/*  gb2312.h - tables for Unicode to GB 2312-1980 (EUC-CN), generated by "backend/tools/gen_eci_mb_h.php"
    from "unicode.org-mappings/EASTASIA/GB/GB2312.TXT"
    (see https://haible.de/bruno/charsets/conversion-tables/GB2312.tar.bz2) */
/*
    libzint - the open source barcode library
    Copyright (C) 2009-2022 Robin Stuart <rstuart114@gmail.com>

    Redistribution and use in source and binary forms, with or without
    modification, are permitted provided that the following conditions
    are met:

    1. Redistributions of source code must retain the above copyright
       notice, this list of conditions and the following disclaimer.
    2. Redistributions in binary form must reproduce the above copyright
       notice, this list of conditions and the following disclaimer in the
       documentation and/or other materials provided with the distribution.
    3. Neither the name of the project nor the names of its contributors
       may be used to endorse or promote products derived from this software
       without specific prior written permission.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
    ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
    IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
    DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
    OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
    HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
    LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
    OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
    SUCH DAMAGE.
 */
/* SPDX-License-Identifier: BSD-3-Clause */

#ifndef Z_GB2312_H
#define Z_GB2312_H

/* Unicode usage bit-flags for URO (U+4E00-U+9FFF) block */
static const unsigned short gb2312_uro_u[1263] = {
    0x7F8B, 0x7F7B, 0x3DB4, 0xEF55, 0xFBA8, 0xF35D, 0x0243, 0x400B,
    0xFB40, 0x8D3E, 0x7BF7, 0x8C2C, 0x6EFF, 0xE3FA, 0x1D3A, 0xA8ED,
    0xE602, 0xCF83, 0x8CF5, 0x3555, 0xE048, 0xFFAB, 0x92B9, 0xD859,
    0xAB18, 0x2892, 0xD7E9, 0x8020, 0xC438, 0xF583, 0xE74A, 0x450A,
    0xB000, 0x9714, 0x7762, 0x5400, 0xD188, 0x1420, 0x1020, 0xC8C0,
    0x2121, 0x0000, 0x13A8, 0x0C04, 0x8000, 0x0440, 0x70C0, 0x0828,
    0x08C0, 0x0004, 0x0002, 0x8000, 0x2B7B, 0x1472, 0x7924, 0x3BFB,
    0x3327, 0x1AE4, 0x9835, 0x38EF, 0x9AD1, 0x2802, 0xA813, 0xBF69,
    0x65CF, 0x2FC6, 0x6B11, 0xAFC9, 0x340F, 0x5053, 0x86A2, 0xA004,
    0x0106, 0xE809, 0x3F0F, 0xC00E, 0x0A88, 0x8145, 0x0010, 0xC601,
    0xA161, 0x26E1, 0x444B, 0xCE00, 0xC7AA, 0xD4EE, 0xCADF, 0x85BB,
    0x3A74, 0xA520, 0x436C, 0x8840, 0x3F06, 0x8BD2, 0xFF79, 0x3BEF,
    0xF75A, 0xE8EF, 0xFBCB, 0x5B36, 0x0D49, 0x1BFD, 0x0154, 0x39EE,
    0xD855, 0x2E75, 0xBFD8, 0xA91A, 0xF3D7, 0xF6BF, 0x67E0, 0xB40C,
    0x82C2, 0x0813, 0xD49D, 0xD08B, 0x065A, 0x1061, 0x74F2, 0x59E0,
    0x8F9F, 0xB312, 0x0080, 0x6AAA, 0x3230, 0xB05E, 0x9D7A, 0x60AC,
    0xD303, 0xC900, 0x3098, 0x8A56, 0x7000, 0x1390, 0x1F14, 0x1842,
    0xC060, 0x0008, 0x8008, 0x1080, 0x0400, 0xEC90, 0x2817, 0xE633,
    0x0758, 0x9000, 0xF708, 0x4E09, 0xF485, 0xFC83, 0xAF53, 0x18C8,
    0x187C, 0x080C, 0x6ADF, 0x0114, 0xC80C, 0xA734, 0xA011, 0x2710,
    0x28C5, 0x4222, 0x0413, 0x0021, 0x3010, 0x4112, 0x1820, 0x4000,
    0x022B, 0xC60C, 0x0300, 0x1000, 0x0022, 0x0022, 0x5810, 0x0249,
    0xA094, 0x9670, 0xEEB0, 0x1792, 0xCB96, 0x05F2, 0x0025, 0x2358,
    0x25DE, 0x42CC, 0xCF38, 0x4A04, 0x0C40, 0x359F, 0x1128, 0x8A00,
    0x13FA, 0x910A, 0x0229, 0x1056, 0x0641, 0x0420, 0x0484, 0x84F0,
    0x0000, 0x0C04, 0x0400, 0x412C, 0x1206, 0x1154, 0x0A4B, 0x0002,
    0x0200, 0x00C0, 0x0000, 0x0094, 0x0001, 0xBFBB, 0x167C, 0x242B,
    0x9BBB, 0x7FA8, 0x0C7F, 0xE379, 0x10F4, 0xE00D, 0x4132, 0x9F01,
    0x8652, 0x3572, 0x10B4, 0xFF12, 0xCF27, 0x4223, 0xC06B, 0x8602,
    0x3106, 0x1FD3, 0x3A0C, 0xA1AA, 0x0812, 0x0204, 0x2572, 0x0801,
    0x40CC, 0x4850, 0x62D0, 0x6010, 0x1C80, 0x2900, 0x9A00, 0x0010,
    0x0004, 0x2200, 0x0000, 0x0080, 0x2020, 0x6800, 0xCBE6, 0x609E,
    0x916E, 0x3F73, 0x60C0, 0x3982, 0x1034, 0x4830, 0x0006, 0xBD5C,
    0x8CD1, 0xD6FB, 0x20E1, 0x43E8, 0x0600, 0x084E, 0x0500, 0xC4D0,
    0x8D1F, 0x89AA, 0xA6E1, 0x1602, 0x0001, 0x21ED, 0x3656, 0x1A8B,
    0x1FB7, 0x13A5, 0x6502, 0x30A0, 0xB278, 0x23C7, 0x6C93, 0xE922,
    0xE47F, 0x3A74, 0x8FE3, 0x9820, 0x280E, 0x2625, 0xBF9C, 0xBF49,
    0x3218, 0xAC54, 0xB949, 0x1916, 0x0C60, 0xB522, 0xFBC1, 0x0659,
    0xE343, 0x8420, 0x08D9, 0x8000, 0x5500, 0x2022, 0x0184, 0x00A1,
    0x4800, 0x2010, 0x1380, 0x4080, 0x0D04, 0x0016, 0x0040, 0x8020,
    0xFD40, 0x8DE7, 0x5436, 0xE098, 0x7B8B, 0x091E, 0xFEC8, 0xD249,
    0x0611, 0x8DEE, 0x1937, 0xBA22, 0x77F4, 0x9FDD, 0xF3EC, 0xF0DA,
    0x4386, 0xEC42, 0x8D3F, 0x2604, 0xFA6C, 0xC021, 0x628E, 0x0CC2,
    0xD785, 0x0145, 0x77AD, 0x5599, 0xE250, 0x4045, 0x260B, 0xA154,
    0x9827, 0x5819, 0x3443, 0xA410, 0x05F2, 0x4114, 0x2280, 0x0700,
    0x00B4, 0x4266, 0x7210, 0x15A1, 0x6025, 0x4185, 0x0054, 0x0000,
    0x0201, 0x0104, 0xC820, 0xCB70, 0x9320, 0x6A62, 0x184C, 0x0095,
    0x1880, 0x9A8B, 0xAAB2, 0x3201, 0xD87A, 0x00C4, 0xF3E5, 0x04C3,
    0xD44D, 0xA238, 0xA1A1, 0x5072, 0x980A, 0x84FC, 0xC152, 0x44D1,
    0x1094, 0x20C2, 0x4180, 0x4210, 0x0000, 0x3A00, 0x0240, 0xD29D,
    0x2F01, 0xA8B1, 0xBD40, 0x2432, 0xD34D, 0xD04B, 0xA723, 0xD0AD,
    0x0A92, 0x75A1, 0xADAC, 0x01E9, 0x801A, 0x771F, 0x9225, 0xA01B,
    0xDFA1, 0x20CA, 0x0602, 0x738C, 0x577F, 0x003B, 0x0BFF, 0x00D0,
    0x806A, 0x0088, 0xA1C4, 0x0029, 0x2A05, 0x0524, 0x4009, 0x1623,
    0x6822, 0x8005, 0x2011, 0xA211, 0x0004, 0x6490, 0x4849, 0x1382,
    0x23D5, 0x1930, 0x2980, 0x0892, 0x5402, 0x8811, 0x2001, 0xA004,
    0x0400, 0x8180, 0x8502, 0x6022, 0x0090, 0x0B01, 0x0022, 0x1202,
    0x4011, 0x0083, 0x1A01, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x009F, 0x4684, 0x12C8, 0x0200, 0x04FC, 0x1A00,
    0x2EDE, 0x0C4C, 0x0402, 0x80B8, 0xA826, 0x0AFC, 0x8C02, 0x2228,
    0xA0E0, 0x8F7B, 0xC7D6, 0x2135, 0x06C7, 0xF8B1, 0x0713, 0x6255,
    0x936E, 0x8A19, 0x6EFA, 0xFB0E, 0x1630, 0x48F9, 0xCD2F, 0x7DEB,
    0x5892, 0x4E84, 0x4CA0, 0x7A2E, 0xEDEA, 0x561E, 0xC649, 0x1190,
    0x5324, 0xE83A, 0xCFDB, 0x8124, 0x18F1, 0x6342, 0x5853, 0x1A8A,
    0x7420, 0x24D3, 0xAA3B, 0x0514, 0x6018, 0x8958, 0x4800, 0xC000,
    0x8268, 0x9101, 0x84A4, 0x2CD6, 0x8886, 0xC4BA, 0x0377, 0x0210,
    0x8244, 0x0038, 0xAE11, 0x404A, 0x28C0, 0x5100, 0x6044, 0x1514,
    0x7310, 0x1000, 0x0082, 0x0248, 0x0205, 0x4006, 0xC003, 0x0000,
    0x0000, 0x0C02, 0x0008, 0x0220, 0x9000, 0x4000, 0xB800, 0xD161,
    0x4621, 0x3274, 0xF800, 0x3B8A, 0x050F, 0x8B00, 0xBBD0, 0x2280,
    0x0600, 0x0769, 0x8040, 0x0043, 0x5420, 0x5000, 0x41D0, 0x250C,
    0x8410, 0x8310, 0x1101, 0x0228, 0x4008, 0x0030, 0x40A1, 0x0200,
    0x0040, 0x2000, 0x1500, 0xABE3, 0x3180, 0xAA44, 0xC2C6, 0xC624,
    0xAC13, 0x8004, 0xB000, 0x03D1, 0x611E, 0x4285, 0xF303, 0x1D9F,
    0x440A, 0x78E8, 0x5E26, 0xC392, 0x2000, 0x0085, 0xB001, 0x4000,
    0x4A90, 0x8842, 0xCA04, 0x0C8D, 0xA705, 0x4203, 0x22A1, 0x0004,
    0x8668, 0x0C01, 0x5564, 0x1079, 0x0002, 0xDEA0, 0x2000, 0x40C1,
    0x488B, 0x5001, 0x0380, 0x0400, 0x0000, 0x5004, 0xC05D, 0x80D0,
    0xA010, 0x970A, 0xBB20, 0x4DAF, 0xD921, 0x1E10, 0x0460, 0x8314,
    0x8848, 0xA6D6, 0xD83B, 0x733F, 0x27BC, 0x4974, 0x0DDC, 0x9213,
    0x142B, 0x8BA1, 0x2E75, 0xD139, 0x3009, 0x5050, 0x8808, 0x6900,
    0x49D4, 0x024A, 0x4010, 0x8016, 0xE564, 0x89D7, 0xC020, 0x5316,
    0x2B92, 0x8600, 0xA345, 0x15E0, 0x008B, 0x0C03, 0x196E, 0xE200,
    0x7031, 0x8006, 0x16A5, 0xA829, 0x2000, 0x1880, 0x7AAC, 0xE148,
    0x3207, 0xB5D6, 0x32E8, 0x5F91, 0x50A1, 0x20E5, 0x7C00, 0x1080,
    0x7280, 0x9D8A, 0x00AA, 0x421F, 0x0E22, 0x0231, 0x1100, 0x0494,
    0x0022, 0x4008, 0x0010, 0x5C10, 0x0343, 0xFCC8, 0xA1A5, 0x0580,
    0x8433, 0x0400, 0x0080, 0x6E08, 0x2A4B, 0x8126, 0xAAD8, 0x2901,
    0x684D, 0x4490, 0x0009, 0xBA88, 0x0040, 0x0082, 0x0000, 0x87D1,
    0x215B, 0xB1E6, 0x3161, 0x8008, 0x0800, 0xC240, 0xA069, 0xA600,
    0x8D58, 0x4A32, 0x5D71, 0x550A, 0x9AA0, 0x2D57, 0x4005, 0x4AA6,
    0x2021, 0x30B1, 0x3FC6, 0x0112, 0x10C2, 0x260A, 0x4462, 0x5082,
    0x9880, 0x8040, 0x04C0, 0x8100, 0x2003, 0x0000, 0x0000, 0x3818,
    0x0200, 0xF1A6, 0x4434, 0x720E, 0x35A2, 0x92E0, 0x8101, 0x0900,
    0x0400, 0x0000, 0x8885, 0x0000, 0x0000, 0x0000, 0x4000, 0x0080,
    0x0000, 0x0000, 0x4040, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0800, 0x0082, 0x0000, 0x0000, 0x0000,
    0x0004, 0x8800, 0xBFFF, 0xE7EF, 0xFFFF, 0xFFBF, 0xEFEF, 0xFDFF,
    0xFBFF, 0xBFFE, 0xFFFF, 0x057F, 0x0034, 0x85B3, 0x4706, 0x4216,
    0x5402, 0xE410, 0x8092, 0xB305, 0x5422, 0x8130, 0x4263, 0x180B,
    0x387B, 0x13F5, 0x07E5, 0xA9EA, 0x3C4C, 0x0514, 0x0600, 0x8002,
    0x1AD9, 0xBD48, 0xEE37, 0xF496, 0x705F, 0x7EC0, 0xBFB2, 0x355F,
    0xE644, 0x455F, 0x9000, 0x4146, 0x1D40, 0x063B, 0x62A1, 0xFE13,
    0x8505, 0x3902, 0x0548, 0x0C08, 0x144F, 0x0000, 0x3488, 0x5818,
    0x3077, 0xD815, 0xBD0E, 0x4BFB, 0x8A90, 0x8500, 0xC100, 0xE61D,
    0xED14, 0xB386, 0xFF72, 0x639B, 0xFD92, 0xD9BE, 0x887B, 0x0A92,
    0xD3FE, 0x1CB2, 0xB980, 0x177A, 0x82C9, 0xDC17, 0xFFFB, 0x3980,
    0x4260, 0x590C, 0x0F01, 0x37DF, 0x94A3, 0xB150, 0x0623, 0x2307,
    0xF85A, 0x3102, 0x01F0, 0x3102, 0x0040, 0x1E82, 0x3A0A, 0x056A,
    0x5B84, 0x1280, 0x8002, 0xA714, 0x2612, 0xA04B, 0x1069, 0x9001,
    0x1000, 0x848A, 0x1802, 0x3F80, 0x0708, 0x4240, 0x0110, 0x4E14,
    0x80B0, 0x1800, 0xC510, 0x0281, 0x8202, 0x1029, 0x0210, 0x8800,
    0x0020, 0x0042, 0x0280, 0x1100, 0xE000, 0x4413, 0x5804, 0xFE02,
    0x3C07, 0x3028, 0x9798, 0x0473, 0xCED1, 0xCB13, 0x6210, 0x431F,
    0x278D, 0x55AC, 0x422E, 0xC892, 0x5380, 0x0288, 0x4039, 0x7851,
    0x292C, 0x8088, 0xB900, 0x2428, 0x0C41, 0x080E, 0x4421, 0x4200,
    0x0408, 0x0868, 0x0006, 0x1204, 0x3031, 0x0290, 0x5B3E, 0xE085,
    0x2936, 0x1044, 0x2814, 0x1082, 0x4266, 0x8334, 0x013C, 0x531B,
    0x0404, 0x0E0D, 0x0C22, 0x0051, 0x0012, 0xC000, 0x0040, 0x8800,
    0x004A, 0x0000, 0x0000, 0x0000, 0xDFF6, 0x5447, 0x8868, 0x0008,
    0x0081, 0x0000, 0x0000, 0x4000, 0x0100, 0x0000, 0x0000, 0x0200,
    0x0600, 0x0008, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0080, 0x0000, 0x0040, 0x0000, 0x0000, 0x0000, 0x1040, 0x0000,
    0x0000, 0x0000, 0xEFFF, 0xF7FD, 0xFF7F, 0xFFFE, 0xFBFF, 0xFFFF,
    0xFDFF, 0xBFFF, 0xFFFF, 0x00FF, 0x12C2, 0x0420, 0x0C06, 0x0708,
    0x1624, 0x0110, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0xE000, 0xFFFE, 0xFFFF, 0xFFFF, 0x7F79, 0x28DF, 0x00F9,
    0x0C32, 0x8012, 0x0008, 0xD53A, 0xD858, 0xECC2, 0x9D18, 0x2FA8,
    0x9620, 0xE010, 0xD60C, 0x2622, 0x0F97, 0x0206, 0xB240, 0x9055,
    0x80A2, 0x5011, 0x9800, 0x0404, 0x4000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFBC0, 0xFFFF,
    0xEFFE, 0xDFFB, 0x0B08, 0x6243, 0x41B6, 0xFB3B, 0x6F74, 0x2389,
    0xAE7F, 0xECD7, 0xE047, 0x5960, 0xA096, 0x098F, 0x612C, 0xA030,
    0x090D, 0x2AAA, 0xD44E, 0x4F7B, 0xC4B2, 0x388B, 0xA9C6, 0x6110,
    0x0014, 0x4200, 0x800C, 0x0202, 0xFE48, 0x6485, 0xD63E, 0xE3F7,
    0x3AA0, 0x0C07, 0xE40C, 0x0430, 0xF680, 0x1002, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0010,
    0x4000, 0x0000, 0x4000, 0x0000, 0x0100, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x4000, 0x0000, 0x0000, 0x0400, 0x0000,
    0x8000, 0x0000, 0x0000, 0x0000, 0x0400, 0x0040, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x4000, 0x0000, 0x0000, 0x0800, 0x0000,
    0xFFE0, 0xFEBD, 0xFFFF, 0xFFFF, 0x7F7F, 0xFBE7, 0xFFBF, 0xF7FF,
    0xFFFF, 0xEFFF, 0xFF7E, 0xDFF7, 0xF6F7, 0xFBDF, 0xBFFE, 0x804F,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xEF00, 0x7FFF,
    0xFF7F, 0xB6F7, 0x4406, 0xB87E, 0x3BF5, 0x8831, 0x1796, 0x00F4,
    0xA960, 0x1391, 0x0080, 0x7249, 0xF2F3, 0x0024, 0x8701, 0x42C8,
    0xE3D3, 0x5048, 0x2400, 0x4305, 0x0000, 0x4A4C, 0x0227, 0x1058,
    0x2820, 0x0116, 0xA809, 0x0014, 0x0000, 0x0000, 0x3EC0, 0x0068,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xFFE0,
    0xB7FF, 0xFDDB, 0x00F7, 0x0000, 0x4000, 0xC72E, 0x0180, 0x0000,
    0x2000, 0x0001, 0x4000, 0x0000, 0x0000, 0x0030, 0xFFA8, 0xB4F7,
    0xADF3, 0x03FF, 0x0120, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0xF000, 0xFFFB,
    0x9DF7, 0xFDCF, 0x01BF, 0x15C3, 0x1827, 0x810A, 0xA842, 0x0A00,
    0x8108, 0x8008, 0x8008, 0x1804, 0xA3BE, 0x0012, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000,
    0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x9000,
    0x69E6, 0xDC37, 0x6BFF, 0x3DFF, 0xFCF8, 0xF3F9, 0x0004,
};

/* Multibyte indexes for URO (U+4E00-U+9FFF) block */
static const unsigned short gb2312_uro_mb_ind[1263] = {
      584,   595,   608,   617,   628,   638,   649,   653,
      657,   665,   674,   687,   693,   706,   717,   725,
      734,   740,   749,   758,   766,   771,   784,   792,
      800,   807,   812,   823,   825,   831,   840,   849,
      854,   857,   864,   873,   876,   882,   885,   887,
      892,   896,   896,   902,   905,   906,   908,   913,
      916,   919,   920,   921,   922,   932,   938,   945,
      957,   965,   972,   979,   989,   997,  1000,  1006,
     1017,  1027,  1036,  1043,  1053,  1060,  1066,  1072,
     1075,  1078,  1084,  1094,  1099,  1103,  1108,  1109,
     1114,  1120,  1127,  1133,  1138,  1147,  1157,  1168,
     1177,  1185,  1190,  1197,  1200,  1208,  1216,  1229,
     1241,  1252,  1263,  1275,  1284,  1290,  1301,  1305,
     1315,  1323,  1332,  1343,  1350,  1362,  1375,  1383,
     1389,  1394,  1398,  1407,  1414,  1420,  1424,  1433,
     1440,  1451,  1458,  1459,  1467,  1472,  1480,  1490,
     1496,  1503,  1507,  1512,  1519,  1522,  1527,  1534,
     1538,  1542,  1543,  1545,  1547,  1548,  1555,  1561,
     1570,  1576,  1578,  1586,  1592,  1600,  1609,  1619,
     1624,  1631,  1634,  1645,  1648,  1653,  1661,  1665,
     1670,  1676,  1680,  1684,  1686,  1689,  1693,  1696,
     1697,  1702,  1708,  1710,  1711,  1713,  1715,  1719,
     1723,  1728,  1735,  1744,  1751,  1760,  1767,  1770,
     1776,  1785,  1791,  1800,  1804,  1807,  1817,  1821,
     1824,  1833,  1838,  1842,  1847,  1851,  1853,  1856,
     1862,  1862,  1865,  1866,  1871,  1875,  1880,  1886,
     1887,  1888,  1890,  1890,  1893,  1894,  1907,  1915,
     1921,  1932,  1942,  1951,  1961,  1967,  1973,  1978,
     1985,  1991,  1999,  2004,  2014,  2024,  2029,  2036,
     2040,  2045,  2055,  2061,  2068,  2071,  2073,  2080,
     2082,  2087,  2091,  2097,  2100,  2104,  2107,  2111,
     2112,  2113,  2115,  2115,  2116,  2118,  2121,  2131,
     2138,  2146,  2157,  2161,  2167,  2171,  2175,  2177,
     2187,  2194,  2206,  2211,  2218,  2220,  2225,  2227,
     2233,  2242,  2249,  2257,  2261,  2262,  2270,  2278,
     2285,  2296,  2303,  2308,  2312,  2320,  2328,  2336,
     2343,  2354,  2362,  2372,  2376,  2381,  2387,  2398,
     2408,  2413,  2420,  2428,  2434,  2438,  2445,  2455,
     2461,  2469,  2472,  2478,  2479,  2483,  2486,  2489,
     2492,  2494,  2496,  2500,  2502,  2506,  2509,  2510,
     2512,  2520,  2530,  2537,  2543,  2553,  2559,  2569,
     2576,  2580,  2590,  2598,  2605,  2616,  2628,  2639,
     2648,  2654,  2661,  2671,  2675,  2685,  2689,  2696,
     2701,  2710,  2714,  2725,  2733,  2739,  2743,  2749,
     2755,  2762,  2768,  2774,  2778,  2785,  2789,  2792,
     2795,  2799,  2805,  2810,  2816,  2821,  2826,  2829,
     2829,  2831,  2833,  2837,  2845,  2850,  2857,  2862,
     2866,  2869,  2877,  2885,  2889,  2898,  2901,  2912,
     2917,  2925,  2931,  2937,  2943,  2948,  2956,  2962,
     2968,  2972,  2976,  2979,  2982,  2982,  2986,  2988,
     2997,  3003,  3010,  3017,  3022,  3031,  3038,  3046,
     3054,  3059,  3067,  3076,  3082,  3086,  3097,  3103,
     3109,  3119,  3124,  3127,  3135,  3147,  3152,  3163,
     3166,  3171,  3173,  3179,  3182,  3187,  3191,  3194,
     3200,  3205,  3208,  3211,  3216,  3217,  3222,  3227,
     3232,  3240,  3245,  3249,  3253,  3257,  3261,  3263,
     3266,  3267,  3270,  3274,  3278,  3280,  3284,  3286,
     3289,  3292,  3295,  3299,  3299,  3299,  3299,  3299,
     3299,  3299,  3299,  3305,  3310,  3315,  3316,  3323,
     3326,  3336,  3341,  3343,  3348,  3354,  3362,  3366,
     3370,  3375,  3386,  3396,  3402,  3409,  3418,  3424,
     3431,  3440,  3446,  3457,  3467,  3472,  3480,  3490,
     3502,  3508,  3514,  3519,  3528,  3539,  3547,  3554,
     3558,  3564,  3572,  3584,  3588,  3595,  3601,  3608,
     3614,  3619,  3626,  3635,  3639,  3643,  3649,  3651,
     3653,  3658,  3662,  3667,  3675,  3680,  3688,  3696,
     3698,  3702,  3705,  3712,  3716,  3720,  3723,  3727,
     3732,  3738,  3739,  3741,  3744,  3747,  3750,  3754,
     3754,  3754,  3757,  3758,  3760,  3762,  3763,  3767,
     3774,  3779,  3786,  3791,  3799,  3805,  3809,  3818,
     3821,  3823,  3830,  3832,  3835,  3839,  3841,  3846,
     3851,  3854,  3858,  3861,  3864,  3866,  3868,  3872,
     3873,  3874,  3875,  3878,  3888,  3892,  3898,  3905,
     3911,  3918,  3920,  3923,  3929,  3936,  3941,  3949,
     3959,  3963,  3971,  3979,  3986,  3987,  3990,  3994,
     3995,  4000,  4004,  4009,  4015,  4022,  4026,  4031,
     4032,  4038,  4041,  4048,  4054,  4055,  4063,  4064,
     4068,  4074,  4077,  4080,  4081,  4081,  4084,  4091,
     4095,  4098,  4105,  4112,  4122,  4129,  4134,  4137,
     4142,  4146,  4155,  4164,  4175,  4184,  4191,  4199,
     4205,  4211,  4218,  4227,  4235,  4239,  4243,  4246,
     4250,  4257,  4261,  4263,  4267,  4275,  4284,  4287,
     4294,  4301,  4304,  4311,  4317,  4321,  4325,  4333,
     4337,  4343,  4346,  4353,  4359,  4360,  4363,  4372,
     4378,  4384,  4394,  4401,  4410,  4415,  4421,  4426,
     4428,  4433,  4441,  4445,  4452,  4457,  4461,  4463,
     4467,  4469,  4471,  4472,  4477,  4482,  4491,  4498,
     4501,  4507,  4508,  4509,  4515,  4522,  4527,  4535,
     4539,  4546,  4550,  4552,  4559,  4560,  4562,  4562,
     4570,  4577,  4586,  4592,  4594,  4595,  4599,  4605,
     4609,  4616,  4622,  4631,  4637,  4643,  4652,  4655,
     4662,  4665,  4671,  4681,  4684,  4688,  4693,  4698,
     4702,  4706,  4708,  4711,  4713,  4716,  4716,  4716,
     4721,  4722,  4731,  4736,  4743,  4750,  4756,  4759,
     4761,  4762,  4762,  4767,  4767,  4767,  4767,  4768,
     4769,  4769,  4769,  4771,  4771,  4771,  4771,  4771,
     4771,  4771,  4771,  4771,  4772,  4774,  4774,  4774,
     4774,  4775,  4777,  4792,  4805,  4821,  4836,  4850,
     4865,  4880,  4894,  4910,  4919,  4922,  4930,  4936,
     4941,  4945,  4950,  4954,  4961,  4966,  4970,  4976,
     4981,  4990,  4999,  5007,  5016,  5023,  5027,  5029,
     5031,  5039,  5047,  5058,  5067,  5076,  5084,  5095,
     5105,  5112,  5121,  5123,  5128,  5133,  5140,  5146,
     5156,  5161,  5166,  5170,  5173,  5180,  5180,  5185,
     5190,  5198,  5205,  5214,  5225,  5230,  5233,  5236,
     5245,  5253,  5261,  5273,  5282,  5292,  5303,  5311,
     5316,  5328,  5335,  5341,  5350,  5356,  5365,  5380,
     5385,  5389,  5395,  5400,  5412,  5419,  5425,  5430,
     5436,  5445,  5449,  5454,  5458,  5459,  5465,  5471,
     5477,  5484,  5487,  5489,  5496,  5501,  5507,  5512,
     5515,  5516,  5521,  5524,  5531,  5535,  5538,  5540,
     5546,  5550,  5552,  5557,  5560,  5563,  5567,  5569,
     5571,  5572,  5574,  5576,  5578,  5581,  5586,  5590,
     5598,  5605,  5609,  5617,  5623,  5632,  5640,  5644,
     5652,  5660,  5668,  5674,  5680,  5685,  5688,  5693,
     5700,  5706,  5709,  5714,  5718,  5722,  5726,  5730,
     5732,  5734,  5738,  5740,  5743,  5748,  5751,  5761,
     5767,  5774,  5777,  5781,  5784,  5790,  5796,  5801,
     5809,  5811,  5817,  5821,  5824,  5826,  5828,  5829,
     5831,  5834,  5834,  5834,  5834,  5847,  5854,  5859,
     5860,  5862,  5862,  5862,  5863,  5864,  5864,  5864,
     5865,  5867,  5868,  5868,  5868,  5868,  5868,  5868,
     5868,  5869,  5869,  5870,  5870,  5870,  5870,  5872,
     5872,  5872,  5872,  5887,  5901,  5916,  5931,  5946,
     5962,  5977,  5992,  6008,  6016,  6021,  6023,  6027,
     6031,  6036,  6038,  6038,  6038,  6038,  6038,  6038,
     6038,  6038,  6041,  6056,  6072,  6088,  6100,  6109,
     6115,  6120,  6123,  6124,  6133,  6140,  6148,  6155,
     6163,  6168,  6172,  6179,  6184,  6193,  6196,  6201,
     6207,  6211,  6215,  6218,  6220,  6221,  6221,  6221,
     6221,  6221,  6221,  6221,  6221,  6221,  6221,  6230,
     6246,  6260,  6274,  6278,  6284,  6291,  6303,  6313,
     6319,  6331,  6342,  6349,  6355,  6361,  6368,  6374,
     6378,  6383,  6390,  6398,  6409,  6416,  6423,  6431,
     6435,  6437,  6439,  6442,  6444,  6453,  6459,  6469,
     6481,  6487,  6492,  6498,  6501,  6508,  6510,  6510,
     6510,  6510,  6510,  6510,  6510,  6510,  6510,  6510,
     6511,  6512,  6512,  6513,  6513,  6514,  6514,  6514,
     6514,  6514,  6514,  6514,  6515,  6515,  6515,  6516,
     6516,  6517,  6517,  6517,  6517,  6518,  6519,  6519,
     6519,  6519,  6519,  6519,  6520,  6520,  6520,  6521,
     6521,  6532,  6545,  6561,  6577,  6591,  6604,  6619,
     6634,  6650,  6665,  6679,  6693,  6706,  6720,  6734,
     6740,  6740,  6740,  6740,  6740,  6740,  6740,  6747,
     6762,  6777,  6789,  6793,  6803,  6814,  6819,  6827,
     6832,  6838,  6844,  6845,  6852,  6863,  6865,  6870,
     6875,  6885,  6889,  6891,  6896,  6896,  6902,  6907,
     6911,  6914,  6918,  6923,  6925,  6925,  6925,  6932,
     6935,  6935,  6935,  6935,  6935,  6935,  6935,  6935,
     6946,  6960,  6973,  6980,  6980,  6981,  6990,  6992,
     6992,  6993,  6994,  6995,  6995,  6995,  6997,  7008,
     7019,  7030,  7040,  7042,  7042,  7042,  7042,  7042,
     7042,  7042,  7042,  7042,  7042,  7042,  7042,  7046,
     7061,  7073,  7086,  7094,  7101,  7107,  7111,  7116,
     7118,  7121,  7123,  7125,  7128,  7138,  7140,  7140,
     7140,  7140,  7140,  7140,  7140,  7140,  7140,  7140,
     7140,  7140,  7140,  7140,  7140,  7140,  7140,  7140,
     7142,  7151,  7161,  7174,  7187,  7198,  7210,
};

/* Unicode codepoints sorted */
static const unsigned short gb2312_u[818] = {
    0x00A4, 0x00A7, 0x00A8, 0x00B0, 0x00B1, 0x00D7, 0x00E0, 0x00E1,
    0x00E8, 0x00E9, 0x00EA, 0x00EC, 0x00ED, 0x00F2, 0x00F3, 0x00F7,
    0x00F9, 0x00FA, 0x00FC, 0x0101, 0x0113, 0x011B, 0x012B, 0x014D,
    0x016B, 0x01CE, 0x01D0, 0x01D2, 0x01D4, 0x01D6, 0x01D8, 0x01DA,
    0x01DC, 0x02C7, 0x02C9, 0x0391, 0x0392, 0x0393, 0x0394, 0x0395,
    0x0396, 0x0397, 0x0398, 0x0399, 0x039A, 0x039B, 0x039C, 0x039D,
    0x039E, 0x039F, 0x03A0, 0x03A1, 0x03A3, 0x03A4, 0x03A5, 0x03A6,
    0x03A7, 0x03A8, 0x03A9, 0x03B1, 0x03B2, 0x03B3, 0x03B4, 0x03B5,
    0x03B6, 0x03B7, 0x03B8, 0x03B9, 0x03BA, 0x03BB, 0x03BC, 0x03BD,
    0x03BE, 0x03BF, 0x03C0, 0x03C1, 0x03C3, 0x03C4, 0x03C5, 0x03C6,
    0x03C7, 0x03C8, 0x03C9, 0x0401, 0x0410, 0x0411, 0x0412, 0x0413,
    0x0414, 0x0415, 0x0416, 0x0417, 0x0418, 0x0419, 0x041A, 0x041B,
    0x041C, 0x041D, 0x041E, 0x041F, 0x0420, 0x0421, 0x0422, 0x0423,
    0x0424, 0x0425, 0x0426, 0x0427, 0x0428, 0x0429, 0x042A, 0x042B,
    0x042C, 0x042D, 0x042E, 0x042F, 0x0430, 0x0431, 0x0432, 0x0433,
    0x0434, 0x0435, 0x0436, 0x0437, 0x0438, 0x0439, 0x043A, 0x043B,
    0x043C, 0x043D, 0x043E, 0x043F, 0x0440, 0x0441, 0x0442, 0x0443,
    0x0444, 0x0445, 0x0446, 0x0447, 0x0448, 0x0449, 0x044A, 0x044B,
    0x044C, 0x044D, 0x044E, 0x044F, 0x0451, 0x2015, 0x2016, 0x2018,
    0x2019, 0x201C, 0x201D, 0x2026, 0x2030, 0x2032, 0x2033, 0x203B,
    0x2103, 0x2116, 0x2160, 0x2161, 0x2162, 0x2163, 0x2164, 0x2165,
    0x2166, 0x2167, 0x2168, 0x2169, 0x216A, 0x216B, 0x2190, 0x2191,
    0x2192, 0x2193, 0x2208, 0x220F, 0x2211, 0x221A, 0x221D, 0x221E,
    0x2220, 0x2225, 0x2227, 0x2228, 0x2229, 0x222A, 0x222B, 0x222E,
    0x2234, 0x2235, 0x2236, 0x2237, 0x223D, 0x2248, 0x224C, 0x2260,
    0x2261, 0x2264, 0x2265, 0x226E, 0x226F, 0x2299, 0x22A5, 0x2312,
    0x2460, 0x2461, 0x2462, 0x2463, 0x2464, 0x2465, 0x2466, 0x2467,
    0x2468, 0x2469, 0x2474, 0x2475, 0x2476, 0x2477, 0x2478, 0x2479,
    0x247A, 0x247B, 0x247C, 0x247D, 0x247E, 0x247F, 0x2480, 0x2481,
    0x2482, 0x2483, 0x2484, 0x2485, 0x2486, 0x2487, 0x2488, 0x2489,
    0x248A, 0x248B, 0x248C, 0x248D, 0x248E, 0x248F, 0x2490, 0x2491,
    0x2492, 0x2493, 0x2494, 0x2495, 0x2496, 0x2497, 0x2498, 0x2499,
    0x249A, 0x249B, 0x2500, 0x2501, 0x2502, 0x2503, 0x2504, 0x2505,
    0x2506, 0x2507, 0x2508, 0x2509, 0x250A, 0x250B, 0x250C, 0x250D,
    0x250E, 0x250F, 0x2510, 0x2511, 0x2512, 0x2513, 0x2514, 0x2515,
    0x2516, 0x2517, 0x2518, 0x2519, 0x251A, 0x251B, 0x251C, 0x251D,
    0x251E, 0x251F, 0x2520, 0x2521, 0x2522, 0x2523, 0x2524, 0x2525,
    0x2526, 0x2527, 0x2528, 0x2529, 0x252A, 0x252B, 0x252C, 0x252D,
    0x252E, 0x252F, 0x2530, 0x2531, 0x2532, 0x2533, 0x2534, 0x2535,
    0x2536, 0x2537, 0x2538, 0x2539, 0x253A, 0x253B, 0x253C, 0x253D,
    0x253E, 0x253F, 0x2540, 0x2541, 0x2542, 0x2543, 0x2544, 0x2545,
    0x2546, 0x2547, 0x2548, 0x2549, 0x254A, 0x254B, 0x25A0, 0x25A1,
    0x25B2, 0x25B3, 0x25C6, 0x25C7, 0x25CB, 0x25CE, 0x25CF, 0x2605,
    0x2606, 0x2640, 0x2642, 0x3000, 0x3001, 0x3002, 0x3003, 0x3005,
    0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D, 0x300E, 0x300F,
    0x3010, 0x3011, 0x3013, 0x3014, 0x3015, 0x3016, 0x3017, 0x3041,
    0x3042, 0x3043, 0x3044, 0x3045, 0x3046, 0x3047, 0x3048, 0x3049,
    0x304A, 0x304B, 0x304C, 0x304D, 0x304E, 0x304F, 0x3050, 0x3051,
    0x3052, 0x3053, 0x3054, 0x3055, 0x3056, 0x3057, 0x3058, 0x3059,
    0x305A, 0x305B, 0x305C, 0x305D, 0x305E, 0x305F, 0x3060, 0x3061,
    0x3062, 0x3063, 0x3064, 0x3065, 0x3066, 0x3067, 0x3068, 0x3069,
    0x306A, 0x306B, 0x306C, 0x306D, 0x306E, 0x306F, 0x3070, 0x3071,
    0x3072, 0x3073, 0x3074, 0x3075, 0x3076, 0x3077, 0x3078, 0x3079,
    0x307A, 0x307B, 0x307C, 0x307D, 0x307E, 0x307F, 0x3080, 0x3081,
    0x3082, 0x3083, 0x3084, 0x3085, 0x3086, 0x3087, 0x3088, 0x3089,
    0x308A, 0x308B, 0x308C, 0x308D, 0x308E, 0x308F, 0x3090, 0x3091,
    0x3092, 0x3093, 0x30A1, 0x30A2, 0x30A3, 0x30A4, 0x30A5, 0x30A6,
    0x30A7, 0x30A8, 0x30A9, 0x30AA, 0x30AB, 0x30AC, 0x30AD, 0x30AE,
    0x30AF, 0x30B0, 0x30B1, 0x30B2, 0x30B3, 0x30B4, 0x30B5, 0x30B6,
    0x30B7, 0x30B8, 0x30B9, 0x30BA, 0x30BB, 0x30BC, 0x30BD, 0x30BE,
    0x30BF, 0x30C0, 0x30C1, 0x30C2, 0x30C3, 0x30C4, 0x30C5, 0x30C6,
    0x30C7, 0x30C8, 0x30C9, 0x30CA, 0x30CB, 0x30CC, 0x30CD, 0x30CE,
    0x30CF, 0x30D0, 0x30D1, 0x30D2, 0x30D3, 0x30D4, 0x30D5, 0x30D6,
    0x30D7, 0x30D8, 0x30D9, 0x30DA, 0x30DB, 0x30DC, 0x30DD, 0x30DE,
    0x30DF, 0x30E0, 0x30E1, 0x30E2, 0x30E3, 0x30E4, 0x30E5, 0x30E6,
    0x30E7, 0x30E8, 0x30E9, 0x30EA, 0x30EB, 0x30EC, 0x30ED, 0x30EE,
    0x30EF, 0x30F0, 0x30F1, 0x30F2, 0x30F3, 0x30F4, 0x30F5, 0x30F6,
    0x30FB, 0x3105, 0x3106, 0x3107, 0x3108, 0x3109, 0x310A, 0x310B,
    0x310C, 0x310D, 0x310E, 0x310F, 0x3110, 0x3111, 0x3112, 0x3113,
    0x3114, 0x3115, 0x3116, 0x3117, 0x3118, 0x3119, 0x311A, 0x311B,
    0x311C, 0x311D, 0x311E, 0x311F, 0x3120, 0x3121, 0x3122, 0x3123,
    0x3124, 0x3125, 0x3126, 0x3127, 0x3128, 0x3129, 0x3220, 0x3221,
    0x3222, 0x3223, 0x3224, 0x3225, 0x3226, 0x3227, 0x3228, 0x3229,
    0x9E1F, 0x9E20, 0x9E21, 0x9E22, 0x9E23, 0x9E25, 0x9E26, 0x9E28,
    0x9E29, 0x9E2A, 0x9E2B, 0x9E2C, 0x9E2D, 0x9E2F, 0x9E31, 0x9E32,
    0x9E33, 0x9E35, 0x9E36, 0x9E37, 0x9E38, 0x9E39, 0x9E3A, 0x9E3D,
    0x9E3E, 0x9E3F, 0x9E41, 0x9E42, 0x9E43, 0x9E44, 0x9E45, 0x9E46,
    0x9E47, 0x9E48, 0x9E49, 0x9E4A, 0x9E4B, 0x9E4C, 0x9E4E, 0x9E4F,
    0x9E51, 0x9E55, 0x9E57, 0x9E58, 0x9E5A, 0x9E5B, 0x9E5C, 0x9E5E,
    0x9E63, 0x9E64, 0x9E66, 0x9E67, 0x9E68, 0x9E69, 0x9E6A, 0x9E6B,
    0x9E6C, 0x9E6D, 0x9E70, 0x9E71, 0x9E73, 0x9E7E, 0x9E7F, 0x9E82,
    0x9E87, 0x9E88, 0x9E8B, 0x9E92, 0x9E93, 0x9E9D, 0x9E9F, 0x9EA6,
    0x9EB4, 0x9EB8, 0x9EBB, 0x9EBD, 0x9EBE, 0x9EC4, 0x9EC9, 0x9ECD,
    0x9ECE, 0x9ECF, 0x9ED1, 0x9ED4, 0x9ED8, 0x9EDB, 0x9EDC, 0x9EDD,
    0x9EDF, 0x9EE0, 0x9EE2, 0x9EE5, 0x9EE7, 0x9EE9, 0x9EEA, 0x9EEF,
    0x9EF9, 0x9EFB, 0x9EFC, 0x9EFE, 0x9F0B, 0x9F0D, 0x9F0E, 0x9F10,
    0x9F13, 0x9F17, 0x9F19, 0x9F20, 0x9F22, 0x9F2C, 0x9F2F, 0x9F37,
    0x9F39, 0x9F3B, 0x9F3D, 0x9F3E, 0x9F44, 0x9F50, 0x9F51, 0x9F7F,
    0x9F80, 0x9F83, 0x9F84, 0x9F85, 0x9F86, 0x9F87, 0x9F88, 0x9F89,
    0x9F8A, 0x9F8B, 0x9F8C, 0x9F99, 0x9F9A, 0x9F9B, 0x9F9F, 0x9FA0,
    0xFF01, 0xFF02, 0xFF03, 0xFF04, 0xFF05, 0xFF06, 0xFF07, 0xFF08,
    0xFF09, 0xFF0A, 0xFF0B, 0xFF0C, 0xFF0D, 0xFF0E, 0xFF0F, 0xFF10,
    0xFF11, 0xFF12, 0xFF13, 0xFF14, 0xFF15, 0xFF16, 0xFF17, 0xFF18,
    0xFF19, 0xFF1A, 0xFF1B, 0xFF1C, 0xFF1D, 0xFF1E, 0xFF1F, 0xFF20,
    0xFF21, 0xFF22, 0xFF23, 0xFF24, 0xFF25, 0xFF26, 0xFF27, 0xFF28,
    0xFF29, 0xFF2A, 0xFF2B, 0xFF2C, 0xFF2D, 0xFF2E, 0xFF2F, 0xFF30,
    0xFF31, 0xFF32, 0xFF33, 0xFF34, 0xFF35, 0xFF36, 0xFF37, 0xFF38,
    0xFF39, 0xFF3A, 0xFF3B, 0xFF3C, 0xFF3D, 0xFF3E, 0xFF3F, 0xFF40,
    0xFF41, 0xFF42, 0xFF43, 0xFF44, 0xFF45, 0xFF46, 0xFF47, 0xFF48,
    0xFF49, 0xFF4A, 0xFF4B, 0xFF4C, 0xFF4D, 0xFF4E, 0xFF4F, 0xFF50,
    0xFF51, 0xFF52, 0xFF53, 0xFF54, 0xFF55, 0xFF56, 0xFF57, 0xFF58,
    0xFF59, 0xFF5A, 0xFF5B, 0xFF5C, 0xFF5D, 0xFF5E, 0xFFE0, 0xFFE1,
    0xFFE3, 0xFFE5,
};

/* Multibyte values sorted in Unicode order */
static const unsigned short gb2312_mb[7445] = {
    0xA1E8, 0xA1EC, 0xA1A7, 0xA1E3, 0xA1C0, 0xA1C1, 0xA8A4, 0xA8A2,
    0xA8A8, 0xA8A6, 0xA8BA, 0xA8AC, 0xA8AA, 0xA8B0, 0xA8AE, 0xA1C2,
    0xA8B4, 0xA8B2, 0xA8B9, 0xA8A1, 0xA8A5, 0xA8A7, 0xA8A9, 0xA8AD,
    0xA8B1, 0xA8A3, 0xA8AB, 0xA8AF, 0xA8B3, 0xA8B5, 0xA8B6, 0xA8B7,
    0xA8B8, 0xA1A6, 0xA1A5, 0xA6A1, 0xA6A2, 0xA6A3, 0xA6A4, 0xA6A5,
    0xA6A6, 0xA6A7, 0xA6A8, 0xA6A9, 0xA6AA, 0xA6AB, 0xA6AC, 0xA6AD,
    0xA6AE, 0xA6AF, 0xA6B0, 0xA6B1, 0xA6B2, 0xA6B3, 0xA6B4, 0xA6B5,
    0xA6B6, 0xA6B7, 0xA6B8, 0xA6C1, 0xA6C2, 0xA6C3, 0xA6C4, 0xA6C5,
    0xA6C6, 0xA6C7, 0xA6C8, 0xA6C9, 0xA6CA, 0xA6CB, 0xA6CC, 0xA6CD,
    0xA6CE, 0xA6CF, 0xA6D0, 0xA6D1, 0xA6D2, 0xA6D3, 0xA6D4, 0xA6D5,
    0xA6D6, 0xA6D7, 0xA6D8, 0xA7A7, 0xA7A1, 0xA7A2, 0xA7A3, 0xA7A4,
    0xA7A5, 0xA7A6, 0xA7A8, 0xA7A9, 0xA7AA, 0xA7AB, 0xA7AC, 0xA7AD,
    0xA7AE, 0xA7AF, 0xA7B0, 0xA7B1, 0xA7B2, 0xA7B3, 0xA7B4, 0xA7B5,
    0xA7B6, 0xA7B7, 0xA7B8, 0xA7B9, 0xA7BA, 0xA7BB, 0xA7BC, 0xA7BD,
    0xA7BE, 0xA7BF, 0xA7C0, 0xA7C1, 0xA7D1, 0xA7D2, 0xA7D3, 0xA7D4,
    0xA7D5, 0xA7D6, 0xA7D8, 0xA7D9, 0xA7DA, 0xA7DB, 0xA7DC, 0xA7DD,
    0xA7DE, 0xA7DF, 0xA7E0, 0xA7E1, 0xA7E2, 0xA7E3, 0xA7E4, 0xA7E5,
    0xA7E6, 0xA7E7, 0xA7E8, 0xA7E9, 0xA7EA, 0xA7EB, 0xA7EC, 0xA7ED,
    0xA7EE, 0xA7EF, 0xA7F0, 0xA7F1, 0xA7D7, 0xA1AA, 0xA1AC, 0xA1AE,
    0xA1AF, 0xA1B0, 0xA1B1, 0xA1AD, 0xA1EB, 0xA1E4, 0xA1E5, 0xA1F9,
    0xA1E6, 0xA1ED, 0xA2F1, 0xA2F2, 0xA2F3, 0xA2F4, 0xA2F5, 0xA2F6,
    0xA2F7, 0xA2F8, 0xA2F9, 0xA2FA, 0xA2FB, 0xA2FC, 0xA1FB, 0xA1FC,
    0xA1FA, 0xA1FD, 0xA1CA, 0xA1C7, 0xA1C6, 0xA1CC, 0xA1D8, 0xA1DE,
    0xA1CF, 0xA1CE, 0xA1C4, 0xA1C5, 0xA1C9, 0xA1C8, 0xA1D2, 0xA1D3,
    0xA1E0, 0xA1DF, 0xA1C3, 0xA1CB, 0xA1D7, 0xA1D6, 0xA1D5, 0xA1D9,
    0xA1D4, 0xA1DC, 0xA1DD, 0xA1DA, 0xA1DB, 0xA1D1, 0xA1CD, 0xA1D0,
    0xA2D9, 0xA2DA, 0xA2DB, 0xA2DC, 0xA2DD, 0xA2DE, 0xA2DF, 0xA2E0,
    0xA2E1, 0xA2E2, 0xA2C5, 0xA2C6, 0xA2C7, 0xA2C8, 0xA2C9, 0xA2CA,
    0xA2CB, 0xA2CC, 0xA2CD, 0xA2CE, 0xA2CF, 0xA2D0, 0xA2D1, 0xA2D2,
    0xA2D3, 0xA2D4, 0xA2D5, 0xA2D6, 0xA2D7, 0xA2D8, 0xA2B1, 0xA2B2,
    0xA2B3, 0xA2B4, 0xA2B5, 0xA2B6, 0xA2B7, 0xA2B8, 0xA2B9, 0xA2BA,
    0xA2BB, 0xA2BC, 0xA2BD, 0xA2BE, 0xA2BF, 0xA2C0, 0xA2C1, 0xA2C2,
    0xA2C3, 0xA2C4, 0xA9A4, 0xA9A5, 0xA9A6, 0xA9A7, 0xA9A8, 0xA9A9,
    0xA9AA, 0xA9AB, 0xA9AC, 0xA9AD, 0xA9AE, 0xA9AF, 0xA9B0, 0xA9B1,
    0xA9B2, 0xA9B3, 0xA9B4, 0xA9B5, 0xA9B6, 0xA9B7, 0xA9B8, 0xA9B9,
    0xA9BA, 0xA9BB, 0xA9BC, 0xA9BD, 0xA9BE, 0xA9BF, 0xA9C0, 0xA9C1,
    0xA9C2, 0xA9C3, 0xA9C4, 0xA9C5, 0xA9C6, 0xA9C7, 0xA9C8, 0xA9C9,
    0xA9CA, 0xA9CB, 0xA9CC, 0xA9CD, 0xA9CE, 0xA9CF, 0xA9D0, 0xA9D1,
    0xA9D2, 0xA9D3, 0xA9D4, 0xA9D5, 0xA9D6, 0xA9D7, 0xA9D8, 0xA9D9,
    0xA9DA, 0xA9DB, 0xA9DC, 0xA9DD, 0xA9DE, 0xA9DF, 0xA9E0, 0xA9E1,
    0xA9E2, 0xA9E3, 0xA9E4, 0xA9E5, 0xA9E6, 0xA9E7, 0xA9E8, 0xA9E9,
    0xA9EA, 0xA9EB, 0xA9EC, 0xA9ED, 0xA9EE, 0xA9EF, 0xA1F6, 0xA1F5,
    0xA1F8, 0xA1F7, 0xA1F4, 0xA1F3, 0xA1F0, 0xA1F2, 0xA1F1, 0xA1EF,
    0xA1EE, 0xA1E2, 0xA1E1, 0xA1A1, 0xA1A2, 0xA1A3, 0xA1A8, 0xA1A9,
    0xA1B4, 0xA1B5, 0xA1B6, 0xA1B7, 0xA1B8, 0xA1B9, 0xA1BA, 0xA1BB,
    0xA1BE, 0xA1BF, 0xA1FE, 0xA1B2, 0xA1B3, 0xA1BC, 0xA1BD, 0xA4A1,
    0xA4A2, 0xA4A3, 0xA4A4, 0xA4A5, 0xA4A6, 0xA4A7, 0xA4A8, 0xA4A9,
    0xA4AA, 0xA4AB, 0xA4AC, 0xA4AD, 0xA4AE, 0xA4AF, 0xA4B0, 0xA4B1,
    0xA4B2, 0xA4B3, 0xA4B4, 0xA4B5, 0xA4B6, 0xA4B7, 0xA4B8, 0xA4B9,
    0xA4BA, 0xA4BB, 0xA4BC, 0xA4BD, 0xA4BE, 0xA4BF, 0xA4C0, 0xA4C1,
    0xA4C2, 0xA4C3, 0xA4C4, 0xA4C5, 0xA4C6, 0xA4C7, 0xA4C8, 0xA4C9,
    0xA4CA, 0xA4CB, 0xA4CC, 0xA4CD, 0xA4CE, 0xA4CF, 0xA4D0, 0xA4D1,
    0xA4D2, 0xA4D3, 0xA4D4, 0xA4D5, 0xA4D6, 0xA4D7, 0xA4D8, 0xA4D9,
    0xA4DA, 0xA4DB, 0xA4DC, 0xA4DD, 0xA4DE, 0xA4DF, 0xA4E0, 0xA4E1,
    0xA4E2, 0xA4E3, 0xA4E4, 0xA4E5, 0xA4E6, 0xA4E7, 0xA4E8, 0xA4E9,
    0xA4EA, 0xA4EB, 0xA4EC, 0xA4ED, 0xA4EE, 0xA4EF, 0xA4F0, 0xA4F1,
    0xA4F2, 0xA4F3, 0xA5A1, 0xA5A2, 0xA5A3, 0xA5A4, 0xA5A5, 0xA5A6,
    0xA5A7, 0xA5A8, 0xA5A9, 0xA5AA, 0xA5AB, 0xA5AC, 0xA5AD, 0xA5AE,
    0xA5AF, 0xA5B0, 0xA5B1, 0xA5B2, 0xA5B3, 0xA5B4, 0xA5B5, 0xA5B6,
    0xA5B7, 0xA5B8, 0xA5B9, 0xA5BA, 0xA5BB, 0xA5BC, 0xA5BD, 0xA5BE,
    0xA5BF, 0xA5C0, 0xA5C1, 0xA5C2, 0xA5C3, 0xA5C4, 0xA5C5, 0xA5C6,
    0xA5C7, 0xA5C8, 0xA5C9, 0xA5CA, 0xA5CB, 0xA5CC, 0xA5CD, 0xA5CE,
    0xA5CF, 0xA5D0, 0xA5D1, 0xA5D2, 0xA5D3, 0xA5D4, 0xA5D5, 0xA5D6,
    0xA5D7, 0xA5D8, 0xA5D9, 0xA5DA, 0xA5DB, 0xA5DC, 0xA5DD, 0xA5DE,
    0xA5DF, 0xA5E0, 0xA5E1, 0xA5E2, 0xA5E3, 0xA5E4, 0xA5E5, 0xA5E6,
    0xA5E7, 0xA5E8, 0xA5E9, 0xA5EA, 0xA5EB, 0xA5EC, 0xA5ED, 0xA5EE,
    0xA5EF, 0xA5F0, 0xA5F1, 0xA5F2, 0xA5F3, 0xA5F4, 0xA5F5, 0xA5F6,
    0xA1A4, 0xA8C5, 0xA8C6, 0xA8C7, 0xA8C8, 0xA8C9, 0xA8CA, 0xA8CB,
    0xA8CC, 0xA8CD, 0xA8CE, 0xA8CF, 0xA8D0, 0xA8D1, 0xA8D2, 0xA8D3,
    0xA8D4, 0xA8D5, 0xA8D6, 0xA8D7, 0xA8D8, 0xA8D9, 0xA8DA, 0xA8DB,
    0xA8DC, 0xA8DD, 0xA8DE, 0xA8DF, 0xA8E0, 0xA8E1, 0xA8E2, 0xA8E3,
    0xA8E4, 0xA8E5, 0xA8E6, 0xA8E7, 0xA8E8, 0xA8E9, 0xA2E5, 0xA2E6,
    0xA2E7, 0xA2E8, 0xA2E9, 0xA2EA, 0xA2EB, 0xA2EC, 0xA2ED, 0xA2EE,
    0xD2BB, 0xB6A1, 0xC6DF, 0xCDF2, 0xD5C9, 0xC8FD, 0xC9CF, 0xCFC2,
    0xD8A2, 0xB2BB, 0xD3EB, 0xD8A4, 0xB3F3, 0xD7A8, 0xC7D2, 0xD8A7,
    0xCAC0, 0xC7F0, 0xB1FB, 0xD2B5, 0xB4D4, 0xB6AB, 0xCBBF, 0xD8A9,
    0xB6AA, 0xC1BD, 0xD1CF, 0xC9A5, 0xD8AD, 0xB8F6, 0xD1BE, 0xE3DC,
    0xD6D0, 0xB7E1, 0xB4AE, 0xC1D9, 0xD8BC, 0xCDE8, 0xB5A4, 0xCEAA,
    0xD6F7, 0xC0F6, 0xBED9, 0xD8AF, 0xC4CB, 0xBEC3, 0xD8B1, 0xC3B4,
    0xD2E5, 0xD6AE, 0xCEDA, 0xD5A7, 0xBAF5, 0xB7A6, 0xC0D6, 0xC6B9,
    0xC5D2, 0xC7C7, 0xB9D4, 0xB3CB, 0xD2D2, 0xD8BF, 0xBEC5, 0xC6F2,
    0xD2B2, 0xCFB0, 0xCFE7, 0xCAE9, 0xD8C0, 0xC2F2, 0xC2D2, 0xC8E9,
    0xC7AC, 0xC1CB, 0xD3E8, 0xD5F9, 0xCAC2, 0xB6FE, 0xD8A1, 0xD3DA,
    0xBFF7, 0xD4C6, 0xBBA5, 0xD8C1, 0xCEE5, 0xBEAE, 0xD8A8, 0xD1C7,
    0xD0A9, 0xD8BD, 0xD9EF, 0xCDF6, 0xBFBA, 0xBDBB, 0xBAA5, 0xD2E0,
    0xB2FA, 0xBAE0, 0xC4B6, 0xCFED, 0xBEA9, 0xCDA4, 0xC1C1, 0xC7D7,
    0xD9F1, 0xD9F4, 0xC8CB, 0xD8E9, 0xD2DA, 0xCAB2, 0xC8CA, 0xD8EC,
    0xD8EA, 0xD8C6, 0xBDF6, 0xC6CD, 0xB3F0, 0xD8EB, 0xBDF1, 0xBDE9,
    0xC8D4, 0xB4D3, 0xC2D8, 0xB2D6, 0xD7D0, 0xCACB, 0xCBFB, 0xD5CC,
    0xB8B6, 0xCFC9, 0xD9DA, 0xD8F0, 0xC7AA, 0xD8EE, 0xB4FA, 0xC1EE,
    0xD2D4, 0xD8ED, 0xD2C7, 0xD8EF, 0xC3C7, 0xD1F6, 0xD6D9, 0xD8F2,
    0xD8F5, 0xBCFE, 0xBCDB, 0xC8CE, 0xB7DD, 0xB7C2, 0xC6F3, 0xD8F8,
    0xD2C1, 0xCEE9, 0xBCBF, 0xB7FC, 0xB7A5, 0xD0DD, 0xD6DA, 0xD3C5,
    0xBBEF, 0xBBE1, 0xD8F1, 0xC9A1, 0xCEB0, 0xB4AB, 0xD8F3, 0xC9CB,
    0xD8F6, 0xC2D7, 0xD8F7, 0xCEB1, 0xD8F9, 0xB2AE, 0xB9C0, 0xD9A3,
    0xB0E9, 0xC1E6, 0xC9EC, 0xCBC5, 0xCBC6, 0xD9A4, 0xB5E8, 0xB5AB,
    0xCEBB, 0xB5CD, 0xD7A1, 0xD7F4, 0xD3D3, 0xCCE5, 0xBACE, 0xD9A2,
    0xD9DC, 0xD3E0, 0xD8FD, 0xB7F0, 0xD7F7, 0xD8FE, 0xD8FA, 0xD9A1,
    0xC4E3, 0xD3B6, 0xD8F4, 0xD9DD, 0xD8FB, 0xC5E5, 0xC0D0, 0xD1F0,
    0xB0DB, 0xBCD1, 0xD9A6, 0xD9A5, 0xD9AC, 0xD9AE, 0xD9AB, 0xCAB9,
    0xD9A9, 0xD6B6, 0xB3DE, 0xD9A8, 0xC0FD, 0xCACC, 0xD9AA, 0xD9A7,
    0xD9B0, 0xB6B1, 0xB9A9, 0xD2C0, 0xCFC0, 0xC2C2, 0xBDC4, 0xD5EC,
    0xB2E0, 0xC7C8, 0xBFEB, 0xD9AD, 0xD9AF, 0xCEEA, 0xBAEE, 0xC7D6,
    0xB1E3, 0xB4D9, 0xB6ED, 0xD9B4, 0xBFA1, 0xD9DE, 0xC7CE, 0xC0FE,
    0xD9B8, 0xCBD7, 0xB7FD, 0xD9B5, 0xD9B7, 0xB1A3, 0xD3E1, 0xD9B9,
    0xD0C5, 0xD9B6, 0xD9B1, 0xD9B2, 0xC1A9, 0xD9B3, 0xBCF3, 0xD0DE,
    0xB8A9, 0xBEE3, 0xD9BD, 0xD9BA, 0xB0B3, 0xD9C2, 0xD9C4, 0xB1B6,
    0xD9BF, 0xB5B9, 0xBEF3, 0xCCC8, 0xBAF2, 0xD2D0, 0xD9C3, 0xBDE8,
    0xB3AB, 0xD9C5, 0xBEEB, 0xD9C6, 0xD9BB, 0xC4DF, 0xD9BE, 0xD9C1,
    0xD9C0, 0xD5AE, 0xD6B5, 0xC7E3, 0xD9C8, 0xBCD9, 0xD9CA, 0xD9BC,
    0xD9CB, 0xC6AB, 0xD9C9, 0xD7F6, 0xCDA3, 0xBDA1, 0xD9CC, 0xC5BC,
    0xCDB5, 0xD9CD, 0xD9C7, 0xB3A5, 0xBFFE, 0xB8B5, 0xC0FC, 0xB0F8,
    0xB4F6, 0xD9CE, 0xD9CF, 0xB4A2, 0xD9D0, 0xB4DF, 0xB0C1, 0xD9D1,
    0xC9B5, 0xCFF1, 0xD9D2, 0xC1C5, 0xD9D6, 0xC9AE, 0xD9D5, 0xD9D4,
    0xD9D7, 0xCBDB, 0xBDA9, 0xC6A7, 0xD9D3, 0xD9D8, 0xD9D9, 0xC8E5,
    0xC0DC, 0xB6F9, 0xD8A3, 0xD4CA, 0xD4AA, 0xD0D6, 0xB3E4, 0xD5D7,
    0xCFC8, 0xB9E2, 0xBFCB, 0xC3E2, 0xB6D2, 0xCDC3, 0xD9EE, 0xD9F0,
    0xB5B3, 0xB6B5, 0xBEA4, 0xC8EB, 0xC8AB, 0xB0CB, 0xB9AB, 0xC1F9,
    0xD9E2, 0xC0BC, 0xB9B2, 0xB9D8, 0xD0CB, 0xB1F8, 0xC6E4, 0xBEDF,
    0xB5E4, 0xD7C8, 0xD1F8, 0xBCE6, 0xCADE, 0xBCBD, 0xD9E6, 0xD8E7,
    0xC4DA, 0xB8D4, 0xC8BD, 0xB2E1, 0xD4D9, 0xC3B0, 0xC3E1, 0xDAA2,
    0xC8DF, 0xD0B4, 0xBEFC, 0xC5A9, 0xB9DA, 0xDAA3, 0xD4A9, 0xDAA4,
    0xD9FB, 0xB6AC, 0xB7EB, 0xB1F9, 0xD9FC, 0xB3E5, 0xBEF6, 0xBFF6,
    0xD2B1, 0xC0E4, 0xB6B3, 0xD9FE, 0xD9FD, 0xBEBB, 0xC6E0, 0xD7BC,
    0xDAA1, 0xC1B9, 0xB5F2, 0xC1E8, 0xBCF5, 0xB4D5, 0xC1DD, 0xC4FD,
    0xBCB8, 0xB7B2, 0xB7EF, 0xD9EC, 0xC6BE, 0xBFAD, 0xBBCB, 0xB5CA,
    0xDBC9, 0xD0D7, 0xCDB9, 0xB0BC, 0xB3F6, 0xBBF7, 0xDBCA, 0xBAAF,
    0xD4E4, 0xB5B6, 0xB5F3, 0xD8D6, 0xC8D0, 0xB7D6, 0xC7D0, 0xD8D7,
    0xBFAF, 0xDBBB, 0xD8D8, 0xD0CC, 0xBBAE, 0xEBBE, 0xC1D0, 0xC1F5,
    0xD4F2, 0xB8D5, 0xB4B4, 0xB3F5, 0xC9BE, 0xC5D0, 0xC5D9, 0xC0FB,
    0xB1F0, 0xD8D9, 0xB9CE, 0xB5BD, 0xD8DA, 0xD6C6, 0xCBA2, 0xC8AF,
    0xC9B2, 0xB4CC, 0xBFCC, 0xB9F4, 0xD8DB, 0xD8DC, 0xB6E7, 0xBCC1,
    0xCCEA, 0xCFF7, 0xD8DD, 0xC7B0, 0xB9D0, 0xBDA3, 0xCCDE, 0xC6CA,
    0xD8E0, 0xD8DE, 0xD8DF, 0xB0FE, 0xBEE7, 0xCAA3, 0xBCF4, 0xB8B1,
    0xB8EE, 0xD8E2, 0xBDCB, 0xD8E4, 0xD8E3, 0xC5FC, 0xD8E5, 0xD8E6,
    0xC1A6, 0xC8B0, 0xB0EC, 0xB9A6, 0xBCD3, 0xCEF1, 0xDBBD, 0xC1D3,
    0xB6AF, 0xD6FA, 0xC5AC, 0xBDD9, 0xDBBE, 0xDBBF, 0xC0F8, 0xBEA2,
    0xC0CD, 0xDBC0, 0xCAC6, 0xB2AA, 0xD3C2, 0xC3E3, 0xD1AB, 0xDBC2,
    0xC0D5, 0xDBC3, 0xBFB1, 0xC4BC, 0xC7DA, 0xDBC4, 0xD9E8, 0xC9D7,
    0xB9B4, 0xCEF0, 0xD4C8, 0xB0FC, 0xB4D2, 0xD0D9, 0xD9E9, 0xDECB,
    0xD9EB, 0xD8B0, 0xBBAF, 0xB1B1, 0xB3D7, 0xD8CE, 0xD4D1, 0xBDB3,
    0xBFEF, 0xCFBB, 0xD8D0, 0xB7CB, 0xD8D1, 0xC6A5, 0xC7F8, 0xD2BD,
    0xD8D2, 0xC4E4, 0xCAAE, 0xC7A7, 0xD8A6, 0xC9FD, 0xCEE7, 0xBBDC,
    0xB0EB, 0xBBAA, 0xD0AD, 0xB1B0, 0xD7E4, 0xD7BF, 0xB5A5, 0xC2F4,
    0xC4CF, 0xB2A9, 0xB2B7, 0xB1E5, 0xDFB2, 0xD5BC, 0xBFA8, 0xC2AC,
    0xD8D5, 0xC2B1, 0xD8D4, 0xCED4, 0xDAE0, 0xCEC0, 0xD8B4, 0xC3AE,
    0xD3A1, 0xCEA3, 0xBCB4, 0xC8B4, 0xC2D1, 0xBEED, 0xD0B6, 0xDAE1,
    0xC7E4, 0xB3A7, 0xB6F2, 0xCCFC, 0xC0FA, 0xC0F7, 0xD1B9, 0xD1E1,
    0xD8C7, 0xB2DE, 0xC0E5, 0xBAF1, 0xD8C8, 0xD4AD, 0xCFE1, 0xD8C9,
    0xD8CA, 0xCFC3, 0xB3F8, 0xBEC7, 0xD8CB, 0xDBCC, 0xC8A5, 0xCFD8,
    0xC8FE, 0xB2CE, 0xD3D6, 0xB2E6, 0xBCB0, 0xD3D1, 0xCBAB, 0xB7B4,
    0xB7A2, 0xCAE5, 0xC8A1, 0xCADC, 0xB1E4, 0xD0F0, 0xC5D1, 0xDBC5,
    0xB5FE, 0xBFDA, 0xB9C5, 0xBEE4, 0xC1ED, 0xDFB6, 0xDFB5, 0xD6BB,
    0xBDD0, 0xD5D9, 0xB0C8, 0xB6A3, 0xBFC9, 0xCCA8, 0xDFB3, 0xCAB7,
    0xD3D2, 0xD8CF, 0xD2B6, 0xBAC5, 0xCBBE, 0xCCBE, 0xDFB7, 0xB5F0,
    0xDFB4, 0xD3F5, 0xB3D4, 0xB8F7, 0xDFBA, 0xBACF, 0xBCAA, 0xB5F5,
    0xCDAC, 0xC3FB, 0xBAF3, 0xC0F4, 0xCDC2, 0xCFF2, 0xDFB8, 0xCFC5,
    0xC2C0, 0xDFB9, 0xC2F0, 0xBEFD, 0xC1DF, 0xCDCC, 0xD2F7, 0xB7CD,
    0xDFC1, 0xDFC4, 0xB7F1, 0xB0C9, 0xB6D6, 0xB7D4, 0xBAAC, 0xCCFD,
    0xBFD4, 0xCBB1, 0xC6F4, 0xD6A8, 0xDFC5, 0xCEE2, 0xB3B3, 0xCEFC,
    0xB4B5, 0xCEC7, 0xBAF0, 0xCEE1, 0xD1BD, 0xDFC0, 0xB4F4, 0xB3CA,
    0xB8E6, 0xDFBB, 0xC4C5, 0xDFBC, 0xDFBD, 0xDFBE, 0xC5BB, 0xDFBF,
    0xDFC2, 0xD4B1, 0xDFC3, 0xC7BA, 0xCED8, 0xC4D8, 0xDFCA, 0xDFCF,
    0xD6DC, 0xDFC9, 0xDFDA, 0xCEB6, 0xBAC7, 0xDFCE, 0xDFC8, 0xC5DE,
    0xC9EB, 0xBAF4, 0xC3FC, 0xBED7, 0xDFC6, 0xDFCD, 0xC5D8, 0xD5A6,
    0xBACD, 0xBECC, 0xD3BD, 0xB8C0, 0xD6E4, 0xDFC7, 0xB9BE, 0xBFA7,
    0xC1FC, 0xDFCB, 0xDFCC, 0xDFD0, 0xDFDB, 0xDFE5, 0xDFD7, 0xDFD6,
    0xD7C9, 0xDFE3, 0xDFE4, 0xE5EB, 0xD2A7, 0xDFD2, 0xBFA9, 0xD4DB,
    0xBFC8, 0xDFD4, 0xCFCC, 0xDFDD, 0xD1CA, 0xDFDE, 0xB0A7, 0xC6B7,
    0xDFD3, 0xBAE5, 0xB6DF, 0xCDDB, 0xB9FE, 0xD4D5, 0xDFDF, 0xCFEC,
    0xB0A5, 0xDFE7, 0xDFD1, 0xD1C6, 0xDFD5, 0xDFD8, 0xDFD9, 0xDFDC,
    0xBBA9, 0xDFE0, 0xDFE1, 0xDFE2, 0xDFE6, 0xDFE8, 0xD3B4, 0xB8E7,
    0xC5B6, 0xDFEA, 0xC9DA, 0xC1A8, 0xC4C4, 0xBFDE, 0xCFF8, 0xD5DC,
    0xDFEE, 0xB2B8, 0xBADF, 0xDFEC, 0xDBC1, 0xD1E4, 0xCBF4, 0xB4BD,
    0xB0A6, 0xDFF1, 0xCCC6, 0xDFF2, 0xDFED, 0xDFE9, 0xDFEB, 0xDFEF,
    0xDFF0, 0xBBBD, 0xDFF3, 0xDFF4, 0xBBA3, 0xCADB, 0xCEA8, 0xE0A7,
    0xB3AA, 0xE0A6, 0xE0A1, 0xDFFE, 0xCDD9, 0xDFFC, 0xDFFA, 0xBFD0,
    0xD7C4, 0xC9CC, 0xDFF8, 0xB0A1, 0xDFFD, 0xDFFB, 0xE0A2, 0xE0A8,
    0xB7C8, 0xC6A1, 0xC9B6, 0xC0B2, 0xDFF5, 0xC5BE, 0xD8C4, 0xDFF9,
    0xC4F6, 0xE0A3, 0xE0A4, 0xE0A5, 0xD0A5, 0xE0B4, 0xCCE4, 0xE0B1,
    0xBFA6, 0xE0AF, 0xCEB9, 0xE0AB, 0xC9C6, 0xC0AE, 0xE0AE, 0xBAED,
    0xBAB0, 0xE0A9, 0xDFF6, 0xE0B3, 0xE0B8, 0xB4AD, 0xE0B9, 0xCFB2,
    0xBAC8, 0xE0B0, 0xD0FA, 0xE0AC, 0xD4FB, 0xDFF7, 0xC5E7, 0xE0AD,
    0xD3F7, 0xE0B6, 0xE0B7, 0xE0C4, 0xD0E1, 0xE0BC, 0xE0C9, 0xE0CA,
    0xE0BE, 0xE0AA, 0xC9A4, 0xE0C1, 0xE0B2, 0xCAC8, 0xE0C3, 0xE0B5,
    0xCECB, 0xCBC3, 0xE0CD, 0xE0C6, 0xE0C2, 0xE0CB, 0xE0BA, 0xE0BF,
    0xE0C0, 0xE0C5, 0xE0C7, 0xE0C8, 0xE0CC, 0xE0BB, 0xCBD4, 0xE0D5,
    0xE0D6, 0xE0D2, 0xE0D0, 0xBCCE, 0xE0D1, 0xB8C2, 0xD8C5, 0xD0EA,
    0xC2EF, 0xE0CF, 0xE0BD, 0xE0D4, 0xE0D3, 0xE0D7, 0xE0DC, 0xE0D8,
    0xD6F6, 0xB3B0, 0xD7EC, 0xCBBB, 0xE0DA, 0xCEFB, 0xBAD9, 0xE0E1,
    0xE0DD, 0xD2AD, 0xE0E2, 0xE0DB, 0xE0D9, 0xE0DF, 0xE0E0, 0xE0DE,
    0xE0E4, 0xC6F7, 0xD8AC, 0xD4EB, 0xE0E6, 0xCAC9, 0xE0E5, 0xB8C1,
    0xE0E7, 0xE0E8, 0xE0E9, 0xE0E3, 0xBABF, 0xCCE7, 0xE0EA, 0xCFF9,
    0xE0EB, 0xC8C2, 0xBDC0, 0xC4D2, 0xE0EC, 0xE0ED, 0xC7F4, 0xCBC4,
    0xE0EE, 0xBBD8, 0xD8B6, 0xD2F2, 0xE0EF, 0xCDC5, 0xB6DA, 0xE0F1,
    0xD4B0, 0xC0A7, 0xB4D1, 0xCEA7, 0xE0F0, 0xE0F2, 0xB9CC, 0xB9FA,
    0xCDBC, 0xE0F3, 0xC6D4, 0xE0F4, 0xD4B2, 0xC8A6, 0xE0F6, 0xE0F5,
    0xE0F7, 0xCDC1, 0xCAA5, 0xD4DA, 0xDBD7, 0xDBD9, 0xDBD8, 0xB9E7,
    0xDBDC, 0xDBDD, 0xB5D8, 0xDBDA, 0xDBDB, 0xB3A1, 0xDBDF, 0xBBF8,
    0xD6B7, 0xDBE0, 0xBEF9, 0xB7BB, 0xDBD0, 0xCCAE, 0xBFB2, 0xBBB5,
    0xD7F8, 0xBFD3, 0xBFE9, 0xBCE1, 0xCCB3, 0xDBDE, 0xB0D3, 0xCEEB,
    0xB7D8, 0xD7B9, 0xC6C2, 0xC0A4, 0xCCB9, 0xDBE7, 0xDBE1, 0xC6BA,
    0xDBE3, 0xDBE8, 0xC5F7, 0xDBEA, 0xDBE9, 0xBFC0, 0xDBE6, 0xDBE5,
    0xB4B9, 0xC0AC, 0xC2A2, 0xDBE2, 0xDBE4, 0xD0CD, 0xDBED, 0xC0DD,
    0xDBF2, 0xB6E2, 0xDBF3, 0xDBD2, 0xB9B8, 0xD4AB, 0xDBEC, 0xBFD1,
    0xDBF0, 0xDBD1, 0xB5E6, 0xDBEB, 0xBFE5, 0xDBEE, 0xDBF1, 0xDBF9,
    0xB9A1, 0xB0A3, 0xC2F1, 0xB3C7, 0xDBEF, 0xDBF8, 0xC6D2, 0xDBF4,
    0xDBF5, 0xDBF7, 0xDBF6, 0xDBFE, 0xD3F2, 0xB2BA, 0xDBFD, 0xDCA4,
    0xDBFB, 0xDBFA, 0xDBFC, 0xC5E0, 0xBBF9, 0xDCA3, 0xDCA5, 0xCCC3,
    0xB6D1, 0xDDC0, 0xDCA1, 0xDCA2, 0xC7B5, 0xB6E9, 0xDCA7, 0xDCA6,
    0xDCA9, 0xB1A4, 0xB5CC, 0xBFB0, 0xD1DF, 0xB6C2, 0xDCA8, 0xCBFA,
    0xEBF3, 0xCBDC, 0xCBFE, 0xCCC1, 0xC8FB, 0xDCAA, 0xCCEE, 0xDCAB,
    0xDBD3, 0xDCAF, 0xDCAC, 0xBEB3, 0xCAFB, 0xDCAD, 0xC9CA, 0xC4B9,
    0xC7BD, 0xDCAE, 0xD4F6, 0xD0E6, 0xC4AB, 0xB6D5, 0xDBD4, 0xB1DA,
    0xDBD5, 0xDBD6, 0xBABE, 0xC8C0, 0xCABF, 0xC8C9, 0xD7B3, 0xC9F9,
    0xBFC7, 0xBAF8, 0xD2BC, 0xE2BA, 0xB4A6, 0xB1B8, 0xB8B4, 0xCFC4,
    0xD9E7, 0xCFA6, 0xCDE2, 0xD9ED, 0xB6E0, 0xD2B9, 0xB9BB, 0xE2B9,
    0xE2B7, 0xB4F3, 0xCCEC, 0xCCAB, 0xB7F2, 0xD8B2, 0xD1EB, 0xBABB,
    0xCAA7, 0xCDB7, 0xD2C4, 0xBFE4, 0xBCD0, 0xB6E1, 0xDEC5, 0xDEC6,
    0xDBBC, 0xD1D9, 0xC6E6, 0xC4CE, 0xB7EE, 0xB7DC, 0xBFFC, 0xD7E0,
    0xC6F5, 0xB1BC, 0xDEC8, 0xBDB1, 0xCCD7, 0xDECA, 0xDEC9, 0xB5EC,
    0xC9DD, 0xB0C2, 0xC5AE, 0xC5AB, 0xC4CC, 0xBCE9, 0xCBFD, 0xBAC3,
    0xE5F9, 0xC8E7, 0xE5FA, 0xCDFD, 0xD7B1, 0xB8BE, 0xC2E8, 0xC8D1,
    0xE5FB, 0xB6CA, 0xBCCB, 0xD1FD, 0xE6A1, 0xC3EE, 0xE6A4, 0xE5FE,
    0xE6A5, 0xCDD7, 0xB7C1, 0xE5FC, 0xE5FD, 0xE6A3, 0xC4DD, 0xE6A8,
    0xE6A7, 0xC3C3, 0xC6DE, 0xE6AA, 0xC4B7, 0xE6A2, 0xCABC, 0xBDE3,
    0xB9C3, 0xE6A6, 0xD0D5, 0xCEAF, 0xE6A9, 0xE6B0, 0xD2A6, 0xBDAA,
    0xE6AD, 0xE6AF, 0xC0D1, 0xD2CC, 0xBCA7, 0xE6B1, 0xD2F6, 0xD7CB,
    0xCDFE, 0xCDDE, 0xC2A6, 0xE6AB, 0xE6AC, 0xBDBF, 0xE6AE, 0xE6B3,
    0xE6B2, 0xE6B6, 0xE6B8, 0xC4EF, 0xC4C8, 0xBEEA, 0xC9EF, 0xE6B7,
    0xB6F0, 0xC3E4, 0xD3E9, 0xE6B4, 0xE6B5, 0xC8A2, 0xE6BD, 0xE6B9,
    0xC6C5, 0xCDF1, 0xE6BB, 0xE6BC, 0xBBE9, 0xE6BE, 0xE6BA, 0xC0B7,
    0xD3A4, 0xE6BF, 0xC9F4, 0xE6C3, 0xE6C4, 0xD0F6, 0xC3BD, 0xC3C4,
    0xE6C2, 0xE6C1, 0xE6C7, 0xCFB1, 0xEBF4, 0xE6CA, 0xE6C5, 0xBCDE,
    0xC9A9, 0xBCB5, 0xCFD3, 0xE6C8, 0xE6C9, 0xE6CE, 0xE6D0, 0xE6D1,
    0xE6CB, 0xB5D5, 0xE6CC, 0xE6CF, 0xC4DB, 0xE6C6, 0xE6CD, 0xE6D2,
    0xE6D4, 0xE6D3, 0xE6D5, 0xD9F8, 0xE6D6, 0xE6D7, 0xD7D3, 0xE6DD,
    0xE6DE, 0xBFD7, 0xD4D0, 0xD7D6, 0xB4E6, 0xCBEF, 0xE6DA, 0xD8C3,
    0xD7CE, 0xD0A2, 0xC3CF, 0xE6DF, 0xBCBE, 0xB9C2, 0xE6DB, 0xD1A7,
    0xBAA2, 0xC2CF, 0xD8AB, 0xCAEB, 0xE5EE, 0xE6DC, 0xB7F5, 0xC8E6,
    0xC4F5, 0xE5B2, 0xC4FE, 0xCBFC, 0xE5B3, 0xD5AC, 0xD3EE, 0xCAD8,
    0xB0B2, 0xCBCE, 0xCDEA, 0xBAEA, 0xE5B5, 0xE5B4, 0xD7DA, 0xB9D9,
    0xD6E6, 0xB6A8, 0xCDF0, 0xD2CB, 0xB1A6, 0xCAB5, 0xB3E8, 0xC9F3,
    0xBFCD, 0xD0FB, 0xCAD2, 0xE5B6, 0xBBC2, 0xCFDC, 0xB9AC, 0xD4D7,
    0xBAA6, 0xD1E7, 0xCFFC, 0xBCD2, 0xE5B7, 0xC8DD, 0xBFED, 0xB1F6,
    0xCBDE, 0xBCC5, 0xBCC4, 0xD2FA, 0xC3DC, 0xBFDC, 0xB8BB, 0xC3C2,
    0xBAAE, 0xD4A2, 0xC7DE, 0xC4AF, 0xB2EC, 0xB9D1, 0xE5BB, 0xC1C8,
    0xD5AF, 0xE5BC, 0xE5BE, 0xB4E7, 0xB6D4, 0xCBC2, 0xD1B0, 0xB5BC,
    0xCAD9, 0xB7E2, 0xC9E4, 0xBDAB, 0xCEBE, 0xD7F0, 0xD0A1, 0xC9D9,
    0xB6FB, 0xE6D8, 0xBCE2, 0xB3BE, 0xC9D0, 0xE6D9, 0xB3A2, 0xDECC,
    0xD3C8, 0xDECD, 0xD2A2, 0xDECE, 0xBECD, 0xDECF, 0xCAAC, 0xD2FC,
    0xB3DF, 0xE5EA, 0xC4E1, 0xBEA1, 0xCEB2, 0xC4F2, 0xBED6, 0xC6A8,
    0xB2E3, 0xBED3, 0xC7FC, 0xCCEB, 0xBDEC, 0xCEDD, 0xCABA, 0xC6C1,
    0xE5EC, 0xD0BC, 0xD5B9, 0xE5ED, 0xCAF4, 0xCDC0, 0xC2C5, 0xE5EF,
    0xC2C4, 0xE5F0, 0xE5F8, 0xCDCD, 0xC9BD, 0xD2D9, 0xE1A8, 0xD3EC,
    0xCBEA, 0xC6F1, 0xE1AC, 0xE1A7, 0xE1A9, 0xE1AA, 0xE1AF, 0xB2ED,
    0xE1AB, 0xB8DA, 0xE1AD, 0xE1AE, 0xE1B0, 0xB5BA, 0xE1B1, 0xE1B3,
    0xE1B8, 0xD1D2, 0xE1B6, 0xE1B5, 0xC1EB, 0xE1B7, 0xD4C0, 0xE1B2,
    0xE1BA, 0xB0B6, 0xE1B4, 0xBFF9, 0xE1B9, 0xE1BB, 0xE1BE, 0xE1BC,
    0xD6C5, 0xCFBF, 0xE1BD, 0xE1BF, 0xC2CD, 0xB6EB, 0xD3F8, 0xC7CD,
    0xB7E5, 0xBEFE, 0xE1C0, 0xE1C1, 0xE1C7, 0xB3E7, 0xC6E9, 0xB4DE,
    0xD1C2, 0xE1C8, 0xE1C6, 0xE1C5, 0xE1C3, 0xE1C2, 0xB1C0, 0xD5B8,
    0xE1C4, 0xE1CB, 0xE1CC, 0xE1CA, 0xEFFA, 0xE1D3, 0xE1D2, 0xC7B6,
    0xE1C9, 0xE1CE, 0xE1D0, 0xE1D4, 0xE1D1, 0xE1CD, 0xE1CF, 0xE1D5,
    0xE1D6, 0xE1D7, 0xE1D8, 0xE1DA, 0xE1DB, 0xCEA1, 0xE7DD, 0xB4A8,
    0xD6DD, 0xD1B2, 0xB3B2, 0xB9A4, 0xD7F3, 0xC7C9, 0xBEDE, 0xB9AE,
    0xCED7, 0xB2EE, 0xDBCF, 0xBCBA, 0xD2D1, 0xCBC8, 0xB0CD, 0xCFEF,
    0xD9E3, 0xBDED, 0xB1D2, 0xCAD0, 0xB2BC, 0xCBA7, 0xB7AB, 0xCAA6,
    0xCFA3, 0xE0F8, 0xD5CA, 0xE0FB, 0xE0FA, 0xC5C1, 0xCCFB, 0xC1B1,
    0xE0F9, 0xD6E3, 0xB2AF, 0xD6C4, 0xB5DB, 0xB4F8, 0xD6A1, 0xCFAF,
    0xB0EF, 0xE0FC, 0xE1A1, 0xB3A3, 0xE0FD, 0xE0FE, 0xC3B1, 0xC3DD,
    0xE1A2, 0xB7F9, 0xBBCF, 0xE1A3, 0xC4BB, 0xE1A4, 0xE1A5, 0xE1A6,
    0xB4B1, 0xB8C9, 0xC6BD, 0xC4EA, 0xB2A2, 0xD0D2, 0xE7DB, 0xBBC3,
    0xD3D7, 0xD3C4, 0xB9E3, 0xE2CF, 0xD7AF, 0xC7EC, 0xB1D3, 0xB4B2,
    0xE2D1, 0xD0F2, 0xC2AE, 0xE2D0, 0xBFE2, 0xD3A6, 0xB5D7, 0xE2D2,
    0xB5EA, 0xC3ED, 0xB8FD, 0xB8AE, 0xC5D3, 0xB7CF, 0xE2D4, 0xE2D3,
    0xB6C8, 0xD7F9, 0xCDA5, 0xE2D8, 0xE2D6, 0xCAFC, 0xBFB5, 0xD3B9,
    0xE2D5, 0xE2D7, 0xC1AE, 0xC0C8, 0xE2DB, 0xE2DA, 0xC0AA, 0xC1CE,
    0xE2DC, 0xE2DD, 0xE2DE, 0xDBC8, 0xD1D3, 0xCDA2, 0xBDA8, 0xDEC3,
    0xD8A5, 0xBFAA, 0xDBCD, 0xD2EC, 0xC6FA, 0xC5AA, 0xDEC4, 0xB1D7,
    0xDFAE, 0xCABD, 0xDFB1, 0xB9AD, 0xD2FD, 0xB8A5, 0xBAEB, 0xB3DA,
    0xB5DC, 0xD5C5, 0xC3D6, 0xCFD2, 0xBBA1, 0xE5F3, 0xE5F2, 0xE5F4,
    0xCDE4, 0xC8F5, 0xB5AF, 0xC7BF, 0xE5F6, 0xECB0, 0xE5E6, 0xB9E9,
    0xB5B1, 0xC2BC, 0xE5E8, 0xE5E7, 0xE5E9, 0xD2CD, 0xE1EA, 0xD0CE,
    0xCDAE, 0xD1E5, 0xB2CA, 0xB1EB, 0xB1F2, 0xC5ED, 0xD5C3, 0xD3B0,
    0xE1DC, 0xE1DD, 0xD2DB, 0xB3B9, 0xB1CB, 0xCDF9, 0xD5F7, 0xE1DE,
    0xBEB6, 0xB4FD, 0xE1DF, 0xBADC, 0xE1E0, 0xBBB2, 0xC2C9, 0xE1E1,
    0xD0EC, 0xCDBD, 0xE1E2, 0xB5C3, 0xC5C7, 0xE1E3, 0xE1E4, 0xD3F9,
    0xE1E5, 0xD1AD, 0xE1E6, 0xCEA2, 0xE1E7, 0xB5C2, 0xE1E8, 0xBBD5,
    0xD0C4, 0xE2E0, 0xB1D8, 0xD2E4, 0xE2E1, 0xBCC9, 0xC8CC, 0xE2E3,
    0xECFE, 0xECFD, 0xDFAF, 0xE2E2, 0xD6BE, 0xCDFC, 0xC3A6, 0xE3C3,
    0xD6D2, 0xE2E7, 0xE2E8, 0xD3C7, 0xE2EC, 0xBFEC, 0xE2ED, 0xE2E5,
    0xB3C0, 0xC4EE, 0xE2EE, 0xD0C3, 0xBAF6, 0xE2E9, 0xB7DE, 0xBBB3,
    0xCCAC, 0xCBCB, 0xE2E4, 0xE2E6, 0xE2EA, 0xE2EB, 0xE2F7, 0xE2F4,
    0xD4F5, 0xE2F3, 0xC5AD, 0xD5FA, 0xC5C2, 0xB2C0, 0xE2EF, 0xE2F2,
    0xC1AF, 0xCBBC, 0xB5A1, 0xE2F9, 0xBCB1, 0xE2F1, 0xD0D4, 0xD4B9,
    0xE2F5, 0xB9D6, 0xE2F6, 0xC7D3, 0xE2F0, 0xD7DC, 0xEDA1, 0xE2F8,
    0xEDA5, 0xE2FE, 0xCAD1, 0xC1B5, 0xBBD0, 0xBFD6, 0xBAE3, 0xCBA1,
    0xEDA6, 0xEDA3, 0xEDA2, 0xBBD6, 0xEDA7, 0xD0F4, 0xEDA4, 0xBADE,
    0xB6F7, 0xE3A1, 0xB6B2, 0xCCF1, 0xB9A7, 0xCFA2, 0xC7A1, 0xBFD2,
    0xB6F1, 0xE2FA, 0xE2FB, 0xE2FD, 0xE2FC, 0xC4D5, 0xE3A2, 0xD3C1,
    0xE3A7, 0xC7C4, 0xCFA4, 0xE3A9, 0xBAB7, 0xE3A8, 0xBBDA, 0xE3A3,
    0xE3A4, 0xE3AA, 0xE3A6, 0xCEF2, 0xD3C6, 0xBBBC, 0xD4C3, 0xC4FA,
    0xEDA8, 0xD0FC, 0xE3A5, 0xC3F5, 0xE3AD, 0xB1AF, 0xE3B2, 0xBCC2,
    0xE3AC, 0xB5BF, 0xC7E9, 0xE3B0, 0xBEAA, 0xCDEF, 0xBBF3, 0xCCE8,
    0xE3AF, 0xE3B1, 0xCFA7, 0xE3AE, 0xCEA9, 0xBBDD, 0xB5EB, 0xBEE5,
    0xB2D2, 0xB3CD, 0xB1B9, 0xE3AB, 0xB2D1, 0xB5AC, 0xB9DF, 0xB6E8,
    0xCFEB, 0xE3B7, 0xBBCC, 0xC8C7, 0xD0CA, 0xE3B8, 0xB3EE, 0xEDA9,
    0xD3FA, 0xD3E4, 0xEDAA, 0xE3B9, 0xD2E2, 0xE3B5, 0xD3DE, 0xB8D0,
    0xE3B3, 0xE3B6, 0xB7DF, 0xE3B4, 0xC0A2, 0xE3BA, 0xD4B8, 0xB4C8,
    0xE3BB, 0xBBC5, 0xC9F7, 0xC9E5, 0xC4BD, 0xEDAB, 0xC2FD, 0xBBDB,
    0xBFAE, 0xCEBF, 0xE3BC, 0xBFB6, 0xB1EF, 0xD4F7, 0xE3BE, 0xEDAD,
    0xE3BF, 0xBAA9, 0xEDAC, 0xE3BD, 0xE3C0, 0xBAB6, 0xB6AE, 0xD0B8,
    0xB0C3, 0xEDAE, 0xEDAF, 0xC0C1, 0xE3C1, 0xC5B3, 0xE3C2, 0xDCB2,
    0xEDB0, 0xB8EA, 0xCEEC, 0xEAA7, 0xD0E7, 0xCAF9, 0xC8D6, 0xCFB7,
    0xB3C9, 0xCED2, 0xBDE4, 0xE3DE, 0xBBF2, 0xEAA8, 0xD5BD, 0xC6DD,
    0xEAA9, 0xEAAA, 0xEAAC, 0xEAAB, 0xEAAE, 0xEAAD, 0xBDD8, 0xEAAF,
    0xC2BE, 0xB4C1, 0xB4F7, 0xBBA7, 0xECE6, 0xECE5, 0xB7BF, 0xCBF9,
    0xB1E2, 0xECE7, 0xC9C8, 0xECE8, 0xECE9, 0xCAD6, 0xDED0, 0xB2C5,
    0xD4FA, 0xC6CB, 0xB0C7, 0xB4F2, 0xC8D3, 0xCDD0, 0xBFB8, 0xBFDB,
    0xC7A4, 0xD6B4, 0xC0A9, 0xDED1, 0xC9A8, 0xD1EF, 0xC5A4, 0xB0E7,
    0xB3B6, 0xC8C5, 0xB0E2, 0xB7F6, 0xC5FA, 0xB6F3, 0xD5D2, 0xB3D0,
    0xBCBC, 0xB3AD, 0xBEF1, 0xB0D1, 0xD2D6, 0xCAE3, 0xD7A5, 0xCDB6,
    0xB6B6, 0xBFB9, 0xD5DB, 0xB8A7, 0xC5D7, 0xDED2, 0xBFD9, 0xC2D5,
    0xC7C0, 0xBBA4, 0xB1A8, 0xC5EA, 0xC5FB, 0xCCA7, 0xB1A7, 0xB5D6,
    0xC4A8, 0xDED3, 0xD1BA, 0xB3E9, 0xC3F2, 0xB7F7, 0xD6F4, 0xB5A3,
    0xB2F0, 0xC4B4, 0xC4E9, 0xC0AD, 0xDED4, 0xB0E8, 0xC5C4, 0xC1E0,
    0xB9D5, 0xBEDC, 0xCDD8, 0xB0CE, 0xCDCF, 0xDED6, 0xBED0, 0xD7BE,
    0xDED5, 0xD5D0, 0xB0DD, 0xC4E2, 0xC2A3, 0xBCF0, 0xD3B5, 0xC0B9,
    0xC5A1, 0xB2A6, 0xD4F1, 0xC0A8, 0xCAC3, 0xDED7, 0xD5FC, 0xB9B0,
    0xC8AD, 0xCBA9, 0xDED9, 0xBFBD, 0xC6B4, 0xD7A7, 0xCAB0, 0xC4C3,
    0xB3D6, 0xB9D2, 0xD6B8, 0xEAFC, 0xB0B4, 0xBFE6, 0xCCF4, 0xCDDA,
    0xD6BF, 0xC2CE, 0xCECE, 0xCCA2, 0xD0AE, 0xC4D3, 0xB5B2, 0xDED8,
    0xD5F5, 0xBCB7, 0xBBD3, 0xB0A4, 0xC5B2, 0xB4EC, 0xD5F1, 0xEAFD,
    0xDEDA, 0xCDA6, 0xCDEC, 0xCEE6, 0xDEDC, 0xCDB1, 0xC0A6, 0xD7BD,
    0xDEDB, 0xB0C6, 0xBAB4, 0xC9D3, 0xC4F3, 0xBEE8, 0xB2B6, 0xC0CC,
    0xCBF0, 0xBCF1, 0xBBBB, 0xB5B7, 0xC5F5, 0xDEE6, 0xDEE3, 0xBEDD,
    0xDEDF, 0xB4B7, 0xBDDD, 0xDEE0, 0xC4ED, 0xCFC6, 0xB5E0, 0xB6DE,
    0xCADA, 0xB5F4, 0xDEE5, 0xD5C6, 0xDEE1, 0xCCCD, 0xC6FE, 0xC5C5,
    0xD2B4, 0xBEF2, 0xC2D3, 0xCCBD, 0xB3B8, 0xBDD3, 0xBFD8, 0xCDC6,
    0xD1DA, 0xB4EB, 0xDEE4, 0xDEDD, 0xDEE7, 0xEAFE, 0xC2B0, 0xDEE2,
    0xD6C0, 0xB5A7, 0xB2F4, 0xDEE8, 0xDEF2, 0xDEED, 0xDEF1, 0xC8E0,
    0xD7E1, 0xDEEF, 0xC3E8, 0xCCE1, 0xB2E5, 0xD2BE, 0xDEEE, 0xDEEB,
    0xCED5, 0xB4A7, 0xBFAB, 0xBEBE, 0xBDD2, 0xDEE9, 0xD4AE, 0xDEDE,
    0xDEEA, 0xC0BF, 0xDEEC, 0xB2F3, 0xB8E9, 0xC2A7, 0xBDC1, 0xDEF5,
    0xDEF8, 0xB2AB, 0xB4A4, 0xB4EA, 0xC9A6, 0xDEF6, 0xCBD1, 0xB8E3,
    0xDEF7, 0xDEFA, 0xDEF9, 0xCCC2, 0xB0E1, 0xB4EE, 0xE5BA, 0xD0AF,
    0xB2EB, 0xEBA1, 0xDEF4, 0xC9E3, 0xDEF3, 0xB0DA, 0xD2A1, 0xB1F7,
    0xCCAF, 0xDEF0, 0xCBA4, 0xD5AA, 0xDEFB, 0xB4DD, 0xC4A6, 0xDEFD,
    0xC3FE, 0xC4A1, 0xDFA1, 0xC1CC, 0xDEFC, 0xBEEF, 0xC6B2, 0xB3C5,
    0xC8F6, 0xCBBA, 0xDEFE, 0xDFA4, 0xD7B2, 0xB3B7, 0xC1C3, 0xC7CB,
    0xB2A5, 0xB4E9, 0xD7AB, 0xC4EC, 0xDFA2, 0xDFA3, 0xDFA5, 0xBAB3,
    0xDFA6, 0xC0DE, 0xC9C3, 0xB2D9, 0xC7E6, 0xDFA7, 0xC7DC, 0xDFA8,
    0xEBA2, 0xCBD3, 0xDFAA, 0xDFA9, 0xB2C1, 0xC5CA, 0xDFAB, 0xD4DC,
    0xC8C1, 0xDFAC, 0xBEF0, 0xDFAD, 0xD6A7, 0xEAB7, 0xEBB6, 0xCAD5,
    0xD8FC, 0xB8C4, 0xB9A5, 0xB7C5, 0xD5FE, 0xB9CA, 0xD0A7, 0xF4CD,
    0xB5D0, 0xC3F4, 0xBEC8, 0xEBB7, 0xB0BD, 0xBDCC, 0xC1B2, 0xB1D6,
    0xB3A8, 0xB8D2, 0xC9A2, 0xB6D8, 0xEBB8, 0xBEB4, 0xCAFD, 0xC7C3,
    0xD5FB, 0xB7F3, 0xCEC4, 0xD5AB, 0xB1F3, 0xECB3, 0xB0DF, 0xECB5,
    0xB6B7, 0xC1CF, 0xF5FA, 0xD0B1, 0xD5E5, 0xCED3, 0xBDEF, 0xB3E2,
    0xB8AB, 0xD5B6, 0xEDBD, 0xB6CF, 0xCBB9, 0xD0C2, 0xB7BD, 0xECB6,
    0xCAA9, 0xC5D4, 0xECB9, 0xECB8, 0xC2C3, 0xECB7, 0xD0FD, 0xECBA,
    0xECBB, 0xD7E5, 0xECBC, 0xECBD, 0xC6EC, 0xCEDE, 0xBCC8, 0xC8D5,
    0xB5A9, 0xBEC9, 0xD6BC, 0xD4E7, 0xD1AE, 0xD0F1, 0xEAB8, 0xEAB9,
    0xEABA, 0xBAB5, 0xCAB1, 0xBFF5, 0xCDFA, 0xEAC0, 0xB0BA, 0xEABE,
    0xC0A5, 0xEABB, 0xB2FD, 0xC3F7, 0xBBE8, 0xD2D7, 0xCEF4, 0xEABF,
    0xEABC, 0xEAC3, 0xD0C7, 0xD3B3, 0xB4BA, 0xC3C1, 0xD7F2, 0xD5D1,
    0xCAC7, 0xEAC5, 0xEAC4, 0xEAC7, 0xEAC6, 0xD6E7, 0xCFD4, 0xEACB,
    0xBBCE, 0xBDFA, 0xC9CE, 0xEACC, 0xC9B9, 0xCFFE, 0xEACA, 0xD4CE,
    0xEACD, 0xEACF, 0xCDED, 0xEAC9, 0xEACE, 0xCEEE, 0xBBDE, 0xB3BF,
    0xC6D5, 0xBEB0, 0xCEFA, 0xC7E7, 0xBEA7, 0xEAD0, 0xD6C7, 0xC1C0,
    0xD4DD, 0xEAD1, 0xCFBE, 0xEAD2, 0xCAEE, 0xC5AF, 0xB0B5, 0xEAD4,
    0xEAD3, 0xF4DF, 0xC4BA, 0xB1A9, 0xE5DF, 0xEAD5, 0xCAEF, 0xEAD6,
    0xEAD7, 0xC6D8, 0xEAD8, 0xEAD9, 0xD4BB, 0xC7FA, 0xD2B7, 0xB8FC,
    0xEAC2, 0xB2DC, 0xC2FC, 0xD4F8, 0xCCE6, 0xD7EE, 0xD4C2, 0xD3D0,
    0xEBC3, 0xC5F3, 0xB7FE, 0xEBD4, 0xCBB7, 0xEBDE, 0xC0CA, 0xCDFB,
    0xB3AF, 0xC6DA, 0xEBFC, 0xC4BE, 0xCEB4, 0xC4A9, 0xB1BE, 0xD4FD,
    0xCAF5, 0xD6EC, 0xC6D3, 0xB6E4, 0xBBFA, 0xD0E0, 0xC9B1, 0xD4D3,
    0xC8A8, 0xB8CB, 0xE8BE, 0xC9BC, 0xE8BB, 0xC0EE, 0xD0D3, 0xB2C4,
    0xB4E5, 0xE8BC, 0xD5C8, 0xB6C5, 0xE8BD, 0xCAF8, 0xB8DC, 0xCCF5,
    0xC0B4, 0xD1EE, 0xE8BF, 0xE8C2, 0xBABC, 0xB1AD, 0xBDDC, 0xEABD,
    0xE8C3, 0xE8C6, 0xE8CB, 0xE8CC, 0xCBC9, 0xB0E5, 0xBCAB, 0xB9B9,
    0xE8C1, 0xCDF7, 0xE8CA, 0xCEF6, 0xD5ED, 0xC1D6, 0xE8C4, 0xC3B6,
    0xB9FB, 0xD6A6, 0xE8C8, 0xCAE0, 0xD4E6, 0xE8C0, 0xE8C5, 0xE8C7,
    0xC7B9, 0xB7E3, 0xE8C9, 0xBFDD, 0xE8D2, 0xE8D7, 0xE8D5, 0xBCDC,
    0xBCCF, 0xE8DB, 0xE8DE, 0xE8DA, 0xB1FA, 0xB0D8, 0xC4B3, 0xB8CC,
    0xC6E2, 0xC8BE, 0xC8E1, 0xE8CF, 0xE8D4, 0xE8D6, 0xB9F1, 0xE8D8,
    0xD7F5, 0xC4FB, 0xE8DC, 0xB2E9, 0xE8D1, 0xBCED, 0xBFC2, 0xE8CD,
    0xD6F9, 0xC1F8, 0xB2F1, 0xE8DF, 0xCAC1, 0xE8D9, 0xD5A4, 0xB1EA,
    0xD5BB, 0xE8CE, 0xE8D0, 0xB6B0, 0xE8D3, 0xE8DD, 0xC0B8, 0xCAF7,
    0xCBA8, 0xC6DC, 0xC0F5, 0xE8E9, 0xD0A3, 0xE8F2, 0xD6EA, 0xE8E0,
    0xE8E1, 0xD1F9, 0xBACB, 0xB8F9, 0xB8F1, 0xD4D4, 0xE8EF, 0xE8EE,
    0xE8EC, 0xB9F0, 0xCCD2, 0xE8E6, 0xCEA6, 0xBFF2, 0xB0B8, 0xE8F1,
    0xE8F0, 0xD7C0, 0xE8E4, 0xCDA9, 0xC9A3, 0xBBB8, 0xBDDB, 0xE8EA,
    0xE8E2, 0xE8E3, 0xE8E5, 0xB5B5, 0xE8E7, 0xC7C5, 0xE8EB, 0xE8ED,
    0xBDB0, 0xD7AE, 0xE8F8, 0xE8F5, 0xCDB0, 0xE8F6, 0xC1BA, 0xE8E8,
    0xC3B7, 0xB0F0, 0xE8F4, 0xE8F7, 0xB9A3, 0xC9D2, 0xC3CE, 0xCEE0,
    0xC0E6, 0xCBF3, 0xCCDD, 0xD0B5, 0xCAE1, 0xE8F3, 0xBCEC, 0xE8F9,
    0xC3DE, 0xC6E5, 0xB9F7, 0xB0F4, 0xD7D8, 0xBCAC, 0xC5EF, 0xCCC4,
    0xE9A6, 0xC9AD, 0xE9A2, 0xC0E2, 0xBFC3, 0xE8FE, 0xB9D7, 0xE8FB,
    0xE9A4, 0xD2CE, 0xE9A3, 0xD6B2, 0xD7B5, 0xE9A7, 0xBDB7, 0xE8FC,
    0xE8FD, 0xE9A1, 0xCDD6, 0xD2AC, 0xE9B2, 0xE9A9, 0xB4AA, 0xB4BB,
    0xE9AB, 0xD0A8, 0xE9A5, 0xB3FE, 0xE9AC, 0xC0E3, 0xE9AA, 0xE9B9,
    0xE9B8, 0xE9AE, 0xE8FA, 0xE9A8, 0xBFAC, 0xE9B1, 0xE9BA, 0xC2A5,
    0xE9AF, 0xB8C5, 0xE9AD, 0xD3DC, 0xE9B4, 0xE9B5, 0xE9B7, 0xE9C7,
    0xC0C6, 0xE9C5, 0xE9B0, 0xE9BB, 0xB0F1, 0xE9BC, 0xD5A5, 0xE9BE,
    0xE9BF, 0xE9C1, 0xC1F1, 0xC8B6, 0xE9BD, 0xE9C2, 0xE9C3, 0xE9B3,
    0xE9B6, 0xBBB1, 0xE9C0, 0xBCF7, 0xE9C4, 0xE9C6, 0xE9CA, 0xE9CE,
    0xB2DB, 0xE9C8, 0xB7AE, 0xE9CB, 0xE9CC, 0xD5C1, 0xC4A3, 0xE9D8,
    0xBAE1, 0xE9C9, 0xD3A3, 0xE9D4, 0xE9D7, 0xE9D0, 0xE9CF, 0xC7C1,
    0xE9D2, 0xE9D9, 0xB3C8, 0xE9D3, 0xCFF0, 0xE9CD, 0xB3F7, 0xE9D6,
    0xE9DA, 0xCCB4, 0xCFAD, 0xE9D5, 0xE9DC, 0xE9DB, 0xE9DE, 0xE9D1,
    0xE9DD, 0xE9DF, 0xC3CA, 0xC7B7, 0xB4CE, 0xBBB6, 0xD0C0, 0xECA3,
    0xC5B7, 0xD3FB, 0xECA4, 0xECA5, 0xC6DB, 0xBFEE, 0xECA6, 0xECA7,
    0xD0AA, 0xC7B8, 0xB8E8, 0xECA8, 0xD6B9, 0xD5FD, 0xB4CB, 0xB2BD,
    0xCEE4, 0xC6E7, 0xCDE1, 0xB4F5, 0xCBC0, 0xBCDF, 0xE9E2, 0xE9E3,
    0xD1EA, 0xE9E5, 0xB4F9, 0xE9E4, 0xD1B3, 0xCAE2, 0xB2D0, 0xE9E8,
    0xE9E6, 0xE9E7, 0xD6B3, 0xE9E9, 0xE9EA, 0xE9EB, 0xE9EC, 0xECAF,
    0xC5B9, 0xB6CE, 0xD2F3, 0xB5EE, 0xBBD9, 0xECB1, 0xD2E3, 0xCEE3,
    0xC4B8, 0xC3BF, 0xB6BE, 0xD8B9, 0xB1C8, 0xB1CF, 0xB1D1, 0xC5FE,
    0xB1D0, 0xC3AB, 0xD5B1, 0xEBA4, 0xBAC1, 0xCCBA, 0xEBA5, 0xEBA7,
    0xEBA8, 0xEBA6, 0xEBA9, 0xEBAB, 0xEBAA, 0xEBAC, 0xCACF, 0xD8B5,
    0xC3F1, 0xC3A5, 0xC6F8, 0xEBAD, 0xC4CA, 0xEBAE, 0xEBAF, 0xEBB0,
    0xB7D5, 0xB7FA, 0xEBB1, 0xC7E2, 0xEBB3, 0xBAA4, 0xD1F5, 0xB0B1,
    0xEBB2, 0xEBB4, 0xB5AA, 0xC2C8, 0xC7E8, 0xEBB5, 0xCBAE, 0xE3DF,
    0xD3C0, 0xD9DB, 0xCDA1, 0xD6AD, 0xC7F3, 0xD9E0, 0xBBE3, 0xBABA,
    0xE3E2, 0xCFAB, 0xE3E0, 0xC9C7, 0xBAB9, 0xD1B4, 0xE3E1, 0xC8EA,
    0xB9AF, 0xBDAD, 0xB3D8, 0xCEDB, 0xCCC0, 0xE3E8, 0xE3E9, 0xCDF4,
    0xCCAD, 0xBCB3, 0xE3EA, 0xE3EB, 0xD0DA, 0xC6FB, 0xB7DA, 0xC7DF,
    0xD2CA, 0xCED6, 0xE3E4, 0xE3EC, 0xC9F2, 0xB3C1, 0xE3E7, 0xC6E3,
    0xE3E5, 0xEDB3, 0xE3E6, 0xC9B3, 0xC5E6, 0xB9B5, 0xC3BB, 0xE3E3,
    0xC5BD, 0xC1A4, 0xC2D9, 0xB2D7, 0xE3ED, 0xBBA6, 0xC4AD, 0xE3F0,
    0xBEDA, 0xE3FB, 0xE3F5, 0xBAD3, 0xB7D0, 0xD3CD, 0xD6CE, 0xD5D3,
    0xB9C1, 0xD5B4, 0xD1D8, 0xD0B9, 0xC7F6, 0xC8AA, 0xB2B4, 0xC3DA,
    0xE3EE, 0xE3FC, 0xE3EF, 0xB7A8, 0xE3F7, 0xE3F4, 0xB7BA, 0xC5A2,
    0xE3F6, 0xC5DD, 0xB2A8, 0xC6FC, 0xC4E0, 0xD7A2, 0xC0E1, 0xE3F9,
    0xE3FA, 0xE3FD, 0xCCA9, 0xE3F3, 0xD3BE, 0xB1C3, 0xEDB4, 0xE3F1,
    0xE3F2, 0xE3F8, 0xD0BA, 0xC6C3, 0xD4F3, 0xE3FE, 0xBDE0, 0xE4A7,
    0xE4A6, 0xD1F3, 0xE4A3, 0xE4A9, 0xC8F7, 0xCFB4, 0xE4A8, 0xE4AE,
    0xC2E5, 0xB6B4, 0xBDF2, 0xE4A2, 0xBAE9, 0xE4AA, 0xE4AC, 0xB6FD,
    0xD6DE, 0xE4B2, 0xE4AD, 0xE4A1, 0xBBEE, 0xCDDD, 0xC7A2, 0xC5C9,
    0xC1F7, 0xE4A4, 0xC7B3, 0xBDAC, 0xBDBD, 0xE4A5, 0xD7C7, 0xB2E2,
    0xE4AB, 0xBCC3, 0xE4AF, 0xBBEB, 0xE4B0, 0xC5A8, 0xE4B1, 0xD5E3,
    0xBFA3, 0xE4BA, 0xE4B7, 0xE4BB, 0xE4BD, 0xC6D6, 0xBAC6, 0xC0CB,
    0xB8A1, 0xE4B4, 0xD4A1, 0xBAA3, 0xBDFE, 0xE4BC, 0xCDBF, 0xC4F9,
    0xCFFB, 0xC9E6, 0xD3BF, 0xCFD1, 0xE4B3, 0xE4B8, 0xE4B9, 0xCCE9,
    0xCCCE, 0xC0D4, 0xE4B5, 0xC1B0, 0xE4B6, 0xCED0, 0xBBC1, 0xB5D3,
    0xC8F3, 0xBDA7, 0xD5C7, 0xC9AC, 0xB8A2, 0xE4CA, 0xE4CC, 0xD1C4,
    0xD2BA, 0xBAAD, 0xBAD4, 0xE4C3, 0xB5ED, 0xD7CD, 0xE4C0, 0xCFFD,
    0xE4BF, 0xC1DC, 0xCCCA, 0xCAE7, 0xC4D7, 0xCCD4, 0xE4C8, 0xE4C7,
    0xE4C1, 0xE4C4, 0xB5AD, 0xD3D9, 0xE4C6, 0xD2F9, 0xB4E3, 0xBBB4,
    0xC9EE, 0xB4BE, 0xBBEC, 0xD1CD, 0xCCED, 0xEDB5, 0xC7E5, 0xD4A8,
    0xE4CB, 0xD7D5, 0xE4C2, 0xBDA5, 0xE4C5, 0xD3E6, 0xE4C9, 0xC9F8,
    0xE4BE, 0xD3E5, 0xC7FE, 0xB6C9, 0xD4FC, 0xB2B3, 0xE4D7, 0xCEC2,
    0xE4CD, 0xCEBC, 0xB8DB, 0xE4D6, 0xBFCA, 0xD3CE, 0xC3EC, 0xC5C8,
    0xE4D8, 0xCDC4, 0xE4CF, 0xE4D4, 0xE4D5, 0xBAFE, 0xCFE6, 0xD5BF,
    0xE4D2, 0xE4D0, 0xE4CE, 0xCDE5, 0xCAAA, 0xC0A3, 0xBDA6, 0xE4D3,
    0xB8C8, 0xE4E7, 0xD4B4, 0xE4DB, 0xC1EF, 0xE4E9, 0xD2E7, 0xE4DF,
    0xE4E0, 0xCFAA, 0xCBDD, 0xE4DA, 0xE4D1, 0xE4E5, 0xC8DC, 0xE4E3,
    0xC4E7, 0xE4E2, 0xE4E1, 0xB3FC, 0xE4E8, 0xB5E1, 0xD7CC, 0xE4E6,
    0xBBAC, 0xD7D2, 0xCCCF, 0xEBF8, 0xE4E4, 0xB9F6, 0xD6CD, 0xE4D9,
    0xE4DC, 0xC2FA, 0xE4DE, 0xC2CB, 0xC0C4, 0xC2D0, 0xB1F5, 0xCCB2,
    0xB5CE, 0xE4EF, 0xC6AF, 0xC6E1, 0xE4F5, 0xC2A9, 0xC0EC, 0xD1DD,
    0xE4EE, 0xC4AE, 0xE4ED, 0xE4F6, 0xE4F4, 0xC2FE, 0xE4DD, 0xE4F0,
    0xCAFE, 0xD5C4, 0xE4F1, 0xD1FA, 0xE4EB, 0xE4EC, 0xE4F2, 0xCEAB,
    0xC5CB, 0xC7B1, 0xC2BA, 0xE4EA, 0xC1CA, 0xCCB6, 0xB3B1, 0xE4FB,
    0xE4F3, 0xE4FA, 0xE4FD, 0xE4FC, 0xB3CE, 0xB3BA, 0xE4F7, 0xE4F9,
    0xE4F8, 0xC5EC, 0xC0BD, 0xD4E8, 0xE5A2, 0xB0C4, 0xE5A4, 0xE5A3,
    0xBCA4, 0xE5A5, 0xE5A1, 0xE4FE, 0xB1F4, 0xE5A8, 0xE5A9, 0xE5A6,
    0xE5A7, 0xE5AA, 0xC6D9, 0xE5AB, 0xE5AD, 0xE5AC, 0xE5AF, 0xE5AE,
    0xB9E0, 0xE5B0, 0xE5B1, 0xBBF0, 0xECE1, 0xC3F0, 0xB5C6, 0xBBD2,
    0xC1E9, 0xD4EE, 0xBEC4, 0xD7C6, 0xD4D6, 0xB2D3, 0xECBE, 0xEAC1,
    0xC2AF, 0xB4B6, 0xD1D7, 0xB3B4, 0xC8B2, 0xBFBB, 0xECC0, 0xD6CB,
    0xECBF, 0xECC1, 0xECC5, 0xBEE6, 0xCCBF, 0xC5DA, 0xBEBC, 0xECC6,
    0xB1FE, 0xECC4, 0xD5A8, 0xB5E3, 0xECC2, 0xC1B6, 0xB3E3, 0xECC3,
    0xCBB8, 0xC0C3, 0xCCFE, 0xC1D2, 0xECC8, 0xBAE6, 0xC0D3, 0xD6F2,
    0xD1CC, 0xBFBE, 0xB7B3, 0xC9D5, 0xECC7, 0xBBE2, 0xCCCC, 0xBDFD,
    0xC8C8, 0xCFA9, 0xCDE9, 0xC5EB, 0xB7E9, 0xD1C9, 0xBAB8, 0xECC9,
    0xECCA, 0xBBC0, 0xECCB, 0xECE2, 0xB1BA, 0xB7D9, 0xBDB9, 0xECCC,
    0xD1E6, 0xECCD, 0xC8BB, 0xECD1, 0xECD3, 0xBBCD, 0xBCE5, 0xECCF,
    0xC9B7, 0xC3BA, 0xECE3, 0xD5D5, 0xECD0, 0xD6F3, 0xECD2, 0xECCE,
    0xECD4, 0xECD5, 0xC9BF, 0xCFA8, 0xD0DC, 0xD1AC, 0xC8DB, 0xECD6,
    0xCEF5, 0xCAEC, 0xECDA, 0xECD9, 0xB0BE, 0xECD7, 0xECD8, 0xECE4,
    0xC8BC, 0xC1C7, 0xECDC, 0xD1E0, 0xECDB, 0xD4EF, 0xECDD, 0xDBC6,
    0xECDE, 0xB1AC, 0xECDF, 0xECE0, 0xD7A6, 0xC5C0, 0xEBBC, 0xB0AE,
    0xBEF4, 0xB8B8, 0xD2AF, 0xB0D6, 0xB5F9, 0xD8B3, 0xCBAC, 0xE3DD,
    0xC6AC, 0xB0E6, 0xC5C6, 0xEBB9, 0xEBBA, 0xEBBB, 0xD1C0, 0xC5A3,
    0xEAF2, 0xC4B2, 0xC4B5, 0xC0CE, 0xEAF3, 0xC4C1, 0xCEEF, 0xEAF0,
    0xEAF4, 0xC9FC, 0xC7A3, 0xCCD8, 0xCEFE, 0xEAF5, 0xEAF6, 0xCFAC,
    0xC0E7, 0xEAF7, 0xB6BF, 0xEAF8, 0xEAF9, 0xEAFA, 0xEAFB, 0xEAF1,
    0xC8AE, 0xE1EB, 0xB7B8, 0xE1EC, 0xE1ED, 0xD7B4, 0xE1EE, 0xE1EF,
    0xD3CC, 0xE1F1, 0xBFF1, 0xE1F0, 0xB5D2, 0xB1B7, 0xE1F3, 0xE1F2,
    0xBAFC, 0xE1F4, 0xB9B7, 0xBED1, 0xC4FC, 0xBADD, 0xBDC6, 0xE1F5,
    0xE1F7, 0xB6C0, 0xCFC1, 0xCAA8, 0xE1F6, 0xD5F8, 0xD3FC, 0xE1F8,
    0xE1FC, 0xE1F9, 0xE1FA, 0xC0EA, 0xE1FE, 0xE2A1, 0xC0C7, 0xE1FB,
    0xE1FD, 0xE2A5, 0xC1D4, 0xE2A3, 0xE2A8, 0xB2FE, 0xE2A2, 0xC3CD,
    0xB2C2, 0xE2A7, 0xE2A6, 0xE2A4, 0xE2A9, 0xE2AB, 0xD0C9, 0xD6ED,
    0xC3A8, 0xE2AC, 0xCFD7, 0xE2AE, 0xBAEF, 0xE9E0, 0xE2AD, 0xE2AA,
    0xBBAB, 0xD4B3, 0xE2B0, 0xE2AF, 0xE9E1, 0xE2B1, 0xE2B2, 0xE2B3,
    0xCCA1, 0xE2B4, 0xE2B5, 0xD0FE, 0xC2CA, 0xD3F1, 0xCDF5, 0xE7E0,
    0xE7E1, 0xBEC1, 0xC2EA, 0xE7E4, 0xE7E3, 0xCDE6, 0xC3B5, 0xE7E2,
    0xBBB7, 0xCFD6, 0xC1E1, 0xE7E9, 0xE7E8, 0xE7F4, 0xB2A3, 0xE7EA,
    0xE7E6, 0xE7EC, 0xE7EB, 0xC9BA, 0xD5E4, 0xE7E5, 0xB7A9, 0xE7E7,
    0xE7EE, 0xE7F3, 0xD6E9, 0xE7ED, 0xE7F2, 0xE7F1, 0xB0E0, 0xE7F5,
    0xC7F2, 0xC0C5, 0xC0ED, 0xC1F0, 0xE7F0, 0xE7F6, 0xCBF6, 0xE8A2,
    0xE8A1, 0xD7C1, 0xE7FA, 0xE7F9, 0xE7FB, 0xE7F7, 0xE7FE, 0xE7FD,
    0xE7FC, 0xC1D5, 0xC7D9, 0xC5FD, 0xC5C3, 0xC7ED, 0xE8A3, 0xE8A6,
    0xE8A5, 0xE8A7, 0xBAF7, 0xE7F8, 0xE8A4, 0xC8F0, 0xC9AA, 0xE8A9,
    0xB9E5, 0xD1FE, 0xE8A8, 0xE8AA, 0xE8AD, 0xE8AE, 0xC1A7, 0xE8AF,
    0xE8B0, 0xE8AC, 0xE8B4, 0xE8AB, 0xE8B1, 0xE8B5, 0xE8B2, 0xE8B3,
    0xE8B7, 0xE8B6, 0xB9CF, 0xF0AC, 0xF0AD, 0xC6B0, 0xB0EA, 0xC8BF,
    0xCDDF, 0xCECD, 0xEAB1, 0xEAB2, 0xC6BF, 0xB4C9, 0xEAB3, 0xD5E7,
    0xDDF9, 0xEAB4, 0xEAB5, 0xEAB6, 0xB8CA, 0xDFB0, 0xC9F5, 0xCCF0,
    0xC9FA, 0xC9FB, 0xD3C3, 0xCBA6, 0xB8A6, 0xF0AE, 0xB1C2, 0xE5B8,
    0xCCEF, 0xD3C9, 0xBCD7, 0xC9EA, 0xB5E7, 0xC4D0, 0xB5E9, 0xEEAE,
    0xBBAD, 0xE7DE, 0xEEAF, 0xB3A9, 0xEEB2, 0xEEB1, 0xBDE7, 0xEEB0,
    0xCEB7, 0xC5CF, 0xC1F4, 0xDBCE, 0xEEB3, 0xD0F3, 0xC2D4, 0xC6E8,
    0xB7AC, 0xEEB4, 0xB3EB, 0xBBFB, 0xEEB5, 0xE7DC, 0xEEB6, 0xBDAE,
    0xF1E2, 0xCAE8, 0xD2C9, 0xF0DA, 0xF0DB, 0xF0DC, 0xC1C6, 0xB8ED,
    0xBECE, 0xF0DE, 0xC5B1, 0xF0DD, 0xD1F1, 0xF0E0, 0xB0CC, 0xBDEA,
    0xD2DF, 0xF0DF, 0xB4AF, 0xB7E8, 0xF0E6, 0xF0E5, 0xC6A3, 0xF0E1,
    0xF0E2, 0xB4C3, 0xF0E3, 0xD5EE, 0xCCDB, 0xBED2, 0xBCB2, 0xF0E8,
    0xF0E7, 0xF0E4, 0xB2A1, 0xD6A2, 0xD3B8, 0xBEB7, 0xC8AC, 0xF0EA,
    0xD1F7, 0xD6CC, 0xBADB, 0xF0E9, 0xB6BB, 0xCDB4, 0xC6A6, 0xC1A1,
    0xF0EB, 0xF0EE, 0xF0ED, 0xF0F0, 0xF0EC, 0xBBBE, 0xF0EF, 0xCCB5,
    0xF0F2, 0xB3D5, 0xB1D4, 0xF0F3, 0xF0F4, 0xF0F6, 0xB4E1, 0xF0F1,
    0xF0F7, 0xF0FA, 0xF0F8, 0xF0F5, 0xF0FD, 0xF0F9, 0xF0FC, 0xF0FE,
    0xF1A1, 0xCEC1, 0xF1A4, 0xF1A3, 0xC1F6, 0xF0FB, 0xCADD, 0xB4F1,
    0xB1F1, 0xCCB1, 0xF1A6, 0xF1A7, 0xF1AC, 0xD5CE, 0xF1A9, 0xC8B3,
    0xF1A2, 0xF1AB, 0xF1A8, 0xF1A5, 0xF1AA, 0xB0A9, 0xF1AD, 0xF1AF,
    0xF1B1, 0xF1B0, 0xF1AE, 0xD1A2, 0xF1B2, 0xF1B3, 0xB9EF, 0xB5C7,
    0xB0D7, 0xB0D9, 0xD4ED, 0xB5C4, 0xBDD4, 0xBBCA, 0xF0A7, 0xB8DE,
    0xF0A8, 0xB0A8, 0xF0A9, 0xCDEE, 0xF0AA, 0xF0AB, 0xC6A4, 0xD6E5,
    0xF1E4, 0xF1E5, 0xC3F3, 0xD3DB, 0xD6D1, 0xC5E8, 0xD3AF, 0xD2E6,
    0xEEC1, 0xB0BB, 0xD5B5, 0xD1CE, 0xBCE0, 0xBAD0, 0xBFF8, 0xB8C7,
    0xB5C1, 0xC5CC, 0xCAA2, 0xC3CB, 0xEEC2, 0xC4BF, 0xB6A2, 0xEDEC,
    0xC3A4, 0xD6B1, 0xCFE0, 0xEDEF, 0xC5CE, 0xB6DC, 0xCAA1, 0xEDED,
    0xEDF0, 0xEDF1, 0xC3BC, 0xBFB4, 0xEDEE, 0xEDF4, 0xEDF2, 0xD5E6,
    0xC3DF, 0xEDF3, 0xEDF6, 0xD5A3, 0xD1A3, 0xEDF5, 0xC3D0, 0xEDF7,
    0xBFF4, 0xBEEC, 0xEDF8, 0xCCF7, 0xD1DB, 0xD7C5, 0xD5F6, 0xEDFC,
    0xEDFB, 0xEDF9, 0xEDFA, 0xEDFD, 0xBEA6, 0xCBAF, 0xEEA1, 0xB6BD,
    0xEEA2, 0xC4C0, 0xEDFE, 0xBDDE, 0xB2C7, 0xB6C3, 0xEEA5, 0xD8BA,
    0xEEA3, 0xEEA6, 0xC3E9, 0xB3F2, 0xEEA7, 0xEEA4, 0xCFB9, 0xEEA8,
    0xC2F7, 0xEEA9, 0xEEAA, 0xDEAB, 0xC6B3, 0xC7C6, 0xD6F5, 0xB5C9,
    0xCBB2, 0xEEAB, 0xCDAB, 0xEEAC, 0xD5B0, 0xEEAD, 0xF6C4, 0xDBC7,
    0xB4A3, 0xC3AC, 0xF1E6, 0xCAB8, 0xD2D3, 0xD6AA, 0xEFF2, 0xBED8,
    0xBDC3, 0xEFF3, 0xB6CC, 0xB0AB, 0xCAAF, 0xEDB6, 0xEDB7, 0xCEF9,
    0xB7AF, 0xBFF3, 0xEDB8, 0xC2EB, 0xC9B0, 0xEDB9, 0xC6F6, 0xBFB3,
    0xEDBC, 0xC5F8, 0xD1D0, 0xD7A9, 0xEDBA, 0xEDBB, 0xD1E2, 0xEDBF,
    0xEDC0, 0xEDC4, 0xEDC8, 0xEDC6, 0xEDCE, 0xD5E8, 0xEDC9, 0xEDC7,
    0xEDBE, 0xC5E9, 0xC6C6, 0xC9E9, 0xD4D2, 0xEDC1, 0xEDC2, 0xEDC3,
    0xEDC5, 0xC0F9, 0xB4A1, 0xB9E8, 0xEDD0, 0xEDD1, 0xEDCA, 0xEDCF,
    0xCEF8, 0xCBB6, 0xEDCC, 0xEDCD, 0xCFF5, 0xEDD2, 0xC1F2, 0xD3B2,
    0xEDCB, 0xC8B7, 0xBCEF, 0xC5F0, 0xEDD6, 0xB5EF, 0xC2B5, 0xB0AD,
    0xCBE9, 0xB1AE, 0xEDD4, 0xCDEB, 0xB5E2, 0xEDD5, 0xEDD3, 0xEDD7,
    0xB5FA, 0xEDD8, 0xEDD9, 0xEDDC, 0xB1CC, 0xC5F6, 0xBCEE, 0xEDDA,
    0xCCBC, 0xB2EA, 0xEDDB, 0xC4EB, 0xB4C5, 0xB0F5, 0xEDDF, 0xC0DA,
    0xB4E8, 0xC5CD, 0xEDDD, 0xBFC4, 0xEDDE, 0xC4A5, 0xEDE0, 0xEDE1,
    0xEDE3, 0xC1D7, 0xBBC7, 0xBDB8, 0xEDE2, 0xEDE4, 0xEDE6, 0xEDE5,
    0xEDE7, 0xCABE, 0xECEA, 0xC0F1, 0xC9E7, 0xECEB, 0xC6EE, 0xECEC,
    0xC6ED, 0xECED, 0xECF0, 0xD7E6, 0xECF3, 0xECF1, 0xECEE, 0xECEF,
    0xD7A3, 0xC9F1, 0xCBEE, 0xECF4, 0xECF2, 0xCFE9, 0xECF6, 0xC6B1,
    0xBCC0, 0xECF5, 0xB5BB, 0xBBF6, 0xECF7, 0xD9F7, 0xBDFB, 0xC2BB,
    0xECF8, 0xECF9, 0xB8A3, 0xECFA, 0xECFB, 0xECFC, 0xD3ED, 0xD8AE,
    0xC0EB, 0xC7DD, 0xBACC, 0xD0E3, 0xCBBD, 0xCDBA, 0xB8D1, 0xB1FC,
    0xC7EF, 0xD6D6, 0xBFC6, 0xC3EB, 0xEFF5, 0xC3D8, 0xD7E2, 0xEFF7,
    0xB3D3, 0xC7D8, 0xD1ED, 0xD6C8, 0xEFF8, 0xEFF6, 0xBBFD, 0xB3C6,
    0xBDD5, 0xD2C6, 0xBBE0, 0xCFA1, 0xEFFC, 0xEFFB, 0xEFF9, 0xB3CC,
    0xC9D4, 0xCBB0, 0xEFFE, 0xB0DE, 0xD6C9, 0xEFFD, 0xB3ED, 0xF6D5,
    0xCEC8, 0xF0A2, 0xF0A1, 0xB5BE, 0xBCDA, 0xBBFC, 0xB8E5, 0xC4C2,
    0xF0A3, 0xCBEB, 0xF0A6, 0xD1A8, 0xBEBF, 0xC7EE, 0xF1B6, 0xF1B7,
    0xBFD5, 0xB4A9, 0xF1B8, 0xCDBB, 0xC7D4, 0xD5AD, 0xF1B9, 0xF1BA,
    0xC7CF, 0xD2A4, 0xD6CF, 0xF1BB, 0xBDD1, 0xB4B0, 0xBEBD, 0xB4DC,
    0xCED1, 0xBFDF, 0xF1BD, 0xBFFA, 0xF1BC, 0xF1BF, 0xF1BE, 0xF1C0,
    0xF1C1, 0xC1FE, 0xC1A2, 0xCAFA, 0xD5BE, 0xBEBA, 0xBEB9, 0xD5C2,
    0xBFA2, 0xCDAF, 0xF1B5, 0xBDDF, 0xB6CB, 0xD6F1, 0xF3C3, 0xF3C4,
    0xB8CD, 0xF3C6, 0xF3C7, 0xB0CA, 0xF3C5, 0xF3C9, 0xCBF1, 0xF3CB,
    0xD0A6, 0xB1CA, 0xF3C8, 0xF3CF, 0xB5D1, 0xF3D7, 0xF3D2, 0xF3D4,
    0xF3D3, 0xB7FB, 0xB1BF, 0xF3CE, 0xF3CA, 0xB5DA, 0xF3D0, 0xF3D1,
    0xF3D5, 0xF3CD, 0xBCE3, 0xC1FD, 0xF3D6, 0xF3DA, 0xF3CC, 0xB5C8,
    0xBDEE, 0xF3DC, 0xB7A4, 0xBFF0, 0xD6FE, 0xCDB2, 0xB4F0, 0xB2DF,
    0xF3D8, 0xF3D9, 0xC9B8, 0xF3DD, 0xF3DE, 0xF3E1, 0xF3DF, 0xF3E3,
    0xF3E2, 0xF3DB, 0xBFEA, 0xB3EF, 0xF3E0, 0xC7A9, 0xBCF2, 0xF3EB,
    0xB9BF, 0xF3E4, 0xB2AD, 0xBBFE, 0xCBE3, 0xF3ED, 0xF3E9, 0xB9DC,
    0xF3EE, 0xF3E5, 0xF3E6, 0xF3EA, 0xC2E1, 0xF3EC, 0xF3EF, 0xF3E8,
    0xBCFD, 0xCFE4, 0xF3F0, 0xF3E7, 0xF3F2, 0xD7AD, 0xC6AA, 0xF3F3,
    0xF3F1, 0xC2A8, 0xB8DD, 0xF3F5, 0xF3F4, 0xB4DB, 0xF3F6, 0xF3F7,
    0xF3F8, 0xC0BA, 0xC0E9, 0xC5F1, 0xF3FB, 0xF3FA, 0xB4D8, 0xF3FE,
    0xF3F9, 0xF3FC, 0xF3FD, 0xF4A1, 0xF4A3, 0xBBC9, 0xF4A2, 0xF4A4,
    0xB2BE, 0xF4A6, 0xF4A5, 0xBCAE, 0xC3D7, 0xD9E1, 0xC0E0, 0xF4CC,
    0xD7D1, 0xB7DB, 0xF4CE, 0xC1A3, 0xC6C9, 0xB4D6, 0xD5B3, 0xF4D0,
    0xF4CF, 0xF4D1, 0xCBDA, 0xF4D2, 0xD4C1, 0xD6E0, 0xB7E0, 0xC1B8,
    0xC1BB, 0xF4D3, 0xBEAC, 0xB4E2, 0xF4D4, 0xF4D5, 0xBEAB, 0xF4D6,
    0xF4DB, 0xF4D7, 0xF4DA, 0xBAFD, 0xF4D8, 0xF4D9, 0xB8E2, 0xCCC7,
    0xF4DC, 0xB2DA, 0xC3D3, 0xD4E3, 0xBFB7, 0xF4DD, 0xC5B4, 0xF4E9,
    0xCFB5, 0xCEC9, 0xCBD8, 0xCBF7, 0xBDF4, 0xD7CF, 0xC0DB, 0xD0F5,
    0xF4EA, 0xF4EB, 0xF4EC, 0xF7E3, 0xB7B1, 0xF4ED, 0xD7EB, 0xF4EE,
    0xE6F9, 0xBEC0, 0xE6FA, 0xBAEC, 0xE6FB, 0xCFCB, 0xE6FC, 0xD4BC,
    0xBCB6, 0xE6FD, 0xE6FE, 0xBCCD, 0xC8D2, 0xCEB3, 0xE7A1, 0xB4BF,
    0xE7A2, 0xC9B4, 0xB8D9, 0xC4C9, 0xD7DD, 0xC2DA, 0xB7D7, 0xD6BD,
    0xCEC6, 0xB7C4, 0xC5A6, 0xE7A3, 0xCFDF, 0xE7A4, 0xE7A5, 0xE7A6,
    0xC1B7, 0xD7E9, 0xC9F0, 0xCFB8, 0xD6AF, 0xD6D5, 0xE7A7, 0xB0ED,
    0xE7A8, 0xE7A9, 0xC9DC, 0xD2EF, 0xBEAD, 0xE7AA, 0xB0F3, 0xC8DE,
    0xBDE1, 0xE7AB, 0xC8C6, 0xE7AC, 0xBBE6, 0xB8F8, 0xD1A4, 0xE7AD,
    0xC2E7, 0xBEF8, 0xBDCA, 0xCDB3, 0xE7AE, 0xE7AF, 0xBEEE, 0xD0E5,
    0xCBE7, 0xCCD0, 0xBCCC, 0xE7B0, 0xBCA8, 0xD0F7, 0xE7B1, 0xD0F8,
    0xE7B2, 0xE7B3, 0xB4C2, 0xE7B4, 0xE7B5, 0xC9FE, 0xCEAC, 0xC3E0,
    0xE7B7, 0xB1C1, 0xB3F1, 0xE7B8, 0xE7B9, 0xD7DB, 0xD5C0, 0xE7BA,
    0xC2CC, 0xD7BA, 0xE7BB, 0xE7BC, 0xE7BD, 0xBCEA, 0xC3E5, 0xC0C2,
    0xE7BE, 0xE7BF, 0xBCA9, 0xE7C0, 0xE7C1, 0xE7B6, 0xB6D0, 0xE7C2,
    0xE7C3, 0xE7C4, 0xBBBA, 0xB5DE, 0xC2C6, 0xB1E0, 0xE7C5, 0xD4B5,
    0xE7C6, 0xB8BF, 0xE7C8, 0xE7C7, 0xB7EC, 0xE7C9, 0xB2F8, 0xE7CA,
    0xE7CB, 0xE7CC, 0xE7CD, 0xE7CE, 0xE7CF, 0xE7D0, 0xD3A7, 0xCBF5,
    0xE7D1, 0xE7D2, 0xE7D3, 0xE7D4, 0xC9C9, 0xE7D5, 0xE7D6, 0xE7D7,
    0xE7D8, 0xE7D9, 0xBDC9, 0xE7DA, 0xF3BE, 0xB8D7, 0xC8B1, 0xF3BF,
    0xF3C0, 0xF3C1, 0xB9DE, 0xCDF8, 0xD8E8, 0xBAB1, 0xC2DE, 0xEEB7,
    0xB7A3, 0xEEB9, 0xEEB8, 0xB0D5, 0xEEBB, 0xD5D6, 0xD7EF, 0xD6C3,
    0xEEBD, 0xCAF0, 0xEEBC, 0xEEBE, 0xEEC0, 0xEEBF, 0xD1F2, 0xC7BC,
    0xC3C0, 0xB8E1, 0xC1E7, 0xF4C6, 0xD0DF, 0xF4C7, 0xCFDB, 0xC8BA,
    0xF4C8, 0xF4C9, 0xF4CA, 0xF4CB, 0xD9FA, 0xB8FE, 0xE5F1, 0xD3F0,
    0xF4E0, 0xCECC, 0xB3E1, 0xF1B4, 0xD2EE, 0xF4E1, 0xCFE8, 0xF4E2,
    0xC7CC, 0xB5D4, 0xB4E4, 0xF4E4, 0xF4E3, 0xF4E5, 0xF4E6, 0xF4E7,
    0xBAB2, 0xB0BF, 0xF4E8, 0xB7AD, 0xD2ED, 0xD2AB, 0xC0CF, 0xBFBC,
    0xEBA3, 0xD5DF, 0xEAC8, 0xF1F3, 0xB6F8, 0xCBA3, 0xC4CD, 0xF1E7,
    0xF1E8, 0xB8FB, 0xF1E9, 0xBAC4, 0xD4C5, 0xB0D2, 0xF1EA, 0xF1EB,
    0xF1EC, 0xF1ED, 0xF1EE, 0xF1EF, 0xF1F1, 0xF1F0, 0xC5D5, 0xF1F2,
    0xB6FA, 0xF1F4, 0xD2AE, 0xDEC7, 0xCBCA, 0xB3DC, 0xB5A2, 0xB9A2,
    0xC4F4, 0xF1F5, 0xF1F6, 0xC1C4, 0xC1FB, 0xD6B0, 0xF1F7, 0xF1F8,
    0xC1AA, 0xC6B8, 0xBEDB, 0xF1F9, 0xB4CF, 0xF1FA, 0xEDB2, 0xEDB1,
    0xCBE0, 0xD2DE, 0xCBC1, 0xD5D8, 0xC8E2, 0xC0DF, 0xBCA1, 0xEBC1,
    0xD0A4, 0xD6E2, 0xB6C7, 0xB8D8, 0xEBC0, 0xB8CE, 0xEBBF, 0xB3A6,
    0xB9C9, 0xD6AB, 0xB7F4, 0xB7CA, 0xBCE7, 0xB7BE, 0xEBC6, 0xEBC7,
    0xB0B9, 0xBFCF, 0xEBC5, 0xD3FD, 0xEBC8, 0xEBC9, 0xB7CE, 0xEBC2,
    0xEBC4, 0xC9F6, 0xD6D7, 0xD5CD, 0xD0B2, 0xEBCF, 0xCEB8, 0xEBD0,
    0xB5A8, 0xB1B3, 0xEBD2, 0xCCA5, 0xC5D6, 0xEBD3, 0xEBD1, 0xC5DF,
    0xEBCE, 0xCAA4, 0xEBD5, 0xB0FB, 0xBAFA, 0xD8B7, 0xF1E3, 0xEBCA,
    0xEBCB, 0xEBCC, 0xEBCD, 0xEBD6, 0xE6C0, 0xEBD9, 0xBFE8, 0xD2C8,
    0xEBD7, 0xEBDC, 0xB8EC, 0xEBD8, 0xBDBA, 0xD0D8, 0xB0B7, 0xEBDD,
    0xC4DC, 0xD6AC, 0xB4E0, 0xC2F6, 0xBCB9, 0xEBDA, 0xEBDB, 0xD4E0,
    0xC6EA, 0xC4D4, 0xEBDF, 0xC5A7, 0xD9F5, 0xB2B1, 0xEBE4, 0xBDC5,
    0xEBE2, 0xEBE3, 0xB8AC, 0xCDD1, 0xEBE5, 0xEBE1, 0xC1B3, 0xC6A2,
    0xCCF3, 0xEBE6, 0xC0B0, 0xD2B8, 0xEBE7, 0xB8AF, 0xB8AD, 0xEBE8,
    0xC7BB, 0xCDF3, 0xEBEA, 0xEBEB, 0xEBED, 0xD0C8, 0xEBF2, 0xEBEE,
    0xEBF1, 0xC8F9, 0xD1FC, 0xEBEC, 0xEBE9, 0xB8B9, 0xCFD9, 0xC4E5,
    0xEBEF, 0xEBF0, 0xCCDA, 0xCDC8, 0xB0F2, 0xEBF6, 0xEBF5, 0xB2B2,
    0xB8E0, 0xEBF7, 0xB1EC, 0xCCC5, 0xC4A4, 0xCFA5, 0xEBF9, 0xECA2,
    0xC5F2, 0xEBFA, 0xC9C5, 0xE2DF, 0xEBFE, 0xCDCE, 0xECA1, 0xB1DB,
    0xD3B7, 0xD2DC, 0xEBFD, 0xEBFB, 0xB3BC, 0xEAB0, 0xD7D4, 0xF4AB,
    0xB3F4, 0xD6C1, 0xD6C2, 0xD5E9, 0xBECA, 0xF4A7, 0xD2A8, 0xF4A8,
    0xF4A9, 0xF4AA, 0xBECB, 0xD3DF, 0xC9E0, 0xC9E1, 0xF3C2, 0xCAE6,
    0xCCF2, 0xE2B6, 0xCBB4, 0xCEE8, 0xD6DB, 0xF4AD, 0xF4AE, 0xF4AF,
    0xF4B2, 0xBABD, 0xF4B3, 0xB0E3, 0xF4B0, 0xF4B1, 0xBDA2, 0xB2D5,
    0xF4B6, 0xF4B7, 0xB6E6, 0xB2B0, 0xCFCF, 0xF4B4, 0xB4AC, 0xF4B5,
    0xF4B8, 0xF4B9, 0xCDA7, 0xF4BA, 0xF4BB, 0xF4BC, 0xCBD2, 0xF4BD,
    0xF4BE, 0xF4BF, 0xF4DE, 0xC1BC, 0xBCE8, 0xC9AB, 0xD1DE, 0xE5F5,
    0xDCB3, 0xD2D5, 0xDCB4, 0xB0AC, 0xDCB5, 0xBDDA, 0xDCB9, 0xD8C2,
    0xDCB7, 0xD3F3, 0xC9D6, 0xDCBA, 0xDCB6, 0xDCBB, 0xC3A2, 0xDCBC,
    0xDCC5, 0xDCBD, 0xCEDF, 0xD6A5, 0xDCCF, 0xDCCD, 0xDCD2, 0xBDE6,
    0xC2AB, 0xDCB8, 0xDCCB, 0xDCCE, 0xDCBE, 0xB7D2, 0xB0C5, 0xDCC7,
    0xD0BE, 0xDCC1, 0xBBA8, 0xB7BC, 0xDCCC, 0xDCC6, 0xDCBF, 0xC7DB,
    0xD1BF, 0xDCC0, 0xDCCA, 0xDCD0, 0xCEAD, 0xDCC2, 0xDCC3, 0xDCC8,
    0xDCC9, 0xB2D4, 0xDCD1, 0xCBD5, 0xD4B7, 0xDCDB, 0xDCDF, 0xCCA6,
    0xDCE6, 0xC3E7, 0xDCDC, 0xBFC1, 0xDCD9, 0xB0FA, 0xB9B6, 0xDCE5,
    0xDCD3, 0xDCC4, 0xDCD6, 0xC8F4, 0xBFE0, 0xC9BB, 0xB1BD, 0xD3A2,
    0xDCDA, 0xDCD5, 0xC6BB, 0xDCDE, 0xD7C2, 0xC3AF, 0xB7B6, 0xC7D1,
    0xC3A9, 0xDCE2, 0xDCD8, 0xDCEB, 0xDCD4, 0xDCDD, 0xBEA5, 0xDCD7,
    0xDCE0, 0xDCE3, 0xDCE4, 0xDCF8, 0xDCE1, 0xDDA2, 0xDCE7, 0xBCEB,
    0xB4C4, 0xC3A3, 0xB2E7, 0xDCFA, 0xDCF2, 0xDCEF, 0xDCFC, 0xDCEE,
    0xD2F0, 0xB2E8, 0xC8D7, 0xC8E3, 0xDCFB, 0xDCED, 0xDCF7, 0xDCF5,
    0xBEA3, 0xDCF4, 0xB2DD, 0xDCF3, 0xBCF6, 0xDCE8, 0xBBC4, 0xC0F3,
    0xBCD4, 0xDCE9, 0xDCEA, 0xDCF1, 0xDCF6, 0xDCF9, 0xB5B4, 0xC8D9,
    0xBBE7, 0xDCFE, 0xDCFD, 0xD3AB, 0xDDA1, 0xDDA3, 0xDDA5, 0xD2F1,
    0xDDA4, 0xDDA6, 0xDDA7, 0xD2A9, 0xBAC9, 0xDDA9, 0xDDB6, 0xDDB1,
    0xDDB4, 0xDDB0, 0xC6CE, 0xC0F2, 0xC9AF, 0xDCEC, 0xDDAE, 0xDDB7,
    0xDCF0, 0xDDAF, 0xDDB8, 0xDDAC, 0xDDB9, 0xDDB3, 0xDDAD, 0xC4AA,
    0xDDA8, 0xC0B3, 0xC1AB, 0xDDAA, 0xDDAB, 0xDDB2, 0xBBF1, 0xDDB5,
    0xD3A8, 0xDDBA, 0xDDBB, 0xC3A7, 0xDDD2, 0xDDBC, 0xDDD1, 0xB9BD,
    0xBED5, 0xBEFA, 0xBACA, 0xDDCA, 0xDDC5, 0xDDBF, 0xB2CB, 0xDDC3,
    0xDDCB, 0xB2A4, 0xDDD5, 0xDDBE, 0xC6D0, 0xDDD0, 0xDDD4, 0xC1E2,
    0xB7C6, 0xDDCE, 0xDDCF, 0xDDC4, 0xDDBD, 0xDDCD, 0xCCD1, 0xDDC9,
    0xDDC2, 0xC3C8, 0xC6BC, 0xCEAE, 0xDDCC, 0xDDC8, 0xDDC1, 0xDDC6,
    0xC2DC, 0xD3A9, 0xD3AA, 0xDDD3, 0xCFF4, 0xC8F8, 0xDDE6, 0xDDC7,
    0xDDE0, 0xC2E4, 0xDDE1, 0xDDD7, 0xD6F8, 0xDDD9, 0xDDD8, 0xB8F0,
    0xDDD6, 0xC6CF, 0xB6AD, 0xDDE2, 0xBAF9, 0xD4E1, 0xDDE7, 0xB4D0,
    0xDDDA, 0xBFFB, 0xDDE3, 0xDDDF, 0xDDDD, 0xB5D9, 0xDDDB, 0xDDDC,
    0xDDDE, 0xBDAF, 0xDDE4, 0xDDE5, 0xDDF5, 0xC3C9, 0xCBE2, 0xDDF2,
    0xD8E1, 0xC6D1, 0xDDF4, 0xD5F4, 0xDDF3, 0xDDF0, 0xDDEC, 0xDDEF,
    0xDDE8, 0xD0EE, 0xC8D8, 0xDDEE, 0xDDE9, 0xDDEA, 0xCBF2, 0xDDED,
    0xB1CD, 0xC0B6, 0xBCBB, 0xDDF1, 0xDDF7, 0xDDF6, 0xDDEB, 0xC5EE,
    0xDDFB, 0xDEA4, 0xDEA3, 0xDDF8, 0xC3EF, 0xC2FB, 0xD5E1, 0xCEB5,
    0xDDFD, 0xB2CC, 0xC4E8, 0xCADF, 0xC7BE, 0xDDFA, 0xDDFC, 0xDDFE,
    0xDEA2, 0xB0AA, 0xB1CE, 0xDEAC, 0xDEA6, 0xBDB6, 0xC8EF, 0xDEA1,
    0xDEA5, 0xDEA9, 0xDEA8, 0xDEA7, 0xDEAD, 0xD4CC, 0xDEB3, 0xDEAA,
    0xDEAE, 0xC0D9, 0xB1A1, 0xDEB6, 0xDEB1, 0xDEB2, 0xD1A6, 0xDEB5,
    0xDEAF, 0xDEB0, 0xD0BD, 0xDEB4, 0xCAED, 0xDEB9, 0xDEB8, 0xDEB7,
    0xDEBB, 0xBDE5, 0xB2D8, 0xC3EA, 0xDEBA, 0xC5BA, 0xDEBC, 0xCCD9,
    0xB7AA, 0xD4E5, 0xDEBD, 0xDEBF, 0xC4A2, 0xDEC1, 0xDEBE, 0xDEC0,
    0xD5BA, 0xDEC2, 0xF2AE, 0xBBA2, 0xC2B2, 0xC5B0, 0xC2C7, 0xF2AF,
    0xD0E9, 0xD3DD, 0xEBBD, 0xB3E6, 0xF2B0, 0xF2B1, 0xCAAD, 0xBAE7,
    0xF2B3, 0xF2B5, 0xF2B4, 0xCBE4, 0xCFBA, 0xF2B2, 0xCAB4, 0xD2CF,
    0xC2EC, 0xCEC3, 0xF2B8, 0xB0F6, 0xF2B7, 0xF2BE, 0xB2CF, 0xD1C1,
    0xF2BA, 0xF2BC, 0xD4E9, 0xF2BB, 0xF2B6, 0xF2BF, 0xF2BD, 0xF2B9,
    0xF2C7, 0xF2C4, 0xF2C6, 0xF2CA, 0xF2C2, 0xF2C0, 0xF2C5, 0xD6FB,
    0xF2C1, 0xC7F9, 0xC9DF, 0xF2C8, 0xB9C6, 0xB5B0, 0xF2C3, 0xF2C9,
    0xF2D0, 0xF2D6, 0xBBD7, 0xF2D5, 0xCDDC, 0xD6EB, 0xF2D2, 0xF2D4,
    0xB8F2, 0xF2CB, 0xF2CE, 0xC2F9, 0xD5DD, 0xF2CC, 0xF2CD, 0xF2CF,
    0xF2D3, 0xF2D9, 0xD3BC, 0xB6EA, 0xCAF1, 0xB7E4, 0xF2D7, 0xF2D8,
    0xF2DA, 0xF2DD, 0xF2DB, 0xF2DC, 0xD1D1, 0xF2D1, 0xCDC9, 0xCECF,
    0xD6A9, 0xF2E3, 0xC3DB, 0xF2E0, 0xC0AF, 0xF2EC, 0xF2DE, 0xF2E1,
    0xF2E8, 0xF2E2, 0xF2E7, 0xF2E6, 0xF2E9, 0xF2DF, 0xF2E4, 0xF2EA,
    0xD3AC, 0xF2E5, 0xB2F5, 0xF2F2, 0xD0AB, 0xF2F5, 0xBBC8, 0xF2F9,
    0xF2F0, 0xF2F6, 0xF2F8, 0xF2FA, 0xF2F3, 0xF2F1, 0xBAFB, 0xB5FB,
    0xF2EF, 0xF2F7, 0xF2ED, 0xF2EE, 0xF2EB, 0xF3A6, 0xF3A3, 0xF3A2,
    0xF2F4, 0xC8DA, 0xF2FB, 0xF3A5, 0xC3F8, 0xF2FD, 0xF3A7, 0xF3A9,
    0xF3A4, 0xF2FC, 0xF3AB, 0xF3AA, 0xC2DD, 0xF3AE, 0xF3B0, 0xF3A1,
    0xF3B1, 0xF3AC, 0xF3AF, 0xF2FE, 0xF3AD, 0xF3B2, 0xF3B4, 0xF3A8,
    0xF3B3, 0xF3B5, 0xD0B7, 0xF3B8, 0xD9F9, 0xF3B9, 0xF3B7, 0xC8E4,
    0xF3B6, 0xF3BA, 0xF3BB, 0xB4C0, 0xEEC3, 0xF3BC, 0xF3BD, 0xD1AA,
    0xF4AC, 0xD0C6, 0xD0D0, 0xD1DC, 0xCFCE, 0xBDD6, 0xD1C3, 0xBAE2,
    0xE1E9, 0xD2C2, 0xF1C2, 0xB2B9, 0xB1ED, 0xF1C3, 0xC9C0, 0xB3C4,
    0xD9F2, 0xCBA5, 0xF1C4, 0xD6D4, 0xF1C5, 0xF4C0, 0xF1C6, 0xD4AC,
    0xF1C7, 0xB0C0, 0xF4C1, 0xF4C2, 0xB4FC, 0xC5DB, 0xCCBB, 0xD0E4,
    0xCDE0, 0xF1C8, 0xD9F3, 0xB1BB, 0xCFAE, 0xB8A4, 0xF1CA, 0xF1CB,
    0xB2C3, 0xC1D1, 0xD7B0, 0xF1C9, 0xF1CC, 0xF1CE, 0xD9F6, 0xD2E1,
    0xD4A3, 0xF4C3, 0xC8B9, 0xF4C4, 0xF1CD, 0xF1CF, 0xBFE3, 0xF1D0,
    0xF1D4, 0xF1D6, 0xF1D1, 0xC9D1, 0xC5E1, 0xC2E3, 0xB9FC, 0xF1D3,
    0xF1D5, 0xB9D3, 0xF1DB, 0xBAD6, 0xB0FD, 0xF1D9, 0xF1D8, 0xF1D2,
    0xF1DA, 0xF1D7, 0xC8EC, 0xCDCA, 0xF1DD, 0xE5BD, 0xF1DC, 0xF1DE,
    0xF1DF, 0xCFE5, 0xF4C5, 0xBDF3, 0xF1E0, 0xF1E1, 0xCEF7, 0xD2AA,
    0xF1FB, 0xB8B2, 0xBCFB, 0xB9DB, 0xB9E6, 0xC3D9, 0xCAD3, 0xEAE8,
    0xC0C0, 0xBEF5, 0xEAE9, 0xEAEA, 0xEAEB, 0xEAEC, 0xEAED, 0xEAEE,
    0xEAEF, 0xBDC7, 0xF5FB, 0xF5FD, 0xF5FE, 0xF5FC, 0xBDE2, 0xF6A1,
    0xB4A5, 0xF6A2, 0xF6A3, 0xECB2, 0xD1D4, 0xD9EA, 0xF6A4, 0xEEBA,
    0xD5B2, 0xD3FE, 0xCCDC, 0xCAC4, 0xE5C0, 0xF6A5, 0xBEAF, 0xC6A9,
    0xDAA5, 0xBCC6, 0xB6A9, 0xB8BC, 0xC8CF, 0xBCA5, 0xDAA6, 0xDAA7,
    0xCCD6, 0xC8C3, 0xDAA8, 0xC6FD, 0xD1B5, 0xD2E9, 0xD1B6, 0xBCC7,
    0xBDB2, 0xBBE4, 0xDAA9, 0xDAAA, 0xD1C8, 0xDAAB, 0xD0ED, 0xB6EF,
    0xC2DB, 0xCBCF, 0xB7ED, 0xC9E8, 0xB7C3, 0xBEF7, 0xD6A4, 0xDAAC,
    0xDAAD, 0xC6C0, 0xD7E7, 0xCAB6, 0xD5A9, 0xCBDF, 0xD5EF, 0xDAAE,
    0xD6DF, 0xB4CA, 0xDAB0, 0xDAAF, 0xD2EB, 0xDAB1, 0xDAB2, 0xDAB3,
    0xCAD4, 0xDAB4, 0xCAAB, 0xDAB5, 0xDAB6, 0xB3CF, 0xD6EF, 0xDAB7,
    0xBBB0, 0xB5AE, 0xDAB8, 0xDAB9, 0xB9EE, 0xD1AF, 0xD2E8, 0xDABA,
    0xB8C3, 0xCFEA, 0xB2EF, 0xDABB, 0xDABC, 0xBDEB, 0xCEDC, 0xD3EF,
    0xDABD, 0xCEF3, 0xDABE, 0xD3D5, 0xBBE5, 0xDABF, 0xCBB5, 0xCBD0,
    0xDAC0, 0xC7EB, 0xD6EE, 0xDAC1, 0xC5B5, 0xB6C1, 0xDAC2, 0xB7CC,
    0xBFCE, 0xDAC3, 0xDAC4, 0xCBAD, 0xDAC5, 0xB5F7, 0xDAC6, 0xC1C2,
    0xD7BB, 0xDAC7, 0xCCB8, 0xD2EA, 0xC4B1, 0xDAC8, 0xB5FD, 0xBBD1,
    0xDAC9, 0xD0B3, 0xDACA, 0xDACB, 0xCEBD, 0xDACC, 0xDACD, 0xDACE,
    0xB2F7, 0xDAD1, 0xDACF, 0xD1E8, 0xDAD0, 0xC3D5, 0xDAD2, 0xDAD3,
    0xDAD4, 0xDAD5, 0xD0BB, 0xD2A5, 0xB0F9, 0xDAD6, 0xC7AB, 0xDAD7,
    0xBDF7, 0xC3A1, 0xDAD8, 0xDAD9, 0xC3FD, 0xCCB7, 0xDADA, 0xDADB,
    0xC0BE, 0xC6D7, 0xDADC, 0xDADD, 0xC7B4, 0xDADE, 0xDADF, 0xB9C8,
    0xBBED, 0xB6B9, 0xF4F8, 0xF4F9, 0xCDE3, 0xF5B9, 0xEBE0, 0xCFF3,
    0xBBBF, 0xBAC0, 0xD4A5, 0xE1D9, 0xF5F4, 0xB1AA, 0xB2F2, 0xF5F5,
    0xF5F7, 0xBAD1, 0xF5F6, 0xC3B2, 0xF5F9, 0xF5F8, 0xB1B4, 0xD5EA,
    0xB8BA, 0xB9B1, 0xB2C6, 0xD4F0, 0xCFCD, 0xB0DC, 0xD5CB, 0xBBF5,
    0xD6CA, 0xB7B7, 0xCCB0, 0xC6B6, 0xB1E1, 0xB9BA, 0xD6FC, 0xB9E1,
    0xB7A1, 0xBCFA, 0xEADA, 0xEADB, 0xCCF9, 0xB9F3, 0xEADC, 0xB4FB,
    0xC3B3, 0xB7D1, 0xBAD8, 0xEADD, 0xD4F4, 0xEADE, 0xBCD6, 0xBBDF,
    0xEADF, 0xC1DE, 0xC2B8, 0xD4DF, 0xD7CA, 0xEAE0, 0xEAE1, 0xEAE4,
    0xEAE2, 0xEAE3, 0xC9DE, 0xB8B3, 0xB6C4, 0xEAE5, 0xCAEA, 0xC9CD,
    0xB4CD, 0xE2D9, 0xC5E2, 0xEAE6, 0xC0B5, 0xD7B8, 0xEAE7, 0xD7AC,
    0xC8FC, 0xD8D3, 0xD8CD, 0xD4DE, 0xD4F9, 0xC9C4, 0xD3AE, 0xB8D3,
    0xB3E0, 0xC9E2, 0xF4F6, 0xBAD5, 0xF4F7, 0xD7DF, 0xF4F1, 0xB8B0,
    0xD5D4, 0xB8CF, 0xC6F0, 0xB3C3, 0xF4F2, 0xB3AC, 0xD4BD, 0xC7F7,
    0xF4F4, 0xF4F3, 0xCCCB, 0xC8A4, 0xF4F5, 0xD7E3, 0xC5BF, 0xF5C0,
    0xF5BB, 0xF5C3, 0xF5C2, 0xD6BA, 0xF5C1, 0xD4BE, 0xF5C4, 0xF5CC,
    0xB0CF, 0xB5F8, 0xF5C9, 0xF5CA, 0xC5DC, 0xF5C5, 0xF5C6, 0xF5C7,
    0xF5CB, 0xBEE0, 0xF5C8, 0xB8FA, 0xF5D0, 0xF5D3, 0xBFE7, 0xB9F2,
    0xF5BC, 0xF5CD, 0xC2B7, 0xCCF8, 0xBCF9, 0xF5CE, 0xF5CF, 0xF5D1,
    0xB6E5, 0xF5D2, 0xF5D5, 0xF5BD, 0xF5D4, 0xD3BB, 0xB3EC, 0xCCA4,
    0xF5D6, 0xF5D7, 0xBEE1, 0xF5D8, 0xCCDF, 0xF5DB, 0xB2C8, 0xD7D9,
    0xF5D9, 0xF5DA, 0xF5DC, 0xF5E2, 0xF5E0, 0xF5DF, 0xF5DD, 0xF5E1,
    0xF5DE, 0xF5E4, 0xF5E5, 0xCCE3, 0xE5BF, 0xB5B8, 0xF5E3, 0xF5E8,
    0xCCA3, 0xF5E6, 0xF5E7, 0xF5BE, 0xB1C4, 0xF5BF, 0xB5C5, 0xB2E4,
    0xF5EC, 0xF5E9, 0xB6D7, 0xF5ED, 0xF5EA, 0xF5EB, 0xB4DA, 0xD4EA,
    0xF5EE, 0xB3F9, 0xF5EF, 0xF5F1, 0xF5F0, 0xF5F2, 0xF5F3, 0xC9ED,
    0xB9AA, 0xC7FB, 0xB6E3, 0xCCC9, 0xEAA6, 0xB3B5, 0xD4FE, 0xB9EC,
    0xD0F9, 0xE9ED, 0xD7AA, 0xE9EE, 0xC2D6, 0xC8ED, 0xBAE4, 0xE9EF,
    0xE9F0, 0xE9F1, 0xD6E1, 0xE9F2, 0xE9F3, 0xE9F5, 0xE9F4, 0xE9F6,
    0xE9F7, 0xC7E1, 0xE9F8, 0xD4D8, 0xE9F9, 0xBDCE, 0xE9FA, 0xE9FB,
    0xBDCF, 0xE9FC, 0xB8A8, 0xC1BE, 0xE9FD, 0xB1B2, 0xBBD4, 0xB9F5,
    0xE9FE, 0xEAA1, 0xEAA2, 0xEAA3, 0xB7F8, 0xBCAD, 0xCAE4, 0xE0CE,
    0xD4AF, 0xCFBD, 0xD5B7, 0xEAA4, 0xD5DE, 0xEAA5, 0xD0C1, 0xB9BC,
    0xB4C7, 0xB1D9, 0xC0B1, 0xB1E6, 0xB1E7, 0xB1E8, 0xB3BD, 0xC8E8,
    0xE5C1, 0xB1DF, 0xC1C9, 0xB4EF, 0xC7A8, 0xD3D8, 0xC6F9, 0xD1B8,
    0xB9FD, 0xC2F5, 0xD3AD, 0xD4CB, 0xBDFC, 0xE5C2, 0xB7B5, 0xE5C3,
    0xBBB9, 0xD5E2, 0xBDF8, 0xD4B6, 0xCEA5, 0xC1AC, 0xB3D9, 0xCCF6,
    0xE5C6, 0xE5C4, 0xE5C8, 0xE5CA, 0xE5C7, 0xB5CF, 0xC6C8, 0xB5FC,
    0xE5C5, 0xCAF6, 0xE5C9, 0xC3D4, 0xB1C5, 0xBCA3, 0xD7B7, 0xCDCB,
    0xCBCD, 0xCACA, 0xCCD3, 0xE5CC, 0xE5CB, 0xC4E6, 0xD1A1, 0xD1B7,
    0xE5CD, 0xE5D0, 0xCDB8, 0xD6F0, 0xE5CF, 0xB5DD, 0xCDBE, 0xE5D1,
    0xB6BA, 0xCDA8, 0xB9E4, 0xCAC5, 0xB3D1, 0xCBD9, 0xD4EC, 0xE5D2,
    0xB7EA, 0xE5CE, 0xE5D5, 0xB4FE, 0xE5D6, 0xE5D3, 0xE5D4, 0xD2DD,
    0xC2DF, 0xB1C6, 0xD3E2, 0xB6DD, 0xCBEC, 0xE5D7, 0xD3F6, 0xB1E9,
    0xB6F4, 0xE5DA, 0xE5D8, 0xE5D9, 0xB5C0, 0xD2C5, 0xE5DC, 0xE5DE,
    0xE5DD, 0xC7B2, 0xD2A3, 0xE5DB, 0xD4E2, 0xD5DA, 0xE5E0, 0xD7F1,
    0xE5E1, 0xB1DC, 0xD1FB, 0xE5E2, 0xE5E4, 0xE5E3, 0xE5E5, 0xD2D8,
    0xB5CB, 0xE7DF, 0xDAF5, 0xDAF8, 0xDAF6, 0xDAF7, 0xDAFA, 0xD0CF,
    0xC4C7, 0xB0EE, 0xD0B0, 0xDAF9, 0xD3CA, 0xBAAA, 0xDBA2, 0xC7F1,
    0xDAFC, 0xDAFB, 0xC9DB, 0xDAFD, 0xDBA1, 0xD7DE, 0xDAFE, 0xC1DA,
    0xDBA5, 0xD3F4, 0xDBA7, 0xDBA4, 0xDBA8, 0xBDBC, 0xC0C9, 0xDBA3,
    0xDBA6, 0xD6A3, 0xDBA9, 0xDBAD, 0xDBAE, 0xDBAC, 0xBAC2, 0xBFA4,
    0xDBAB, 0xDBAA, 0xD4C7, 0xB2BF, 0xDBAF, 0xB9F9, 0xDBB0, 0xB3BB,
    0xB5A6, 0xB6BC, 0xDBB1, 0xB6F5, 0xDBB2, 0xB1C9, 0xDBB4, 0xDBB3,
    0xDBB5, 0xDBB7, 0xDBB6, 0xDBB8, 0xDBB9, 0xDBBA, 0xD3CF, 0xF4FA,
    0xC7F5, 0xD7C3, 0xC5E4, 0xF4FC, 0xF4FD, 0xF4FB, 0xBEC6, 0xD0EF,
    0xB7D3, 0xD4CD, 0xCCAA, 0xF5A2, 0xF5A1, 0xBAA8, 0xF4FE, 0xCBD6,
    0xF5A4, 0xC0D2, 0xB3EA, 0xCDAA, 0xF5A5, 0xF5A3, 0xBDB4, 0xF5A8,
    0xF5A9, 0xBDCD, 0xC3B8, 0xBFE1, 0xCBE1, 0xF5AA, 0xF5A6, 0xF5A7,
    0xC4F0, 0xF5AC, 0xB4BC, 0xD7ED, 0xB4D7, 0xF5AB, 0xF5AE, 0xF5AD,
    0xF5AF, 0xD0D1, 0xC3D1, 0xC8A9, 0xF5B0, 0xF5B1, 0xF5B2, 0xF5B3,
    0xF5B4, 0xF5B5, 0xF5B7, 0xF5B6, 0xF5B8, 0xB2C9, 0xD3D4, 0xCACD,
    0xC0EF, 0xD6D8, 0xD2B0, 0xC1BF, 0xBDF0, 0xB8AA, 0xBCF8, 0xF6C6,
    0xF6C7, 0xF6C8, 0xF6C9, 0xF6CA, 0xF6CC, 0xF6CB, 0xF7E9, 0xF6CD,
    0xF6CE, 0xEEC4, 0xEEC5, 0xEEC6, 0xD5EB, 0xB6A4, 0xEEC8, 0xEEC7,
    0xEEC9, 0xEECA, 0xC7A5, 0xEECB, 0xEECC, 0xB7B0, 0xB5F6, 0xEECD,
    0xEECF, 0xEECE, 0xB8C6, 0xEED0, 0xEED1, 0xEED2, 0xB6DB, 0xB3AE,
    0xD6D3, 0xC4C6, 0xB1B5, 0xB8D6, 0xEED3, 0xEED4, 0xD4BF, 0xC7D5,
    0xBEFB, 0xCED9, 0xB9B3, 0xEED6, 0xEED5, 0xEED8, 0xEED7, 0xC5A5,
    0xEED9, 0xEEDA, 0xC7AE, 0xEEDB, 0xC7AF, 0xEEDC, 0xB2A7, 0xEEDD,
    0xEEDE, 0xEEDF, 0xEEE0, 0xEEE1, 0xD7EA, 0xEEE2, 0xEEE3, 0xBCD8,
    0xEEE4, 0xD3CB, 0xCCFA, 0xB2AC, 0xC1E5, 0xEEE5, 0xC7A6, 0xC3AD,
    0xEEE6, 0xEEE7, 0xEEE8, 0xEEE9, 0xEEEA, 0xEEEB, 0xEEEC, 0xEEED,
    0xEEEE, 0xEEEF, 0xEEF0, 0xEEF1, 0xEEF2, 0xEEF4, 0xEEF3, 0xEEF5,
    0xCDAD, 0xC2C1, 0xEEF6, 0xEEF7, 0xEEF8, 0xD5A1, 0xEEF9, 0xCFB3,
    0xEEFA, 0xEEFB, 0xEEFC, 0xEEFD, 0xEFA1, 0xEEFE, 0xEFA2, 0xB8F5,
    0xC3FA, 0xEFA3, 0xEFA4, 0xBDC2, 0xD2BF, 0xB2F9, 0xEFA5, 0xEFA6,
    0xEFA7, 0xD2F8, 0xEFA8, 0xD6FD, 0xEFA9, 0xC6CC, 0xEFAA, 0xEFAB,
    0xC1B4, 0xEFAC, 0xCFFA, 0xCBF8, 0xEFAE, 0xEFAD, 0xB3FA, 0xB9F8,
    0xEFAF, 0xEFB0, 0xD0E2, 0xEFB1, 0xEFB2, 0xB7E6, 0xD0BF, 0xEFB3,
    0xEFB4, 0xEFB5, 0xC8F1, 0xCCE0, 0xEFB6, 0xEFB7, 0xEFB8, 0xEFB9,
    0xEFBA, 0xD5E0, 0xEFBB, 0xB4ED, 0xC3AA, 0xEFBC, 0xEFBD, 0xEFBE,
    0xEFBF, 0xCEFD, 0xEFC0, 0xC2E0, 0xB4B8, 0xD7B6, 0xBDF5, 0xCFC7,
    0xEFC3, 0xEFC1, 0xEFC2, 0xEFC4, 0xB6A7, 0xBCFC, 0xBEE2, 0xC3CC,
    0xEFC5, 0xEFC6, 0xEFC7, 0xEFCF, 0xEFC8, 0xEFC9, 0xEFCA, 0xC7C2,
    0xEFF1, 0xB6CD, 0xEFCB, 0xEFCC, 0xEFCD, 0xB6C6, 0xC3BE, 0xEFCE,
    0xEFD0, 0xEFD1, 0xEFD2, 0xD5F2, 0xEFD3, 0xC4F7, 0xEFD4, 0xC4F8,
    0xEFD5, 0xEFD6, 0xB8E4, 0xB0F7, 0xEFD7, 0xEFD8, 0xEFD9, 0xEFDA,
    0xEFDB, 0xEFDC, 0xEFDD, 0xEFDE, 0xBEB5, 0xEFE1, 0xEFDF, 0xEFE0,
    0xEFE2, 0xEFE3, 0xC1CD, 0xEFE4, 0xEFE5, 0xEFE6, 0xEFE7, 0xEFE8,
    0xEFE9, 0xEFEA, 0xEFEB, 0xEFEC, 0xC0D8, 0xEFED, 0xC1AD, 0xEFEE,
    0xEFEF, 0xEFF0, 0xCFE2, 0xB3A4, 0xC3C5, 0xE3C5, 0xC9C1, 0xE3C6,
    0xB1D5, 0xCECA, 0xB4B3, 0xC8F2, 0xE3C7, 0xCFD0, 0xE3C8, 0xBCE4,
    0xE3C9, 0xE3CA, 0xC3C6, 0xD5A2, 0xC4D6, 0xB9EB, 0xCEC5, 0xE3CB,
    0xC3F6, 0xE3CC, 0xB7A7, 0xB8F3, 0xBAD2, 0xE3CD, 0xE3CE, 0xD4C4,
    0xE3CF, 0xE3D0, 0xD1CB, 0xE3D1, 0xE3D2, 0xE3D3, 0xE3D4, 0xD1D6,
    0xE3D5, 0xB2FB, 0xC0BB, 0xE3D6, 0xC0AB, 0xE3D7, 0xE3D8, 0xE3D9,
    0xE3DA, 0xE3DB, 0xB8B7, 0xDAE2, 0xB6D3, 0xDAE4, 0xDAE3, 0xDAE6,
    0xC8EE, 0xDAE5, 0xB7C0, 0xD1F4, 0xD2F5, 0xD5F3, 0xBDD7, 0xD7E8,
    0xDAE8, 0xDAE7, 0xB0A2, 0xCDD3, 0xDAE9, 0xB8BD, 0xBCCA, 0xC2BD,
    0xC2A4, 0xB3C2, 0xDAEA, 0xC2AA, 0xC4B0, 0xBDB5, 0xCFDE, 0xDAEB,
    0xC9C2, 0xB1DD, 0xDAEC, 0xB6B8, 0xD4BA, 0xB3FD, 0xDAED, 0xD4C9,
    0xCFD5, 0xC5E3, 0xDAEE, 0xDAEF, 0xDAF0, 0xC1EA, 0xCCD5, 0xCFDD,
    0xD3E7, 0xC2A1, 0xDAF1, 0xCBE5, 0xDAF2, 0xCBE6, 0xD2FE, 0xB8F4,
    0xDAF3, 0xB0AF, 0xCFB6, 0xD5CF, 0xCBED, 0xDAF4, 0xE3C4, 0xC1A5,
    0xF6BF, 0xF6C0, 0xF6C1, 0xC4D1, 0xC8B8, 0xD1E3, 0xD0DB, 0xD1C5,
    0xBCAF, 0xB9CD, 0xEFF4, 0xB4C6, 0xD3BA, 0xF6C2, 0xB3FB, 0xF6C3,
    0xB5F1, 0xF6C5, 0xD3EA, 0xF6A7, 0xD1A9, 0xF6A9, 0xF6A8, 0xC1E3,
    0xC0D7, 0xB1A2, 0xCEED, 0xD0E8, 0xF6AB, 0xCFF6, 0xF6AA, 0xD5F0,
    0xF6AC, 0xC3B9, 0xBBF4, 0xF6AE, 0xF6AD, 0xC4DE, 0xC1D8, 0xCBAA,
    0xCFBC, 0xF6AF, 0xF6B0, 0xF6B1, 0xC2B6, 0xB0D4, 0xC5F9, 0xF6B2,
    0xC7E0, 0xF6A6, 0xBEB8, 0xBEB2, 0xB5E5, 0xB7C7, 0xBFBF, 0xC3D2,
    0xC3E6, 0xD8CC, 0xB8EF, 0xBDF9, 0xD1A5, 0xB0D0, 0xF7B0, 0xF7B1,
    0xD0AC, 0xB0B0, 0xF7B2, 0xF7B3, 0xF7B4, 0xC7CA, 0xBECF, 0xF7B7,
    0xF7B6, 0xB1DE, 0xF7B5, 0xF7B8, 0xF7B9, 0xCEA4, 0xC8CD, 0xBAAB,
    0xE8B8, 0xE8B9, 0xE8BA, 0xBEC2, 0xD2F4, 0xD4CF, 0xC9D8, 0xD2B3,
    0xB6A5, 0xC7EA, 0xF1FC, 0xCFEE, 0xCBB3, 0xD0EB, 0xE7EF, 0xCDE7,
    0xB9CB, 0xB6D9, 0xF1FD, 0xB0E4, 0xCBCC, 0xF1FE, 0xD4A4, 0xC2AD,
    0xC1EC, 0xC6C4, 0xBEB1, 0xF2A1, 0xBCD5, 0xF2A2, 0xF2A3, 0xF2A4,
    0xD2C3, 0xC6B5, 0xCDC7, 0xF2A5, 0xD3B1, 0xBFC5, 0xCCE2, 0xF2A6,
    0xF2A7, 0xD1D5, 0xB6EE, 0xF2A8, 0xF2A9, 0xB5DF, 0xF2AA, 0xF2AB,
    0xB2FC, 0xF2AC, 0xF2AD, 0xC8A7, 0xB7E7, 0xECA9, 0xECAA, 0xECAB,
    0xECAC, 0xC6AE, 0xECAD, 0xECAE, 0xB7C9, 0xCAB3, 0xE2B8, 0xF7CF,
    0xF7D0, 0xB2CD, 0xF7D1, 0xF7D3, 0xF7D2, 0xE2BB, 0xBCA2, 0xE2BC,
    0xE2BD, 0xE2BE, 0xE2BF, 0xE2C0, 0xE2C1, 0xB7B9, 0xD2FB, 0xBDA4,
    0xCACE, 0xB1A5, 0xCBC7, 0xE2C2, 0xB6FC, 0xC8C4, 0xE2C3, 0xBDC8,
    0xB1FD, 0xE2C4, 0xB6F6, 0xE2C5, 0xC4D9, 0xE2C6, 0xCFDA, 0xB9DD,
    0xE2C7, 0xC0A1, 0xE2C8, 0xB2F6, 0xE2C9, 0xC1F3, 0xE2CA, 0xE2CB,
    0xC2F8, 0xE2CC, 0xE2CD, 0xE2CE, 0xCAD7, 0xD8B8, 0xD9E5, 0xCFE3,
    0xF0A5, 0xDCB0, 0xC2ED, 0xD4A6, 0xCDD4, 0xD1B1, 0xB3DB, 0xC7FD,
    0xB2B5, 0xC2BF, 0xE6E0, 0xCABB, 0xE6E1, 0xE6E2, 0xBED4, 0xE6E3,
    0xD7A4, 0xCDD5, 0xE6E5, 0xBCDD, 0xE6E4, 0xE6E6, 0xE6E7, 0xC2EE,
    0xBDBE, 0xE6E8, 0xC2E6, 0xBAA7, 0xE6E9, 0xE6EA, 0xB3D2, 0xD1E9,
    0xBFA5, 0xE6EB, 0xC6EF, 0xE6EC, 0xE6ED, 0xE6EE, 0xC6AD, 0xE6EF,
    0xC9A7, 0xE6F0, 0xE6F1, 0xE6F2, 0xE5B9, 0xE6F3, 0xE6F4, 0xC2E2,
    0xE6F5, 0xE6F6, 0xD6E8, 0xE6F7, 0xE6F8, 0xB9C7, 0xF7BB, 0xF7BA,
    0xF7BE, 0xF7BC, 0xBAA1, 0xF7BF, 0xF7C0, 0xF7C2, 0xF7C1, 0xF7C4,
    0xF7C3, 0xF7C5, 0xF7C6, 0xF7C7, 0xCBE8, 0xB8DF, 0xF7D4, 0xF7D5,
    0xF7D6, 0xF7D8, 0xF7DA, 0xF7D7, 0xF7DB, 0xF7D9, 0xD7D7, 0xF7DC,
    0xF7DD, 0xF7DE, 0xF7DF, 0xF7E0, 0xDBCB, 0xD8AA, 0xE5F7, 0xB9ED,
    0xBFFD, 0xBBEA, 0xF7C9, 0xC6C7, 0xF7C8, 0xF7CA, 0xF7CC, 0xF7CB,
    0xF7CD, 0xCEBA, 0xF7CE, 0xC4A7, 0xD3E3, 0xF6CF, 0xC2B3, 0xF6D0,
    0xF6D1, 0xF6D2, 0xF6D3, 0xF6D4, 0xF6D6, 0xB1AB, 0xF6D7, 0xF6D8,
    0xF6D9, 0xF6DA, 0xF6DB, 0xF6DC, 0xF6DD, 0xF6DE, 0xCFCA, 0xF6DF,
    0xF6E0, 0xF6E1, 0xF6E2, 0xF6E3, 0xF6E4, 0xC0F0, 0xF6E5, 0xF6E6,
    0xF6E7, 0xF6E8, 0xF6E9, 0xF6EA, 0xF6EB, 0xF6EC, 0xF6ED, 0xF6EE,
    0xF6EF, 0xF6F0, 0xF6F1, 0xF6F2, 0xF6F3, 0xF6F4, 0xBEA8, 0xF6F5,
    0xF6F6, 0xF6F7, 0xF6F8, 0xC8FA, 0xF6F9, 0xF6FA, 0xF6FB, 0xF6FC,
    0xF6FD, 0xF6FE, 0xF7A1, 0xF7A2, 0xF7A3, 0xF7A4, 0xF7A5, 0xF7A6,
    0xF7A7, 0xF7A8, 0xB1EE, 0xF7A9, 0xF7AA, 0xF7AB, 0xF7AC, 0xF7AD,
    0xC1DB, 0xF7AE, 0xF7AF, 0xC4F1, 0xF0AF, 0xBCA6, 0xF0B0, 0xC3F9,
    0xC5B8, 0xD1BB, 0xF0B1, 0xF0B2, 0xF0B3, 0xF0B4, 0xF0B5, 0xD1BC,
    0xD1EC, 0xF0B7, 0xF0B6, 0xD4A7, 0xCDD2, 0xF0B8, 0xF0BA, 0xF0B9,
    0xF0BB, 0xF0BC, 0xB8EB, 0xF0BD, 0xBAE8, 0xF0BE, 0xF0BF, 0xBEE9,
    0xF0C0, 0xB6EC, 0xF0C1, 0xF0C2, 0xF0C3, 0xF0C4, 0xC8B5, 0xF0C5,
    0xF0C6, 0xF0C7, 0xC5F4, 0xF0C8, 0xF0C9, 0xF0CA, 0xF7BD, 0xF0CB,
    0xF0CC, 0xF0CD, 0xF0CE, 0xF0CF, 0xBAD7, 0xF0D0, 0xF0D1, 0xF0D2,
    0xF0D3, 0xF0D4, 0xF0D5, 0xF0D6, 0xF0D8, 0xD3A5, 0xF0D7, 0xF0D9,
    0xF5BA, 0xC2B9, 0xF7E4, 0xF7E5, 0xF7E6, 0xF7E7, 0xF7E8, 0xC2B4,
    0xF7EA, 0xF7EB, 0xC2F3, 0xF4F0, 0xF4EF, 0xC2E9, 0xF7E1, 0xF7E2,
    0xBBC6, 0xD9E4, 0xCAF2, 0xC0E8, 0xF0A4, 0xBADA, 0xC7AD, 0xC4AC,
    0xF7EC, 0xF7ED, 0xF7EE, 0xF7F0, 0xF7EF, 0xF7F1, 0xF7F4, 0xF7F3,
    0xF7F2, 0xF7F5, 0xF7F6, 0xEDE9, 0xEDEA, 0xEDEB, 0xF6BC, 0xF6BD,
    0xF6BE, 0xB6A6, 0xD8BE, 0xB9C4, 0xD8BB, 0xDCB1, 0xCAF3, 0xF7F7,
    0xF7F8, 0xF7F9, 0xF7FB, 0xF7FA, 0xB1C7, 0xF7FC, 0xF7FD, 0xF7FE,
    0xC6EB, 0xECB4, 0xB3DD, 0xF6B3, 0xF6B4, 0xC1E4, 0xF6B5, 0xF6B6,
    0xF6B7, 0xF6B8, 0xF6B9, 0xF6BA, 0xC8A3, 0xF6BB, 0xC1FA, 0xB9A8,
    0xEDE8, 0xB9EA, 0xD9DF, 0xA3A1, 0xA3A2, 0xA3A3, 0xA1E7, 0xA3A5,
    0xA3A6, 0xA3A7, 0xA3A8, 0xA3A9, 0xA3AA, 0xA3AB, 0xA3AC, 0xA3AD,
    0xA3AE, 0xA3AF, 0xA3B0, 0xA3B1, 0xA3B2, 0xA3B3, 0xA3B4, 0xA3B5,
    0xA3B6, 0xA3B7, 0xA3B8, 0xA3B9, 0xA3BA, 0xA3BB, 0xA3BC, 0xA3BD,
    0xA3BE, 0xA3BF, 0xA3C0, 0xA3C1, 0xA3C2, 0xA3C3, 0xA3C4, 0xA3C5,
    0xA3C6, 0xA3C7, 0xA3C8, 0xA3C9, 0xA3CA, 0xA3CB, 0xA3CC, 0xA3CD,
    0xA3CE, 0xA3CF, 0xA3D0, 0xA3D1, 0xA3D2, 0xA3D3, 0xA3D4, 0xA3D5,
    0xA3D6, 0xA3D7, 0xA3D8, 0xA3D9, 0xA3DA, 0xA3DB, 0xA3DC, 0xA3DD,
    0xA3DE, 0xA3DF, 0xA3E0, 0xA3E1, 0xA3E2, 0xA3E3, 0xA3E4, 0xA3E5,
    0xA3E6, 0xA3E7, 0xA3E8, 0xA3E9, 0xA3EA, 0xA3EB, 0xA3EC, 0xA3ED,
    0xA3EE, 0xA3EF, 0xA3F0, 0xA3F1, 0xA3F2, 0xA3F3, 0xA3F4, 0xA3F5,
    0xA3F6, 0xA3F7, 0xA3F8, 0xA3F9, 0xA3FA, 0xA3FB, 0xA3FC, 0xA3FD,
    0xA1AB, 0xA1E9, 0xA1EA, 0xA3FE, 0xA3A4,
};

/* Indexes into Unicode `gb2312_u[]` array in blocks of 0x100 */
static const unsigned short gb2312_u_ind[256] = {
        0,    25,    33,    53,   149,   149,   149,   149,
      149,   149,   149,   149,   149,   149,   149,   149,
      149,   149,   149,   149,   149,   149,   149,   149,
      149,   149,   149,   149,   149,   149,   149,   149,
      160,   178,   206,   208,   258,   336,   347,   347,
      347,   347,   347,   347,   347,   347,   347,   347,
      453,   574,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   584,   584,
      584,   584,   584,   584,   584,   584,   655,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   720,
      720,   720,   720,   720,   720,   720,   720,   814,
};

#endif /* Z_GB2312_H */
