/* XRACER (C) 1999-2000 Richard W.M. Jones <rich@annexia.org> and other AUTHORS
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: sky.c,v 1.2 2000/03/19 23:48:47 rich Exp $
 */

#include "config.h"

#include <GL/glu.h>

#include "xracer.h"
#include "xracer-track.h"
#include "xracer-log.h"
#include "xracer-texture.h"
#include "common.h"

static int sky_dlist;
static GLuint sky_tex;

int
sky_load ()
{
  sky_tex = xrTextureLoad ("sky/clouds2.jpg", 0, 0, 0, 0);
  if (sky_tex == 0)
    {
      xrLog (LOG_ERROR, "cannot load sky texture: sky/clouds2.jpg");
      return -1;
    }

  sky_dlist = glGenLists (1);
  if (sky_dlist == 0)
    {
      xrLog (LOG_ERROR,
	     "glGenLists: cannot allocate display list: %s",
	     gluErrorString (glGetError ()));
      return -1;
    }

  glNewList (sky_dlist, GL_COMPILE);

  glBindTexture (GL_TEXTURE_2D, sky_tex);

  glBegin (GL_QUAD_STRIP);
  glTexCoord2f (0, 1);
  glVertex3f (- 50, - 25, 1);
  glTexCoord2f (0, 0);
  glVertex3f (- 50, - 50, 1);

  glTexCoord2f (1, 1);
  glVertex3f (- 25, - 25, 2);
  glTexCoord2f (1, 0);
  glVertex3f (- 25, - 50, 1);

  glTexCoord2f (2, 1);
  glVertex3f (0, - 25, 2);
  glTexCoord2f (2, 0);
  glVertex3f (0, - 50, 1);

  glTexCoord2f (3, 1);
  glVertex3f (25, - 25, 2);
  glTexCoord2f (3, 0);
  glVertex3f (25, - 50, 1);

  glTexCoord2f (4, 1);
  glVertex3f (50, - 25, 1);
  glTexCoord2f (4, 0);
  glVertex3f (50, - 50, 1);
  glEnd ();

  glBegin (GL_QUAD_STRIP);
  glTexCoord2f (0, 2);
  glVertex3f (- 50, 0, 1);
  glTexCoord2f (0, 1);
  glVertex3f (- 50, - 25, 1);

  glTexCoord2f (1, 2);
  glVertex3f (- 25, 0, 2);
  glTexCoord2f (1, 1);
  glVertex3f (- 25, - 25, 2);

  glTexCoord2f (2, 2);
  glVertex3f (0, 0, 2.5);
  glTexCoord2f (2, 1);
  glVertex3f (0, - 25, 2);

  glTexCoord2f (3, 2);
  glVertex3f (25, 0, 2);
  glTexCoord2f (3, 1);
  glVertex3f (25, - 25, 2);

  glTexCoord2f (4, 2);
  glVertex3f (50, 0, 1);
  glTexCoord2f (4, 1);
  glVertex3f (50, - 25, 1);
  glEnd ();

  glBegin (GL_QUAD_STRIP);
  glTexCoord2f (0, 3);
  glVertex3f (- 50, 25, 1);
  glTexCoord2f (0, 2);
  glVertex3f (- 50, 0, 1);

  glTexCoord2f (1, 3);
  glVertex3f (- 25, 25, 2);
  glTexCoord2f (1, 2);
  glVertex3f (- 25, 0, 2);

  glTexCoord2f (2, 3);
  glVertex3f (0, 25, 2);
  glTexCoord2f (2, 2);
  glVertex3f (0, 0, 2.5);

  glTexCoord2f (3, 3);
  glVertex3f (25, 25, 2);
  glTexCoord2f (3, 2);
  glVertex3f (25, 0, 2);

  glTexCoord2f (4, 3);
  glVertex3f (50, 25, 1);
  glTexCoord2f (4, 2);
  glVertex3f (50, 0, 1);
  glEnd ();

  glBegin (GL_QUAD_STRIP);
  glTexCoord2f (0, 4);
  glVertex3f (- 50, 50, 1);
  glTexCoord2f (0, 3);
  glVertex3f (- 50, 25, 1);

  glTexCoord2f (1, 4);
  glVertex3f (- 25, 50, 1);
  glTexCoord2f (1, 3);
  glVertex3f (- 25, 25, 2);

  glTexCoord2f (2, 4);
  glVertex3f (0, 50, 1);
  glTexCoord2f (2, 3);
  glVertex3f (0, 25, 2);

  glTexCoord2f (3, 4);
  glVertex3f (25, 50, 1);
  glTexCoord2f (3, 3);
  glVertex3f (25, 25, 2);

  glTexCoord2f (4, 4);
  glVertex3f (50, 50, 1);
  glTexCoord2f (4, 3);
  glVertex3f (50, 25, 1);
  glEnd ();

  glEndList ();

  return 0;
}

void
sky_unload ()
{
  glDeleteLists (sky_dlist, 1);
  xrTextureUnload (sky_tex);
}

void
sky_display (const GLfloat *posn)
{
  static GLfloat cloud_posn = 0.0;
  GLfloat x = posn[0];
  GLfloat y = posn[1];
  GLfloat z = posn[2];

  cloud_posn += 0.02 * xrTimeInterval;
  glMatrixMode( GL_TEXTURE );
  glPushMatrix();
  glLoadIdentity();
  glTranslatef( cloud_posn, cloud_posn, 0.0 );
  glMatrixMode( GL_MODELVIEW );
  glPushMatrix ();
  glTranslatef (x, y, z);

  glCallList (sky_dlist);

  glMatrixMode( GL_MODELVIEW );
  glPopMatrix ();
  glMatrixMode( GL_TEXTURE );
  glPopMatrix();
}
