/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ddlutils;

import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.ddlutils.DdlUtilsException;
import org.apache.ddlutils.Platform;
import org.apache.ddlutils.PlatformUtils;

public class PlatformFactory {
    private static Map _platforms = null;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$axion$AxionPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$cloudscape$CloudscapePlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$db2$Db2Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$db2$Db2v8Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$derby$DerbyPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$firebird$FirebirdPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$hsqldb$HsqlDbPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$interbase$InterbasePlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$maxdb$MaxDbPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$mckoi$MckoiPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$mssql$MSSqlPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$mysql$MySqlPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$mysql$MySql50Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$oracle$Oracle8Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$oracle$Oracle9Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$oracle$Oracle10Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$postgresql$PostgreSqlPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$sapdb$SapDbPlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$sybase$SybasePlatform;
    static /* synthetic */ Class class$org$apache$ddlutils$platform$sybase$SybaseASE15Platform;
    static /* synthetic */ Class class$org$apache$ddlutils$Platform;

    private static synchronized Map getPlatforms() {
        if (_platforms == null) {
            _platforms = new HashMap();
            PlatformFactory.registerPlatforms();
        }
        return _platforms;
    }

    public static synchronized Platform createNewPlatformInstance(String databaseName) throws DdlUtilsException {
        Class platformClass = (Class)PlatformFactory.getPlatforms().get(databaseName.toLowerCase());
        try {
            return platformClass != null ? (Platform)platformClass.newInstance() : null;
        }
        catch (Exception ex) {
            throw new DdlUtilsException("Could not create platform for database " + databaseName, ex);
        }
    }

    public static synchronized Platform createNewPlatformInstance(String jdbcDriver, String jdbcConnectionUrl) throws DdlUtilsException {
        return PlatformFactory.createNewPlatformInstance(new PlatformUtils().determineDatabaseType(jdbcDriver, jdbcConnectionUrl));
    }

    public static synchronized Platform createNewPlatformInstance(DataSource dataSource) throws DdlUtilsException {
        Platform platform = PlatformFactory.createNewPlatformInstance(new PlatformUtils().determineDatabaseType(dataSource));
        platform.setDataSource(dataSource);
        return platform;
    }

    public static synchronized Platform createNewPlatformInstance(DataSource dataSource, String username, String password) throws DdlUtilsException {
        Platform platform = PlatformFactory.createNewPlatformInstance(new PlatformUtils().determineDatabaseType(dataSource, username, password));
        platform.setDataSource(dataSource);
        platform.setUsername(username);
        platform.setPassword(password);
        return platform;
    }

    public static synchronized String[] getSupportedPlatforms() {
        return PlatformFactory.getPlatforms().keySet().toArray(new String[0]);
    }

    public static boolean isPlatformSupported(String platformName) {
        return PlatformFactory.getPlatforms().containsKey(platformName.toLowerCase());
    }

    public static synchronized void registerPlatform(String platformName, Class platformClass) {
        PlatformFactory.addPlatform(PlatformFactory.getPlatforms(), platformName, platformClass);
    }

    private static void registerPlatforms() {
        PlatformFactory.addPlatform(_platforms, "Axion", class$org$apache$ddlutils$platform$axion$AxionPlatform == null ? (class$org$apache$ddlutils$platform$axion$AxionPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.axion.AxionPlatform")) : class$org$apache$ddlutils$platform$axion$AxionPlatform);
        PlatformFactory.addPlatform(_platforms, "Cloudscape", class$org$apache$ddlutils$platform$cloudscape$CloudscapePlatform == null ? (class$org$apache$ddlutils$platform$cloudscape$CloudscapePlatform = PlatformFactory.class$("org.apache.ddlutils.platform.cloudscape.CloudscapePlatform")) : class$org$apache$ddlutils$platform$cloudscape$CloudscapePlatform);
        PlatformFactory.addPlatform(_platforms, "DB2", class$org$apache$ddlutils$platform$db2$Db2Platform == null ? (class$org$apache$ddlutils$platform$db2$Db2Platform = PlatformFactory.class$("org.apache.ddlutils.platform.db2.Db2Platform")) : class$org$apache$ddlutils$platform$db2$Db2Platform);
        PlatformFactory.addPlatform(_platforms, "DB2v8", class$org$apache$ddlutils$platform$db2$Db2v8Platform == null ? (class$org$apache$ddlutils$platform$db2$Db2v8Platform = PlatformFactory.class$("org.apache.ddlutils.platform.db2.Db2v8Platform")) : class$org$apache$ddlutils$platform$db2$Db2v8Platform);
        PlatformFactory.addPlatform(_platforms, "Derby", class$org$apache$ddlutils$platform$derby$DerbyPlatform == null ? (class$org$apache$ddlutils$platform$derby$DerbyPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.derby.DerbyPlatform")) : class$org$apache$ddlutils$platform$derby$DerbyPlatform);
        PlatformFactory.addPlatform(_platforms, "Firebird", class$org$apache$ddlutils$platform$firebird$FirebirdPlatform == null ? (class$org$apache$ddlutils$platform$firebird$FirebirdPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.firebird.FirebirdPlatform")) : class$org$apache$ddlutils$platform$firebird$FirebirdPlatform);
        PlatformFactory.addPlatform(_platforms, "HsqlDb", class$org$apache$ddlutils$platform$hsqldb$HsqlDbPlatform == null ? (class$org$apache$ddlutils$platform$hsqldb$HsqlDbPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.hsqldb.HsqlDbPlatform")) : class$org$apache$ddlutils$platform$hsqldb$HsqlDbPlatform);
        PlatformFactory.addPlatform(_platforms, "Interbase", class$org$apache$ddlutils$platform$interbase$InterbasePlatform == null ? (class$org$apache$ddlutils$platform$interbase$InterbasePlatform = PlatformFactory.class$("org.apache.ddlutils.platform.interbase.InterbasePlatform")) : class$org$apache$ddlutils$platform$interbase$InterbasePlatform);
        PlatformFactory.addPlatform(_platforms, "MaxDB", class$org$apache$ddlutils$platform$maxdb$MaxDbPlatform == null ? (class$org$apache$ddlutils$platform$maxdb$MaxDbPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.maxdb.MaxDbPlatform")) : class$org$apache$ddlutils$platform$maxdb$MaxDbPlatform);
        PlatformFactory.addPlatform(_platforms, "McKoi", class$org$apache$ddlutils$platform$mckoi$MckoiPlatform == null ? (class$org$apache$ddlutils$platform$mckoi$MckoiPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.mckoi.MckoiPlatform")) : class$org$apache$ddlutils$platform$mckoi$MckoiPlatform);
        PlatformFactory.addPlatform(_platforms, "MsSql", class$org$apache$ddlutils$platform$mssql$MSSqlPlatform == null ? (class$org$apache$ddlutils$platform$mssql$MSSqlPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.mssql.MSSqlPlatform")) : class$org$apache$ddlutils$platform$mssql$MSSqlPlatform);
        PlatformFactory.addPlatform(_platforms, "MySQL", class$org$apache$ddlutils$platform$mysql$MySqlPlatform == null ? (class$org$apache$ddlutils$platform$mysql$MySqlPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.mysql.MySqlPlatform")) : class$org$apache$ddlutils$platform$mysql$MySqlPlatform);
        PlatformFactory.addPlatform(_platforms, "MySQL5", class$org$apache$ddlutils$platform$mysql$MySql50Platform == null ? (class$org$apache$ddlutils$platform$mysql$MySql50Platform = PlatformFactory.class$("org.apache.ddlutils.platform.mysql.MySql50Platform")) : class$org$apache$ddlutils$platform$mysql$MySql50Platform);
        PlatformFactory.addPlatform(_platforms, "Oracle", class$org$apache$ddlutils$platform$oracle$Oracle8Platform == null ? (class$org$apache$ddlutils$platform$oracle$Oracle8Platform = PlatformFactory.class$("org.apache.ddlutils.platform.oracle.Oracle8Platform")) : class$org$apache$ddlutils$platform$oracle$Oracle8Platform);
        PlatformFactory.addPlatform(_platforms, "Oracle9", class$org$apache$ddlutils$platform$oracle$Oracle9Platform == null ? (class$org$apache$ddlutils$platform$oracle$Oracle9Platform = PlatformFactory.class$("org.apache.ddlutils.platform.oracle.Oracle9Platform")) : class$org$apache$ddlutils$platform$oracle$Oracle9Platform);
        PlatformFactory.addPlatform(_platforms, "Oracle10", class$org$apache$ddlutils$platform$oracle$Oracle10Platform == null ? (class$org$apache$ddlutils$platform$oracle$Oracle10Platform = PlatformFactory.class$("org.apache.ddlutils.platform.oracle.Oracle10Platform")) : class$org$apache$ddlutils$platform$oracle$Oracle10Platform);
        PlatformFactory.addPlatform(_platforms, "PostgreSql", class$org$apache$ddlutils$platform$postgresql$PostgreSqlPlatform == null ? (class$org$apache$ddlutils$platform$postgresql$PostgreSqlPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.postgresql.PostgreSqlPlatform")) : class$org$apache$ddlutils$platform$postgresql$PostgreSqlPlatform);
        PlatformFactory.addPlatform(_platforms, "SapDB", class$org$apache$ddlutils$platform$sapdb$SapDbPlatform == null ? (class$org$apache$ddlutils$platform$sapdb$SapDbPlatform = PlatformFactory.class$("org.apache.ddlutils.platform.sapdb.SapDbPlatform")) : class$org$apache$ddlutils$platform$sapdb$SapDbPlatform);
        PlatformFactory.addPlatform(_platforms, "Sybase", class$org$apache$ddlutils$platform$sybase$SybasePlatform == null ? (class$org$apache$ddlutils$platform$sybase$SybasePlatform = PlatformFactory.class$("org.apache.ddlutils.platform.sybase.SybasePlatform")) : class$org$apache$ddlutils$platform$sybase$SybasePlatform);
        PlatformFactory.addPlatform(_platforms, "SybaseASE15", class$org$apache$ddlutils$platform$sybase$SybaseASE15Platform == null ? (class$org$apache$ddlutils$platform$sybase$SybaseASE15Platform = PlatformFactory.class$("org.apache.ddlutils.platform.sybase.SybaseASE15Platform")) : class$org$apache$ddlutils$platform$sybase$SybaseASE15Platform);
    }

    private static synchronized void addPlatform(Map platformMap, String platformName, Class platformClass) {
        if (!(class$org$apache$ddlutils$Platform == null ? (class$org$apache$ddlutils$Platform = PlatformFactory.class$("org.apache.ddlutils.Platform")) : class$org$apache$ddlutils$Platform).isAssignableFrom(platformClass)) {
            throw new IllegalArgumentException("Cannot register class " + platformClass.getName() + " because it does not implement the " + (class$org$apache$ddlutils$Platform == null ? (class$org$apache$ddlutils$Platform = PlatformFactory.class$("org.apache.ddlutils.Platform")) : class$org$apache$ddlutils$Platform).getName() + " interface");
        }
        platformMap.put(platformName.toLowerCase(), platformClass);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

