/*******************************************************************************
* Copyright (c) 2018 - 2020 Xilinx, Inc.  All rights reserved.
* SPDX-License-Identifier: MIT
*******************************************************************************/


#ifndef __XPMC_XMPU_H__
#define __XPMC_XMPU_H__


#ifdef __cplusplus
extern "C" {
#endif

/**
 * XpmcXmpu Base Address
 */
#define XPMC_XMPU_BASEADDR      0xF12F0000UL

/**
 * Register: XpmcXmpuCtrl
 */
#define XPMC_XMPU_CTRL    ( ( XPMC_XMPU_BASEADDR ) + 0x00000000UL )
#define XPMC_XMPU_CTRL_RSTVAL   0x00000013UL

#define XPMC_XMPU_CTRL_DISDEFSREGION_SHIFT   4UL
#define XPMC_XMPU_CTRL_DISDEFSREGION_WIDTH   1UL
#define XPMC_XMPU_CTRL_DISDEFSREGION_MASK    0x00000010UL
#define XPMC_XMPU_CTRL_DISDEFSREGION_DEFVAL  0x1UL

#define XPMC_XMPU_CTRL_ALIGNCFG_SHIFT   3UL
#define XPMC_XMPU_CTRL_ALIGNCFG_WIDTH   1UL
#define XPMC_XMPU_CTRL_ALIGNCFG_MASK    0x00000008UL
#define XPMC_XMPU_CTRL_ALIGNCFG_DEFVAL  0x0UL

#define XPMC_XMPU_CTRL_HIDEALLOWED_SHIFT   2UL
#define XPMC_XMPU_CTRL_HIDEALLOWED_WIDTH   1UL
#define XPMC_XMPU_CTRL_HIDEALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_CTRL_HIDEALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_CTRL_DEFWRALLOWED_SHIFT   1UL
#define XPMC_XMPU_CTRL_DEFWRALLOWED_WIDTH   1UL
#define XPMC_XMPU_CTRL_DEFWRALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_CTRL_DEFWRALLOWED_DEFVAL  0x1UL

#define XPMC_XMPU_CTRL_DEFRDALLOWED_SHIFT   0UL
#define XPMC_XMPU_CTRL_DEFRDALLOWED_WIDTH   1UL
#define XPMC_XMPU_CTRL_DEFRDALLOWED_MASK    0x00000001UL
#define XPMC_XMPU_CTRL_DEFRDALLOWED_DEFVAL  0x1UL

/**
 * Register: XpmcXmpuErrSts1Lo
 */
#define XPMC_XMPU_ERR_STS1_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000004UL )
#define XPMC_XMPU_ERR_STS1_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_ERR_STS1_LO_AXI_ADDR_SHIFT   0UL
#define XPMC_XMPU_ERR_STS1_LO_AXI_ADDR_WIDTH   32UL
#define XPMC_XMPU_ERR_STS1_LO_AXI_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_ERR_STS1_LO_AXI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuErrSts1Hi
 */
#define XPMC_XMPU_ERR_STS1_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000008UL )
#define XPMC_XMPU_ERR_STS1_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_ERR_STS1_HI_AXI_ADDR_SHIFT   0UL
#define XPMC_XMPU_ERR_STS1_HI_AXI_ADDR_WIDTH   12UL
#define XPMC_XMPU_ERR_STS1_HI_AXI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_ERR_STS1_HI_AXI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuErrSts2
 */
#define XPMC_XMPU_ERR_STS2    ( ( XPMC_XMPU_BASEADDR ) + 0x0000000CUL )
#define XPMC_XMPU_ERR_STS2_RSTVAL   0x00000000UL

#define XPMC_XMPU_ERR_STS2_AXI_ID_SHIFT   0UL
#define XPMC_XMPU_ERR_STS2_AXI_ID_WIDTH   10UL
#define XPMC_XMPU_ERR_STS2_AXI_ID_MASK    0x000003ffUL
#define XPMC_XMPU_ERR_STS2_AXI_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuIsr
 */
#define XPMC_XMPU_ISR    ( ( XPMC_XMPU_BASEADDR ) + 0x00000010UL )
#define XPMC_XMPU_ISR_RSTVAL   0x00000000UL

#define XPMC_XMPU_ISR_SECURITYVIO_SHIFT   3UL
#define XPMC_XMPU_ISR_SECURITYVIO_WIDTH   1UL
#define XPMC_XMPU_ISR_SECURITYVIO_MASK    0x00000008UL
#define XPMC_XMPU_ISR_SECURITYVIO_DEFVAL  0x0UL

#define XPMC_XMPU_ISR_WRPERMVIO_SHIFT   2UL
#define XPMC_XMPU_ISR_WRPERMVIO_WIDTH   1UL
#define XPMC_XMPU_ISR_WRPERMVIO_MASK    0x00000004UL
#define XPMC_XMPU_ISR_WRPERMVIO_DEFVAL  0x0UL

#define XPMC_XMPU_ISR_RDPERMVIO_SHIFT   1UL
#define XPMC_XMPU_ISR_RDPERMVIO_WIDTH   1UL
#define XPMC_XMPU_ISR_RDPERMVIO_MASK    0x00000002UL
#define XPMC_XMPU_ISR_RDPERMVIO_DEFVAL  0x0UL

#define XPMC_XMPU_ISR_INV_APB_SHIFT   0UL
#define XPMC_XMPU_ISR_INV_APB_WIDTH   1UL
#define XPMC_XMPU_ISR_INV_APB_MASK    0x00000001UL
#define XPMC_XMPU_ISR_INV_APB_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuImr
 */
#define XPMC_XMPU_IMR    ( ( XPMC_XMPU_BASEADDR ) + 0x00000014UL )
#define XPMC_XMPU_IMR_RSTVAL   0x0000000fUL

#define XPMC_XMPU_IMR_SECURITYVIO_SHIFT   3UL
#define XPMC_XMPU_IMR_SECURITYVIO_WIDTH   1UL
#define XPMC_XMPU_IMR_SECURITYVIO_MASK    0x00000008UL
#define XPMC_XMPU_IMR_SECURITYVIO_DEFVAL  0x1UL

#define XPMC_XMPU_IMR_WRPERMVIO_SHIFT   2UL
#define XPMC_XMPU_IMR_WRPERMVIO_WIDTH   1UL
#define XPMC_XMPU_IMR_WRPERMVIO_MASK    0x00000004UL
#define XPMC_XMPU_IMR_WRPERMVIO_DEFVAL  0x1UL

#define XPMC_XMPU_IMR_RDPERMVIO_SHIFT   1UL
#define XPMC_XMPU_IMR_RDPERMVIO_WIDTH   1UL
#define XPMC_XMPU_IMR_RDPERMVIO_MASK    0x00000002UL
#define XPMC_XMPU_IMR_RDPERMVIO_DEFVAL  0x1UL

#define XPMC_XMPU_IMR_INV_APB_SHIFT   0UL
#define XPMC_XMPU_IMR_INV_APB_WIDTH   1UL
#define XPMC_XMPU_IMR_INV_APB_MASK    0x00000001UL
#define XPMC_XMPU_IMR_INV_APB_DEFVAL  0x1UL

/**
 * Register: XpmcXmpuIen
 */
#define XPMC_XMPU_IEN    ( ( XPMC_XMPU_BASEADDR ) + 0x00000018UL )
#define XPMC_XMPU_IEN_RSTVAL   0x00000000UL

#define XPMC_XMPU_IEN_SECURITYVIO_SHIFT   3UL
#define XPMC_XMPU_IEN_SECURITYVIO_WIDTH   1UL
#define XPMC_XMPU_IEN_SECURITYVIO_MASK    0x00000008UL
#define XPMC_XMPU_IEN_SECURITYVIO_DEFVAL  0x0UL

#define XPMC_XMPU_IEN_WRPERMVIO_SHIFT   2UL
#define XPMC_XMPU_IEN_WRPERMVIO_WIDTH   1UL
#define XPMC_XMPU_IEN_WRPERMVIO_MASK    0x00000004UL
#define XPMC_XMPU_IEN_WRPERMVIO_DEFVAL  0x0UL

#define XPMC_XMPU_IEN_RDPERMVIO_SHIFT   1UL
#define XPMC_XMPU_IEN_RDPERMVIO_WIDTH   1UL
#define XPMC_XMPU_IEN_RDPERMVIO_MASK    0x00000002UL
#define XPMC_XMPU_IEN_RDPERMVIO_DEFVAL  0x0UL

#define XPMC_XMPU_IEN_INV_APB_SHIFT   0UL
#define XPMC_XMPU_IEN_INV_APB_WIDTH   1UL
#define XPMC_XMPU_IEN_INV_APB_MASK    0x00000001UL
#define XPMC_XMPU_IEN_INV_APB_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuIds
 */
#define XPMC_XMPU_IDS    ( ( XPMC_XMPU_BASEADDR ) + 0x0000001CUL )
#define XPMC_XMPU_IDS_RSTVAL   0x00000000UL

#define XPMC_XMPU_IDS_SECURITYVIO_SHIFT   3UL
#define XPMC_XMPU_IDS_SECURITYVIO_WIDTH   1UL
#define XPMC_XMPU_IDS_SECURITYVIO_MASK    0x00000008UL
#define XPMC_XMPU_IDS_SECURITYVIO_DEFVAL  0x0UL

#define XPMC_XMPU_IDS_WRPERMVIO_SHIFT   2UL
#define XPMC_XMPU_IDS_WRPERMVIO_WIDTH   1UL
#define XPMC_XMPU_IDS_WRPERMVIO_MASK    0x00000004UL
#define XPMC_XMPU_IDS_WRPERMVIO_DEFVAL  0x0UL

#define XPMC_XMPU_IDS_RDPERMVIO_SHIFT   1UL
#define XPMC_XMPU_IDS_RDPERMVIO_WIDTH   1UL
#define XPMC_XMPU_IDS_RDPERMVIO_MASK    0x00000002UL
#define XPMC_XMPU_IDS_RDPERMVIO_DEFVAL  0x0UL

#define XPMC_XMPU_IDS_INV_APB_SHIFT   0UL
#define XPMC_XMPU_IDS_INV_APB_WIDTH   1UL
#define XPMC_XMPU_IDS_INV_APB_MASK    0x00000001UL
#define XPMC_XMPU_IDS_INV_APB_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuLock
 */
#define XPMC_XMPU_LOCK    ( ( XPMC_XMPU_BASEADDR ) + 0x00000020UL )
#define XPMC_XMPU_LOCK_RSTVAL   0x00000000UL

#define XPMC_XMPU_LOCK_REGWRDIS_SHIFT   0UL
#define XPMC_XMPU_LOCK_REGWRDIS_WIDTH   1UL
#define XPMC_XMPU_LOCK_REGWRDIS_MASK    0x00000001UL
#define XPMC_XMPU_LOCK_REGWRDIS_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR00StartLo
 */
#define XPMC_XMPU_R00_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000100UL )
#define XPMC_XMPU_R00_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R00_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R00_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R00_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R00_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR00StartHi
 */
#define XPMC_XMPU_R00_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000104UL )
#define XPMC_XMPU_R00_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R00_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R00_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R00_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R00_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR00EndLo
 */
#define XPMC_XMPU_R00_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000108UL )
#define XPMC_XMPU_R00_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R00_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R00_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R00_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R00_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR00EndHi
 */
#define XPMC_XMPU_R00_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000010CUL )
#define XPMC_XMPU_R00_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R00_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R00_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R00_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R00_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR00Master
 */
#define XPMC_XMPU_R00_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000110UL )
#define XPMC_XMPU_R00_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R00_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R00_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R00_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R00_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R00_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R00_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R00_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R00_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR00Cfg
 */
#define XPMC_XMPU_R00_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x00000114UL )
#define XPMC_XMPU_R00_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R00_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R00_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R00_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R00_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R00_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R00_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R00_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R00_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R00_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R00_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R00_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R00_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R00_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R00_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R00_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R00_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R00_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R00_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R00_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R00_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR01StartLo
 */
#define XPMC_XMPU_R01_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000118UL )
#define XPMC_XMPU_R01_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R01_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R01_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R01_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R01_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR01StartHi
 */
#define XPMC_XMPU_R01_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000011CUL )
#define XPMC_XMPU_R01_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R01_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R01_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R01_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R01_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR01EndLo
 */
#define XPMC_XMPU_R01_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000120UL )
#define XPMC_XMPU_R01_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R01_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R01_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R01_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R01_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR01EndHi
 */
#define XPMC_XMPU_R01_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000124UL )
#define XPMC_XMPU_R01_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R01_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R01_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R01_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R01_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR01Master
 */
#define XPMC_XMPU_R01_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000128UL )
#define XPMC_XMPU_R01_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R01_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R01_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R01_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R01_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R01_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R01_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R01_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R01_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR01Cfg
 */
#define XPMC_XMPU_R01_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x0000012CUL )
#define XPMC_XMPU_R01_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R01_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R01_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R01_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R01_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R01_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R01_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R01_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R01_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R01_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R01_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R01_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R01_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R01_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R01_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R01_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R01_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R01_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R01_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R01_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R01_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR02StartLo
 */
#define XPMC_XMPU_R02_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000130UL )
#define XPMC_XMPU_R02_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R02_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R02_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R02_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R02_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR02StartHi
 */
#define XPMC_XMPU_R02_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000134UL )
#define XPMC_XMPU_R02_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R02_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R02_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R02_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R02_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR02EndLo
 */
#define XPMC_XMPU_R02_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000138UL )
#define XPMC_XMPU_R02_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R02_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R02_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R02_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R02_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR02EndHi
 */
#define XPMC_XMPU_R02_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000013CUL )
#define XPMC_XMPU_R02_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R02_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R02_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R02_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R02_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR02Master
 */
#define XPMC_XMPU_R02_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000140UL )
#define XPMC_XMPU_R02_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R02_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R02_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R02_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R02_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R02_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R02_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R02_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R02_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR02Cfg
 */
#define XPMC_XMPU_R02_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x00000144UL )
#define XPMC_XMPU_R02_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R02_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R02_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R02_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R02_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R02_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R02_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R02_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R02_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R02_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R02_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R02_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R02_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R02_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R02_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R02_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R02_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R02_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R02_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R02_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R02_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR03StartLo
 */
#define XPMC_XMPU_R03_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000148UL )
#define XPMC_XMPU_R03_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R03_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R03_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R03_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R03_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR03StartHi
 */
#define XPMC_XMPU_R03_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000014CUL )
#define XPMC_XMPU_R03_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R03_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R03_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R03_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R03_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR03EndLo
 */
#define XPMC_XMPU_R03_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000150UL )
#define XPMC_XMPU_R03_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R03_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R03_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R03_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R03_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR03EndHi
 */
#define XPMC_XMPU_R03_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000154UL )
#define XPMC_XMPU_R03_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R03_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R03_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R03_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R03_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR03Master
 */
#define XPMC_XMPU_R03_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000158UL )
#define XPMC_XMPU_R03_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R03_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R03_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R03_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R03_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R03_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R03_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R03_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R03_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR03Cfg
 */
#define XPMC_XMPU_R03_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x0000015CUL )
#define XPMC_XMPU_R03_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R03_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R03_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R03_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R03_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R03_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R03_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R03_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R03_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R03_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R03_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R03_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R03_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R03_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R03_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R03_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R03_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R03_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R03_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R03_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R03_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR04StartLo
 */
#define XPMC_XMPU_R04_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000160UL )
#define XPMC_XMPU_R04_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R04_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R04_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R04_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R04_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR04StartHi
 */
#define XPMC_XMPU_R04_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000164UL )
#define XPMC_XMPU_R04_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R04_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R04_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R04_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R04_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR04EndLo
 */
#define XPMC_XMPU_R04_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000168UL )
#define XPMC_XMPU_R04_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R04_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R04_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R04_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R04_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR04EndHi
 */
#define XPMC_XMPU_R04_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000016CUL )
#define XPMC_XMPU_R04_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R04_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R04_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R04_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R04_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR04Master
 */
#define XPMC_XMPU_R04_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000170UL )
#define XPMC_XMPU_R04_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R04_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R04_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R04_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R04_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R04_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R04_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R04_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R04_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR04Cfg
 */
#define XPMC_XMPU_R04_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x00000174UL )
#define XPMC_XMPU_R04_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R04_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R04_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R04_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R04_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R04_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R04_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R04_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R04_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R04_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R04_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R04_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R04_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R04_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R04_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R04_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R04_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R04_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R04_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R04_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R04_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR05StartLo
 */
#define XPMC_XMPU_R05_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000178UL )
#define XPMC_XMPU_R05_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R05_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R05_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R05_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R05_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR05StartHi
 */
#define XPMC_XMPU_R05_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000017CUL )
#define XPMC_XMPU_R05_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R05_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R05_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R05_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R05_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR05EndLo
 */
#define XPMC_XMPU_R05_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000180UL )
#define XPMC_XMPU_R05_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R05_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R05_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R05_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R05_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR05EndHi
 */
#define XPMC_XMPU_R05_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000184UL )
#define XPMC_XMPU_R05_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R05_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R05_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R05_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R05_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR05Master
 */
#define XPMC_XMPU_R05_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000188UL )
#define XPMC_XMPU_R05_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R05_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R05_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R05_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R05_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R05_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R05_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R05_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R05_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR05Cfg
 */
#define XPMC_XMPU_R05_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x0000018CUL )
#define XPMC_XMPU_R05_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R05_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R05_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R05_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R05_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R05_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R05_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R05_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R05_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R05_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R05_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R05_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R05_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R05_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R05_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R05_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R05_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R05_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R05_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R05_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R05_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR06StartLo
 */
#define XPMC_XMPU_R06_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000190UL )
#define XPMC_XMPU_R06_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R06_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R06_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R06_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R06_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR06StartHi
 */
#define XPMC_XMPU_R06_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000194UL )
#define XPMC_XMPU_R06_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R06_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R06_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R06_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R06_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR06EndLo
 */
#define XPMC_XMPU_R06_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000198UL )
#define XPMC_XMPU_R06_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R06_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R06_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R06_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R06_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR06EndHi
 */
#define XPMC_XMPU_R06_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000019CUL )
#define XPMC_XMPU_R06_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R06_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R06_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R06_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R06_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR06Master
 */
#define XPMC_XMPU_R06_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x000001A0UL )
#define XPMC_XMPU_R06_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R06_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R06_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R06_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R06_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R06_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R06_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R06_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R06_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR06Cfg
 */
#define XPMC_XMPU_R06_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x000001A4UL )
#define XPMC_XMPU_R06_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R06_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R06_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R06_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R06_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R06_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R06_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R06_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R06_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R06_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R06_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R06_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R06_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R06_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R06_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R06_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R06_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R06_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R06_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R06_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R06_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR07StartLo
 */
#define XPMC_XMPU_R07_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x000001A8UL )
#define XPMC_XMPU_R07_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R07_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R07_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R07_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R07_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR07StartHi
 */
#define XPMC_XMPU_R07_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x000001ACUL )
#define XPMC_XMPU_R07_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R07_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R07_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R07_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R07_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR07EndLo
 */
#define XPMC_XMPU_R07_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x000001B0UL )
#define XPMC_XMPU_R07_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R07_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R07_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R07_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R07_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR07EndHi
 */
#define XPMC_XMPU_R07_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x000001B4UL )
#define XPMC_XMPU_R07_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R07_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R07_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R07_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R07_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR07Master
 */
#define XPMC_XMPU_R07_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x000001B8UL )
#define XPMC_XMPU_R07_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R07_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R07_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R07_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R07_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R07_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R07_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R07_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R07_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR07Cfg
 */
#define XPMC_XMPU_R07_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x000001BCUL )
#define XPMC_XMPU_R07_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R07_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R07_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R07_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R07_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R07_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R07_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R07_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R07_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R07_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R07_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R07_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R07_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R07_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R07_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R07_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R07_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R07_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R07_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R07_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R07_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR08StartLo
 */
#define XPMC_XMPU_R08_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x000001C0UL )
#define XPMC_XMPU_R08_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R08_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R08_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R08_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R08_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR08StartHi
 */
#define XPMC_XMPU_R08_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x000001C4UL )
#define XPMC_XMPU_R08_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R08_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R08_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R08_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R08_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR08EndLo
 */
#define XPMC_XMPU_R08_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x000001C8UL )
#define XPMC_XMPU_R08_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R08_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R08_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R08_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R08_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR08EndHi
 */
#define XPMC_XMPU_R08_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x000001CCUL )
#define XPMC_XMPU_R08_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R08_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R08_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R08_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R08_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR08Master
 */
#define XPMC_XMPU_R08_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x000001D0UL )
#define XPMC_XMPU_R08_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R08_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R08_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R08_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R08_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R08_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R08_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R08_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R08_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR08Cfg
 */
#define XPMC_XMPU_R08_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x000001D4UL )
#define XPMC_XMPU_R08_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R08_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R08_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R08_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R08_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R08_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R08_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R08_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R08_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R08_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R08_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R08_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R08_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R08_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R08_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R08_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R08_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R08_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R08_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R08_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R08_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR09StartLo
 */
#define XPMC_XMPU_R09_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x000001D8UL )
#define XPMC_XMPU_R09_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R09_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R09_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R09_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R09_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR09StartHi
 */
#define XPMC_XMPU_R09_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x000001DCUL )
#define XPMC_XMPU_R09_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R09_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R09_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R09_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R09_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR09EndLo
 */
#define XPMC_XMPU_R09_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x000001E0UL )
#define XPMC_XMPU_R09_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R09_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R09_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R09_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R09_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR09EndHi
 */
#define XPMC_XMPU_R09_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x000001E4UL )
#define XPMC_XMPU_R09_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R09_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R09_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R09_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R09_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR09Master
 */
#define XPMC_XMPU_R09_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x000001E8UL )
#define XPMC_XMPU_R09_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R09_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R09_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R09_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R09_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R09_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R09_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R09_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R09_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR09Cfg
 */
#define XPMC_XMPU_R09_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x000001ECUL )
#define XPMC_XMPU_R09_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R09_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R09_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R09_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R09_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R09_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R09_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R09_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R09_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R09_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R09_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R09_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R09_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R09_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R09_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R09_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R09_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R09_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R09_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R09_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R09_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR10StartLo
 */
#define XPMC_XMPU_R10_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x000001F0UL )
#define XPMC_XMPU_R10_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R10_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R10_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R10_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R10_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR10StartHi
 */
#define XPMC_XMPU_R10_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x000001F4UL )
#define XPMC_XMPU_R10_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R10_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R10_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R10_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R10_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR10EndLo
 */
#define XPMC_XMPU_R10_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x000001F8UL )
#define XPMC_XMPU_R10_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R10_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R10_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R10_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R10_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR10EndHi
 */
#define XPMC_XMPU_R10_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x000001FCUL )
#define XPMC_XMPU_R10_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R10_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R10_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R10_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R10_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR10Master
 */
#define XPMC_XMPU_R10_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000200UL )
#define XPMC_XMPU_R10_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R10_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R10_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R10_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R10_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R10_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R10_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R10_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R10_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR10Cfg
 */
#define XPMC_XMPU_R10_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x00000204UL )
#define XPMC_XMPU_R10_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R10_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R10_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R10_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R10_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R10_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R10_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R10_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R10_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R10_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R10_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R10_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R10_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R10_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R10_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R10_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R10_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R10_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R10_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R10_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R10_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR11StartLo
 */
#define XPMC_XMPU_R11_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000208UL )
#define XPMC_XMPU_R11_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R11_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R11_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R11_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R11_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR11StartHi
 */
#define XPMC_XMPU_R11_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000020CUL )
#define XPMC_XMPU_R11_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R11_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R11_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R11_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R11_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR11EndLo
 */
#define XPMC_XMPU_R11_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000210UL )
#define XPMC_XMPU_R11_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R11_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R11_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R11_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R11_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR11EndHi
 */
#define XPMC_XMPU_R11_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000214UL )
#define XPMC_XMPU_R11_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R11_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R11_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R11_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R11_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR11Master
 */
#define XPMC_XMPU_R11_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000218UL )
#define XPMC_XMPU_R11_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R11_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R11_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R11_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R11_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R11_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R11_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R11_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R11_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR11Cfg
 */
#define XPMC_XMPU_R11_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x0000021CUL )
#define XPMC_XMPU_R11_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R11_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R11_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R11_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R11_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R11_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R11_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R11_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R11_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R11_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R11_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R11_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R11_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R11_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R11_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R11_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R11_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R11_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R11_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R11_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R11_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR12StartLo
 */
#define XPMC_XMPU_R12_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000220UL )
#define XPMC_XMPU_R12_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R12_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R12_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R12_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R12_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR12StartHi
 */
#define XPMC_XMPU_R12_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000224UL )
#define XPMC_XMPU_R12_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R12_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R12_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R12_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R12_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR12EndLo
 */
#define XPMC_XMPU_R12_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000228UL )
#define XPMC_XMPU_R12_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R12_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R12_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R12_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R12_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR12EndHi
 */
#define XPMC_XMPU_R12_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000022CUL )
#define XPMC_XMPU_R12_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R12_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R12_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R12_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R12_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR12Master
 */
#define XPMC_XMPU_R12_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000238UL )
#define XPMC_XMPU_R12_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R12_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R12_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R12_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R12_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R12_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R12_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R12_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R12_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR12Cfg
 */
#define XPMC_XMPU_R12_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x0000023CUL )
#define XPMC_XMPU_R12_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R12_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R12_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R12_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R12_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R12_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R12_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R12_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R12_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R12_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R12_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R12_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R12_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R12_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R12_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R12_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R12_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R12_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R12_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R12_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R12_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR13StartLo
 */
#define XPMC_XMPU_R13_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000240UL )
#define XPMC_XMPU_R13_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R13_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R13_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R13_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R13_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR13StartHi
 */
#define XPMC_XMPU_R13_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000244UL )
#define XPMC_XMPU_R13_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R13_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R13_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R13_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R13_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR13EndLo
 */
#define XPMC_XMPU_R13_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000248UL )
#define XPMC_XMPU_R13_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R13_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R13_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R13_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R13_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR13EndHi
 */
#define XPMC_XMPU_R13_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000024CUL )
#define XPMC_XMPU_R13_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R13_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R13_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R13_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R13_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR13Master
 */
#define XPMC_XMPU_R13_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000250UL )
#define XPMC_XMPU_R13_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R13_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R13_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R13_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R13_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R13_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R13_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R13_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R13_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR13Cfg
 */
#define XPMC_XMPU_R13_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x00000254UL )
#define XPMC_XMPU_R13_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R13_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R13_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R13_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R13_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R13_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R13_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R13_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R13_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R13_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R13_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R13_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R13_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R13_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R13_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R13_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R13_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R13_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R13_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R13_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R13_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR14StartLo
 */
#define XPMC_XMPU_R14_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000258UL )
#define XPMC_XMPU_R14_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R14_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R14_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R14_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R14_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR14StartHi
 */
#define XPMC_XMPU_R14_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000025CUL )
#define XPMC_XMPU_R14_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R14_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R14_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R14_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R14_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR14EndLo
 */
#define XPMC_XMPU_R14_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000260UL )
#define XPMC_XMPU_R14_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R14_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R14_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R14_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R14_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR14EndHi
 */
#define XPMC_XMPU_R14_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000264UL )
#define XPMC_XMPU_R14_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R14_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R14_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R14_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R14_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR14Master
 */
#define XPMC_XMPU_R14_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000268UL )
#define XPMC_XMPU_R14_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R14_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R14_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R14_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R14_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R14_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R14_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R14_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R14_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR14Cfg
 */
#define XPMC_XMPU_R14_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x0000026CUL )
#define XPMC_XMPU_R14_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R14_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R14_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R14_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R14_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R14_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R14_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R14_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R14_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R14_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R14_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R14_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R14_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R14_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R14_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R14_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R14_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R14_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R14_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R14_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R14_CFG_EN_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR15StartLo
 */
#define XPMC_XMPU_R15_START_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000270UL )
#define XPMC_XMPU_R15_START_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R15_START_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R15_START_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R15_START_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R15_START_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR15StartHi
 */
#define XPMC_XMPU_R15_START_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x00000274UL )
#define XPMC_XMPU_R15_START_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R15_START_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R15_START_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R15_START_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R15_START_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR15EndLo
 */
#define XPMC_XMPU_R15_END_LO    ( ( XPMC_XMPU_BASEADDR ) + 0x00000278UL )
#define XPMC_XMPU_R15_END_LO_RSTVAL   0x00000000UL

#define XPMC_XMPU_R15_END_LO_ADDR_SHIFT   0UL
#define XPMC_XMPU_R15_END_LO_ADDR_WIDTH   32UL
#define XPMC_XMPU_R15_END_LO_ADDR_MASK    0xffffffffUL
#define XPMC_XMPU_R15_END_LO_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR15EndHi
 */
#define XPMC_XMPU_R15_END_HI    ( ( XPMC_XMPU_BASEADDR ) + 0x0000027CUL )
#define XPMC_XMPU_R15_END_HI_RSTVAL   0x00000000UL

#define XPMC_XMPU_R15_END_HI_ADDR_SHIFT   0UL
#define XPMC_XMPU_R15_END_HI_ADDR_WIDTH   12UL
#define XPMC_XMPU_R15_END_HI_ADDR_MASK    0x00000fffUL
#define XPMC_XMPU_R15_END_HI_ADDR_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR15Master
 */
#define XPMC_XMPU_R15_MASTER    ( ( XPMC_XMPU_BASEADDR ) + 0x00000280UL )
#define XPMC_XMPU_R15_MASTER_RSTVAL   0x00000000UL

#define XPMC_XMPU_R15_MASTER_MSK_SHIFT   16UL
#define XPMC_XMPU_R15_MASTER_MSK_WIDTH   10UL
#define XPMC_XMPU_R15_MASTER_MSK_MASK    0x03ff0000UL
#define XPMC_XMPU_R15_MASTER_MSK_DEFVAL  0x0UL

#define XPMC_XMPU_R15_MASTER_ID_SHIFT   0UL
#define XPMC_XMPU_R15_MASTER_ID_WIDTH   10UL
#define XPMC_XMPU_R15_MASTER_ID_MASK    0x000003ffUL
#define XPMC_XMPU_R15_MASTER_ID_DEFVAL  0x0UL

/**
 * Register: XpmcXmpuR15Cfg
 */
#define XPMC_XMPU_R15_CFG    ( ( XPMC_XMPU_BASEADDR ) + 0x00000284UL )
#define XPMC_XMPU_R15_CFG_RSTVAL   0x00000008UL

#define XPMC_XMPU_R15_CFG_NSCHECKTYPE_SHIFT   4UL
#define XPMC_XMPU_R15_CFG_NSCHECKTYPE_WIDTH   1UL
#define XPMC_XMPU_R15_CFG_NSCHECKTYPE_MASK    0x00000010UL
#define XPMC_XMPU_R15_CFG_NSCHECKTYPE_DEFVAL  0x0UL

#define XPMC_XMPU_R15_CFG_REGIONNS_SHIFT   3UL
#define XPMC_XMPU_R15_CFG_REGIONNS_WIDTH   1UL
#define XPMC_XMPU_R15_CFG_REGIONNS_MASK    0x00000008UL
#define XPMC_XMPU_R15_CFG_REGIONNS_DEFVAL  0x1UL

#define XPMC_XMPU_R15_CFG_WRALLOWED_SHIFT   2UL
#define XPMC_XMPU_R15_CFG_WRALLOWED_WIDTH   1UL
#define XPMC_XMPU_R15_CFG_WRALLOWED_MASK    0x00000004UL
#define XPMC_XMPU_R15_CFG_WRALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R15_CFG_RDALLOWED_SHIFT   1UL
#define XPMC_XMPU_R15_CFG_RDALLOWED_WIDTH   1UL
#define XPMC_XMPU_R15_CFG_RDALLOWED_MASK    0x00000002UL
#define XPMC_XMPU_R15_CFG_RDALLOWED_DEFVAL  0x0UL

#define XPMC_XMPU_R15_CFG_EN_SHIFT   0UL
#define XPMC_XMPU_R15_CFG_EN_WIDTH   1UL
#define XPMC_XMPU_R15_CFG_EN_MASK    0x00000001UL
#define XPMC_XMPU_R15_CFG_EN_DEFVAL  0x0UL


#ifdef __cplusplus
}
#endif

#endif /* __XPMC_XMPU_H__ */
