/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.ietf.uri.IllegalActionException;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URI;

public abstract class HttpResourceConnection
extends ResourceConnection {
    public static final int INVALID_HTTP_RESPONSE = -1;
    public static final int HTTP_OK = 200;
    public static final int HTTP_CREATED = 201;
    public static final int HTTP_ACCEPTED = 202;
    public static final int HTTP_NOT_AUTHORITATIVE = 203;
    public static final int HTTP_NO_CONTENT = 204;
    public static final int HTTP_RESET = 205;
    public static final int HTTP_PARTIAL = 206;
    public static final int HTTP_MULT_CHOICE = 300;
    public static final int HTTP_MOVED_PERM = 301;
    public static final int HTTP_MOVED_TEMP = 302;
    public static final int HTTP_SEE_OTHER = 303;
    public static final int HTTP_NOT_MODIFIED = 304;
    public static final int HTTP_USE_PROXY = 305;
    public static final int HTTP_BAD_REQUEST = 400;
    public static final int HTTP_UNAUTHORIZED = 401;
    public static final int HTTP_PAYMENT_REQUIRED = 402;
    public static final int HTTP_FORBIDDEN = 403;
    public static final int HTTP_NOT_FOUND = 404;
    public static final int HTTP_BAD_METHOD = 405;
    public static final int HTTP_NOT_ACCEPTABLE = 406;
    public static final int HTTP_PROXY_AUTH = 407;
    public static final int HTTP_CLIENT_TIMEOUT = 408;
    public static final int HTTP_CONFLICT = 409;
    public static final int HTTP_GONE = 410;
    public static final int HTTP_LENGTH_REQUIRED = 411;
    public static final int HTTP_PRECON_FAILED = 412;
    public static final int HTTP_ENTITY_TOO_LARGE = 413;
    public static final int HTTP_REQ_TOO_LONG = 414;
    public static final int HTTP_UNSUPPORTED_TYPE = 415;
    public static final int HTTP_SERVER_ERROR = 500;
    public static final int HTTP_INTERNAL_ERROR = 501;
    public static final int HTTP_BAD_GATEWAY = 502;
    public static final int HTTP_UNAVAILABLE = 503;
    public static final int HTTP_GATEWAY_TIMEOUT = 504;
    public static final int HTTP_VERSION = 505;
    public static final String GET_METHOD = "GET";
    public static final String POST_METHOD = "POST";
    public static final String HEAD_METHOD = "HEAD";
    public static final String OPTIONS_METHOD = "OPTIONS";
    public static final String PUT_METHOD = "PUT";
    public static final String DELETE_METHOD = "DELETE";
    public static final String TRACE_METHOD = "TRACE";
    public static final String INVALID_RESPONSE_MSG = "Invalid HTTP response";
    public static final String IF_MODIFIED_HEADER = "If-Modified-Since";
    public static final String CONTENT_TYPE_HEADER = "Content-Type";
    public static final String CONTENT_LENGTH_HEADER = "Content-Length";
    public static final String LOCATION_HEADER = "Location";
    private static final String PROXY_HOST_PROP = "http.proxyHost";
    private static final String PROXY_PORT_PROP = "http.proxyPort";
    private static final String NO_PROXY_PROP = "http.noProxyHosts";
    private static final String USER_AGENT_PROP = "http.agent";
    private static final String COOKIE_PROP = "http.allowCookies";
    private static final String REDIRECT_PROP = "http.allowRedirects";
    private static final String NUM_REDIRECT_PROP = "http.numRedirects";
    private static final int DEFAULT_MAX_REDIRECTS;
    protected static boolean followRedirects;
    protected int maxRedirects = DEFAULT_MAX_REDIRECTS;
    protected static boolean allowCookies;
    protected static String proxyHost;
    protected static int proxyPort;
    protected static List nonProxiedHosts;
    protected static String userAgent;
    protected String method = "GET";
    protected int responseCode = -1;
    protected String responseMsg = null;
    protected boolean proxyInUse = false;
    private String content_type = null;
    private int content_length = -1;

    protected HttpResourceConnection(URI uRI) {
        super(uRI);
    }

    public abstract void disconnect();

    public static void setFollowRedirects(boolean bl) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSetFactory();
        }
        followRedirects = bl;
    }

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public void setMaxRedirects(int n) throws IllegalActionException {
        if (this.connected) {
            throw new IllegalActionException("Connection established");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Negative max redirects");
        }
        this.maxRedirects = n;
    }

    public static void setAllowCookies(boolean bl) {
        allowCookies = bl;
    }

    public static boolean getAllowCookies() {
        return allowCookies;
    }

    public boolean usingProxy() {
        return this.proxyInUse;
    }

    public static void setProxyHost(String string) throws SecurityException {
        proxyHost = string;
    }

    public static String getProxyHost() {
        return proxyHost;
    }

    public static void setProxyPort(int n) throws SecurityException {
        proxyPort = n;
    }

    public static int getProxyPort() {
        return proxyPort;
    }

    public static void addNoProxyForHost(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Null host name for don't proxy req");
        }
        nonProxiedHosts.add(string.toLowerCase());
    }

    public static void addNoProxyForHost(List list) {
        if (list == null) {
            return;
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Object e = list.get(i);
            if (e != null && e instanceof String) continue;
            list.remove(i);
        }
        nonProxiedHosts.addAll(list);
    }

    public static void removeNoProxyForHost(String string) {
        if (string == null) {
            return;
        }
        nonProxiedHosts.remove(string.toLowerCase());
    }

    public void setRequestMethod(String string) throws IllegalActionException {
        if (this.connected) {
            throw new IllegalActionException("Can't reset method: already connected");
        }
        this.method = string;
    }

    public String getRequestMethod() {
        return this.method;
    }

    public int getResponseCode() throws IOException {
        if (this.responseCode != -1) {
            return this.responseCode;
        }
        this.getInputStream();
        String string = this.getHeaderField(0);
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            stringTokenizer.nextToken();
            this.responseCode = Integer.parseInt(stringTokenizer.nextToken());
            this.responseMsg = stringTokenizer.nextToken("");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.responseCode;
    }

    public String getResponseMessage() throws IOException {
        if (this.responseMsg != null) {
            return this.responseMsg;
        }
        this.getResponseCode();
        return this.responseMsg;
    }

    public InputStream getErrorStream() {
        return null;
    }

    public String getContentType() {
        if (this.content_type == null) {
            this.content_type = this.getHeaderField(CONTENT_TYPE_HEADER);
        }
        return this.content_type;
    }

    public int getContentLength() {
        if (this.content_length == -1) {
            String string = this.getHeaderField(CONTENT_LENGTH_HEADER);
            try {
                this.content_length = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.content_length;
    }

    static {
        followRedirects = true;
        allowCookies = false;
        proxyHost = null;
        proxyPort = -1;
        nonProxiedHosts = new ArrayList();
        userAgent = null;
        allowCookies = Boolean.getBoolean(COOKIE_PROP);
        followRedirects = Boolean.getBoolean(REDIRECT_PROP);
        proxyPort = Integer.getInteger(PROXY_PORT_PROP, -1);
        DEFAULT_MAX_REDIRECTS = Integer.getInteger(NUM_REDIRECT_PROP, 5);
        try {
            userAgent = System.getProperty(USER_AGENT_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            proxyHost = System.getProperty(PROXY_HOST_PROP);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            String string = System.getProperty(NO_PROXY_PROP, "");
            StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
            while (stringTokenizer.hasMoreTokens()) {
                nonProxiedHosts.add(stringTokenizer.nextToken());
            }
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

