/* 
 * vflmklib.c 
 * by Hirotsugu Kakugawa
 * - commn functions used in vflmkXXX.c
 *
 *  10 May 2001
 */
/*
 * Copyright (C) 2001-2017 Hirotsugu Kakugawa. 
 * All rights reserved.
 *
 * License: GPLv3 and FreeType Project License (FTL)
 *
 */


#include "config.h"
#include "with.h"
#include <stdio.h>
#include <stdlib.h>
#ifdef WIN32
#  include <io.h>
#endif
#ifdef HAVE_UNISTD_H
#  include <unistd.h>
#endif
#ifdef SYS_PARAM_H
#  include <sys/param.h>
#endif
#ifdef SYS_TIME_H
#  include <sys/time.h>
#else
#  include <time.h>
#endif
#include <ctype.h>

#ifdef WITH_KPATHSEA
# include  "kpathsea/kpathsea.h"
#endif

#include  "VFlib-3_7.h"
#include  "VFsys.h"
#include  "vflibcap.h"
#include  "fsearch.h"

#ifdef WIN32
#include <windows.h>
static int GetHostName(char *szHostName, int nSize)
{
	DWORD dwSize = (DWORD)nSize;
	return GetComputerName(szHostName, &dwSize) ? 0 : -1;
}
#endif

char*
copy_cmdline(int xargc, char **xargv)
{
  int   i, t;
  char  *s, *p;

  t = 1;
  for (i = 0; i < xargc; i++)
    t = t + strlen(xargv[i]) + 1;
  if ((s = malloc(t)) == NULL){
    fprintf(stderr, "no memory.\n");
    exit(1);
  }
  
  p = s;
  for (i = 0; i < xargc; i++){
    strcpy(p, xargv[i]);
    p += strlen(xargv[i]);
    *(p++) = ' ';
  }
  s[t-1] = '\0';

  return s;
}


void 
banner(char *name, char *prog, char *cline)
{
  char  host[256], ts[256], *p;
  time_t   t;

#ifdef WIN32
  if (GetHostName(host, sizeof(host)) < 0)
#else
  if (gethostname(host, sizeof(host)) < 0)
#endif
    strcpy(host, "???");
  t = time(NULL);

  strcpy(ts, asctime(localtime(&t)));
  if ((p = strchr(ts, '\n')) != NULL)
    *p = '\0';

  printf(";; -------------------------------------------------------\n");
  printf(";; *** %s ***\n", name);
  printf(";; Generated by %s\n", prog);
  printf(";; at %s on %s\n", ts, host);
  printf(";; Commandline: %s\n", cline);
  printf("\n");
}

char*
x_strdup(char *s)
{
  char  *p;

  if (s == NULL){
    fprintf(stderr, "internal error.");
    exit(1);
  }

  p = malloc(strlen(s) + 1);
  if (p == NULL){
    fprintf(stderr, "no memory.");
    exit(1);
  }
  
  strcpy(p, s);
  return p;
}

char*
check_font_exist(char *file, char **dirs, int ndirs, int kptype, char **ext)
{
  int  i, l, j;
  char  path[MAXPATHLEN], **e;
  char *e0[] = { "", NULL };

  if (ndirs == 0)
    return 0;  /* may or may not exist */

  for (i = 0; i < ndirs; i++){
#ifdef WITH_KPATHSEA
	char *p;
    if ((strcmp(dirs[i], "TEXMF") == 0)
	|| (strcmp(dirs[i], "KPATHSEA") == 0)
	|| (strcmp(dirs[i], "texmf") == 0)
	|| (strcmp(dirs[i], "kpathsea") == 0)){
      p = kpse_find_file(file, kptype, 0);
      if (access(p, R_OK) >= 0)
	return 0;  /* exist */
    } else {
#else
	  {
#endif
      e = ext;
      if (e == NULL)
	e = e0;
      for (j = 0; e[j] != NULL; j++){
	sprintf(path, "%s", dirs[i]);
	l = strlen(dirs[i]);
	if ((l >= 2) && (dirs[i][l-2] == '/') && (dirs[i][l-1] == '/')){
	  sprintf(&path[l-2], "/%s", file);
	} else if ((l >= 2) && (dirs[i][l-2] != '/') && (dirs[i][l-1] == '/')){
	  sprintf(&path[l-1], "/%s", file);
	} else {
	  sprintf(&path[l], "/%s", file);
	}
	strcat(path, e[j]);
#if 0
	printf("***%s\n", path);
#endif
	if (access(path, R_OK) >= 0){
	  sprintf(path, "%s%s", file, e[j]);
	  return  x_strdup(path);    /* exist */
	}
      }
    }
  }
  
  return NULL;  /* not exist */
}


void
check_argc(int argc)
{
  if (argc == 0){
    fprintf(stderr,"Illegal command line argument\n");
    fprintf(stderr,"Use '--help' option for help\n");
    exit(1);
  }
}


int
map_need_tfm(char *fontclass)
{
  int  i;
  static char *db[] = {
    "type1", 
    "vf", 
    NULL};
  
  for (i = 0; db[i] != NULL; i++){
    if (strcmp(fontclass, db[i]) == 0)
      return 1;
  }
  return 0;  
}
