/*
 * ===========================
 * VDK Visual Develeopment Kit
 * Version 2.0.0
 * november 2000
 * ===========================
 *
 * Copyright (C) 1998, Mario Motta
 * Developed by Mario Motta <mmotta@guest.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */
#include <string.h>
#include "ctreecompo.h"
#include <string.h>
const int MAX_TITLES = 1;
// in pixmap.cc
extern char *mini_ofolder_xpm[];
extern char *mini_cfolder_xpm[];
// in src/pixdata.cc
extern char *testo_xpm[];
static  char *titles[] = {"Folders & files"};
static char buff[128];
///////////////////////////////////////////////////
DEFINE_SIGNAL_LIST(TreeComponent,VDKBox);
DEFINE_EVENT_LIST(TreeComponent,VDKBox);
DEFINE_SIGNAL_MAP(TreeComponent,VDKBox) 
  ON_SIGNAL(tree,select_node_signal,ShowSelection),
  ON_SIGNAL(remove,clicked_signal,RemoveSelection),
  ON_SIGNAL(build,clicked_signal,BuildTree),
  ON_SIGNAL(clear,clicked_signal,ClearTree),
  ON_SIGNAL(expand,clicked_signal,ExpandNode)
END_SIGNAL_MAP
   

/*
 */
bool
TreeComponent::ExpandNode(VDKObject* )
{
  VDKTreeNode node = tree->SelectedNode;
  if(node && ! tree->IsLeaf(node))
    {
      if(tree->IsExpanded(node))
	gtk_ctree_collapse_recursive(GTK_CTREE(tree->CustomWidget()),node);
      else
	gtk_ctree_expand_recursive(GTK_CTREE(tree->CustomWidget()),node);
    }
  return true;
}
/* 
 */  
bool 
TreeComponent::RemoveSelection(VDKObject* )
{
  VDKTreeNode node = NULL;
  VDKTreeNodeArray& selections = tree->Selections();
  if( (selections.size() == 0) && (node = tree->SelectedNode) )
    tree->RemoveNode(node);
  else
    {
      tree->Freeze();
      for(int j = 0; j < selections.size(); j++)
	tree->RemoveNode(selections[j]);
      tree->Thaw();
    }
  if(tree->Size() == 0)
    {
      remove->Enabled = false;
      build->Enabled = true;
    }
  return true;
}

/* 
 */  
bool 
TreeComponent::ClearTree(VDKObject* obj)
{
  tree->Clear();
  remove->Enabled = false;
  build->Enabled = true;
  return true;
}

/*
 */
bool 
TreeComponent::ShowSelection(VDKObject* obj)
{ 
  VDKCustomTree* aTree = NULL;
  VDKTreeNode node;
  Tuple tuple;
  int t,j;
  // downcast from VDKObj to VDKCustomTree
  aTree = dynamic_cast<VDKCustomTree*>(obj);
  // when called from a button surely fails
  aTree = aTree ? aTree : tree;
  
  VDKTreeNodeArray& selections = aTree->Selections();
  if(selections.size() == 0)
    {
      node = aTree->SelectedNode;
      if(node && aTree->IsLeaf(node))
	{
	  tuple = (*aTree)[node];
	  for(t = 0; t < tuple.size(); t++)
	    printf("\ncol:%d, text:%s",t,(char*) tuple[t]);
	  fflush(stdout);
	}
    }
  else
    {
      for(j = 0; j < selections.size(); j++)
	{ 
	  tuple = (*aTree)[selections[j]];
	  for(t = 0; t < tuple.size(); t++)
	    printf("\ncol:%d, text:%s",t,(char*) tuple[t]);
	  fflush(stdout);
	}
    }
  return true;
}
/*
 */ 
bool 
TreeComponent::ShowExtendedSelection(VDKObject* obj, GdkEvent*)
{
  // downcast from VDKObj to VDKCustomTree
  VDKCustomTree* aTree = dynamic_cast<VDKCustomTree*>(obj);
  g_return_val_if_fail(aTree != NULL,false);
  VDKTreeNodeArray& selections = aTree->Selections();
  if(selections.size() > 1)
    ShowSelection(obj);
  printf("\nselection size:%d",selections.size());
  fflush(stdout);
  return false;
}
/* 
 */
#define RAND_RANGE  20.0
bool 
TreeComponent::BuildTree(VDKObject*)
{
  VDKTreeNode node; 
  int t = 0,siblings = 3;
  int depth = 2; 
  char* text = &buff[0];
  tree->Freeze();
  // add a root + 3 siblings 
  sprintf(buff,"Folder 1");
  node = tree->AddNode(&text,NULL,
		       true,false, mini_cfolder_xpm, mini_ofolder_xpm);
  for(t = 0; t < siblings; t++)
    {
      sprintf(buff,"File %d",t);
      tree->AddNode(&text,node,false,true,testo_xpm);
    }
  // add a root + depth childs + a sibling
  sprintf(buff,"Folder 2");
  node = tree->AddNode(&text,NULL,
		       true,false, mini_cfolder_xpm, mini_ofolder_xpm); 
  for(t = 0;  t < depth;  t++) 
    {
      sprintf(buff,"Folder %d",t+3);
      node = tree->AddNode(&text,node, 
			   true,false, mini_cfolder_xpm, mini_ofolder_xpm);
    }
  sprintf(buff,"File 1");
  tree->AddNode(&text,node,false,true,testo_xpm);
  // add again a root + 10 siblings
  siblings = 10;
  sprintf(buff,"Folder 5");
  node = tree->AddNode(&text,NULL,
		       true,false, mini_cfolder_xpm, mini_ofolder_xpm);
  for(t = 0; t < siblings; t++)
    {
      sprintf(buff,"File %d",t);
      tree->AddNode(&text,node,false,true,testo_xpm);
    }
  tree->Thaw();
  build->Enabled = false;
  remove->Enabled = true;
  // select first node
  tree->SelectedNode = NULL;
  return true;
}
///////////////////////////////////////////////////

void    
TreeComponent::Setup() 
{
  tree = new VDKCustomTree(Owner(),MAX_TITLES,titles,GTK_SELECTION_EXTENDED);
  // set tree properties
  tree->LineStyle = GTK_CTREE_LINES_DOTTED;
  tree->ActiveTitle(0,false);
  // tree->Font = new VDKFont(Owner(),"helvetica 12");
  Add(tree);
  // 
  VDKFrame * frame = new VDKFrame(Owner(),NULL,h_box);
  remove = new VDKCustomButton(Owner(),"Remove selected nodes");
  build = new VDKCustomButton(Owner(),"Rebuild tree");
  clear = new VDKCustomButton(Owner(),"Clear tree");
  expand = new VDKCustomButton(Owner(),"Expand/Collapse");
  frame->Add(remove,l_justify);
  frame->Add(clear,l_justify);
  frame->Add(build,l_justify);
  frame->Add(expand,l_justify);
  Add(frame,l_justify,false,false,false);
  // load tree
  BuildTree(NULL);
  // when mouse is released shows multiple selections (if any)
  EventConnect(tree,"button_release_event",
	       &TreeComponent::ShowExtendedSelection);
  printf("\ntree size:%d",tree->Size());
  fflush(stdout);
 }
