use core_data
set nocount on

select
'pos:' + isnull([pos], '') as [pos],
'cType:' + isnull([sysCType], '') as [cType],
'cForm:' + isnull([cForm], '') as [cForm],
'lForm:' + isnull([reading], '') as [lForm],
case when isnull([meaning],'')='' then 'lemma:' + [lemma] else 'lemma:' + [lemma] + '-' + [meaning] end as [lemma],
'orth:' + isnull([orthToken], '') as [orth],
'pron:' + isnull([pronToken], '') as [pron],
'kana:' + isnull([kanaToken], '') as [kana],
'form:' + isnull([form], '') as [form],
'orthBase:' + isnull([orthBase], '') as [orthBase],
'pronBase:' + isnull([pronBase], '') as [pronBase],
'kanaBase:' + isnull([kanaBase],'') as [kanaBase],
'formBase:' + isnull([formBase], '') as [formBase],
'goshu:' + isnull([wType], '') as [goshu],
'iType:' + isnull([iType], '') as [iType],
'iForm:' + isnull([iForm], '') as [iForm],
'iConType:' + isnull([iConType], '') as [iConType],
'fType:' + isnull([fType], '') as [fType],
'fForm:' + isnull([fForm], '') as [fForm],
'fConType:' + isnull([fConType], '') as [fConType],
'aType:' + isnull([aType],'') as [aType],
'aConType:' + isnull([aConType],'') as [aConType],
'aModType:' + isnull([aModType],'') as [aModType], 
'lid:' + convert(varchar, isnull([lid], '')) as [lid],
'type:' + isnull([type], '') as [type],
'status:' + isnull([status],'') as [status]

from dbo.Lex_Full  with (nolock)

where
(
	(isnull([status],'') not like '%[ZY]%')
)
and [since] <= 70 and [until] >= 70


order by [lForm], [lemma], [pos], [cType], [cForm], [orth]

----	10      
----	20      
----	30      q
----	40      
----	50      ߐ
----	60      ߑ
----	70      

