/*
 * Decompiled with CFR 0.152.
 */
package org.piccolo2d.extras.swt;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.piccolo2d.PNode;
import org.piccolo2d.extras.swt.SWTGraphics2D;
import org.piccolo2d.util.PPaintContext;

public class PSWTText
extends PNode {
    private static final long serialVersionUID = 1L;
    protected static final double DEFAULT_GREEK_THRESHOLD = 5.5;
    protected static final Color DEFAULT_GREEK_COLOR = Color.gray;
    protected static final String DEFAULT_FONT_NAME = "Helvetica";
    protected static final int DEFAULT_FONT_STYLE = 0;
    protected static final int DEFAULT_FONT_SIZE = 12;
    protected static final Font DEFAULT_FONT = new Font("Helvetica", 0, 12);
    protected static final Color DEFAULT_PEN_COLOR = Color.black;
    protected static final String DEFAULT_TEXT = "";
    protected static final boolean DEFAULT_IS_TRANSPARENT = false;
    protected static final int DEFAULT_PADDING = 2;
    private boolean transparent = false;
    protected double greekThreshold = 5.5;
    protected Color greekColor = DEFAULT_GREEK_COLOR;
    protected Color penColor = DEFAULT_PEN_COLOR;
    protected Font font = DEFAULT_FONT;
    protected int padding = 2;
    protected ArrayList lines = new ArrayList();
    protected double translateX = 0.0;
    protected double translateY = 0.0;

    public PSWTText() {
        this(DEFAULT_TEXT, DEFAULT_FONT);
    }

    public PSWTText(String str) {
        this(str, DEFAULT_FONT);
    }

    public PSWTText(String str, Font font) {
        this.setText(str);
        this.font = font;
        this.recomputeBounds();
    }

    public Color getPenColor() {
        return this.penColor;
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.repaint();
    }

    public Paint getPenPaint() {
        return this.penColor;
    }

    public void setPenPaint(Paint aPaint) {
        this.penColor = (Color)aPaint;
    }

    public Color getBackgroundColor() {
        return (Color)this.getPaint();
    }

    public void setBackgroundColor(Color color) {
        super.setPaint((Paint)color);
    }

    public void setTransparent(boolean transparent) {
        this.transparent = transparent;
    }

    public boolean isTransparent() {
        return this.transparent;
    }

    public double getGreekThreshold() {
        return this.greekThreshold;
    }

    public void setGreekThreshold(double threshold) {
        this.greekThreshold = threshold;
        this.repaint();
    }

    public Font getFont() {
        return this.font;
    }

    public String getText() {
        StringBuffer result = new StringBuffer();
        Iterator lineIterator = this.lines.iterator();
        while (lineIterator.hasNext()) {
            result.append(lineIterator.next());
            result.append('\n');
        }
        if (result.length() > 0) {
            result.deleteCharAt(result.length() - 1);
        }
        return result.toString();
    }

    public void setFont(Font aFont) {
        this.font = aFont;
        this.recomputeBounds();
    }

    public void setText(String str) {
        int pos = 0;
        boolean done = false;
        this.lines.clear();
        do {
            int index;
            if ((index = str.indexOf(10, pos)) == -1) {
                this.lines.add(str.substring(pos));
                done = true;
                continue;
            }
            this.lines.add(str.substring(pos, index));
            pos = index + 1;
        } while (!done);
        this.recomputeBounds();
    }

    public void setTranslateX(double x) {
        this.setTranslation(x, this.translateY);
    }

    public double getTranslateX() {
        return this.translateX;
    }

    public void setTranslateY(double y) {
        this.setTranslation(this.translateX, y);
    }

    public double getTranslateY() {
        return this.translateY;
    }

    public void setTranslation(double x, double y) {
        this.translateX = x;
        this.translateY = y;
        this.recomputeBounds();
    }

    public void setTranslation(Point2D p) {
        this.setTranslation(p.getX(), p.getY());
    }

    public Point2D getTranslation() {
        Point2D.Double p = new Point2D.Double(this.translateX, this.translateY);
        return p;
    }

    public void paint(PPaintContext ppc) {
        double renderedFontSize;
        if (this.lines.isEmpty()) {
            return;
        }
        Graphics2D g2 = ppc.getGraphics();
        AffineTransform at = null;
        boolean translated = false;
        if (this.translateX != 0.0 || this.translateY != 0.0) {
            at = g2.getTransform();
            g2.translate(this.translateX, this.translateY);
            translated = true;
        }
        if ((renderedFontSize = (double)this.font.getSize() * ppc.getScale()) < this.greekThreshold) {
            this.paintAsGreek(ppc);
        } else {
            this.paintAsText(ppc);
        }
        if (translated) {
            g2.setTransform(at);
        }
    }

    public void paintAsGreek(PPaintContext ppc) {
        Graphics2D g2 = ppc.getGraphics();
        if (this.greekColor != null) {
            g2.setBackground(this.greekColor);
            ((SWTGraphics2D)g2).fillRect(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    public void paintAsText(PPaintContext ppc) {
        SWTGraphics2D sg2 = (SWTGraphics2D)ppc.getGraphics();
        if (!this.transparent) {
            if (this.getPaint() == null) {
                sg2.setBackground(Color.WHITE);
            } else {
                sg2.setBackground((Color)this.getPaint());
            }
            sg2.fillRect(0, 0, (int)this.getWidth(), (int)this.getHeight());
        }
        sg2.translate(this.padding, this.padding);
        sg2.setColor(this.penColor);
        sg2.setFont(this.font);
        double y = 0.0;
        FontMetrics fontMetrics = sg2.getSWTFontMetrics();
        for (String line : this.lines) {
            if (line.length() != 0) {
                sg2.drawString(line, 0.0, y, true);
            }
            y += (double)fontMetrics.getHeight();
        }
        sg2.translate(-this.padding, -this.padding);
    }

    protected void recomputeBounds() {
        GC gc = new GC((Drawable)Display.getDefault());
        Point newBounds = this.isTextEmpty() ? gc.stringExtent(" ") : this.calculateTextBounds(gc);
        gc.dispose();
        this.setBounds(this.translateX, this.translateY, newBounds.x + 4, newBounds.y + 4);
    }

    private boolean isTextEmpty() {
        return this.lines.isEmpty() || this.lines.size() == 1 && ((String)this.lines.get(0)).equals(DEFAULT_TEXT);
    }

    private Point calculateTextBounds(GC gc) {
        SWTGraphics2D g2 = new SWTGraphics2D(gc, (Device)Display.getDefault());
        g2.setFont(this.font);
        FontMetrics fm = g2.getSWTFontMetrics();
        Point textBounds = new Point(0, 0);
        boolean firstLine = true;
        for (String line : this.lines) {
            Point lineBounds = gc.stringExtent(line);
            if (firstLine) {
                textBounds.x = lineBounds.x;
                textBounds.y += fm.getAscent() + fm.getDescent() + fm.getLeading();
                firstLine = false;
                continue;
            }
            textBounds.x = Math.max(lineBounds.x, textBounds.x);
            textBounds.y += fm.getHeight();
        }
        return textBounds;
    }

    protected void internalUpdateBounds(double x, double y, double width, double height) {
        this.recomputeBounds();
    }
}

