## TFSA-2021-124: Segfault and heap buffer overflow in `{Experimental,}DatasetToTFRecord`

### CVE Number
CVE-2021-37650

### Impact
The implementation for `tf.raw_ops.ExperimentalDatasetToTFRecord` and
`tf.raw_ops.DatasetToTFRecord` can trigger heap buffer overflow and segmentation
fault:

```python
import tensorflow as tf

dataset = tf.data.Dataset.range(3)
dataset = tf.data.experimental.to_variant(dataset)
tf.raw_ops.ExperimentalDatasetToTFRecord(
  input_dataset=dataset,
  filename='/tmp/output',
  compression_type='')
```

The
[implementation](https://github.com/tensorflow/tensorflow/blob/f24faa153ad31a4b51578f8181d3aaab77a1ddeb/tensorflow/core/kernels/data/experimental/to_tf_record_op.cc#L93-L102)
assumes that all records in the dataset are of string type. However, there is no
check for that, and the example given above uses numeric types.

### Patches
We have patched the issue in GitHub commit
[e0b6e58c328059829c3eb968136f17aa72b6c876](https://github.com/tensorflow/tensorflow/commit/e0b6e58c328059829c3eb968136f17aa72b6c876).

The fix will be included in TensorFlow 2.6.0. We will also cherrypick this
commit on TensorFlow 2.5.1, TensorFlow 2.4.3, and TensorFlow 2.3.4, as these are
also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported by members of the Aivul Team from Qihoo
360.
