## TFSA-2021-106: Crash in `tf.strings.substr` due to `CHECK`-fail

### CVE Number
CVE-2021-29617

### Impact
An attacker can cause a denial of service via `CHECK`-fail in
`tf.strings.substr` with invalid arguments:

```python
import tensorflow as tf
tf.strings.substr(input='abc', len=1, pos=[1,-1])
```

```python
import tensorflow as tf
tf.strings.substr(input='abc', len=1, pos=[1,2])
```

### Patches
We have received a patch for the issue in GitHub commit
[890f7164b70354c57d40eda52dcdd7658677c09f](https://github.com/tensorflow/tensorflow/commit/890f7164b70354c57d40eda52dcdd7658677c09f).

The fix will be included in TensorFlow 2.5.0. We will also cherrypick this
commit on TensorFlow 2.4.2, TensorFlow 2.3.3, TensorFlow 2.2.3 and TensorFlow
2.1.4, as these are also affected and still in supported range.

### For more information
Please consult [our security
guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for
more information regarding the security model and how to contact us with issues
and questions.

### Attribution
This vulnerability has been reported in
[#46900](https://github.com/tensorflow/issues/46900) and fixed in
[#46974](https://github.com/tensorflow/issues/46974).
