from __future__ import print_function



class _MockMeta(type):
    def __getattr__(self, name):
        return _Mock()

class _Mock(object):
    __metaclass__ = _MockMeta
    def __init__(self, *a, **kw):
        object.__init__(self)
        for k,v in kw.iteritems():
            setattr(self, k, v)
    def __getattr__(*a, **kw): return _Mock()
    def __call__(*a, **kw): return _Mock()
    def __getitem__(*a, **kw): return _Mock()
    def __int__(*a, **kw): return 1
    def __contains__(*a, **kw): return False
    def __len__(*a, **kw): return 1
    def __iter__(*a, **kw): return iter([])
    def __exit__(*a, **kw): return False
    def __complex__(*a, **kw): return 1j
    def __float__(*a, **kw): return 1.0
    def __bool__(*a, **kw): return True
    def __nonzero__(*a, **kw): return True
    def __oct__(*a, **kw): return 1
    def __hex__(*a, **kw): return 0x1
    def __long__(*a, **kw): return long(1)
    def __index__(*a, **kw): return 1       


_display_mimetype = _Mock()

_jpegxy = _Mock()

_merge = _Mock()

_pngxy = _Mock()

_safe_exists = _Mock()

_safe_get_formatter_method = _Mock()

cast_bytes_py2 = _Mock()

cast_unicode = _Mock()

clear_output = _Mock()

display = _Mock()

display_html = _Mock()

display_javascript = _Mock()

display_jpeg = _Mock()

display_json = _Mock()

display_latex = _Mock()

display_pdf = _Mock()

display_png = _Mock()

display_pretty = _Mock()

display_svg = _Mock()

os = _Mock()

print_function = _Mock()

publish_display_data = _Mock()

set_matplotlib_close = _Mock()

set_matplotlib_formats = _Mock()

skip_doctest = _Mock()

string_types = _Mock()

struct = _Mock()

_JPEG = '\xff\xd8'

_PNG = '\x89PNG\r\n\x1a\n'

css_t = '$("head").append($("<link/>").attr({\n  rel:  "stylesheet",\n  type: "text/css",\n  href: "%s"\n}));\n'

lib_t1 = '$.getScript("%s", function () {\n'

lib_t2 = '});\n'

class DisplayObject(_Mock):
  pass
  _read_flags = 'r'

class HTML(_Mock):
  pass
  _read_flags = 'r'

class Image(_Mock):
  pass
  _FMT_JPEG = u'jpeg'
  _FMT_PNG = u'png'
  _read_flags = 'rb'

class JSON(_Mock):
  pass
  _read_flags = 'r'

class Javascript(_Mock):
  pass
  _read_flags = 'r'

class Latex(_Mock):
  pass
  _read_flags = 'r'

class Math(_Mock):
  pass
  _read_flags = 'r'

class Pretty(_Mock):
  pass
  _read_flags = 'r'

class SVG(_Mock):
  pass
  _read_flags = 'r'

class TextDisplayObject(_Mock):
  pass
  _read_flags = 'r'

class unicode_type(_Mock):
  pass


