C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LIMSOL
C                       *****************
C
C      ------------------------------------------------------------
     * (NDIM,NPOINS,NELEMS,NDMATS,NREFS,COORDS,NODES,TMPSA,TMPS,
     *  NBFLUS,NFLUSS,VFLUSS,NBDIRS,NDIRS,VDIRS,NBECHS,NECHS,VECHS,
     *  NBRAIS,NRAYIS,VRAYIS,NBRESS,NRESCS,VRESCS)
C      ------------------------------------------------------------
C
C***********************************************************************
C* SYRTHES 3.4.2                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C            INITIALISATION DES CONDITIONS AUX LIMITES SUR LE SOLIDE   *
C            POUR LE CALCUL COUPLE FLUIDE-SOLIDE                       * 
C            (Sous-programme utilisateur)                              *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !  NDIM     ! TE ! D  ! DIMENSION DU PROBLEME                        !
C !  NPOINS   ! TE ! D  ! NOMBRE DE NOEUDS DU MAILLAGE SOLIDE          !
C !  NELEMS   ! TE ! D  ! NOMBRE D'ELEMENTS DU MAILLAGE SOLIDE         !
C !  NDMATS   ! TE ! D  ! NOMBRE DE NOEUDS PAR ELEMENT                 !
C !  NREFS    ! TE ! D  ! REFERENCES DES NOEUDS SOLIDES                !
C !  COORDS   ! TR ! D  ! COORDONNEES DES NOEUDS SOLIDES               !
C !  NODES    ! TE ! D  ! CONNECTIVITE DU MAILLAGE SOLIDE              !
C !  TMPSA    ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  TMPS     ! TR ! D  ! TEMPERATURE DANS LE SOLIDE A L'ETAPE N       !
C !  NFLUSS   ! TE ! D  ! NUMERO DES NOEUDS PORTANT UNE C.L. DE FLUX   !
C !  VFLUSS   ! TR ! R  ! VALEUR DE LA CONDITION DE TYPE FLUX          !
C !  NDIRS    ! TE ! D  ! NUMERO DES NOEUDS PORTANT UNE C.L. DIRICHLET !
C !  VDIRS    ! TR ! R  ! VALEUR DE LA CONDITION DE TYPE  DIRICHLET    !
C !  NECHS    ! TE ! D  ! NUMERO DES NOEUDS AVEC C.L. COEFF ECHANGE    ! 
C !  VECHS    ! TR ! R  ! VALEUR DE LA CONDITION DE TYPE  COEFF ECHANGE!
C !           !    !    !    VECHS(...,1) = temperature exterieure     !
C !           !    !    !    VECHS(...,2) = coefficient d'echange      !
C !  NRAYIS   ! TE ! D  ! NUMERO DES NOEUDS AVEC RAYONNEMENT  infi     ! 
C !  VRAYIS   ! TR ! R  ! VALEUR DES PARAMETRES POUR LE RAYONNEMENTinfi!
C !  NRESCS   ! TE ! D  ! NUMERO DES NOEUDS AVEC RESISTANCE DE CONTACT ! 
C !  VRESCS   ! TR ! R  ! VALEUR DE LA RESISTANCE                      !
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /OPTCT/   !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : 
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C***********************************************************************
C
#include "optct.h"
#include "nlofes.h"
#include "divct.h"
#include "syrthu.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINS,NELEMS,NDMATS
      INTEGER NBFLUS,NBDIRS,NBECHS,NBRESS,NBRAIS
      INTEGER NREFS(NPOINS),NODES(NELEMS,NDMATS)
      DOUBLE PRECISION  COORDS(NPOINS,NDIM),TMPS(NPOINS),TMPSA(NPOINS)
      INTEGER NFLUSS(NBFLUS),NDIRS(NBDIRS),NECHS(NBECHS)
      INTEGER NRESCS(NBRESS,2),NRAYIS(NBRAIS)
      DOUBLE PRECISION  VFLUSS(NBFLUS),VDIRS(NBDIRS),VECHS(NBECHS,2)
      DOUBLE PRECISION  VRESCS(NBRESS,2),VRAYIS(NBRAIS,2)
C
C.. Variables internes
      INTEGER N,NUMNO,NUMREF
      DOUBLE PRECISION T,XX,YY,ZZ,TT1,TT2
C
      LOGICAL LVERIF
C
C***********************************************************************
C
C     1- INITIALISATIONS
C     ==================
C
      LVERIF = .FALSE.
C
C***********************************************************************
C
C     INTERVENTION UTILISATEUR A PARTIR DE CETTE LIGNE 
C     ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~  
C
C     Pour stopper l'execution proprement en cas de probleme
C     mettre LSTOPS a "TRUE" dans vos tests
C     LSTOPS = .FALSE.
C
C
C     =========================================================
C     2- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE FLUX
C     =========================================================
C
C 
C     Temps courant sur le solide
CUTI  T = TEMPSS
C
C
C     Exemple ...
C
CUTI  DO N=1,NBFLUS
C
C        Numero global du noeud
CUTI     NUMNO = NFLUSS(N)
C
C        References du noeud
CUTI     NUMREF = NREFS(NUMNO)
C
C        Coordonnees du noeud
CUTI     XX = COORDS(NUMNO,1)
CUTI     YY = COORDS(NUMNO,2)
CUTI     IF(NDIM.EQ.3) ZZ = COORDS(NUMNO,3)
C
C        TT1 = Temperature au noeud courant
CUTI     TT1 = TMPS(NUMNO)
C
C        Si le noeud porte la reference 3, le flux vaut 1000 W/M2
C        sinon, il vaut 10000 W/M2
C
CUTI     IF (NUMREF.EQ.3) THEN
CUTI        VFLUSS(N) = 1000.0D0
CUTI     ELSE
CUTI        VFLUSS(N) = 10000.0D0
CUTI     ENDIF
C
CUTI  ENDDO
C
C     ==============================================================
C     3- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE DIRICHLET
C     ==============================================================
C
C     Temps courant sur le solide
CUTI  T = TEMPSS
C
C     Exemple ...
C
CUTI  DO N=1,NBDIRS
C
C        Numero global du noeud
CUTI     NUMNO = NDIRS(N)
C
C        References du noeud
CUTI     NUMREF = NREFS(NUMNO)
C
C        Coordonnees du noeud
CUTI     XX = COORDS(NUMNO,1)
CUTI     YY = COORDS(NUMNO,2)
CUTI     IF(NDIM.EQ.3) ZZ = COORDS(NUMNO,3)
C
C        TT1 = Temperature au noeud courant
CUTI     TT1 = TMPS(NUMNO)
C
C        Si le noeud porte la reference 5, le dirichlet vaut 2 sinon 3
C
CUTI     IF (NUMREF.EQ.3) THEN
CUTI        VDIRS(N) = 2.0D0
CUTI     ELSE
CUTI        VDIRS(N) = 3.0D0
CUTI     ENDIF
C
CUTI  ENDDO
C
C
C     ====================================================
C     4- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE 
C        COEFFICIENT D'ECHANGE
C     ====================================================
C
C     Temps courant sur le solide
CUTI  T = TEMPSS
C
C     Exemple ...
C
CUTI  DO N=1,NBECHS
C
C        Numero global du noeud
CUTI     NUMNO = NECHS(N)
C
C        References du noeud
CUTI     NUMREF = NREFS(NUMNO)
C
C        Coordonnees du noeud
CUTI     XX = COORDS(NUMNO,1)
CUTI     YY = COORDS(NUMNO,2)
CUTI     IF(NDIM.EQ.3) ZZ = COORDS(NUMNO,3)
C
C        TT1 = Temperature au noeud courant
CUTI     TT1 = TMPS(NUMNO)
C
C        Si le noeud porte la reference 6, la temperature exterieure est
C        de 20 et le coefficient d'echange de 10, sinon, la temperature 
C        exterieure et de 40 C
C
CUTI     IF (NUMREF.EQ.6) THEN        
CUTI        VECHS(N,1) = 20.0D0
CUTI        VECHS(N,2) = 10.0D0
CUTI     ELSE
CUTI        VECHS(N,1) = 40.0D0
CUTI        VECHS(N,2) = 10.0D0
CUTI     ENDIF
C
CUTI  ENDDO
C
C
C     ====================================================
C     5- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE 
C        RESISTANCE DE CONTACT
C     ====================================================
C     Il s'agit d'initialiser la resistance de contact
C
C     Temps courant sur le solide
CUTI  T = TEMPSS
C
C     Exemple ...
C
CUTI  DO N=1,NBRESS
C
C        Numero global du noeud
CUTI     NUMNO = NRESCS(N,1)
C
C        References du noeud
CUTI     NUMREF = NREFS(NUMNO)
C
C        Coordonnees du noeud
CUTI     XX = COORDS(NUMNO,1)
CUTI     YY = COORDS(NUMNO,2)
CUTI     IF(NDIM.EQ.3) ZZ = COORDS(NUMNO,3)
C
C        TT1 = Temperature au noeud courant
CUTI     TT1 = TMPS(NUMNO)
C
C        Si le noeud porte la reference 4
C
CUTI     IF (NUMREF.EQ.4) THEN        
CUTI        VRESCS(N,2) = 0.5D0
CUTI     ELSE
CUTI        VRESCS(N,2) = 0.7D0
CUTI     ENDIF
C
CUTI  ENDDO
C
C     ====================================================
C     6- INITIALISATION DES CONDITIONS AUX LIMITES DE TYPE 
C        RAYONNEMENT INFINI
C     ====================================================
C
C     Temps courant sur le solide
CUTI  T = TEMPSS
C
C     Exemple ...
C
CUTI  DO N=1,NBRAIS
C
C        Numero global du noeud
CUTI     NUMNO = NRAYIS(N)
C
C        References du noeud
CUTI     NUMREF = NREFS(NUMNO)
C
C        Coordonnees du noeud
CUTI     XX = COORDS(NUMNO,1)
CUTI     YY = COORDS(NUMNO,2)
CUTI     IF(NDIM.EQ.3) ZZ = COORDS(NUMNO,3)
C
C        TT1 = Temperature au noeud courant
CUTI     TT1 = TMPS(NUMNO)
C
C        Si le noeud porte la reference 6, la temperature exterieure 
C        utilisee pour le rayonnement est de 100 degree C
C        L'emissivite est de 0.8
C        de 20 degree et epsilon=0.9 autrement 
C
CUTI     IF (NUMREF.EQ.6) THEN        
CUTI        VRAYIS(N,1) = 100.0D0
CUTI        VRAYIS(N,2) = 0.8D0
CUTI     ELSE
CUTI        VRAYIS(N,1) = 20.D0
CUTI        VRAYIS(N,2) = 0.9
CUTI     ENDIF
C
CUTI  ENDDO
C
C                   FIN INTERVENTION UTILISATEUR
C                   ~~~~~~~~~~~~~~~~~~~~~~~~~~~~
C
C
C***********************************************************************
C
C     5- IMPRESSION DE CONTROLE
C     =========================
C
      IF (LVERIF) THEN
C
         IF (NBFLUS.GT.0 .OR. NBDIRS.GT.0 .OR. NBECHS.GT.0) THEN
            WRITE(NFECRA,5000)
         ELSE
            WRITE(NFECRA,5001)
         ENDIF
         IF (NBFLUS.GT.0) THEN
           WRITE(NFECRA,5010)
           WRITE(NFECRA,5050) (NFLUSS(N),VFLUSS(N),N=1,NBFLUS)
         ENDIF
         IF (NBDIRS.GT.0) THEN
           WRITE(NFECRA,5020)
           WRITE(NFECRA,5050) (NDIRS(N),VDIRS(N),N=1,NBDIRS)
         ENDIF
         IF (NBECHS.GT.0) THEN
           WRITE(NFECRA,5030)
           WRITE(NFECRA,5060) 
     &          (NECHS(N),VECHS(N,1),VECHS(N,2),N=1,NBECHS)
         ENDIF
         IF (NBRAIS.GT.0) THEN
           WRITE(NFECRA,5040)
           WRITE(NFECRA,5060) 
     &          (NRAYIS(N),VRAYIS(N,1),VRAYIS(N,2),N=1,NBRAIS)
         ENDIF
C
      ENDIF
C
C--------
C FORMATS
C--------
C
 5000 FORMAT(/,'  *** LIMSOL : IMPRESSION DES CONDITIONS AUX LIMITES')
 5001 FORMAT(/,'  *** LIMSOL : CONDITIONS AUX LIMITES = FLUX NUL')
 5010 FORMAT(/,'   - Condition de type flux (noeud, valeur)')
 5020 FORMAT(/,'   - Condition de type Dirichlet (noeud, valeur)')
 5030 FORMAT(/,'   - Condition de type coeff echange (noeud, T, h)')
 5040 FORMAT(/,'   - Condition de type rayonnement infini',
     &         ' (noeud, T, sigma)')
 5050 FORMAT('(',I6,'-',G10.3,')')
 5060 FORMAT('(',I6,'-',G10.3,',',G10.3,')')
C
C----
C FIN
C----
      END
