C-----------------------------------------------------------------------
C
C                        SYRTHES version 3.4
C                        -------------------
C
C     This file is part of the SYRTHES Kernel, element of the
C     thermal code SYRTHES.
C
C     Copyright (C) 1988-2008 EDF S.A., France
C
C     contact: syrthes-support@edf.fr
C
C
C     The SYRTHES Kernel is free software; you can redistribute it
C     and/or modify it under the terms of the GNU General Public License
C     as published by the Free Software Foundation; either version 2 of
C     the License, or (at your option) any later version.
C
C     The SYRTHES Kernel is distributed in the hope that it will be
C     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
C     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C     GNU General Public License for more details.
C
C
C     You should have received a copy of the GNU General Public License
C     along with the Code_Saturne Kernel; if not, write to the
C     Free Software Foundation, Inc.,
C     51 Franklin St, Fifth Floor,
C     Boston, MA  02110-1301  USA
C
C-----------------------------------------------------------------------
C                       *****************
                        SUBROUTINE LRASI1
C                       *****************
C
C     --------------------
     *(NDIM,NPOINR,NELRAY)
C     --------------------
C
C***********************************************************************
C* SYRTHES 3.4.3                                    COPYRIGHT EDF 2008 *
C***********************************************************************
C AUTEURS : C. PENIGUEL, I. RUPP                                       *
C***********************************************************************
C FONCTION :                                                           *
C ----------                                                           *
C       1ere LECTURE DU MAILLAGE ELEMENTS FINIS POUR LE RAYONNEMENT    *
C             --> STRUCTURE DE DONNEE ISSUE DE SIMAIL                  *
C             (Necessaire pour les dimensionnements de tableaux)       *
C                                                                      *
C-----------------------------------------------------------------------
C                             ARGUMENTS
C .___________.____.____.______________________________________________.
C !    NOM    !TYPE!MODE!                   ROLE                       !
C !___________!____!____!______________________________________________!
C !___________!____!____!______________________________________________!
C ! COMMONS                                                            !
C !____________________________________________________________________!
C ! /XREFER/  !    ! D  !                                              !
C ! /NLOFES/  !    ! D  !                                              !
C ! /NLOFCT/  !    ! D  !                                              !
C !___________!____!____!______________________________________________!
C
C (*) TYPE : E (ENTIER), R (REEL), A (ALPHANUMERIQUE), T (TABLEAU)
C     ET TYPES COMPOSES
C (*) MODE : D (DONNEE NON MODIFIEE), R (RESULTAT), M (DONNEE MODIFIEE)
C            A (TABLEAU AUXILIAIRE)
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELE(S) : LCOODP,CMPTNO,CMPTEL,CMPTFA,INREFA
C
C-----------------------------------------------------------------------
C     SOUS PROGRAMME(S) APPELANT(S) :
C
C***********************************************************************
C
      IMPLICIT NONE
C
C***********************************************************************
C     DONNEES EN COMMON  
C **********************************************************************
C
#include "nlofes.h"
#include "nlofct.h"
#include "optct.h"
C
C***********************************************************************
C
C.. Variables externes
      INTEGER NDIM,NPOINR,NELRAY
C
C.. Variables internes
      INTEGER NDIMEF,NCOPNP,NSOMP1
      INTEGER I,M(32),LE,NSEG,NTRI,NTET
      CHARACTER*4 CHAR4
#ifdef HAVE_C_IO
      INTEGER   NBRLUS,NBRTOT,IERROR
      CHARACTER MSGIER*80
#endif /* HAVE_C_IO */
C
C***********************************************************************
C
C     0- INITIALISATIONS
C     ==================
C
#ifdef HAVE_C_IO
      CALL REWDBF (NFSGRA, IERROR)
      IF (IERROR .NE. 0) GOTO 998
#else
      REWIND (NFSGRA)
#endif
C
C     1- LECTURE DE L'ENREGISTREMENT AVANT LE TABLEAU 0
C     =================================================
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGRA, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGRA, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ(NFSGRA,ERR=999) LE,(M(I), I=1,LE) 
C
      REWIND (NFSGRA)
      READ (NFSGRA,ERR=999) LE,(M(I), I=1,LE) 
#endif
C
C     2- LECTURE DU TABLEAU 0
C     =======================
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGRA, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGRA, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ (NFSGRA,ERR=999) LE, (M(I), I=1,LE)
#endif
C
C     verifications....
C       - du nom de la structure
c            C = CHAR4(M(29))
c            IF (C.NE.'NOPO') THEN
c               WRITE(NFECRA,1000)
c               CLOSE(NFSGRA)
c               STOP
c            ENDIF
C       - du nombre de tableaux associes
            IF (M(32).NE.0) THEN
               WRITE(NFECRA,1023)
               STOP
            ENDIF
C
C     3- LECTURE DU TABLEAU 2
C     =======================
#ifdef HAVE_C_IO
      NBRLUS = 0
      CALL READBF (NFSGRA, 4, 1, 1, NBRLUS, NBRTOT, LE, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      CALL READBF (NFSGRA, 4, LE, 1, NBRLUS, NBRTOT, M, IERROR)
      IF (IERROR .NE. 0) GOTO 998
      IF (NBRLUS .LT. NBRTOT) THEN
         CALL READBF (NFSGRA, 4, 0, 2, NBRLUS, NBRTOT, 0, IERROR)
         IF (IERROR .NE. 0) GOTO 998
      ENDIF
#else
      READ(NFSGRA,ERR=999) LE,(M(I),I=1,LE)
#endif
C
      NDIMEF = M(1)
      NCOPNP = M(4)
      NELRAY = M(5)
      NSEG = M(7)
      NTRI = M(8)
      NTET = M(10)
      NPOINR = M(15)
      NSOMP1 = M(22)
C
C
C     4- VERIFICATIONS DIVERSES
C     =========================
C
      IF (NDIM.NE.NDIMEF) THEN
        WRITE(NFECRA,1021)
        STOP
      ENDIF
C
      IF (NSOMP1.NE.NPOINR) THEN
         WRITE(NFECRA,1022)
         STOP
      ENDIF
C     
      IF (NTRI.NE.NELRAY .AND. NSEG.NE.NELRAY) THEN
         WRITE(NFECRA,1023)
         STOP
      ENDIF
C
C
      RETURN
#ifdef HAVE_C_IO
 998  CONTINUE
      CALL STREBF (MSGIER, LEN(MSGIER), IERROR)
      WRITE(NFECRA,9998) MSGIER
      STOP
#else
 999  CONTINUE
      WRITE(NFECRA,9999)
      STOP
#endif
C
C--------
C FORMATS
C--------
C 
 1000 FORMAT('  %% ERREUR LRASI1 : LE FICHIER NE CONTIENT PAS UNE S.D.',
     &       ' DE MAILLAGE ')
 1018 FORMAT('  %% ERREUR LRASI1 : DIMENSION DES MAILLAGES ',
     &       'INCOMPATIBLES')
 1021 FORMAT('  %% ERREUR LRASI1 : La dimension du maillage rayonnement'
     &       ,' n''est pas coherente',/,
     &       21X,'avec celle du solide')      
 1022 FORMAT('  %% ERREUR LRASI1 : LE MAILLAGE POSSEDE DES'
     &                             ,' NOEUDS MILIEUX')      
 1023 FORMAT('  %% ERREUR LRASI1 : UTILISATION D''ELEMENTS ',
     &                              'NON CONFORMES',/,
     &       20X,'Seuls sont autorises :',/,
     &       20X,' - les triangles (en dimension 3)',/,
     &       20X,' - les segments  (en dimension 2)')
C 
#ifdef HAVE_C_IO
 9998 FORMAT(' %% ERREUR LRASI1 : erreur de lecture du maillage ',
     *       ' rayonnement',/,'    de type : ',A)
#else
 9999 FORMAT(' %% ERREUR LRASI1 : erreur de lecture du maillage ',
     *       ' rayonnement')
#endif
C
      END

