/*============================================================================*/
/* Definitions pour la combinaison de sous-programmes en Fortran et en C      */
/*                                                                            */
/* Bibliotheque : Code_Saturne, SYRTHES                    Copyright EDF 2000 */
/*============================================================================*/


#ifndef _FORTRAN_C_H_
#define _FORTRAN_C_H_


/* Definitions de types */

#undef  integer_t
#undef  real_t

#define integer_t   int     /* Type "INTEGER" en Fortran                      */
#define real_t      double  /* Type "REAL*8" ou "DOUBLE PRECISION" en Fortran */

#define integer_4_t int     /* Entier de 4 octets de long                     */

#ifndef __hpux
#define UNDERSCORE
#endif

#ifdef UNDERSCORE
#define fsymbol(x, y) x##_
#else
#define fsymbol(x, y) x
#endif

/* Passage d'argument de type chaine de caracteres Fortran -> C rencontre
   sur de nombreux systemes : les longeurs des chaines Fortran sont ajoutees
   a la fin de la liste des arguments de la fonction C correspondante
*/
#ifndef __uxpv__
#define CHAINE_F_VERS_C_LEN_FIN
#else
#define CHAINE_F_VERS_C_STR_NUL
#endif

#endif /* _FORTRAN_C_H_ */
