#!/bin/bash

# Change pylint behaviour
# Defaults:
FLAGS=
# Errors only:
FLAGS=-e

# Delete old dirs
rm -rf output
mkdirhier output
cd output

# Check base system
pylint $FLAGS --files-output=y newsfc
# Remove incorrect sfc.log errors
sed -i s/E.\*No.\*sfc.log.\*// *.txt
# Remove empty log files
python ../cleanlogs.py *.txt

# Print sizes
echo output/ lines:
cat *.txt | uniq | wc -l
