/*
 *  Copyright (C) 2008 Nicolas Vion <nico@picapo.net>
 *
 *   This file is part of swac-get.
 *
 *   Swac-get is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   Swac-get is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with swac-get; if not, write to the Free Software
 *   Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef _SWAC_HH
#define _SWAC_HH

#include <string>

#include "swac_db.hh"
#include "swac_index.hh"
#include "swac_repository.hh"



struct Tswac : virtual Tswac_db, public Tswac_index, private Tswac_repository_http, private Tswac_repository_local {
private:
	bool package_delete(std::string url);
	void package_deselect_id(std::string packid);
	void package_select_id(std::string packid);
	void package_select_url(std::string url);

public:
	void package_select(std::string url);
	void package_deselect_idx(std::string idx);
	void package_deselect(std::string url);
	std::string package_get_available_version(std::string url);

	void source_select(std::string url);
	void source_deselect(std::string url);
	void source_delete(std::string url);
	void source_load(std::string url);

	void upgrade_structure();
	void upgrade();
	void update();

	void sql(std::string sql);
};

#endif

