---
title: 2022 Tutorial
---

This tutorial showcases network editing, flows, opposite driving, pedestrian crossings, parking search, and more!

# Files

- [sumo2022_tutorial.zip](https://sumo.dlr.de/daily/sumo2022_tutorial.zip)

# Video
<a class="no-arrow-link" data-youtube href="https://www.youtube.com/watch?v=urKtJj87X5M">Watch the 2022 Tutorial</a>


# Transcription


## Intro
Welcome to the traditional SUMO User Conference tutorial. Now, today I will be showing you a range of topics, from starting with beginner-level topics, introductory material, and then moving on to somewhat more sophisticated topics, but as in every year, we will start with the wizard and the three-click scenario generation, and we'll also talk about network editing. We'll see how to simply create individual traffic flows, and then we'll talk a bit about the advanced things, such as opposite direction driving, pedestrian crossings, and traffic in search for parking. To run this tutorial, to follow this tutorial on your own computers maybe after the talk, because it will be probably hard to follow live, you will need SUMO version 1.13.0, a Python interpreter on your computer, a text editor and the tutorial files, which you can find in our documentation, in the "Tutorial" section there is a subsection "SUMO User Conference Tutorials" where you'll find the download link. This tutorial will be recorded. And I'm hoping that you are able to see the keys that I press in the lower part of the screen. So if I press some buttons, I hope you can see those and they will be in the recordings. Did anybody see any keys? Yes, we can see them. Great.

## osmWebWizard
Then let's start with the osmWebWizard. This is a tool that comes with SUMO and it's meant to help you set up a simulation scenario with just a few clicks. When you run this tool, and you can probably run it from your taskbar if SUMO is installed, there should be a link to the osmWebWizard, or you can find it in the tools subfolder of your SUMO installation. So if you run this, it will open up a web browser where you can select part of the map, part of the world that you want to download. And then you can also select the types of traffic that you want to have in your simulation. There are additional options such as enabling public transport and downloading satellite backgrounds or shapes for land use and buildings. And as a new feature in the latest release, or rather since the last user conference tutorial, I'm happy to present to you a new feature that is road type selection. So there's a new tab in the wizard, I'll show this in a few seconds, where you can select all the kinds of roads that you would like to see in your simulation. And one major use case of that is being able to download bigger scenarios. Because the download size of the scenario is limited by the open street map servers, and if you select your road types and you deselect background shapes, then you can build very big scenarios. For example, if you only need the major roads. 
So let's see how this works. So there should be a SUMO folder somewhere in your system, wherever you installed that. And if you don't have a link in your taskbar, then you just enter the tools folder, and you launch the osmWebWizard. And then what you'll see is this browser window where you can select an area, you drag it around and resize it, and you can this, you can also select the types of traffic that you want, and the types of roads that you need, disable everything that you not want. Maybe not add polygons this time, just to show how that goes, and generate your scenario, and that's it!
So of course it takes a while to download the data and to build the scenario but eventually what you'll get is a simulation window with that scenario up and running. So of course I already included scenario files for you in this tutorial so I'll just close the wizard real quickly and we'll move on to the files that I brought you. All right so this is the first folder of the tutorial files and let's talk a little bit about the files that you will find in there. So the most important file is the sumo config file. It's the configuration that ties everything together and the key files here are the network file named with the extension `.net.xml`. And then you have the `osm.passenger.trips.xml` and depending on the buttons you clicked there could be others but right now we only enabled passenger cars, but there could be more files for public transport stops, pedestrians and if you're interested in these then I invite you to look at tutorials from past years because these were explained. There's one file that defines how the simulation shall look when first opened and then there's a range of files for rebuilding the scenario with different options, and some of this for example the build batch file will see and use in this tutorial, because whenever you change something about the network you generally have to rebuild the traffic to adapt to changing infrastructure. All right so let's now look at the simulation that I brought for you as part of the tutorial.

If SUMO is installed on your system correctly then you can just click on a file of the sumo config extension and it should launch sumo. And so let's run the simulation. By the way we have added new hotkeys so you can now just run the simulation by hitting the <kbd>space bar</kbd>, and you can stop it this way again. And now if you look very carefully you will probably not see anything because the cars are just too small at this type of zoom. As promised, we downloaded the big scenario which is possible with filtering road types. So if you want to see cars moving all over the place one way to do this is to change the graphical settings. This is found behind this rainbow button. And one setting that I always find to be useful is found in the "Vehicles"-tab, it's "Draw with constant size when zoomed out", suddenly all the cars are large. And let's color them by speed so we can get some idea of what they're doing. And now in order not to have to set this again every time we simply store these settings in the registry. I call that "speedLarge" because I color the cars by speed and they are large. So now I have this here and I can use it again and again. So let's run this simulation and see how it goes. You also have hotkeys for for changing the delay or you can do this with the slider, make the simulation run really slow or really fast. So somewhere in between is probably good. <kbd>Page Up</kbd>, <kbd>Page Down</kbd> also changes this so we can see cars running all over the network and then suddenly here in the upper left corner it looks kind of bad and we see warning messages pop up. Now there are some things you can do with these warning messages. One thing is you can click on the underlined vehicle names or you can click on the underlined lane IDs and you can even click on those underlined times. This will set a breakpoint so you could then rewind the simulation and run it up to that time to see what's really been happening. So what we have here is some kind of deadlock. The cars are in this circular structure and the circle has run full and so none of the cars can really move. After a while cars are being teleported which means they are moved to the next edge in an irregular manner so this is often a sign of things going wrong. And of course this is something we want to change and can change and I'll show you here quickly.

## Network Editing - Join Junctions
So back to the slides. Now for those that are new to SUMO you may be wondering what you're actually seeing there. What's in this simulation? How did that come about? So the network on which these cars are simulated is based on the OSM (OpenStreetMap) road network data storage and in this case it's a filtered version of the data set because we only included the major roads and it's also a heuristic interpretation because the data isn't really built for micro simulation. It's maybe built for routing mostly for building pretty maps. So we do have to do some interpretation. If you look at the satellite picture of that particular intersection you see it is one big intersection and in open street map it's kind of like the square made a cluster of four intersections. And here the interpretation turns us into three junctions which still form a circle unfortunately. So, this is something we can fix, and we'll fix this with the graphical editor netedit. One way to launch this, is from your taskbar (if you have an icon), or simply from sumo-gui by pressing <kbd>Ctrl</kbd> + <kbd>T</kbd>, this is in the Edit menu if you need to recall the hotkey. So we open that up, and now want we want to do is we want to turn this cluster of intersections into a single intersection, which is easy to simulate. So we'll switch to the selection mode (with the letter <kbd>S</kbd>). Now we can click on each of these junctions to select them. And then there's this tool "Join Selected Junctions" with the <kbd>F7</kbd> key. And now it's a single junction. And if you want to see how this looks, we can recompute all the shapes with the <kbd>F5</kbd> key. So that's that. And now <kbd>Ctrl</kbd> + <kbd>S</kbd>, we save the network (you can find this in the file menu obviously). And now, can we restart the simulation? Well yes we can. I pressed <kbd>Ctrl</kbd> + <kbd>R</kbd> to reload it, but it won't work. Because now the roads have changed and we have to rebuild the traffic. So I close the simulation and I go to that folder and run the build batch file. And now I can run the simulation again. And ah yes, now I can switch back to the settings that I stored. And as you can see, there is no error now and the traffic is running. And if we let it run for a little longer, we'll find that it does no longer have this deadlock here in the circle. Now one thing that was important here was to close the simulation because on Windows the files are locked by a running simulation and you cannot regenerate the traffic. So just keep that in mind when working with this tutorial. All right, so, now another small background information: the process that created the network out of the OSM data, it actually wanted to join this junction the way we just did manually and it failed. So it actually gave a warning in its log output and said, no, I couldn't manage to join this junction, though I would have liked to. So this is something to look at when building networks, looking for those warnings.

All right. So what we can do is we can compare how the simulation behaves with and without the fix. And as you may imagine, such a deadlock has quite an impact on the running times of the cars and how long they wait and how much time they lose. And so I've put this down on a little table and you can see that the waiting time, the average waiting time of all the cars in the network was cut in half due to this fix. Now, if you want to get this kind of statistics, one way is to just run the simulation on the command line. So I'll open up command line here and I run `sumo -c osm.sumocfg`, and when this has finished running, you can get all the statistics I just showed on the table on the command line. Of course, there are files, XML files where you can write this to, but this is often a quick and convenient way. All right. 

## Network Editing - Reduce
Moving on to network editing. And by the way, we're actually in a different tutorial folder now. I'll switch to this one. So this is the second part, netedit. I'll open up the editor again, closing the old one. All right. So the next thing we want to do is we want to reduce the network to focus on a smaller part of the simulation. Sometimes this is useful. For example, if you don't want actually rectangular areas, which the web wizard will give you. So again, we go to select mode, pressing the letter <kbd>S</kbd>. And then by holding down <kbd>Shift</kbd>, we can do a rectangle selection and build up the part of the network that we want to keep. So if you, you can keep adding action areas. And of course, you could also switch this to remove areas. So let's add some more. And now you'll find this reduce button. And bam, it reduces your network to the selected extent. And then of course, you save it and you can rebuild the traffic.

## Network Editing - Traffic light
What else can we do? Well, when looking back at that satellite picture, we noticed that the intersection which we had joined actually had all the markings of a traffic light. So was that the case in SUMO? Actually, no. This is, I'm going to join by going to another folder. So this intersection does not have a traffic light. You can see its type is priority. It's no traffic light. It's there. The right of way is governed by priority rules. So let's change this. We go to the traffic light mode by pressing the letter <kbd>T</kbd>. This is this little icon here on top. And if you don't recall the hotkeys, you can find them all in this Edit menu. And now we click on the junction, we can create the traffic light. And that's it. We save the network. And we have the simulation with the traffic light here. And what happens if we do? Oh, actually, one little part of background: OpenStreetMap does have some information about traffic lights, but often, they just record where the signs are. And that's a bit of a challenge to figure out what the control on the section is. All the more if there isn't a single intersection in OpenStreetMap... So in this case, heuristics failed, often it succeeds, but here we had to adapt this manually, which is a teaching moment, I guess. So what happens when we add the traffic light to the simulation? Well, the waiting time of cars goes up because presumably there's not so much traffic, and now some cars have to wait at a red light. So what else can we do? We can change the type of the traffic light, because what we had before was a traffic light that had a fixed cycle plan. So all the phases have the same duration again and again, regardless of the traffic at that intersection. And we can change this by going to the inspection mode, this icon here, clicking the intersection, and then changing the TL type, the traffic light type attribute from "static" to "actuated", and we save the network, and that's all there is to it. What this actually does in the background is it sets minimum and maximum durations based on some options for each of the green phases. And then in the simulation, there will be some traffic detection that cycles the phases. But we'll hear a lot more about traffic lights in this conference based on what I know about the schedule. So let's look at the simulation corresponding to all the changes we did. It's in this final folder. And when we run the simulation, we see that there is this traffic light here. Cars are coming and they wait at the red lights, obviously. And one thing we can look at, is the duration of the phases. So let's right click on one of those colored lines, "Show Parameter". We have all kinds of values here. And one thing that I want to look at is the running duration, so how long does a certain phase actually run. And when I click on this little plot button, a plot window opens up. And let's have these side by side. So the window isn't being hidden. And let's run the simulation. And as you can see, the phases are often quite short, but sometimes they're getting longer due to the presence of traffic that needs a longer phase. So this way we can see that we're actually running an actuated traffic light. And when we look at what this does. So we've reduced the network, then we added a traffic light, which gave 15 seconds of waiting time compared to we only had a priority junction, and now we've turned this into an actuated traffic light. And the average waiting time in the whole scenario goes down, even though there are many intersections. So this goes to show there's quite an impact from the type of traffic light we defined at one intersection. And then you may ask, "well, is this the real traffic light plan that's running at that intersection?" And I have to tell you, no, it's just the best guess, and it's most likely not what happens there, all the more because in the real world this intersection has a tram going through, which certainly affects the way the phases switch. But it's better than no traffic light, and it's also better than having a static traffic light, and often we are trying to approximate the real world as best as we can, in particular in large networks.

## Network Editing - Junction shape
So something else you could do in netedit is, you could actually look at that intersection, shape it. So how would that work? You could right click on that intersection and set a custom junction shape. And then you could move the change around or delete points by <kbd>shift</kbd> clicking or adding more points by just dragging. When you're done, press <kbd>Enter</kbd>. This is seldomly necessary. And in this case, it also has no big impact on traffic, no measurable impact on the average properties over the whole network. All right, so much for the first batch of network editing. Now let's move to a new topic.

## Traffic
Let's talk about traffic. Unfortunately, the traffic you've seen so far in this scenario is simply random because there is no general data source to read traffic data from, so we could build scenarios anywhere in the world. So what happened here in the background with the wizard is it generated a certain configuration to build random traffic for this network. And the key things that I've highlighted here is for how long should the traffic last. So it ends at 3,600 seconds (one hour of traffic). And then there's the `p` parameter, the period between insertion, so this was somehow based on the size of the network. For a larger network, you want more cars typically. So in this network, every 2.1 second, a new car was inserted on a random edge, on a random road, so to speak, driving to some other random road, and the traffic has some attributes, so it's passenger cars and they depart on whatever lane suits their route best. So these are all attributes that were given automatically and the trips should have a minimum distance of 300 meters because otherwise it looks ridiculous. You should have just walked much better for the environment anyway. And then there are a certain number of options that you can use to influence the probability of a certain road network edge to be the origin or destination for traffic. So this option scales the probability with the number of lanes, more lanes means more traffic, and this scales the probability of the fringe factor option in a way that makes traffic more likely to appear at the outside of the network, at the outer border. Also disappear there. This is by the way an option that you can set in the in the web wizard interface when assigning the traffic. And then there's one more option "--validate" that I want to highlight. This ensures that all the random trips that were generated can actually be done. So there is a road from start to end. This may not always be the case, for example, if you download a part of a city with a river and no bridge, then you cannot go from the left to the right side in that scenario and then some trips should rather not be created because they are not valid for this scenario. All right, so much for random traffic. Often it's a good start but it's not the end point of building a good scenario.

## Demand Editing - Flow
And one thing you can do, especially for smaller scenarios, is just defining the traffic flow in a very manual way. Let's say so many cars driving from this point to that point. So let's see how we can do this in netedit. We'll move, we're moving to another folder so let me clean this up. It's a bit of a challenge, so many windows. All right, so this is the third part of the tutorial. This is about traffic flow. And again I used the easy way to open up the network editor by first running the simulation. Pressing <kbd>Ctrl</kbd> + <kbd>T</kbd> to run the editor. So far we've spent some time in the network mode, but there are three major modes. One for editing network things, with all these submodes of inspecting, deleting, creating edges, traffic lights, etc. And you can learn more about these in other tutorials that have been recorded. And then there is a major mode for editing traffic, this is the demand mode. And also a data mode that was explained in last year's tutorial but we'll not use that today. So in the demand mode we can use the submode for vehicles to create some traffic. And you can create individual cars either with fixed routes, these are called vehicles here, or you can define trips where you only give a start and an endpoint and the simulation has to figure out what roads are actually taken and we call these trips here. But let's now create a flow. So a flow is not just one car that shows up in the simulation, but a whole bunch of them. And there are various ways to define them. From one edge to another or from one junction to another or with a fixed route, and right now let's define a flow between two junctions. Let's say from this junction to let's say this junction here. Okay and it's not done yet. I've just defined locations. Let's set some more properties of this flow. So since that edge where it starts has two lanes, we want to have the traffic start on either one. So we set the departLane to a value of random. And then we also want to have the car start with some speed because this is really the edge of the scenario and they're not starting from home but they're really coming in from some other part of the world, so let's set their depart speed to a smarter value let's set this to the average, so whatever the other cars are driving this is the speed that they should come in with and if there's no traffic they can just choose the maximum speed, so random depart lane, average speed and now let's define how many cars we want. So there are various ways to describe this, we could set a number or an end in time let's go with the end in time and then to show you a new feature let's have a traffic that follows a Poisson distribution rather that conforms to a Poisson process and we'll set some kind of arrival rate. Let's use 1.5 cars per second. And you may be wondering, isn't that a bit much? But yes, you will see in a little while. And now finally, I press <kbd>Enter</kbd>, and this car symbol here appears, it shows you that it's a flow. We could also use the inspect mode to review all the properties. But for now, let's save this to a file. And let's use this in the simulation.

So how are we to make sure that this flow gets called? Well, there is, of course, our sumo configuration. And here, we have to make sure that the file is included. So where it says route-files, these are all the traffic definitions, our random passenger trips and now we have our flow which I just named liked this, the name is arbitrary. And then it gets included. So let's run the simulation. Now, this happens when I change things during live testing. Actually, I defined the traffic flow between edges, not between junctions. If you define traffic between junctions, you actually have to set another simulation option. This one (`<junction-taz value="true"/>`). Teaching moment again... So let's look at that simulation. We have the traffic coming in. And let's make this a little bigger. And actually let's not color the cars by streets, but by their default coloring. No, not those. No, that didn't help very much because I forgot to give them a distinct color. I wanted to have them in blue. So let's change that real quick. Let's give them the color blue. And I saved the demand with <kbd>Ctrl</kbd> + <kbd>Shift</kbd> + <kbd>D</kbd>. And now that didn't work out. Why didn't it? Those are blue. Am I in the right folder? Those are blue. That's fine as well. And now vehicles by their given color. All right. Yes, there they are. Now we can see our flow is opposed to all the random traffic we had beforehand. And now you may be wondering, do we really have a Poisson distribution here? Well, I'm afraid we don't. Because what happens is that we've actually defined more traffic than the network can handle. And this is shown by this little icon here turning yellow. And by a certain number here going up, this is the number of insertion backlog vehicles. And I'll just open a little plot for you to see. I'll rerun the simulation, and I'll show you the number of insertion backlog vehicles. This number keeps going up and up and up and up. And yes, it doesn't stop. So what this basically says is we've defined too much traffic. Cars that cannot enter the road network due to lack of space, they are delayed in their insertion with the goal of inserting them later. But the traffic never lets up. So this queue gets never emptier. We have to define fewer traffic. So let's do this right now. Let's change this traffic. And now I could do this in netedit, but I do it in the files here very quick. And I changed this rate parameter here from 1.5 to 0.7. So let's have fewer traffic. And let's look at the simulation. And the insertion backlog. And now you can see this looks much tamer. Often this falls back to zero. But we're still not quite happy. So there are a number of things we could do. We could decrease the traffic further, in particular, under the realization that there's a big bottleneck here. And there is something else we can do. Let's go back to the slides for a little bit. We could set one of the rather novel options for SUMO. This is the option `extrapolate-departpos`. So what does this do? Whenever you insert traffic in SUMO, this happens during the simulation step or rather at the end of the simulation step. So if you step one second, if you have one second per step, then every second a car can enter. But this kind of constrains the spacing between the cars. Of course we could lower the time or increase the time resolution of the simulation. But we could also do is set this new option which ensures that cars that actually wanted to be parked between two full seconds that they are moved along a little bit. And so we have much better spacing in the simulation. So let's show you how this looks. So I've prepared a second configuration file and this just sets this option (`extrapolate-departpos`). And when we run this, what you see in those plots is that it stays at zero, the insertion backlog starts at zero, stays at zero for larger periods of time. But as you can see it still goes up from time to time and this is where we don't really have the Poisson spacing we want. So it's still a bit too much traffic. All right. So much for the traffic flow.

## Opposite-Direction driving
Now onto the next topic of opposite direction driving. This is a new folder. So let's talk about the two things that we need for opposite direction driving. We need to change the network with some additional information that's as well. This is one road and that other road that's really the opposite side, you can move between those for overtaking. So this is the first thing we have to do. And I'll show you how this looks in the network editor. So first of all, let's look at an edge that has a potential opposite direction. So here we have one direction of the road and here we have another direction of the road. And as long as we look at those edges, we won't find what we're looking for. We have to really inspect the lanes of the edge, either by holding down <kbd>Shift</kbd>, as you can see, the icon at the cursor even changes. So now when we click here, we see the attributes of lanes, but we could also click this button. Then every click would inspect lanes. So let's look at the lane. This has a little opposite attribute, which is empty at the moment. So how are we going to fill this? We're going to use an option that populates all those fields automatically whenever there's an opposite direction lane. So we'll go to the options screen and then all the options that are available in netconvert can be found here. In the bottom of the processing tab, we'll have "opposite.guess". And if we set this option and rebuild the network, I'll press <kbd>F5</kbd>. And when we look at that lane, it has the opposite information filled in. All right. So that's the one thing we want to do. And now the second thing we need to do is we need to give the cars some reason to overtake. Because they could do this if a very fast car finds itself behind a very slow car. But in these types of urban networks, the more common reason is to have cars parked on the road that really force you to overtake through the opposite direction. So let's create some traffic parked on the road. We go to demand mode, which is <kbd>F3</kbd>, and this button here, and to the vehicle mode. And let's create some trips. And we want the cars to be just parked in this area, two in one direction, one in the other direction. And so let's make it so that they depart at their stop location. So I set departPos to stop. And then I click once here, followed by <kbd>Enter</kbd>. Again here, followed by <kbd>Enter</kbd> again here. Now I have defined three trips. Actually, they are not shown in that position yet. It didn't define any stops yet. So let's do that as a next step. We go to the stop mode with the letter <kbd>A</kbd>. And now we have to define for which car we want to select the stop. In this case, it's simple. We don't have very many, so we can just select them on the drop down. And now let's have them stop. Somewhere here along the route for 3,600 seconds. So make them a real annoyance for traffic. And I press <kbd>Enter</kbd>, it's there. Now for the other car, for the second car going this way, let's also create a stop. Actually, I don't even need to press <kbd>Enter</kbd>, the click is enough. And one more here. And let's inspect those stops to make sure that all of them have the correct attributes. Yes, 3,000. Well, 660 doesn't really matter at this point. This one as well. And this one, I still need to change 3,600. All right. So I find that these are too closely spaced. So let's move them around a bit with move mode. And I just drag those stops to give the overtaking cars a bit more room. And then of course I have to save this as demand. And now let's just look at, I'm not saving this. I'm using files I saved beforehand. Let's just go to the new tutorial files and see how this looks simulation. All right. So first of all, let's do a single simulation step to see those cars appear. And I could click this button. I could also press the <kbd>D</kbd> key on my keyboard to do a single step. And as you can see here are the cars. Two going to the northern direction, one going to the southern direction. I can click on them, show their route, and then I'll find they have to stop for 3,600 seconds. Now let's see the traffic coming in. And let's make the vehicles large again. And there we go. All right. So you can see the cars have to kind of weave through here. And if there's traffic coming from the opposite side, they have to wait. But I guess that's not exciting enough because that's still just the random traffic. And we really want to see what's happening with lots of traffic. So let's use the other config with the flow that we defined beforehand. Again, make the cars large. And let's go. So now here we have those, this big wave of cars moving up. And they may think that's a good idea to drive here. But as you can see, the queue is building up whenever there's traffic coming from the other side. So they have to wait. Now, even this traffic has to wait here because otherwise there would be a total blockage. And then at some point, the blue cars decide they're better off going the other route, which is a good decision that those trips take automatically, all those flows with an unconstrained route will take automatically in SUMO. All right, so that's for opposite direction driving.

## Pedestrian Crossing
Then moving on to the next topic of pedestrian crossing. Now, in the wizard, we could have just activated the traffic type of pedestrians. And we would have received the network that is ready made for pedestrians' simulation. But sometimes it's good to know how to build things from scratch. So this is what I'll show you now. So in the network, let's open a network... Another way to open a network, of course. Let's look at our favorite intersection here and all the steps we need to take to turn this into a pedestrian-ready intersection. All right, so what we want to add are sidewalks because our pedestrians have to walk somewhere. I'll enter the selection mode and I'll just draw a big rectangle here. And now I have several things selected, junctions and edges. But when I right-click on one of those selected edges, I can perform operations on all of them. So I'm going to add a restricted lane of type sidewalk. Eight sidewalks are added. Now I cancel my selection with <kbd>Esc</kbd>, and I recompute the geometry with <kbd>F5</kbd>. And so now the pedestrians have some place to walk, only in the vicinity of this crossing. And this has one important side effect. Not only does it create lanes that are exclusive to pedestrians. When I click here, inspect mode, when I click here, I find that only pedestrians are allowed here. This is the only green checkmark. And if I click here, I'll find that the pedestrians are disallowed. So they're the disallowed box. In contrast to those other road network edges that only disallow rail traffic and ships, but they still permit pedestrians. This kind of road network is a shared space simulation. But here, we don't want shared space, we want a real crossing where the pedestrians have to wait and then cross. All right, so we have the sidewalks let's do the crossings themselves. This is the crossing mode activated by <kbd>R</kbd> we click on the junction and now we could add one big crossing across those edges by selecting them and pressing <kbd>Enter</kbd> but let's not do this we want little islands so let's click on each edge and turn and press <kbd>Enter</kbd> to create the crossing and that's it, crossings all around and if we open this in sumo-gui this is how it looks. All right, the next step is to add pedestrian traffic, so again we go to demand mode and then to the person mode you're already familiar with the concept of a flow so now let's have this flow for persons and just have them walk from here to there, and from here to there, and we can save this as demand and now let's look at this in the simulation. What do we have? We have all sidewalks, let's make the simulation a bit slower and what I did here was I changed the visualization to have the pedestrians show up as little circles because in this way they have good visibility and if you look very closely I loaded the file that I defined beforehand because suddenly there's traffic crossing twice going from here over there to there which is a bit more interesting and of course you can do this also by just selecting other targets, there are many potential routes to take by the pedestrians and they are not constrained to any particular direction they can use all sidewalks in all directions. So this is the pedestrian simulation.

## Parking Search
Now to the last part of the tutorial before we are running out of time, let's talk about something more advanced let's talk about traffic in search of parking. Right now our traffic has entered the simulation and then they've well basically disappeared on the final edge, either at the border of the network or somewhere within the network, and this time we want something different: we want them all to find a parking spot at the end of their route, at the end of their trip. So for this we need to have three things: we need to define infrastructure (parking areas) and of course we could define those manually in netedit, but today I'll show you a pipeline to do all this fully automatic. So we'll need parking areas in our network. The next thing we'll need is a change of plans. The cars, they have to stop at the end of their route and again we could add those in netedit, but here I'll show you how to do this automatically. And we'll need a final thing for our parking search: we'll need information about, well, about the presence of alternative parking areas in the area. So think of those as the little parking guidance signs. Sometimes it's just a sign that says parking this way and sometimes it's a real information sign that has a digital display for showing the current occupancy of the parking areas at the destination. And you can define either one. And this today will go for just the signs that tell there is parking to be had this way. So the cars have to guess the occupancy. So all this is happening with three scripts that are put in a batch file and I'll go over the options for these, the meaning of these script real quickly. The first one generates parking areas for a whole network ([generateParkingAreas.py](../Tools/Misc.md#generateparkingareaspy)). So basically here, it adds a parking capacity parking area to pretty much every edge. We can also add some randomization there. We find to the output files. This will hold the parking areas (`parking.add.xml`). It defines that each area has random capacity, and even if that should drop to zero, let's keep it anyway. So the parking areas will have capacity anywhere from one to a larger number. And let's not have any parking areas on motorways or motorway ramps. That would be sin. Okay. So the next script, it adds stops at the end of every trip ([addStops2Routes.py](../Tools/Routes.md#addstops2routespy)). Again, it loads a network and it loads a demand file. These are all random passenger trips. And it also loads the parking areas and says, well, just not park anywhere, but park at the parking area for a duration of one hour. And finally, there's a script that generates the connectivity or visibility ([generateParkingAreaRerouters.py](../Tools/Misc.md#generateparkingarearerouterspy)), it also needs the network, the parking areas, an output file, and in this case, it says, well, let's have the visibility, at least for the other side of the road. Going one way, you can see whether the parking areas on the other side of the road are occupied or not. And let's look for alternatives in an area of four kilometers. This is a bit extreme, but you'll see why we'll need this in a second. So all this is tied together in this batch file in the last part of the tutorial. So let's run this real quick. And it runs through all these stages. And then we can look at our simulation. So what do we see here? We see funny colors. I've colored the roads, streets or edges by the number of free parking spaces. So let's have a legend here. So somewhere between... up to maybe 20 or 40 parking spaces on some of that just know, but even more here. So let's run the simulation. And we have our cars this time I show them as circles and they're driving through the network, and what are they going to do? Well, let's look at one of those cars, and not one on the motorway, but one on the road. Let's show the route. So this car wants to stop there for 3,600 seconds. Well, then let's follow this car. I'll do a <kbd>Shift</kbd>-click on the car or its route and I'm in tracking mode. And so let's track where it's going. Well, it did find a parking spot and that's it. So to stop tracking the car, I can do a right click here and select "stop tracking", or I can just double click and now I'm free again. But let's not show this route anymore. And let's run the simulation for a little while longer to have the parking areas fill up. And as you can see, the colors change. They change to gray when there's no parking capacity left on an edge. So let's now follow some other car on its desperate search for parking. Track it. All right. So let's see how it goes. And as you can see, there were some jumps here. So it arrived at a point where there was no parking and it picked an alternative and then it finally found one. So the parking part of SUMO, it provides for a large number of options to configure the way these cars actually pick their alternatives. And then at the end, when we run this long enough, actually all the cars have find a parking spot. And if we wonder how long they took for this, well, we can just recolor them by the number of times that they changed their route. And as we can see, some cars took quite a number of attempts to do so. And some of them are actually still going, still looking. But in the end, everyone found their spot. All right. That's all I wanted to show you for today. We will be going on a break. And then we'll be ready for the "ask us anything" session, so to sum this up, I used osmWebWizard to get a quick start, don't forget to read the documentation, report any bugs you find, please share your scenarios and results (we are really happy when you do so). We are always looking forward to talk to people that want to do projects with us. Thank you for your attention!


# Other conference tutorials

Take a look at our other conference tutorials, [here](index.md#sumo_user_conference_tutorials).