/*===========================================================================
*
*                            PUBLIC DOMAIN NOTICE
*               National Center for Biotechnology Information
*
*  This software/database is a "United States Government Work" under the
*  terms of the United States Copyright Act.  It was written as part of
*  the author's official duties as a United States Government employee and
*  thus cannot be copyrighted.  This software/database is freely available
*  to the public for use. The National Library of Medicine and the U.S.
*  Government have not placed any restriction on its use or reproduction.
*
*  Although all reasonable efforts have been taken to ensure the accuracy
*  and reliability of the software and data, the NLM and the U.S.
*  Government do not and cannot warrant the performance or results that
*  may be obtained by using this software or data. The NLM and the U.S.
*  Government disclaim all warranties, express or implied, including
*  warranties of performance, merchantability or fitness for any particular
*  purpose.
*
*  Please cite the author in any work or product based on this material.
*
* ===========================================================================
*
*/

#ifndef _h_locked_value_
#define _h_locked_value_

#ifdef __cplusplus
extern "C" {
#endif

#ifndef _h_klib_rc_
#include <klib/rc.h>
#endif

#ifndef _h_kproc_lock_
#include <kproc/lock.h>
#endif

typedef struct locked_value
{
    KLock * lock;
    uint64_t value;
} locked_value_t;

rc_t locked_value_init( locked_value_t * self, uint64_t init_value );
void locked_value_release( locked_value_t * self );
rc_t locked_value_get( locked_value_t * self, uint64_t * value );
rc_t locked_value_set( locked_value_t * self, uint64_t value );

#ifdef __cplusplus
}
#endif

#endif
