/*
 * baseout.h: header for baseout.cpp.
 */

/*
 * Rounding modes.
 */
enum RoundingMode {
    /*
     * The obvious two directed rounding modes. (If the caller
     * wants round-to-minus-inf or round-to-plus-inf, they must
     * work that out for themselves by considering the sign.)
     */
    ROUND_TOWARD_ZERO,
    ROUND_AWAY_FROM_ZERO,
    /*
     * Four forms of round-to-nearest, differing in what they
     * do to exact ties. Again, the two directed tie-breaking
     * policies are signless.
     */
    ROUND_TO_NEAREST_EVEN,
    ROUND_TO_NEAREST_ODD,
    ROUND_TO_NEAREST_TOWARD_ZERO,
    ROUND_TO_NEAREST_AWAY_FROM_ZERO,
    /*
     * Modes which depend on the sign. Inside baseout.cpp, these are
     * translated into one of the modes above once the sign of the
     * number is known.
     */
    ROUND_UP,
    ROUND_DOWN,
    ROUND_TO_NEAREST_UP,
    ROUND_TO_NEAREST_DOWN
};

/*
 * Construct an OutputGenerator for numbers written in standard
 * positional notation in any integer base from 2 to 36.
 */
OutputGenerator *base_format(Spigot *spig, int base, int uppercase,
                             bool has_digitlimit, int digitlimit,
                             RoundingMode rmode, int minintdigits);

/*
 * Construct an OutputGenerator for numbers formatted like IEEE bit
 * patterns (with optional trailing digits for extra precision).
 */
OutputGenerator *ieee_format(Spigot *spig, int ieee_bits,
                             bool has_digitlimit, int digitlimit,
                             RoundingMode rmode);

/*
 * Construct an OutputGenerator to format a string based on a
 * 'printf' float-type specification.
 *
 * 'width' and 'precision' are the numbers given in the specification,
 * or -1 in each case to indicate that none was provided. 'specifier'
 * is the char value of the main formatting directive (one of
 * 'e','f','g','a' or its uppercase equivalent). 'flags' is a bit-mask
 * in which the bit (1 << n) means the nth flag character in
 * PRINTF_FLAGSTR.
 *
 * 'nibble_mode' controls the choice of exponent in %a formats. If it
 * is false, the chosen exponent is always as large as possible, so
 * that the leading digit (for any nonzero number) is 1. If true, the
 * chosen exponent is always a multiple of 4, so that the hex digits
 * of the output align to the hex digits in ordinary -b16 mode.
 */
#define PRINTF_FLAGSTR "-+ #0"
OutputGenerator *printf_format(Spigot *spig, RoundingMode rmode,
                               int width, int precision,
                               int flags, int specifier,
                               bool nibble_mode);
