/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 */

namespace AGS {

const PlainGameDescriptor GAME_NAMES[] = {
	{ "ags", "Adventure Game Studio Game" },
	{ "ags-scan", "AGS Game Scanner" },

	// Pre-2.5 games that aren't supported by the current AGS engine
	{ "6da", "The 6 Day Assassin" },
	{ "aaronsepicjourney", "Aaron's Epic Journey" },
	{ "aceduswell", "Ace Duswell: Where's The Ace?" },
	{ "achristmastale", "A Christmas Tale" },
	{ "adayinthefuture", "A Day In The Future" },
	{ "adventuregame", "Adventure Game" },
	{ "agsbgeditor", "AGS Background Editor" },
	{ "aliengame", "Alien Game" },
	{ "anotherrpg", "Another RPG" },
	{ "asapadventure", "ASAP Adventure" },
	{ "bertthenewsreader", "Bert the Newsreader" },
	{ "billybobwildnight", "Billy Bob's Wild Night" },
	{ "blackjack", "AGS Blackjack" },
	{ "blastoff", "Blastoff!" },
	{ "bluecupontherun", "Bluecup on the Run" },
	{ "bobsquest2", "Bob's Quest 2: The quest for the AGS Blue cup award" },
	{ "bookofspells1", "Book of Spells 1" },
	{ "bookofspells2", "Book of Spells 2" },
	{ "bookofspells3", "Book of Spells 3" },
	{ "calsoon", "Calsoon" },
	{ "candy", "I Want Candy" },
	{ "captainmuchly", "Captain Muchly Drinks Bleach" },
	{ "carverisland1", "The Secret of Carver Island" },
	{ "carverisland2", "Carver Island 2: Mrs. Rodriguez's Revenge" },
	{ "castlequest", "Castle Quest" },
	{ "chef", "The Chef" },
	{ "commanderkeenron", "Commander Keen Enters Reality-on-the-Norm" },
	{ "compensation", "Compensation" },
	{ "cosmos", "Cosmos" },
	{ "crimetime", "Crime Time" },
	{ "cutlass", "Cutlass" },
	{ "damnthatspill", "Clyde Remolen in: Damn that Spill!" },
	{ "darksects", "Dark Sects" },
	{ "darts", "Darts" },
	{ "davyjonescestmort", "Davy Jones c'est Mort" },
	{ "davyjonesisback", "Davy Jones is Back" },
	{ "deepbright", "Deepbright" },
	{ "defenderofron", "Defender of Reality-on-the-Norm" },
	{ "defsrpgdemo", "Def's RPG Demo" },
	{ "demonslayer1", "DemonSlayer 1: Bert the Super Demon Slayer Guy" },
	{ "demonslayer2", "DemonSlayer 2: DemonSlayer vs. Vegetable Vampires" },
	{ "demonslayer3", "DemonSlayer 3: Hotel and Alley" },
	{ "demonslayer4", "DemonSlayer 4" },
	{ "dirkchafberg", "Dirk Chafberg" },
	{ "domjohnson", "Dom Johnson" },
	{ "earwigisangry", "Earwig Is Angry!" },
	{ "edgeofreality", "Edge of Reality" },
	{ "edsgravedigger", "Ed's Gravedigger" },
	{ "elburro", "El Burro" },
	{ "equallyinsane", "Jake Rabbit in: E.I. - Equally Insane" },
	{ "erniesbigadventure1", "Ernie's Big Adventure" },
	{ "erniesbigadventure2", "Ernie's Big Adventure II" },
	{ "everythingeuro", "Everything Euro (Alles Euro)" },
	{ "exile", "Exile" },
	{ "exodus", "Exodus" },
	{ "eyesofthejadesphinx", "Eyes of the Jade Sphinx" },
	{ "faddevil", "Fad of Devil's Hash" },
	{ "fatman", "Fatman" },
	{ "firewall", "Firewall" },
	{ "floyd", "Floyd SB the Company Man" },
	{ "fowlplay", "Reality-on-the-Norm 2 and 1/2: Fowl Play" },
	{ "gaeafallen", "Gaea Fallen" },
	{ "gorthor", "Gorthor of the Cave People" },
	{ "grandfathertreasure", "Grandfather's Treasure" },
	{ "grannyzombiekiller", "Granny Zombiekiller in: Mittens Murder Mystery" },
	{ "gregsmountainousadventure", "Greg's Mountainous Adventure" },
	{ "greysgreytadv", "Mr. Grey's Greyt Adventure" },
	{ "helmsuntitled", "Helm's Untitled Game" },
	{ "henkkaquest", "Henkka: Mini Quest" },
	{ "hermit", "Hermit" },
	{ "hiphendrix", "Highly Hip Hendrix" },
	{ "hookymcp", "Hooky McPegleg, Pirate Postman" },
	{ "housequest", "Joe Jenkins in: House Quest" },
	{ "huckleburyhippie", "Hucklebury Hippie" },
	{ "ijuntitled", "Ian James' Untitled Game" },
	{ "inadream", "In a Dream" },
	{ "indysecretchamber", "Indiana Jones and the Secret Chamber of Schloss Brunwald" },
	{ "intergalacticlife", "Intergalactic Life" },
	{ "invasionspacealiens", "Invasion of the Space Aliens Who Are Not From Earth But From Some Other Planet" },
	{ "islandquest", "Island Quest" },
	{ "ispy", "I Spy" },
	{ "jamesbondage", "James Bondage" },
	{ "javajo", "Java Jo's Koffee Stand!" },
	{ "jinglebells", "Jingle Bells" },
	{ "kidnapped", "Kidnapped" },
	{ "kittensandcacti", "Kittens and Cacti" },
	{ "larryvales1", "Larry Vales: Traffic Division" },
	{ "larryvales2", "Larry Vales II: Dead Girls are Easy" },
	{ "larryvales3", "Larry Vales III: Time Heals All 'Burns" },
	{ "lassi", "Lassi and Roger" },
	{ "lassiandrogermeetgod", "Lassi and Roger Meet God" },
	{ "lassiquest1", "Lassi Quest I" },
	{ "littlejonnyevil", "Little Jonny Evil" },
	{ "littlewillie", "Little Willie" },
	{ "losttreasureron", "The Lost Treasure of Reality-on-the-Norm" },
	{ "ludwig", "VonLudwig" },
	{ "lunchtimeofthedamned", "Lunchtime Of The Damned" },
	{ "lupoinutile", "Lupo Inutile" },
	{ "meninbrown", "Men In Brown" },
	{ "miagsremake", "Monkey Island AGS Remake" },
	{ "midtownshootout", "Anton Ulvfot's Mid-Town Shootout" },
	{ "mikasdream", "Mika's Surreal Dream" },
	{ "momsquest", "Mom's Quest" },
	{ "monkeyplank", "Monkey Plank" },
	{ "moosewars", "Moose Wars: Desire For More Cows" },
	{ "murder", "Murder" },
	{ "nicholaswolfe1", "Nicholas Wolfe part I: Framed" },
	{ "nightoftheplumber", "Night of the Plumber" },
	{ "nightwatch", "Nightwatch" },
	{ "nihilism", "Nihilism" },
	{ "novomestro", "Novo Mestro" },
	{ "odysseus", "The Trials of Odysseus Kent" },
	{ "permanentdaylight", "Permanent Daylight" },
	{ "perpetrator", "Perpetrator" },
	{ "pizzaquest", "Pizza Quest" },
	{ "pointblank", "Point Blank" },
	{ "pornquest", "Porn Quest" },
	{ "postmanonlydiesonce", "The Postman Only Dies Once" },
	{ "qfc", "Quest For Colours" },
	{ "qfg412", "Quest for Glory 4 1/2" },
	{ "racingmanager", "Racing Manager" },
	{ "raymondskeys", "Raymond's Keys" },
	{ "red", "Red" },
	{ "returnofdvs", "Return of Die Vie Ess" },
	{ "richardlonghurst", "Richard Longhurst and the Box That Ate Time" },
	{ "ripp", "RIPP" },
	{ "robblanc1", "Rob Blanc I: Better Days of a Defender of the Universe" },
	{ "robblanc2", "Rob Blanc II: Planet of the Pasteurised Pestilence" },
	{ "robblanc3", "Rob Blanc III: The Temporal Terrorists" },
	{ "rodekill", "Rode Kill: A Day In the Life" },
	{ "rodequest", "Rode Quest" },
	{ "ronbeachparty", "Reality-on-the-Norm Beach Party" },
	{ "ronxmas2002", "Reality-on-the-Norm Xmas 2002" },
	{ "samthepiratemonkey", "Sam The Pirate Monkey" },
	{ "slackerquest", "Slacker Quest" },
	{ "snailquest1", "Snail Quest" },
	{ "snailquest2", "Snail Quest 2" },
	{ "snailquest3", "Snail Quest 3" },
	{ "sol", "Sol" },
	{ "sovietunionstrikesback", "The Soviet Union Strikes Back" },
	{ "space", "Space" },
	{ "stickmen", "Stickmen" },
	{ "superdisk", "Superdisk" },
	{ "testicle", "Day of the Testicle" },
	{ "thecrownofgold", "The Crown of Gold" },
	{ "theinexperiencedassassin", "The Inexperienced Assassin" },
	{ "theisland", "The Island" },
	{ "thendor", "Thendor" },
	{ "thetower", "The Tower" },
	{ "thewarp", "The Warp" },
	{ "tommato", "Tom Mato's Grand Wing-Ding" },
	{ "tulliesworld1", "Tullie's World 1: The Roving of Candale" },
	{ "tvquest", "TV Quest" },
	{ "uishowoff", "Interface Show-off" },
	{ "universalequalizer", "The Universal Equalizer" },
	{ "vengeanceofthechicken", "Vengeance of the Chicken" },
	{ "waitkey", "WaitKey();" },
	{ "winfry", "Winfry" },
	{ "zakagsremake", "Zak McKracken and the Alien Mindbenders AGS Remake" },
	

	// AGDI games. They get their own grouping because they're just that awesome
	{ "kq1agdi", "King's Quest I: Quest for the Crown Remake" },
	{ "kq2agdi", "King's Quest II: Romancing the Stones Remake" },
	{ "kq3agdi", "King's Quest III Redux: To Heir is Human" },
	{ "qfg2agdi", "Quest for Glory II: Trial by Fire Remake" },

	// Infamous Adventures games. Likewise
	{ "sq2fg", "Space Quest for Glory" },
	{ "sq2vga", "Space Quest II - Vohaul's Revenge VGA Remake" },
	{ "kq3vga", "King's Quest III: To Heir is Human VGA Remake" },

	// Commercial games
	{ "3geeks", "3 GEEKS" },
	{ "alemmo", "Al Emmo And The Lost Dutchman's Mine" },
	{ "alemmoanozira", "Al Emmo's Postcards from Anozira" },
	{ "alum", "Alum" },
	{ "apotheosis", "The Apotheosis Project" },
	{ "astroloco", "Astroloco: Worst Contact"},
	{ "atotk", "A Tale Of Two Kingdoms" },
	{ "beer", "Beer!" },
	{ "blackwell1", "The Blackwell Legacy" },
	{ "blackwell2", "Blackwell Unbound" },
	{ "blackwell3", "The Blackwell Convergence" },
	{ "blackwell4", "The Blackwell Deception" },
	{ "blackwell5", "The Blackwell Epiphany" },
	{ "captaindisaster", "Captain Disaster in: Death Has A Million Stomping Boots" },
	{ "charnelhousetrilogy", "The Charnel House Trilogy" },
	{ "chronicleofinnsmouth", "Chronicle of Innsmouth" },
	{ "crystalshardadventurebundle", "Crystal Shard Adventure Bundle" },
	{ "danewguys2", "Da New Guys: Day of the Jackass" },
	{ "detectivegallo", "Detective Gallo" },
	{ "diamondsintherough", "Diamonds in the Rough" },
	{ "docapocalypse", "Doc Apocalypse" },
	{ "donticeyourcool", "Don't Ice Your Cool" },
	{ "downfall2009", "Downfall (2009)" },
	{ "downfall2016", "Downfall (2016)" },
	{ "dustbowl", "Dustbowl" },
	{ "falconcity", "Falcon City" },
	{ "feriadarles", "Feria d'Arles" },
	{ "footballgame", "Football Game" },
	{ "geminirue", "Gemini Rue" },
	{ "ghostdream", "Ghostdream" },
	{ "goldenwake", "A Golden Wake" },
	{ "grandmabadass", "GrandMa Badass" },
	{ "guardduty", "Guard Duty" },
	{ "herdiscoming", "Herd is Coming" },
	{ "jorry", "JORRY" },
	{ "justignorethem", "Just Ignore Them" },
	{ "justignorethemremake", "Just Ignore Them (Remake)" },
	{ "kathyrain", "Kathy Rain" },
	{ "killyourself", "Kill Yourself" },
	{ "lamplightcity", "Lamplight City" },
	{ "legendofhand", "Legend of Hand" },
	{ "mage", "Mage's Initiation: Reign of the Elements" },
	{ "metaldead", "Metal Dead" },
	{ "mountainsofmadness", "Chronicle of Innsmouth: Mountains of Madness" },
	{ "mybigsister", "My Big Sister" },
	{ "neofeud", "Neofeud" },
	{ "oott", "Order of the Thorne: The King's Challenge" },
	{ "phantomfellows", "The Phantom Fellows" },
	{ "primordia", "Primordia" },
	{ "qfi", "Quest for Infamy" },
	{ "resonance", "Resonance" },
	{ "richardandalice", "Richard & Alice" },
	{ "roguestate", "Rogue State" },
	{ "samaritan", "The Samaritan Paradox" },
	{ "shardlight", "Shardlight" },
	{ "shivah", "Shivah" },
	{ "strangeland", "Strangeland" },
	{ "sumatra", "Sumatra: Fate of Yandi" },
	{ "superjazzman", "Super Jazz Man" },
	{ "tales", "Tales" },
	{ "technobabylon", "Technobabylon" },
	{ "theadventuresoffatman", "The Adventures of Fatman" },
	{ "theantidote", "The Antidote" },
	{ "thebeardinthemirror", "The Beard in the Mirror" },
	{ "thecastle", "The Castle" },
	{ "thecatlady", "The Cat Lady" },
	{ "thesecretsofjesus", "The Secrets of Jesus" },
	{ "theterribleoldman", "The Terrible Old Man" },
	{ "timegentlemenplease", "Time Gentlemen, Please" },
	{ "unavowed", "Unavowed" },
	{ "untilihaveyou", "Until I Have You" },
	{ "waitingfortheloop", "Waiting For the Loop" },
	{ "welcometosunnymunarvagir", "Welcome to Sunny Munarvagir" },
	{ "whispersofamachine", "Whispers of a Machine" },
	{ "zniwadventure", "Zniw Adventure" },
	// Commercial Italian games
	{ "onironauta", "Onironauta" },

	// Post-2.5 games that are likely supported by the AGS engine
	{ "10waysfromsunday", "10 Ways from Sunday" },
	{ "11-11-11", "11-11-11" },
	{ "1213", "1213 Episode 1" },
	{ "15minutes", "15 Minutes" },
	{ "30minutes", "30 minutes" },
	{ "1dayamosquito", "1 day a mosquito" },
	{ "2034acaftercanada1", "2034 A.C. (After Canada)" },
	{ "2034acaftercanada2", "2034 A.C. (After Canada) II" },
	{ "24hours", "24 Hours" },
	{ "3pigsandawolf", "Three Little Pigs and a Wolf" },
	{ "46memorylane", "46 Memory Lane" },
	{ "4lungboy", "4-Lung Boy" },
	{ "4ofclubs", "4 of Clubs" },
	{ "5daysastranger", "5 Days A Stranger" },
	{ "5oclocklock", "5-O'clock Lock" },
	{ "6daysasacrifice", "6 Days A Sacrifice" },
	{ "6mornings", "6mornings" },
	{ "7daysaskeptic", "7 Days A Skeptic" },
	{ "9hourstodawn", "9 Hours to Dawn" },
	{ "9monthsin", "9 Months In" },
	{ "aazor", "Aazor: Life of a Demon - Part I: The Beginning" },
	{ "abducted", "Abducted" },
	{ "abducted10mins", "Abducted 10 Minutes" },
	{ "abduction", "Abduction" },
	{ "abettermousetrap", "A Better Mouse Trap" },
	{ "ablemabel", "Able Mabel gets a Job" },
	{ "absent", "Absent" },
	{ "absentpart1", "Absent - Part I" },
	{ "absin", "Absin - An Interactive Mystery" },
	{ "absurdistan", "Absurdistan" },
	{ "acatsnight1", "A Cat's Night" },
	{ "acatsnight2", "A Cat's Night 2 - Orazio Goes To Town" },
	{ "access", "_Access" },
	{ "aceking", "Ace King" },
	{ "acequest", "Ace Quest" },
	{ "acharchronicles", "Achar Chronicles: Oblitus" },
	{ "achristmasblunder", "A Christmas Blunder" },
	{ "achristmasghost", "A Christmas Ghost" },
	{ "achristmasnightmare", "A Christmas Nightmare" },
	{ "achristmaswish", "A Christmas Wish" },
	{ "aciddd", "AciDDD" },
	{ "acjadventure", "A Christopher Jones Adventure" },
	{ "acureforthecommoncold", "A Cure for the Common Cold" },
	{ "acuriouspastime", "A Curious Pastime" },
	{ "acurioussilence", "A Curious Silence" },
	{ "adateinthepark", "A Date in the Park" },
	{ "adaywithmichael", "A Day with Michael" },
	{ "advallinthegame", "Adventure: All In The Game" },
	{ "advbunnybunnyman", "Adventures of Bunny Bunnyman (Pupu Pupulaisen Seikkailut)" },
	{ "adventureisland", "Adventure Island" },
	{ "adventurequest", "Adventure Quest" },
	{ "adventurequest2", "Adventure Quest 2 - Winterlong" },
	{ "adventuresofjoshanddyan", "Adventures of Josh and Dyan" },
	{ "adventuresofmaxfaxepisode1", "Adventures of Max Fax (episode 1)" },
	{ "adventuresofprincessmarian", "Adventures of Princess Marian" },
	{ "adventuretheinsidejob", "Adventure: The Inside Job" },
	{ "advwelcome", "Adventure: Welcome to the Genre" },
	{ "aerinde", "Aerinde" },
	{ "aeronuts", "AeroNuts" },
	{ "affairoftheweirdo", "Affair of the Weirdo" },
	{ "afragmentofher", "A Fragment of Her" },
	{ "afriendindeed", "A Friend Indeed ..." },
	{ "afrojones", "Afro Jones" },
	{ "afterashadow", "After a Shadow" },
	{ "agentbee", "Agent Bee" },
	{ "agenthudson", "Agent Hudson" },
	{ "agenttrinityepisode0theultimatum", "Agent Trinity - Episode 0 - The Ultimatum" },
	{ "aggghost", "A G-G-Ghost!" },
	{ "agitprop", "Agitprop: The Game" },
	{ "agnosticchicken", "Agnostic Chicken" },
	{ "agsawards2008", "AGS Awards Ceremony 2008" },
	{ "agsawards2016", "AGS Awards Ceremony 2016" },
	{ "agsawards2017", "AGS Awards Ceremony 2017" },
	{ "agsawards2020", "AGS Awards Ceremony 2020" },
	{ "agsawardsbp", "AGS Awards Backstage Pass" },
	{ "agscamerastd", "AGS Cameras Tech Demo" },
	{ "agschess", "AGS Chess" },
	{ "agscolosseum", "AGS Colosseum" },
	{ "agsdarts", "AGS 180 Darts" },
	{ "agsdarts2", "AGS 180 Darts 2" },
	{ "agsinvaders", "AGS Invaders" },
	{ "agsjukebox", "AGS JukeBox" },
	{ "agslife", "AGSLife" },
	{ "agsmagus", "AGS Magus" },
	{ "agsmastermind", "AGS Mastermind" },	
	{ "agsmittensshooter", "AGS Mittens Shooter" },
	{ "agsmoduletester", "Ags Module Tester" },
	{ "agsyahtzee", "AGS Yahtzee" },
	{ "agsyahtzee2", "AGS Yahtzee 2" },
	{ "agunshotinroom37", "A Gunshot in Room 37" },
	{ "ahmetsagsfightgameremix", "Ahmet's AGS Fight Game Remix" },
	{ "ahomieadventure", "A Homie Adventure" },
	{ "aidaschristmas", "Aida's Strange Christmas" },
	{ "ainthegoffantabulousw", "Adventures in the Galaxy of Fantabulous Wonderment" },
	{ "airbreak", "Airbreak" },
	{ "airwaveifoughtthelawandthelawone", "~airwave~ - I Fought the Law, And the Law One" },
	{ "alandlordsdream", "A Landlord's Dream" },
	{ "alansaveschristmas", "Alan saves Christmas (and most of the world too)" },
	{ "albatheexplorer", "Alba the Explorer: Princess Marian part V" },
	{ "alienattack", "Alien Attack" },
	{ "aliencarniage", "Alien Carniage" },
	{ "aliencowrampage", "Alien Cow Rampage: Orion Needs Your Milk!" },
	{ "alienescapade", "Alien Escapade" },
	{ "alienpuzzleinvasion", "Alien Puzzle Invasion" },
	{ "alienrapeescape", "Alien Rape Escape" },
	{ "alienthreat", "Alien Threat" },
	{ "alientimezone", "Alien Time Zone" },
	{ "allgonesoon", "All Gone Soon" },
	{ "allgonesoon2", "All Gone Soon 2" },
	{ "allhallowseve", "All Hallow's Eve" },	
	{ "allpigs", "All Pigs Deserve To Burn In Hell" },
	{ "allthewaydown", "All The Way Down" },
	{ "aloneinthenight", "Alone in the Night" },
	{ "alphabeta", "Alphabeta: A Room Full of Words" },
	{ "alphablock", "AlphaBlock" },
	{ "alphadog", "Alpha Dog" },
	{ "alphax", "Alpha X" },
	{ "alphaxsmash", "Alpha X - Project: Smash" },
	{ "alquest1", "Al-Quest 1" },
	{ "alysvsthephantomfelinefoe", "Alys vs. The Phantom Feline Foe" },
	{ "amagicstone", "A magic stone" },
	{ "amotospuf", "Amoto's Puf" },
	{ "amongthorns", "Among Thorns" },
	{ "amtag", "AMTAG: another medieval themed adventure game" },
	{ "amused", "A-Mused" },
	{ "analienswork", "An Alien's Work Is Never Done..." },
	{ "ancientaliens", "Ancient Aliens - The Roots of Sound" },
	{ "anentertainingspeech", "An Entertaining Speech" },
	{ "aneternityreflecting", "An Eternity, Reflecting" },
	{ "anightinberry", "A night in Berry (Une nuit en Berry)" },
	{ "anightmareonduckburg", "A Nightmare on Duckburg" },
	{ "anightthatwouldntend", "A Night That Wouldn't End" },
	{ "anighttoremember", "A Night to Remember" },
	{ "animalcruelty", "Animal Cruelty" },
	{ "anna", "anna" },
	{ "annaquest", "Anna's Quest Vol. 1: Winfriede's Tower" },
	{ "annieandroidautomatedaffection", "Annie Android: Automated Affection" },
	{ "anoblegame", "A Noble Game" },
	{ "anotherhero", "Another Hero" },
	{ "anotherwayout", "Another Way Out" },
	{ "anthonysessay", "Anthony's Essay" },
	{ "anticipatingmurder", "Anticipating Murder" },
	{ "antiheroes", "Anti-Heroes" },
	{ "anxiousawakening", "An Anxious Awakening" },
	{ "apiratestale", "A pirates tale" },
	{ "aplaceinthesun", "A Place In The Sun" },
	{ "aplacewithoutfrontier", "A Place Without Frontier" },
	{ "apocalypsemeow1", "Apocalypse Meow Chapter 1 - Gatitos: The Paws of Fate" },
	{ "apocalypsevel", "Apocalypse: Vel" },
	{ "applefarm", "Apple Farm" },
	{ "appointmentwithdeath", "Appointment With Death" },
	{ "apprentice", "Apprentice" },
	{ "apprentice2", "Apprentice II" },
	{ "aprofoundjourney", "A Profound Journey" },
	{ "apunkwithwheels", "A punk with wheels" },
	{ "aractaur", "Aractaur" },
	{ "araindogstory", "A Raindog Story" },
	{ "archeos", "Archeos" },
	{ "ardensvale", "Arden's Vale" },
	{ "ardentfever", "Ardent Fever" },
	{ "arewethereyet", "Are we there yet?" },
	{ "arjunaz78", "Arjunaz78 @ AGS" },
	{ "aroomwithoutyou", "A Room Without You In It" },
	{ "armageddonmargaret", "Armageddon Margaret" },
	{ "asecondface", "A Second Face: The Eye of Geltz is Watching You" },
	{ "ashinaredwitch", "Ashina: The Red Witch" },
	{ "ashpines", "Ash Pines" },
	{ "ashortnightmare", "A Short Nightmare" },
	{ "asimplefix", "A Simple Fix" },
	{ "asporia", "Asporia: Hidden Threat" },
	{ "asterix", "Asterix and the Roman Underground" },
	{ "astranded", "Astranded (Astro-Stranded)" },
	{ "astron", "Astron" },
	{ "asuspiciousdate", "A Suspicious Date" },
	{ "aswinsdream", "Aswin's Dream" },
	{ "ataintedtreat", "A Tainted Treat" },
	{ "ataleinthezoo", "A Tale in the Zoo" },
	{ "ataleofbetrayal", "A Tale Of Betrayal" },
	{ "atapi", "Atapi" },
	{ "athingaboutnothingness", "A thing about nothingness" },
	{ "atotkjukebox", "ATOTK jukebox" },
	{ "atreatandsometricks", "A Treat and Some Tricks" },
	{ "atthecafe", "At the Café" },
	{ "audioquest", "Audio Quest" },
	{ "aunaturel", "Au Naturel" },
	{ "automation", "Automation" },
	{ "averyspecialdog", "A very special dog" },
	{ "awakener", "Awakener" },
	{ "awakening", "Awakening - Part 1: Escape" },
	{ "awakeningofthesphinx", "Awakening of the Sphinx" },
	{ "awalkindatomb", "A walk in da tomb" },
	{ "awalkinthepark", "A Walk in the Park" },
	{ "awayinatower", "Away in a Tower" },
	{ "awesmoequest", "Awesmoe Quest" },
	{ "awomanforallseasons", "A Woman for All Seasons" },
	{ "axmasevetale", "A Xmas Eve Tale" },
	{ "bachelorstory", "Bachelor Story" },
	{ "backdoorman", "Back Door Man" },
	{ "backlot", "Backlot: Adventure Antics" },
	{ "badbunker", "Bad Bunker" },
	{ "badluck", "Bad Luck" },
	{ "bakeoffitalia", "Bake Off Italia - The Graphic Adventure" },
	{ "baldysadventure", "Baldy's Adventure" },
	{ "balloonface", "Balloon Face" },
	{ "baltazarthefamiliar", "Baltazar the Familiar" },
	{ "bananaman", "Banana Man" },
	{ "bananaracer", "Banana Racer" },
	{ "barahir", "Barahir's Adventure: Askar's Castle" },
	{ "barelyfloating", "Barely Floating" },
	{ "barhoppers", "BarHoppers" },
	{ "barndilemma", "Barn Dilemma" },
	{ "barnrunner1p1", "Barn Runner 1: The Armageddon Eclair (Part 1)" },
	{ "barnrunner1p2", "Barn Runner 1: The Armageddon Eclair (Part 2)" },
	{ "barnrunner3", "Barn Runner 3: Don't Jerk The Trigger of Love" },
	{ "barnrunner4", "Barn Runner 4: The Prick Who Came In From the Cold" },
	{ "barnrunner5p1", "Barn Runner 5: The Forever Friday (Part 1)" },
	{ "barnrunner5p2", "Barn Runner 5: The Forever Friday (Part 2)" },
	{ "barnrunner5p3", "Barn Runner 5: The Forever Friday (Part 3)" },
	{ "barnrunnerbake1", "Barn Runner Bake Sale 1: The Rich Dame Who Cut The Cheese" },
	{ "barnrunnerhall1", "Barn Runner Halloween 1: Fully Automatic Mojo" },
	{ "barnrunnervalentine1", "Barn Runner Valentine 1: Pucker Factor" },
	{ "barnrunnervn1", "Barn Runner Visual Novel 1: The Mayor's New Dress" },
	{ "barnrunnerxmas0", "Barn Runner Xmas 0: Christmas Soup" },
	{ "barnrunnerxmas2", "Barn Runner Xmas 2: Wreck The Halls" },
	{ "barrier", "Barrier" },
	{ "barrunner", "Ed Watts: Bar Runner" },
	{ "bartolomeo", "Bartolomeo, misled by circumstances, learns that appearances can be deceptive" },
	{ "bartsquestfortv", "Bart's Quest For TV" },
	{ "battlewarriorsrt", "Battle Warriors: Rovendale Tactics" },
	{ "bbcscreensaver", "Background Blitz Collection Screensaver" },
	{ "bcremake", "Black Cauldron Remake" },
	{ "beacon", "Beacon" },
	{ "bear", "Bear Story" },
	{ "bearinvenice", "Bear in Venice" },
	{ "beasts", "Beasts" },
	{ "beautiesandbeasts", "Beauties and Beasts" },
	{ "beforethedarkcrystal2", "Before the Dark Crystal II" },
	{ "beforeww2", "Before WW2" },
	{ "bellyofthebeast", "Belly of the Beast" },
	{ "belowzero", "Below Zero" },
	{ "belusebiusarrival", "Belusebius Arrival" },
	{ "benchandlerpi", "Ben Chandler: Paranormal Investigator!" },
	{ "bentheredanthat", "Ben There, Dan That!" },
	{ "beprepared", "Be Prepared (Bodi Pripravljen)" },
	{ "berthabuttsboogie", "Bertha Butt's Boogie" },
	{ "besieged", "BESIEGED, Or: How to Get Out of A Castle... Without Being Catapulted" },
	{ "bestowersofeternity", "Bestowers of Eternity - Part One" },
	{ "betrayal", "Betrayal" },
	{ "betweenpillars", "Between the Pillars of Creation" },
	{ "beyondeternity1", "Beyond Eternity - episode 1: The West College Disappearances" },
	{ "beyondhorizon", "Beyond Horizon" },
	{ "beyondreality", "Beyond Reality" },
	{ "beyondterror", "Beyond Terror" },
	{ "beyondthedoor", "Beyond the door" },
	{ "beyondthehorizon", "Beyond the horizon" },
	{ "bicschristmastale", "Bic's Christmas Tale" },
	{ "bigbadwolf3lilpiggies", "Big Bad Wolf & 3 Lil' Piggies" },
	{ "bigblue", "Big Blue World Domination" },
	{ "bigfoot", "Bigfoot" },
	{ "bigglesonmars", "Biggles On Mars" },
	{ "bigtroubleinlittleimola", "Big Trouble in Little Imola"},
	{ "billybstar", "Billy B. Star and the Lapaset Travel Quest" },
	{ "billyboysimportantwinelottery", "Billy Boy's Important Wine Lottery" },
	{ "billygoatsgruff", "Billy Goats Gruff" },
	{ "billymasterswasright", "Billy Masters Was Right" },
	{ "bioluminescence", "Bioluminescence" },
	{ "bird", "bird" },
	{ "birdy", "Birdy" },
	{ "birdybirdy", "Birdy Birdy" },
	{ "bitstream", "Bitstream" },
	{ "bittersweet", "Bittersweet" },
	{ "biwa", "Biwa of Blood" },
	{ "bizarreearthquake", "Bizarre Earthquake" },
	{ "bjcase1", "Ben Jordan P.I. Case 1: In Search of the Skunk-Ape" },
	{ "bjcase2", "Ben Jordan P.I. Case 2: The Lost Galleon of the Salton Sea" },
	{ "bjcase3", "Ben Jordan P.I. Case 3: The Sorceress of Smailholm" },
	{ "bjcase4", "Ben Jordan P.I. Case 4: Horror at Number 50" },
	{ "bjcase5", "Ben Jordan P.I. Case 5: Land of the Rising Dead" },
	{ "bjcase6", "Ben Jordan P.I. Case 6: Scourge of the Sea People" },
	{ "bjcase7", "Ben Jordan P.I. Case 7: The Cardinal Sins" },
	{ "bjcase8", "Ben Jordan P.I. Case 8: Relics of the Past" },
	{ "bjpww1", "Ben Jordan P.W.W. Case 1: Wrath of the Skunk Ape" },
	{ "blackfriday", "Black Friday" },
	{ "blackmailinbrooklyn", "Blackmail In Brooklyn" },
	{ "blackmorph", "Black Morph" },
	{ "blacksect1", "Black Sect Remake" },
	{ "blacksect2", "Black Sect 2: The Cursed Crypt" },
	{ "blackudder", "Blackudder: To Doubloon or not to Doubloon" },
	{ "bladespassion", "Blades of Passion: An Oceanspirit Dennis Adventure" },
	{ "blindsweeper", "BlindSweeper" },
	{ "blindtosiberia", "Blind to Siberia" },
	{ "blockz", "Blockz - A Slider Puzzle Game" },
	{ "bloodedfields", "Blooded Fields" },
	{ "bluelobe", "Blue Lobe Inc." },
	{ "bluemoon", "Blue Moon" },
	{ "boardquest", "Board Quest" },
	{ "bob", "Bob" },
	{ "bobescapes", "Bob Escapes (Bob En Cavale)" },
	{ "bobgoeshome", "Bob Goes Home" },
	{ "bobgoeshomedeluxe", "Bob Goes Home Deluxe" },
	{ "bobsquest1", "Bob's Quest" },
	{ "bogsadventure", "Bog's Adventures in the Underworld" },
	{ "bogsadventureineasy3d", "Bog's Adventure in Easy3D" },
	{ "bohemianyard", "Bohemian Yard" },
	{ "boilerroom", "Boiler Room Blues" },
	{ "boltaction", "Bolt Action" },
	{ "bone", "Bone" },
	{ "boogiebum", "Boogie Bum's Roger Quest" },
	{ "bookofdestiny", "Book of Destiny" },
	{ "bovinebyproduct", "Bovine By-Product" },
	{ "bowanddork", "Bow and Dork" },
	{ "bowserquirkquest", "Bowser Quirk Quest" },
	{ "box", "Box" },
	{ "boxfight", "Boxfight for AGS" },
	{ "boyindahood", "Boy in da hood: Give me the money!" },
	{ "bradbradsonkeyquest", "Brad Bradson: Key Quest" },
	{ "breakage", "Breakage" },
	{ "breakdown", "Breakdown" },
	{ "breakingcharacter", "Breaking Character" },
	{ "breakfastont1", "Breakfast on Trappist-1" },
	{ "brokenwindows1", "Broken Windows - Chapter 1" },
	{ "brokenwindows2", "Broken Windows - Chapter 2" },
	{ "brokenwindows3", "Broken Windows - Chapter 3" },
	{ "brotherswreckers", "Brothers & Wreckers" },
	{ "brucequest", "Bruce Quest: The Secrets of the Outback" },
	{ "bruises", "Bruises" },
	{ "bsg78", "BSG78 - Unexpected at the Rising Star" },
	{ "bubblewrap", "Bubble Wrap Popping Simulator 2013" },
	{ "bubsybobcat", "Bubsy The Bobcat In Rip Van Bubsy Starring Bubsy" },
	{ "buccaneer", "Buccaneer" },
	{ "bullettrain", "Bullet Train" },
	{ "bunawantsbeer", "Buna Wants Beer" },
	{ "bunnyquest", "Bunny Quest" },
	{ "burymeinthesand", "Bury Me in the Sand" },
	{ "bustinthebastille", "Bustin' the Bastille" },
	{ "butcherstanys", "Butcher Stanys" },
	{ "butcherstanys2", "Butcher Stanys II: Stanys Meets Marilyn Manson" },
	{ "byohero", "BYO-Hero" },
	{ "bythenumbers", "By the Numbers" },
	{ "bytheswordconspiracy", "By the Sword: Conspiracy" },
	{ "byzantine", "Byzantine" },
	{ "cabbagequest", "Cabbage Quest" },
	{ "cabbagesandkings", "Cabbages and Kings" },
	{ "cachoquest", "Cacho Quest" },
	{ "calebsdrunkenadventure", "Caleb's Drunken Adventure" },
	{ "calequest", "Cale Quest" },
	{ "callmegeorge1", "Call Me George, Chapter 1: Prophecy" },
	{ "calsoon2", "Calsoon 2" },
	{ "camp1", "Camp 1" },
	{ "capricorn", "Tropic of Capricorn" },
	{ "captaincringe", "Chronicles of Captain Cringe" },
	{ "captaindisastermoon", "Captain Disaster In: The Dark Side of the Moon" },
	{ "captaindownes", "Captain Downes and the Pirate Princess" },
	{ "carrotbobinzxspeccyworld", "Carrot Bob in ZX speccy world" },
	{ "cartlife", "Cart Life" },
	{ "casablancathedayafter", "Casablanca, The Day After" },
	{ "casenoir", "Case Noir" },
	{ "caseofthemuffindiver", "The case of The Muffin Diver" },
	{ "cassandra", "Cassandra" },
	{ "castleoffire", "Castle of Fire" },
	{ "catacombic", "Catacombic" },
	{ "catapault", "CATapault" },
	{ "cauche", "Cauchemarionto" },
	{ "caverns", "Caverns" },
	{ "caveofavarice", "Cave of Avarice" },
	{ "cayannepepper", "Cayanne Pepper" },
	{ "cedricandtherevolution", "Cedric and the Revolution" },
	{ "cedricshooter", "Cedric Shooter" },
	{ "celestialcatastrophe", "Danny Sexbang in Celestial Catastrophe" },
	{ "celticchaosep1", "Celtic Chaos Episode 1: Cold mead" },
	{ "celticchaosep2", "Celtic Chaos Episode 2: Fishermen's fiends" },
	{ "cgascreensaver", "CGA Games Screensaver" },
	{ "chalkman", "Chalkman" },
	{ "chalksquest", "Chalk's Quest" },
	{ "chanceofthedead", "Chance Of The Dead" },
	{ "charamba1", "Charamba, Chapter 1: Bitches in the Desert" },
	{ "charamba2", "Charamba, Chapter 2: Hallowe'en" },
	{ "charliefoxtrot", "Charlie Foxtrot" },
	{ "chasingrobot", "Chasing Robot" },
	{ "chatroom", "Chatroom" },
	{ "cheerfulscience", "Cheerful Science" },
	{ "chekken", "cheKKen" },
	{ "chemin", "Chemin" },
	{ "cherrysquest", "Cherry's Quest For Coffee" },
	{ "chessboard", "ChessBoard" },
	{ "chezapa", "Chez Apa" },
	{ "chickchaser", "Chick Chaser" },
	{ "chickenfraction", "Chicken Fraction" },
	{ "chickenvsroad", "Chicken vs. Road" },
	{ "chinesecheckers", "Chinese Checkers" },
	{ "chongoadv", "Chongo's China Adventure" },
	{ "chriscolumbus1", "Christopher Columbus is an Idiot - Act 1" },
	{ "christmas42", "Christmas42" },
	{ "christmasgamearcade", "CGA: Christmas Game Arcade" },
	{ "christmashunt", "Christmas Hunt" },
	{ "christmaspresent", "Christmas Present" },
	{ "christmasquest", "Christmas Quest" },
	{ "christmasquest2", "Christmas Quest 2: The Yuletide Flows In" },
	{ "christmasquest3", "Christmas Quest 3: Santa's Little Help Desk" },
	{ "cirquedezale", "Cirque de Zale" },
	{ "city", "City" },
	{ "cityofthieves", "City of Thieves: Rescue Sandy" },
	{ "claire", "Claire" },
	{ "clarinette", "Clarinette" },
	{ "classnotes", "Class Notes" },
	{ "clipgoestotown", "Clip goes to town" },
	{ "clotildesoffritti", "Clotilde Soffritti in Never Buy a Used Spaceship" },
	{ "clownatthecircus", "Clown at the Circus" },
	{ "clubmidget", "Club Midget" },
	{ "clubofevil", "Club of Evil" },
	{ "coderbattle", "CODERBATTLE - quest for the whole game -" },
	{ "coelldeckaflight", "Coell Decka Flight" },
	{ "coinopafternoon", "Coin-Operated Afternoon" },
	{ "coinrush2", "Coin Rush 2" },
	{ "colaskunk", "Cola Skunkette: A Bit of Cleanup" },
	{ "coldhandreef", "The Cold Hand Reef" },
	{ "coldmeat", "Cold Meat" },
	{ "coldstorage", "Cold Storage" },
	{ "colinsimpson", "Colin Simpson Leaves Employment" },
	{ "colourclash", "Colour Clash" },
	{ "colourwise", "ColourWise" },
	{ "colourwiseleveleditor", "ColourWise - Level Editor" },
	{ "columbuslander", "Columbus Lander" },
	{ "comedyquest", "Comedy Quest" },
	{ "comradecitizenpart1", "Comrade Citizen (part 1)" },
	{ "concurrence", "Concurrence" },
	{ "confessionsofacatburglar", "Confessions Of A Cat Burglar" },
	{ "coniferskunks", "Conifer Skunks: Osvald's Surprise" },
	{ "conspiracybelowzero", "Conspiracy: Below-Zero" },
	{ "conspiracyofsongo", "Conspiracy of Songo" },
	{ "constancethebarbarian", "Constance the Barbarian" },
	{ "contact", "Contact" },
	{ "content", "Content" },
	{ "contrapasso", "Commissar's Contrapasso" },
	{ "cop", "Cop" },
	{ "corneliuschristmas", "Cornelius Cat in: How the Cat Saved Christmas" },
	{ "corneliuspest", "Cornelius Cat in: The Uncontrollable Pest" },
	{ "cornersshiny", "Corner's Shiny (2013 edition)"},
	{ "cosmodyssey", "Cosmodyssey: Jammy Edition" },
	{ "cosmospuzzle", "Cosmos Puzzle" },
	{ "cosmosquest1", "Cosmos Quest I" },
	{ "cosmosquest2", "Cosmos Quest II" },
	{ "cosmosquest3", "Cosmos Quest III" },
	{ "cougarsquestforfreedom", "Cougar's Quest for Freedom" },
	{ "counterfeit", "Counterfeit" },
	{ "coupdecup", "Coup de Cup" },
	{ "coyote1", "Coyote Episode I: The Mexican" },
	{ "crackwell1", "The Crackwell Legacy" },
	{ "crackwell2", "Crackwell Unhinged" },
	{ "craftofevil", "Craft Of Evil" },
	{ "crankosaurus", "Crankosaurus Prime and the Blue Crystal Pursuit" },
	{ "crankosaurusff", "Crankosaurus Prime and the Blue Crystal Pursuit: The Fangs of Fortune" },
	{ "crashcourse", "Crash Course" },
	{ "crashevadedestroy", "Crash! Evade! Destroy!" },
	{ "crave", "Crave" },
	{ "crepefields", "Crepe Fields: A Scare Among Crows" },
	{ "crimezone", "Crime Zone" },
	{ "criminalist", "Criminalist" },
	{ "crimmsson", "Crimm's Son" },
	{ "crossstitch", "Cross Stitch Casper" },
	{ "crowandfoxy", "Crow and Foxy (Le Corbeau et la Renarde)" },
	{ "cryo", "Cryo" },
	{ "crypt", "Crypt" },
	{ "cryptic", "Cryptic" },
	{ "crystalquest", "Crystal Quest" },
	{ "csihunt1", "CSI Hunt 1" },
	{ "cspb", "Cake & Smurphy Puzzle Battle!" },
	{ "cyberjack", "cyberJACK" },
	{ "cyberpunk97ep1", "Cyberpunk '97 - Episode 1" },
	{ "daceyinthedark", "Dacey in the Dark: Prelude" },
	{ "dada", "Dada: Stagnation in Blue" },
	{ "dadaxmas", "Dada Christmas Special: Stagnation in Red and White" },
	{ "daggerhell", "DAGGERHELL" },
	{ "dakota", "Dakota" },
	{ "daleks", "Daleks" },
	{ "dalesfilmquest", "Dale's Film Quest" },
	{ "damsel", "Damsel - Chapter 1: Stress on the Tress" },
	{ "dancetilyoudrop", "Dance Til' You Drop!" },
	{ "danewguys", "Da New Guys" },
	{ "dangermouse", "Danger Mouse" },
	{ "dangerousderek", "Dangerous Derek's Livestream" },
	{ "dangerouslandsrt2", "Dangerous Lands: Rovendale Tactics 2" },
	{ "dannydreadisoncall", "Danny Dread is On Call" },
	{ "dantesday", "Dante's Day" },
	{ "darkblack", "Dark Black" },
	{ "darkcave", "The Dark Cave: Adventure of Princess Marian IV" },
	{ "darkforce", "DarkForce: Peace Among Nations" },
	{ "darkofnight", "Dark of Night" },
	{ "darktimesmerrychristmas", "Dark Times (Merry Christmas)" },
	{ "darum", "Darum" },
	{ "davegeneric", "Dave Generic" },
	{ "davidletterman", "David Letterman - the Video Game" },
	{ "davyjonesspellbook", "Davy Jones' Spellbook" },
	{ "dawnswonderedatagesend", "Dawns Wondered: At Age's End" },
	{ "dayofthefish", "Day of the Fish" },
	{ "ddddd", "DDDDD" },
	{ "ddr", "Dennis Dennis Revolution" },
	{ "deaddimension", "Dead Dimension" },
	{ "deadgods", "Dead Gods: Haizara 2" },
	{ "deadhand", "Dead Hand" },
	{ "deadinspace", "Dead in Space" },
	{ "deadlyconsequences", "Deadly Consequences!" },
	{ "deadmanpoliticalparty", "Dead Man's Political Party" },
	{ "deadofwinter", "Dead of Winter" },
	{ "deadpixels", "Dead Pixels" },
	{ "deadroom", "Dead Room" },
	{ "deadsilence", "Dead Silence" },
	{ "deadstar", "Dead Star" },
	{ "deathandtransfiguration", "Death and Transfiguration" },
	{ "deathasitis", "Death as it Is" },
	{ "deathep1", "Death - Episode One" },
	{ "deathofanangel", "Death of an Angel" },
	{ "deathofdavyjonesscenario", "Yet Another Death of Davy Jones Scenario" },
	{ "deathonstage", "Death on Stage" },
	{ "deathsdoor", "Death's Door" },
	{ "deathsquest", "Deat(h)'s Quest" },
	{ "deathworeendlessfeathersdisk1", "Death Wore Endless Feathers Disk 1" },
	{ "deephope", "Deep Hope" },
	{ "deepspacemission", "Deep Space Mission: Are we alone?" },
	{ "deflus", "Deflus" },
	{ "dehaunt", "Dehaunt" },
	{ "deity", "Deity" },
	{ "delerium", "Delerium" },
	{ "demogame", "JWB Games Demo Game" },
	{ "demonday", "Demon Day" },
	{ "demonslayer5", "Demon Slayer 5" },
	{ "derrekquest", "Derrek Quest I: Lost in the desert" },
	{ "derverschwundenehusky", "Der verschwundene Husky" },
	{ "desmond", "Desmond: The 'Thing' from another world!" },
	{ "desolate", "Desolate" },
	{ "detectivebhmini", "Detective Boiled Hard Mini Case" },
	{ "detectiveobriced", "Detective O.Briced" },
	{ "detectiverizal", "Detective Rizal and the Jaded Ruby" },
	{ "detention", "Detention!" },
	{ "devochkaquest", "Devochka Quest" },
	{ "dexter", "Dexter Morning Routine" },
	{ "dgsearchbatteries", "Another DG game: the search of the batteries" },
	{ "dicklarenzo", "Dick LaRenzo: Secret Agent!" },
	{ "diemaskennyarlathoteps", "Die Masken Nyarlathoteps" },
	{ "dimetrodon", "Day of the Dimetrodon" },
	{ "dinnerforpigeons", "Dinner for Pigeons" },
	{ "dirandiouskroken", "Dirandious Kroken" },
	{ "disappearancetime", "007 ¾: Disappearance Time" },
	{ "disgust", "Disgust" },
	{ "dislocation", "Dislocation" },
	{ "disquiet", "Disquiet" },
	{ "distancenoobject", "Distance no object" },
	{ "doctormaze", "The Amazing Doctor Maze" },
	{ "doctormuttonchop", "Doctor Muttonchop" },
	{ "doctorwho", "Doctor Who: Time Snare" },
	{ "dogescape", "Dog Escape" },
	{ "dollshouse", "dolls house" },
	{ "dollshouseinsanity", "dolls house: INSANITY" },
	{ "donalddowell", "Donald Dowell and the Ghost of Barker Manor" },
	{ "donkeybas", "Donkey.Bas AGS Remake" },
	{ "donnaavengerofblood", "Donna: Avenger of Blood" },
	{ "donniedarko", "Donnie Darko - The Adventure Game" },
	{ "donspillacyconspiracyquest", "Don Spillacy's Conspiracy Quest" },
	{ "dontdrinkthepink", "Don't Drink the Pink" },
	{ "donthedweebdancedilemma", "Don the Dweeb: Dance Dilemma" },
	{ "dontlook", "Don't Look!" },
	{ "dontpush", "Don't Push The Button" },
	{ "dontworrybaby", "Don't Worry Baby" },
	{ "dontworryillbringthebeer", "Don't Worry, I'll Bring The Beer!" },
	{ "doomgraphicadventure", "Doom: A Very Graphic Adventure" },
	{ "doors", "Doors" },
	{ "doses", "Doses" },
	{ "dovadulasburn", "DoVaDuLa'S BuRn" },
	{ "draconis", "Draconis" },
	{ "draculator2", "Draculator II: Byte of the Draculator" },
	{ "dragonorb", "Dragon Orb" },
	{ "dragonscale", "Dragonscale: The Encounter" },
	{ "dragonsfang", "Dragon's Fang" },
	{ "dragontales", "Dragon Tales" },
	{ "drchuckles", "Dr. Chuckles' Miniature World Of Madness" },
	{ "dreadmacfarlane", "Dread Mac Farlane" },
	{ "dreadmacfarlane2", "Dread Mac Farlane - Part 2" },
	{ "dreamagine", "Dreamagine" },
	{ "dreamer", "Little Dreamer" },
	{ "dreamsequence", "dream sequence" },
	{ "dreamsofwintermass", "Dreams of Winter Mass" },
	{ "dreamychristmas", "Create your own adventure game: Your dreamy Christmas" },
	{ "dressedforafight", "Dressed for a Fight Out" },
	{ "drevil", "Dr. Evil" },
	{ "drillkiller", "DRILL KILLER" },
	{ "drlutztimetravelmachine", "Dr.Lutz Time Travel Machine" },
	{ "drugsandalians", "drugs and alians" },
	{ "dumbassdrivers", "Dumbass Drivers!" },
	{ "dungeonhands", "Dungeon Hands" },
	{ "duskhunters", "Dusk Hunters" },
	{ "dusttowater", "Dust to Water" },
	{ "dutyandbeyond", "Duty and Beyond" },
	{ "dutyfirst", "Duty First" },
	{ "duzzquest", "DuzzQuest: An Egotistic Adventure" },
	{ "duzzquest2", "DuzzQuest2" },
	{ "dysmaton", "Dysmaton" },
	{ "earlbobby1", "Earl Bobby is looking for his Shoes" },
	{ "earlbobby2", "Earl Bobby is looking for his Balls" },
	{ "earlbobby3", "Earl Bobby is looking for a Loo" },
	{ "earlmansinthebreakout", "Earl Mansin: The Breakout" },
	{ "earthlingpriorities", "Earthling Priorities" },
	{ "earthstory", "Earth Story" },
	{ "easterencounter", "Easter Encounter" },
	{ "easterinron", "Easter in Reality-on-the-Norm" },
	{ "easterislanddefender", "Easter Island Defender" },
	{ "echidna", "Echidna Chwest" },
	{ "echoesofterra", "Echoes of Terra" },
	{ "echoesofthepast", "Echoes of the Past" },
	{ "echointheclouds", "Echo in the Clouds" },
	{ "edmund", "Edmund and the potato" },
	{ "educatingadventuresofgirlandrabbit", "Educating Adventures of Girl and Rabbit" },
	{ "eerieblue", "Eerie Blue" },
	{ "egoplanetapes", "Ego in Planet of the Apes" },
	{ "egress", "Egress - The Test of STS-417" },
	{ "eight", "8" },
	{ "einsteinmachine", "Einstein Machine" },
	{ "electrctgui", "electrctGUI" },
	{ "elevator", "The Elevator" },
	{ "elevatorriseabyss", "The Elevator - Rise from the Abyss!" },
	{ "elfer", "Elfer" },
	{ "elfmotorsinc", "Elf Motors Inc." },
	{ "elforescuecraby", "ELFO:Rescue Craby" },
	{ "elfthe4elements", "ELF: The 4 elements" },
	{ "elfthedarkness", "ELF: And soon the darkness..." },
	{ "eliminationbyimprovisation", "Elimination by Improvisation" },
	{ "elmowagon", "Elmo's Wagon Conflict" },
	{ "emeraldeyes", "Emerald Eyes" },
	{ "emilyenough", "Emily Enough: Imprisoned" },
	{ "emmaroide", "Emma Roide" },
	{ "emptymindblankfate", "Empty Mind - Blank Fate" },
	{ "encounters", "Encounters of the Closest Kind" },
	{ "endlessloop", "Endless Loop" },
	{ "enoworld", "Enoworld" },
	{ "enterthestory", "Enter The Story" },
	{ "entrapment", "Entrapment" },
	{ "entrapped", "Entrapped" },
	{ "equilibrium", "Equilibrium - Out of Time" },
	{ "erictheanteater", "Eric the Anteater" },
	{ "erkrealestate", "Erk: Adventures in Stone Age Real Estate" },
	{ "errand", "Errand" },
	{ "escape", "Escape" },
	{ "escapefromasmallroom", "Escape From a Small Room 1: The walls are closing in" },
	{ "escapefromevergreenforest", "Escape From Evergreen Forest" },
	{ "escapefromlurrilous", "Escape from Lurrilous" },
	{ "escapefromterrorbay", "Escape From Terror Bay" },
	{ "escapefromthechaoticcity", "Escape From The Chaotic City" },
	{ "escapefromthegarage", "ESCAPE from the garage" },
	{ "escapefromthesalemmoons", "Escape From The Salem Moons" },
	{ "escapefromthezombiecity", "Escape From The Zombie City" },
	{ "escapethebarn", "Escape the Barn" },
	{ "escapetheship", "Escape the ship" },
	{ "escapetocivilization", "Escape to Civilization" },
	{ "esper", "ESPER: The Town on the Edge of Darkness" },
	{ "essenceofimagination", "Essence of Imagination" },
	{ "essia", "Essia" },
	{ "etaac", "Electronic Tax Administration Advisory Committee" },
	{ "eternalchrysalis", "Eternal Chrysalis" },
	{ "eternallyus", "Eternally Us" },
	{ "eventtimer", "Event Timer" },
	{ "everlight", "Everlight Forest" },
	{ "evil", "Evil" },
	{ "evilenterprises", "Evil Enterprises" },
	{ "evildead4", "Evil Dead 4" },
	{ "evillodge", "Evillodge: The Criminal Adventure Game" },
	{ "exclamation", "!" },
	{ "exit", "EXIT" },
	{ "exmachina", "Ex Machina" },
	{ "explorationa", "Exploration A" },
	{ "exposedreality", "Exposed Reality" },
	{ "everythingm", "Everything that Begins with an M" },
	{ "fadingshades", "Fading Shades" },
	{ "fakethemoonlanding", "Fake the moon landing" },
	{ "fall", "Fall" },
	{ "fallenangel", "Fallen Angel" },
	{ "fallenhero", "Fallen Hero" },
	{ "fallensoldier", "Fallen soldier" },
	{ "fallingdark", "Falling Dark" },
	{ "fallingdark2", "Falling Dark 2: Relapse" },
	{ "familieherfurth", "Der neue Wahnsinn der Familie Herfurth" },
	{ "fanbots", "Fanbots" },
	{ "farcorners1", "The Far Corners of the World: Chapter 1 - The Book, the Box and the Key" },
	{ "farnowhere", "FAR NOWHERE" },
	{ "fashiongirl", "Fashion Girl" },
	{ "fasmo", "Fasmo!" },
	{ "fasmogoeswest", "Fasmo 2: Fasmo Goes West" },
	{ "fayeking", "Faye King: Jungle Jeopardy" },
	{ "fbiquest", "FBI Quest" },
	{ "fearaphobia", "Fearaphobia" },
	{ "featherweight", "Featherweight" },
	{ "femspray", "FemSpray" },
	{ "fengshuiandtheartoftvreception", "Feng Shui And The Art Of TV Reception" },
	{ "ferragosto", "Elia, Ilaria & the Kids Having a Good Time at the Sea (or at least they try)" },
	{ "feuersturm1", "Feuersturm - Kapitel 1: Zurück in die welt" },
	{ "feuersturm2", "Feuersturm - Kapitel 2: Der unheimliche Zug" },
	{ "feuersturm3", "Feuersturm - Kapitel 3: Wo Der Wald Beginnt..." },
	{ "fhaloness", "Fhaloness" },
	{ "fifa2004", "FIFA International Football 2004" },
	{ "fightforlife", "Fight for Life" },
	{ "fightgame", "Fight Game" },
	{ "finger", "Finger of suspicion" },
	{ "fireflystory3d", "Firefly story 3D" },
	{ "firstdrop", "1st Drop" },
	{ "firststitch", "The Tapestry - Prologue: The First Stitch" },
	{ "fistsofmurder", "Fists of Murder" },
	{ "fixumdude", "Fixumdude's 3D Printing Adventure" },
	{ "flamebarrel", "Flame Barrel" },
	{ "flashbax", "Flashbax" },
	{ "flightrobots", "Flight from the Robots" },
	{ "floatyrog", "Floaty Rog'" },
	{ "flophouse", "Flophouse Hijinks" },
	{ "flowergirl", "Flower Girl" },
	{ "fluxworld", "Flux World" },
	{ "flyingthinker", "Flying Thinker" },
	{ "flypaper", "Fly Paper" },
	{ "focality", "Focality" },
	{ "foggydawn", "Foggy Dawn" },
	{ "foggynotions", "Foggy Notions" },
	{ "foodwars", "Food Wars" },
	{ "foolaround", "Fool Around" },
	{ "forcemajeureiithezone", "Force majeure II: The Zone" },
	{ "forest", "Forest" },
	{ "forestdweller", "Forest Dweller 3D" },
	{ "forfrogssakegetthefrogout", "FOR FROGS SAKE! GET THE FROG OUT!" },
	{ "forge", "Forge" },
	{ "forgettendeath", "Forgetten Death" },
	{ "forms", "Forms" },
	{ "fortressofwonders", "Fortress of Wonders" },
	{ "foundations", "Foundations" },
	{ "fountainofunicorns", "Fountain of Unicorns" },
	{ "fountainofyouth", "Indiana Jones and the Fountain of Youth" },
	{ "framed", "Framed!" },
	{ "frankenpooper", "Frankenpooper" },
	{ "frankfurter1", "The Adventures of Stanley 'Frankfurter' Jones" },
	{ "frankfurter2ch1", "Frank Further: The Further Adventures of Stanley 'Frankfurter' Jones - Chapter I" },
	{ "frankstallone", "Frank Stallone: The Driver and Mob Enforcer" },
	{ "frankthefarmhandpart1", "Frank the Farmhand - Part 1: The Big Escape" },
	{ "frankthefarmhandpart2", "Frank the Farmhand - Part 2: The Secret of Guija" },
	{ "franticfranko", "Frantic Franko: A Bergzwerg Gone Berserk" },
	{ "frasiercraneseattlerampage", "Frasier Crane: Seattle Rampage" },
	{ "freakchic", "Freak Chic" },
	{ "fredandbarneymeetthefuture", "Fred and Barney meet the future" },
	{ "fribbeldib", "Fribbeldib" },
	{ "fridgefollies", "Fridge Follies" },
	{ "frightfest", "FrightFest: Dracula vs. Frankenstein vs. The Mummy" },
	{ "fritz", "Fritz" },
	{ "frogisland", "Frog Island" },
	{ "frozenkingdom", "Frozen Kingdom" },
	{ "fsis1000000quest", "FSi's $1000000 Quest!" },
	{ "fsisachequest", "FSi's Ache Quest" },
	{ "fsisalienation", "FSi's Alienation!" },
	{ "fsiscotmattcehotsvd", "FSi's CotMATtCEHotSVD" },
	{ "fsismhcfhr", "FSi's MHCFHR!" },
	{ "fsispowercowfromuranus", "FSi's PowerCow From Uranus!" },
	{ "fulkramick", "Fulkramick's Dreamting: An Interactive Adventure" },
	{ "furballs1", "Fur Balls 1 - evil be thy name: Bundles of mayhem!" },
	{ "funsunmishaps", "Fun, Sun & Mishaps" },
	{ "funwithnumbers", "Fun With Numbers" },
	{ "futuramatrivia", "Futurama: Who Said That?" },
	{ "futurecity3000", "Future City 3000" },
	{ "gabyking", "The Young Gabriel King Chronicles" },
	{ "galaxyquest", "Galaxy Quest: The Arkainian Artifact - Part I" },
	{ "gamequest", "Game Quest" },
	{ "gamesgalore", "Games Galore!" },
	{ "gassesuittollis3", "Gasse Suit Tollis 3: Looking for Love" },
	{ "gatewayremake", "Gateway Remake" },
	{ "gaygreg", "Gay Greg is Grounded" },
	{ "gemcollector", "Gem Collector" },
	{ "genbu", "Genbu's Favour" },
	{ "geometricshapes1circleboy", "Geometric Shapes 1: Circleboy" },
	{ "gesundheit", "Gesundheit!" },
	{ "getawayfrompluto", "Get away from PLUTO" },
	{ "getfood", "Get food" },
	{ "getsquirty", "Get Squirty!" },
	{ "ghostcatchers", "GhostCatchers" },
	{ "ghostvoyage", "Ghost Voyage" },
	{ "gladiatorquest", "Gladiator Quest" },
	{ "glitchquest", "Glitch Quest" },
	{ "gnomeshomebrewingadventure", "Gnome's Homebrewing Adventure" },
	{ "gnrblex", "GNRBLEX" },
	{ "goatherd", "Goat Herd and the Gods" },
	{ "goldreddragon", "Gold of the Red Dragon" },
	{ "goneboatfishin", "Gone Boat Fishin'" },
	{ "gonefishin", "Gone fishin'" },
	{ "gonemyangel", "Gone, My Angel, Gone" },
	{ "gonorth", "Go North" },
	{ "gonorth2", "Go North 2" },
	{ "goodgod", "Good God!" },
	{ "goodman", "Good Man" },
	{ "goodmorningmrgingerbread", "Good Morning, Mr. Gingerbread!" },
	{ "goodsantabadsanta", "Good Santa, Bad Santa" },
	{ "goontang", "Goontang Chackalaka" },
	{ "gotalight", "Got a Light?" },
	{ "gpslostadventure", "G.P.'s Lost Adventure" },
	{ "grandkitchenescape", "Grand Kitchen Escape" },
	{ "graveyard", "Graveyard" },
	{ "gravitytestgame", "Gravity's Test Game" },
	{ "gray", "Gray" },
	{ "greenback", "Greenback - Prologue" },
	{ "gremlin", "Gremlin" },
	{ "grizzlygooseofgosse", "Grizzly Goose of Gosse" },
	{ "groundhog", "Groundhog" },
	{ "grr", "Grr! Bearly Sane" },
	{ "guardiansofgold", "Guardians of Gold" },
	{ "guyhookcrook", "Guy: by hook or by crook" },
	{ "guyredplanet", "Guy who landed on weird red planet" },
	{ "guyslug", "Guy Slug: Private Eye" },
	{ "guyver1d", "Guyver 1D" },
	{ "guyverquest1", "Guyver Quest I: Sho Adventure" },
	{ "guyverquest2", "Guyver Quest II: Cronos" },
	{ "gville1", "G-ville 1" },
	{ "gwendarkly", "Gwen Darkly: A Speechless Case" },
	{ "hack", "Hack" },
	{ "halloween", "Halloween" },
	{ "halloweenguest", "Halloween with an unexpected Guest" },
	{ "halloweenhorror", "Halloween Horror" },
	{ "hallwayofadventures", "Hallway of Adventures" },
	{ "hangon", "Hang On" },
	{ "happyduckieadventure", "Happy Duckie Adventure" },
	{ "happyface", "^_^" },
	{ "hardspace", "Hard Space: Conquest of the Gayliks!" },
	{ "harrycaine", "Harry Caine UNRATED" },
	{ "harrypotterrpg", "Harry Potter RPG" },
	{ "harrys21stbirthday", "Harry's 21st Birthday" },
	{ "harryshopshock", "Harry and the Locked Crocs Shop Shock" },
	{ "hauntedcastle", "Haunted Castle" },
	{ "haven1", "Haven - Episode 1" },
	{ "hawkeye", "Hawk Eye Quandaries" },
	{ "headbangerheaven", "Headbanger's Heaven - A Rock & Roll Adventure" },
	{ "headoverheels", "Head over Heels" },
	{ "heartofabraxas", "Heart of Abraxas" },
	{ "heartland", "Heartland" },
	{ "heatwave", "Heatwave" },
	{ "heavenhell", "Heaven, Hell and the Neitherworld" },
	{ "heavymetalnannulf", "Heavy Metal Nannulf: The Strange Stage" },
	{ "hecamethroughthedoor", "He Came Through the Door" },
	{ "heed", "Heed" },
	{ "helloneighbor", "Hello Neighbor!" },
	{ "hellotaxi", "Hello! Taxi!" },
	{ "hellspuppy", "Hell's Puppy" },
	{ "helpthegame", "HELP! the game" },
	{ "hendrixisland", "HENdRIX' Island" },
	{ "henkstroemlostincellar", "Henk Stroem in: Lost In Cellar" },
	{ "henman", "Hen Man: Origins" },
	{ "henrysmith", "Henry Smith and the Looters of Peru" },
	{ "herby", "Herby" },
	{ "herenosirens", "Here Be NO Sirens" },
	{ "heroeswyrdale", "Heroes of Wyrdale" },
	{ "heroinesquest", "Heroine's Quest: The Herald of Ragnarok" },
	{ "hesgonehistorical", "He's Gone Historical" },
	{ "hewatches", "He Watches" },
	{ "hhgtgtowelday", "H2G2: Towel Day" },
	{ "hiddenplains", "Hidden Plains" },
	{ "hiddentreasureryansfortune", "Hidden Treasure: Ryan's Fortune" },
	{ "hide", "Hide" },
	{ "hiliaderoleagainsthell", "Hilia Derole against Hell" },
	{ "him", "Him" },
	{ "hitchhikersguidetothegalaxyremake", "The Hitchhiker's Guide to the Galaxy Remake" },
	{ "hitthefreak", "Hit the Freak" },
	{ "hiyah", "HiYah!" },
	{ "hjarta", "Hjarta" },
	{ "hlobb", "The Historical League of Bouncy Boxing" },
	{ "hoik", "Hero of Infamous Kingdoms" },
	{ "homesweetron", "Home Sweet Reality-on-the-Norm" },
	{ "honksadventure", "Honk's Adventure" },
	{ "hood", "Hood" },
	{ "hope", "Hope" },
	{ "horseparkdeluxe", "Horse Park DeLuxe" },
	{ "horseparkfantasy", "Horse Park Fantasy" },
	{ "hotel", "Hotel" },
	{ "hotelhansen", "Hotel Hansen" },
	{ "hotelhijinks", "Hotel Hijinks" },
	{ "housedesade", "House of de Sade" },
	{ "houseofhorror", "House of Horror" },
	{ "housequest2", "House Quest 2" },
	{ "howmany", "How many..." },
	{ "howtheyfoundsilence", "How They Found Silence" },
	{ "hubris", "Hubris - A Popular Pub Pastime" },
	{ "hungry", "Hungry" },
	{ "hungryworm", "Hungry Worm" },
	{ "huongjiaoping", "Huong Jiao Ping" },
	{ "huxzadventure", "Huxz Adventure" },
	{ "hybrid", "Hybrid" },
	{ "hydeandseek", "Hyde and Seek" },
	{ "hydrate", "HYDRATE" },
	{ "hypnotoad", "Hypnotoad" },
	{ "iamjason", "IAMJASON" },
	{ "icantsleep", "I Can't Sleep in Silence - It's Always Darkest" },
	{ "iceintheair", "Ice in the Air" },
	{ "icestationzero", "Ice Station Zero" },
	{ "id", "iD" },
	{ "iforgot", "I Forgot..." },
	{ "iggrok", "Instagame: Grok" },
	{ "igspaceadventurer", "Instagame: Space Adventurer" },
	{ "igstrangeplanet", "Instagame: The Strange Planet" },
	{ "iiispy", "III-Spy" },
	{ "iisstabbings", "From Hell's Hart, I is Stabbings: An Oceanspirit Dennis Tale" },
	{ "illuminationdiminishing", "Illumination Diminishing" },
	{ "illusion", "Illusion" },
	{ "imfree", "I'm free (Soy libre)" },
	{ "imnotcrazyrightthecell", "I'm not crazy, right? - The Cell" },
	{ "imnotcrazyrightthewell", "I'm not crazy, right? - The Well" },
	{ "imonlysleeping", "I'm Only Sleeping" },
	{ "imstillhere", "I'm still Here" },
	{ "inbloom", "In Bloom" },
	{ "indybones", "Indy Bones: The Book of the Gods" },
	{ "indycomingofage", "Indiana Jones - Coming of Age" },
	{ "indycrownofsolomon", "Indiana Jones and the Crown of Solomon" },
	{ "indycrystalcursor", "Indiana Jones and the Window of the Crystal Cursor" },
	{ "indygoldofgenghiskhan", "Indiana Jones and the Gold of Genghis Khan" },
	{ "indypassageofsaints", "Indiana Jones and the Passage of Saints" },
	{ "indyrelicoftheviking", "Indiana Jones and the relic of the Viking" },
	{ "indysevencities", "Indiana Jones and the Seven Cities of Gold" },
	{ "indianarodent", "Indiana Rodent: Raiders of the Lost Cheese" },
	{ "infantrydivision", "Infantry Division 1338" },
	{ "infectionep1", "Infection - Episode I: The Ship" },
	{ "infectionep2", "Infection - Episode II: The Station" },
	{ "inferno", "Inferno: the demo of a rotten bastard" },
	{ "infinitemonkeys", "Infinite Monkeys" },
	{ "infinitybit", "Infinity Bit" },
	{ "inlimbo", "In Limbo" },
	{ "innersanctum", "Inner Sanctum" },
	{ "insanebert", "Insane Bert" },
	{ "insidemonkeyisland", "Inside Monkey Island" },
	{ "insidemonkeyislandch2", "Inside Monkey Island: 2nd chapter" },
	{ "insidemonkeyislandch3", "Inside Monkey Island: 3rd chapter" },
	{ "inspectorgismoe", "Inspector Gismoe" },
	{ "integerbattleship", "Integer Battleship" },
	{ "intergalacticspacepancake", "Intergalactic Space Pancake!" },
	{ "interstellarborders", "Interstellar Borders" },
	{ "intothelight", "Into The Light" },
	{ "intraworld", "Intra-World" },
	{ "intraworld2", "Intra-World 2" },
	{ "invincibleisland", "Invincible Island Remake" },
	{ "ioawn4t", "If On A Winter's Night, Four Travelers" },
	{ "irentedaboat", "I Rented a Boat" },
	{ "isaacodyssey", "Isaac's Odyssey" },
	{ "isnkill", "ISN: Kill!" },
	{ "isos", "I.S.O.S." },
	{ "ispy2", "I Spy II" },
	{ "itsabugslife", "It's a Bugs Life" },
	{ "itsjustarongame", "It's Just a Reality-on-the-Norm Game" },
	{ "iwalkedapath", "I Walked a Path" },
	{ "iwantanidentity", "I want an Identity (Quiero una Identidad)" },
	{ "iwantout", "I Want Out!" },
	{ "iwanttodie", "I want to die (Quiero Morir)" },
	{ "iwanttodieremake", "I want to die (Quiero Morir) Remake" },
	{ "iwwhiiwwhitomirotpgthegame", "IWWHIIWWHITOMIROTPG: The Game!" },
	{ "jack", "JACK" },
	{ "jacktrasheaterch1", "Jack Trasheater - Chapter I: Pain House! (Jack Trasheater e la Casa del Dolore)" },
	{ "jacktrekker", "Jack Trekker - Somewhere in Egypt" },
	{ "jacob", "Jacob" },
	{ "jacobvacut", "Jacob - VertigoAddict's cut" },
	{ "jacquelinewhitecurseofthemummies", "Jacqueline White - Curse of the Mummies" },
	{ "jacquelinewhitereddesert", "Jacqueline White - Bad Trouble in the Red Desert" },
	{ "jailhouse", "Jail House Breakdown" },
	{ "jamesbond", "James Bond" },
	{ "jamesinneverland", "James in Neverland" },
	{ "jamesperis", "James Peris es el agente 00,5" },
	{ "jamesperis2", "James Peris 2" },
	{ "jasongoldenapple", "Jason and the Golden Apple" },
	{ "javelincatch", "Javelin Catch" },
	{ "jetpacksam", "Jetpack Sam" },
	{ "jimmsquest3", "Jimm's Quest III: Lesko's Revenge" },
	{ "jimmysday", "Jimmy's Day" },
	{ "jimmythetroublemaker", "Jimmy The Troublemaker" },
	{ "joeshorriblehell", "Joe's Horrible Hell" },
	{ "joesmiserablelife", "Joe's Miserable Life" },
	{ "johnharris", "John Harris and the Treasure of the Pharaoh" },
	{ "johnjebediahgun", "John Jebediah Gun and Sepheret Island" },
	{ "johnlosthiskeyep1", "John Lost His Key - Episode 1" },
	{ "johnlosthiskeyep2", "John Lost His Key - Episode 2" },
	{ "johnnyrocket", "Johnny Rockett Adventure" },
	{ "johnsinclair", "John Sinclair - Voodoo in London" },
	{ "jonahsplace", "Jonah's Place" },
	{ "jonnyfeces", "Jonny and the sweet fragrance of feces" },
	{ "jonstickman", "Jon Stickman" },
	{ "journey", "Journey" },
	{ "journeyhome", "Journey Home" },
	{ "journeyhell", "Journey to Hell" },
	{ "juliusdangerous1", "Julius Dangerous .. and the space invaders" },
	{ "juliusdangerous2", "Julius Dangerous 2" },
	{ "jumpinjack", "Jumpin' Jack: the bean powered kid" },
	{ "jumpinjones", "Jumpin' Jones in: The Big Switch-Off" },
	{ "jumpjackflash", "Jump! Jack! Flash!" },
	{ "june20th", "June 20th" },
	{ "justanotherpointnclickadventure", "Just Another Point n Click Adventure" },
	{ "justyouandme", "Just You And Me" },
	{ "kanjigakusei", "Kanji Gakusei" },
	{ "karelianninja", "Karelian Ninja" },
	{ "kartquest", "Kart-Quest" },
	{ "kata", "KATA" },
	{ "keptosh1", "Keptosh I: The Search for junc" },
	{ "keyboardmadness", "Keyboard Madness" },
	{ "keysofagamespace", "Keys of a gamespace. An expressive game" },
	{ "killereye", "Killer Floating Eye" },
	{ "killjoseda", "Kill Joseda" },
	{ "killmenow", "Kill Me Now" },
	{ "killthelights", "Kill The Lights" },
	{ "kingdomlegend1", "Kingdom Legend" },
	{ "kingdomlegend2", "Kingdom Legend 2" },
	{ "kingofrock", "The King of Rock in: Riding the Wild Wind" },
	{ "kingrobert", "King Robert's Quest: The Frustratingly Early Access Adventure" },
	{ "kingsquestfororgy", "King's Quest for Orgy" },
	{ "kinkyisland", "Kinky Island" },
	{ "kirja", "Kirjastotäti" },
	{ "kittenadv", "Kitten Adventures" },
	{ "kittyquest", "Kitty Quest" },
	{ "knightquestforgoldenring", "Knight Quest for the Golden Ring" },
	{ "knightsquest3", "Knight's Quest III - Tides of Merania" },
	{ "knightsquest4", "Knight's Quest IV - Here Today, Gone to Yesterday" },
	{ "knobblycrook", "The Knobbly Crook" },
	{ "koddurova", "Kod Durova" },
	{ "koffeekrisis", "Koffee Krisis" },
	{ "kongbaghdad", "Kong Over Baghdad" },
	{ "korinsmines", "Korin's Mines" },
	{ "koscheitheimmortal", "Koschei The Immortal - The Beginning" },
	{ "kq3plus", "King's Quest III+" },
	{ "kq4retold", "King's Quest IV: The Perils of Rosella Retold" },
	{ "kq9vga", "King's Quest IX: The Silver Lining VGA" },
	{ "kristmaskrisis", "Kristmas Krisis" },
	{ "ktx1", "KTX-1" },
	{ "kumastory", "Kuma Story" },
	{ "labor", "Labor" },
	{ "labratescape", "Lab Rat Escape" },
	{ "labyrinth", "Labyrinth" },
	{ "lacicuta1", "La Cicuta1" },
	{ "lacroixpan", "La Croix Pan" },
	{ "laffaireaspirox", "L'Affaire Aspirox" },
	{ "lagrancastanya", "La Gran Castanya" },
	{ "lallaveyfabianshones", "LA LLAVE Y FABIAN SHONES" },
	{ "lamaleta", "La Maleta" },
	{ "laodiseadelfracaso2", "La Odisea del Fracaso II" },
	{ "laportenoire", "AAaaah!! La porte noire" },
	{ "larrylotter", "Larry Lotter and the Test of Time" }, // aka Warthogs
	{ "lastnfurious", "Last'n'Furious" },
	{ "laundryday", "Laundry Day" },
	{ "lavablava", "Lava Blava" },
	{ "lazaruswantspants", "Lazarus Wants Pants" },
	{ "lazytownthenewkid", "LazyTown: The New Kid" },
	{ "lbstoryofcedrickdusce", "LB: Story of Cedrick DUSCE!" },
	{ "lechuckstories", "LeChuck Stories" },
	{ "legendofrovendale", "Legend of Rovendale" },
	{ "legendofseththebard", "Legend of Seth the Bard" },
	{ "legendsofmardaram", "Legends of Mardaram" },
	{ "leisuresuitlarry2", "Leisure Suit Larry 2 - Point and Click" },
	{ "leisuresuitlarrylil", "Leisure Suit Larry: L i L" },
	{ "lesmiserables", "Les Miserables" },
	{ "lessthanthree", "<3 (Less Than Three)" },
	{ "lessurvivants", "Les Survivants" },
	{ "lichdomwheresdidiputthat", "Lichdom - Where's did I put that..." },
	{ "life", "Life" },
	{ "lifeboatstoryofcedrick", "Lifeboat: Story of Cedrick" },
	{ "lifeofdduck", "Life of D. Duck" },
	{ "lifeofdduck2", "Life of D. Duck II" },
	{ "liftreasureofthetanones", "Lif Treasure of the Tanones" },
	{ "lightcycles", "AGS Cycles" },
	{ "lightningmaster", "Lightning Master" },
	{ "likeafox", "Like a Fox!" },
	{ "limeylizardwastewizard", "Limey Lizard: Waste Wizard" },
	{ "litnunforgettablememories", "LitN Unforgettable Memories" },
	{ "littlegirlinunderland", "Little Girl in Underland" },
	{ "livingnightmaredeluxe", "Living Nightmare Deluxe" },
	{ "livingnightmareendlessdream", "Living Nightmare: Endless Dream" },
	{ "livingnightmarefreedom", "Living Nightmare: Freedom" },
	{ "lockedout", "Locked Out" },
	{ "loftusandtheskycap", "Loftus and the Sky Cap" },
	{ "lonecase", "LoneCase" },
	{ "lonecase2", "Lone Case 2" },
	{ "lonecase3showdown", "LoneCase3:Showdown" },
	{ "lonelynight", "Lonely night" },
	{ "longexpectedfriday", "Long expected Friday" },
	{ "lonkeyisland", "The Tale of Lonkey Island" },
	{ "lookingfordread", "Looking For Dread Mac Farlane (A la recherche de Dread Mac Farlane)" },
	{ "loomiireturnoftheswans", "Loom II: Return of the Swans" },
	{ "losjovenesdelaguerra", "Los Jovenes De La Guerra" },
	{ "lostanswers", "Lost Answers" },
	{ "lostdollar", "Max Griff in: The Lost Dollar" },
	{ "lostinparadise", "Lost In Paradise" },
	{ "lostinthenightmare", "Lost In The Nightmare" },
	{ "lostinthetomb", "Lost In The Tomb" },
	{ "lostinthewoods", "Lost In The Woods" },
	{ "lucasmaniac", "Lucas Maniac!" },
	{ "lucidlucy", "LUCID LUCY" },
	{ "lucylavender", "The Amazing Adventures of Lucy Lavender" },
	{ "lukesexistentialnightmare", "Luke's Existential Nightmare" },
	{ "lunarlanderprototype", "Lunar Lander Prototype" },
	{ "lydiaandthemysteryofnellrenomanor", "Lydia and the Mystery of Nellreno Manor" },
	{ "maggieandmax", "Maggie and Max" },
	{ "magic8ball", "Magic-8-Ball" },
	{ "magicalwhatevergirlrocksoutinthestoneage", "Magical Whatever Girl Rocks Out In The Stone Age" },
	{ "magicballoffortune", "Magic Ball of Fortune" },
	{ "magnumpm", "Magnum, P.M" },
	{ "magsic", "Magsic" },
	{ "magsic2", "Magsic II" },
	{ "magsceremony2001jul", "July 2001 MAGS Ceremony" },
	{ "magsceremony2001jun", "June 2001 MAGS Ceremony" },
	{ "magsjune2017", "MAGS june 2017" },
	{ "magssep2007", "MAGS Sep 2007" },
	{ "majorbummerdude", "Major Bummer Dude: Lassi Quest Reality-on-the-Norm" },
	{ "manboy", "Man Boy" },
	{ "maniacland", "Alice in Maniacland" },
	{ "maniacmansiondeluxe", "Maniac Mansion Deluxe" },
	{ "maniacmetalheadmania", "Maniac Metalhead Mania" },
	{ "mardsrevengebytk", "Mard's Revenge by TK" },
	{ "martyausdemall", "Marty aus dem All" },
	{ "mash", "M*A*S*H*: The Point n' Click Adventure" },
	{ "mastersofsound", "Masters of Sound" },
	{ "matttothefuture", "Matt to the Future" },
	{ "maverickgunn", "Maverick Gunn and the Eye of Oggun" },
	{ "medicaltheoriesofdrkur", "Medical Theories of Dr Kur" },
	{ "mego2008silvesteredition", "Me Go 2008: Silvester Edition" },
	{ "megoaway", "Me Go... Away!" },
	{ "megocannibaljungle", "Me Go Cannibal Jungle!" },
	{ "megostore", "Me Go Store!" },
	{ "melrin1", "Melrin: The Disciple Ordeal" },
	{ "melrin2", "Melrin: The Pendant Quest" },
	{ "melrin3", "Melrin: The Dragon Menace" },
	{ "memoriesfade", "Memories Fade" },
	{ "meninhats", "Men In Hats" },
	{ "merrychristmas", "Merry Christmas" },
	{ "messedupmothergoosedeluxemyassenhanced", "Messed-Up Mother Goose - DELUXE MY ASS: ENHANCED" },
	{ "meta", "META" },
	{ "metaphobia", "Metaphobia" },
	{ "meteorheadrecycled", "METEORHEAD RECYCLED" },
	{ "mi5thereturnoflechuck", "Monkey Island 5: The Return of LeChuck" },
	{ "mibaddaytobedead", "MI:Bad Day to be Dead" },
	{ "micarnivalofthedamned", "MI:Carnival of the Damned" },
	{ "mickeymauserpart1", "Mickey Mauser: Part 1" },
	{ "micv", "Monkey Island - Carnaval Vudu - Parte 1 - La Busqueda" },
	{ "midastouch", "midastouch" },
	{ "mikasdream2", "Mika's Surreal Dream II: The Dream Comes True!?" },
	{ "mikelechey", "Mike Lechey" },
	{ "mikesroom", "Mike's Room" },
	{ "milkshake", "Milkshake" },
	{ "mimv", "Monkey Island - La Maldicion Vudu" },
	{ "mindboggler", "MINDBOGGLER" },
	{ "mindseye", "Mind's Eye" },
	{ "minigame4", "Mini Game 4" },
	{ "missingsincemidnight", "Missing since Midnight" },
	{ "mistdelaescueladearte", "El Misterio de la Escuela de Arte" },
	{ "mivl", "Monkey Island - La Venganza de Largo" },
	{ "mmm1", "MMM 001: Geschwisterliebe" },
	{ "mmm2", "MMM 002: Unruhen" },
	{ "mmm3", "MMM 003: Stubenarrest" },
	{ "mmm4", "MMM 004: Mimikry der Emotionen" },
	{ "mmm5", "MMM 005: Rhythmen zum Reinbeißen" },
	{ "mmm6", "MMM 006: Er is' weg" },
	{ "mmm7", "MMM 007: Right said Fred!?!" },
	{ "mmm8", "MMM 008: Die Abfuhr" },
	{ "mmm9", "MMM 009: Radioaktiv" },
	{ "mmm10", "MMM 010: Tales of the Weird Ed" },
	{ "mmm11", "MMM 011: Ein haariger Ausflug" },
	{ "mmm12", "MMM 012: Serien-Special: GIGA Mansion" },
	{ "mmm13", "MMM 013: Nur geträumt" },
	{ "mmm14", "MMM 014: Ed's Rache für den Hamsterbraten" },
	{ "mmm15", "MMM 015: Ortmaschine" },
	{ "mmm16", "MMM 016: Meteor Family - Die Rückkehr des Meteoriten" },
	{ "mmm17", "MMM 017: Das Labor" },
	{ "mmm18", "MMM 018: Shit Happens!" },
	{ "mmm21", "MMM 021: Rettet Kanal 13!" },
	{ "mmm22", "MMM 022: Presserummel" },
	{ "mmm23", "MMM 023: Das verflixte Geschenk" },
	{ "mmm24", "MMM 024: Time Machine" },
	{ "mmm26", "MMM 026: Zeitenwende" },
	{ "mmm27", "MMM 027: Hamsternator" },
	{ "mmm28", "MMM 028: Time Machine 2" },
	{ "mmm29", "MMM 029: Flucht des Meteoriten" },
	{ "mmm30", "MMM 030: Memories of Zak" },
	{ "mmm31", "MMM 031: Britneys Suche" },
	{ "mmm32", "MMM 032: The Secret of Maniac Mansion" },
	{ "mmm33", "MMM 033: Carry on Smiley!" },
	{ "mmm34", "MMM 034: Helden des Tages" },
	{ "mmm35", "MMM 035: Weggebeamt" },
	{ "mmm36", "MMM 036: Der Liebesbrief" },
	{ "mmm37", "MMM 037: Verabredung mit Dave" },
	{ "mmm38", "MMM 038: Rescue Mission" },
	{ "mmm39", "MMM 039: Erinnerungen" },
	{ "mmm40", "MMM 040: Verflixte Türen" },
	{ "mmm41", "MMM 041: Das neue Jugendschutzgesetz" },
	{ "mmm42", "MMM 042: Die furchtbaren Pläne des Psycho Bernie" },
	{ "mmm43", "MMM 043: Vorsicht, Edna kommt!" },
	{ "mmm44", "MMM 044: Razors grosser Auftritt" },
	{ "mmm45", "MMM 045: Maniac Monday" },
	{ "mmm46", "MMM 046: Verschollen" },
	{ "mmm47", "MMM 047: Maniac Ostern" },
	{ "mmm48", "MMM 048: Wendy und das Buch des Todes" },
	{ "mmm49", "MMM 049: Clouso's grösster Coup" },
	{ "mmm50", "MMM 050: Das Date 3" },
	{ "mmm51", "MMM 051: Ortmaschine II" },
	{ "mmm52", "MMM 052: Ein irrer Tag eines Ronvillers" },
	{ "mmm53", "MMM 053: Der Klaus schlägt zurück" },
	{ "mmm54", "MMM 054: CSI:RONVILLE" },
	{ "mmm55", "MMM 055: Hamsters of the mysterious man: Chapter of dream" },
	{ "mmm56", "MMM 056: Grotten-Urlaub" },
	{ "mmm57", "MMM 057: Ein geheimnisvoller Ausflug" },
	{ "mmm58", "MMM 058: The People's Court" },
	{ "mmm59", "MMM 059: Computerliebe" },
	{ "mmm60", "MMM 060: Jahrmarkt der Verdammten" },
	{ "mmm61", "MMM 061: Bernards Room" },
	{ "mmm63", "MMM 063: Books - Deals unter Nachbarn" },
	{ "mmm64", "MMM 064: Baranoia" },
	{ "mmm65", "MMM 065: Save Smiley!" },
	{ "mmm66", "MMM 066: Hoagies neuer Freund" },
	{ "mmm66akt3", "MMM 066: Hoagies neuer Freund - Akt 3: Der verbotene Akt" },
	{ "mmm67", "MMM 067: Die Schöne und das Biest" },
	{ "mmm68", "MMM 068: MaMMa ante Portas" },
	{ "mmm69", "MMM 069: Samstag" },
	{ "mmm70", "MMM 070: Maniac Mansion Begins" },
	{ "mmm71", "MMM 071: Neue Abenteuer auf Terra" },
	{ "mmm72", "MMM 072: Mindbending TV" },
	{ "mmm73", "MMM 073: Even a broken Clock" },
	{ "mmm74", "MMM 074: Ted Edison and the Curse of King RootenTooten" },
	{ "mmm75", "MMM 075: Das Necronomicon" },
	{ "mmm76", "MMM 076: The Bernoulli-Show" },
	{ "mmm77", "MMM 077: Schwer verquer" },
	{ "mmm78", "MMM 078: Dumm geholfen" },
	{ "mmm79", "MMM 079: Der Wunsch-O-Mat" },
	{ "mmm80", "MMM 080: Spiel des Lebens" },
	{ "mmm81", "MMM 081: Bernard bricht aus!" },
	{ "mmm82", "MMM 082: Freundin mit Hindernissen" },
	{ "mmm83", "MMM 083: Chasing Hoagie" },
	{ "mmm84", "MMM 084: Surf'n'Ronville" },
	{ "mmm85", "MMM 085: Freundin mit Hindernissen - Part 2" },
	{ "mmm86", "MMM 086: Bernard bekommt Besuch" },
	{ "mmm87", "MMM 087: Das Geheimnis des Blakes Hotel von Ronville" },
	{ "mmm88", "MMM 088: Der alltägliche Wahnsinn" },
	{ "mmm89", "MMM 089: Der Weltrettungsalgorithmus - Die neue Version" },
	{ "mmm90", "MMM 090: Kofferpacken" },
	{ "mmm91", "MMM 091: Fels in der Brandung" },
	{ "mmm93", "MMM 093: Murder at the Moonshine Mansion" },
	{ "mmm94", "MMM 094: Maniac on the Mississippi" },
	{ "mmm95", "MMM 095: Britney's Flucht" },
	{ "mmm96", "MMM 096: Dave's Home Odyssey" },
	{ "mmm97", "MMM 097: Tollhaus-Weihnachten" },
	{ "mmm98", "MMM 098: Maniac Apartment" },
	{ "mmm99", "MMM 099: Die Premiere" },
	{ "mmm100", "MMM 100: Money Mansion" },
	{ "mmmhw1", "MMM Halloween 05-1" },
	{ "mmmhw2", "MMM Halloween 05-2: Escape from Maniac Mansion" },
	{ "mmmhw3", "MMM Halloween 05-3: Day of the Dead" },
	{ "mmmhw4", "MMM Halloween 05-4: MMM-Horror" },
	{ "mmmhw5", "MMM Halloween 05-5: Redrum" },
	{ "mmmhw6", "MMM Halloween 06-1: The Curse of Maniac Mansion" },
	{ "mmmhw7", "MMM Halloween 06-2: Hä? Ich glaub' ich spinne!" },
	{ "mmmhw8", "MMM Halloween 10-1: Das Monster aus der Racoon Lagoon" },
	{ "mmmhw9", "MMM Halloween 10-2: TMMCMFH" },
	{ "mmmhw10", "MMM Halloween 10-3: Und Bernard läutet zur Geisterstunde" },
	{ "mmmhw11", "MMM Halloween 10-4: Bad and Mad" },
	{ "moncul", "Mon Cul!" },
	{ "monkeyklon", "A Clone of Monkey Island" },
	{ "monkeystothemoon", "Monkeys to the Moon" },
	{ "monkeywrench", "monkeywrench" },
	{ "monsterfromthehountedhill", "Monster from the hounted hill" },
	{ "montyonthenorm", "Monty on the Norm" },
	{ "moonlightmoggy", "Moonlight Moggy" },
	{ "moose", "Moose" },
	{ "moose2", "Moose 2" },
	{ "mordimlaufrad", "Mord im Laufrad" },
	{ "mordy2", "Mordy2" },
	{ "mothersday", "Mothers Day" },
	{ "motlpaa", "MOTLPAA" },
	{ "mourirenmer", "Mourir en mer" },
	{ "mrdangerscontest", "Mr. Danger's Contest" },
	{ "mudlarks", "Mudlarks" },
	{ "murderdog4", "Murder Dog IV: Trial of the Murder Dog" },
	{ "murderinthemansion", "Murder in the Mansion" },
	{ "murderofadrianelkwood", "The Murder of Adrian Elkwood" },
	{ "murphyssalvagejustmyluck", "Murphy's Salvage: Just My Luck" },
	{ "murranchronicles1", "Murran Chronicles 1" },
	{ "murranchronicles2", "Murran Chronicles 2" },
	{ "murranchronicles3", "Murran Chronicles 3 - Life Drinker" },
	{ "musicmixer", "Boyd's Music Mixer" },
	{ "myburdentokeep", "My Burden to Keep" },
	{ "mysterioushouse", "Mysterious house" },
	{ "mysticseer", "Mystic Seer" },
	{ "mythicalgambitflawlessfatality", "Mythical Gambit: Flawless Fatality" },
	{ "mzi", "Mission Zukunftia" },
	{ "mzi2", "Mission Zukunftia 2" },
	{ "nanobots", "Nanobots" },
	{ "necroquest", "Necroquest" },
	{ "nedysadventure", "Nedy's adventure" },
	{ "nekusnewtrip", "Neku's new trip" },
	{ "nellycootalot", "Nelly Cootalot: Spoonbeaks Ahoy!" },
	{ "nellycootalot-hd", "Nelly Cootalot: Spoonbeaks Ahoy! HD" },
	{ "neosaires2070", "Neos Aires 2070" },
	{ "nesquest", "NES Quest" },
	{ "news", "N.E.W.S." },
	{ "nickitandrun", "Al Gurbish in... Nick It & Run!!!" },
	{ "niemandsland", "Das Niemandsland" },
	{ "nightandday", "Night and Day" },
	{ "nightoftheravingfeminist", "Night of the Raving Feminist" },
	{ "nightwork", "Nightwork" },
	{ "noactionjackson", "No-Action Jackson" },
	{ "noahsquest", "Noah's Quest" },
	{ "nobodycares", "Nobody Cares" },
	{ "noiamspartacus", "No, I Am Spartacus!" },
	{ "noisymountain", "Noisy Mountain" },
	{ "nomonkeysbanana", "No Monkey's Banana" },
	{ "norbisquest", "Norbi's quest" },
	{ "norbisquest15", "Norbi's quest 1,5" },
	{ "norbisquest2", "Norbi's quest 2" },
	{ "norbiwinterspecial", "Norbi winter special" },
	{ "normancooks", "Norman Cooks" },
	{ "norserunereader", "Norse Rune Reader" },
	{ "notetoself", "Note to Self" },
	{ "noughtscrosses", "Noughts & Crosses" },
	{ "oceanspiritdennisscourgeoftheunderworld", "Oceanspirit Dennis: Scourge of the Underworld" },
	{ "odottamaton", "Odot Tamat On" },
	{ "offtheclock", "Off The Clock" },
	{ "ohdulieber", "Oh du lieber Augustin" },
	{ "omnipotenttarot", "Omnipotent Tarot" },
	{ "onceuponacrime", "Once Upon A Crime" },
	{ "onceuponatime", "Once Upon A Time" },
	{ "one", "One" },
	{ "onemorefathom", "One More Fathom" },
	{ "oneofakindadivinecomedyofmistakes", "One Of A Kind: A Divine Comedy of Mistakes" },
	{ "onespytoomany", "One spy too many" },
	{ "oneweekoneroom", "One Week One Room" },
	{ "onleavingthebuilding", "On Leaving The Building" },
	{ "onlythegooddieyoungenglishversion", "Only The Good Die Young - english version" },
	{ "openquest", "OpenQuest!" },
	{ "operationnovi", "Operation Novi" },
	{ "operationsavebluecup", "Operation Save Blue Cup" },
	{ "orangeman", "Orange man" },
	{ "osdarayofhope", "OSD: A Ray of Hope" },
	{ "osdocd", "OSD:OCD" },
	{ "osdsearch", "The Search for Oceanspirit Dennis" },
	{ "osdthelostworldep2", "OSD.The lost world ep 2" },
	{ "osdvsron", "Oceanspirit Dennis vs. Reality-on-the-Norm" },
	{ "osher", "Boundless Osher - Osher Bli Gvulot" },
	{ "otakurivals", "Otaku Rivals" },
	{ "otherworlds", "Other Worlds" },
	{ "otisbuildsafire", "Otis Builds a Fire" },
	{ "ouja", "Ouja" },
	{ "ourobouros", "I am Ourobouros" },
	{ "outbreakbyabhijitkamat", "Outbreak by Abhijit Kamat" },
	{ "outofgas", "Out of Gas" },
	{ "overtheedge", "The Journey Down: Over the Edge" },
	{ "owlsquest", "Owl's Quest" },
	{ "palettequest2", "Palette Quest 2" },
	{ "pandainspace", "Panda In Space" },
	{ "pandor", "Pandor" },
	{ "paperplanes", "Paper Planes" },
	{ "paradiselost", "Paradise Lost" },
	{ "parameciumcomplex", "Paramecium Complex" },
	{ "paranormalinvestigation", "Paranormal Investigation" },
	{ "paranormalwarriorwithin", "Paranormal Warrior Within" },
	{ "party", "Party" },
	{ "patchwork", "Patchwork" },
	{ "paulaimwunderland", "Paula im Wunderland" },
	{ "paulmooseinspaceworld", "Paul Moose In Space World" },
	{ "paulquest", "Paul Quest" },
	{ "paulromano", "Paul Romano - Recollection" },
	{ "pennistheultimateinpong", "Pennis: The Ultimate in Pong!" },
	{ "perfidiouspetrolstation", "The Perfidious Petrol Station" },
	{ "perilsofpoom", "PERILS OF POOM" },
	{ "pesterquest", "Pester Quest" },
	{ "petshopincident", "The Petshop Incident" },
	{ "petalrose", "Petal Rose" },
	{ "pharmacistjones", "Pharmacist Jones" },
	{ "pickpocketrpg", "Pickpocket RPG" },
	{ "pilotlight", "Pilot Light" },
	{ "pimpinonparakuss", "Pimpin On Parakuss" },
	{ "piratefry2", "Pirate Fry 2" },
	{ "piratefry3", "Pirate Fry 3" },
	{ "pirates", "Pirates!" },
	{ "piratess", "Piratess" },
	{ "piss", "PISS" },
	{ "pixelhunt", "Pixel Hunt" },
	{ "pixia", "Pixia" },
	{ "pixxxelhuntertheepic", "Pixxxelhunter The Epic" },
	{ "pizzanostra", "Pizza Nostra" },
	{ "plan10frommypants", "Plan 10 from MY PANTS!!!" },
	{ "planetxmas", "Planet Xmas" },
	{ "platformerius", "Platformerius" },
	{ "platformhorde", "Platform Horde" },
	{ "pledgequest1", "Pledge Quest 1" },
	{ "pledgequest2", "Pledge Quest 2" },
	{ "pleurghburgdarkages", "Pleurghburg: Dark Ages" },
	{ "plumberboy", "Plumberboy" },
	{ "pm-cute", "PM Cute" },
	{ "pmuvchvt", "PMUVCHVT" },
	{ "pmxi", "PMXI" },
	{ "pocketfluffyay", "PocketFluff_yay!" },
	{ "politicallyyours", "Politically Yours" },
	{ "ponderabilia", "Ponderabilia" },
	{ "pong", "Pong" },
	{ "postmansquest", "Postman's Quest" },
	{ "powernap", "Power Nap" },
	{ "powerunlimited", "Power Unlimited" },
	{ "pqtadventure", "Adventures of PQT" },
	{ "practicescript", "Practice Script" },
	{ "predatorspreyforplants", "Predators Prey For Plants" },
	{ "preludetoadventure", "A Prelude to an Adventure" },
	{ "princessandallthekingdom", "Princess and all the kingdom" },
	{ "princessmarianix", "Princess Marian IX" },
	{ "princessmariansnowfight", "Princess Marian Snow Fight!" },
	{ "princessmarianspigeonpinger", "Princess Marian's Pigeon Pinger" },
	{ "princessmarianxmagichat", "Princess Marian X: Magic Hat" },
	{ "principlesofevil", "Principles of Evil" },
	{ "principlesofevil2", "Principles of Evil II" },
	{ "prisonersofice", "Prisoners of Ice" },
	{ "prodigal", "Prodigal" },
	{ "profneely", "Professor Neely And The Death Ray Of Doom" },
	{ "projectevilspy2", "Project Evilspy II" },
	{ "proofoffiction", "Proof of Fiction" },
	{ "prototypical", "Prototypical" },
	{ "proxecto", "Proxecto" },
	{ "psychopomp", "Psychopomp" },
	{ "pubmasterquest2", "pub master quest.2" },
	{ "pubmastersquest", "Pub Masters Quest" },
	{ "puddypenguin", "Puddy Penguin" },
	{ "purgatorio", "Purgatorio" },
	{ "purityofthesurf", "Purity of the Surf" },
	{ "pussiehunt", "Pussie Hunt" },
	{ "puzzlepumice", "Puzzle of the Pulchritudinous Pumice" },
	{ "puzzlebots", "Puzzle Bots" },
	{ "pxenophobe", "PXenophobe" },
	{ "quantumnauts", "QUANTUMNAUTS" },
	{ "questfighter", "Quest Fighter" },
	{ "questfighter2", "Quest Fighter II" },
	{ "questforcinema", "QuestForCinema" },
	{ "questforjesus", "Quest for Jesus" },
	{ "questforpalette", "Quest for Palette" },
	{ "questforthebluecup", "Quest for the Blue Cup" },
	{ "questforyeti", "Quest for Yeti" },
	{ "questforyrolg", "Quest for Yrolg" },
	{ "quimbyquestanewdope", "Quimby Quest: A New Dope" },
	{ "rabbiteyemotel", "An Evening At The RabbitEye Motel" },
	{ "race", "R.ACE" },
	{ "racist", "Racist" },
	{ "rackham", "Rackham" },
	{ "rainbowtube", "Billy And Desmond's Fantastic Amazing Rainbow Tube" },
	{ "ralphtheraven", "Ralph the Raven" },
	{ "ramghost", "RAM Ghost" },
	{ "ramsesporter", "Ramses Porter and the Relay for Love" },
	{ "rango", "Rango" },
	{ "ratchannel", "Rat Channel" },
	{ "rayandtheguitar", "Ray and the Guitar" },
	{ "raybexter", "Ray Bexter" },
	{ "razorsinthenight", "Razors in the Night" },
	{ "reagentorange", "Re-Agent Orange" },
	{ "realitycheck1", "Reality Check" },
	{ "realitycheck2", "Reality Check 2" },
	{ "realitycheck3", "Reality Check 3" },
	{ "realitycheck4", "Reality Check 4" },
	{ "realityinthenorm", "Reality-in-the-Norm" },
	{ "realityonthenorm", "Reality-on-the-Norm" },
	{ "recess", "Recess" },
	{ "recess2", "Recess 2" },
	{ "redbow", "Red Bow" },
	{ "redbeardsavesron", "Red Beard Saves Reality-on-the-Norm" },
	{ "reddwarf", "Red Dwarf" },
	{ "redflagg", "Red Flagg" },
	{ "redhotoverdrive", "Red Hot Overdrive" },
	{ "redpantsmeetsrobinsonclauseau", "Redpants meets Robinson Clauseau" },
	{ "redpantstheprincessandthebeanstalk", "Redpants: The Princess and the Beanstalk" },
	{ "reefriversquestforekoban", "Reef Rivers: Quest for Ekoban" },
	{ "rend", "The Tapestry - Chapter 2: Rend" },
	{ "repossessor", "The Repossessor" },
	{ "retaliation", "Reality-on-the-Norm 13:13 Retaliation" },
	{ "retroron", "Retroron" },
	{ "returnjourney", "Return Journey" },
	{ "returntocivilization", "Return To Civilization" },
	{ "revelation", "Revelation" },
	{ "rickyquest", "Ricky Quest" },
	{ "righteouscity", "Righteous City" },
	{ "roadofdestiny", "Road of Destiny" },
	{ "roadracer", "Road Racer" },
	{ "roastmothergoose", "Roast Mother Goose" },
	{ "robbingtheprincess", "Robbing The Princess" },
	{ "robertredford1", "Robert Redford saves the day Ep 1" },
	{ "robertredford2", "Robert Redford saves the day Ep 2" },
	{ "robertredford3", "Robert Redford saves the day Ep 3" },
	{ "robmassacreofchainsawness", "Rob: Massacre of Chainsawness" },
	{ "roboquest", "Robo Quest" },
	{ "robotragedy", "Robotragedy" },
	{ "robotragedy2", "Robotragedy 2" },
	{ "roccioquest", "Roccio Quest" },
	{ "rockabillykid", "Rockabilly Kid" },
	{ "rockatruestory", "Rock - A True Story" },
	{ "rockburgerstreehouses", "Rock Burgers & Tree Houses" },
	{ "rockpaperscissors2", "Rock Paper Scissors Reboot" },
	{ "rockrockrock", "Rock Rock Rock" },
	{ "rockyroams", "Rocky roams" },
	{ "rodequest2", "Rode Quest 2" },
	{ "rogue", "Rogue" },
	{ "ronbeforethelegacy", "Reality-on-the-Norm: Before the Legacy" },
	{ "ronsixteen", "Sixteen" },
	{ "rontimeouttrailer", "Time Out Trailer" },
	{ "ron5thanniversary", "Reality-on-the-Norm 5th Anniversary Trailer" },
	{ "ronvilleviper", "MMM - Hollywood Special 2011 - Ronville VIper" },
	{ "roomoffear", "Room of fear" },
	{ "rootofallevil", "Root of All Evil" },
	{ "rosauradocelestialrescuefromdespair", "Rosaura Docelestial: Rescue from Despair" },
	{ "rowengoestowork", "Rowen Goes To Work" },
	{ "rs15", "rs15" },
	{ "rudeawakening", "Rude Awakening" },
	{ "runestones", "Runestones!" },
	{ "ryansdayout", "Ryan's Day Out" },
	{ "saddsonissein", "Saddson Issein" },
	{ "salazarsevilplan", "Salazar's evil plan" },
	{ "sammysquest", "Sammy's Quest" },
	{ "santaclausdown", "Santa Claus Down" },
	{ "santassidekick", "Santas Sidekick" },
	{ "satanquest", "Satan Quest" },
	{ "satchsquest", "Satch's Quest" },
	{ "saturdayschool", "Saturday School" },
	{ "saw", "Saw" },
	{ "saw2", "Saw 2" },
	{ "scaredstiffa", "Scared Stiff a" },
	{ "scarymaze", "Scary Maze" },
	{ "schwarzweissrot", "SchwarzWeissRot" },
	{ "scnider", "Scnider" },
	{ "scytheisland", "Scythe Island" },
	{ "searchforsanity", "Search for Sanity" },
	{ "searchofmarina", "In search of Marina" },
	{ "seashells", "Seashells" },
	{ "seasongreetings2002", "Season Greetings 2002" },
	{ "secretquestremake", "Secret Quest Remake" },
	{ "secrets", "Secrets" },
	{ "sepulchre", "Sepulchre" },
	{ "sevendoors", "Seven Doors" },
	{ "shadesofgreye", "Shades of Greye" },
	{ "shadowsofron", "Shadows of Reality-on-the-Norm" },
	{ "shadowsoftheempire", "Star Wars: Shadows of the Empire (Tech Demo)" },
	{ "shailadusithlenquete", "Shai-la du Sith : l'Enquete" },
	{ "shailaofthesith", "Shai-la of the Sith" },
	{ "shawshank", "The Shawshank Redemption" },
	{ "sheepquest", "SheepQuest" },
	{ "shem", "Shem" },
	{ "sherlock", "Sherlock" },
	{ "shiftersboxoutsidein", "Shifter's Box - Outside In" },
	{ "shoot", "Shoot" },
	{ "shootmyvalentine", "Shoot my Valentine" },
	{ "shortcut", "ShortCut" },
	{ "shrivel", "Shrivel" },
	{ "shunday", "Shunday" },
	{ "sierraquest1", "Sierra Quest 1 - Roberta in Love" },
	{ "silentknight1", "Silent Knight" },
	{ "silentknight2", "Silent Knight II" },
	{ "simonsjourney", "Simon's Journey" },
	{ "simonthesorcerer3", "Simon the Sorcerer 3" },
	{ "simonthesorcerersbrother", "Simon, The Sorcerer's Brother" },
	{ "simshogwarts", "SimsHogwarts" },
	{ "skippysavestheday", "Skippy Saves The Day" },
	{ "slaythedragon", "Slay the Dragon" },
	{ "slaythedragon2", "Slay the Dragon II" },
	{ "slaythedragon3", "Slay the Dragon III" },
	{ "sleepyisland", "Sleepy Island" },
	{ "slimequestforpizza", "Slime-Quest for Pizza" },
	{ "slothforseasons", "A Sloth For Both Seasons" },
	{ "slugprincess", "Slug Princess" },
	{ "sma1", "Second Moon Adventure Part 1 - Night" },
	{ "sma2", "Second Moon Adventure Part 2" },
	{ "sma3", "Second Moon Adventure Part 3 - Rest In Peace" },
	{ "sma4", "Second Moon Adventure Part 4" },
	{ "sma6", "Second Moon Adventure Part VI" },
	{ "smileysquest", "Smiley's Quest" },
	{ "smileysquest2", "Smiley's Quest 2" },
	{ "smoothhide", "Smooth Hide" },
	{ "snakeamagsgame", "SNAKE - a MAGS game" },
	{ "snakesofavalon", "Snakes of Avalon" },
	{ "snakesonaplane", "Snakes on a plane!" },
	{ "snipermotherland", "Sniper and spotter serving the motherland" },
	{ "sniperpatriotic", "Sniper and spotter being patriotic" },
	{ "snowmaneatcarrot", "May the Best Snowman Eat a Carrot" },
	{ "snowyadventures", "Snowy Adventures" },
	{ "sonicandfriendsinclubhouse", "Sonic and friends in: Club house" },
	{ "sophiamcgrath", "Sophia McGrath" },
	{ "sosk", "Sosk" },
	{ "sovietunterzoegersdorf2", "Soviet Unterzoegersdorf: Sector II" },
	{ "sovietunterzoegersdorf", "Soviet Unterzoegersdorf" },
	{ "spacefreakers", "Space Freakers" },
	{ "spacehunter", "Space Hunter" },
	{ "spacelynxes", "Space Lynxes" },
	{ "spacepirates", "Space Pirates" },
	{ "spacepoolalpha", "Space Pool Alpha" },
	{ "spacerangers", "Space Rangers" },
	{ "spacerangersep52", "Space Rangers Ep 52" },
	{ "spacewar", "Space war" },
	{ "spacewarepisode2strikba", "Spacewar episode 2(strik.ba.)" },
	{ "spellbound", "Spellbound" },
	{ "spilakassinn", "Spilakassinn" },
	{ "spooks", "Spooks" },
	{ "spoonsiiitheunauthorizededition", "Spoons III - The Unauthorized Edition" },
	{ "spottd_boyd", "Spot The Difference" },
	{ "spottd_captainid", "Spot The Difference" },
	{ "sproutsofevil", "Sprouts of evil" },
	{ "sq3vga", "Space Quest III VGA Preview" },
	{ "sq45", "Space Quest IV.5 - Roger Wilco And The Voyage Home" },
	{ "sq55", "Space Quest 5.5" },
	{ "sqdote", "Space Quest Minus 1: Decisions of the Elders" },
	{ "sqdote2", "Space Quest: A Son of Xenon" },
	{ "sqinc", "Space Quest: Incinerations" },
	{ "sqkubikgetready", "SQ Kubik (Get ready?)" },
	{ "sqm11", "Space Quest Mania 1x1" },
	{ "sqm11remake", "Space Quest Mania 1x1 (Remake)" },
	{ "sqm12", "Space Quest Mania 1x2" },
	{ "sqm12remake", "Space Quest Mania 1x2 (Remake)" },
	{ "sqm13", "Space Quest Mania 1x3" },
	{ "sqm14", "Space Quest Mania 1x4" },
	{ "sqm15", "Space Quest Mania 1x5" },
	{ "sqm16", "Space Quest Mania 1x6" },
	{ "sqpotim", "Space Quest: Planet of the Incredible Menace" },
	{ "sqvn", "Space Quest Visual Novel" },
	{ "sqvsb", "Space Quest: Vohaul Strikes Back" },
	{ "sram2", "SRAM 2 - Cinomeh's Revenge" },
	{ "stablepeteandthejoust", "Stable Pete and the Joust" },
	{ "stairquest", "Stair Quest" },
	{ "stanamespiepisode1", "Stan Ames PI, Episode 1" },
	{ "stansrevenge", "Stan's Revenge" },
	{ "stargateadv", "Stargate Adventure" },
	{ "stargatesgc", "Stargate SGC" },
	{ "stargatesolitaire", "Stargate Solitaire" },
	{ "starshipcaramba", "Starship Caramba" },
	{ "starshipposeidon", "Starship Poseidon" },
	{ "starshipquasar", "Starship Quasar" },
	{ "startreknewton", "Star Trek: Newton (Part 1 - Anomaly)" },
	{ "stediddyip1employment", "Stediddy IP1 - Employment" },
	{ "stickmeni", "Stickmen I" },
	{ "stickythestickfigurepart1thecrimsonhouse", "Sticky the Stick Figure Part 1: The Crimson House" },
	{ "stranded", "STRANDED" },
	{ "stranger", "Stranger" },
	{ "strangerinstickworld", "Stranger in Stickworld" },
	{ "strangerthings", "Stranger Things" },
	{ "stuckathome", "Stuck at Home" },
	{ "sulifallenharmony", "Suli Fallen Harmony" },
	{ "supaevil", "Supa-EviL" },
	{ "supergirl", "Supergirl" },
	{ "superhammerquest", "Super Hammer Quest" },
	{ "superpitstopracing", "Super Pitstop Racing" },
	{ "surreality", "Surreality" },
	{ "suspiciousmind", "Suspicious Mind" },
	{ "sweed", "Sweed" },
	{ "sword", "Sword" },
	{ "sydneyfindsemployment", "Sydney Finds Employment" },
	{ "sydneytreadsthecatwalk", "Sydney Treads the Catwalk" },
	{ "symploke1", "Symploke. Legend of Gustavo Bueno (Chapter 1)" },
	{ "symploke2", "Symploke: Legend of Gustavo Bueno (Chapter 2)" },
	{ "symploke3", "Symploke: Legend of Gustavo Bueno (Chapter 3)" },
	{ "taleofalegacy", "A Tale of a Legacy" },
	{ "talesofchickenry", "Tales of Chickenry" },
	{ "tao", "Tao" },
	{ "tarthenia", "Tarthenia" },
	{ "teamwork", "Teamwork" },
	{ "tbdiy", "The BAD day in year" },
	{ "teafortwo", "Tea for Two - A Detective Logans Case" },
	{ "templeofspheres", "Indiana Jones and the Temple of Spheres" },
	{ "tenhumstombpart1", "Tenhum's Tomb Part 1" },
	{ "terrorofthevampire", "Terror of the Vampire!" },
	{ "test", "Test" },
	{ "test5", "test5" },
	{ "textparsergame", "Text Parser Game" },
	{ "tfg-bttf3", "The Fan Game - Back to the Future Part III - Timeline Of Monkey Island" },
	{ "tfg-bttf4", "The Fan Game - Back to the Future Part IV - The Multitasking Crystal" },
	{ "tfg-bttf5", "The Fan Game - Back to the Future Part V - Multidimensional Space-Timelines" },
	{ "tfg-bttfwat", "The Fan Game - I'll Be Back to the Future With A Terminator" },
	{ "tfg-mi", "The Fan Game - Ghostbusters and The Secret of Monkey Island" },
	{ "tfg-goonies", "The Fan Game - The Goonies" },
	{ "tfg-pixel", "The Fan Game - The Pixel Has You - Disk 1" },
	{ "tfg-somi", "The Fan Game - The Secret of Monkey Island Recoded" },
	{ "tfg-ssgw", "The Fan Game - Saint Seiya - Galaxian Wars" },
	{ "tfg-zak2", "The Fan Game - Zak McKracken: A Mansion, A Meteor, and the Alien Mindbenders" },
	{ "tftoz1", "Tales From The Outer Zone: Cyborg Seppuku" },
	{ "tftoz2", "Tales From The Outer Zone: The Goat Crone" },
	{ "tftoz3", "Tales From The Outer Zone: Fleshworms" },
	{ "tftoz4", "Tales From The Outer Zone: The Construction" },
	{ "thatcrazyworld", "That Crazy World" },
	{ "thatday", "ThatDay" },
	{ "the30minutewar", "Duke Stanley, National Hero in: The 30 Minute War" },
	{ "the7thsense", "The 7th Sense" },
	{ "theadventureofthehero", "The Adventure of the Hero" },
	{ "theadventuresofturquoisem", "The Adventures of Turquoise M" },
	{ "theassassin", "The Assassin" },
	{ "theawakening", "The Awakening" },
	{ "thebadneighbours", "The bad neighbours" },
	{ "thebar", "The Bar" },
	{ "thebrokenbrain", "The Broken Brain" },
	{ "thebunker", "The Bunker" },
	{ "theburn", "The Burn" },
	{ "thecadaversynod", "The cadaver synod" },
	{ "thecan", "The Can" },
	{ "thecell", "Drunk Fred in the Cell" },
	{ "thechrysalis", "The Chrysalis" },
	{ "thecrazedchicken", "The Crazed Chicken" },
	{ "thecube", "The Cube" },
	{ "thecurseoflife", "The Curse of Life" },
	{ "thedaynothinghappened", "The Day Nothing Happened" },
	{ "thedayofdarkness", "The Day Of Darkness" },
	{ "thedeathoflukesimpson", "The Death of Luke Simpson" },
	{ "thedevilsshroudpart1", "The Devil's Shroud-part1" },
	{ "thedigitalspell", "The Digital Spell" },
	{ "thedusseldorfconspiracy", "Jessica Plunkenstein and the Düsseldorf Conspiracy" },
	{ "thedwarvendaggerofblitz", "The Dwarven Dagger of Blitz" },
	{ "theelevator", "The Elevator" },
	{ "theenergizer", "The Energizer" },
	{ "theepicadventures", "The epic adventures of Barry" },
	{ "theeverbeginningtale", "The Ever-Beginning Tale" },
	{ "theexecutionofanneboleyn", "The Execution of Anne Boleyn" },
	{ "thefarm", "the farm" },
	{ "theficklehandsoffate", "The Fickle Hands of Fate" },
	{ "thefind", "The Find" },
	{ "thegourmet", "The Gourmet" },
	{ "thegreatcasserolecaper", "The Great Casserole Caper" },
	{ "thegreatstrokeoff", "The Great Stroke-Off!" },
	{ "thegruglegends", "The Grug Legends" },
	{ "thehamlet", "The Hamlet" },
	{ "thehauntedhouse", "The Haunted House" },
	{ "theheist", "The Heist" },
	{ "thehobbitriseofthedragonking", "The Hobbit: Rise of the Dragon King" },
	{ "thehousethatatemysoul", "The house that ate my soul" },
	{ "thehuntforgoldbeard", "The hunt for Goldbeard" },
	{ "thehuntforshaunbinda", "The hunt for Shaun Binda" },
	{ "thehuntforshaunbindadeluxeedition", "The Hunt For Shaun Binda Deluxe Edition" },
	{ "theinfinitystring", "The Infinity String" },
	{ "theiraqiparadox", "The Iraqi Paradox" },
	{ "thejackyard", "The Jackyard" },
	{ "thejourneyhome", "The Journey Home" },
	{ "thejourneyofiesir", "The Journey of Iesir" },
	{ "thelastharvest", "The Last Harvest" },
	{ "thelastsupperawhodunnit", "The Last Supper, A Whodunnit" },
	{ "theloneloser", "The Lone Loser" },
	{ "thelongtrip", "The Long Trip" },
	{ "themajesticconspiracy", "The Majestic Conspiracy" },
	{ "themarionette", "The Marionette" },
	{ "themccarthychronicleschapter1", "The McCarthy Chronicles Chapter 1" },
	{ "themcreedcasebytk", "The McReed Case by TK" },
	{ "themysteriesofstiegomoors", "The Mysteries of Stiego Moors" },
	{ "themysteryofhauntedhollow", "The Mystery of Haunted Hollow" },
	{ "thenetherworld", "The Netherworld" },
	{ "thenextcurse", "The Next Curse" },
	{ "theoracle", "The Oracle" },
	{ "thepaparazziprince", "The Paparazzi Prince; and the Quest for Headlines" },
	{ "thepark", "The Park" },
	{ "theperfectmurder", "The Perfect Murder" },
	{ "thephantominheritance", "The Phantom Inheritance" },
	{ "thequestfortheholysalsa", "The Quest for the Holy Salsa" },
	{ "thequesttozooloo", "The Quest To Zooloo" },
	{ "therail", "The Rail" },
	{ "theroadtomurder", "Laura Bow in The Road to Murder" },
	{ "therobolovers", "The Robolovers" },
	{ "therotaryclub", "The Rotary Club" },
	{ "thesearch", "The Search" },
	{ "thesecretofchunkysalsa", "The Secret of Chunky Salsa" },
	{ "thesecretofgoldenriver", "Fynewrylst Memories: The Secret of Golden River" },
	{ "thesecretofhuttongrammarschool", "The Secret of Hutton Grammar School" },
	{ "thesecretofmountmonkey", "The secret of Mount Monkey" },
	{ "thesecretplan1runningtostandstill", "The Secret Plan 1 - Running to stand still" },
	{ "theshaft", "The Shaft" },
	{ "theshortestjourney", "The Shortest Journey" },
	{ "thesmallestpoints", "The Smallest Points" },
	{ "thesnaplock", "The Snaplock" },
	{ "thespoons", "The Spoons" },
	{ "thestarryskyaboveme", "The Starry Sky Above Me" },
	{ "thesundownmystery", "The Sundown mystery" },
	{ "thethickening", "Reality-on-the-Norm 13:13^2 The Thickening" },
	{ "thetombofthemoon", "The Tomb of the Moon" },
	{ "thetrap", "The Trap" },
	{ "thetreasuredmedallion", "The Treasured Medallion" },
	{ "thetreasureoflochinch", "The Treasure of Loch Inch" },
	{ "theuncertaintymachine", "The Uncertainty Machine" },
	{ "theupliftmofopartyplan", "MI5 Bob: The Uplift Mofo Party Plan" },
	{ "thevacuum", "The Vacuum" },
	{ "thevisitor3", "The Visitor 3" },
	{ "thewitch", "The witch, ..." },
	{ "thisgame", "This Game" },
	{ "threeguyswalkintoheaven", "Three Guys Walk Into Heaven" },
	{ "tilepuzzlegame", "Tile Puzzle Game" },
	{ "tiltor", "Tiltor" },
	{ "timequest1", "Time Quest" },
	{ "timequest2", "Time Quest 2" },
	{ "timesinkofchronos", "Timesink of Chronos" },
	{ "timestone", "Time Stone" },
	{ "timothylande", "Timothy Lande" },
	{ "tmntturtlesintime", "TMNT: Turtles in Time" },
	{ "toffeetrouble", "Toffee Trouble" },
	{ "tomateundescanso", "Tomate un descanso" },
	{ "tomhanksaway", "Tom Hanks Away" },
	{ "toomanykittens", "Too Many Kittens" },
	{ "totalhangoverextreamzz", "Total Hangover ExtreamZz!" },
	{ "totti1", "Totti's missing claw" },
	{ "totti2", "Good Evening Totti" },
	{ "tq", "tq" },
	{ "trappedinabuilding", "Trapped in a building" },
	{ "trevordaisoninouterspace", "Trevor Daison in outer space" },
	{ "trexandmusclesambigtroubleinspf", "Trex and Muscle SAM big trouble in SPF" },
	{ "trilbysnotes", "Trilby's Notes" },
	{ "trilbytheartoftheft", "Trilby: The Art Of Theft" },
	{ "trivialpassyouit", "Trivial Pass You It" },
	{ "trumpsbed", "Shit in Trump's Bed" },
	{ "tvbrder", "Tv? Br?der" },
	{ "twelvethirteense", "Twelve Thirteen Special Edition" },
	{ "twelvethirteen", "Twelve Thirteen, episode 1" },
	{ "twelvethirteenepisode2", "Twelve Thirteen, episode 2" },
	{ "twelvethirteenepisode3", "Twelve Thirteen, episode 3" },
	{ "twentiesflappersvsthemummy", "Twenties Flappers vs The Mummy" },
	{ "twoofakind", "Two of a Kind" },
	{ "ucom", "Bob Smith and the Unsolved Case of Mystery" },
	{ "uglyfiles", "Ugly Files" },
	{ "ulitsadimitrova", "Ulitsa Dimitrova" },
	{ "unbound", "Unbound" },
	{ "underworld", "The Underworld" },
	{ "unfinished", "unfinished" },
	{ "unfinishedtales", "Unfinished Tales (Cuentos Inconclusos)" },
	{ "unganeedsmumba", "UNGA needs MUMBA" },
	{ "unintelligentdesign", "Unintelligent Design" },
	{ "unprofe", "Un Profe" },
	{ "unraveling", "The Tapestry - Chapter 1: The Unraveling" },
	{ "updatequest", "Update Quest" },
	{ "urbanwitchstory", "Urban Witch Story" },
	{ "utopiaoftyrant", "Utopia of Tyrant" },
	{ "vacationquestthing", "Vacation Quest... Thing" },
	{ "valhallaextinction", "Valhalla Extinction" },
	{ "valis", "valis" },
	{ "vankairbreak", "van K. Airbreak" },
	{ "vegetablepatchextreemturbo", "Vegetable Patch Extreem Turbo" },
	{ "veggietales3d", "Veggie Tales 3D" },
	{ "venator", "Venator" },
	{ "veteranshootout", "Veteran shootout" },
	{ "vicwreckleshalloweencostume", "Vic Wreckle's Halloween Costume" },
	{ "virtualpiano", "Virtual Piano" },
	{ "vohaulsrevenge2", "Space Quest XII: Vohaul's Revenge II" },
	{ "voodoodave", "Voodoo Dave and the Tablecloth Mystery" },
	{ "vpxt2", "V P x T ! 2 !" },
	{ "vrrontour", "VR Reality-on-the-Norm Tour " },
	{ "wallyweasel", "The Wacky World of Wally Weasel" },
	{ "waltersasteroid", "Walters-Asteroid" },
	{ "warstars", "War Stars" },
	{ "washedashore", "Washed Ashore" },
	{ "washedashoredeluxe", "Washed Ashore Deluxe" },
	{ "wasted", "Wasted" },
	{ "waterquest", "WATER QUEST" },
	{ "wcedit", "WCEdit..." },
	{ "wearevectors", "We Are Vectors" },
	{ "wegotlost", "I Think We Got Lost" },
	{ "welcometodarklake", "Welcome to Dark Lake" },
	{ "wet", "WET" },
	{ "what", "what!" },
	{ "whatisthatthing", "what is that thing" },
	{ "whatlinusbruckmansees", "What Linus Bruckman Sees" },
	{ "whattimeisit", "Artie Salomon: What time is it?" },
	{ "wherebedragons", "Where Be Dragons?" },
	{ "wheredidsamgo", "Where did Sam go?" },
	{ "wheresmhatma", "Where's M' Hat Ma?" },
	{ "whiskeyweather", "Whiskey Weather" },
	{ "whokilledkennyrogers", "Who Killed Kenny Rogers" },
	{ "whowantstoliveagain", "James Bond - Who wants to live again?" },
	{ "whowantstoliveforever", "Who wants to live forever?" },
	{ "williamsnightmare", "Williams Nightmare" },
	{ "willowhouse", "Willow House" },
	{ "winnersdontdodrugs", "Winners Don't Do Drugs" },
	{ "winterrose", "Winter Rose" },
	{ "witch", "Witch" },
	{ "witchnight", "Witch Night" },
	{ "witchron", "Witch!" },
	{ "withoutaprayer", "Without a Prayer" },
	{ "witness", "Witness!" },
	{ "wizardhood", "Wizardhood" },
	{ "woo", "Woo" },
	{ "woolyrockbottom", "Wooly Rockbottom" },
	{ "worldofwarcraftquest", "World of Warcraft Quest" },
	{ "worm", "Worm" },
	{ "wrathofthesolonoids", "Wrath of the Solonoids" },
	{ "yoda", "Yoda" },
	{ "yourlate", "9 Minutes! Your late!" },
	{ "zakrepixeled", "Zak McKracken and the Alien Mindbenders - repixeled" },
	{ "zak2", "The New Adventures of Zak McKracken" },
	{ "zombieattack", "Zombie Attack" },
	{ "zombiefish", "Zombie Fish" },
	{ "zooreal", "ZooReal" },
	{ "zugzwang", "Zugzwang" },

	{ 0, 0 }
};

const char *const PRE_25 = "Pre 2.5";

#define DETECTION_ENTRY_GUIO(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, GUIO, PLUGIN_ARR, FLAGS) \
	{{ ID, PLATFORM, AD_ENTRY1s(FILENAME, MD5, SIZE), LANG, \
	Common::kPlatformUnknown, FLAGS, GUIO }, PLUGIN_ARR }

#define DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, PLUGIN_ARR, FLAGS) \
	DETECTION_ENTRY_GUIO(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, GUIO1(GUIO_NOLANG), PLUGIN_ARR, FLAGS)


#define PRE_25_ENTRY(ID, FILENAME, MD5, SIZE) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "Pre 2.5", nullptr, ADGF_UNSTABLE)

#define PRE_25_ENTRY_LANG(ID, FILENAME, MD5, SIZE, LANG) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, LANG, "Pre 2.5", nullptr, ADGF_UNSTABLE)

#define PRE_25_DEMO_ENTRY(ID, FILENAME, MD5, SIZE) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "Pre 2.5 Demo", nullptr, ADGF_UNSTABLE | ADGF_DEMO)

#define PRE_25_DEMO_ENTRY_LANG(ID, FILENAME, MD5, SIZE, LANG) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, LANG, "Pre 2.5 Demo", nullptr, ADGF_UNSTABLE | ADGF_DEMO)

#define UNSUPPORTED_ENTRY(ID, FILENAME, MD5, SIZE, LANG, PLATFORM) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, nullptr, ADGF_UNSTABLE)

#define UNSUPPORTED_DEMO_ENTRY(ID, FILENAME, MD5, SIZE) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "Demo", nullptr, ADGF_UNSTABLE | ADGF_DEMO)

#define UNSUPPORTED_GAME_ENTRY(ID, FILENAME, MD5, SIZE) \
	UNSUPPORTED_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, nullptr)


#define TESTING_ENTRY(ID, FILENAME, MD5, SIZE, LANG, PLATFORM) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, nullptr, ADGF_TESTING)

#define STABLE_ENTRY(ID, FILENAME, MD5, SIZE, LANG, PLATFORM) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, nullptr, ADGF_NO_FLAGS)

#define DEMO_ENTRY(ID, FILENAME, MD5, SIZE) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "Demo", nullptr, ADGF_DEMO)

#define DEMO_ENTRY_LANG(ID, FILENAME, MD5, SIZE, LANG) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, LANG, "Demo", nullptr, ADGF_DEMO)

#define GAME_ENTRY(ID, FILENAME, MD5, SIZE) \
	STABLE_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, nullptr)

#define GAME_ENTRY_LANG(ID, FILENAME, MD5, SIZE, LANG) \
	STABLE_ENTRY(ID, FILENAME, MD5, SIZE, LANG, nullptr)

#define GAME_ENTRY_STEAM(ID, FILENAME, MD5, SIZE) \
	STABLE_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "Steam")

#define GAME_ENTRY_GOG(ID, FILENAME, MD5, SIZE) \
	STABLE_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "GOG")

#define GAME_ENTRY_PLATFORM(ID, FILENAME, MD5, SIZE, PLATFORM) \
	STABLE_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, PLATFORM)


#define STABLE_ENTRY_PLUGIN(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, PLUGIN_ARR) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, PLUGIN_ARR, ADGF_NO_FLAGS)

#define STABLE_ENTRY_PLUGIN_GUIO(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, GUIO, PLUGIN_ARR) \
	DETECTION_ENTRY_GUIO(ID, FILENAME, MD5, SIZE, LANG, PLATFORM, GUIO, PLUGIN_ARR, ADGF_NO_FLAGS)

#define DEMO_ENTRY_PLUGIN(ID, FILENAME, MD5, SIZE, PLUGIN_ARR) \
	DETECTION_ENTRY(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "Demo", PLUGIN_ARR, ADGF_DEMO)

#define GAME_ENTRY_PLUGIN_STEAM(ID, FILENAME, MD5, SIZE, PLUGIN_ARR) \
	STABLE_ENTRY_PLUGIN(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "Steam", PLUGIN_ARR)

#define GAME_ENTRY_PLUGIN_GOG(ID, FILENAME, MD5, SIZE, PLUGIN_ARR) \
	STABLE_ENTRY_PLUGIN(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "GOG", PLUGIN_ARR)

#define GAME_ENTRY_PLUGIN_STEAM_NOLAUNCHLOAD(ID, FILENAME, MD5, SIZE, PLUGIN_ARR) \
STABLE_ENTRY_PLUGIN_GUIO(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "Steam", GUIO2(GUIO_NOLANG, GUIO_NOLAUNCHLOAD), PLUGIN_ARR)

#define GAME_ENTRY_PLUGIN_GOG_NOLAUNCHLOAD(ID, FILENAME, MD5, SIZE, PLUGIN_ARR) \
STABLE_ENTRY_PLUGIN_GUIO(ID, FILENAME, MD5, SIZE, Common::UNK_LANG, "GOG", GUIO2(GUIO_NOLANG, GUIO_NOLAUNCHLOAD), PLUGIN_ARR)

static const PluginVersion AGSTEAM_WADJETEYE[] = { { "agsteam", kWadjetEye }, { nullptr, 0 } };
static const PluginVersion AGS_FLASHLIGHT[] = { { "agsflashlight", 0 }, { nullptr, 0 } };
static const PluginVersion AGSSPRITEFONT_CLIFFTOP[] = { { "agsspritefont", kClifftopGames }, { nullptr, 0 } };


const AGSGameDescription GAME_DESCRIPTIONS[] = {
	// Pre-2.5 games that aren't supported by the current AGS engine
	PRE_25_DEMO_ENTRY("achristmastale", "tale.exe", "094135f05cf14fc3903e0d3697911a4e", 1484122),
	PRE_25_DEMO_ENTRY("adventuregame", "adventure.exe", "221637e5d62e2ca3cc146846ab0b2e49", 5533207),
	PRE_25_DEMO_ENTRY("anotherrpg", "zombie.exe", "fc5f54dcfc82d3b991f670490a316958", 2697235),
	PRE_25_DEMO_ENTRY("bobsquest2", "bq2.exe", "1c21bdb52bcafcafe988b30fd6bb4126", 2540006),
	PRE_25_DEMO_ENTRY("castlequest", "castle.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 1494036),  // DOS
	PRE_25_DEMO_ENTRY("castlequest", "castle.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 1792104),  // Windows
	PRE_25_DEMO_ENTRY("cosmos", "ac2game.dat", "73e5b8276f3d0a2ab7077c03c24fb16e", 993845),
	PRE_25_DEMO_ENTRY("damnthatspill", "SPILL.exe", "6026f2bae1609882ae6f19f4de293786", 1903003),
	PRE_25_DEMO_ENTRY("deepbright", "tc.exe", "8f80c91d160e333ab7f6be5208ea0533", 3022557),
	PRE_25_DEMO_ENTRY("defsrpgdemo", "GAMEE.exe", "fc5f54dcfc82d3b991f670490a316958", 3952616),
	PRE_25_DEMO_ENTRY("dirkchafberg", "ac2game.dat", "be7bec4a433beb5085184b64119351c8", 1906822),
	PRE_25_DEMO_ENTRY("domjohnson", "TIMMY.exe", "89f304332b7bd02ed62f754a3b53f129", 6413032),
	PRE_25_DEMO_ENTRY("edgeofreality", "EDGEOF.exe", "1c21bdb52bcafcafe988b30fd6bb4126", 7428333),
	PRE_25_DEMO_ENTRY("edsgravedigger", "dig1.exe", "426e34f40e0dc5285af3fb5fc32a220e", 8060324),
	PRE_25_DEMO_ENTRY("elburro", "burro.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 1858196),
	PRE_25_DEMO_ENTRY("elburro", "burro.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 2209309),
	PRE_25_DEMO_ENTRY("equallyinsane", "EIDemo.exe", "deff766b7e64dd84edf20666a278fa1d", 1641841),
	PRE_25_DEMO_ENTRY("exodus", "EXODUS.exe", "8e3cad1439a1d3336e721b1918a20704", 5107192),
	PRE_25_DEMO_ENTRY("eyesofthejadesphinx", "jade.exe", "f2fe94ab604612e4595f3c79b0245529", 10763660),
	PRE_25_DEMO_ENTRY("fatman", "FATMAN1.exe", "07f9921784124d9e09f39bb831e06131", 800643),
	PRE_25_DEMO_ENTRY("firewall", "firewall demo.exe", "2fd8ca69f236ae1ad46edab4ba26a33d", 2839412),
	DETECTION_ENTRY("fountainofyouth", "FOY.exe", "04eedea9846d380d6d9a120f657daa43", 1206580, Common::UNK_LANG, "Pre 2.5 Preview", nullptr, ADGF_UNSTABLE | ADGF_DEMO),
	DETECTION_ENTRY("fountainofyouth", "rollinfoy.exe", "19f4045333d9c823a5439d0447d55985", 3454107, Common::UNK_LANG, "Pre 2.5 Rolling Demo", nullptr, ADGF_UNSTABLE | ADGF_DEMO),
	PRE_25_DEMO_ENTRY("gorthor", "fart.exe", "fc5f54dcfc82d3b991f670490a316958", 1138006),
	PRE_25_DEMO_ENTRY("grandfathertreasure", "GRANDPA.EXE", "9ef5bffe7b85377751c25af806345794", 2295917),
	PRE_25_DEMO_ENTRY("helmsuntitled", "EXAMPLE.EXE", "9ef5bffe7b85377751c25af806345794", 1920895),
	PRE_25_DEMO_ENTRY("huckleburyhippie", "HippieDemo.exe", "07f9921784124d9e09f39bb831e06131", 823186),
	PRE_25_DEMO_ENTRY("ijuntitled", "PI.exe", "80bdce9a1052e896c7cba6a4334cecce", 3562650),
	PRE_25_DEMO_ENTRY("inadream", "INADREAM.exe", "1bccd2edef19abc99e9683519d80c0e0", 2257400),
	PRE_25_DEMO_ENTRY("islandquest", "IslandQ.exe", "fc5f54dcfc82d3b991f670490a316958", 2089405),
	DETECTION_ENTRY("kinkyisland", "kinky.exe", "04eedea9846d380d6d9a120f657daa43", 2281415, Common::UNK_LANG, "Pre 2.5 Rolling Demo", nullptr, ADGF_UNSTABLE | ADGF_DEMO),  //Win
	DETECTION_ENTRY("kinkyisland", "kinky.exe", "19f4045333d9c823a5439d0447d55985", 5437534, Common::UNK_LANG, "Pre 2.5 Rolling Demo", nullptr, ADGF_UNSTABLE | ADGF_DEMO),  //DOS
	PRE_25_DEMO_ENTRY("larryvales3", "burns.exe", "094135f05cf14fc3903e0d3697911a4e", 2120885),
	PRE_25_DEMO_ENTRY("miagsremake", "MIDEMO.exe", "ed778afb4f46c3f2a70d330532a83a2f", 1078492),
	PRE_25_DEMO_ENTRY("nicholaswolfe1", "nw1demo.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 1539596),
	PRE_25_DEMO_ENTRY("pointblank", "future.exe", "385a593828b1edb194e984ce55cda65e", 1379714),
	PRE_25_DEMO_ENTRY("ronbeachparty", "BEACH.exe", "04eedea9846d380d6d9a120f657daa43", 3623974),
	PRE_25_DEMO_ENTRY("ronxmas2002", "XMAS.exe", "9027912819f3a319ed9de0fd855310c3", 4056155),
	PRE_25_DEMO_ENTRY("testicle", "TESTICLE.exe", "094135f05cf14fc3903e0d3697911a4e", 948186),
	PRE_25_DEMO_ENTRY("uishowoff", "pd.exe", "ecd0793124fbc9b89c6d11162e3b5851", 3853394),
	PRE_25_DEMO_ENTRY("waitkey", "ac2game.dat", "8ddf3744922101e33305dfcd06e3b682", 445197),
	PRE_25_DEMO_ENTRY("whattimeisit", "WTII.exe", "8b21668ca462b0b6b35df43c5902b074", 1826322),  // 2001-08-01
	PRE_25_DEMO_ENTRY("whattimeisit", "ac2game.dat", "e016cb68731d0e38fe97905dbf0d5b36", 4451529),  // 2002-02-03
	PRE_25_DEMO_ENTRY("zakagsremake", "zak.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 2337860),
	PRE_25_ENTRY("6da", "6da.exe", "9027912819f3a319ed9de0fd855310c3", 1608073),
	PRE_25_ENTRY("aaronsepicjourney", "aaron.exe", "1c21bdb52bcafcafe988b30fd6bb4126", 1788404),
	PRE_25_ENTRY("aceduswell", "ace.exe", "be48a6b0b81a71d34a41930623c065f1", 3103822),
	PRE_25_ENTRY("adayinthefuture", "space.exe", "ecd0793124fbc9b89c6d11162e3b5851", 4120328),
	PRE_25_ENTRY("agsbgeditor", "AGSBGEDI.exe", "a9fbf05df479ca7e7dbd67d9bbd149d9", 1322728),
	PRE_25_ENTRY("aliengame", "platform.exe", "f4585823c1b4ce97d78c8acb433bec52", 2680383),
	PRE_25_ENTRY("asapadventure", "asap.exe", "8f80c91d160e333ab7f6be5208ea0533", 1405072),
	PRE_25_ENTRY("barnrunner1p1", "eclair 1.exe", "9fa0358760f1f1bffddd080532f586f0", 1864283),
	PRE_25_ENTRY("barnrunner1p2", "eclair 2.exe", "9fa0358760f1f1bffddd080532f586f0", 5644093),
	PRE_25_ENTRY("bertthenewsreader", "bert.exe", "80bdce9a1052e896c7cba6a4334cecce", 2814934),
	PRE_25_ENTRY("billybobwildnight", "TheWildNight.exe", "426e34f40e0dc5285af3fb5fc32a220e", 1925403),
	PRE_25_ENTRY("blackjack", "blackjack.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 1153092),
	PRE_25_ENTRY("blastoff", "BlastOff.exe", "8f80c91d160e333ab7f6be5208ea0533", 2043203),
	PRE_25_ENTRY("blastoff", "BlastOff-Win.exe", "727a30f9244441ad57a76086f4faa779", 2409275),
	PRE_25_ENTRY("bluecupontherun", "ac2game.dat", "c290455f00f630c8a52c7eceb7c663eb", 1995708),
	PRE_25_ENTRY("bookofspells1", "ac2game.dat", "fe66cb08bcffd094c159cd4ee72bacd3", 3442073),
	PRE_25_ENTRY("bookofspells2", "ac2game.dat", "9df87a8e5bbcc7206b001c0b8316b7f9", 3263169),
	PRE_25_ENTRY("bookofspells3", "ac2game.dat", "9f0181393bdceb2c0bbdb06634714023", 4806518),
	PRE_25_ENTRY("cabbagesandkings", "FAL.exe", "9027912819f3a319ed9de0fd855310c3", 2836668),  // v1.0
	PRE_25_ENTRY("calsoon", "calsoon.exe", "5477f4ed8f860427d1492548b677073c", 2865508),
	PRE_25_ENTRY("candy", "CANDY.exe", "1c21bdb52bcafcafe988b30fd6bb4126", 1155013),
	PRE_25_ENTRY("captainmuchly", "bleach.exe", "9027912819f3a319ed9de0fd855310c3", 1174829),
	PRE_25_ENTRY("carverisland1", "secret.exe", "8f80c91d160e333ab7f6be5208ea0533", 3116071),
	PRE_25_ENTRY("carverisland2", "carver2.exe", "ed778afb4f46c3f2a70d330532a83a2f", 6265594),
	PRE_25_ENTRY("chef", "CHEF.exe", "04eedea9846d380d6d9a120f657daa43", 11556768),
	PRE_25_ENTRY("commanderkeenron", "KEENRON.exe", "9027912819f3a319ed9de0fd855310c3", 2061720),
	PRE_25_ENTRY("compensation", "comp.exe", "094135f05cf14fc3903e0d3697911a4e", 2054366),
	PRE_25_ENTRY("crimetime", "crimetim.exe", "be48a6b0b81a71d34a41930623c065f1", 1303660),
	PRE_25_ENTRY("cutlass", "ac2game.dat", "ba6eb93c31cd78a18448ddea70836c5e", 985175),
	PRE_25_ENTRY("darksects", "ac2game.dat", "b2923f9cdad3b11898a6b5c5b014c5db", 9886156),
	PRE_25_ENTRY("darts", "dart.exe", "ed778afb4f46c3f2a70d330532a83a2f", 736848),
	PRE_25_ENTRY("davyjonescestmort", "RONDDJ.exe", "c90241861523a2ed0f2f6e68fb0f0661", 2456690),
	PRE_25_ENTRY("davyjonesisback", "RONDJR.exe", "9027912819f3a319ed9de0fd855310c3", 2817715),
	PRE_25_ENTRY("defenderofron", "SUPRPHIL.EXE", "9027912819f3a319ed9de0fd855310c3", 4387452),
	PRE_25_ENTRY("demonslayer1", "mags.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 3820347),
	PRE_25_ENTRY("demonslayer2", "bert.exe", "0c057c5e6df6f45772286986ab7b7a5b", 1726766),
	PRE_25_ENTRY("demonslayer3", "tiler.exe", "426e34f40e0dc5285af3fb5fc32a220e", 2586532),
	PRE_25_ENTRY("demonslayer4", "dem four.exe", "426e34f40e0dc5285af3fb5fc32a220e", 5110674),
	PRE_25_ENTRY("earwigisangry", "earwig.exe", "04eedea9846d380d6d9a120f657daa43", 2371856),
	PRE_25_ENTRY("edgeofreality", "edgeof.exe", "1c21bdb52bcafcafe988b30fd6bb4126", 46706875),
	PRE_25_ENTRY("erniesbigadventure1", "magsjune.exe", "fc5f54dcfc82d3b991f670490a316958", 8814849),
	PRE_25_ENTRY("erniesbigadventure2", "magsjuly.exe", "2fd8ca69f236ae1ad46edab4ba26a33d", 6647578),
	PRE_25_ENTRY("erniesbigadventure2", "magsjuly.exe", "2fd8ca69f236ae1ad46edab4ba26a33d", 6647578),
	PRE_25_ENTRY_LANG("everythingeuro", "EURO.EXE", "8e3cad1439a1d3336e721b1918a20704", 1923920, Common::DE_DEU),  // DOS Deu
	PRE_25_ENTRY_LANG("everythingeuro", "EURO.EXE", "8e3cad1439a1d3336e721b1918a20704", 1918371, Common::EN_ANY),  // DOS Eng
	PRE_25_ENTRY("exile", "exile.exe", "aad0a09714fab4de51e5488da48fd5d4", 13421451),
	PRE_25_ENTRY("faddevil", "FAD.EXE", "094135f05cf14fc3903e0d3697911a4e", 1730090),
	PRE_25_ENTRY("floyd", "floyd.exe", "9ef5bffe7b85377751c25af806345794", 5477588),
	PRE_25_ENTRY("fowlplay", "RON2HALF.EXE", "727a30f9244441ad57a76086f4faa779", 2416233),
	PRE_25_ENTRY("gaeafallen", "gaea_fallen.exe", "80bdce9a1052e896c7cba6a4334cecce", 11273205),
	PRE_25_ENTRY("grannyzombiekiller", "mags.exe", "0c057c5e6df6f45772286986ab7b7a5b", 12855495),
	PRE_25_ENTRY("gregsmountainousadventure", "mags.exe", "80a17966fc547849d43646acf89de296", 2112993),
	PRE_25_ENTRY("greysgreytadv", "greywin.exe", "80bdce9a1052e896c7cba6a4334cecce", 1283447),
	PRE_25_ENTRY("henkkaquest", "Henkka.exe", "04eedea9846d380d6d9a120f657daa43", 1843411),
	PRE_25_ENTRY("hermit", "hermit.exe", "4689069dd6b241e38311d0586e610a8d", 13995403),
	PRE_25_ENTRY("hiphendrix", "hendrix.exe", "094135f05cf14fc3903e0d3697911a4e", 711944),
	PRE_25_ENTRY("hookymcp", "HMPP.exe", "e59a532ee3d6686fdcabf498e180b635", 3812053),
	PRE_25_ENTRY("housequest", "HouseQuest.exe", "6988ee3c2dd1cda50d49a12317801c08", 2897790),
	PRE_25_ENTRY("indysecretchamber", "indy.exe", "094135f05cf14fc3903e0d3697911a4e", 1545150),
	PRE_25_ENTRY("intergalacticlife", "INTERLIFE.exe", "9027912819f3a319ed9de0fd855310c3", 2226509),
	PRE_25_ENTRY("invasionspacealiens", "reality.exe", "426e34f40e0dc5285af3fb5fc32a220e", 2001118),
	PRE_25_ENTRY("islandquest", "IslandQ.exe", "80bdce9a1052e896c7cba6a4334cecce", 5220070),
	PRE_25_ENTRY("ispy", "SPY.exe", "8f80c91d160e333ab7f6be5208ea0533", 2864744), //v2
	PRE_25_ENTRY("ispy", "ac2game.dat", "f93fcb017856b28d8ee509e58d91a838", 2509569), //v3
	PRE_25_ENTRY("ispy2", "ISPY2.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 3028482), //v1
	PRE_25_ENTRY("jamesbondage", "jbdos.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 2056737),
	PRE_25_ENTRY("javajo", "Java Jo's Koffee Stand!.exe", "0e4b0d6c14177a94218619b8c8e60a15", 1623899),
	PRE_25_ENTRY("jinglebells", "jinglebells.exe", "385a593828b1edb194e984ce55cda65e", 1620588),
	PRE_25_ENTRY("kittensandcacti", "KAC.exe", "9027912819f3a319ed9de0fd855310c3", 5739433),
	PRE_25_ENTRY("kidnapped", "ac2game.dat", "27daca01ccbbbaf02bf6b4b85d5990b4", 1205017),
	PRE_25_ENTRY("larryvales1", "larryvtd.exe", "610b7a3d1fd90f24d2218aa26b29d8ca", 3129645),
	PRE_25_ENTRY("larryvales2", "dead.exe", "be48a6b0b81a71d34a41930623c065f1", 3946993),
	PRE_25_ENTRY("lassi", "lassi.exe", "ed778afb4f46c3f2a70d330532a83a2f", 3681914),
	PRE_25_ENTRY("lassiandrogermeetgod", "mtg.exe", "ed778afb4f46c3f2a70d330532a83a2f", 1618544),
	PRE_25_ENTRY("lassiquest1", "lassi.exe", "c391c6676099032440b206189babe76e", 1700368),
	PRE_25_ENTRY("littlejonnyevil", "lje.exe", "e93037e8efc7abc19b8978903ef5b409", 2133182),
	PRE_25_ENTRY("littlewillie", "ac2game.dat", "239b11ab644222c67d981494766a3c25", 254128),
	PRE_25_ENTRY("losttreasureron", "LTRON.exe", "e59a532ee3d6686fdcabf498e180b635", 2274645),
	PRE_25_ENTRY("ludwig", "ludwig.exe", "727a30f9244441ad57a76086f4faa779", 3658869),
	PRE_25_ENTRY("lunchtimeofthedamned", "reality.exe", "dd69243e3cc9e955215e0d556301b58e", 1357955),
	PRE_25_ENTRY("lupoinutile", "lupo.exe", "19f4045333d9c823a5439d0447d55985", 1856459),
	PRE_25_ENTRY("magsceremony2001jul", "MAGS002.exe", "094135f05cf14fc3903e0d3697911a4e", 1821625),
	PRE_25_ENTRY("magsceremony2001jun", "MAGS001.exe", "094135f05cf14fc3903e0d3697911a4e", 1698160),
	PRE_25_ENTRY("meninbrown", "0112.men in brown.exe", "426e34f40e0dc5285af3fb5fc32a220e", 2072392),
	PRE_25_ENTRY("midtownshootout", "mtsowin.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 1076035),
	PRE_25_ENTRY("mikasdream", "MIKASDREAM.exe", "9027912819f3a319ed9de0fd855310c3", 5858215),
	PRE_25_ENTRY("momsquest", "mom's quest.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 3173896),
	PRE_25_ENTRY("monkeyplank", "plank.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 815948),
	PRE_25_ENTRY("montyonthenorm", "Monty.exe", "89f304332b7bd02ed62f754a3b53f129", 1663257),  // original DOS version
	PRE_25_ENTRY("moose", "moose.exe", "f4585823c1b4ce97d78c8acb433bec52", 1448684),
	PRE_25_ENTRY("moosewars", "moose.exe", "f4585823c1b4ce97d78c8acb433bec52", 1448684),
	PRE_25_ENTRY("murder", "murder.exe", "221637e5d62e2ca3cc146846ab0b2e49", 935799),
	PRE_25_ENTRY("nightoftheplumber", "night of the plumber.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 1703896),
	PRE_25_ENTRY("nightwatch", "NIGHTWATCH.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 2616586),
	PRE_25_ENTRY("nihilism", "RONcm.exe", "c90241861523a2ed0f2f6e68fb0f0661", 1853822),
	PRE_25_ENTRY("novomestro", "novo.exe", "07f9921784124d9e09f39bb831e06131", 1122507),
	PRE_25_ENTRY("odysseus", "odysseus.exe", "426e34f40e0dc5285af3fb5fc32a220e", 2799113), // Windows
	PRE_25_ENTRY("odysseus", "odysseus.exe", "00dce98d598e9b7ad3c6674bfd4880d9", 2570368), // DOS
	PRE_25_ENTRY("paranormalinvestigation", "RONPI.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 2994116),  // original DOS version
	PRE_25_ENTRY("permanentdaylight", "daylight.exe", "07f9921784124d9e09f39bb831e06131", 1799958),
	PRE_25_ENTRY("perpetrator", "ac2game.dat", "56ef979be112e122e24d0cc8caea4ea4", 994303),
	PRE_25_ENTRY("pizzaquest", "pqwin.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 2500089),
	PRE_25_ENTRY("pornquest", "porn.exe", "04eedea9846d380d6d9a120f657daa43", 1012323),
	PRE_25_ENTRY("postmanonlydiesonce", "Postman.exe", "fc5f54dcfc82d3b991f670490a316958", 7187159),  // Windows
	PRE_25_ENTRY("postmanonlydiesonce", "Post.exe", "f2fe94ab604612e4595f3c79b0245529", 6726601),  // DOS
	PRE_25_ENTRY("qfc", "qfc.exe", "04eedea9846d380d6d9a120f657daa43", 2038696),
	PRE_25_ENTRY("qfg412", "qfg.exe", "8b21668ca462b0b6b35df43c5902b074", 26674790),
	PRE_25_ENTRY("qfg412", "qfg.exe", "9027912819f3a319ed9de0fd855310c3", 26954823),
	PRE_25_ENTRY("racingmanager", "raceman.exe", "465f972675db2da6040518221af5b0ba", 15971689),
	PRE_25_ENTRY("raymondskeys", "keys.exe", "e016cb68731d0e38fe97905dbf0d5b36", 1032178),
	PRE_25_ENTRY("red", "red.exe", "be48a6b0b81a71d34a41930623c065f1", 1101194),
	PRE_25_ENTRY("repossessor", "repossessor.exe", "1f0edcb7fa3f8e2b1dd60fa6c0bce60f", 2906801),  // original DOS version
	PRE_25_ENTRY("returnofdvs", "reality.exe", "1c21bdb52bcafcafe988b30fd6bb4126", 2703414),
	PRE_25_ENTRY("richardlonghurst", "rlbat-win.exe", "04eedea9846d380d6d9a120f657daa43", 7935723),
	PRE_25_ENTRY("ripp", "ripp.exe", "426e34f40e0dc5285af3fb5fc32a220e", 10489586),
	PRE_25_ENTRY("robblanc1", "ac2game.dat", "29c2ced2f2e6ad764e4249b4e4c45bba", 920415),
	PRE_25_ENTRY("robblanc1", "rb.exe", "426e34f40e0dc5285af3fb5fc32a220e", 1804361), // v1.2
	PRE_25_ENTRY("robblanc2", "ac2game.dat", "dd6c52e5a6e9b70efef4654769f11c69", 2056386),
	PRE_25_ENTRY("robblanc2", "rb2.exe", "426e34f40e0dc5285af3fb5fc32a220e", 2973290), // v1.2
	PRE_25_ENTRY("robblanc3", "ac2game.dat", "8f8264de3c1bd91e26b84fe37fb5e53e", 2828959),
	PRE_25_ENTRY("robblanc3", "rb3.exe", "426e34f40e0dc5285af3fb5fc32a220e", 3783355), // v1.2
	PRE_25_ENTRY("rodekill", "rodekill.exe", "72f3c950b4d9d14580a11db885a63310", 11995954),
	PRE_25_ENTRY("rodequest", "rodequest1.exe", "72f3c950b4d9d14580a11db885a63310", 1196458),
	PRE_25_ENTRY("samthepiratemonkey", "monkey.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 1401414),
	PRE_25_ENTRY("sma1", "moonsdt.exe", "9027912819f3a319ed9de0fd855310c3", 1276725),
	PRE_25_ENTRY("slackerquest", "ac2game.dat", "e0998f2d2e14a55aae2291fdfab1ce7d", 1306492),
	PRE_25_ENTRY("snailquest1", "snailquest.exe", "dd69243e3cc9e955215e0d556301b58e", 1095860),
	PRE_25_ENTRY("snailquest2", "sq2.exe", "1bccd2edef19abc99e9683519d80c0e0", 955614),
	PRE_25_ENTRY("snailquest3", "sq3.exe", "1bccd2edef19abc99e9683519d80c0e0", 1501892),
	PRE_25_ENTRY("sol", "sol.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 4702799),
	PRE_25_ENTRY("sovietunionstrikesback", "ac2game.dat", "565953ecb1a69a31439ff33b00c539bb", 1062670),
	PRE_25_ENTRY("space", "space.exe", "094135f05cf14fc3903e0d3697911a4e", 3790026),
	PRE_25_ENTRY("stickmen", "stickmen.exe", "094135f05cf14fc3903e0d3697911a4e", 2145142),
	PRE_25_ENTRY("superdisk", "superdisk.exe", "80bdce9a1052e896c7cba6a4334cecce", 1304065),
	PRE_25_ENTRY("teamwork", "teamwork.exe", "538274077115c6d8b4a0927dd3cceeac", 1096149),
	PRE_25_ENTRY("thecrownofgold", "the crown of gold.exe", "e407143be000e44f113ba5ff1fbd17f9", 1971515),
	PRE_25_ENTRY("theinexperiencedassassin", "assassin.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 2659741),
	PRE_25_ENTRY("theisland", "island.exe", "e93037e8efc7abc19b8978903ef5b409", 1814801),
	PRE_25_ENTRY("thendor", "ac2game.dat", "b9c2ad76574c08bbcfd56eb1b49d2cd3", 8580708),
	PRE_25_ENTRY("thetower", "thetower.exe", "9027912819f3a319ed9de0fd855310c3", 3431385),
	PRE_25_ENTRY("thewarp", "warp.exe", "9027912819f3a319ed9de0fd855310c3", 881957),
	PRE_25_ENTRY("tommato", "tom mato's grand wing-ding.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 2735158),
	PRE_25_ENTRY("tulliesworld1", "candale.exe", "1c21bdb52bcafcafe988b30fd6bb4126", 3936603),
	PRE_25_ENTRY("tvquest", "mags.exe", "fc5f54dcfc82d3b991f670490a316958", 1318019),
	PRE_25_ENTRY("underworld", "UNDERWORLD.exe", "2fd8ca69f236ae1ad46edab4ba26a33d", 14661243),
	PRE_25_ENTRY("universalequalizer", "RON - The Universal Equaliser.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 1167105),
	PRE_25_ENTRY("vengeanceofthechicken", "chicken.exe", "6026f2bae1609882ae6f19f4de293786", 1808436),
	PRE_25_ENTRY("whokilledkennyrogers", "mags.exe", "ed778afb4f46c3f2a70d330532a83a2f", 1240103),
	PRE_25_ENTRY("winfry", "fry.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 4164041),

	// Post 2.5 games that aren't currently supported
	// uses unsupported agslua plugin
	UNSUPPORTED_GAME_ENTRY("allthewaydown", "deepuns3.exe", "6c0b5468657c22d62201e3769cd8d2b3", 29830067),
	UNSUPPORTED_GAME_ENTRY("barelyfloating", "Barely Floating.exe", "60fbd60394e3616920325eab6eef567c", 1283262682),
	// Commercial game that likely uses custom extensions. Not only does it seem
	// to use AGSController plugin built-in, even when I hooked up AGSController for
	// the stand-alone AGS 3.5 interpreter, it hangs just like in ScummVM
	UNSUPPORTED_GAME_ENTRY("untilihaveyou", "until i have you.exe", "cda1d7e36993dd55ba5513c1c43e5b2b", 1089857773), // Steam
	UNSUPPORTED_GAME_ENTRY("untilihaveyou", "until i have you.exe", "cda1d7e36993dd55ba5513c1c43e5b2b", 1072879555),
	// 2.55 game, but uses a plugin agsflashlight. Also, even with AGS interpreter
	// hacked to specify plugin, errors on loading room107 saying that
	// "room animations are no longer supported"
	UNSUPPORTED_GAME_ENTRY("zak2", "Zak2.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 8686711),
	UNSUPPORTED_GAME_ENTRY("zak2", "Zak2.exe", "0b7529a76f38283d6e850b8d56526fc1", 9205143),

	// AGDI games. They get their own grouping because they're just that awesome
	GAME_ENTRY("kq1agdi", "kqvga.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 34298679),  // 1.0
	GAME_ENTRY("kq1agdi", "kqvga.exe", "73f87b30f84e9c34ab09ec8dd7ae109d", 34922340),  // 2.0
	GAME_ENTRY("kq1agdi", "kqvga.exe", "888e2976e6659963af15df151b846540", 27083389),  // 3.0
	GAME_ENTRY("kq1agdi", "kq1vga.exe", "688f1807c9d8df26fc0f174dc756054e", 8278611),  // 4.1c
	GAME_ENTRY("kq1agdi", "kq1vga.exe", "4e590490776aea10db84db4a92e1c1bb", 8226850),
	GAME_ENTRY("kq2agdi", "kq2vga.exe", "308d35bc34e9df29d8acce615593e3e7", 64947213),  // 1.0
	GAME_ENTRY("kq2agdi", "kq2vga.exe", "3ee3a0166357ac37836f8908a371f2dc", 65743584),  // 2.0
	GAME_ENTRY("kq2agdi", "kq2vga.exe", "40cfb7563df7dacf6530b19289a4745b", 12563246),	// 3.1
	GAME_ENTRY("kq2agdi", "kq2vga.exe", "40cfb7563df7dacf6530b19289a4745b", 12574643),  // 3.1c
	GAME_ENTRY("kq2agdi", "kq2vga.exe", "43e6294f8bfbba8a3f754fa742353845", 12507938),
	GAME_ENTRY("kq2agdi", "Kq2vgaEsp.exe", "f964e5cb4d339432dd0302d67eb11105", 2490368), // Spanish transalation
	GAME_ENTRY("kq3agdi", "kq3redux.exe", "4c2ea3f7b4974509c59546ca8761b040", 11890197),  // 1.0
	GAME_ENTRY("kq3agdi", "kq3redux.exe", "e569fb2ceabdc4a1609348c23ebc0821", 11986266),  // 1.1
	GAME_ENTRY("qfg2agdi", "qfg2vga.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 20523688),  // 1.1
	GAME_ENTRY("qfg2agdi", "qfg2vga.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 20470902),
	GAME_ENTRY("qfg2agdi", "qfg2vga.exe", "582e26533cf784011c7565e89905d3c4", 18224373),
	GAME_ENTRY("qfg2agdi", "game.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5408433),

	// Infamous Adventures games. Likewise
	GAME_ENTRY("kq3vga", "kq3.exe", "f120690b506dd63cd7d1112ea6af2f77", 4844298),  // 1.0 was kq3agdi
	GAME_ENTRY("kq3vga", "KQ3.exe", "f120690b506dd63cd7d1112ea6af2f77", 5883843),  // current version from the download site
	GAME_ENTRY("kq3vga", "ac2game.dat", "f120690b506dd63cd7d1112ea6af2f77", 5883843), // current mac version from the download site
	GAME_ENTRY("sq2fg", "sq2fg.exe", "a524cbb1c51589903c4043b98917f1d9", 5329030),
	GAME_ENTRY("sq2vga", "sq2vga.exe", "bdaf20d9779c01986d6d8b7e1d6118ee", 106094482),  // 1.0
	GAME_ENTRY("sq2vga", "sq2vga.exe", "bdaf20d9779c01986d6d8b7e1d6118ee", 117200044),  // 1.1
	GAME_ENTRY("sq2vga", "sq2vga_v2.exe", "28a946e8a278814362613f8600375438", 177645020),  // 2.0
	GAME_ENTRY("sq2vga", "SQ2VGA_V2.ags", "b3026b025c640a5c6164274034a6bab9", 175145932), // Linux

	// Commercial games
	GAME_ENTRY_STEAM("alemmo", "al-emmo.exe", "ff22fd118f18eca884dc7ed2a5be3877", 19045178),
	GAME_ENTRY("alemmo", "al_emmo.exe", "bb9e32ee92bb0996df5fea50e88d686a", 19036716), // 4.1, Desura
	GAME_ENTRY("alemmo", "al_emmo.exe", "d14295053c672c253460c8a7179b2bba", 19054865),
	GAME_ENTRY("alemmo", "al_emmo.exe", "4139d665622b2e3c5a31e90fc530fc74", 22442059),
	GAME_ENTRY("alemmo", "al_emmo.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 19181537),
	GAME_ENTRY("alemmo", "Al_EmmoSPA.exe", "a6608b37277f1220a1aecc6c18102a04", 2479104), // Fanmade Spanish translation
	GAME_ENTRY("alemmoanozira", "postcards from anozira.exe", "f5f73b35e809d9e01a2cff32abeffadf", 5567476), // 3.0, Desura
	GAME_ENTRY_STEAM("alemmoanozira", "Postcards_from_Anozira.exe", "a33691e4a84e2645b4cbe1f681511798", 5567690),
	GAME_ENTRY("alemmoanozira", "postcards from anozira.exe", "893f31faa33f1219b316894a0cbe7b27", 174781776),
	GAME_ENTRY_STEAM("alum", "alum.exe", "6d2f8e80c5f2372b705fdd4cc32f3579", 429203260), // Windows
	GAME_ENTRY_STEAM("alum", "Alum.exe", "6d2f8e80c5f2372b705fdd4cc32f3579", 429197066), // Linux & Mac
	GAME_ENTRY("alum", "alum.exe", "6d2f8e80c5f2372b705fdd4cc32f3579", 428902430),
	STABLE_ENTRY("atotk", "atotk.exe", "68d4f3488a9dcec74584651c0e29e439", 5078719, Common::UNK_LANG, "Steam/Deluxe"),
	STABLE_ENTRY("atotk", "atotk.ags", "68d4f3488a9dcec74584651c0e29e439", 5078866, Common::UNK_LANG, "Steam/Deluxe"), // 2.04
	GAME_ENTRY("apotheosis", "the apotheosis project.exe", "0cab252e992e5da65bdbf3648c2b70df", 1144087889), // 1.0
	GAME_ENTRY_STEAM("apotheosis", "the apotheosis project.exe", "0115a64ddec9396108f32da31d761ecb", 1144677502),
	GAME_ENTRY_STEAM("apotheosis", "The Apotheosis Project.exe", "4c0c28d58ebd53823fc0248e5b777c52", 1144826071),
	GAME_ENTRY_STEAM("apotheosis", "The Apotheosis Project.ags", "0d9ae5a4ffd3e3e968c6addb5d524954", 1142362222), // Linux
	GAME_ENTRY_STEAM("astroloco", "astroloco1.exe", "c71919e3b0cc415ef725cf1a9818a515", 42894919),
	GAME_ENTRY("astroloco", "astroloco1.exe", "06e70a826fde73b3f86f974885d31abe", 42492070),
	GAME_ENTRY_STEAM("beer", "beer!.exe", "6f201fd7a19869c85f49c7c471d0479a", 5055091), // Windows
	GAME_ENTRY_STEAM("beer", "Beer!.ags", "6f201fd7a19869c85f49c7c471d0479a", 5042748), // Linux
	GAME_ENTRY_GOG("blackwell1", "blackwell1.exe", "605e124cb7e0b56841c471e2d641c224", 18822697),
	GAME_ENTRY_PLUGIN_STEAM("blackwell1", "blackwell1.exe", "605e124cb7e0b56841c471e2d641c224", 18824597, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell1", "blackwell1.exe", "605e124cb7e0b56841c471e2d641c224", 19757071, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell1", "blackwell1.exe", "e5a75b86a0ea8143e1784261f5f52e83", 67241529, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell1", "ac2game.dat", "ff5b05b81909683fcd57580c58a81d87", 64200209, AGSTEAM_WADJETEYE), // Linux & Mac
	GAME_ENTRY_PLUGIN_STEAM("blackwell1", "ac2game.dat", "1051d3fa462b1e0cc8973a8775128307", 66679994, AGSTEAM_WADJETEYE), // Mac
	GAME_ENTRY("blackwell1", "blackwell1.exe", "605e124cb7e0b56841c471e2d641c224", 18824247), // Humble Bundle (Windows)
	GAME_ENTRY("blackwell1", "ac2game.dat", "605e124cb7e0b56841c471e2d641c224", 68665467), // Android
	GAME_ENTRY("blackwell1", "ac2game.dat", "4668e05ef2a94267b0d571e715413302", 64200367), // Humble Bundle (Linux)
	GAME_ENTRY("blackwell1", "ac2game.dat", "7fe0cac6736427d67822bca3d4bb30cb", 66675482),
	GAME_ENTRY_GOG("blackwell2", "unbound.exe", "5c3a940514d91431e8e1c372018851ca", 14493753),
	GAME_ENTRY_PLUGIN_STEAM("blackwell2", "unbound.exe", "5c3a940514d91431e8e1c372018851ca", 14496128, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell2", "unbound.exe", "5c3a940514d91431e8e1c372018851ca", 14469500, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell2", "unbound.exe", "00edc7b69ae377f6093ac567fd901849", 15683333, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell2", "ac2game.dat", "87c0681f4eebafddc60533f799456d53", 57672335, AGSTEAM_WADJETEYE), // Linux & Mac
	GAME_ENTRY("blackwell2", "unbound.exe", "5c3a940514d91431e8e1c372018851ca", 14495742), // Humble Bunde (Windows)
	GAME_ENTRY("blackwell2", "ac2game.dat", "5c3a940514d91431e8e1c372018851ca", 69452991), // Android
	GAME_ENTRY("blackwell2", "ac2game.dat", "e28670a676a3e4e78eef76b9573e490a", 57670660), // Humble Bunde (Linux)
	GAME_ENTRY("blackwell2", "ac2game.dat", "5c3a940514d91431e8e1c372018851ca", 59483140),
	GAME_ENTRY_GOG("blackwell3", "convergence.exe", "2260c1a21aba7ac00baf0100d4ca54f1", 172575801),
	GAME_ENTRY_PLUGIN_STEAM("blackwell3", "convergence.exe", "2260c1a21aba7ac00baf0100d4ca54f1", 172578803, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell3", "convergence.exe", "2260c1a21aba7ac00baf0100d4ca54f1", 171969680, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell3", "convergence.exe", "f261c2505f98503a1ec9f1dff7f13bda", 173873229, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell3", "ac2game.dat", "2844e3823d74652d282b8173bbde2b8b", 170703726, AGSTEAM_WADJETEYE), // Linux & Mac
	GAME_ENTRY("blackwell3", "convergence.exe", "2260c1a21aba7ac00baf0100d4ca54f1", 172578032), // Humble Bundle (Windows, v1.1)
	GAME_ENTRY("blackwell3", "ac2game.dat", "2260c1a21aba7ac00baf0100d4ca54f1", 173301005), // Android
	GAME_ENTRY("blackwell3", "ac2game.dat", "c894f6005f479ba8f12e87223920aa6a", 170700456), // Humble Bundle (Linux)
	GAME_ENTRY("blackwell3", "ac2game.dat", "2260c1a21aba7ac00baf0100d4ca54f1", 172574888),
	GAME_ENTRY_GOG("blackwell4", "deception.exe", "b3b192cf20a2f7666ddea3410dbd87cc", 303459336),
	GAME_ENTRY_GOG("blackwell4", "deception.exe", "1c0bf79d9720d0a81219e8778fb7e231", 304040703),
	GAME_ENTRY_GOG("blackwell4", "agsgame.dat", "1c0bf79d9720d0a81219e8778fb7e231", 304040703), // Linux
	GAME_ENTRY_PLUGIN_STEAM("blackwell4", "deception.exe", "b3b192cf20a2f7666ddea3410dbd87cc", 304076138, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell4", "deception.exe", "499c3261a1f73c5b78125beeca1c2d08", 305215631, AGSTEAM_WADJETEYE),
	GAME_ENTRY_GOG("blackwell5", "epiphany.exe", "c1cddd6fcdbcd030beda9f10d4e4270a", 281849897),
	GAME_ENTRY_GOG("blackwell5", "agsgame.dat", "c1cddd6fcdbcd030beda9f10d4e4270a", 281849897), // Linux
	GAME_ENTRY_PLUGIN_STEAM("blackwell5", "epiphany.exe", "c1cddd6fcdbcd030beda9f10d4e4270a", 281856724, AGSTEAM_WADJETEYE),
	GAME_ENTRY_PLUGIN_STEAM("blackwell5", "epiphany.exe", "764f20abb335b94ab8ec6a4ef6db01ea", 283020359, AGSTEAM_WADJETEYE),
	GAME_ENTRY_STEAM("captaindisaster", "cd-dhamsb-1-0-1.exe", "e2d290f8f21c6a83a9e8c5f3a0425b5e", 150665897),
	GAME_ENTRY_STEAM("charnelhousetrilogy", "cht.ags", "55c782c9de5a09157ea6aafac90b9cc8", 339257135),
	GAME_ENTRY_STEAM("charnelhousetrilogy", "cht.exe", "29c49db0805500ec14964eb897fc7b02", 341425110),
	GAME_ENTRY("charnelhousetrilogy", "cht.exe", "9ba3d9fbb098a26d7293ad3161c0f270", 341411868),
	GAME_ENTRY_STEAM("chronicleofinnsmouth", "chronicleofinnsmouth.exe", "f2e3fe96788b72ef2bf9429c58716099", 552972692),
	GAME_ENTRY_STEAM("chronicleofinnsmouth", "chronicleofinnsmouth.exe", "cb7ab3394128c52293417eae5dacf365", 552728591),
	GAME_ENTRY_STEAM("crystalshardadventurebundle", "bundle.exe", "1c45d5c239d9eeef61e283983b6e6851", 4645713),
	GAME_ENTRY("danewguys2", "jackass.exe", "029aab0fef5e9fff7b95ddf5d79d7718", 23932842), // Humble Store
	GAME_ENTRY_STEAM("detectivegallo", "dgbuild.exe", "2e0678b5642c64e057022a79742743fb", 90740554),
	GAME_ENTRY_GOG("detectivegallo", "dgbuild.exe", "2e0678b5642c64e057022a79742743fb", 90740772),
	GAME_ENTRY("diamondsintherough", "Diamonds.exe", "14c995189266969d538b31d1df451d3f", 180079079),
	GAME_ENTRY_STEAM("docapocalypse", "doc_apocalypse.exe", "1a7dfeb7797720111f9e40b5cbfea4c4", 47961989),
	GAME_ENTRY("docapocalypse", "doc_apocalypse.exe", "1a7dfeb7797720111f9e40b5cbfea4c4", 47959435),
	GAME_ENTRY("donticeyourcool", "Don't Ice Your Cool.exe", "2321081ba51d1869ebe11b9ba126911b", 5979469),
	GAME_ENTRY_STEAM("downfall2009", "downfall.exe", "aabdafae8b57dfc48fdf158a72326c23", 183357927),
	GAME_ENTRY_STEAM("downfall2009", "downfall.exe", "aabdafae8b57dfc48fdf158a72326c23", 279342949), // 1.4
	GAME_ENTRY_LANG("downfall2009", "downfall.exe", "10212624b951711c4b44f5cb9eecbf0a", 143360, Common::RU_RUS), // GOG
	GAME_ENTRY_GOG("downfall2016", "downfall.exe", "08b1340f3528feeebce1ecc59cc17907", 1995812750),
	GAME_ENTRY_STEAM("downfall2016", "downfall.exe", "08b1340f3528feeebce1ecc59cc17907", 224368590),
	GAME_ENTRY_STEAM("downfall2016", "Downfall.ags", "7c87b99ce309a46085e40ac1a2b20e75", 224024207), // Linux
	GAME_ENTRY_STEAM("dustbowl", "dustbowl.exe", "aa349d52fd620cf9642935cd5bdec5d8", 63365026),
	GAME_ENTRY("dustbowl", "dustbowl.exe", "aa349d52fd620cf9642935cd5bdec5d8", 82185295),
	GAME_ENTRY_STEAM("falconcity", "game.exe", "e816b31cfe3512c2ec24ac0bc6cfc605", 584191058),
	GAME_ENTRY_STEAM("feriadarles", "feria d'arles.exe", "6a3291595263debd129e1e2064baeea5", 275649462),
	GAME_ENTRY_STEAM("feriadarles", "ac2game.dat", "6a3291595263debd129e1e2064baeea5", 275640157), // Mac
	GAME_ENTRY("feriadarles", "feria d'arles.exe", "6a3291595263debd129e1e2064baeea5", 275659086),
	GAME_ENTRY_STEAM("footballgame", "Football Game.exe", "76703ac67835bdbfde5b378a147c8ba2", 164951859),
	GAME_ENTRY("footballgame", "football game.exe", "76703ac67835bdbfde5b378a147c8ba2", 164951859),
	GAME_ENTRY("footballgame", "football game.exe", "8283bcdb6ec07ec4a4040ef34215ec96", 164960522),
	GAME_ENTRY("geminirue", "GeminiRue.exe", "0bdfb2139abaae5ae2dc85f1aacfd3f6", 61906750), // v1.1 CD Release
	GAME_ENTRY_GOG("geminirue", "gemini rue.exe", "f3c0c7d3892bdd8963e8ce017f73de08", 61986506),
	GAME_ENTRY("geminirue", "gemini rue.exe", "0bdfb2139abaae5ae2dc85f1aacfd3f6", 61926695),
	DETECTION_ENTRY("geminirue", "gemini rue.exe", "0bdfb2139abaae5ae2dc85f1aacfd3f6", 64650419, Common::DE_DEU, nullptr, nullptr, GAMEFLAG_FORCE_AA), // German retail
	GAME_ENTRY_STEAM("geminirue", "gemini_rue_pc.exe", "83362d0d2c1d4909bfbd85c04c95bde2", 72960932),
	GAME_ENTRY("geminirue", "gemini_rue_pc.exe", "f49a61ea46feb86f89de3c136ad809ff", 73412249),
	GAME_ENTRY_PLUGIN_STEAM("geminirue", "agsgame.dat", "f3c0c7d3892bdd8963e8ce017f73de08", 62059297, AGSTEAM_WADJETEYE), //Linux
	GAME_ENTRY("geminirue", "gemini_rue_pc.exe", "e8f1d07a6b363e9cc80dac5367f1b4ba", 72860463), // Humble Bundle
	GAME_ENTRY("geminirue", "ac2game.dat", "f3c0c7d3892bdd8963e8ce017f73de08", 62852566), // Android
	GAME_ENTRY("geminirue", "ac2game.dat", "e8f1d07a6b363e9cc80dac5367f1b4ba", 72836785), // MacOS, Humble Bundle
	GAME_ENTRY_GOG("geminirue", "agsgame.dat", "f3c0c7d3892bdd8963e8ce017f73de08", 62069353), // Linux
	GAME_ENTRY_STEAM("ghostdream", "ghostdream.exe", "05594881531d62e4575545f3c8fd2576", 480856325),
	GAME_ENTRY_STEAM("goldenwake", "a-golden-wake.exe", "dbe281d93c914899886e77c09c3c65ec", 130844360), // Linux & Mac
	GAME_ENTRY_STEAM("goldenwake", "a-golden-wake.exe", "e7080df9729aae2a0097b752198f3cca", 130846774),
	GAME_ENTRY_GOG("goldenwake", "a-golden-wake.exe", "7056895c888d6cf3f0120d2edfeb7f7b", 130912596),
	GAME_ENTRY("goldenwake", "a-golden-wake.exe", "e80586fdc2db32f65658b235d8cbc159", 129814364), // Humble Bundle
	GAME_ENTRY("goldenwake", "a-golden-wake.exe", "e80586fdc2db32f65658b235d8cbc159", 129814642),
	GAME_ENTRY("goldenwake", "ac2game.dat", "bb3b4630c44a51e3a23892563121c2c8", 128018480), // Linux Humble Bundle
	GAME_ENTRY("goldenwake", "ac2game.dat", "d27edc5b7eee382501dfcfea044dfc90", 128018546),
	GAME_ENTRY_STEAM("grandmabadass", "GrandmaBadass-bundle1.exe", "a66d7de0e58d3f3a09522745c4d523d9", 739736114),
	GAME_ENTRY_STEAM("guardduty", "guardduty.exe", "98d09f79129a5f96b6622661e2a7bc64", 706020335),
	GAME_ENTRY_GOG("guardduty", "guardduty.exe", "98d09f79129a5f96b6622661e2a7bc64", 706020743),
	GAME_ENTRY_STEAM("herdiscoming", "herd.exe", "78dd4ca028ee0156b6a093d6d780aa65", 7321217),
	GAME_ENTRY_STEAM("justignorethem", "justignorethem.exe", "182e930ace9d62a22d09779cac72e597", 94918926),
	GAME_ENTRY("justignorethem", "justignorethem.exe", "7a3096ac0237cb6aa8e1718e28caf039", 98544330),
	GAME_ENTRY_STEAM("justignorethemremake", "justignorethemremake.exe", "7a0b9391c01ad13e5107b7763084a993", 187186542),
	GAME_ENTRY_PLUGIN_STEAM_NOLAUNCHLOAD("kathyrain", "kathyrain.exe", "434e24a12ba3cfb07d7b4b2f0e0bb1bf", 197487159, AGSSPRITEFONT_CLIFFTOP),
	GAME_ENTRY_PLUGIN_GOG_NOLAUNCHLOAD("kathyrain", "kathyrain.exe", "d2b1ba151c3d209b50331127032f96f6", 197489719, AGSSPRITEFONT_CLIFFTOP),
	GAME_ENTRY_STEAM("killyourself", "ky.exe", "4e0d0aca04563b21a47e8a0cc56605fc", 18567658),
	GAME_ENTRY_GOG("lamplightcity", "lamplight city.exe", "0cb636e2235e2b7cff4ece5898653e18", 981897178), // Version 1.10
	GAME_ENTRY_GOG("lamplightcity", "lamplight city.ags", "70a52d0ba7e5975df40aef460142f770", 979393622), // Linux
	GAME_ENTRY_STEAM("lamplightcity", "lamplight city.exe", "4b18403fd1d150321f50cff9232d7b28", 982468239),
	GAME_ENTRY_STEAM("lamplightcity", "lamplight city.ags", "69936bd2263616bb0bd64fa6b4fe5a8d", 979409133),
	GAME_ENTRY_STEAM("lamplightcity", "ac2game.dat", "0cb636e2235e2b7cff4ece5898653e18", 981897178), // Mac
	GAME_ENTRY_STEAM("legendofhand", "legend of hand.exe", "fc478dd7564c908615c9366398d995c8", 75797285),
	GAME_ENTRY("legendofhand", "legend of hand.exe", "fc478dd7564c908615c9366398d995c8", 75797155),
	GAME_ENTRY_GOG("mage", "ac2game.dat", "2e822f554994f36e0c62da2acda874da", 30492258), // Mac
	GAME_ENTRY_GOG("mage", "mages_initiation.exe", "2e822f554994f36e0c62da2acda874da", 30492089),
	GAME_ENTRY_STEAM("mage", "mages_initiation.exe", "2e822f554994f36e0c62da2acda874da", 30492087),
	GAME_ENTRY_STEAM("mage", "ac2game.dat", "2e822f554994f36e0c62da2acda874da", 30492087), // Mac
	GAME_ENTRY_STEAM("metaldead", "metaldead.exe", "91996c5379e82787b68e84ab67d9672f", 1504754877),
	GAME_ENTRY("metaldead", "metaldead.exe", "3b0874c12fa643efa5fcdc43f647c871", 1501335400),
	GAME_ENTRY_STEAM("neofeud", "neofeud.exe", "6e861b1f476ff7cdf036082abb271329", 2078740517),
	GAME_ENTRY("neofeud", "neofeud.exe", "6e861b1f476ff7cdf036082abb271329", 2078743375),
	GAME_ENTRY_GOG("oott", "oott-tkc.exe", "11c2421258465cba4bd773c49d918ee3", 467834855),
	GAME_ENTRY_GOG("oott", "oott-tkc.exe", "11c2421258465cba4bd773c49d918ee3", 467845009),
	GAME_ENTRY_STEAM("oott", "oott-tkc.exe", "11c2421258465cba4bd773c49d918ee3", 467844896),
	GAME_ENTRY_STEAM("oott", "agsgame.dat", "801b35fe313a432e44671ab04178b679", 465670839), // Linux
	GAME_ENTRY_GOG("oott", "agsgame.dat", "ca8414acc5dc5687891db2d8ac5a0e76", 465662744), // Linux
	GAME_ENTRY_GOG("primordia", "primordia.exe", "22313e59c3233001488c26f18c80cc08", 973495830),
	GAME_ENTRY_GOG("primordia", "primordia.exe", "f2edc9c3161f1f538df9b4c59fc89e24", 978377890),
	GAME_ENTRY_GOG("primordia", "agsgame.dat", "22313e59c3233001488c26f18c80cc08", 973495830), // Linux
	GAME_ENTRY_STEAM("primordia", "primordia.exe", "f2edc9c3161f1f538df9b4c59fc89e24", 978377182),
	GAME_ENTRY("primordia", "primordia.exe", "22313e59c3233001488c26f18c80cc08", 973154021), // DVD version
	GAME_ENTRY("primordia", "primordia.exe", "8f717a5a14ceda815292ce4065348afb", 978722743),
	GAME_ENTRY_STEAM("puzzlebots", "ac2game.dat", "34b49df9cf6eadb5c3587b3921d5b72f", 787776664),
	GAME_ENTRY_GOG("qfi", "qfi.exe", "0702df6e67ef87fd3c51d09303803126", 534847265),
	GAME_ENTRY_GOG("qfi", "qfi.exe", "32b36aebe0729c9360bc10dcddc0653c", 538562096),
	GAME_ENTRY_STEAM("qfi", "qfi.exe", "32b36aebe0729c9360bc10dcddc0653c", 538681872),
	GAME_ENTRY("qfi", "qfi.exe", "32b36aebe0729c9360bc10dcddc0653c", 538547262),
	GAME_ENTRY("qfi", "qfi.exe", "946f453df05714c65256ad315dc6cc37", 538574225), // itch.io 1.2
	GAME_ENTRY("qfi", "agsgame.dat", "9efb669ada4b685f9a5a91ce161424a7", 532694795), // Linux Groupees
	GAME_ENTRY("qfi", "agsgame.dat", "2a0ba29e479ca5aa8c6b4233f030e78f", 536391599),
	GAME_ENTRY_STEAM("qfi", "agsgame.dat", "2a0ba29e479ca5aa8c6b4233f030e78f", 536513114), // Linux
	GAME_ENTRY("qfi", "qfi.exe", "8a7bc4f9ef0e6b0a5b01d3e4d5d5ee7d", 534881961),
	GAME_ENTRY("qfi", "qfi.exe", "32b36aebe0729c9360bc10dcddc0653c", 538547259),
	GAME_ENTRY_GOG("resonance", "resonance.exe", "2e635c22bcbf0ed3d46f1bcde71812d4", 849404957),
	GAME_ENTRY_PLUGIN_STEAM("resonance", "resonance.exe", "2e635c22bcbf0ed3d46f1bcde71812d4", 849410915, AGSTEAM_WADJETEYE),
	GAME_ENTRY_STEAM("richardandalice", "richardandalice.exe", "1023d348f67ba958f78ed62d029565c7", 109164768),
	GAME_ENTRY_STEAM("richardandalice", "richardandalice.exe", "f47d11397e2059a25b11057ea6cf3409", 108264256),
	GAME_ENTRY("richardandalice", "richardandalice.exe", "9a7e38a1810e6a1839601fb5c6bd42e6", 108602238), // Desura
	GAME_ENTRY_STEAM("roguestate", "roguestate.exe", "981a1c4d5a64b8ebe300f9769acf0fe5", 895486573),
	GAME_ENTRY("samaritan", "samaritan.exe", "79dd677433bbb10d4970367eb68b243c", 78070237), // Groupees, v1.1
	GAME_ENTRY_STEAM("samaritan", "samaritan.exe", "5fb404a4a7c9cd1449dfdd3d23fa0250", 78753952),
	GAME_ENTRY_STEAM("samaritan", "samaritan.exe", "6a3b669b7d34ec9356a665afe0c2c003", 78438375),
	GAME_ENTRY_STEAM("shardlight", "shardlight.exe", "ee801fba52d252249677a9170bd2db96", 642157876),
	GAME_ENTRY("shardlight", "shardlight.exe", "ee801fba52d252249677a9170bd2db96", 642151325),
	GAME_ENTRY("shardlight", "shardlight.exe", "ee801fba52d252249677a9170bd2db96", 642142591),
	GAME_ENTRY("shivah", "shivah.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 19542815), // Official website
	GAME_ENTRY_PLUGIN_STEAM("shivah", "shivah.exe", "0aaf5445a3544a631d6e7dd4561fc7ae", 32323040, AGSTEAM_WADJETEYE),
	GAME_ENTRY_STEAM("shivah", "ac2game.dat", "0aaf5445a3544a631d6e7dd4561fc7ae", 32323040),
	GAME_ENTRY("shivah", "ac2game.dat", "0aaf5445a3544a631d6e7dd4561fc7ae", 32339699), // Android
	GAME_ENTRY("shivah", "ac2game.dat", "ec0019b528dd1e9bcb4264967c4a3a31", 30446404), // Linux Humble Bundle
	GAME_ENTRY("shivah", "ac2game.dat", "bdc618b23fc279938f05f8ac058a938b", 32723739), // MacOS
	GAME_ENTRY_GOG("shivah", "shivah.exe", "0aaf5445a3544a631d6e7dd4561fc7ae", 32319665), // Windows GOG, Humble Bundle
	GAME_ENTRY_STEAM("sumatra", "sumatra fate of yandi.exe", "57c868b1a81c0335ab60970292cd79d8", 170088886),
	GAME_ENTRY("superjazzman", "sjm.exe", "0710e2ec71042617f565c01824f0cf3c", 10841689), // Official website
	GAME_ENTRY("symploke1", "Symploke.exe", "ff20c8c9dda8379607db87e7726909c6", 29996616), // Videojuegos Fermin website (Spanish)
	GAME_ENTRY("symploke1", "symploke1.exe", "ff20c8c9dda8379607db87e7726909c6", 57363019), // Steam (English), same as Videojuegos Fermin website (English)
	GAME_ENTRY("symploke1", "symploke1.exe", "ff20c8c9dda8379607db87e7726909c6", 29996469), // Steam (Spanish)
	GAME_ENTRY("symploke2", "symploke2.exe", "ff20c8c9dda8379607db87e7726909c6", 184247323), // Steam (English)
	GAME_ENTRY("symploke2", "symploke2.exe", "ff20c8c9dda8379607db87e7726909c6", 124539110), // Steam (Spanish)
	GAME_ENTRY("symploke3", "symploke3.exe", "c7acc0fba53cb6a656c9cbc788868a2d", 284040264), // Steam (English)
	GAME_ENTRY("symploke3", "symploke3.exe", "c7acc0fba53cb6a656c9cbc788868a2d", 284098408), // Steam (Spanish)
	GAME_ENTRY("tales", "tales.exe", "4f6c7ec127e8b0ce077abb357903612f", 112930701),
	GAME_ENTRY_STEAM("tales", "tales.exe", "7b5842e8954354ef6e21dc1837073182", 150969855),
	GAME_ENTRY_STEAM("technobabylon", "technobabylon.exe", "e523535e730f313e1ed9b19b1a9dd228", 447900356),
	GAME_ENTRY("technobabylon", "technobabylon.exe", "e523535e730f313e1ed9b19b1a9dd228", 447894701),  // Humble Bundle
	GAME_ENTRY_STEAM("theadventuresoffatman", "fatman.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 44449205),
	GAME_ENTRY("theantidote", "The Antidote.exe", "4017d881af6467d6aad9183e6e38a261", 325819947),
	GAME_ENTRY_STEAM("thebeardinthemirror", "the beard in the mirror.exe", "4d4b6d6e560cf32f440c39f8d3896da5", 40637501),
	GAME_ENTRY_STEAM("thecastle", "maniac.exe", "3b96c2143d927f005715be73344e456c", 22362337),
	GAME_ENTRY_GOG("thecatlady", "thecatlady.exe", "0ea2b985dc5d7d27cb7c1b7da5eedea0", 1072316702),
	GAME_ENTRY_STEAM("thecatlady", "thecatlady.exe", "0ea2b985dc5d7d27cb7c1b7da5eedea0", 53988582),
	GAME_ENTRY("thecatlady", "Cat Lady.exe", "92320e20e3d4c70a94d89e2f797e65c1", 1061000756), // DVD
	GAME_ENTRY_STEAM("thesecretsofjesus", "the secrets of jesus.exe", "2e17ab52586ad34b5e597c20a59f60a0", 1577637692),
	GAME_ENTRY_STEAM("theterribleoldman", "the terrible old man.exe", "e07a475bcf14bc75c016724186f222ac", 369769127),
	GAME_ENTRY_STEAM("theterribleoldman", "the terrible old man.exe", "b3a10d7d3b5a728330b028ec28ff2d05", 103852030),
	GAME_ENTRY_STEAM("timegentlemenplease", "tgp.exe", "86a5359bac7c88f0dfa060478800dd61", 74077811),
	GAME_ENTRY_STEAM("waitingfortheloop", "waitingfortheloop.exe", "0241777c2537fc5d077c05cde10bfa9f", 51472537),
	GAME_ENTRY("waitingfortheloop", "waitingfortheloop.exe", "0241777c2537fc5d077c05cde10bfa9f", 51273604),
	GAME_ENTRY("welcometosunnymunarvagir", "alpha4.ags", "392dbdd0697ae32af4cfe5212f9213c5", 23000263),
	GAME_ENTRY_PLUGIN_STEAM_NOLAUNCHLOAD("whispersofamachine", "whispers.exe", "b4962a0a9c9c33954e185a137125f527", 159084291, AGSSPRITEFONT_CLIFFTOP),
	GAME_ENTRY_PLUGIN_GOG_NOLAUNCHLOAD("whispersofamachine", "whispers.exe", "b8416ff5242d6540980f922f03a01a5f", 159085573, AGSSPRITEFONT_CLIFFTOP),
	GAME_ENTRY_STEAM("zniwadventure", "ctgame.exe", "8a2d48ee8d92bad3c5cacd8b883c5871", 100036465),
	GAME_ENTRY_STEAM("zniwadventure", "ctgame.exe", "8a2d48ee8d92bad3c5cacd8b883c5871", 100040004),
	GAME_ENTRY("zniwadventure", "ctgame.exe", "8a2d48ee8d92bad3c5cacd8b883c5871", 100010235),
	// Commercial Italian games
	GAME_ENTRY_LANG("onironauta", "Onironauta.exe", "5c8c0e3edae9b4fad276c136b2b48ce8", 69917110, Common::IT_ITA),

	// Post-2.5 games that are likely supported by the AGS engine
	DEMO_ENTRY("3geeks", "3GEEKS_Demo.exe", "7ddb9e776648faed5a51170d087074e9", 512546851), // itch.io
	DEMO_ENTRY("aazor", "aazor.exe", "465f972675db2da6040518221af5b0ba", 4956212),
	DEMO_ENTRY("absurdistan", "Absurdistan - Demo.exe", "4588012d3077d6b6791fce8cd4b15885", 35712363),  // v1.3
	DEMO_ENTRY("acuriouspastime", "Curious.exe", "3e46b32a00fd4e6b9f68754f854695c5", 27346489),
	DEMO_ENTRY("adventurequest", "begin.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 1584015),
	DEMO_ENTRY("adventurequest2", "adventure.exe", "f120690b506dd63cd7d1112ea6af2f77", 4603131),
	DEMO_ENTRY("afrojones", "afrojones.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 4739799),
	DEMO_ENTRY("agscolosseum", "AGS coliseum.exe", "6d65fa76ae212c9bbfa868698f47e921", 86449242),
	DEMO_ENTRY("alemmo", "al-emmo.exe", "9661b29821fdc7f93d286f25c195fc22", 8932837), // Steam
	DEMO_ENTRY("alemmo", "emmo_demo.exe", "2fb17c4382f2f54ef6d040b6493fec4b", 8943213), // Official website
	DEMO_ENTRY("allhallowseve", "hallows.exe", "a9d8eb8963b4d3b8ed4f7e74edcb6ccd", 8904536),
	DEMO_ENTRY("alphax", "alphax.exe", "06a03fe35791b0578068ab1873455463", 17879795),
	DEMO_ENTRY("alquest1", "alquest.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 20154310),
	DEMO_ENTRY("annaquest", "AnnasQuest-DEMO.exe", "9257c91ee6cda3796d8af6856cf883bb", 69313413),
	DEMO_ENTRY("anentertainingspeech", "An Entertaining Speech.exe", "a8971dcd9a97994a0b8fe9160ebad777", 171300529),
	DEMO_ENTRY("animalcruelty", "Animal Cruelty Demo 1.2.exe", "495d45fb8adfd49690ae3b97921feec6", 41830978),  // v1.2
	DEMO_ENTRY("anotherhero", "Another Hero - First Look Demo.exe", "7ddb9e776648faed5a51170d087074e9", 27404506),
	DEMO_ENTRY("ashinaredwitch", "ATRW.exe", "8355ade0422da6e8655f71470ff51483", 44543604),  // Itch.io
	DEMO_ENTRY("ashinaredwitch", "Ashina.exe", "8355ade0422da6e8655f71470ff51483", 140043612),  // Steam
	DEMO_ENTRY("ashpines", "Ash Pines Demo.exe", "981e60a9be515bb56c634856462abbc7", 90323249),
	DEMO_ENTRY("awakeningofthesphinx", "awksphinx.exe", "0500aacb6c176d47ac0f8158f055db83", 7507867),
	DEMO_ENTRY("bachelorstory", "Bachelor Story.exe", "a524cbb1c51589903c4043b98917f1d9", 7436465),
	DEMO_ENTRY("bananaman", "banana man demo.exe", "615e806856b7730afadf1fea9a756b70", 53524952),
	DEMO_ENTRY("battlewarriorsrt", "battle.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 16314318),
	DEMO_ENTRY("beforeww2", "beforeww.exe", "4d17844029d8910fbaae1bdc99e250f2", 9759616),
	DEMO_ENTRY("bizarreearthquake", "bizarre.exe", "7e7c92d697b3cc9610d86854a00e517b", 29387739),
	DEMO_ENTRY("blackmorph", "liechi.exe", "46859c6f77bdb311266daa589561fa6b", 14476030),  // MAGS 
	DEMO_ENTRY("blackmorph", "Black Morph.exe", "cd37b1dbdff2c7092e05f5abed2f5dee", 16333092),  // v1.0
	DEMO_ENTRY("blackwell1", "blackwell demo.exe", "2eeca6bae968dc61b5ed36561efc0fca", 53342880),
	DEMO_ENTRY("blackwell2", "unbound_demo.exe", "6ee842f73649ced615c44d4eb303687c", 30057537),
	DEMO_ENTRY("blackwell3", "convergence.exe", "856a6e0e22d2cb4a45d5bbc7245ce5e8", 29935120),
	DEMO_ENTRY("blackwell4", "deception.exe", "b3b192cf20a2f7666ddea3410dbd87cc", 260533048),
	DEMO_ENTRY("blackwell5", "epiphany.exe", "c1cddd6fcdbcd030beda9f10d4e4270a", 283994688),
	DEMO_ENTRY("blockz", "Blockz.exe", "e007e8f70fecd73999aaf53847c5a833", 31799091),
	DEMO_ENTRY("bluemoon", "blue moon.exe", "95dcf736be87cf7d40bf64d5b078c4b7", 14845997),
	DEMO_ENTRY("bookofdestiny", "SG.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 1198451),
	DEMO_ENTRY("brotherswreckers", "Brothers & Wreckers.exe", "f24c533ce89a2566c157b871f87a4ce4", 42831964),
	DEMO_ENTRY("bytheswordconspiracy", "bts.exe", "7dc7f61f79ba7a77d4ef8168bfd3d173", 60246329),
	DEMO_ENTRY("byzantine", "byza.exe", "39d7a558298a9f1d40c1f415daf9bb74", 3708632),
	DEMO_ENTRY("captaindisaster", "cd-dhamsb-demo-1-3-0.exe", "9d991dd1f9e7fee653d3a9bb2546f968", 153646768),
	DEMO_ENTRY("charnelhousetrilogy", "sepulchredemo.exe", "9ba3d9fbb098a26d7293ad3161c0f270", 139434513), // Steam
	DEMO_ENTRY("chronicleofinnsmouth", "ChronicleOfInnsmouthTechDemo1.1.exe", "b5c41e08919834b549ca350a28f18f87", 43595582),
	DEMO_ENTRY("city", "City.exe", "3e62eafed0fc365821b7afdbf1aec3d8", 18660151),
	DEMO_ENTRY("clubmidget", "midget2.exe", "4d17844029d8910fbaae1bdc99e250f2", 1593937),
	DEMO_ENTRY("coelldeckaflight", "coell deca.exe", "a524cbb1c51589903c4043b98917f1d9", 5497572),
	DEMO_ENTRY("crimmsson", "Crimm's Son.exe", "618d7dce9631229b4579340b964c6810", 9039508),
	DEMO_ENTRY("cyberpunk97ep1", "zone - Copy.exe", "78dd4ca028ee0156b6a093d6d780aa65", 717217747),
	DEMO_ENTRY("danewguys2", "dng2 demo.exe", "0d2e8dc76f9ac381d204a3ac763b0bac", 5235302),
	DEMO_ENTRY("dangermouse", "Danger Mouse.exe", "eed666c68be394737de478a52210dde4", 247422806),
	DEMO_ENTRY("dawnswonderedatagesend", "myGame.exe", "75f4c7f66b1be60af5b2d65f617b91a7", 243406385),
	DEMO_ENTRY("deflus", "Deflusdemo.exe", "0710e2ec71042617f565c01824f0cf3c", 2939316),
	DEMO_ENTRY("detectivegallo", "dgbuild.exe", "5f2e683b0d5e66e47f5800322982171e", 466252165),
	DEMO_ENTRY("detectiverizal", "Detective Rizal and the Jaded Ruby.exe", "615e73fc1874e92d60a1996c2330ea36", 28411427),
	DEMO_ENTRY("diamondsintherough", "diamonds demo.exe", "14c995189266969d538b31d1df451d3f", 2439365),
	DEMO_ENTRY("doctorwho", "Doctor Who.exe", "06a03fe35791b0578068ab1873455463", 50728727),
	DEMO_ENTRY("doses", "PN.exe", "615e73fc1874e92d60a1996c2330ea36", 3891599),  // v1.0
	DEMO_ENTRY("doses", "PN.exe", "615e73fc1874e92d60a1996c2330ea36", 3945217),  // v1.2
	DEMO_ENTRY("downfall2016", "downfall_demo.exe", "7c87b99ce309a46085e40ac1a2b20e75", 97968746), // Steam
	DEMO_ENTRY("dragonsfang", "DraciZub_hra.exe", "bdaf20d9779c01986d6d8b7e1d6118ee", 27463584),
	DEMO_ENTRY("drevil", "drevil.exe", "0394af1c29e1060fcdbacf2a3dd9b231", 1371668),
	DEMO_ENTRY("dumbassdrivers", "dumbass.exe", "f120690b506dd63cd7d1112ea6af2f77", 40580988),
	DEMO_ENTRY("dustbowl", "Dustbowl - DEMO.exe", "b9f4b6df0ab98d27d1bf8b874b8d12b6", 15285362),
	DEMO_ENTRY("dusttowater", "Dust to Water.exe", "0e32c4b3380e286dc0cea8550f1c045e", 70459846),
	DEMO_ENTRY("dysmaton", "Dysmaton.exe", "6e861b1f476ff7cdf036082abb271329", 140513956),
	DEMO_ENTRY("dysmaton", "Dysmaton.ags", "1e0cda052a371ebf6aa0bd62c0e754b9", 138033300),
	DEMO_ENTRY("earlbobby3", "demo.exe", "0e32c4b3380e286dc0cea8550f1c045e", 4221725),
	DEMO_ENTRY("echointheclouds", "Echo in the Clouds.exe", "2321081ba51d1869ebe11b9ba126911b", 57717828),
	DEMO_ENTRY("eerieblue", "EerieBlue.exe", "bacdba3c759a861e899e6b0adcbb8bd5", 96605122),
	DEMO_ENTRY("eerieblue", "EerieBlue.exe", "bacdba3c759a861e899e6b0adcbb8bd5", 96647570),
	DEMO_ENTRY("emmaroide", "emma roide.exe", "aefd91a131817036d224fe030e406c6e", 24919443),
	DEMO_ENTRY("enterthestory", "Enter The Story.exe", "0514661a4ba6772cf0db0cf839fc7003", 19589742),
	DEMO_ENTRY("everlight", "Everlight.exe", "0500aacb6c176d47ac0f8158f055db83", 17597037),
	DEMO_ENTRY("everythingm", "TinyMika.exe", "66adc3431f0626a2c6e80f31a21f0981", 3529496),
	DEMO_ENTRY("flashbax", "demo flashbax.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 5527034),
	DEMO_ENTRY("forcemajeureiithezone", "thezonedemo.exe", "b63d26c17bf292017f9a708ae9dc38ca", 18414473),
	DEMO_ENTRY("forfrogssakegetthefrogout", "Frog2.exe", "0241777c2537fc5d077c05cde10bfa9f", 6723366),
	DEMO_ENTRY_LANG("forgettendeath", "ForgettenDeath.exe", "06a03fe35791b0578068ab1873455463", 19427130, Common::TR_TUR),  // Turkish
	DEMO_ENTRY("fountainofyouth", "foydemo.exe", "f120690b506dd63cd7d1112ea6af2f77", 14372003),
	DEMO_ENTRY("franticfranko", "steelh1.exe", "2cb9c81a20282b55f69343ef95cbb63d", 37086267),
	DEMO_ENTRY("gamesgalore", "gamesgalore.exe", "f120690b506dd63cd7d1112ea6af2f77", 7620552),
	DEMO_ENTRY("gassesuittollis3", "gst3_demo.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 4270243),
	DEMO_ENTRY("geminirue", "gemini rue demo.exe", "978eab85a41b8fc089b719af47dfbb79", 61839853),
	DEMO_ENTRY("gesundheit", "gesundheit.exe", "5554b9e0df6241d25c9a070708e54478", 49666357),
	DEMO_ENTRY("ghostdream", "ghostdream.exe", "05594881531d62e4575545f3c8fd2576", 225600520),
	DEMO_ENTRY("grandmabadass", "grandmaDEMO.exe", "636250e131f51c7a97989992cc97cf02", 525503237),
	DEMO_ENTRY("greenback", "Greenback.exe", "b80b5892fc0291add209a0d3de6dedc5", 10490547),
	DEMO_ENTRY("gwendarkly", "MAGSGwenVersion.exe", "ac764efb63859d435e03f04f46f2b1f0", 10141568),
	DEMO_ENTRY("harrycaine", "Harry Caine Extreme Weather Reporter.exe", "82da2565c456dcfb265ded6fe3189c0b", 24158833),
	DEMO_ENTRY("herdiscoming", "herd.exe", "78dd4ca028ee0156b6a093d6d780aa65", 5664594), // Steam
	DEMO_ENTRY("hewatches", "MansionAGS.exe", "74dc062c5f68f3d70da911f2db5737b6", 10728553),
	DEMO_ENTRY("hiliaderoleagainsthell", "dark trial demo.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 36442694),
	DEMO_ENTRY("hood", "hood.exe", "97d700529f5cc826f230c27acf81adfd", 1575198),
	DEMO_ENTRY("houseofhorror", "The House of Horror.exe", "c20fee88ad37d2d21837eee9d34f2dbe", 10120651),
	DEMO_ENTRY("huxzadventure", "Huxsadv.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 2053897),
	DEMO_ENTRY_LANG("indycrownofsolomon", "IndyCoS.exe", "f120690b506dd63cd7d1112ea6af2f77", 5483592, Common::EN_ANY),  // English
	DEMO_ENTRY_LANG("indycrownofsolomon", "cosdemo2.1-it.exe", "f120690b506dd63cd7d1112ea6af2f77", 5772985, Common::IT_ITA),  //Italian
	DEMO_ENTRY_LANG("indycrownofsolomon", "CoSdemo2.1.exe", "f120690b506dd63cd7d1112ea6af2f77", 6178327, Common::DE_DEU),  //German
	DEMO_ENTRY_LANG("indycrownofsolomon", "CoSdemo2.1.exe", "f120690b506dd63cd7d1112ea6af2f77", 6069990, Common::ES_ESP),  //Spanish
	DEMO_ENTRY_LANG("indycrownofsolomon", "CoSdemo2.1.exe", "06a03fe35791b0578068ab1873455463", 6903169, Common::FI_FIN),  //Finnish
	DEMO_ENTRY("indycrystalcursor", "cursoid.exe", "06a03fe35791b0578068ab1873455463", 12136127),
	DEMO_ENTRY("indysevencities", "Seven Cities.exe", "c9cd3e2cdd295c33e62cfa97b14461e9", 12561314),  //v1.2.1.1
	DEMO_ENTRY("infectionep2", "Infection_Ep_II_AGS.exe", "a524cbb1c51589903c4043b98917f1d9", 23691417),
	DEMO_ENTRY("inferno", "inf.exe", "97d700529f5cc826f230c27acf81adfd", 8783105),
	DEMO_ENTRY("intergalacticspacepancake", "space.exe", "4d17844029d8910fbaae1bdc99e250f2", 1993173),
	DEMO_ENTRY("intraworld", "1 Intra World.exe", "0241777c2537fc5d077c05cde10bfa9f", 40044701),
	DEMO_ENTRY("jacquelinewhitecurseofthemummies", "CurseOfTheMummies.exe", "e9bdea51db49da499c69e8c21a821a7f", 193723250),
	DEMO_ENTRY("jamesperis2", "james2.exe", "06a03fe35791b0578068ab1873455463", 35766505),
	DEMO_ENTRY("jimmsquest3", "JQ3.EXE", "0b7529a76f38283d6e850b8d56526fc1", 4930906),
	DEMO_ENTRY_LANG("johnsinclair", "John Sinclair - Voodoo in London.exe", "d72e72697a755c7de395b0f6c8cbbf0d", 56795991, Common::DE_DEU),
	DEMO_ENTRY("jonstickman", "J.S.exe", "a2230d4ac3c39431b51c9bb20929932c", 9570622),
	DEMO_ENTRY("jorry", "jorry demo.exe", "fe5f7dc7785b335aec72a2a834629bad", 124667001),
	DEMO_ENTRY("karelianninja", "Karelian ninja.exe", "25976a689b0f4d73eac69b1728377ecb", 14407656),
	DEMO_ENTRY_PLUGIN("kathyrain", "kathyrain.exe", "434e24a12ba3cfb07d7b4b2f0e0bb1bf", 197487685, AGSSPRITEFONT_CLIFFTOP), // Steam
	DEMO_ENTRY_PLUGIN("kathyrain", "kathyrain.exe", "d2b1ba151c3d209b50331127032f96f6", 197490245, AGSSPRITEFONT_CLIFFTOP), // GOG
	DEMO_ENTRY("kingrobert", "King Robert's Quest.exe", "0241777c2537fc5d077c05cde10bfa9f", 4847870),
	DEMO_ENTRY("kinkyisland", "kinky.exe", "f120690b506dd63cd7d1112ea6af2f77", 10628479),
	DEMO_ENTRY("kq3plus", "Intro.ags", "06a03fe35791b0578068ab1873455463", 4866555),
	DEMO_ENTRY("kq9vga", "KQ9DEMO1.exe", "06a03fe35791b0578068ab1873455463", 2635933),
	DEMO_ENTRY("kumastory", "Kuma Story.exe", "54e966a013d104bf23603c780438d089", 2893472),
	DEMO_ENTRY("laportenoire", "proute.exe", "06a03fe35791b0578068ab1873455463", 17087125),
	DEMO_ENTRY("lazytownthenewkid", "newkiddemo1.2.exe", "9cb3c8dc7a8ab9c44815955696be2677", 15515508),
	DEMO_ENTRY("litnunforgettablememories", "litn_umtechdemo.exe", "f120690b506dd63cd7d1112ea6af2f77", 3507831),
	DEMO_ENTRY("mash", "mash demo.ags", "af4276d98c9f71dba02658fe95e49b75", 2565641),
	DEMO_ENTRY("mash", "mash demo.exe", "7825fa980fcd058caadaf6d3377b1f78", 5601309),
	DEMO_ENTRY("mi5thereturnoflechuck", "demo.exe", "0500aacb6c176d47ac0f8158f055db83", 6235270),
	DEMO_ENTRY("micv", "MI.exe", "d90febc33f641a5f14c485f8ef29fb33", 3371895),
	DEMO_ENTRY("mimv", "MI.exe", "c0c6dafd33236a308bd0b87678326994", 1872382),
	DEMO_ENTRY("mivl", "MI.exe", "23a7b5a6119e82a9750302492b3f2856", 1927604),
	DEMO_ENTRY("mybigsister", "my big sister.exe", "4dc50ca8b5d2c762fe86a528b09973cf", 90464651),
	DEMO_ENTRY("neofeud", "neofeud demo.exe", "6e861b1f476ff7cdf036082abb271329", 1886913453),
	DEMO_ENTRY("neofeud", "neofeud.exe", "6e861b1f476ff7cdf036082abb271329", 2078743282), // 1.3 itch.io
	DEMO_ENTRY("neofeud", "Neofeud_LINUX_TEST_9_2_17.ags", "a23f0c48d8128bb7045ab8685665a464", 2076260110), // itch.io Linux
	DEMO_ENTRY("oott", "demo_tkc.exe", "54da0ce99f3e8b556db6d236c8ef76ba", 415137576), // Steam
	DEMO_ENTRY("phantomfellows", "TPF.exe", "71961f24fd94e30e61167d7b0720cd35", 96534651),
	DEMO_ENTRY("phantomfellows", "TPF.exe", "71961f24fd94e30e61167d7b0720cd35", 96536204),
	DEMO_ENTRY("phantomfellows", "TPF.exe", "71961f24fd94e30e61167d7b0720cd35", 96799674),
	DEMO_ENTRY("phantomfellows", "TPF.exe", "71961f24fd94e30e61167d7b0720cd35", 96799833),
	DEMO_ENTRY("phantomfellows", "TPF.exe", "71961f24fd94e30e61167d7b0720cd35", 96800964),
	DEMO_ENTRY("phantomfellows", "TPF.exe", "71961f24fd94e30e61167d7b0720cd35", 430357136),
	DEMO_ENTRY("phantomfellows", "TPF.exe", "71961f24fd94e30e61167d7b0720cd35", 505116629),
	DEMO_ENTRY("primordia", "primordia.exe", "22313e59c3233001488c26f18c80cc08", 727898212),
	DEMO_ENTRY("pubmastersquest", "pub master quest [demo].exe", "e1676318c8a040fcf508b817013dc8fe", 23431689),
	DEMO_ENTRY("puzzlebots", "puzzlebots_demo.exe", "34b49df9cf6eadb5c3587b3921d5b72f", 354138961),
	DEMO_ENTRY("quantumnauts", "qndemo.exe", "aeb2dd29e5ff839cb3ee86cf3e87e3ca", 134237367),
	DEMO_ENTRY("qfi", "qfi_demo2.exe", "9e7eb04bb1652e188e6f2633eed89408", 82314927),
	DEMO_ENTRY("realitycheck4", "Reality Check 4.exe", "82da2565c456dcfb265ded6fe3189c0b", 16426064),
	DEMO_ENTRY("redbow", "Red Bow.exe", "2971fd82315ce4df9d8287def34b4713", 21338542), // itch.io
	DEMO_ENTRY("resonance", "resonance_demo.exe", "2e635c22bcbf0ed3d46f1bcde71812d4", 473386791),
	DEMO_ENTRY("retaliation", "Ron Retaliation.exe", "0500aacb6c176d47ac0f8158f055db83", 3135809),
	DEMO_ENTRY("retroron", "retroron.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 3762985),
	DEMO_ENTRY("rontimeouttrailer", "ronTOintro.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 2804752),
	DEMO_ENTRY("rontimeouttrailer", "ronTOintro.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 2804573),
	DEMO_ENTRY("ron5thanniversary", "5thpromo.exe", "f120690b506dd63cd7d1112ea6af2f77", 1620446),
	DEMO_ENTRY("searchforsanity", "sfs.exe", "308d35bc34e9df29d8acce615593e3e7", 9097147),
	DEMO_ENTRY("shadowsoftheempire", "sote_td.exe", "b8cd640b45c5a79c33c7a8a8fe32ebe2", 63299246),
	DEMO_ENTRY("shardlight", "shardlight demo.exe", "ee801fba52d252249677a9170bd2db96", 642405010), // Steam
	DEMO_ENTRY("shardlight", "shardlight demo.exe", "ee801fba52d252249677a9170bd2db96", 642366257),
	DEMO_ENTRY("shivah", "shivahdemo.exe", "6e3d6225dee662ff6450a3bfa942773b", 20897850),
	DEMO_ENTRY("shivah", "shivah-demo.exe", "0aaf5445a3544a631d6e7dd4561fc7ae", 23987292),
	DEMO_ENTRY("simonthesorcerer3", "simon3.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8189928),
	DEMO_ENTRY("simonthesorcerersbrother", "stsb-trailer.exe", "06a03fe35791b0578068ab1873455463", 2283838),
	DEMO_ENTRY("spoonsiiitheunauthorizededition", "spoonsIII.exe", "2ca80bd50763378b72cd1e1cf25afac3", 7316512),
	DEMO_ENTRY("sq3vga", "sq3vgademo.exe", "64fcaf7da0b257ea831f89c54be0ad72", 3630019),
	DEMO_ENTRY("sq55", "sq5.5.exe", "465f972675db2da6040518221af5b0ba", 16342443),
	DEMO_ENTRY("sram2", "sram2.exe", "e3a33d139d90f2e695292a618753b8a5", 296499943),
	DEMO_ENTRY("stuckathome", "shtrl1.exe", "0500aacb6c176d47ac0f8158f055db83", 819147),
	DEMO_ENTRY("sulifallenharmony", "Suli Fallen Harmony - Demo.exe", "8a58836830dce896e4366f57791ab6cc", 8822781),
	DEMO_ENTRY("sulifallenharmony", "Suli Fallen Harmony - Demo.exe", "8a58836830dce896e4366f57791ab6cc", 8826816), // itch.io
	DEMO_ENTRY("superjazzman", "sjmdemo.exe", "0710e2ec71042617f565c01824f0cf3c", 5214882),
	DEMO_ENTRY("tales", "tales.exe", "4f6c7ec127e8b0ce077abb357903612f", 112930689), // Steam
	DEMO_ENTRY("technobabylon", "technobabylon.exe", "e523535e730f313e1ed9b19b1a9dd228", 595787927),
	DEMO_ENTRY("technobabylon", "technobabylon.exe", "e523535e730f313e1ed9b19b1a9dd228", 59578792),
	DEMO_ENTRY("theadventuresoffatman", "fatman.exe", "853cef07077feadd0f2ccd55c5bd747b", 56375090),
	DEMO_ENTRY("theloneloser", "demo (english).exe", "0500aacb6c176d47ac0f8158f055db83", 6082095),
	DEMO_ENTRY("thesecretsofjesus", "the secrets of jesus.exe", "2e17ab52586ad34b5e597c20a59f60a0", 841450335), // Steam
	DEMO_ENTRY("thesecretsofjesus", "The secrets of Jesus.ags", "ed790525ab59cfc727a35582731de9c1", 838622031), // itch.io Linux
	DEMO_ENTRY("thesecretsofjesus", "the secrets of jesus.exe", "2e17ab52586ad34b5e597c20a59f60a0", 841450335), // itch.io Windows
	DEMO_ENTRY("timegentlemenplease", "tgp.exe", "86a5359bac7c88f0dfa060478800dd61", 29686006),
	DEMO_ENTRY("untilihaveyou", "until i have you.exe", "cda1d7e36993dd55ba5513c1c43e5b2b", 457842687),
	DEMO_ENTRY("wallyweasel", "wallydemo.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 12579444),
	DEMO_ENTRY("whattimeisit", "Wtii-demo.exe", "13a143130096b8d6baae1a7ccca52ac4", 4044338),  // 2002-09-09
	DEMO_ENTRY("whiskeyweather", "sword-denz-wjam2013.exe", "19467230b9a39aea9f711e83ccf4c984", 14336391),
	DEMO_ENTRY("withoutaprayer", "prayerDemo.exe", "28f82e420b82d07651b68114f90223c8", 8745149),
	DEMO_ENTRY("zniwadventure", "ctgame.exe", "b47f0434e11532ec79c330b44ee05130", 10641139),
	DEMO_ENTRY("zombieattack", "zademo.exe", "82da2565c456dcfb265ded6fe3189c0b", 20958555),

	GAME_ENTRY("10waysfromsunday", "10waysfromsunday.exe", "495d45fb8adfd49690ae3b97921feec6", 11362765),
	GAME_ENTRY("10waysfromsunday", "10waysfromsunday.exe", "495d45fb8adfd49690ae3b97921feec6", 11362850),
	GAME_ENTRY("11-11-11", "APOCA.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 286278821),  // v1.1.1
	GAME_ENTRY("1213", "1213.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2940069),
	GAME_ENTRY("15minutes", "15 minutes.exe", "615e73fc1874e92d60a1996c2330ea36", 24136635),
	GAME_ENTRY("30minutes", "30minutes.exe", "18f5fd85de78efca16c7bafce54e3f63", 17930417),
	GAME_ENTRY("1dayamosquito", "mosquito.exe", "465f972675db2da6040518221af5b0ba", 2178983),
	GAME_ENTRY("2034acaftercanada1", "MAGS_01_13.exe", "1280ba7c269a68a9505871516319db0c", 14123278),
	GAME_ENTRY("2034acaftercanada2", "2034 ac ii.exe", "1280ba7c269a68a9505871516319db0c", 35207006),
	GAME_ENTRY("24hours", "24.exe", "f120690b506dd63cd7d1112ea6af2f77", 1932370),
	GAME_ENTRY("3pigsandawolf", "3piggiesalpha.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 14181120),
	GAME_ENTRY("3pigsandawolf", "three little pigs and a wolf.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 14180634),
	GAME_ENTRY("46memorylane", "diyu.exe", "e3962995a70923a8d5a8f1cf8f932eee", 66686277),
	GAME_ENTRY("4lungboy", "4LungBoy.exe", "615e73fc1874e92d60a1996c2330ea36", 91014705),
	GAME_ENTRY("4ofclubs", "4ofclubs.exe", "06a03fe35791b0578068ab1873455463", 5909169),
	GAME_ENTRY("5daysastranger", "5days.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 4614351), // Special Edition
	GAME_ENTRY("5daysastranger", "5days.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 4440143), // v1.3
	GAME_ENTRY("5daysastranger", "5daysorig.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 4593115),
	GAME_ENTRY("5oclocklock", "dadgame.exe", "3018c5443291aec823bc63342ce4c58b", 6073887),
	GAME_ENTRY("6daysasacrifice", "6das.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7993899),
	GAME_ENTRY("6daysasacrifice", "6das se.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8173314),
	GAME_ENTRY("6mornings", "project2.exe", "e7dac058b9bc0b42d489e474c2ddec84", 11595240),
	GAME_ENTRY("7daysaskeptic", "7days.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 4863356),
	GAME_ENTRY("7daysaskeptic", "7days.exe", "465f972675db2da6040518221af5b0ba", 4693374),
	GAME_ENTRY("9hourstodawn", "9h2d.exe", "94d1b64c658b4731141e4482c88f0d79", 110935816),
	GAME_ENTRY("9monthsin", "9 Months In.exe", "7407eea3a8a88cca77c59f0a3a400f36", 33372910),
	GAME_ENTRY("abducted", "10 minutes.exe", "465f972675db2da6040518221af5b0ba", 2687034),
	GAME_ENTRY("abducted10mins", "10 minutes.exe", "465f972675db2da6040518221af5b0ba", 2688871),
	GAME_ENTRY("abduction", "Abduction.exe", "a524cbb1c51589903c4043b98917f1d9", 144332695),
	GAME_ENTRY("abduction", "Abduction.exe", "a524cbb1c51589903c4043b98917f1d9", 144408290),
	GAME_ENTRY("abettermousetrap", "trap.exe", "0b7529a76f38283d6e850b8d56526fc1", 4735739),
	GAME_ENTRY("ablemabel", "Able Mabel.exe", "618d7dce9631229b4579340b964c6810", 16175891),
	GAME_ENTRY("absent", "absent.exe", "aabdafae8b57dfc48fdf158a72326c23", 39284149),
	GAME_ENTRY("absentpart1", "absent - part i.exe", "34ca36e3948aae8527dd0e90f0861a75", 31421924),
	GAME_ENTRY("absin", "black_project.exe", "b142b43c146c25443a1d155d441a6a81", 8787461),
	GAME_ENTRY("absurdistan", "Absurdistan.exe", "4588012d3077d6b6791fce8cd4b15885", 84568958),
	GAME_ENTRY("acatsnight1", "A Cat's Night.exe", "615e73fc1874e92d60a1996c2330ea36", 73906461),
	GAME_ENTRY("acatsnight2", "A Cat's Night 2.exe", "1bc32c4f5753b1ccbc60b2735b89bd4c", 226162327),
	GAME_ENTRY("access", "access.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 1816218),
	GAME_ENTRY("aceking", "ags.exe", "f982756f0e2c2fbeca15d199b9851559", 338249917),
	GAME_ENTRY("acequest", "newgame.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 4124225),
	GAME_ENTRY("acharchronicles", "Oblitus.exe", "e37052201ffaea41ff1784f59ce47163", 55523181),
	GAME_ENTRY("achristmasblunder", "blunder.exe", "35c11dc3b5f73b290489503b0a7c89e5", 1974915),
	GAME_ENTRY("achristmasghost", "A Christmas Ghost.exe", "7971a7c02d414dc8cb33b6ec36080b91", 54309690),
	GAME_ENTRY("achristmasnightmare", "xmasnightmare.exe", "53db6ba4864b17a28b8176d92459c7bc", 49689828),  // v1.3 Windows
	GAME_ENTRY("achristmasnightmare", "xmasnightmare.ags", "3e9ca3f7786ca2c19e1718060726d44a", 46691215),  // v1.3 Linux
	GAME_ENTRY("achristmaswish", "A Christmas Wish.exe", "01d0e6bd812abaa307bcb10fc2193416", 3452454),
	GAME_ENTRY("aciddd", "acidddd.exe", "06a03fe35791b0578068ab1873455463", 1858394),
	GAME_ENTRY("acjadventure", "CJADVENTURE.exe", "06a03fe35791b0578068ab1873455463", 1653029),
	GAME_ENTRY("acureforthecommoncold", "game.exe", "06a03fe35791b0578068ab1873455463", 5247960),
	GAME_ENTRY("acuriouspastime", "Curious.exe", "4cdf7cf9047ca83b3221a95664ee36d2", 485278752),
	GAME_ENTRY("acurioussilence", "silence.exe", "495d45fb8adfd49690ae3b97921feec6", 8039714),
	GAME_ENTRY_PLATFORM("adateinthepark", "a date in the park.exe", "59fe2aa2cc67589f11707ddc5a7f01cc", 47324098, "itch.io/Steam"), // TODO: split
	GAME_ENTRY("adaywithmichael", "adwm.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 65283966),
	GAME_ENTRY("advallinthegame", "all in the game.exe", "bb59de174d70797d774dec76a171352d", 843215726),
	GAME_ENTRY("advbunnybunnyman", "Game.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 13431315),
	GAME_ENTRY("advbunnybunnyman", "Pupupeli.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 13453697),
	GAME_ENTRY("adventureisland", "adisland.exe", "6d2f8e80c5f2372b705fdd4cc32f3579", 51032657),  // v3
	GAME_ENTRY("adventuresofjoshanddyan", "joshanddyan.exe", "90413e9ae57e222f8913b09d2bc847bc", 3053444),
	GAME_ENTRY("adventuresofmaxfaxepisode1", "maxfax1.exe", "f95aa7fd4c60ae0c64ab2bca085d0d15", 111272141),
	GAME_ENTRY("adventuresofprincessmarian", "marian.exe", "97d700529f5cc826f230c27acf81adfd", 3637811),
	GAME_ENTRY("adventuretheinsidejob", "thalia.exe", "615e806856b7730afadf1fea9a756b70", 305012295),
	GAME_ENTRY("advwelcome", "welcome to the genre.exe", "7b312aca49376e8a92bc31c612dfe81d", 31339728),
	GAME_ENTRY("aerinde", "aerinde.exe", "3d40063da244931d67726a2d9600f1e8", 31700697),
	GAME_ENTRY("aeronuts", "aeronuts.exe", "e446d58cf60bf13e32d0edd470065c7d", 10984662),
	GAME_ENTRY("aeronuts", "aeronuts.exe", "820ac8a9776518d8510404c2deaf6328", 11469798),
	GAME_ENTRY_PLATFORM("affairoftheweirdo", "max_griff_invg.exe", "acf67190f218f04bcafec14c0864c220", 5279933, "v1.0.0"),
	GAME_ENTRY_PLATFORM("affairoftheweirdo", "max_griff_invg.exe", "acf67190f218f04bcafec14c0864c220", 5153491, "v1.0.1"),
	GAME_ENTRY("afragmentofher", "afragmentofher_v0.2.1.0.exe", "618d7dce9631229b4579340b964c6810", 8400475),
	GAME_ENTRY("afriendindeed", "thehouse.exe", "3128b9f90e2f954ba704414ae854d10b", 6197624),
	GAME_ENTRY("afterashadow", "after a shadow.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6157553),
	GAME_ENTRY("agentbee", "BEE.exe", "95dcf736be87cf7d40bf64d5b078c4b7", 45542087),
	GAME_ENTRY("agenthudson", "ah.exe", "c7916b82f00c94013a3f7706b4d333c6", 15479216),
	GAME_ENTRY("agenttrinityepisode0theultimatum", "theultimatum_03.exe", "615e73fc1874e92d60a1996c2330ea36", 3777519),
	GAME_ENTRY("aggghost", "verbcoin.exe", "88d4158acfc9db9299e514979f289ced", 23937962),
	GAME_ENTRY("agitprop", "agitprop.exe", "a524cbb1c51589903c4043b98917f1d9", 12834513),
	GAME_ENTRY("agnosticchicken", "chicken.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 2473154),
	GAME_ENTRY("agsawards2008", "aa2008.exe", "2615d67c2234f387e0ffd1a375476be0", 15151764),
	GAME_ENTRY("agsawards2016", "AGS Awards 2016.exe", "6e861b1f476ff7cdf036082abb271329", 389520873),
	GAME_ENTRY("agsawards2017", "AGS Awards 2017.exe", "78dd4ca028ee0156b6a093d6d780aa65", 799003462),
	GAME_ENTRY("agsawards2020", "AGS Awards 2020.exe", "1466cb5cd32c5ce4a4dbc6e4975f8991", 346110549),
	GAME_ENTRY("agsawards2020", "AGS Awards 2020.exe", "1466cb5cd32c5ce4a4dbc6e4975f8991", 346114803),
	GAME_ENTRY("agsawardsbp", "AGS Awards Backstage Pass.exe", "82da2565c456dcfb265ded6fe3189c0b", 6458787),
	GAME_ENTRY("agscamerastd", "camdemo.exe", "17009da9820f5aa86d0588023d497db8", 26012159),  // Windows
	GAME_ENTRY("agscamerastd", "camdemo.ags", "4e6e999d090581aea259ee10428d5628", 22977515),  // Linux
	GAME_ENTRY("agschess", "chess.exe", "f120690b506dd63cd7d1112ea6af2f77", 1198934),
	GAME_ENTRY("agsdarts", "ags darts.exe", "434c43a5e1ba2a11c1bde723ffeae719", 47771575),
	GAME_ENTRY("agsdarts2", "AGS 180 Darts 2.exe", "96bdc335c417f8e15e1361df894e3ced", 276660650),
	GAME_ENTRY("agsinvaders", "ags-invaders.exe", "f120690b506dd63cd7d1112ea6af2f77", 1394435),
	GAME_ENTRY("agsjukebox", "jukebox2.exe", "a7aef57e360306c9377164f38d317ccb", 2914973),
	GAME_ENTRY("agslife", "AGSLife.exe", "f2be2a4ef91e99bd902536da5f3290c7", 9608578),
	GAME_ENTRY("agsmagus", "AGS Wizard.exe", "434c43a5e1ba2a11c1bde723ffeae719", 21177588),
	GAME_ENTRY("agsmastermind", "AGS Mastermind.exe", "519c0d37ab893d95f5add495355e460c", 30196465),
	GAME_ENTRY("agsmittensshooter", "clex.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 1381575),
	GAME_ENTRY("agsmoduletester", "v1.0 source.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 2020344),
	GAME_ENTRY("agsyahtzee", "ags yathzee.exe", "434c43a5e1ba2a11c1bde723ffeae719", 37295758),
	GAME_ENTRY("agsyahtzee", "ags yathzee.exe", "434c43a5e1ba2a11c1bde723ffeae719", 39185090),  // v2.0
	GAME_ENTRY("agsyahtzee2", "ags yahtzee 2.exe", "9e995c04d8642d6182d492c54a90b188", 71217276),
	GAME_ENTRY("agunshotinroom37", "agir37.exe", "f120690b506dd63cd7d1112ea6af2f77", 1451303),
	GAME_ENTRY("ahmetsagsfightgameremix", "fight.exe", "f120690b506dd63cd7d1112ea6af2f77", 2469641),
	GAME_ENTRY("ahomieadventure", "AHA_20150820_00_src.exe", "0241777c2537fc5d077c05cde10bfa9f", 3902636),
	GAME_ENTRY("aidaschristmas", "Aidas Strange Christmas.exe", "9cb3c8dc7a8ab9c44815955696be2677", 15568945),
	GAME_ENTRY("ainthegoffantabulousw", "gfw.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7991393),
	GAME_ENTRY("airbreak", "Airbreak.exe", "28567bd2dc355a02a0ba58749e753f87", 23126098),
	GAME_ENTRY("airwaveifoughtthelawandthelawone", "~airwave~.exe", "18456f28d9bf843b087e80072c85beca", 22521544),
	GAME_ENTRY("alandlordsdream", "Game.exe", "0241777c2537fc5d077c05cde10bfa9f", 6212265),
	GAME_ENTRY("alandlordsdream", "Game.exe", "7db052bc30700d1f30f5330f5814f519", 8060425),
	GAME_ENTRY("alansaveschristmas", "alancmas.exe", "3f76f9c4249bdc06794c13b098229c90", 39312224),
	GAME_ENTRY("alansaveschristmas", "alancmas.exe", "9db90e244d6f3476191d3d4de189509d", 39295833),
	GAME_ENTRY("albatheexplorer", "alba_explorer.exe", "0500aacb6c176d47ac0f8158f055db83", 2026147),
	GAME_ENTRY("alienattack", "alien attack.exe", "06a03fe35791b0578068ab1873455463", 11045476),
	GAME_ENTRY("aliencarniage", "AlienCarni.exe", "06a03fe35791b0578068ab1873455463", 22301801),
	GAME_ENTRY("aliencowrampage", "alien.exe", "57dc38c78f323afa45e486ee7fff767f", 15639495),
	GAME_ENTRY("alienescapade", "Alien Escapade.exe", "4fb72c890984548ed6782063f2230942", 30092272),
	GAME_ENTRY("alienpuzzleinvasion", "alien.exe", "a524cbb1c51589903c4043b98917f1d9", 10552264),
	GAME_ENTRY("alienrapeescape", "a.r.e.exe", "39d7a558298a9f1d40c1f415daf9bb74", 4802707),
	GAME_ENTRY("alienthreat", "alien threat.exe", "f120690b506dd63cd7d1112ea6af2f77", 6341266),
	GAME_ENTRY("alientimezone", "atz.exe", "0710e2ec71042617f565c01824f0cf3c", 2911858),
	GAME_ENTRY("allgonesoon", "All_Gone_Soon.exe", "618d7dce9631229b4579340b964c6810", 8858991),
	GAME_ENTRY("allgonesoon2", "AGS2.exe", "618d7dce9631229b4579340b964c6810", 11140718),
	GAME_ENTRY("allpigs", "All pigs deserve to burn in hell.exe", "973f6b65820ca1f4e19704a49be99d76", 20836147),
	GAME_ENTRY("aloneinthenight", "alone.exe", "0710e2ec71042617f565c01824f0cf3c", 9501343),
	GAME_ENTRY_PLATFORM("alphabeta", "Alphabeta.exe", "5992f37daae6ea70654e9544e62ebb97", 2601798, "unfinished"),
	GAME_ENTRY("alphablock", "AlphaBlock.exe", "962449147c1646ee07d4022c79c6cd8b", 14360875),  // Windows
	GAME_ENTRY("alphablock", "AlphaBlock.ags", "7eb3b39b6fb6a5dfcaa058ab371a22f2", 11327255),  // Linux
	GAME_ENTRY("alphadog", "alpha_dog.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 3329253),
	GAME_ENTRY("alphaxsmash", "project smash.exe", "06a03fe35791b0578068ab1873455463", 25377719),
	GAME_ENTRY("alysvsthephantomfelinefoe", "alys.exe", "3c5bd1713959ff469cb46ebe5542cfcf", 22323495),
	GAME_ENTRY("amagicstone", "a magic stone.exe", "465f972675db2da6040518221af5b0ba", 5478520),
	GAME_ENTRY("amotospuf", "amotos.exe", "06a03fe35791b0578068ab1873455463", 10771879),
	GAME_ENTRY("amongthorns", "Among Thorns.exe", "b5c41e08919834b549ca350a28f18f87", 64621203),
	GAME_ENTRY("amtag", "amtag.exe", "06a03fe35791b0578068ab1873455463", 8755912),
	GAME_ENTRY("amused", "TheMeanTime.exe", "615e73fc1874e92d60a1996c2330ea36", 5113261),
	GAME_ENTRY("analienswork", "AWIND.exe", "0710e2ec71042617f565c01824f0cf3c", 4460224),
	GAME_ENTRY("ancientaliens", "AAliens.exe", "82da2565c456dcfb265ded6fe3189c0b", 49750239),
	GAME_ENTRY("aneternityreflecting", "An Eternity, Reflecting.exe", "78dd4ca028ee0156b6a093d6d780aa65", 53731093),
	GAME_ENTRY_PLATFORM("anightinberry", "Nuit en Berry.exe", "06a03fe35791b0578068ab1873455463", 336951778, "Original"),  //2016 release
	GAME_ENTRY_PLATFORM("anightinberry", "Nuit en Berry.exe", "d5225f13aa4356e9524fb0de9375cecc", 744946585, "Longer Version"),  //v2.0.5 2019 release
	GAME_ENTRY("anightmareonduckburg", "ANoD.exe", "c9cd3e2cdd295c33e62cfa97b14461e9", 91549100),
	GAME_ENTRY("anightthatwouldntend", "Game.exe", "0241777c2537fc5d077c05cde10bfa9f", 14559632),
	GAME_ENTRY("anighttoremember", "the trials.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 9643993),
	GAME_ENTRY("anna", "anna.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 42337759),  // v1.0
	GAME_ENTRY("anna", "anna.exe", "548d8cf1c544c85da3e78b7aa65a6d41", 16572928),
	GAME_ENTRY("annieandroidautomatedaffection", "annie source.exe", "fc17e9b3ab53f6b4841e2a4af5c782ff", 5015270),
	GAME_ENTRY("anoblegame", "a_noble_game.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3580379),
	GAME_ENTRY("anotherwayout", "1week.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7870567),
	GAME_ENTRY("anthonysessay", "copy of school.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 11033611),
	GAME_ENTRY("anticipatingmurder", "ags.exe", "f120690b506dd63cd7d1112ea6af2f77", 19907137),
	GAME_ENTRY("antiheroes", "antiheroes.exe", "f120690b506dd63cd7d1112ea6af2f77", 3984580),
	GAME_ENTRY("antiheroes", "antiheroes.exe", "f120690b506dd63cd7d1112ea6af2f77", 3982762),
	GAME_ENTRY("anxiousawakening", "An Anxious Awakening.exe", "0241777c2537fc5d077c05cde10bfa9f", 3991332),
	GAME_ENTRY("apiratestale", "a_pirates_tale.exe", "06a03fe35791b0578068ab1873455463", 13952670),
	GAME_ENTRY("aplaceinthesun", "inthesun.exe", "7a3096ac0237cb6aa8e1718e28caf039", 40359648),
	GAME_ENTRY("aplacewithoutfrontier", "Frontier.exe", "9cb3c8dc7a8ab9c44815955696be2677", 17733652),
	GAME_ENTRY("apocalypsemeow1", "CaK3.exe", "97d700529f5cc826f230c27acf81adfd", 6044911),
	GAME_ENTRY("apocalypsevel", "MAGSGAME.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 5025809),
	GAME_ENTRY("applefarm", "Apple farm.exe", "82da2565c456dcfb265ded6fe3189c0b", 5483907),
	GAME_ENTRY("appointmentwithdeath", "APD.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 1321938),
	GAME_ENTRY("apprentice", "app.exe", "ecc8eaa38fe3adea61ffc525d2ce5c0e", 14110306),
	GAME_ENTRY_PLATFORM("apprentice", "app.exe", "45ab4f29031b50c8d01d10a269f77ff5", 17488604, "Deluxe"),
	GAME_ENTRY("apprentice2", "app2.exe", "465f972675db2da6040518221af5b0ba", 34159191),
	GAME_ENTRY("aprofoundjourney", "apj.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 920131),
	GAME_ENTRY("apunkwithwheels", "A punk with wheels.exe", "d90cd956022235ed9b272fb0b2ab5792", 17924043),
	GAME_ENTRY("aractaur", "aractaur.exe", "aecd482222ff54206e43a029b5f0b170", 5318963),
	GAME_ENTRY("araindogstory", "Raindog.exe", "09cf8b451781575fa3ba1a0e31f5fc66", 96888573),
	GAME_ENTRY("archeos", "archeos.exe", "2ff048659aaefd20d342db6428a5f1a0", 6659974),
	GAME_ENTRY("archeos", "archeos.exe", "2ff048659aaefd20d342db6428a5f1a0", 6661410),
	GAME_ENTRY("archeos", "archeos.ags", "050b3e5c5486fb6b977712cb4e4d6058", 4217618),
	GAME_ENTRY("ardensvale", "Arden's Vale.exe", "588df1c52f2ecdc6af866cd06b9810e1", 20097804),
	GAME_ENTRY("ardentfever", "Ardent Fever.exe", "d32f0fb244a8f815e7e87a78aa5dcee3", 3979543),
	GAME_ENTRY("arewethereyet", "arewethereyet.exe", "f120690b506dd63cd7d1112ea6af2f77", 1054672),
	GAME_ENTRY("arjunaz78", "Arjunaz78.exe", "2748aefd266d40d9a14088cb77293549", 11368111),
	GAME_ENTRY("aroomwithoutyou", "aroomwithoutyou.ags", "34ba844fe761f8a9da2cf1076c30d847", 27163303),
	GAME_ENTRY("aroomwithoutyou", "aroomwithoutyou.exe", "7ddb9e776648faed5a51170d087074e9", 29650615),
	GAME_ENTRY("armageddonmargaret", "am_game.exe", "06a03fe35791b0578068ab1873455463", 3640885),
	GAME_ENTRY("armageddonmargaret", "armageddon margaret.exe", "3128b9f90e2f954ba704414ae854d10b", 2951568),
	GAME_ENTRY("armageddonmargaret", "mags.exe", "3128b9f90e2f954ba704414ae854d10b", 2951568),
	GAME_ENTRY("asecondface", "eye of geltz.exe", "0e32c4b3380e286dc0cea8550f1c045e", 7061019),
	GAME_ENTRY("ashortnightmare", "a_short_nightmare.exe", "b142b43c146c25443a1d155d441a6a81", 94221930),
	GAME_ENTRY("asimplefix", "A simple fix.exe", "615e73fc1874e92d60a1996c2330ea36", 27488921),
	GAME_ENTRY("asporia", "rpg.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 7094164),
	GAME_ENTRY("asterix", "asterix.exe", "06a03fe35791b0578068ab1873455463", 62405430),
	GAME_ENTRY("astranded", "astranded.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 1845395),
	GAME_ENTRY("astron", "astron.exe", "a0fd918609b9d139e4076fa7a0052ae1", 71101771),
	GAME_ENTRY("asuspiciousdate", "MAGS May.exe", "39d9d0f826b7510c850c55c109230cb4", 4686146),
	GAME_ENTRY("aswinsdream", "agsgame.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 14384181),
	GAME_ENTRY("ataintedtreat", "A Tainted Treat.exe", "615e73fc1874e92d60a1996c2330ea36", 5737926),
	GAME_ENTRY("ataleinthezoo", "MAGS-Jan.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 16729569),
	GAME_ENTRY("ataleofbetrayal", "mags.exe", "465f972675db2da6040518221af5b0ba", 11071496),
	GAME_ENTRY("atapi", "atapi.exe", "dd8586ebefd5c457e29b6b9845a576ea", 34114381),
	GAME_ENTRY("athingaboutnothingness", "LD26.exe", "615e73fc1874e92d60a1996c2330ea36", 5654082),
	GAME_ENTRY("atotk", "atotk.exe", "37cf2d4d07842d45b59c6dd9387c1ee7", 42785860),
	GAME_ENTRY("atotk", "atotk.exe", "37cf2d4d07842d45b59c6dd9387c1ee7", 42740200),
	GAME_ENTRY("atotk", "atotk.exe", "37cf2d4d07842d45b59c6dd9387c1ee7", 42872046),
	GAME_ENTRY("atotk", "atotk.exe", "68d4f3488a9dcec74584651c0e29e439", 5078309),
	GAME_ENTRY("atotkjukebox", "jukebox.exe", "37cf2d4d07842d45b59c6dd9387c1ee7", 1631992),
	GAME_ENTRY("atreatandsometricks", "a treat and some tricks.exe", "495d45fb8adfd49690ae3b97921feec6", 33708250),
	GAME_ENTRY("atthecafe", "At the cafe.exe", "615e73fc1874e92d60a1996c2330ea36", 3192558),
	GAME_ENTRY("audioquest", "Audio Quest.exe", "06a03fe35791b0578068ab1873455463", 1638472),
	GAME_ENTRY("aunaturel", "au naturel.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 8499426),
	GAME_ENTRY("automation", "automation.exe", "c16204dc8aa338e3199b2c62da0b33f4", 3943320),
	GAME_ENTRY("averyspecialdog", "dog.exe", "465f972675db2da6040518221af5b0ba", 2120544),
	GAME_ENTRY("awakener", "awakener.exe", "3e62eafed0fc365821b7afdbf1aec3d8", 8896076),
	GAME_ENTRY("awakening", "eob.exe", "a524cbb1c51589903c4043b98917f1d9", 21527657),
	GAME_ENTRY("awalkindatomb", "full game.exe", "0710e2ec71042617f565c01824f0cf3c", 1312738),
	GAME_ENTRY("awalkinthepark", "sag_mag_04_08.exe", "9cb3c8dc7a8ab9c44815955696be2677", 2908542),
	GAME_ENTRY("awayinatower", "SoringCleaning.exe", "615e73fc1874e92d60a1996c2330ea36", 6231313),
	GAME_ENTRY("awesmoequest", "Awesmoe.exe", "06a03fe35791b0578068ab1873455463", 1440230),
	GAME_ENTRY("awomanforallseasons", "A Woman For All Seasons.exe", "77c325a29d4b45fe9bb38761fb17118b", 4171441),
	GAME_ENTRY("axmasevetale", "mags.exe", "71ca0d6c1c699595f28a2125948d4a84", 6489870),
	GAME_ENTRY("backdoorman", "hustler.exe", "2c26669a627da8e1e5159319b78ad1ce", 9558000),
	GAME_ENTRY("backlot", "BackRemake.exe", "a524cbb1c51589903c4043b98917f1d9", 4252039),
	GAME_ENTRY("badbunker", "Bad Bunker.exe", "b216ee957dd677023e02d900281a02d6", 3457312),
	GAME_ENTRY("badluck", "bad luck.exe", "f120690b506dd63cd7d1112ea6af2f77", 10618466),
	GAME_ENTRY("bakeoffitalia", "bakeoff.exe", "39b1e8b82bd8e4dc1f0e54ce100e0fa5", 9128728),  // v0.9.7 Windows
	GAME_ENTRY("bakeoffitalia", "bakeoff.ags", "974fa0136dbc927485a1a1a085e26369", 5973764),  // v0.9.7 Linux
	GAME_ENTRY("baldysadventure", "baldy.exe", "ea0d3284542db629f36cb6fc785e07bc", 179358984),
	GAME_ENTRY("baltazarthefamiliar", "baltazar.exe", "9cb3c8dc7a8ab9c44815955696be2677", 2867294),
	GAME_ENTRY("balloonface", "hg.exe", "0710e2ec71042617f565c01824f0cf3c", 2189438),
	GAME_ENTRY("bananaracer", "bananaracer.exe", "e93f9dfa8405f1ca9f881d160ab31dc2", 10452233),
	GAME_ENTRY("bananaracer", "bananaracer.exe", "e93f9dfa8405f1ca9f881d160ab31dc2", 10454173),
	GAME_ENTRY("barahir", "Barahir.exe", "5677656386de765e72b7400f1e631eed", 40520601),  // v1.2 Windows
	GAME_ENTRY("barahir", "Barahir.ags", "07560dece6654ae594efd210975be588", 37382021),  // v1.2 Linux
	GAME_ENTRY("barhoppers", "BarHoppers.exe", "f18443f98fd61d2c655e76a17f7da905", 22590227),
	GAME_ENTRY("barndilemma", "woh.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 2432485),
	GAME_ENTRY("barnrunner1p1", "eclair 1.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 13202017),
	GAME_ENTRY("barnrunner1p2", "eclair 2.exe", "465f972675db2da6040518221af5b0ba", 34193929),
	GAME_ENTRY("barnrunner3", "Mini Game 3.exe", "465f972675db2da6040518221af5b0ba", 3455484),
	GAME_ENTRY("barnrunner4", "Barn Runner 4.exe", "465f972675db2da6040518221af5b0ba", 4954262),
	GAME_ENTRY("barnrunner5p1", "barn runner 5-1.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 104073543),
	GAME_ENTRY("barnrunner5p2", "barn runner 5-2.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 200879890),
	GAME_ENTRY("barnrunner5p3", "Barn Runner 5-3.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 236158866),
	GAME_ENTRY("barnrunnerbake1", "BR Bake Sale 1.exe", "18b284c22010850f79bc5c20054a70c4", 29716432),
	GAME_ENTRY("barnrunnerhall1", "BR Halloween 1.exe", "18b284c22010850f79bc5c20054a70c4", 52243988),
	GAME_ENTRY("barnrunnervalentine1", "BR Valentine 1.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 101774857),
	GAME_ENTRY("barnrunnervn1", "BR VN1.exe", "809418706c429cee5d88e8d483c906cc", 26857313),
	GAME_ENTRY("barnrunnerxmas0", "BR Xmas 0.exe", "615e806856b7730afadf1fea9a756b70", 13689876),
	GAME_ENTRY("barnrunnerxmas2", "xmas 2.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 31770973),
	GAME_ENTRY("barrier", "Barrier.exe", "615e73fc1874e92d60a1996c2330ea36", 19111101),
	GAME_ENTRY("barrunner", "Bar Runner.exe", "615e73fc1874e92d60a1996c2330ea36", 3642405),
	GAME_ENTRY("bartolomeo", "Bartolomeo.exe", "f604f7f3a12da5d3bcf7a7814a14e43b", 42261079),
	GAME_ENTRY("bartsquestfortv", "simpsons.exe", "0500aacb6c176d47ac0f8158f055db83", 794013),
	GAME_ENTRY("bbcscreensaver", "BBC-Screensaver.exe", "0e6d6f3c19f5ca250b7b7ee03cdb2083", 131195371),
	GAME_ENTRY("bcremake", "bc.exe", "0710e2ec71042617f565c01824f0cf3c", 7683255),
	GAME_ENTRY("beacon", "beacon.exe", "af0d268193a9220891e983d03141ec58", 24671086),
	GAME_ENTRY("bear", "bear.exe", "97020973a2a635fe28eb0ba4bdfaa70b", 3258662),  //v1.3
	GAME_ENTRY("bearinvenice", "Bear in Venice.exe", "7d2c5cddcac88662b24165b3a0dd77c9", 20615211),
	GAME_ENTRY("beasts", "beasts.exe", "0500aacb6c176d47ac0f8158f055db83", 1295435),
	GAME_ENTRY("beautiesandbeasts", "beautiesandbeasts.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 6507202),
	GAME_ENTRY("beforethedarkcrystal2", "Before the Dark Crystal II.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 59569723),
	GAME_ENTRY("bellyofthebeast", "Belly of the beast.exe", "9f8a9d74c09f188af9af3e263f8b59bc", 22461502),  // Windows
	GAME_ENTRY("bellyofthebeast", "Belly of the beast.ags", "5b086e038c7bf4eada977f52f1d22cd7", 19425322),  // Linux
	GAME_ENTRY("belowzero", "Below Zero.exe", "06a03fe35791b0578068ab1873455463", 2506599),
	GAME_ENTRY("belusebiusarrival", "RoNXXL.exe", "465f972675db2da6040518221af5b0ba", 9426141),
	GAME_ENTRY("belusebiusarrival", "ronextra.exe", "465f972675db2da6040518221af5b0ba", 9958019),
	GAME_ENTRY("benchandlerpi", "BCPI.exe", "9c912b25b6768af44931d7cb40d1dac4", 5815085),
	GAME_ENTRY("bentheredanthat", "btdt.exe", "90413e9ae57e222f8913b09d2bc847bc", 46342499),
	GAME_ENTRY_PLATFORM("bentheredanthat", "btdt.exe", "90413e9ae57e222f8913b09d2bc847bc", 89521873, "Special Edition/Steam"),
	GAME_ENTRY("beprepared", "skavti1.exe", "615e73fc1874e92d60a1996c2330ea36", 23113815),
	GAME_ENTRY("berthabuttsboogie", "berthabutt.exe", "a524cbb1c51589903c4043b98917f1d9", 5684614),
	GAME_ENTRY("besieged", "besieged.exe", "615e806856b7730afadf1fea9a756b70", 11679795),
	GAME_ENTRY("bestowersofeternity", "eternity.exe", "0b66a68c2c8aabe78c80e30b8b82acef", 16187539),
	GAME_ENTRY("betrayal", "OROW.exe", "615e73fc1874e92d60a1996c2330ea36", 3240170),
	GAME_ENTRY("betweenpillars", "Pillars.exe", "04706182ca048f6506d6342f420ae501", 395512813),
	GAME_ENTRY("beyondeternity1", "Eternity1.exe", "5871918713de85ee4bae331ca3284184", 26381630),
	GAME_ENTRY("beyondhorizon", "Beyond Horizon.exe", "338fa79960d40689063af31c671b8729", 173615276),
	GAME_ENTRY("beyondreality", "br.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 10879320),
	GAME_ENTRY("beyondterror", "beyondterror.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8219797),
	GAME_ENTRY("beyondthedoor", "btd.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 6450527),
	GAME_ENTRY("beyondthehorizon", "horizon.exe", "4d7d2addcde045dae6e0363a43f9acad", 15708563),
	GAME_ENTRY("bicschristmastale", "AGS - MAGS 1208.exe", "01d0e6bd812abaa307bcb0fc2193416", 2509865),
	GAME_ENTRY("bigbadwolf3lilpiggies", "big bad wolf.exe", "06a03fe35791b0578068ab1873455463", 5812024),
	GAME_ENTRY("bigblue", "WorldDom.exe", "615e73fc1874e92d60a1996c2330ea36", 10079085),
	GAME_ENTRY("bigfoot", "Game.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 97902481),
	GAME_ENTRY("bigglesonmars", "biggles on mars.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 29048931),
	GAME_ENTRY("bigtroubleinlittleimola", "adventure.exe", "495d45fb8adfd49690ae3b97921feec6", 711456988),
	GAME_ENTRY("billybstar", "Billy B Star.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1756026),
	GAME_ENTRY("billyboysimportantwinelottery", "billyboy.exe", "5881d6b88386317dc9d67524a14b11d4", 4872317),
	GAME_ENTRY("billygoatsgruff", "billygoatsgruff.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 5949489),
	GAME_ENTRY("billymasterswasright", "Billy Masters Was Right.exe", "6fe5526eb7dc5b8fe82fb447a4701af7", 44901409),
	GAME_ENTRY("bioluminescence", "MAGS May.exe", "615e73fc1874e92d60a1996c2330ea36", 12887295),
	GAME_ENTRY("bird", "bird.exe", "2c1fd0f6fb167d5e69080d8c0946a2dc", 110011869),  // Windows
	GAME_ENTRY("bird", "bird.ags", "dfa991c129b488afcf54b957cd8d5710", 107520461),  // Linux
	GAME_ENTRY("birdy", "birdy.exe", "06a03fe35791b0578068ab1873455463", 4250415),
	GAME_ENTRY("birdybirdy", "BirdyBirdy.exe", "f907e03f753f87a08d67ee20719654c2", 21144151),  //  Windows
	GAME_ENTRY("birdybirdy", "BirdyBirdy.ags", "ec6416ed1649d7a829fe6f31be40498a", 8890619),  //Linux
	GAME_ENTRY("bitstream", "Bitstream.exe", "e8617c9bf3fce67aa8da088c6daa4152", 610992645),
	GAME_ENTRY("bittersweet", "Bittersweet.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 42348607),  // v1.02 itch.io
	GAME_ENTRY("biwa", "biwa.exe", "0500aacb6c176d47ac0f8158f055db83", 6109499),
	GAME_ENTRY_PLATFORM("bjcase1", "bj1deluxe.exe", "8275249f4ffbc28c1f10ad09a2786814", 8293704, "Deluxe"),
	GAME_ENTRY("bjcase1", "bj1.exe", "4b1378721f4f066f75102f3dca809224", 5678910),
	GAME_ENTRY("bjcase2", "bj2.exe", "465f972675db2da6040518221af5b0ba", 6318491),
	GAME_ENTRY_PLATFORM("bjcase2", "BJ2Deluxe.exe", "18b284c22010850f79bc5c20054a70c4", 7055507, "Deluxe"),
	GAME_ENTRY("bjcase3", "bj3.exe", "61f113e2e52e0dd27aeb438a55dd9b8c", 10841883),
	GAME_ENTRY("bjcase4", "bj4.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 15303392),
	GAME_ENTRY("bjcase5", "bj5.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 13681827),
	GAME_ENTRY("bjcase6", "bj6.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 18281493),
	GAME_ENTRY("bjcase7", "bj7.exe", "18b284c22010850f79bc5c20054a70c4", 13714066),
	GAME_ENTRY("bjcase8", "BJ8.exe", "98df40b0885b4e5f90f1093987f1f56c", 28334295),
	GAME_ENTRY("bjpww1", "BJWW.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3538560),
	GAME_ENTRY("blackfriday", "Black Friday.exe", "6fbfa4a25c909d8c2c1ee06da6b828a3", 7282327),  // Windows v1.0.3
	GAME_ENTRY("blackfriday", "Black Friday.ags", "84ab43eb263d80f844fa5d5910a5512d", 4759175),  // Linux v1.0.3
	GAME_ENTRY("blackmailinbrooklyn", "brooklyn.exe", "3192c36199d2b0784f866b28da7106d8", 4913695),
	GAME_ENTRY("blacksect1", "Black Sect Remake.exe", "615e73fc1874e92d60a1996c2330ea36", 34503092),
	GAME_ENTRY("blacksect2", "BS2-TCC.ags", "37ffa36feb915ed44cc94e2cec5b67ed", 19706314),
	GAME_ENTRY("blacksect2", "BS2-TCC.exe", "b96aaa8eae38a02f0c8c5262ec0a5057", 22765022),
	GAME_ENTRY("blackudder", "blackudder.exe", "338fa79960d40689063af31c671b8729", 87695958),
	GAME_ENTRY("bladespassion", "blades_of_passion.exe", "3f29c1146aff735c61362fc5162f42e4", 13267106),
	GAME_ENTRY("blindsweeper", "BlindSweeper.exe", "495d45fb8adfd49690ae3b97921feec6", 3437862),
	GAME_ENTRY("blindtosiberia", "blindtosiberia.exe", "e8985d9ffbfa1eda77f2eb8d1331944a", 5899304),
	GAME_ENTRY("bloodedfields", "Murder.exe", "48038a476d99d23499229a28ac4490cd", 4034796),
	GAME_ENTRY("bloodedfields", "Clock.ags", "817d6fbba647f2f5dfcd91ebd4fff17c", 611037),
	GAME_ENTRY("bluelobe", "Blue Lobe Inc.exe", "4d4b6d6e560cf32f440c39f8d3896da5", 34413450),
	GAME_ENTRY("boardquest", "board quest.exe", "465f972675db2da6040518221af5b0ba", 3930325),
	GAME_ENTRY("bob", "bob.exe", "0b7529a76f38283d6e850b8d56526fc1", 2874144),
	GAME_ENTRY("bobescapes", "bob en cavale.exe", "06a03fe35791b0578068ab1873455463", 43264937),
	GAME_ENTRY("bobgoeshome", "tut.exe", "0710e2ec71042617f565c01824f0cf3c", 1480234),
	GAME_ENTRY("bobgoeshomedeluxe", "bobdeluxe.exe", "0710e2ec71042617f565c01824f0cf3c", 1555913),
	GAME_ENTRY("bobsquest1", "bq19.exe", "97d700529f5cc826f230c27acf81adfd", 2767487),
	GAME_ENTRY("bogsadventure", "bogsadventure.exe", "25f919423520b921a041ec854e3a0217", 58789948),
	GAME_ENTRY("bogsadventureineasy3d", "Easy3D.exe", "06a03fe35791b0578068ab1873455463", 13361265),
	GAME_ENTRY("bohemianyard", "by.exe", "bdc14551f03d02b714a949be792a016b", 39643461),
	GAME_ENTRY("boilerroom", "brb.exe", "27343924ddad3be0b97bdcaa71858b1b", 4299483),
	GAME_ENTRY("boltaction", "BAction.exe", "7435dda89567847b6f6ae5211cbdffde", 91472413),
	GAME_ENTRY("bone", "Bone.exe", "eaa4f4b14a9fb5bb59aca188d765b41e", 4079499),
	GAME_ENTRY("boogiebum", "BoogieBum.exe", "2ca80bd50763378b72cd1e1cf25afac3", 4882195),
	GAME_ENTRY("bovinebyproduct", "cow.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 134670383),
	GAME_ENTRY("bowanddork", "BowAndDork.exe", "7db052bc30700d1f30f5330f5814f519", 17121243),  // Windows
	GAME_ENTRY("bowanddork", "BowAndDork.ags", "8728011855017e243bb95682d2898004", 14086087),  // Linux 
	GAME_ENTRY("bowserquirkquest", "bowser quirk quest.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 3046623),
	GAME_ENTRY("box", "box.exe", "0b7529a76f38283d6e850b8d56526fc1", 748638),
	GAME_ENTRY("boxfight", "boxen.exe", "3128b9f90e2f954ba704414ae854d10b", 3132938),
	GAME_ENTRY("boyindahood", "boy in da hood.exe", "afe40dc1416dd51e896ee0444d799f07", 12260759),
	GAME_ENTRY("bradbradsonkeyquest", "badness.exe", "0500aacb6c176d47ac0f8158f055db83", 1190580),
	GAME_ENTRY("breakage", "Breakage.exe", "973f6b65820ca1f4e19704a49be99d76", 727818639),
	GAME_ENTRY("breakdown", "breakdown.exe", "710ac163c281a5a539ffe2386264b990", 5273352),
	GAME_ENTRY("breakingcharacter", "Breaking character.exe", "615e73fc1874e92d60a1996c2330ea36", 23803957),
	GAME_ENTRY("breakfastont1", "BoT1.exe", "f08d8d658578a479c72a472380e2c324", 48866312),  // Windows
	GAME_ENTRY("breakfastont1", "BoT1.ags", "8fb32c0f7598562ee747b762c1ffb9e9", 45764084),  // Linux
	GAME_ENTRY("brokenwindows1", "Police.exe", "7ddb9e776648faed5a51170d087074e9", 16971333),
	GAME_ENTRY("brokenwindows2", "BW2.exe", "0564de07d3fd5c16e6947a647061913c", 16458558),
	GAME_ENTRY("brokenwindows3", "BW3.exe", "0564de07d3fd5c16e6947a647061913c", 16926857),
	GAME_ENTRY("brucequest", "bruce.exe", "f18443f98fd61d2c655e76a17f7da905", 30055288),
	GAME_ENTRY("bruises", "Bruises.exe", "1b9191cfa0fab42776cbaf7b02768a05", 8050720),
	GAME_ENTRY_PLATFORM("bruises", "Bruises.exe", "45ab64eb8ef455f82fa27fae73ca0785", 8058295, "Post-Jam Fixes"),
	GAME_ENTRY_PLATFORM("bruises", "Bruises.ags", "0fda16c094a6d1deafd8dd27aa98c287", 5567399, "Post-Jam Fixes"),
	GAME_ENTRY("bsg78", "bsg-e01.exe", "cf1ff01dfb8261f791ac95a7f5f05c1c", 401029955),
	GAME_ENTRY("bubblewrap", "bubble wrap popping simulator 2013.exe", "24275d3b085f0e6f3834311994eb1018", 3166059),
	GAME_ENTRY("bubsybobcat", "rip van bubsy.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 52424482),
	GAME_ENTRY("buccaneer", "buccaneer.exe", "c87aa6377abc18c1a1b2968ae6db08eb", 1576850),
	GAME_ENTRY("bullettrain", "bullet train.exe", "f120690b506dd63cd7d1112ea6af2f77", 17383747),
	GAME_ENTRY("bunawantsbeer", "bwb.exe", "c02022408287355175a601fd5ed1c66d", 2285202),
	GAME_ENTRY("bunnyquest", "bunnyquest.exe", "28f82e420b82d07651b68114f90223c8", 1154928),
	GAME_ENTRY("burymeinthesand", "buryme.exe", "f10516e88ec858700804ee69d041aead", 24252498),
	GAME_ENTRY("bustinthebastille", "Bastille.exe", "42f8802095baac3b5ed134635673cead", 722888946), // 1.05
	GAME_ENTRY("butcherstanys", "stanys.exe", "97d700529f5cc826f230c27acf81adfd", 1404933),
	GAME_ENTRY("butcherstanys2", "stanys.exe", "97d700529f5cc826f230c27acf81adfd", 1489182),
	GAME_ENTRY("byohero", "BYO-Hero.exe", "f0dd8a7e2c0e033d8f928e65aa54b10f", 163626763),
	GAME_ENTRY("bythenumbers", "By the Numbers.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 15781843),
	GAME_ENTRY("cabbagequest", "Cabbagequest.exe", "06a03fe35791b0578068ab1873455463", 4916170),
	GAME_ENTRY("cabbagesandkings", "fal.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 3611642),  // v2.0
	GAME_ENTRY_LANG("cachoquest", "CQ.exe", "06a03fe35791b0578068ab1873455463", 3166350, Common::ES_ESP),
	GAME_ENTRY("calebsdrunkenadventure", "calebdru.exe", "0b7529a76f38283d6e850b8d56526fc1", 15484923),
	GAME_ENTRY("calequest", "CQ1.exe", "dbebe4ccfe277d5d040ddb0b83265508", 361215392),  // v1.0
	GAME_ENTRY("callmegeorge1", "Call Me George.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 3872581),
	GAME_ENTRY("calsoon2", "looncalsoon.exe", "97d700529f5cc826f230c27acf81adfd", 18981033),
	GAME_ENTRY("capricorn", "capricorn.exe", "06a03fe35791b0578068ab1873455463", 4817076),
	GAME_ENTRY("camp1", "Camp1.exe", "d0c1d3be980d97e592ffe16b71a3b9f9", 34131784),
	GAME_ENTRY("captaincringe", "captain_cringe.exe", "dd8586ebefd5c457e29b6b9845a576ea", 2631464),
	GAME_ENTRY("captaindisastermoon", "CDiTDSotM.exe", "134528bfbb398455d06fa1dc1db5ca85", 44284638),
	GAME_ENTRY_STEAM("captaindisastermoon", "CDiTDSotM.exe", "ca313f3c6ade23c16e764f21940b0863", 44604440),
	GAME_ENTRY("captaindownes", "Captain Downes.exe", "78dd4ca028ee0156b6a093d6d780aa65", 32770340),  // Windows
	GAME_ENTRY("captaindownes", "Captain Downes.ags", "01c5914ae83d39dab345f2f70dd3e4ee", 30285588),  // Linux
	GAME_ENTRY("captaindownes", "ac2game.dat", "01c5914ae83d39dab345f2f70dd3e4ee", 30285588),  // Mac
	GAME_ENTRY("carrotbobinzxspeccyworld", "carrotbob.exe", "949f7440e3692b7366c2029979dee9a0", 914509),
	GAME_ENTRY("cartlife", "cartlife.exe", "7c8d67dd922fa543a1b1b76f9e1cc7c2", 21045074),
	GAME_ENTRY("casablancathedayafter", "casablanca.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 4238105),
	GAME_ENTRY("casenoir", "case noir.exe", "fd3ecd8289bebadbf775fe8a13b9c5d7", 15407193),
	GAME_ENTRY("casenoir", "case noir.exe", "2ca80bd50763378b72cd1e1cf25afac3", 15401399),
	GAME_ENTRY("caseofthemuffindiver", "TheMuffinDiver.exe", "0241777c2537fc5d077c05cde10bfa9f", 5344954),
	GAME_ENTRY("cassandra", "GPCv16.exe", "615e73fc1874e92d60a1996c2330ea36", 46787711),
	GAME_ENTRY("castleoffire", "castle of fire.exe", "b6f0726bd5776abee0d452b8f1073850", 14800915),
	GAME_ENTRY("catacombic", "catacombic.exe", "057d1aa29f6fadd83209268efcfb35a3", 7317791),
	GAME_ENTRY("catapault", "catapault.exe", "290afe0bac54418822f15175e474731d", 8286661),
	GAME_ENTRY("cauche", "Cauchemarionto.exe", "5f4c694e6dc897dc417fabd8ce0844e1", 5608334),
	GAME_ENTRY("caverns", "Caverns.exe", "c9cc759756e1f24783029948da533ccd", 20800343),
	GAME_ENTRY("caveofavarice", "CaveOfAvarice.exe", "f907e03f753f87a08d67ee20719654c2", 103572644),  // Windows
	GAME_ENTRY("caveofavarice", "CaveOfAvarice.ags", "0cc8aacba64fb6e53944d1ad37efac70", 100600464),  // Linux
	GAME_ENTRY("cayannepepper", "cpepper.exe", "06a03fe35791b0578068ab1873455463", 16117141),
	GAME_ENTRY("cedricandtherevolution", "elves!.exe", "b216ee957dd677023e02d900281a02d6", 10205755),
	GAME_ENTRY("cedricshooter", "CedricShooter.exe", "236d705f7a02fa1f44f734fb9eb054a5", 7101976),  // Windows
	GAME_ENTRY("cedricshooter", "CedricShooter.ags", "b44a79cd3b24a270f276f2b014e0b239", 4601352),  // Linux
	GAME_ENTRY("celestialcatastrophe", "CelestialCatastrophe.exe", "495d45fb8adfd49690ae3b97921feec6", 5164082),
	GAME_ENTRY("celticchaosep1", "CC1.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 18627665),
	GAME_ENTRY("celticchaosep2", "cc2.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 17463014),
	GAME_ENTRY("cgascreensaver", "CGASAVER12.exe", "ba86f02ab89fb54164e226bdcbd1d5e7", 387228637),
	GAME_ENTRY("chalkman", "Chalkman.exe", "d93777b4ac9542258ab4013ad14b271e", 102049536),
	GAME_ENTRY("chalksquest", "chalk.exe", "0710e2ec71042617f565c01824f0cf3c", 5138049),
	GAME_ENTRY("chanceofthedead", "chance.exe", "8418b150c267e4f1d462b9a5d60e507d", 5597569),
	GAME_ENTRY("charamba1", "Charamba.exe", "354e3016d64ac3378478d3d52ef0460d", 7468361),
	GAME_ENTRY("charamba2", "CharambaII.exe", "354e3016d64ac3378478d3d52ef0460d", 4975542),
	GAME_ENTRY("charliefoxtrot", "foxtrot.exe", "0500aacb6c176d47ac0f8158f055db83", 48626762),
	GAME_ENTRY("chasingrobot", "1st game.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 4687601),
	GAME_ENTRY("chatroom", "chatroom.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 6760748),
	GAME_ENTRY("cheerfulscience", "cheerfulscience.exe", "06a03fe35791b0578068ab1873455463", 7740040),
	GAME_ENTRY("chekken", "chekken.exe", "bde175c0c4d87a59a7a082be595d08da", 13477393),
	GAME_ENTRY("chemin", "chemin.exe", "06a03fe35791b0578068ab1873455463", 3179064),
	GAME_ENTRY("cherrysquest", "Coffee.exe", "1b0541ad9e6b6d3ceed71f6757f275c0", 9090885),
	GAME_ENTRY("chessboard", "ChessBoard.exe", "82da2565c456dcfb265ded6fe3189c0b", 2638884),
	GAME_ENTRY("chezapa", "chezapa.exe", "9cf51833e787cc919837d9a8bd8fc14c", 2870327),
	GAME_ENTRY("chickchaser", "amy.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7968024),
	GAME_ENTRY("chickenfraction", "chicken.exe", "0500aacb6c176d47ac0f8158f055db83", 3021315),
	GAME_ENTRY("chickenvsroad", "chicken.exe", "f120690b506dd63cd7d1112ea6af2f77", 1652888),
	GAME_ENTRY("chickenvsroad", "chicken.exe", "f120690b506dd63cd7d1112ea6af2f77", 30627567),  //v2.71
	GAME_ENTRY("chinesecheckers", "chinesecheckers.exe", "06a03fe35791b0578068ab1873455463", 3391826),
	GAME_ENTRY("chongoadv", "ChinaGame.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 31148695),
	GAME_ENTRY("chriscolumbus1", "ChrisColumbus.exe", "615e73fc1874e92d60a1996c2330ea36", 14817026),
	GAME_ENTRY("christmas42", "christmas_42.exe", "97f74f77ff127215fc44f35958fd2d55", 1546010),
	GAME_ENTRY("christmasgamearcade", "Xmas_2015.exe", "b5c41e08919834b549ca350a28f18f87", 7363985),
	GAME_ENTRY("christmashunt", "MyXmasGame.exe", "0241777c2537fc5d077c05cde10bfa9f", 3170875),
	GAME_ENTRY("christmaspresent", "christmas.exe", "3128b9f90e2f954ba704414ae854d10b", 5644948),
	GAME_ENTRY("christmasquest", "christmas quest.exe", "f120690b506dd63cd7d1112ea6af2f77", 14042816),
	GAME_ENTRY("christmasquest2", "christmasquest2.exe", "06a03fe35791b0578068ab1873455463", 22683950),
	GAME_ENTRY("christmasquest3", "cq3.exe", "f0a7712890942b9155193cc4488a07bc", 50854625),
	GAME_ENTRY("cirquedezale", "cirque.exe", "3128b9f90e2f954ba704414ae854d10b", 8547131),
	GAME_ENTRY("cityofthieves", "City of Thieves.exe", "74dc062c5f68f3d70da911f2db5737b6", 54527105),
	GAME_ENTRY("claire", "claire.exe", "b25674056fe8cc0b7bf0a4409c5c5bfc", 2781456),
	GAME_ENTRY("clarinette", "Clarinette.exe", "0eb179eb70b64b7a0d3da3585430d209", 14022754),
	GAME_ENTRY("classnotes", "classnotes.exe", "0710e2ec71042617f565c01824f0cf3c", 5706836),
	GAME_ENTRY("clipgoestotown", "clip goes to town.exe", "0710e2ec71042617f565c01824f0cf3c", 1690928),
	GAME_ENTRY("clotildesoffritti", "Clotilde astronave.exe", "286551ded3eedc428451e506e29196c9", 368664276),
	GAME_ENTRY("clownatthecircus", "circus.exe", "f120690b506dd63cd7d1112ea6af2f77", 1073547),
	GAME_ENTRY("clubofevil", "club of evil.exe", "65f53f81071dab6b3ab8363e4c76d12e", 11838011),
	GAME_ENTRY_LANG("coderbattle", "coderbattle.exe", "8bae5a42f382b38d516a7f8c8f686376", 23992763, Common::DE_DEU),
	GAME_ENTRY("coinopafternoon", "Let's Play Something.exe", "615e73fc1874e92d60a1996c2330ea36", 1225364411),  //English
	GAME_ENTRY_LANG("coinopafternoon", "Let's Play Something.exe", "e80586fdc2db32f65658b235d8cbc159", 900630574, Common::FR_FRA),  //French
	GAME_ENTRY("coinrush2", "coinrsh2.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 1260438),
	GAME_ENTRY("colaskunk", "MAGSAug2018.exe", "3c5bd1713959ff469cb46ebe5542cfcf", 17792401),
	GAME_ENTRY("coldhandreef", "WMAGS_0815.exe", "2ca80bd50763378b72cd1e1cf25afac3", 117129193),
	GAME_ENTRY("coldmeat", "Cold Meat.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 41382750),
	GAME_ENTRY("coldstorage", "coldstorage.exe", "f8e8f781a4a95c2bfea5f54b085df550", 3632485),
	GAME_ENTRY("colinsimpson", "office.exe", "06a03fe35791b0578068ab1873455463", 11781006),
	GAME_ENTRY("colourclash", "colourclash.exe", "0241777c2537fc5d077c05cde10bfa9f", 2803703),
	GAME_ENTRY("colourwise", "colourwise.exe", "473f0e2fd72b747cef62d91090ab74c7", 24461117),
	GAME_ENTRY("colourwiseleveleditor", "colourwise - Level Editor.exe", "3e09048ec0763a90ffa4eaeeb8f96df5", 3365519),
	GAME_ENTRY("columbuslander", "columbus lander.exe", "779421cd8ad5268e2efdb26e04608db7", 48744943),
	GAME_ENTRY_STEAM("comedyquest", "Comedy Quest.exe", "7a0123d8f6575e9954a18125456515f4", 22381783),
	GAME_ENTRY("comradecitizenpart1", "citizen.exe", "06a03fe35791b0578068ab1873455463", 2174301),
	GAME_ENTRY("concurrence", "Concurrence.exe", "27343924ddad3be0b97bdcaa71858b1b", 57168217),  //v1.1
	GAME_ENTRY("concurrence", "Concurrence.exe", "27343924ddad3be0b97bdcaa71858b1b", 58196965),  //v1.2
	GAME_ENTRY("confessionsofacatburglar", "cat.exe", "0500aacb6c176d47ac0f8158f055db83", 1328541),
	GAME_ENTRY("coniferskunks", "ConiferSkunksMAGS.exe", "7ddb9e776648faed5a51170d087074e9", 16898660),
	GAME_ENTRY("conspiracybelowzero", "conspiracy.exe", "338fa79960d40689063af31c671b8729", 395111008),
	GAME_ENTRY("conspiracyofsongo", "songo.exe", "934a3d245739d7ac66c021f8409c1044", 31526905),
	GAME_ENTRY("constancethebarbarian", "ctb.exe", "0500aacb6c176d47ac0f8158f055db83", 1150440),
	GAME_ENTRY("contact", "Contact.exe", "c40014c84e8d2d081154105ba4361849", 25017442),
	GAME_ENTRY("content", "Content.exe", "9878f9ded585f7191df2eebc01867c6e", 29828265),  // Windows Eng
	GAME_ENTRY_LANG("content", "Content_Kor.exe", "9878f9ded585f7191df2eebc01867c6e", 30127981, Common::KO_KOR),  // Windows Korean
	GAME_ENTRY("content", "Content.ags", "7a0e6b41e951aedd4385c10c15513835", 26690197),  // Linux
	GAME_ENTRY("contrapasso", "Commissar's Contrapasso.exe", "164da3f495c1fff9695893ec6622f4eb", 440822669),  // Windows
	GAME_ENTRY("contrapasso", "Commissar's Contrapasso.ags", "3e99c4265fbfcd89f04fc85d367289cd", 438328189),  // Linux
	GAME_ENTRY("contrapasso", "ac2game.dat", "3e99c4265fbfcd89f04fc85d367289cd", 438328189),  // Mac
	GAME_ENTRY("cop", "COP.exe", "465f972675db2da6040518221af5b0ba", 6439577),
	GAME_ENTRY("corneliuschristmas", "CorneliusCatChristmas.exe", "f6a5f0a2f617b84174b5ab48147ae9f7", 18946254),
	GAME_ENTRY("corneliuspest", "CorneliusCat.exe", "b5c41e08919834b549ca350a28f18f87", 26410221),
	GAME_ENTRY("cornersshiny", "Corner's Shiny.exe", "74dc062c5f68f3d70da911f2db5737b6", 2245296),
	GAME_ENTRY("cosmodyssey", "KosmoGameJam.exe", "495d45fb8adfd49690ae3b97921feec6", 663963764),
	GAME_ENTRY("cosmospuzzle", "space.exe", "0500aacb6c176d47ac0f8158f055db83", 3591766),
	GAME_ENTRY("cosmosquest1", "tfas1.exe", "ff3d6e4edfca8b4f4f1c6cbf8e2781a6", 16653211),
	GAME_ENTRY("cosmosquest2", "tfas2-32bit.exe", "ff3d6e4edfca8b4f4f1c6cbf8e2781a6", 118740291),
	GAME_ENTRY("cosmosquest3", "cq3.exe", "18b284c22010850f79bc5c20054a70c4", 8674790),
	GAME_ENTRY("cougarsquestforfreedom", "chra.exe", "0500aacb6c176d47ac0f8158f055db83", 12654043),
	GAME_ENTRY("cougarsquestforfreedom", "cqff.exe", "0500aacb6c176d47ac0f8158f055db83", 12590916),  //v1.0
	GAME_ENTRY("counterfeit", "counterfeit.exe", "ef1645ccd3d16691ec3908c91f340c34", 2232297),
	GAME_ENTRY("coupdecup", "newgame.exe", "949f7440e3692b7366c2029979dee9a0", 9635719),
	GAME_ENTRY("coyote1", "coyote.exe", "a524cbb1c51589903c4043b98917f1d9", 33124533),
	GAME_ENTRY("crackwell1", "Crackwell.exe", "06a03fe35791b0578068ab1873455463", 2990976),
	GAME_ENTRY("crackwell2", "Crackwell2.exe", "06a03fe35791b0578068ab1873455463", 7979141),
	GAME_ENTRY("craftofevil", "craft of evil.exe", "4c1d9a74c4acf6771aab4be704bf0797", 22409329),
	GAME_ENTRY("crankosaurus", "Crankosaur.exe", "00ca3a1eb345f1c3b0a88657b4087aa6", 37732797),
	GAME_ENTRY("crankosaurusff", "Crankosaur.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 60705925),
	GAME_ENTRY("crashcourse", "Crash course.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 3354483),
	GAME_ENTRY("crashevadedestroy", "ced.exe", "06a03fe35791b0578068ab1873455463", 1938399),
	GAME_ENTRY("crave", "crave.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 59222727),
	GAME_ENTRY("crepefields", "Crepe Fields.exe", "0e4ce1f719c288c65227f6073186bed7", 5928778),  // Windows
	GAME_ENTRY("crepefields", "Crepe Fields.ags", "c59c4cf5d4bb0ba6a6c5fe63b740c577", 3430714),  // Linux
	GAME_ENTRY("crimezone", "LD48.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 3786245),
	GAME_ENTRY("criminalist", "Onromm.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1388001),
	GAME_ENTRY("crossstitch", "Cross Stitch Casper.exe", "d44551532361c1eeec9b167de35515d1", 123801381),
	GAME_ENTRY("crowandfoxy", "LeCorbeauetlaRenarde.exe", "615e73fc1874e92d60a1996c2330ea36", 15444218),
	GAME_ENTRY("cryo", "cryo.exe", "615e73fc1874e92d60a1996c2330ea36", 27992619),
	GAME_ENTRY("crypt", "crypt.exe", "0500aacb6c176d47ac0f8158f055db83", 2089059),
	GAME_ENTRY("cryptic", "cryptic.exe", "d9143b143b011d7bd8726c1bb5dabc59", 6027654),
	GAME_ENTRY("crystalquest", "MarchMAGS.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2284362),
	GAME_ENTRY("csihunt1", "csi hunt 1.exe", "06a03fe35791b0578068ab1873455463", 2190662),
	GAME_ENTRY("cspb", "cspb.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 77296215),
	GAME_ENTRY("cyberjack", "brewton24.exe", "e3962995a70923a8d5a8f1cf8f932eee", 3439339),
	GAME_ENTRY("daceyinthedark", "Darkness.exe", "27343924ddad3be0b97bdcaa71858b1b", 6353848),
	GAME_ENTRY("dada", "Dada.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 3992871),
	GAME_ENTRY("dadaxmas", "DadaXmas.exe", "2986195aec1d206f8e9c080b3232b25e", 13170134),
	GAME_ENTRY("daggerhell", "DaggerHell.exe", "7971a7c02d414dc8cb33b6ec36080b91", 3614181),
	GAME_ENTRY("daggerhell", "DaggerHell.ags", "5c833e0d8c484c904732ee1d14ebcafb", 1117141),
	GAME_ENTRY("dakota", "Dakota.exe", "615e73fc1874e92d60a1996c2330ea36", 12745994),
	GAME_ENTRY("daleks", "Daleks.exe", "0241777c2537fc5d077c05cde10bfa9f", 2409634),
	GAME_ENTRY("dalesfilmquest", "dale.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 2557975),
	GAME_ENTRY("damsel", "Damsel.exe", "809418706c429cee5d88e8d483c906cc", 77101995),
	GAME_ENTRY("dancetilyoudrop", "DanceTilYouDrop.exe", "0710e2ec71042617f565c01824f0cf3c", 4682843),
	GAME_ENTRY_PLATFORM("dancetilyoudrop", "DanceTilYouDrop.exe", "0710e2ec71042617f565c01824f0cf3c", 4822399, "EX"),
	GAME_ENTRY("danewguys", "DaNewGuys.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 12115013),
	GAME_ENTRY("danewguys", "DaNewGuys.exe", "97020973a2a635fe28eb0ba4bdfaa70b", 11998791),
	GAME_ENTRY("dangerousderek", "DangerousDerek.exe", "f6a5f0a2f617b84174b5ab48147ae9f7", 7416843),
	GAME_ENTRY("dangerouslandsrt2", "dlrt2.exe", "0710e2ec71042617f565c01824f0cf3c", 21636362),
	GAME_ENTRY("dannydreadisoncall", "On Call.exe", "ef480ccb0831e452e55456e0ca24c761", 8787649),
	GAME_ENTRY("dannydreadisoncall", "On Call.exe", "ef480ccb0831e452e55456e0ca24c761", 8791050),
	GAME_ENTRY("dantesday", "Dante's Day.exe", "0500aacb6c176d47ac0f8158f055db83", 7504000),
	GAME_ENTRY("darkblack", "DarkBlack.exe", "e80586fdc2db32f65658b235d8cbc159", 8714374),
	GAME_ENTRY("darkcave", "DarkCave.exe", "0d48d8b170624e8f33bd7cd7f3ad2052", 5293954),
	GAME_ENTRY("darkforce", "DarkForce.exe", "338fa79960d40689063af31c671b8729", 276608794),
	GAME_ENTRY("darkofnight", "D_o_N.exe", "3f7bb944e107f883d183f047d9d7f698", 10261961),
	GAME_ENTRY("darktimesmerrychristmas", "Dark Times (Merry Christmas).exe", "1b9f13d430bb15bf30d0fd044358db68", 49043355),
	GAME_ENTRY("darum", "afterlife.exe", "0241777c2537fc5d077c05cde10bfa9f", 4082712),
	GAME_ENTRY("darum", "Darum.exe", "0241777c2537fc5d077c05cde10bfa9f", 4082708),
	GAME_ENTRY("davegeneric", "generic.exe", "a524cbb1c51589903c4043b98917f1d9", 2449830),
	GAME_ENTRY("davidletterman", "letterman.exe", "615e806856b7730afadf1fea9a756b70", 17019706),
	GAME_ENTRY("davyjonesspellbook", "dj_sbook.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 1095440),
	GAME_ENTRY("dayofthefish", "Rivet.exe", "06a03fe35791b0578068ab1873455463", 2265379),
	GAME_ENTRY("ddddd", "DDDDD.exe", "f3f788c1e3a7b0b40e24e453fa1b9440", 21718220),
	GAME_ENTRY("ddr", "OSD Revolution.ags", "4b5143c2e43527c7228e0596f67b2064", 2796626),
	GAME_ENTRY_LANG("deaddimension", "Dead Dimension.exe", "a62c0cd6a3d7547e04c856b25bf74f60", 425596857, Common::ES_ESP),
	GAME_ENTRY("deadgods", "DEAD GODS.exe", "82da2565c456dcfb265ded6fe3189c0b", 11562861),
	GAME_ENTRY("deadhand", "Dead Hand.exe", "87ddba03ee2498d0df16f3e6fa1c630a", 31344599),
	GAME_ENTRY("deadinspace", "DIP.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 19166495),
	GAME_ENTRY("deadlyconsequences", "Deadly Consequences.exe", "173f00e582eebd082d66f1291702b373", 173003853),
	GAME_ENTRY("deadmanpoliticalparty", "DMP~1.P.exe", "c87aa6377abc18c1a1b2968ae6db08eb", 6032550),
	GAME_ENTRY("deadofwinter", "DoW.exe", "615e806856b7730afadf1fea9a756b70", 7055437),
	GAME_ENTRY("deadpixels", "Dead Pixels.exe", "06a03fe35791b0578068ab1873455463", 4018372),
	GAME_ENTRY("deadroom", "Dead room.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 871409),
	GAME_ENTRY("deadsilence", "Game.exe", "5c5d4680def6954c0cd22e82dc07d4d4", 3370359),
	GAME_ENTRY("deadstar", "DeadStar.exe", "0500aacb6c176d47ac0f8158f055db83", 1974362),
	GAME_ENTRY("deathandtransfiguration", "death.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 11103314),
	GAME_ENTRY("deathasitis", "death.exe", "a524cbb1c51589903c4043b98917f1d9", 4001615),
	GAME_ENTRY("deathep1", "Death.exe", "4ffc2285a82023294aee3d41181e7177", 120667199),
	GAME_ENTRY("deathofanangel", "Angel.exe", "f120690b506dd63cd7d1112ea6af2f77", 3906130),
	GAME_ENTRY("deathofdavyjonesscenario", "yadodjs.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1229074),
	GAME_ENTRY("deathonstage", "DeathOnStage.exe", "a524cbb1c51589903c4043b98917f1d9", 3131683),
	GAME_ENTRY("deathsdoor", "Death's Door.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 31447213),
	GAME_ENTRY("deathsquest", "HEHU!.exe", "949f7440e3692b7366c2029979dee9a0", 991809),
	GAME_ENTRY("deathworeendlessfeathersdisk1", "Cyberpunk.exe", "2aaa2609117a34adf666ea546e6dc000", 12620944),
	GAME_ENTRY("deephope", "DeepHope.exe", "615e73fc1874e92d60a1996c2330ea36", 5039793),
	GAME_ENTRY("deepspacemission", "DSM.exe", "173f00e582eebd082d66f1291702b373", 340115162),
	GAME_ENTRY("dehaunt", "dehaunt.exe", "06a03fe35791b0578068ab1873455463", 3166435),
	GAME_ENTRY("deity", "Deity.exe", "371425d66b0d5dceedf1039fbde2656a", 3799508),
	GAME_ENTRY("delerium", "DLM.exe", "8c515b7c2355248233f7f8f802239cd7", 28448274),
	GAME_ENTRY("demogame", "Demo Game.exe", "f120690b506dd63cd7d1112ea6af2f77", 3296215),
	GAME_ENTRY("demonday", "Testgame.exe", "0b7529a76f38283d6e850b8d56526fc1", 6749329),
	GAME_ENTRY("demonslayer5", "Dem5.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 2346338),
	GAME_ENTRY("derrekquest", "dq1.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 9664668),
	GAME_ENTRY_LANG("derverschwundenehusky", "Husky.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 51932091, Common::DE_DEU),
	GAME_ENTRY("desmond", "Desmond.exe", "c1feaa2d7845fbe03d9791e4cae121b3", 9021681),  // Windows
	GAME_ENTRY("desmond", "Desmond.ags", "7284c404d82513e2981db5134899f154", 5990621),  // Linux
	GAME_ENTRY("desolate", "Desolate.exe", "5e6155cb09d4d4d59c6998fdafa0e17d", 39349967),  // Windows
	GAME_ENTRY("desolate", "Desolate.ags", "ff0cfe9bf8322574250d1241e94b1bc9", 36237499),  // Linux
	GAME_ENTRY("detectivebhmini", "Detective Boiled-Hard Mini Case.exe", "7971a7c02d414dc8cb33b6ec36080b91", 23715735),
	GAME_ENTRY("detectiveobriced", "OBriced.exe", "3ab9922a2ab7c5875af4c9794b33e012", 92518862),
	GAME_ENTRY("detention", "little.exe", "c16204dc8aa338e3199b2c62da0b33f4", 2362176),
	GAME_ENTRY("devochkaquest", "DevochkaQuest.exe", "84faea68bf7277610c2229be7b3e74af", 32769660),
	GAME_ENTRY("dexter", "DexterIntro.exe", "2ca80bd50763378b72cd1e1cf25afac3", 4630186),
	GAME_ENTRY_LANG("dgsearchbatteries", "dgsfb.exe", "88cf59aad15ca331ab0f854e16c84df3", 1664209, Common::EN_ANY),  // English  
	GAME_ENTRY_LANG("dgsearchbatteries", "dgf.exe", "88cf59aad15ca331ab0f854e16c84df3", 1619269, Common::FR_FRA),  //French
	GAME_ENTRY("dicklarenzo", "LaRenzo.exe", "0500aacb6c176d47ac0f8158f055db83", 36844867),
	GAME_ENTRY("diemaskennyarlathoteps", "ags_masken.exe", "74dc062c5f68f3d70da911f2db5737b6", 129219473),
	GAME_ENTRY("dimetrodon", "Day of the Dimetrodon.exe", "9632da1faae3ef66d7ea9dd60cc19440", 28727620),
	GAME_ENTRY("dimetrodon", "Day of the Dimetrodon.ags", "758c54f5431641ba68ecab7ae54b0480", 25685296),
	GAME_ENTRY("dinnerforpigeons", "DinnerForPigeons.exe", "0de24019f4bf96e6a7add17110514609", 27207204),
	GAME_ENTRY("dirandiouskroken", "Dirandious Kroken.exe", "9f8a9d74c09f188af9af3e263f8b59bc", 12227072),  // Windows
	GAME_ENTRY("dirandiouskroken", "Dirandious Kroken.ags", "53f94c587c9728e342a0f23b1f025907", 9190892),  // Linux
	GAME_ENTRY("disappearancetime", "007.exe", "35452a12003d51118f7c2ccc45ff52ca", 2838918),  // v1
	GAME_ENTRY("disappearancetime", "007.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2879333),  // v2
	GAME_ENTRY_PLATFORM("disappearancetime", "007Plus.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 3847344, "2009 Release"),  // v3
	GAME_ENTRY("disgust", "Disgust.exe", "495d45fb8adfd49690ae3b97921feec6", 8780836),  // Windows
	GAME_ENTRY("disgust", "Disgust.ags", "05346dafd4ff4893660447cf75b6f542", 6300180),  // Linux
	GAME_ENTRY("dislocation", "dislocation.exe", "aecd482222ff54206e43a029b5f0b170", 168869859),
	GAME_ENTRY("disquiet", "Disquiet.exe", "f90f5f612ed5879addfdd8634d093333", 9624101),
	GAME_ENTRY("distancenoobject", "Distance no object.exe", "5cca0f8af961d2bc1c6e475437d3b23b", 98011325),  // Windows
	GAME_ENTRY("distancenoobject", "Distance no object.ags", "60b1978b591c4ffcb63e81e69d425343", 94977705),  // Linux
	GAME_ENTRY("doctormaze", "Maze.exe", "825ccacaabe2a3b0cd48d6f8deb42d72", 43934617),
	GAME_ENTRY("doctormuttonchop", "muttonchop.exe", "57e261dd3bb45761af4a002775e45710", 5781714),
	GAME_ENTRY("doctormuttonchop", "muttonchop.exe", "57e261dd3bb45761af4a002775e45710", 5847364),
	GAME_ENTRY_PLATFORM("dogescape", "dog.exe", "0710e2ec71042617f565c01824f0cf3c", 1508802, "unfinished"),
	GAME_ENTRY("dollshouse", "DOLLS house.exe", "0241777c2537fc5d077c05cde10bfa9f", 37582183),
	GAME_ENTRY("dollshouseinsanity", "dollshouse insanity.exe", "0241777c2537fc5d077c05cde10bfa9f", 52632190),
	GAME_ENTRY_LANG("donalddowell", "Donald Dowell.exe", "74dc062c5f68f3d70da911f2db5737b6", 647518160, Common::EN_ANY),  // English
	GAME_ENTRY_LANG("donalddowell", "Donald Dowell.exe", "74dc062c5f68f3d70da911f2db5737b6", 596996103, Common::IT_ITA),  //Italian
	GAME_ENTRY("donkeybas", "DonkeyBas.exe", "06a03fe35791b0578068ab1873455463", 1944795),
	GAME_ENTRY("donnaavengerofblood", "DONNA.exe", "74aad8dfd71ed2ae9574a60be7610c43", 275096403),
	GAME_ENTRY("donniedarko", "Darko.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 1820048),
	GAME_ENTRY("donspillacyconspiracyquest", "DSAQ.exe", "f120690b506dd63cd7d1112ea6af2f77", 2066918),
	GAME_ENTRY("dontdrinkthepink", "pink.exe", "82da2565c456dcfb265ded6fe3189c0b", 5447689),
	GAME_ENTRY("donthedweebdancedilemma", "Don the Dweeb.exe", "f120690b506dd63cd7d1112ea6af2f77", 2278453),
	GAME_ENTRY("dontlook", "Don't Look.exe", "25976a689b0f4d73eac69b1728377ecb", 4623669),
	GAME_ENTRY("dontpush", "DontPush.exe", "897e7a83055ef58603d39b1412d40f3b", 3119863),
	GAME_ENTRY("dontworrybaby", "baby.exe", "a524cbb1c51589903c4043b98917f1d9", 12498411),
	GAME_ENTRY("dontworryillbringthebeer", "Don't Worry, I'll Bring The Beer.exe", "495d45fb8adfd49690ae3b97921feec6", 4446095),
	GAME_ENTRY("doomgraphicadventure", "DoomGraphic.exe", "0500aacb6c176d47ac0f8158f055db83", 2236047),
	GAME_ENTRY("doors", "Doors.exe", "3277e3b4ec9c224fb338460be298b77c", 95135227),
	GAME_ENTRY("dovadulasburn", "FILES.exe", "9cb3c8dc7a8ab9c44815955696be2677", 26489645),
	GAME_ENTRY("dovadulasburn", "DoVaDuLa'S BuRn.exe", "06a03fe35791b0578068ab1873455463", 27108565),
	GAME_ENTRY("draconis", "Draconis.exe", "7a026b53d6c066a785670b958827d310", 2861993),  // OROW
	GAME_ENTRY("draconis", "Draconis.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 2921005),  // MAGS
	GAME_ENTRY("draculator2", "Draculator II.exe", "519c0d37ab893d95f5add495355e460c", 17244503),
	GAME_ENTRY("dragonorb", "DragonOrb.exe", "2bc8f994a7d1e05ed45f35abf2128231", 269836732),
	GAME_ENTRY("dragonscale", "DS.exe", "64fcaf7da0b257ea831f89c54be0ad72", 1366698),
	GAME_ENTRY("dragontales", "dragont.exe", "465f972675db2da6040518221af5b0ba", 9240132),
	GAME_ENTRY("drchuckles", "Dr Chuckles.exe", "07b30f9606f5dfde84cb66e926f7cc74", 615657195),
	GAME_ENTRY("dreadmacfarlane", "Dread.exe", "615e806856b7730afadf1fea9a756b70", 11157310),  // Eng/Fra
	GAME_ENTRY_LANG("dreadmacfarlane", "Dread.exe", "615e806856b7730afadf1fea9a756b70", 11158073, Common::FR_FRA),
	GAME_ENTRY_PLATFORM("dreadmacfarlane2", "Dread2.exe", "fb787304e66798ba9d0172665a34f4cf", 5332574, "unfinished"),
	GAME_ENTRY("dreamychristmas", "Your dreamy Christmas.exe", "a4e6ec808b347f4456eae7c808e90727", 84727913),  // Windows
	GAME_ENTRY("dreamychristmas", "Your dreamy Christmas.ags", "f61d34a8a5c9501962c7161fe127aba2", 81696341),  // Linux
	GAME_ENTRY("dreamagine", "Game.exe", "256752c9a97b4780fc5e6f3239c8cdf1", 11122818),
	GAME_ENTRY("dreamer", "LittleDreamer.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 62151801),
	GAME_ENTRY("dreamsequence", "dreamseq.ags", "97d700529f5cc826f230c27acf81adfd", 4724470),
	GAME_ENTRY("dreamsofwintermass", "Dreams of Winter Mass.exe", "1608e6ba3e7965580fe36e547635c0ac", 3305143),
	GAME_ENTRY("dressedforafight", "ladyfighterv2.exe", "7cebde856d22620450989e3b1d7896b1", 580950783),
	GAME_ENTRY("drillkiller", "LD22_Entry.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 4121415),
	GAME_ENTRY("drlutztimetravelmachine", "Dr.Lutz Machine.exe", "2bc8f994a7d1e05ed45f35abf2128231", 12602529),
	GAME_ENTRY("drugsandalians", "Drugs and alians.exe", "82da2565c456dcfb265ded6fe3189c0b", 158823644),
	GAME_ENTRY("dungeonhands", "DungeonHands.exe", "0a6704159f6f716ac80da91c430430ce", 16276450),
	GAME_ENTRY("dungeonhands", "DungeonHands.exe", "f80ff6c2348f2bb90d3813719f54c870", 13751518),
	GAME_ENTRY("duskhunters", "DuskHunters.exe", "3128b9f90e2f954ba704414ae854d10b", 3029482),
	GAME_ENTRY("dutyandbeyond", "Deliver.exe", "0710e2ec71042617f565c01824f0cf3c", 28873258),
	GAME_ENTRY("dutyfirst", "duty_first.exe", "4e0d0aca04563b21a47e8a0cc56605fc", 10333200),
	GAME_ENTRY("duzzquest", "DuzzQuest.exe", "3128b9f90e2f954ba704414ae854d10b", 13125200),
	GAME_ENTRY("duzzquest2", "DuzzQuest2.exe", "8911d942c1a71458370d37ca3e5bfdda", 59088366),
	GAME_ENTRY("earlbobby1", "Bobby's Shoes.exe", "bb59de174d70797d774dec76a171352d", 12735626),
	GAME_ENTRY("earlbobby2", "Bobby's Balls.exe", "bb59de174d70797d774dec76a171352d", 4006605),
	GAME_ENTRY("earlbobby3", "Earl Bobby 3.exe", "804add6fbbb791b7be195dc0097434a1", 4379857),
	GAME_ENTRY("earlmansinthebreakout", "Earl Mansin.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 108987401),
	GAME_ENTRY("earthlingpriorities", "Earthling Priorities.exe", "9b54ea3557373188d8388ec4d1ae5eed", 21490281),
	GAME_ENTRY("earthstory", "EarthStory.exe", "82da2565c456dcfb265ded6fe3189c0b", 23042784),
	GAME_ENTRY("easterencounter", "Easter Encounter.exe", "779421cd8ad5268e2efdb26e04608db7", 30257364),
	GAME_ENTRY("easterinron", "puzzles.exe", "02094e217c23e1d40a84891ee95010cb", 3239060),
	GAME_ENTRY("easterislanddefender", "Moia 'n Seek.exe", "804add6fbbb791b7be195dc0097434a1", 6359079),
	GAME_ENTRY("echidna", "Echidna Chwest.exe", "dbe281d93c914899886e77c09c3c65ec", 8769591),
	GAME_ENTRY("echoesofterra", "echoes.exe", "a524cbb1c51589903c4043b98917f1d9", 42866707),
	GAME_ENTRY("echoesofthepast", "Echoes of the Past.exe", "111542004299dae82a02e750fdb97e59", 612857584),
	GAME_ENTRY("edmund", "Edmundand the potato.exe", "615e73fc1874e92d60a1996c2330ea36", 4533124),
	GAME_ENTRY("educatingadventuresofgirlandrabbit", "Game.exe", "82da2565c456dcfb265ded6fe3189c0b", 2877964),
	GAME_ENTRY("egoplanetapes", "EgoInPlanetOfTheApes.exe", "7ddb9e776648faed5a51170d087074e9", 38605725),
	GAME_ENTRY("egoplanetapes", "EgoInPlanetOfTheApes.ags", "cfc308c9dcbd329a0c5bf1283e731c92", 19452067),
	GAME_ENTRY("egoplanetapes", "Crossover.ags", "86a0b6f733707544035d7e823584ed4d", 16666330),
	GAME_ENTRY("egress", "Egress.exe", "615e73fc1874e92d60a1996c2330ea36", 439827181),
	GAME_ENTRY("eight", "8.exe", "c7835774540a2e7d9d89a2df66fbcec4", 2412166),
	GAME_ENTRY("electrctgui", "electrctGUI.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 8941606),
	GAME_ENTRY("elevator", "Elevator.exe", "f10516e88ec858700804ee69d041aead", 29506915),
	GAME_ENTRY("elevatorriseabyss", "T_E_R.exe", "f120690b506dd63cd7d1112ea6af2f77", 13366126),
	GAME_ENTRY_LANG("elfer", "socer.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 1911767, Common::DE_DEU),
	GAME_ENTRY("elfmotorsinc", "ElfMtrs.exe", "3421b46ff95c5885603086c39a038a20", 8036769),
	GAME_ENTRY("elforescuecraby", "elfo.exe", "31457af75a89b6141c31e8ed33a57e25", 10641021),
	GAME_ENTRY("elfthe4elements", "ELF2.exe", "247bd23f71d7c785a7c9aa8b06077ec0", 207254832),
	GAME_ENTRY("elfthedarkness", "ELF.exe", "247bd23f71d7c785a7c9aa8b06077ec0", 128596356),
	GAME_ENTRY("eliminationbyimprovisation", "Stu2.exe", "9cf51833e787cc919837d9a8bd8fc14c", 971446),
	GAME_ENTRY("elmowagon", "Elmo's Wagon Conflict.exe", "615e73fc1874e92d60a1996c2330ea36", 3051412),
	GAME_ENTRY("emeraldeyes", "Emerald.exe", "f120690b506dd63cd7d1112ea6af2f77", 2849945),
	GAME_ENTRY("emilyenough", "EE.exe", "97020973a2a635fe28eb0ba4bdfaa70b", 3141963),
	GAME_ENTRY("emptymindblankfate", "EMBF.exe", "18b284c22010850f79bc5c20054a70c4", 75732051),
	GAME_ENTRY("encounters", "Encounters of the Closest Kind.exe", "06a03fe35791b0578068ab1873455463", 4393673),
	GAME_ENTRY("endlessloop", "Endless Loop.exe", "615e73fc1874e92d60a1996c2330ea36", 1920165),
	GAME_ENTRY("enoworld", "Enoworld.exe", "465f972675db2da6040518221af5b0ba", 16151170),
	GAME_ENTRY("entrapment", "Entrapment.exe", "fa876182475fd84bc104e3458b7ba362", 24899784),  
	GAME_ENTRY("entrapped", "Cellar.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 4644055),  
	GAME_ENTRY("equilibrium", "EQ.exe", "0500aacb6c176d47ac0f8158f055db83", 8398394),
	GAME_ENTRY("erictheanteater", "eric.exe", "e750ecac380dca709028fc0744b9f7f6", 3865602),
	GAME_ENTRY("erkrealestate", "AISRE.exe", "41e8fa920589300ed8b4aec09a658c90", 5958575),
	GAME_ENTRY("errand", "errand.exe", "2e6b104176f310e7fb507183c443edfe", 4404813), // v1.2
	GAME_ENTRY("errand", "Errand.exe", "8212e96af620f6e02a37fdf583f79751", 4425035),  // v1.3  Windows
	GAME_ENTRY("errand", "Errand.exe", "8212e96af620f6e02a37fdf583f79751", 4421187),  // v1.3  Alt/Linux
	GAME_ENTRY("escape", "Escape.exe", "9cf51833e787cc919837d9a8bd8fc14c", 2182153),
	GAME_ENTRY("escapefromasmallroom", "game1.exe", "0b7529a76f38283d6e850b8d56526fc1", 803029),
	GAME_ENTRY("escapefromevergreenforest", "EFEF.exe", "2e58934bbe98335f33c20a23a6c6135a", 23855632),
	GAME_ENTRY("escapefromlurrilous", "EFL.exe", "4bcbc24015114752b3c7971128704689", 2756979),
	GAME_ENTRY("escapefromterrorbay", "eftb.exe", "665fe5817e020e6a81849429e93662e4", 4917879),
	GAME_ENTRY("escapefromthechaoticcity", "ChaoticCity.exe", "ff3358d8f2726d544aadfde4f1ec8407", 93118664),
	GAME_ENTRY("escapefromthegarage", "Escape.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 962798),
	GAME_ENTRY("escapefromthesalemmoons", "Salem.exe", "9cf51833e787cc919837d9a8bd8fc14c", 1394026),
	GAME_ENTRY("escapefromthezombiecity", "zombie.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 3216299),
	GAME_ENTRY("escapethebarn", "EscapeTheBarn.exe", "82da2565c456dcfb265ded6fe3189c0b", 11451800),
	GAME_ENTRY("escapetheship", "Escape.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1063503),
	GAME_ENTRY("escapetocivilization", "Saanb.exe", "0b7529a76f38283d6e850b8d56526fc1", 1209470),
	GAME_ENTRY("esper", "esper.exe", "0710e2ec71042617f565c01824f0cf3c", 17409715),
	GAME_ENTRY("essenceofimagination", "Essence of Imagination.exe", "0fe1d93da69963d5eef55ce2619c94be", 32847280),
	GAME_ENTRY("essia", "Mnemo.exe", "615e73fc1874e92d60a1996c2330ea36", 2691247),
	GAME_ENTRY("etaac", "TaxOROW.exe", "a524cbb1c51589903c4043b98917f1d9", 4474174),
	GAME_ENTRY("eternalchrysalis", "Eternal_Chrysalis.exe", "2b4b47cd54497526c7606878a4624f58", 39916658),
	GAME_ENTRY("eternallyus", "Eternally Us.exe", "3faa59edd92158ff2cbd4b9db54acf61", 43467084),
	GAME_ENTRY("eternallyus", "Eternally Us.exe", "3faa59edd92158ff2cbd4b9db54acf61", 43468014),
	GAME_ENTRY("eventtimer", "Timer.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 3000682),
	GAME_ENTRY("evil", "Evil.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 2459231),
	GAME_ENTRY("evilenterprises", "EvilE.exe", "3128b9f90e2f954ba704414ae854d10b", 6502022),
	GAME_ENTRY("evillodge", "Evillodge.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 982457),
	GAME_ENTRY("exclamation", "!.exe", "0514661a4ba6772cf0db0cf839fc7003", 2785515),
	GAME_ENTRY("exit", "EXIT.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 54723513),
	GAME_ENTRY("exmachina", "machina.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 5545266),  //v1.2
	GAME_ENTRY("explorationa", "ExplorationA.exe", "615e73fc1874e92d60a1996c2330ea36", 8536746),
	GAME_ENTRY("exposedreality", "HORON.exe", "bb59de174d70797d774dec76a171352d", 4847902),
	GAME_ENTRY("fadingshades", "FadingShades.exe", "f120690b506dd63cd7d1112ea6af2f77", 20166198),
	GAME_ENTRY("fakethemoonlanding", "OperationStarman.exe", "495d45fb8adfd49690ae3b97921feec6", 56805472),
	GAME_ENTRY("fall", "FALL.exe", "387ff720e746ae46e93f463fd58d77a4", 34152794),
	GAME_ENTRY("fallenangel", "Fallen Angel.exe", "f120690b506dd63cd7d1112ea6af2f77", 3988730),
	GAME_ENTRY("fallenangel", "Fallen Angel.exe", "f120690b506dd63cd7d1112ea6af2f77", 3993369),
	GAME_ENTRY("fallenhero", "Fallen Hero.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 99865610),
	GAME_ENTRY("fallensoldier", "fallen soldier.exe", "7a3096ac0237cb6aa8e1718e28caf039", 81522018),
	GAME_ENTRY("fallingdark", "Falling Dark.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 451738395),  //v1.4
	GAME_ENTRY("fallingdark2", "Falling Dark 2.exe", "0564de07d3fd5c16e6947a647061913c", 205636847),  //v1.06
	GAME_ENTRY_LANG("familieherfurth", "Familie Herfurth.exe", "cefb80c104ab2a8bd1713d13d7c74d07", 5457327, Common::DE_DEU),  //v2.0
	GAME_ENTRY("fanbots", "Game.exe", "aecd482222ff54206e43a029b5f0b170", 8665702),  //MAGS
	GAME_ENTRY("fanbots", "Game.exe", "c58d7c2d20e502e72a504f3f23a1d6da", 12986310),  // 2.0.1
	GAME_ENTRY("fanbots", "Game.exe", "4b18403fd1d150321f50cff9232d7b28", 13725413),  // 2.0.2
	GAME_ENTRY("farcorners", "FCotW1.exe", "98df40b0885b4e5f90f1093987f1f56c", 27336337),
	GAME_ENTRY("farnowhere", "FAR NOWHERE.exe", "06a03fe35791b0578068ab1873455463", 77186777),
	GAME_ENTRY("fashiongirl", "Fashion Girl.exe", "a4e6ec808b347f4456eae7c808e90727", 109319608),  // Windows
	GAME_ENTRY("fashiongirl", "Fashion Girl.ags", "08bb57ffbec899a4bd01a65253d67a6b", 106288036),  // Linux
	GAME_ENTRY("fasmo", "fasmo.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 16778433),
	GAME_ENTRY("fasmogoeswest", "FasmoGoesWest.exe", "f120690b506dd63cd7d1112ea6af2f77", 15348030),
	GAME_ENTRY("fayeking", "FKJJ.exe", "7ce746c19cf3080a9fac568979b2bf9b", 10664729),
	GAME_ENTRY("fbiquest", "FQ.exe", "465f972675db2da6040518221af5b0ba", 3838610),
	GAME_ENTRY("fearaphobia", "Fearaphobia.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 9646228),
	GAME_ENTRY("featherweight", "Featherweight.exe", "e8b2a430042709f07183c2c249e0e0d9", 6399452),
	GAME_ENTRY("femspray", "Fem.exe", "01d0e6bd812abaa307bcb10fc2193416", 49176669),
	GAME_ENTRY("fengshuiandtheartoftvreception", "Feng Shui And The Art Of TV Reception.exe", "c1b88c284a3d821f93d78a2e88487932", 22687931),
	GAME_ENTRY("ferragosto", "Ferragosto.exe", "f604f7f3a12da5d3bcf7a7814a14e43b", 61875571),
	GAME_ENTRY_LANG("feuersturm1", "Feuersturm.exe", "06a03fe35791b0578068ab1873455463", 5682579, Common::DE_DEU),
	GAME_ENTRY_LANG("feuersturm2", "fs2.exe", "06a03fe35791b0578068ab1873455463", 7043558, Common::DE_DEU),
	GAME_ENTRY_LANG("feuersturm3", "feuersturm3.exe", "206478d4d39e16571682b2cddf01a78f", 7826524, Common::DE_DEU),
	GAME_ENTRY("fhaloness", "Fhaloness.exe", "b908419fbf01d288e9eca05eea7c8ed4", 7278107),
	GAME_ENTRY("fhaloness", "Fhaloness.exe", "b908419fbf01d288e9eca05eea7c8ed4", 7277962),
	GAME_ENTRY("fifa2004", "Soccer.exe", "475da5decb9ad2a11e64e2e2e891d8e0", 2524958),
	GAME_ENTRY("fightforlife", "FFL.exe", "452e0b23ec8bac95c3e86732d19879a1", 178832193),
	GAME_ENTRY("fightgame", "Fight Game.exe", "463f79e5db4013d1b3be647edd7e338d", 1871790),
	GAME_ENTRY("fightgame", "Fight Game.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 3551992),
	GAME_ENTRY("finger", "Finger of suspicion.exe", "9ba6f64cc122117779e5528e94f9b8d1", 189584333),
	GAME_ENTRY("fireflystory3d", "FFS 3D.exe", "27343924ddad3be0b97bdcaa71858b1b", 2254453),
	GAME_ENTRY("firstdrop", "Landinge.exe", "3e89794213fbd91efab223754f82cfdd", 11410897),
	GAME_ENTRY("firststitch", "t1stitch.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 2622753),  // v2
	GAME_ENTRY("firststitch", "t1stitch.exe", "06a03fe35791b0578068ab1873455463", 3404581),  // v3
	GAME_ENTRY("fistsofmurder", "mags1808.exe", "9cd9563150a69bc1d4eacda0ff3557f8", 55441407),  // Windows
	GAME_ENTRY("fistsofmurder", "mags1808.ags", "060b511dd9f501bae44d2cc37a18a05e", 52994031),  // Linux
	GAME_ENTRY("fixumdude", "fixumdude3dpa.exe", "3c886d441e027ff61bf641f4ed544a0e", 155902768),
	GAME_ENTRY("flamebarrel", "Flame barrel.exe", "06a03fe35791b0578068ab1873455463", 2298745),
	GAME_ENTRY("flightrobots", "FlightFromTheRobots.exe", "3ab9922a2ab7c5875af4c9794b33e012", 4517631),
	GAME_ENTRY("floatyrog", "FloatyRog.exe", "6e6f33162242d74dd1fa042429f16562", 2592017),
	GAME_ENTRY("flophouse", "FlopHigh.exe", "0241777c2537fc5d077c05cde10bfa9f", 5807004),
	GAME_ENTRY_PLATFORM("flophouse", "FlopHigh.exe", "0241777c2537fc5d077c05cde10bfa9f", 9159785, "Deluxe"),
	GAME_ENTRY("flowergirl", "flowergirl.exe", "9cb3c8dc7a8ab9c44815955696be2677", 62544543),
	GAME_ENTRY("fluxworld", "FluxWorld.exe", "06a03fe35791b0578068ab1873455463", 5614789),
	GAME_ENTRY("flyingthinker", "Flying Thinker (eng).exe", "615e73fc1874e92d60a1996c2330ea36", 712414432),
	GAME_ENTRY("flypaper", "OROW.exe", "06a03fe35791b0578068ab1873455463", 15723518),
	GAME_ENTRY("focality", "Focality.exe", "6465bcd8a1ec4ee001ba2f2029a4ee02", 10679646),
	GAME_ENTRY("foggydawn", "Fog3.2.exe", "615e73fc1874e92d60a1996c2330ea36", 8336612),  //v1.1
	GAME_ENTRY_PLATFORM("foggynotions", "Foggy.exe", "615e73fc1874e92d60a1996c2330ea36", 8417964, "Alpha"),
	GAME_ENTRY_PLATFORM("foggynotions", "Foggy.exe", "2ca80bd50763378b72cd1e1cf25afac3", 11872355, "Beta"),
	GAME_ENTRY("foodwars", "Food Wars.exe", "9f8a9d74c09f188af9af3e263f8b59bc", 128468125),  // Windows
	GAME_ENTRY("foodwars", "Food Wars.ags", "c7e2353e800c13851105cfa28d9b3561", 125431945),  // Linux
	GAME_ENTRY("forest", "ForestOfPeople.exe", "615e73fc1874e92d60a1996c2330ea36", 18593840),
	GAME_ENTRY("forestdweller", "FD3D.exe", "e80586fdc2db32f65658b235d8cbc159", 11101168),
	GAME_ENTRY("foolaround", "FoolAround.exe", "7825fa980fcd058caadaf6d3377b1f78", 43258878),
	GAME_ENTRY("foolaround", "FoolAround.ags", "34b16504571f8fc59f3ed836d4c6fbd3", 40223210),
	GAME_ENTRY("forge", "Forge - Chapter One.exe", "1350d2520339f030c8b20283122a027f", 180565568),
	GAME_ENTRY("forms", "Forms.exe", "78f88f71bbef277d93cbe10f1d2ac404", 6738014),
	GAME_ENTRY("fortressofwonders", "Fortress.exe", "465f972675db2da6040518221af5b0ba", 4474304),
	GAME_ENTRY("foundations", "Foundations.exe", "8b4a2cb0849b02ffb981dc06b38c968e", 13779901),
	GAME_ENTRY("fountainofunicorns", "pmvi.exe", "465f972675db2da6040518221af5b0ba", 3038012),
	GAME_ENTRY("framed", "Jhum.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 4572587),
	GAME_ENTRY("frankenpooper", "frankenpooper.exe", "fb3b0f6bad923958d9d9198daea125e6", 24372899),
	GAME_ENTRY("frankfurter1", "FRANKFURTER.exe", "3367a5cfcf7b3e1948a276ac71ce1033", 9509749),
	GAME_ENTRY("frankfurter2ch1", "FRANK FURTHER.exe", "5874553fb86462672c94be2bed2a6534", 209844613),
	GAME_ENTRY("frankstallone", "Driver.exe", "7ec46f3c1c857731d6f7ff022be22c14", 20844627),
	GAME_ENTRY("frankthefarmhandpart1", "Frank.exe", "0006c0a95a5f35ca0d275adecf9dfa1d", 22602166),
	GAME_ENTRY("frankthefarmhandpart2", "Frank2.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 63832313),
	GAME_ENTRY_PLATFORM("franticfranko", "steelh1.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 118746106, "WIP2"),
	GAME_ENTRY("frasiercraneseattlerampage", "FRASIER.exe", "0241777c2537fc5d077c05cde10bfa9f", 3688664),
	GAME_ENTRY("freakchic", "FreakChic.exe", "0241777c2537fc5d077c05cde10bfa9f", 58493059),
	GAME_ENTRY("fredandbarneymeetthefuture", "Fred and Barney meet the future.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 234107316),
	GAME_ENTRY("fredandbarneymeetthefuture", "Fred and Barney meet the future.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 234107660),
	GAME_ENTRY("fredandbarneymeetthefuture", "Fred and Barney meet the future.ags", "5e9885d094c22bd18a5b4b0d5ffa81ff", 231627516),
	GAME_ENTRY("fribbeldib", "firbbeldib.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 90835696),
	GAME_ENTRY("fridgefollies", "Fridge.exe", "2ca80bd50763378b72cd1e1cf25afac3", 15002210),
	GAME_ENTRY("frightfest", "FrightFest.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 162130501),
	GAME_ENTRY("frightfest", "FrightFest.ags", "b0fbca28e8bd1e83878682b245734746", 159650357),  
	GAME_ENTRY("fritz", "Fritz.exe", "a4e6ec808b347f4456eae7c808e90727", 70554365),  // Windows
	GAME_ENTRY("fritz", "Fritz.ags", "df0330e366a4c3fd13e0e2ef491a2e3a", 67522793),  // Linux
	GAME_ENTRY("frogisland", "frog_island.exe", "465f972675db2da6040518221af5b0ba", 4355477),
	GAME_ENTRY("frozenkingdom", "Frozen Kingdom.exe", "5cca0f8af961d2bc1c6e475437d3b23b", 331574752),  // Windows
	GAME_ENTRY("frozenkingdom", "Frozen Kingdom.ags", "f6e18a377e81dd3238df54e1abf161ce", 328541132),  // Linux
	GAME_ENTRY("fsis1000000quest", "$1000000.exe", "0710e2ec71042617f565c01824f0cf3c", 833468),
	GAME_ENTRY("fsisachequest", "achequest.exe", "06a03fe35791b0578068ab1873455463", 2952369),
	GAME_ENTRY("fsisalienation", "alienation.exe", "06a03fe35791b0578068ab1873455463", 3812243),
	GAME_ENTRY("fsiscotmattcehotsvd", "valgame.exe", "06a03fe35791b0578068ab1873455463", 2199912),
	GAME_ENTRY("fsismhcfhr", "das_id.exe", "0710e2ec71042617f565c01824f0cf3c", 1852114),
	GAME_ENTRY("fsispowercowfromuranus", "PowerCowen.exe", "0710e2ec71042617f565c01824f0cf3c", 1442185),
	GAME_ENTRY("fulkramick", "DreamtHaus.exe", "06a03fe35791b0578068ab1873455463", 47212093),
	GAME_ENTRY("funsunmishaps", "Fun, Sun & Mishaps.exe", "933200c8f306eccaaa484b1575da8528", 452348894),
	GAME_ENTRY("funsunmishaps", "Fun, Sun & Mishaps.exe", "933200c8f306eccaaa484b1575da8528", 452348866),
	GAME_ENTRY("funwithnumbers", "fwn.exe", "a524cbb1c51589903c4043b98917f1d9", 18743833),
	GAME_ENTRY("furballs1", "Fur Balls 1 Evil be thy name.exe", "c876b504a1048fe06c71c9d9a0bc5817", 11417569),
	GAME_ENTRY("futuramatrivia", "FuturamaWhoSaidThat.exe", "8923670fc767b7b66ac2659556bdc3da", 125539307),  // Windows
	GAME_ENTRY("futuramatrivia", "FuturamaWhoSaidThat.ags", "a02b24866dbcc53227b96d4767fd566e", 122145751),  // Linux
	GAME_ENTRY("futurecity3000", "FutureCity3000.exe", "4d4b6d6e560cf32f440c39f8d3896da5", 41930580),
	GAME_ENTRY("gabyking", "GabyKing.exe", "1fd15cc387812c04447d89729b24b097", 2289131),
	GAME_ENTRY("gabyking", "GabyKing.exe", "1fd15cc387812c04447d89729b24b097", 2260498),
	GAME_ENTRY("galaxyquest", "My Game.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 1809822),
	GAME_ENTRY("gamequest", "Game Quest.exe", "06a03fe35791b0578068ab1873455463", 6597978),
	GAME_ENTRY("gatewayremake", "Gateway Remake.exe", "0241777c2537fc5d077c05cde10bfa9f", 210991212),
	GAME_ENTRY("gatewayremake", "Gateway Remake.exe", "0241777c2537fc5d077c05cde10bfa9f", 212491008),
	GAME_ENTRY("gaygreg", "ggig.exe", "3128b9f90e2f954ba704414ae854d10b", 3876381),
	GAME_ENTRY("gemcollector", "gemgame.exe", "789facada85e12c3ac19d5a6d4379a49", 75235335),
	GAME_ENTRY("genbu", "Genbu.exe", "64fcaf7da0b257ea831f89c54be0ad72", 1892238),
	GAME_ENTRY("geometricshapes1circleboy", "Circle1.exe", "06a03fe35791b0578068ab1873455463", 2389129),
	GAME_ENTRY("getawayfrompluto", "Get away.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 755529),
	GAME_ENTRY("getfood", "getfood.exe", "495d45fb8adfd49690ae3b97921feec6", 10600153),
	GAME_ENTRY("getsquirty", "Get Squirty.exe", "78dd4ca028ee0156b6a093d6d780aa65", 9498475),
	GAME_ENTRY("ghostcatchers", "GhostCatchers.exe", "338fa79960d40689063af31c671b8729", 230925663),
	GAME_ENTRY("ghostvoyage", "Ghost Voyage.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 7870814),
	GAME_ENTRY("gladiatorquest", "Glad.exe", "97020973a2a635fe28eb0ba4bdfaa70b", 2821000),
	GAME_ENTRY("glitchquest", "glitchquest.exe", "465f972675db2da6040518221af5b0ba", 3182715),
	GAME_ENTRY_PLATFORM("glitchquest", "GQnofun.exe", "465f972675db2da6040518221af5b0ba", 3181931, "No-Fun"),
	GAME_ENTRY("gnomeshomebrewingadventure", "gnomebrew.exe", "abb3aee32ae97a8475626cceefb0664e", 50307521),
	GAME_ENTRY_PLATFORM("gnrblex", "Gnrblex_AGS.exe", "476a1a39d43ea27577eacf907173e2c1", 85038656, "MAGS"),  // MAGS v1.0.0.1
	GAME_ENTRY_PLATFORM("gnrblex", "Gnrblex_AGS.exe", "476a1a39d43ea27577eacf907173e2c1", 85043059, "MAGS"),  // MAGS v1.0.0.5
	GAME_ENTRY_PLATFORM("gnrblex", "Gnrblex_AGS.exe", "59fe2aa2cc67589f11707ddc5a7f01cc", 115462750, "Final/Steam"),  // Final/Steam v2.0
	GAME_ENTRY("goatherd", "Goat Herd and the Gods.exe", "56ce1bc6ab10748cb4ddb91435cfa578", 91710325),
	GAME_ENTRY("goldreddragon", "Mongoose Fitch.exe", "615e73fc1874e92d60a1996c2330ea36", 4508646),
	GAME_ENTRY("goneboatfishin", "Gone Boat Fishin'.exe", "bdd1df0484e296faa348ffcb03e16273", 72936045),
	GAME_ENTRY("gonefishin", "Gone fishin'.exe", "338fa79960d40689063af31c671b8729", 76569490),
	GAME_ENTRY("gonemyangel", "GoneMyAngel.exe", "615e73fc1874e92d60a1996c2330ea36", 16422700),
	GAME_ENTRY("gonorth", "GO NORTH.exe", "f18443f98fd61d2c655e76a17f7da905", 14398652),
	GAME_ENTRY("gonorth2", "GO NORTH.exe", "618d7dce9631229b4579340b964c6810", 13294868),
	GAME_ENTRY("goodgod", "Good God!.exe", "02bd7b853a95bca41a594567c4f59fd6", 8372952),
	GAME_ENTRY("goodmorningmrgingerbread", "mister_gingerbread.exe", "b42f80733b6bd1ded5e29be2c683afa8", 7084332),
	GAME_ENTRY("goodsantabadsanta", "x-mags.exe", "71ca0d6c1c699595f28a2125948d4a84", 1966547),
	GAME_ENTRY("goontang", "GC.exe", "0710e2ec71042617f565c01824f0cf3c", 1243202),
	GAME_ENTRY("gotalight", "gotalight.exe", "daa21f03e41b5d3e7fd7558be3f8616e", 4019593),
	GAME_ENTRY("gpslostadventure", "G.P.s Lost Adventure [Wells8892].exe", "06a03fe35791b0578068ab1873455463", 4181945),
	GAME_ENTRY("gpslostadventure", "GPs_LostAdventure.exe", "06a03fe35791b0578068ab1873455463", 4181945),
	GAME_ENTRY("grandkitchenescape", "GrandKitchenEscape.exe", "310db16c989e9bbfa3973bc1bb6215f7", 28327560),  // Windows
	GAME_ENTRY("grandkitchenescape", "GrandKitchenEscape.ags", "5d2aac79e25a74a4db113c54df4a01ec", 25110132),  // Linux
	GAME_ENTRY("graveyard", "Graveyard.exe", "955b711b21d7a2df6af1bb0cccccbb08", 13699789),
	GAME_ENTRY("gravitytestgame", "TEST.exe", "97d700529f5cc826f230c27acf81adfd", 768926),
	GAME_ENTRY("gray", "Gray.exe", "b36bda97ef129952eb2d18bf5087530c", 162378773),
	GAME_ENTRY_PLATFORM("gray", "Gray.exe", "b36bda97ef129952eb2d18bf5087530c", 165386532, "Easter Egg Edition"),
	GAME_ENTRY("gremlin", "Gremlin.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 3962167),
	GAME_ENTRY("grizzlygooseofgosse", "Goose Fear.exe", "b69b5887e4a33a3b8588d52fed04b730", 32123559),
	GAME_ENTRY("groundhog", "Groundhog.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 67854225),
	GAME_ENTRY("grr", "Grr!.exe", "3128b9f90e2f954ba704414ae854d10b", 26753739),
	GAME_ENTRY("guardiansofgold", "Guardians of Gold.exe", "933200c8f306eccaaa484b1575da8528", 429166629),
	GAME_ENTRY("guardiansofgold", "Guardians of Gold.exe", "933200c8f306eccaaa484b1575da8528", 429237374),
	GAME_ENTRY("guyhookcrook", "GuyByHookOrByCrook.exe", "b0a3f015490a1c2b2d87483524f96df0", 9024485),  // Windows
	GAME_ENTRY("guyhookcrook", "GuyByHookOrByCrook.ags", "1d909d5622b79c5c86b202723d96088b", 5919185),  // Linux
	GAME_ENTRY("guyredplanet", "rocket.exe", "82da2565c456dcfb265ded6fe3189c0b", 5375785),
	GAME_ENTRY("guyslug", "GuySlug.exe", "0710e2ec71042617f565c01824f0cf3c", 1959514),
	GAME_ENTRY("guyver1d", "Guyver1D.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 2618588),
	GAME_ENTRY("guyverquest1", "Guyver Quest.exe", "465f972675db2da6040518221af5b0ba", 774591),
	GAME_ENTRY("guyverquest2", "Guyver Quest 2.exe", "465f972675db2da6040518221af5b0ba", 1138940),
	GAME_ENTRY("gville1", "GVILLE1.exe", "c1451c6631e1bf4de6d1ed3760ca1dc9", 2340624),
	GAME_ENTRY("hack", "Hack.exe", "f120690b506dd63cd7d1112ea6af2f77", 4384638),
	GAME_ENTRY("halloween", "Halloween.exe", "3128b9f90e2f954ba704414ae854d10b", 5130336),  // v2.0
	GAME_ENTRY("halloweenguest", "Halloweenguest.exe", "8f18ad4456e6dbeaf041cd91449a55ba", 17689741),  // Windows
	GAME_ENTRY("halloweenguest", "Halloweenguest.ags", "1981397bceffc777473efe379d5cec52", 14653561),  // Linux
	GAME_ENTRY("halloweenhorror", "Halloween.exe", "06a03fe35791b0578068ab1873455463", 33740975),
	GAME_ENTRY("hallwayofadventures", "Hallway.exe", "0710e2ec71042617f565c01824f0cf3c", 7085407),
	GAME_ENTRY_PLATFORM("hangon", "HangOn.exe", "6e861b1f476ff7cdf036082abb271329", 4203208, "MAGS"),  // MAGS
	GAME_ENTRY_PLATFORM("hangon", "HangOn.exe", "e09e4f152c8f4553e90885391ac72e46", 24219759, "itch.io v2.0.0"),  // 2.0
	GAME_ENTRY("happyduckieadventure", "HDA.exe", "f120690b506dd63cd7d1112ea6af2f77", 1924654),
	GAME_ENTRY("happyface", "^_^.exe", "b36bda97ef129952eb2d18bf5087530c", 4347757),
	GAME_ENTRY("hardspace", "Hard Space!.exe", "3ecd04c0e0df079ff906ec4696d5fe23", 11494382),  // Final/Deluxe
	GAME_ENTRY_PLATFORM("hardspace", "BnP.exe", "8f9c77fd2671fc7e4a91a7cf0b69a731", 8775113, "MAGS"),  // MAGS
	GAME_ENTRY("harrypotterrpg", "Harry Potter RPG.exe", "7a3096ac0237cb6aa8e1718e28caf039", 364510777),
	GAME_ENTRY("harrypotterrpg", "Harry Potter RPG.exe", "0241777c2537fc5d077c05cde10bfa9f", 364169114),
	GAME_ENTRY("harrys21stbirthday", "harold.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 3525444),
	GAME_ENTRY("harryshopshock", "Harry and the Locked Crocs Shop Shock.exe", "495d45fb8adfd49690ae3b97921feec6", 13062995),
	GAME_ENTRY("harryshopshock", "snapattack.ags", "8f45073f4c89b9b9fd8990740bafa03a", 10582339),
	GAME_ENTRY("hauntedcastle", "haunted.exe", "3c22ec19306691b68c34f6ce98377265", 40287804),
	GAME_ENTRY("haven1", "A small world.exe", "b142b43c146c25443a1d155d441a6a81", 43019171),  // Windows
	GAME_ENTRY("haven1", "A small world.ags", "c764faa670679c24eb4d51957387f8b4", 40539027),  // Linux
	GAME_ENTRY("hawkeye", "heq.exe", "2870eb249d21d414ca1de98401190293", 136607518),
	GAME_ENTRY("headbangerheaven", "Beta8.exe", "f6a5f0a2f617b84174b5ab48147ae9f7", 74939699),
	GAME_ENTRY("headoverheels", "HeadOverHeels.exe", "9adc0f6d055efb4e21093f9216dd40fe", 12051069),  // Deluxe
	GAME_ENTRY_PLATFORM("headoverheels", "HeadOverHeels.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 9325331, "MAGS"), // MAGS
	GAME_ENTRY("heartland", "Heartland V1.2.exe", "261d108f9213356a351b35b54867f342", 21237374),
	GAME_ENTRY_PLATFORM("heartland", "Heartland.exe", "0829f8e184ed6a4bf36b14ba42003a67", 6702004, "Deluxe"),
	GAME_ENTRY_PLATFORM("heartland", "Heartland.exe", "0829f8e184ed6a4bf36b14ba42003a67", 6701875, "Deluxe"), // v1.1
	GAME_ENTRY("heartofabraxas", "orowgame.exe", "0710e2ec71042617f565c01824f0cf3c", 15632750),
	GAME_ENTRY("heatwave", "Heatwave.exe", "e2f7df57d111e57e3cf1e229088c6947", 3638644),
	GAME_ENTRY("heavenhell", "Limbo Adventure.exe", "9ecb923d5169ded48d5fd2c6ed4befa4", 31138864),
	GAME_ENTRY_PLATFORM("heavenhell", "Limbo Adventure.exe", "7c10efb8990fb48ded51fbcd88a6bf17", 30800724, "AKA Limbo - The Adventure Game"),
	GAME_ENTRY("heavymetalnannulf", "NannulfMAGS.exe", "3c5bd1713959ff469cb46ebe5542cfcf", 21272417),
	GAME_ENTRY("hecamethroughthedoor", "He Came Through the Door.exe", "78dd4ca028ee0156b6a093d6d780aa65", 30263715),
	GAME_ENTRY("heed", "Heed.exe", "e8b2a430042709f07183c2c249e0e0d9", 6300045),
	GAME_ENTRY("helloneighbor", "Hello Neighbor!.exe", "a524cbb1c51589903c4043b98917f1d9", 6811100),
	GAME_ENTRY("hellotaxi", "taxi.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3132739),
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.exe", "e09e4f152c8f4553e90885391ac72e46", 4783941, "0.1.0 Alpha"),
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.exe", "e09e4f152c8f4553e90885391ac72e46", 6127544, "0.2.0 Alpha"),
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.exe", "e09e4f152c8f4553e90885391ac72e46", 6137066, "0.3.0 Alpha"),
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.exe", "e09e4f152c8f4553e90885391ac72e46", 6365194, "0.4.0 Alpha"),
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.exe", "e09e4f152c8f4553e90885391ac72e46", 6371263, "0.5.0 Alpha"),
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.exe", "e09e4f152c8f4553e90885391ac72e46", 7535277, "1.0"),  // Windows
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.ags", "a5032265c42a1a976a86870c9a1193e0", 5049501, "1.0"),  // Linux
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.exe", "7ddb9e776648faed5a51170d087074e9", 9712775, "1.1.0"),
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.exe", "e09e4f152c8f4553e90885391ac72e46", 9769286, "1.2.0"),  // Windows
	GAME_ENTRY_PLATFORM("hellspuppy", "dogfromhell.ags", "cc16dae148e82e8d79f1ad0269ec3668", 7283510, "1.2.0"),  // Linux
	GAME_ENTRY("helpthegame", "HELP.exe", "06a03fe35791b0578068ab1873455463", 3686323),
	GAME_ENTRY("hendrixisland", "HendrixIsland.exe", "5c06d8be06d65fbda5a006ec703fbd41", 29319207),
	GAME_ENTRY("henkstroemlostincellar", "Henk_LIC.exe", "3128b9f90e2f954ba704414ae854d10b", 1391240),
	GAME_ENTRY("henman", "hen-man.exe", "615e73fc1874e92d60a1996c2330ea36", 19556067),
	GAME_ENTRY("henrysmith", "Henry Smith.exe", "b5c41e08919834b549ca350a28f18f87", 10896764),
	GAME_ENTRY("herby", "Herby.exe", "033f047c11ee95db0058c188ec620bb2", 6715991), // itch.io Win/Linux
	GAME_ENTRY("herenosirens", "mags092018.exe", "78dd4ca028ee0156b6a093d6d780aa65", 52618339),
	GAME_ENTRY("herenosirens", "mags092018.ags", "558f2f3cb55d2045d164fe342f15ac99", 50133587),
	GAME_ENTRY("heroeswyrdale", "mags1904.exe", "7971a7c02d414dc8cb33b6ec36080b91", 195444903),  // Windows
	GAME_ENTRY("heroeswyrdale", "mags1904.ags", "51ff78da52b2873cacb5e9b21cc1c610", 192947863),  // Linux
	GAME_ENTRY_STEAM("heroinesquest", "heroine's quest.exe", "35b93e905a5aeba8fafd0e5b0f4cb9b6", 7014402),
	GAME_ENTRY_STEAM("heroinesquest", "heroine's quest.exe", "fa5b449d9d93a9055e0ab6caf0aee77c", 7020827), // v1.2.7
	GAME_ENTRY("heroinesquest", "heroine's quest.exe", "0b19953a0a879b5027c98b0cdd8142f1", 6825340),
	GAME_ENTRY("heroinesquest", "heroine's quest.exe", "35b93e905a5aeba8fafd0e5b0f4cb9b6", 6952250),
	GAME_ENTRY("hesgonehistorical", "His.exe", "465f972675db2da6040518221af5b0ba", 5768754),
	GAME_ENTRY("hhgtgtowelday", "TowelDay.exe", "18456f28d9bf843b087e80072c85beca", 5431338),
	GAME_ENTRY("hiddenplains", "eureka02.exe", "6afafd26476d17a5e2a8e41f690d3720", 384360829),  // Windows
	GAME_ENTRY("hiddenplains", "eureka02.ags", "024d04d4d227cfb32b66a7fb8e4561f2", 381866349),  // Linux
	GAME_ENTRY("hiddentreasureryansfortune", "HiddenTRF.exe", "504df40bf50a0859e3dc15b000dab5f6", 7345149),
	GAME_ENTRY("hide", "Hide.exe", "6e861b1f476ff7cdf036082abb271329", 13701886),
	GAME_ENTRY("him", "twin.exe", "6b4ceb9e327ac99479c08d825461f4cb", 23721672),
	GAME_ENTRY("hitchhikersguidetothegalaxyremake", "HHGTG.exe", "e003041f4332f136920e636e39d3e127", 34956191),
	GAME_ENTRY("hitthefreak", "HTF.EXE", "f3a13b2d6c2e0fe04c6f466062920e23", 3103477),
	GAME_ENTRY("hiyah", "HiYah- game.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2972762),
	GAME_ENTRY("hjarta", "Hjarta.exe", "1c00b5d482f5531cb1eba7360b98b3e4", 642373238),  // v1.0.1
	GAME_ENTRY("hjarta", "Hjarta.exe", "1c00b5d482f5531cb1eba7360b98b3e4", 642373213),  // v1.0
	GAME_ENTRY("hlobb", "Boxing.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 9544151),
	GAME_ENTRY("hoik", "game.ags", "3b7cceb3e4bdb031dc5d8f290936e94b", 5408433),
	GAME_ENTRY("homesweetron", "RoN - Home Sweet RoN.exe", "311cf286b596ed7c68d5505424dea1bc", 14135201),
	GAME_ENTRY("honksadventure", "house_eng_5.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1746878),
	GAME_ENTRY_LANG("honksadventure", "housesitting_18.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1746919, Common::DE_DEU),
	GAME_ENTRY("hope", "Hope.exe", "f92eba780bd1177612e264263d34c555", 4195489),
	GAME_ENTRY("horseparkdeluxe", "Horse Park DeLuxe.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 22491099),
	GAME_ENTRY("horseparkfantasy", "Horse Park Fantasy.exe", "615e73fc1874e92d60a1996c2330ea36", 16576614),
	GAME_ENTRY("hotel", "Hotel.exe", "615e73fc1874e92d60a1996c2330ea36", 29586297),
	GAME_ENTRY("hotelhansen", "Hotel.exe", "3128b9f90e2f954ba704414ae854d10b", 4006863),  // v2.0
	GAME_ENTRY("hotelhijinks", "HH.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1490538),
	GAME_ENTRY("housedesade", "House of de Sade.exe", "173f00e582eebd082d66f1291702b373", 85765288),
	GAME_ENTRY("housequest2", "house2.exe", "9cb3c8dc7a8ab9c44815955696be2677", 4471723),
	GAME_ENTRY("howmany", "How many.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 5925587), //  v1.0
	GAME_ENTRY("howmany", "How many.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 5925931), //  v1.1
	GAME_ENTRY("howtheyfoundsilence", "How They Found Silence.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 5322796),
	GAME_ENTRY("hubris", "Hubris.exe", "3b2f2a03ab0ae3ce1d2248843b9c2395", 6772869),
	GAME_ENTRY("hungry", "Hungry!.exe", "0710e2ec71042617f565c01824f0cf3c", 15619749),
	GAME_ENTRY_LANG("hungryworm", "boom.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 934966, Common::NL_NLD),
	GAME_ENTRY("huongjiaoping", "hotpot.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 47237302),
	GAME_ENTRY("hybrid", "hybrid.exe", "c5d2c54c20cb606519b86d3890ee7fc0", 10607084),
	GAME_ENTRY("hydeandseek", "Hyde and Seek.exe", "c2f495a688dc19e66362657dee9aa895", 28066547),
	GAME_ENTRY("hydrate", "Hydrate.exe", "b3ba6cb504a31fd2ce43e86280eb06a7", 3968325),  // Windows
	GAME_ENTRY("hydrate", "Hydrate.ags", "eb7203ea3e432183394a36f0b58d7d88", 1470261),  // Linux
	GAME_ENTRY("hypnotoad", "Hypnotoad.exe", "06a03fe35791b0578068ab1873455463", 1947740),
	GAME_ENTRY("iamjason", "IAMJASON.exe", "e8985d9ffbfa1eda77f2eb8d1331944a", 4843842),
	GAME_ENTRY("icantsleep", "The Bait that Lures.exe", "7e2043ac91777f83869ea255d9fcbc28", 67515438),
	GAME_ENTRY("iceintheair", "IceInTheAir.exe", "bf2a2e7c608d33102f4d532e5cdcddda", 4365231),  //v1.2
	GAME_ENTRY("icestationzero", "Ice Station Zero.exe", "9f8a9d74c09f188af9af3e263f8b59bc", 36606112),  // Windows
	GAME_ENTRY("icestationzero", "Ice Station Zero.ags", "970bc84550c7e623e7bce6191f372137", 33569932),  // Linux
	GAME_ENTRY("id", "iD.exe", "495d45fb8adfd49690ae3b97921feec6", 19035497),
	GAME_ENTRY("iforgot", "Forgot.exe", "6aa30185326552359c7865e55c045a74", 7743871),
	GAME_ENTRY("iggrok", "grok.exe", "9cf51833e787cc919837d9a8bd8fc14c", 1046039),
	GAME_ENTRY("igspaceadventurer", "IGS.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 1204802),
	GAME_ENTRY("igstrangeplanet", "tsp.exe", "b25674056fe8cc0b7bf0a4409c5c5bfc", 2207926),
	GAME_ENTRY("iiispy", "IIISpy.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 6696408),  // v1
	GAME_ENTRY("iiispy", "IIISpy.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 6696286),
	GAME_ENTRY_PLATFORM("iiispy", "IIISpy.ags", "0a4731cd3995a4d055e84ab5e63ebb80", 6428749, "v1.2"),  // v1.2 Linux
	GAME_ENTRY_PLATFORM("iiispy", "IIISpy.exe", "21d7482c8e968857e2653debeaa8a384", 8909917, "v1.2"),  // v1.2 Win
	GAME_ENTRY("iisstabbings", "MAGS_11_2012.exe", "82da2565c456dcfb265ded6fe3189c0b", 4759681),
	GAME_ENTRY("illuminationdiminishing", "IlluminationDiminishing.exe", "b142b43c146c25443a1d155d441a6a81", 21227029),
	GAME_ENTRY("illuminationdiminishing", "IlluminationDiminishing.exe", "b142b43c146c25443a1d155d441a6a81", 49006279),
	GAME_ENTRY("illuminationdiminishing", "IlluminationDiminishing.exe", "b142b43c146c25443a1d155d441a6a81", 49006319),
	GAME_ENTRY("illusion", "Illusions.exe", "0710e2ec71042617f565c01824f0cf3c", 2576009),
	GAME_ENTRY("imfree", "I'm free.exe", "d90cd956022235ed9b272fb0b2ab5792", 241986165),
	GAME_ENTRY("imfree", "Soy Libre.exe", "d90cd956022235ed9b272fb0b2ab5792", 241924247),
	GAME_ENTRY("imnotcrazyrightthecell", "I'm not crazy.exe", "9cb3c8dc7a8ab9c44815955696be2677", 3152216),
	GAME_ENTRY("imnotcrazyrightthewell", "The Well.exe", "9cb3c8dc7a8ab9c44815955696be2677", 5000358),
	GAME_ENTRY("imonlysleeping", "sleeping.exe", "465f972675db2da6040518221af5b0ba", 2489565),
	GAME_ENTRY("imstillhere", "PostApocalypse.exe", "615e73fc1874e92d60a1996c2330ea36", 5436580),
	GAME_ENTRY("inbloom", "In-Bloom.exe", "f43f4ceb97c8b2317fce6e0b921998a5", 9288711),  // v1.4 Win
	GAME_ENTRY("inbloom", "In-Bloom.ags", "a663a1c1bbd052f1339526066cce8117", 3400809),  // v1.4 Linux
	GAME_ENTRY("indianarodent", "Indiana Rodent.exe", "89df481678b2ddc40ecc9f83caa76b89", 5629366),  //v1.1
	GAME_ENTRY_PLATFORM("indianarodent", "Indiana Rodent.exe", "510be04e5eec2aa92bb78b060f138d64", 4564295, "MAGS"),  //MAGS
	GAME_ENTRY("indybones", "Book of the Gods.exe", "4064f82b96cab962a1d1bca434ad9c8d", 48937857),
	GAME_ENTRY("indycomingofage", "IndyCOA.exe", "90413e9ae57e222f8913b09d2bc847bc", 2368083),
	GAME_ENTRY("indygoldofgenghiskhan", "Indy.exe", "b676bb7963adc3611bc67635123d293a", 6325803),
	GAME_ENTRY("indypassageofsaints", "Compiled_AGS3.2.1.exe", "4370edcb2ef8b9ecb323fb5a94770117", 78409939),
	GAME_ENTRY("indyrelicoftheviking", "Indiana Jones and the relic of the viking.exe", "de375dffcb0635bb84daf82eaddf4e3b", 63943198),  //v1.1
	GAME_ENTRY("infantrydivision", "Infantry.exe", "0710e2ec71042617f565c01824f0cf3c", 9144372),
	GAME_ENTRY("infectionep1", "Infection I.exe", "7132ff7d6b0bc1e9f3e4bd4755390626", 25974295),
	GAME_ENTRY("infinitemonkeys", "InfiniteMonkeys.exe", "4d7d2addcde045dae6e0363a43f9acad", 4841557),
	GAME_ENTRY("infinitemonkeys", "InfiniteMonkeys.exe", "21fd0f65dfa48de2b39cb8ec23b30889", 4531999), //MAGS 2006
	GAME_ENTRY("infinitemonkeys", "InfiniteMonkeys.exe", "60e8d15faf490b2d317e2036b4fb9a9c", 6126255), //version 1.3
	GAME_ENTRY("infinitybit", "InfinityBit.exe", "27343924ddad3be0b97bdcaa71858b1b", 48338191),
	GAME_ENTRY("inlimbo", "inLIMBO.exe", "0710e2ec71042617f565c01824f0cf3c", 1883031),
	GAME_ENTRY("innersanctum", "Inner Sanctum.exe", "36f44e064eab15e502caeb60fd09f52d", 88875883),
	GAME_ENTRY("insanebert", "Insane Bert.exe", "18b284c22010850f79bc5c20054a70c4", 1675739),
	GAME_ENTRY("insidemonkeyisland", "MIIM.exe", "06a03fe35791b0578068ab1873455463", 5186306),
	GAME_ENTRY("insidemonkeyislandch2", "MIIM2.exe", "06a03fe35791b0578068ab1873455463", 5885525),
	GAME_ENTRY_LANG("insidemonkeyislandch3", "IMI3.exe", "06a03fe35791b0578068ab1873455463", 7337235, Common::IT_ITA),
	GAME_ENTRY("inspectorgismoe", "police.exe", "465f972675db2da6040518221af5b0ba", 2899579),
	GAME_ENTRY("integerbattleship", "intbattl.exe", "0500aacb6c176d47ac0f8158f055db83", 4158273),
	GAME_ENTRY("intergalacticspacepancake", "space.exe", "97d700529f5cc826f230c27acf81adfd", 1797309),
	GAME_ENTRY("interstellarborders", "Interstellar Borders New.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 13864633),
	GAME_ENTRY("intothelight", "ITL.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 12146182),
	GAME_ENTRY("intraworld", "Intra World.exe", "0241777c2537fc5d077c05cde10bfa9f", 44338673),
	GAME_ENTRY("intraworld2", "troll.exe", "495d45fb8adfd49690ae3b97921feec6", 2935816),
	GAME_ENTRY("invincibleisland", "Invincible.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 4218160),
	GAME_ENTRY("invincibleisland", "Invincible.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1751882),  //v1
	GAME_ENTRY("ioawn4t", "ioawn4t.ags", "34455803b41269a1a2dd44cc8b2d549f", 884275141), // Linux
	GAME_ENTRY("ioawn4t", "ioawn4t.exe", "b93a59eb67e202f5e807d7a7e678ad85", 887314393), // Windows
	GAME_ENTRY("ioawn4t", "ioawn4t.exe", "b93a59eb67e202f5e807d7a7e678ad85", 887315687),
	GAME_ENTRY("ioawn4t", "ioawn4t.exe", "11bd8123982f9442f372ed5defc88b50", 888895169),
	GAME_ENTRY("ioawn4t", "game.ags", "11bd8123982f9442f372ed5defc88b50", 888895169),
	GAME_ENTRY("irentedaboat", "I_rented_a_boat.exe", "792c0a0eaeba1a8846cb7b1af1e3266e", 144007992),  // Windows
	GAME_ENTRY("irentedaboat", "I_rented_a_boat.ags", "9c8cbf1ee6f0a797fdaee29177a43224", 140971300),  // Linux
	GAME_ENTRY("isaacodyssey", "isaacsoddysee.exe", "615e73fc1874e92d60a1996c2330ea36", 5339324),  //v1.1
	GAME_ENTRY("isnkill", "ISN.exe", "4d17844029d8910fbaae1bdc99e250f2", 7932669),
	GAME_ENTRY("isos", "ISOS.exe", "06a03fe35791b0578068ab1873455463", 7362937),
	GAME_ENTRY("ispy2", "I Spy II.exe", "c87aa6377abc18c1a1b2968ae6db08eb", 2293873),
	GAME_ENTRY("itsabugslife", "It's a Bugs Life.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 201172081),
	GAME_ENTRY("itsjustarongame", "RONgames.exe", "97d700529f5cc826f230c27acf81adfd", 2171873),
	GAME_ENTRY("iwalkedapath", "I walked a path.exe", "fd3ecd8289bebadbf775fe8a13b9c5d7", 89018261),
	GAME_ENTRY("iwantanidentity", "Quiero una identidad - Akkad Estudios.exe", "ffaf92297a381f2770f204122b4cc26a", 404765762),
	GAME_ENTRY("iwantout", "I_want_out!.exe", "c2cb8ff1ad3028b08fd3dab91578b934", 22218677),  //v1.1.5
	GAME_ENTRY("iwantout", "I_want_out!.ags", "2a31f07d3105c978d9b0392000f38461", 22718900),
	GAME_ENTRY("iwantout", "I_want_out!.ags", "7db3059844c14f1d817f68b958b66f45", 22718900),
	GAME_ENTRY("iwanttodie", "ElMito.exe", "f120690b506dd63cd7d1112ea6af2f77", 11304944),
	GAME_ENTRY("iwanttodieremake", "IWTD.exe", "981e60a9be515bb56c634856462abbc7", 62882828),
	GAME_ENTRY("iwwhiiwwhitomirotpgthegame", "IWWHIIWWHITOMIROTPG - The Game.exe", "5fd79c32d2b8bbd589f6254d611d2742", 3576019),
	GAME_ENTRY("jack", "JACK.exe", "615e73fc1874e92d60a1996c2330ea36", 243357628),
	GAME_ENTRY("jacktrasheaterch1", "carrin.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2376923),
	GAME_ENTRY("jacktrekker", "Jack Trekker.exe", "cb07ae51acec1830dd67c508b90f8951", 51900973),
	GAME_ENTRY("jacob", "Jacob.exe", "90413e9ae57e222f8913b09d2bc847bc", 7101001),
	GAME_ENTRY("jacobvacut", "JacobVAcut.exe", "06a03fe35791b0578068ab1873455463", 8017226),
	GAME_ENTRY("jacquelinewhitereddesert", "Jacqueline White.exe", "02ab2c5f53f42d494491b7f411da8d47", 119383318),
	GAME_ENTRY("jailhouse", "viki.exe", "465f972675db2da6040518221af5b0ba", 3769307),
	GAME_ENTRY("jamesbond", "platform2.exe", "949f7440e3692b7366c2029979dee9a0", 4467701),
	GAME_ENTRY("jamesinneverland", "JamesNeverland.exe", "06a03fe35791b0578068ab1873455463", 36488607),
	GAME_ENTRY("jamesperis", "James1.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 85631684),  // Eng/Spa
	GAME_ENTRY_LANG("jamesperis", "James1.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 85605688, Common::ES_ESP),
	GAME_ENTRY("jasongoldenapple", "Jason and the Golden Apple.exe", "7446ce302043dac2acc8cd5cc7cc8f68", 732192390),
	GAME_ENTRY("javelincatch", "JvlnCtch.exe", "3421b46ff95c5885603086c39a038a20", 1626263),
	GAME_ENTRY("jetpacksam", "Jetpack Sam.exe", "173f00e582eebd082d66f1291702b373", 12574372),
	GAME_ENTRY("jimmysday", "jimmy.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 13419394),
	GAME_ENTRY("jimmythetroublemaker", "Jimmy The Troublemaker.exe", "25976a689b0f4d73eac69b1728377ecb", 200843118),
	GAME_ENTRY("joeshorriblehell", "Joe's Horrible Hell.exe", "cdcc787023c51c6fc9ffc17118f6adff", 61061393),
	GAME_ENTRY("joesmiserablelife", "Joe's Miserable Life.exe", "1b9f13d430bb15bf30d0fd044358db68", 36705304),
	GAME_ENTRY("johnharris", "totp.exe", "74dc062c5f68f3d70da911f2db5737b6", 36463878),
	GAME_ENTRY("johnjebediahgun", "JJG.exe", "a28cb95e1769ba1bfa48f850390746c2", 88957123),
	GAME_ENTRY("johnlosthiskeyep1", "Newgame.exe", "0b7529a76f38283d6e850b8d56526fc1", 1453831),
	GAME_ENTRY("johnlosthiskeyep2", "Johnny.exe", "0500aacb6c176d47ac0f8158f055db83", 1182438),
	GAME_ENTRY("johnnyrocket", "Rocket.exe", "a524cbb1c51589903c4043b98917f1d9", 10366294),
	GAME_ENTRY_LANG("johnsinclair", "John Sinclair- Voodoo in London.exe", "68c4cdee67c40bf96cf78e11f9073ddd", 238169392, Common::DE_DEU),
	GAME_ENTRY("jonahsplace", "Jonah's Place.exe", "615e73fc1874e92d60a1996c2330ea36", 28368426),
	GAME_ENTRY("jonnyfeces", "Jonny Smallvalley.exe", "01d0e6bd812abaa307bcb10fc2193416", 34437869),
	GAME_ENTRY("journey", "journey.exe", "be858e83311d4f1b49e05b933b92f0a9", 2617447),
	GAME_ENTRY("journeyhome", "Journey Home.exe", "20aa2fac9f64e876da8ed437f609bad6", 1982898758),  //v1.1 Win
	GAME_ENTRY("journeyhome", "Journey Home.ags", "0c80d863920b7b2002764a11ab825fff", 1980416054),  //v1.1 Linux
	GAME_ENTRY("journeyhell", "Cropcircles.exe", "e80586fdc2db32f65658b235d8cbc159", 211064206),
	GAME_ENTRY_LANG("juliusdangerous1", "Julius Dangerous.exe", "ddaf3807f1fe16b2813ff832b4fb471a", 83137140, Common::IT_ITA),
	GAME_ENTRY_LANG("juliusdangerous1", "Julius Dangerous.exe", "79077a68e53562082494933a21e2714f", 83175251, Common::IT_ITA),  //v1.0.0.3
	GAME_ENTRY("juliusdangerous2", "Julius Dangerous 2.exe", "e2d4a98de69b1f8e6462c387710a441a", 146931732),
	GAME_ENTRY("juliusdangerous2", "Julius Dangerous 2.exe", "15ee13935b9555a041df569af8598bfe", 159441130),  //v1.2
	GAME_ENTRY("jumpinjack", "Jumpin' Jack.exe", "338fa79960d40689063af31c671b8729", 36458660),
	GAME_ENTRY("jumpinjones", "ags.exe", "36f44e064eab15e502caeb60fd09f52d", 19633830),
	GAME_ENTRY("jumpjackflash", "Jump! Jack! Flash!.exe", "6b4ceb9e327ac99479c08d825461f4cb", 20103698),
	GAME_ENTRY("june20th", "June 20th.exe", "f18443f98fd61d2c655e76a17f7da905", 11198272),
	GAME_ENTRY("justanotherpointnclickadventure", "Advent.exe", "6a98b4cc2f5a55421248be53f15a6a99", 9582620),
	GAME_ENTRY("justyouandme", "it'swithyou.exe", "495d45fb8adfd49690ae3b97921feec6", 19545407),
	GAME_ENTRY("kanjigakusei", "KanjiGakusei.exe", "c1bce0ccfa858f0f5d2fe19997d89b05", 17604764),
	GAME_ENTRY("kartquest", "Kart.exe", "465f972675db2da6040518221af5b0ba", 77317312),
	GAME_ENTRY("kata", "KATA.exe", "06a03fe35791b0578068ab1873455463", 4631650),
	GAME_ENTRY("keptosh1", "Keptosh.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 2904848),
	GAME_ENTRY("keyboardmadness", "piano.exe", "f120690b506dd63cd7d1112ea6af2f77", 1767775),
	GAME_ENTRY("keysofagamespace", "Keys.exe", "75f4c7f66b1be60af5b2d65f617b91a7", 85582285),
	GAME_ENTRY("keysofagamespace", "Keys.exe", "75f4c7f66b1be60af5b2d65f617b91a7", 85581872),  //v1.2
	GAME_ENTRY("killereye", "killereye.exe", "0710e2ec71042617f565c01824f0cf3c", 1009042),
	GAME_ENTRY("killjoseda", "KillJD.exe", "20dc02a8f977caf5c4dc6f2a4c8d4378", 6034414),
	GAME_ENTRY("killmenow", "Kill me now.exe", "b5c41e08919834b549ca350a28f18f87", 35675885),  // Windows
	GAME_ENTRY("killmenow", "Kill me now.ags", "355985efd32c26c7b937e0b8039c46a4", 33414365),  // Linux
	GAME_ENTRY("killthelights", "Kill The Lights.exe", "9b54ea3557373188d8388ec4d1ae5eed", 20416736),
	GAME_ENTRY("kingdomlegend1", "Kingdom Legends.exe", "06a03fe35791b0578068ab1873455463", 2254139),
	GAME_ENTRY("kingdomlegend2", "KL2.exe", "f1a8c734c513909d130b3ae139b5f076", 305831701),
	GAME_ENTRY("kingofrock", "ags_mi3.exe", "0500aacb6c176d47ac0f8158f055db83", 5142697),
	GAME_ENTRY("kingsquestfororgy", "KQ.exe", "97d700529f5cc826f230c27acf81adfd", 1574600),
	GAME_ENTRY_LANG("kirja", "Kirjasto.exe", "a524cbb1c51589903c4043b98917f1d9", 3865024, Common::FI_FIN),
	GAME_ENTRY("kittenadv", "Kitten.exe", "9973fbc73cce23867246d3a5e3c86d01", 5423637),
	GAME_ENTRY("kittyquest", "multiverbtemplate.exe", "6e861b1f476ff7cdf036082abb271329", 78650122),
	GAME_ENTRY("knightquestforgoldenring", "KQuestGoldRing.exe", "f120690b506dd63cd7d1112ea6af2f77", 2582542),
	GAME_ENTRY("knightsquest3", "KQ3TOM.exe", "0710e2ec71042617f565c01824f0cf3c", 8405513),  //v1.0
	GAME_ENTRY("knightsquest3", "KQ3TOM.exe", "0710e2ec71042617f565c01824f0cf3c", 8408641),
	GAME_ENTRY("knightsquest4", "MAGSQuest.exe", "0500aacb6c176d47ac0f8158f055db83", 4074151),
	GAME_ENTRY("knobblycrook", "Knobbly Crook.exe", "9d2c7d86fe1316d08678b732e4241076", 326499357),
	GAME_ENTRY("knobblycrook", "Knobbly Crook.exe", "d6269b2f4cc3da56077bb4e2df7984d5", 2035570004),
	GAME_ENTRY_LANG("koddurova", "Kod Durova.exe", "615e73fc1874e92d60a1996c2330ea36", 498427333, Common::RU_RUS),
	GAME_ENTRY("koffeekrisis", "Koffee Krisis.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 2423111),
	GAME_ENTRY("kongbaghdad", "baghdad.exe", "b216ee957dd677023e02d900281a02d6", 2091750),
	GAME_ENTRY("korinsmines", "Korin's Mines.exe", "465f972675db2da6040518221af5b0ba", 20055117),
	GAME_ENTRY("koscheitheimmortal", "Koschei.exe", "465f972675db2da6040518221af5b0ba", 2771442),
	GAME_ENTRY_PLATFORM("kq3plus", "KQ3plus.ags", "3b7cceb3e4bdb031dc5d8f290936e94b", 11727219, "Beta"),
	GAME_ENTRY("kq4retold", "King's Quest 4.exe", "da6140c1e246d5f7641464bda80c45d5", 148103603),
	GAME_ENTRY("kq4retold", "KQ4Retold.exe", "da6140c1e246d5f7641464bda80c45d5", 293710098),
	GAME_ENTRY("kq4retold", "KQ4Retold.exe", "da6140c1e246d5f7641464bda80c45d5", 312045017), // 1.04
	GAME_ENTRY("kq4retold", "King's Quest 4.ags", "e9e8f833b86874526cb5e356d1e287eb", 145563043),
	GAME_ENTRY("kq4retold", "ac2game.dat", "da6140c1e246d5f7641464bda80c45d5", 293710098),
	GAME_ENTRY("kristmaskrisis", "Kristmas Krisis.exe", "90413e9ae57e222f8913b09d2bc847bc", 2067681),
	GAME_ENTRY("ktx1", "KTX-1.exe", "615e73fc1874e92d60a1996c2330ea36", 13806290),
	GAME_ENTRY("kumastory", "Kuma Story.exe", "5d82ab003f108bf44999421884d69f55", 5621765),
	GAME_ENTRY("labor", "LaborEN.exe", "b9fcd61691d19d954a5cfd5fb57a6b45", 7245344),
	GAME_ENTRY("labratescape", "Joel.exe", "06a03fe35791b0578068ab1873455463", 3256136),
	GAME_ENTRY("labyrinth", "labyrnth.exe", "0710e2ec71042617f565c01824f0cf3c", 7686481),
	GAME_ENTRY("lacicuta1", "Cicuta1.exe", "1290e191d4f24893ce83ba0af5debd9e", 8665956),
	GAME_ENTRY("lacroixpan", "La Croix Pan.exe", "d9018b1792f6d959d7add4dc3f7cdb46", 12102643),
	GAME_ENTRY("laffaireaspirox", "L'Affaire Aspirox.exe", "23a67b6de10ec35e9f5a4dfc7d928222", 139865345),
	GAME_ENTRY("lagrancastanya", "PROJECT1.exe", "c87aa6377abc18c1a1b2968ae6db08eb", 39298012),
	GAME_ENTRY("lallaveyfabianshones", "LLAVE.exe", "a8d73d686b2eb77caab8c05e3e1f1d57", 3374527),
	GAME_ENTRY("lamaleta", "La Maleta.ags", "144566549a27ad1b41346627ec82f586", 43741777),
	GAME_ENTRY("laodiseadelfracaso2", "La Odisea II.exe", "0710e2ec71042617f565c01824f0cf3c", 3083622),
	GAME_ENTRY("larrylotter", "Warthogs.exe", "9c49b6fa0460f36d6e7558281f142683", 12448793),
	GAME_ENTRY("larrylotter", "warthogs.exe", "cbe62572ed082a3063a49d594612ac0b", 12397280), // v1.7
	GAME_ENTRY_STEAM("larrylotter", "larry lotter.ags", "2802b69370de199a1f8d47889a197c14", 47202232),
	GAME_ENTRY("lastnfurious", "Last'n'Furious.exe", "3569271305cddb7156260cce9439e543", 17696093),
	GAME_ENTRY("laundryday", "Laundry Day.exe", "06a03fe35791b0578068ab1873455463", 2456888),
	GAME_ENTRY("lavablava", "Rumble.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 2294674),
	GAME_ENTRY("lazaruswantspants", "pants.exe", "9cf51833e787cc919837d9a8bd8fc14c", 1311852),
	GAME_ENTRY("lbstoryofcedrickdusce", "lifeboat.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3563681),
	GAME_ENTRY("lechuckstories", "CHUCK_272.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6274861),
	GAME_ENTRY("legendofrovendale", "Vampire.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 10018497),
	GAME_ENTRY("legendofseththebard", "LOSTB 1.48.exe", "a524cbb1c51589903c4043b98917f1d9", 10669482),
	GAME_ENTRY("legendsofmardaram", "LOM.exe", "0710e2ec71042617f565c01824f0cf3c", 50183544),
	GAME_ENTRY("leisuresuitlarry2", "Larry 2.exe", "949f7440e3692b7366c2029979dee9a0", 11971760),
	GAME_ENTRY("leisuresuitlarrylil", "LSL.exe", "34cf71d28e1e9c55934f624969011c7e", 18440862),
	GAME_ENTRY("lesmiserables", "Les Miserables.exe", "0514661a4ba6772cf0db0cf839fc7003", 127582664),
	GAME_ENTRY("lessthanthree", "Less Than Three.exe", "3e62eafed0fc365821b7afdbf1aec3d8", 6506759),
	GAME_ENTRY("lessurvivants", "Les_Survivants.exe", "c5d2c54c20cb606519b86d3890ee7fc0", 265445972),
	GAME_ENTRY("lichdomwheresdidiputthat", "Lichdom.exe", "0e6ae2b49c1a38363a77024f3ce31771", 7412719),
	GAME_ENTRY("life", "Life.exe", "97a2a2feb82708da8f6ed30c15a7eb53", 43833851),
	GAME_ENTRY("lifeboatstoryofcedrick", "lifeboat.exe", "3128b9f90e2f954ba704414ae854d10b", 2952689),
	GAME_ENTRY("lifeofdduck", "D Duck.exe", "0710e2ec71042617f565c01824f0cf3c", 49461615),
	GAME_ENTRY("lifeofdduck2", "D. Duck II.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 135923689),
	GAME_ENTRY("liftreasureofthetanones", "Lif.exe", "18b284c22010850f79bc5c20054a70c4", 3946641),
	GAME_ENTRY("lightcycles", "LightCycles.exe", "495d45fb8adfd49690ae3b97921feec6", 3415108),
	GAME_ENTRY("lightningmaster", "Master.exe", "27343924ddad3be0b97bdcaa71858b1b", 231301393),
	GAME_ENTRY("likeafox", "likeafox.exe", "c7916b82f00c94013a3f7706b4d333c6", 2707737),
	GAME_ENTRY("limeylizardwastewizard", "LLWW.exe", "fab982fd31570655ac3b1858bd8265e4", 33755872),
	GAME_ENTRY("limeylizardwastewizard", "LLWW.exe", "1991fde090b8c3b7cf53561d11593836", 38188301),
	GAME_ENTRY("littlegirlinunderland", "Underland.exe", "06a03fe35791b0578068ab1873455463", 10125940),
	GAME_ENTRY("livingnightmaredeluxe", "Living Nightmare.exe", "4415d633ea1a2dcd03ff0eff43f182ee", 9997554),
	GAME_ENTRY("livingnightmareendlessdream", "LNED.exe", "4415d633ea1a2dcd03ff0eff43f182ee", 10671309),
	GAME_ENTRY("livingnightmarefreedom", "LNF.exe", "6aa30185326552359c7865e55c045a74", 26580184),
	GAME_ENTRY("lockedout", "locked-out.exe", "465f972675db2da6040518221af5b0ba", 1930862),
	GAME_ENTRY("loftusandtheskycap", "loftus.exe", "4c83816b87e6e253dc8e324e89bcbca3", 24333349),
	GAME_ENTRY("lonecase", "LoneCase.exe", "8661936f40669fa1672dced4df0521a0", 3550717),
	GAME_ENTRY("lonecase2", "Lone Case 2.exe", "cb3bbab6e565fcbd57af8f33a8609210", 6015178),
	GAME_ENTRY("lonecase3showdown", "lc 3.exe", "893df6568c294926f7efa3f3ec2ce14d", 7997004),
	GAME_ENTRY("lonelynight", "Lonely night.exe", "0710e2ec71042617f565c01824f0cf3c", 2488077),
	GAME_ENTRY("longexpectedfriday", "LEFRIDAY.exe", "28f82e420b82d07651b68114f90223c8", 7595812),
	GAME_ENTRY("lonkeyisland", "lonkey.exe", "4e92c6db88a34b62eef37a621aabfb53", 44134488),
	GAME_ENTRY("lonkeyisland", "lonkey.exe", "4e92c6db88a34b62eef37a621aabfb53", 44114957),
	GAME_ENTRY("lookingfordread", "Looking For Dread Mac Farlane.exe", "2321081ba51d1869ebe11b9ba126911b", 417051695),  // Windows
	GAME_ENTRY("lookingfordread", "Looking For Dread Mac Farlane.ags", "bde1905a3c6a6f7f4491378789512a68", 414566943),  // Linux
	GAME_ENTRY_LANG("lookingfordread", "A la recherche de Dread Mac Farlane.exe", "2321081ba51d1869ebe11b9ba126911b", 417052014, Common::FR_FRA),  // Windows
	GAME_ENTRY_LANG("lookingfordread", "A la recherche de Dread Mac Farlane.ags", "4d232dca7faf065d24f554b7be03740d", 414567262, Common::FR_FRA),  // Linux
	GAME_ENTRY("loomiireturnoftheswans", "loom2.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 9761097),
	GAME_ENTRY("losjovenesdelaguerra", "guerra.exe", "97d700529f5cc826f230c27acf81adfd", 4286035),
	GAME_ENTRY("lostanswers", "Lost Answers.exe", "c88de182eae58fdb43e5b4e587095ff5", 254684884),
	GAME_ENTRY("lostdollar", "Ron.exe", "c87aa6377abc18c1a1b2968ae6db08eb", 4542929),
	GAME_ENTRY("lostinparadise", "2paradise.exe", "06a03fe35791b0578068ab1873455463", 37279978),
	GAME_ENTRY("lostinthenightmare", "litn.exe", "0710e2ec71042617f565c01824f0cf3c", 5492994),
	GAME_ENTRY("lostinthenightmare", "litn.exe", "0710e2ec71042617f565c01824f0cf3c", 5493239),
	GAME_ENTRY("lostinthetomb", "PaperKubik.exe", "33c2a53cb4a4ae48787d42980852047b", 2659023),
	GAME_ENTRY("lostinthewoods", "LITW.exe", "00328f4f1e7729144483107b96b11df8", 55203461),
	GAME_ENTRY("lucasmaniac", "LucasManiac !.exe", "f120690b506dd63cd7d1112ea6af2f77", 28361487),
	GAME_ENTRY("lucidlucy", "LUCID LUCY.exe", "655363c390c7ae7225c237108edf50b7", 182038828),
	GAME_ENTRY("lucylavender", "Lucy.exe", "c87aa6377abc18c1a1b2968ae6db08eb", 7944054),
	GAME_ENTRY("lukesexistentialnightmare", "Lukeexit.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 653834),
	GAME_ENTRY("lunarlanderprototype", "LunarLanderPrototype.exe", "495d45fb8adfd49690ae3b97921feec6", 3510282),
	GAME_ENTRY("lydiaandthemysteryofnellrenomanor", "LydiaW.exe", "615e73fc1874e92d60a1996c2330ea36", 33971307),
	GAME_ENTRY("maggieandmax", "Max.exe", "465f972675db2da6040518221af5b0ba", 5759981),
	GAME_ENTRY("magic8ball", "Magic-8-Ball.exe", "82da2565c456dcfb265ded6fe3189c0b", 4233735),
	GAME_ENTRY("magicalwhatevergirlrocksoutinthestoneage", "mwg.exe", "b2b99b5b3dcaee0fa292343c5a2c429b", 7784104),
	GAME_ENTRY("magicballoffortune", "Magic Ball.exe", "f120690b506dd63cd7d1112ea6af2f77", 6016698),
	GAME_ENTRY("magnumpm", "Magnum, P.M.exe", "06a03fe35791b0578068ab1873455463", 91711892),
	GAME_ENTRY("magsic", "Magsic.exe", "7a436b9a2e8e80c8aaaeed09ef9e3d3d", 22360144),
	GAME_ENTRY("magsic2", "MagsicII.exe", "28f82e420b82d07651b68114f90223c8", 30029761),
	GAME_ENTRY("magsjune2017", "MAGS june 2017.exe", "e3962995a70923a8d5a8f1cf8f932eee", 304129558),
	GAME_ENTRY("magssep2007", "MAGS Sep 2007.exe", "f120690b506dd63cd7d1112ea6af2f77", 6007305),
	GAME_ENTRY("majorbummerdude", "visyron.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 3104750),
	GAME_ENTRY("manboy", "Man Boy.exe", "1275885401b7d2ece491e704535707d9", 3038532),
	GAME_ENTRY("maniacland", "AliceInManiacland.exe", "74203c62b4604c4463f1c53db2d47c01", 6570499),  // Windows
	GAME_ENTRY("maniacland", "AliceInManiacland.ags", "00596e8a9f0bd774528fb8c7225bed0d", 4082163),  // Linux
	GAME_ENTRY("maniacland", "AliceInManiacland.exe", "d37a4f06126fc1f3bb7e5c31bd58a014", 8015351),  // Windows (newer)
	GAME_ENTRY("maniacmansiondeluxe", "Maniac.exe", "465f972675db2da6040518221af5b0ba", 10181366), // v1.3
	GAME_ENTRY("maniacmansiondeluxe", "Maniac.exe", "465f972675db2da6040518221af5b0ba", 10409172),
	GAME_ENTRY("maniacmetalheadmania", "Maniac Metalhead Mania.exe", "d4dbb53d3617dcbb56251eb4a332fddd", 11785951),
	GAME_ENTRY("mardsrevengebytk", "MPLR.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 1771793),
	GAME_ENTRY("martyausdemall", "test3.exe", "0710e2ec71042617f565c01824f0cf3c", 4352013),
	GAME_ENTRY("mash", "MASH.ags", "8fe67d5a066d4ab203db0cce102ed86c", 12536184),
	GAME_ENTRY("mash", "MASH.exe", "7825fa980fcd058caadaf6d3377b1f78", 15571852),
	GAME_ENTRY("mastersofsound", "MOS.exe", "bb59de174d70797d774dec76a171352d", 20298343),
	GAME_ENTRY("matttothefuture", "MTTF.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 5560975),
	GAME_ENTRY("maverickgunn", "Maverick Gunn.exe", "2bc8f994a7d1e05ed45f35abf2128231", 19431941),
	GAME_ENTRY("medicaltheoriesofdrkur", "dfg.exe", "465f972675db2da6040518221af5b0ba", 3140527),
	GAME_ENTRY("mego2008silvesteredition", "Me Go Store III.exe", "06a03fe35791b0578068ab1873455463", 12040937),
	GAME_ENTRY("megoaway", "Me Go Store II.exe", "06a03fe35791b0578068ab1873455463", 6640781),
	GAME_ENTRY("megocannibaljungle", "mgcj.exe", "06a03fe35791b0578068ab1873455463", 7127871),
	GAME_ENTRY("megostore", "Me Go Store.exe", "90413e9ae57e222f8913b09d2bc847bc", 2961962),
	GAME_ENTRY("melrin1", "Melrin.exe", "803e65c28364b6bf44b7c4610fcdaa5a", 12822475),
	GAME_ENTRY("melrin2", "Melrin2.exe", "803e65c28364b6bf44b7c4610fcdaa5a", 4372768),
	GAME_ENTRY("melrin3", "Melrin3.exe", "803e65c28364b6bf44b7c4610fcdaa5a", 5802221),
	GAME_ENTRY("memoriesfade", "MemoriesFade.exe", "d5d028212a242a9841feff24ec3db3c9", 7996519),
	GAME_ENTRY("meninhats", "GAME.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 1646510),
	GAME_ENTRY("merrychristmas", "Merry Christmas.exe", "172b30c282856b382464bed5fcb61e29", 4812266),
	GAME_ENTRY("messedupmothergoosedeluxemyassenhanced", "MMG.exe", "d642f2110a3dc0c48ab7b13f69b5caf6", 36523450),
	GAME_ENTRY("meta", "META.exe", "06a03fe35791b0578068ab1873455463", 10113135),
	GAME_ENTRY_STEAM("meta", "meta.exe", "9358670438c3fab77489a1dd229029b1", 2536926),
	GAME_ENTRY("metaphobia", "Metaphobia.exe", "10da7427cf74ba0cc7ceb29f99ff0a67", 92083437), // itch.io 1.01 Windows
	GAME_ENTRY("metaphobia", "ac2game.exe", "10da7427cf74ba0cc7ceb29f99ff0a67", 92083437), // itch.io MacOS
	GAME_ENTRY_STEAM("metaphobia", "Metaphobia.exe", "10da7427cf74ba0cc7ceb29f99ff0a67", 92086491),
	GAME_ENTRY("meteorheadrecycled", "Meteorhead.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 5081311),
	GAME_ENTRY("mibaddaytobedead", "Monkey.exe", "f120690b506dd63cd7d1112ea6af2f77", 2117238),
	GAME_ENTRY("micarnivalofthedamned", "MI-COD.exe", "90413e9ae57e222f8913b09d2bc847bc", 5114086),
	GAME_ENTRY("mickeymauserpart1", "MM.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 12076323),
	GAME_ENTRY("midastouch", "midastouch.exe", "6e861b1f476ff7cdf036082abb271329", 10810464),
	GAME_ENTRY("mikasdream2", "MSD.exe", "02094e217c23e1d40a84891ee95010cb", 9951843),
	GAME_ENTRY("mikelechey", "Mike Lechey.exe", "06a03fe35791b0578068ab1873455463", 2349277),
	GAME_ENTRY("mikesroom", "Mikes_late.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5001254),
	GAME_ENTRY("milkshake", "Milkshake.exe", "615e806856b7730afadf1fea9a756b70", 1656268),
	GAME_ENTRY("mindboggler", "Rebel.exe", "847ca9d174cd091b7a1b82f032bdd052", 36979705),
	GAME_ENTRY("mindseye", "MindsEye.exe", "8a84eb07f484540ecc59ea80bf21dc9e", 30024175),
	GAME_ENTRY("minigame4", "Mini Game 4.exe", "465f972675db2da6040518221af5b0ba", 4954264),
	GAME_ENTRY("missingsincemidnight", "msm.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7989479),
	GAME_ENTRY_LANG("mistdelaescueladearte", "EA.exe", "465f972675db2da6040518221af5b0ba", 6732362, Common::ES_ESP),
	GAME_ENTRY("mmm1", "MMM.exe", "465f972675db2da6040518221af5b0ba", 5476481),
	GAME_ENTRY("mmm1", "MMM.exe", "137a2bc940f033beab257b2fa88526ba", 10917227),
	GAME_ENTRY("mmm2", "MMM02.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5830457),
	GAME_ENTRY("mmm3", "mmme2.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5795895),
	GAME_ENTRY("mmm4", "mmm.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8368739),
	GAME_ENTRY("mmm5", "MMM05.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6181463),
	GAME_ENTRY("mmm6", "jeff.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5859742),
	GAME_ENTRY("mmm7", "MMM7.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5936294),
	GAME_ENTRY("mmm8", "MMM - E8.exe", "45ab4f29031b50c8d01d10a269f77ff5", 5095385),
	GAME_ENTRY("mmm9", "mmm_radioactive.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7665414),
	GAME_ENTRY("mmm10", "MMM-TOTWE.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8455565),
	GAME_ENTRY("mmm10", "MMM-TOTWE.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8455743),
	GAME_ENTRY("mmm11", "MMMania 2.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7872940),
	GAME_ENTRY("mmm11", "MMMania.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6123337),
	GAME_ENTRY("mmm12", "Giga.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 4141502),
	GAME_ENTRY("mmm13", "traum.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6703140),
	GAME_ENTRY("mmm14", "msytr.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5836799),
	GAME_ENTRY("mmm14", "msytr.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5863583),
	GAME_ENTRY("mmm15", "MMM15.exe", "06a03fe35791b0578068ab1873455463", 8503015),
	GAME_ENTRY("mmm15", "MMM15.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8957215),
	GAME_ENTRY("mmm16", "Meteor Family.exe", "06a03fe35791b0578068ab1873455463", 5759077),
	GAME_ENTRY("mmm16", "Meteor Family.exe", "06a03fe35791b0578068ab1873455463", 5777213),
	GAME_ENTRY("mmm16", "mmmgui.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5019001),
	GAME_ENTRY("mmm17", "mmmgui.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6503602),
	GAME_ENTRY("mmm18", "Shit Happens!.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6300460),
	GAME_ENTRY("mmm18", "Shit Happens!.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6300947),
	GAME_ENTRY("mmm21", "mmmgui1.exe", "465f972675db2da6040518221af5b0ba", 8757734),
	GAME_ENTRY("mmm22", "mmm.exe", "465f972675db2da6040518221af5b0ba", 6909531),
	GAME_ENTRY("mmm23", "MANIAC.exe", "465f972675db2da6040518221af5b0ba", 5904865),
	GAME_ENTRY("mmm24", "mmmgui.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6112992),
	GAME_ENTRY("mmm26", "TryDott.exe", "28f82e420b82d07651b68114f90223c8", 4683840),
	GAME_ENTRY("mmm27", "Hamster.exe", "465f972675db2da6040518221af5b0ba", 7497001),
	GAME_ENTRY("mmm28", "Time Machine 2.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7314610),
	GAME_ENTRY("mmm29", "mmmgui.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8033934),
	GAME_ENTRY("mmm30", "memorie.exe", "0710e2ec71042617f565c01824f0cf3c", 4300662),
	GAME_ENTRY("mmm31", "MMM31.exe", "0710e2ec71042617f565c01824f0cf3c", 6777832),
	GAME_ENTRY("mmm31", "MMM31.exe", "ca70858da2a347bd8ec2dedcbb4113b4", 7382014),
	GAME_ENTRY("mmm32", "save_mmm.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6291592),
	GAME_ENTRY("mmm33", "Smiley.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7567946),
	GAME_ENTRY("mmm33", "Smiley.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 7568039),
	GAME_ENTRY("mmm34", "Helden.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 21647765),
	GAME_ENTRY("mmm34", "Helden.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 21648581),
	GAME_ENTRY("mmm35", "Weggebeamt.exe", "0710e2ec71042617f565c01824f0cf3c", 4255405),
	GAME_ENTRY("mmm36", "Der Liebesbrief.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 9499807),
	GAME_ENTRY("mmm37", "MMM37.exe", "0710e2ec71042617f565c01824f0cf3c", 10092409),
	GAME_ENTRY("mmm37", "SandyEppi.exe", "ca70858da2a347bd8ec2dedcbb4113b4", 10311675),
	GAME_ENTRY("mmm38", "mmm38.exe", "81083747db230fe1e7bbe64857467b56", 8701976),
	GAME_ENTRY("mmm38", "Rescue Mission.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6912146),
	GAME_ENTRY("mmm39", "erinner.exe", "465f972675db2da6040518221af5b0ba", 10525885),
	GAME_ENTRY("mmm39", "Erinnerungen.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6673993),
	GAME_ENTRY("mmm40", "MMM40.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 10990625),
	GAME_ENTRY("mmm40", "Verflixte Türen.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 9483433),
	GAME_ENTRY("mmm41", "mmm41.exe", "6d5a5284ed0403e75d64f42f415242a5", 8634455),
	GAME_ENTRY("mmm42", "psychobernie.exe", "0710e2ec71042617f565c01824f0cf3c", 6696188),
	GAME_ENTRY("mmm43", "Edna.exe", "0710e2ec71042617f565c01824f0cf3c", 5149386),
	GAME_ENTRY("mmm44", "Razor.exe", "0710e2ec71042617f565c01824f0cf3c", 4820839),
	GAME_ENTRY("mmm45", "MMM45.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 13327742),
	GAME_ENTRY("mmm46", "Lost.exe", "0710e2ec71042617f565c01824f0cf3c", 5143252),
	GAME_ENTRY("mmm47", "Ostern.exe", "5c183013f9d8ed144de05f239633a604", 7416584),
	GAME_ENTRY("mmm48", "mmm_wendy_271.exe", "f120690b506dd63cd7d1112ea6af2f77", 8870057),
	GAME_ENTRY("mmm49", "Clouso.exe", "0710e2ec71042617f565c01824f0cf3c", 12159468),
	GAME_ENTRY("mmm50", "mmm50.exe", "5c183013f9d8ed144de05f239633a604", 5258429),
	GAME_ENTRY("mmm51", "Ortmaschine II.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 9261025),
	GAME_ENTRY("mmm52", "52 v2.exe", "4d7d2addcde045dae6e0363a43f9acad", 15632826),
	GAME_ENTRY("mmm53", "MMM-dksz.exe", "c1df737ef943e6e3cc09d36fcd4b1ed0", 8689677),
	GAME_ENTRY("mmm53", "MMM-dksz.exe", "c1df737ef943e6e3cc09d36fcd4b1ed0", 8708254),
	GAME_ENTRY("mmm54", "CSI_RONVILLE.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 19836078),
	GAME_ENTRY("mmm55", "ChapterofDream.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 5539795),
	GAME_ENTRY("mmm56", "Grotten-Urlaub.exe", "615e806856b7730afadf1fea9a756b70", 6641264),
	GAME_ENTRY("mmm57", "Episode 57-v2.exe", "90413e9ae57e222f8913b09d2bc847bc", 22458183),
	GAME_ENTRY("mmm58", "COURT.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 8245554),
	GAME_ENTRY("mmm59", "KevinGUI.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 5299420),
	GAME_ENTRY("mmm60", "mmm60.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6431816),
	GAME_ENTRY("mmm61", "bernardsRoom.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 8767774),
	GAME_ENTRY("mmm61", "bernardsRoom.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 8855002),
	GAME_ENTRY("mmm63", "Bernard_272.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 5315794),
	GAME_ENTRY("mmm64", "Baranoia.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6053354),
	GAME_ENTRY("mmm65", "Save Smiley!.exe", "f120690b506dd63cd7d1112ea6af2f77", 5306178),
	GAME_ENTRY("mmm66", "Hoagie.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6131305),
	GAME_ENTRY("mmm66akt3", "Hoagie.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6287962),
	GAME_ENTRY("mmm67", "Epi67.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 40585222),
	GAME_ENTRY("mmm68", "MaP.exe", "615e806856b7730afadf1fea9a756b70", 8260817),
	GAME_ENTRY("mmm69", "Samstag.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 5425439),
	GAME_ENTRY("mmm70", "MMB.exe", "7b8b28390b898ad22427bd92b2c38959", 38612057),
	GAME_ENTRY("mmm71", "Dreiauge.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 28016268),
	GAME_ENTRY("mmm72", "mindbending.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 7306081),
	GAME_ENTRY("mmm73", "Eabc.exe", "4d7d2addcde045dae6e0363a43f9acad", 5708460),
	GAME_ENTRY("mmm74", "tedventure.exe", "90413e9ae57e222f8913b09d2bc847bc", 7768144),
	GAME_ENTRY("mmm75", "Necronomicon.exe", "0710e2ec71042617f565c01824f0cf3c", 9645824),
	GAME_ENTRY("mmm76", "bernoullishow.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 5380631),
	GAME_ENTRY("mmm77", "MMM77.exe", "06a03fe35791b0578068ab1873455463", 13099621),
	GAME_ENTRY("mmm78", "Dumm geholfen.exe", "18b284c22010850f79bc5c20054a70c4", 11787742),
	GAME_ENTRY("mmm79", "Wunsch-O-Mat.exe", "74aad8dfd71ed2ae9574a60be7610c43", 5071097),
	GAME_ENTRY("mmm80", "Spiel des Lebens.exe", "bb59de174d70797d774dec76a171352d", 4989738),
	GAME_ENTRY("mmm81", "Bernard bricht aus!.exe", "bb59de174d70797d774dec76a171352d", 4461097),
	GAME_ENTRY("mmm82", "Freundin mit Hindernissen.exe", "bb59de174d70797d774dec76a171352d", 4470551),
	GAME_ENTRY("mmm83", "Chasing Hoagie.exe", "c8daf8ef2bc83ea8b0f310cfce209401", 6083727),
	GAME_ENTRY("mmm84", "Surf'n'Ronville.exe", "736c02211122a28ec41646a29c22688f", 11288591),
	GAME_ENTRY("mmm85", "Compiled.exe", "c8daf8ef2bc83ea8b0f310cfce209401", 5003407),
	GAME_ENTRY("mmm86", "Bernard bekommt Besuch.exe", "430eaebb21d406061d67a9972ad33947", 18382681),
	GAME_ENTRY("mmm87", "Hotel Ronville.exe", "0ab0633f966ed01403362e6dfb5ca7d4", 12678222),
	GAME_ENTRY("mmm88", "Der alltaegliche Wahnsinn.exe", "74dc062c5f68f3d70da911f2db5737b6", 4412559),
	GAME_ENTRY("mmm89", "Weltdateien.exe", "e2922ce173aaab9881647510498bdaf5", 26312833),
	GAME_ENTRY("mmm90", "mmm90.exe", "f1d98b6c9f4fb300181a927948ec8ef5", 8606394),
	GAME_ENTRY("mmm91", "MMM-FidB.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6345594),
	GAME_ENTRY("mmm93", "Moonshine.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 9184631),
	GAME_ENTRY("mmm94", "Mississippi.exe", "311cf286b596ed7c68d5505424dea1bc", 19670283),
	GAME_ENTRY("mmm95", "BritneysEscape.exe", "37a096932a37607b8115f57d269229b9", 16216498),
	GAME_ENTRY("mmm96", "Dave.exe", "430eaebb21d406061d67a9972ad33947", 12980000),
	GAME_ENTRY("mmm97", "X-mas Mansion.exe", "b643c4e0619a8a271383c02b3ac9196f", 12095953),
	GAME_ENTRY("mmm98", "mmm98.exe", "fb1e40d2828ca16537365b91a90b5bee", 14466864),
	GAME_ENTRY("mmm99", "die_premiere.exe", "3e9c6691d4b9fd70aa47c5bfd68c5c3a", 8312345),
	GAME_ENTRY("mmm100", "money.exe", "91b1d125f9c818b8d2f376d24774377e", 52085746),
	GAME_ENTRY("mmmhw1", "Halloween.exe", "28f82e420b82d07651b68114f90223c8", 7354818),
	GAME_ENTRY("mmmhw2", "Escape.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 10251940),
	GAME_ENTRY("mmmhw3", "MMM - DotD.exe", "0710e2ec71042617f565c01824f0cf3c", 4843398),
	GAME_ENTRY("mmmhw3", "MMM - DotD.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 5664499),
	GAME_ENTRY("mmmhw4", "MMM-Horror.exe", "0710e2ec71042617f565c01824f0cf3c", 4300488),
	GAME_ENTRY("mmmhw5", "Redrum.exe", "0710e2ec71042617f565c01824f0cf3c", 4410844),
	GAME_ENTRY("mmmhw6", "TCoMM.exe", "f120690b506dd63cd7d1112ea6af2f77", 5073963),
	GAME_ENTRY("mmmhw7", "Utschi-2006.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 7399530),
	GAME_ENTRY("mmmhw8", "racoon.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 11664995),
	GAME_ENTRY("mmmhw9", "TMMCMFH.exe", "c8daf8ef2bc83ea8b0f310cfce209401", 31905464),
	GAME_ENTRY("mmmhw10", "Bernard_272.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 9775462),
	GAME_ENTRY("mmmhw11", "Bad and Mad.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6895237),
	GAME_ENTRY("moncul", "moncul.exe", "0710e2ec71042617f565c01824f0cf3c", 1493822),
	GAME_ENTRY("monkeyklon", "monkeyklon.exe", "0710e2ec71042617f565c01824f0cf3c", 5196763),
	GAME_ENTRY("monkeystothemoon", "Monkeys to the Moon.exe", "77d91b65ff03c1f3a8381e39c7f693cb", 8720439),
	GAME_ENTRY("monkeywrench", "monkeywrench.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 27454116),
	GAME_ENTRY("monsterfromthehountedhill", "Monster.exe", "465f972675db2da6040518221af5b0ba", 6197451),
	GAME_ENTRY("montyonthenorm", "monty.exe", "f8e8f781a4a95c2bfea5f54b085df550", 3270202),  // updated  version
	GAME_ENTRY("moonlightmoggy", "Moggy.exe", "0a6704159f6f716ac80da91c430430ce", 13336128),
	GAME_ENTRY("moose", "MOOSE.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 4732219),
	GAME_ENTRY("moose2", "MOOSE2.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 1251361),
	GAME_ENTRY("mordimlaufrad", "MordImLaufrad.exe", "18b284c22010850f79bc5c20054a70c4", 4396809),
	GAME_ENTRY("mordy2", "Mordy2.exe", "0710e2ec71042617f565c01824f0cf3c", 5186329),
	GAME_ENTRY("mothersday", "mothersday.exe", "0b7529a76f38283d6e850b8d56526fc1", 1816363),
	GAME_ENTRY("motlpaa", "MOTLPAA.exe", "0710e2ec71042617f565c01824f0cf3c", 1575258),
	GAME_ENTRY_STEAM("mountainsofmadness", "MountainsOfMadness.exe", "95822b7957b8f239d3216b9209cfb1f5", 337894184),
	GAME_ENTRY("mourirenmer", "Mourir.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 2519706),
	GAME_ENTRY("mrdangerscontest", "Danger.exe", "06a03fe35791b0578068ab1873455463", 7096987),
	GAME_ENTRY("mudlarks", "Mudlarks.exe", "dfa63386f3e7dd011447982affff1154", 311640039),
	GAME_ENTRY("murderdog4", "MurderDogIV.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 9930349),
	GAME_ENTRY("murderinthemansion", "MitM 1.2.exe", "27df05bd72589a589c054d11d6d03c0f", 9758713),
	GAME_ENTRY("murderofadrianelkwood", "elkwood.exe", "06a03fe35791b0578068ab1873455463", 3685153),
	GAME_ENTRY("murphyssalvagejustmyluck", "space.exe", "f8029b1e9ff5ac01ae23896af44e885a", 51351465),
	GAME_ENTRY("murranchronicles1", "Jersey Devil.exe", "06a03fe35791b0578068ab1873455463", 20555872),
	GAME_ENTRY("murranchronicles2", "Talons.exe", "06a03fe35791b0578068ab1873455463", 17613066),
	GAME_ENTRY("murranchronicles3", "LifeDrinker.exe", "90413e9ae57e222f8913b09d2bc847bc", 13274387),
	GAME_ENTRY("musicmixer", "mixertest.exe", "0b7529a76f38283d6e850b8d56526fc1", 798369),
	GAME_ENTRY("myburdentokeep", "MBTK.exe", "52b5831250acb676c3c76b8e47af4b2c", 35230042),
	GAME_ENTRY("mysterioushouse", "mh.exe", "495d45fb8adfd49690ae3b97921feec6", 42400316),
	GAME_ENTRY("mysticseer", "NickOfTime.exe", "f120690b506dd63cd7d1112ea6af2f77", 4460113),
	GAME_ENTRY("mythicalgambitflawlessfatality", "MGFF.exe", "4887d3dca056a0772741b42f66e018fb", 59711760),
	GAME_ENTRY("mzi", "MissionZukunftia.exe", "0564de07d3fd5c16e6947a647061913c", 4305024),
	GAME_ENTRY("mzi2", "MissionZukunftia2.exe", "839a7cbaa6c287ca35cf46a2505b48eb", 6672476),
	GAME_ENTRY("nanobots", "Nanobots.exe", "95dcf736be87cf7d40bf64d5b078c4b7", 41977727),
	GAME_ENTRY("necroquest", "necroquest01.exe", "2d111a69de0723f337bad661cb006239", 9545924),
	GAME_ENTRY("necroquest", "necroquest01.exe", "6d4adcef07a14b53369d23edf5117252", 12389204),
	GAME_ENTRY("nedysadventure", "Nedy.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 6463558),
	GAME_ENTRY("nekusnewtrip", "nnt.exe", "c0c1865c3c8369e034095a725ca1ddbf", 35012412),
	GAME_ENTRY("nekusnewtrip", "square enix.exe", "a524cbb1c51589903c4043b98917f1d9", 10630694),
	GAME_ENTRY("nellycootalot", "Nelly Cootalot.exe", "18b284c22010850f79bc5c20054a70c4", 108256323),
	GAME_ENTRY("nellycootalot", "Nelly.exe", "bdaf20d9779c01986d6d8b7e1d6118ee", 198349190),
	GAME_ENTRY_STEAM("nellycootalot-hd", "Nelly.exe", "521aecdb5343c8d8f1c1000c4c2fa468", 11069524),
	GAME_ENTRY_STEAM("nellycootalot-hd", "Nelly.exe", "28f22ae60e2f3524665c1d5be60a0bf3", 11069220),
	GAME_ENTRY("neosaires2070", "Neos Aires 2070 - Sunday Comes First.exe", "76703ac67835bdbfde5b378a147c8ba2", 84186100), // 1.0
	GAME_ENTRY("neosaires2070", "Neos Aires 2070.exe", "78dd4ca028ee0156b6a093d6d780aa65", 84126492), // 1.1
	GAME_ENTRY("nesquest", "NES Quest.exe", "8b72036706da98095057df615d07460b", 20881972),
	GAME_ENTRY("news", "WI-AA.exe", "06a03fe35791b0578068ab1873455463", 29631312),
	GAME_ENTRY("nickitandrun", "NIAREnglish.exe", "b25674056fe8cc0b7bf0a4409c5c5bfc", 14180082),
	GAME_ENTRY("niemandsland", "Das Niemandsland.exe", "430eaebb21d406061d67a9972ad33947", 14852973),
	GAME_ENTRY("nightandday", "Night and Day.exe", "430eaebb21d406061d67a9972ad33947", 17187367),  //v1.0
	GAME_ENTRY("nightandday", "Night and Day.exe", "430eaebb21d406061d67a9972ad33947", 17206287),  //v1.1
	GAME_ENTRY("nightandday", "Night and Day.exe", "430eaebb21d406061d67a9972ad33947", 17209105),  //v1.2
	GAME_ENTRY("nightoftheravingfeminist", "Prueba1.exe", "b25674056fe8cc0b7bf0a4409c5c5bfc", 7015243),
	GAME_ENTRY("nightwork", "Nightwork.exe", "f10516e88ec858700804ee69d041aead", 23059420),
	GAME_ENTRY("noactionjackson", "current.exe", "3128b9f90e2f954ba704414ae854d10b", 28343366),
	GAME_ENTRY("noahsquest", "Noah's Quest.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 107188362),
	GAME_ENTRY("nobodycares", "Nobody Cares.exe", "618d7dce9631229b4579340b964c6810", 20897642),
	GAME_ENTRY("noiamspartacus", "spartacus.exe", "28f82e420b82d07651b68114f90223c8", 1133879),
	GAME_ENTRY("noisymountain", "NoisyMountainE.exe", "465f972675db2da6040518221af5b0ba", 8031142),
	GAME_ENTRY("nomonkeysbanana", "NMB.exe", "36f44e064eab15e502caeb60fd09f52d", 2750366),
	GAME_ENTRY("norbisquest", "Norbi's quest.exe", "3128b9f90e2f954ba704414ae854d10b", 4912333),
	GAME_ENTRY("norbisquest15", "Norbi 1,5.exe", "f120690b506dd63cd7d1112ea6af2f77", 5455598),
	GAME_ENTRY("norbisquest2", "Norbi 2.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 14114728),
	GAME_ENTRY("norbiwinterspecial", "NWS.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 10149860),
	GAME_ENTRY("normancooks", "NORMAN.exe", "4d17844029d8910fbaae1bdc99e250f2", 9397734),
	GAME_ENTRY("norserunereader", "NorseRuneReader.exe", "f120690b506dd63cd7d1112ea6af2f77", 2111273),
	GAME_ENTRY("notetoself", "elandra_nts.exe", "7e706ca442dd1277f09480b9ba08a1ec", 7176224),
	GAME_ENTRY("noughtscrosses", "Noughts.exe", "615e73fc1874e92d60a1996c2330ea36", 2159904),
	GAME_ENTRY("oceanspiritdennisscourgeoftheunderworld", "Oceanspirit Dennis.exe", "18456f28d9bf843b087e80072c85beca", 2419770),
	GAME_ENTRY("odottamaton", "Odottamaton.exe", "9d9e5ea323793fc526b1533d78c4f9c6", 23822268),
	GAME_ENTRY("offtheclock", "Off The Clock.ags", "8918895c5c695bae90af13ea4f1a9807", 495345700), // Linux
	GAME_ENTRY("offtheclock", "Off The Clock.exe", "b2eb107c1f9784b7fc4f58c2a7678dea", 498392456), // Windows
	GAME_ENTRY("offtheclock", "ac2game.dat", "b2eb107c1f9784b7fc4f58c2a7678dea", 498257938), // Mac
	GAME_ENTRY("ohdulieber", "Augustin.exe", "b142b43c146c25443a1d155d441a6a81", 13477896),
	GAME_ENTRY("omnipotenttarot", "OmnipotentTarot.exe", "f120690b506dd63cd7d1112ea6af2f77", 7166774),
	GAME_ENTRY("onceuponacrime", "OUAC.exe", "6ee842f73649ced615c44d4eb303687c", 6580658),
	GAME_ENTRY("onceuponatime", "Oncetime.exe", "18b284c22010850f79bc5c20054a70c4", 11633390),
	GAME_ENTRY("one", "one.exe", "0710e2ec71042617f565c01824f0cf3c", 53482630),
	GAME_ENTRY("onemorefathom", "AGS_OMF.exe", "9b47600b5662d7f8b6a4c6ed6854a12c", 24492467),
	GAME_ENTRY("oneofakindadivinecomedyofmistakes", "OneOfAKind.exe", "a524cbb1c51589903c4043b98917f1d9", 4031186),
	GAME_ENTRY("onespytoomany", "One spy too many.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 70521403),
	GAME_ENTRY("oneweekoneroom", "1 week 1 room.exe", "06a03fe35791b0578068ab1873455463", 4275934),
	GAME_ENTRY("onleavingthebuilding", "On Leaving The Building.exe", "fd68fced8b89792d2e90be87b33d4b19", 64776995),
	GAME_ENTRY("onlythegooddieyoungenglishversion", "OtGDY_En.exe", "87ccd318a469128530699388f916b86f", 153980124),
	GAME_ENTRY("openquest", "OpenQuest.exe", "90413e9ae57e222f8913b09d2bc847bc", 3407165),
	GAME_ENTRY("operationnovi", "Operation Novi.exe", "465f972675db2da6040518221af5b0ba", 24583968),
	GAME_ENTRY("operationsavebluecup", "OSBC.exe", "f120690b506dd63cd7d1112ea6af2f77", 3040865),
	GAME_ENTRY("orangeman", "Orange man.exe", "c38d6846c402bfcdedcf5c34cd8bc3ee", 1960932),
	GAME_ENTRY("osdarayofhope", "ray_of_hope.exe", "25976a689b0f4d73eac69b1728377ecb", 6595789),
	GAME_ENTRY("osdocd", "OSD-OCD.exe", "9dbf699a0e41550bb080813a233e73a8", 47758168),
	GAME_ENTRY("osdsearch", "OSDSearch.exe", "c2e87de9507f0443368b300e8c882f30", 37505243),
	GAME_ENTRY("osdthelostworldep2", "OSD.TLW2.exe", "a80ae4d0aea21508f1df9d18f2839bcb", 22076715),
	GAME_ENTRY("osdvsron", "RON vs OSD.exe", "7e7d6148fa1efad740c664c4f68f4246", 15930882),
	GAME_ENTRY_LANG("osher", "Osher.exe", "18b284c22010850f79bc5c20054a70c4", 389177994, Common::HE_ISR),
	GAME_ENTRY("otakurivals", "Kintaro.exe", "465f972675db2da6040518221af5b0ba", 4045893),
	GAME_ENTRY("otherworlds", "Other Worlds.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 10669659),
	GAME_ENTRY("otisbuildsafire", "obaf.exe", "c8d330b58da0a00a136c52ed3a20ae23", 4260705),
	GAME_ENTRY("ouja", "Ouja.exe", "4d7d2addcde045dae6e0363a43f9acad", 6254682),
	GAME_ENTRY("ourobouros", "I am Ourobouros.exe", "615e73fc1874e92d60a1996c2330ea36", 5841551),
	GAME_ENTRY_LANG("ourobouros", "I am Ourobouros - French.exe", "615e73fc1874e92d60a1996c2330ea36", 5843873, Common::FR_FRA),  // French
	GAME_ENTRY("outbreakbyabhijitkamat", "outbreak.exe", "0500aacb6c176d47ac0f8158f055db83", 3271348),
	GAME_ENTRY("outofgas", "OutOfGas.exe", "6b4ceb9e327ac99479c08d825461f4cb", 18187986),
	GAME_ENTRY("outofgas", "OutOfGas.exe", "f0e74b3673867316e1cb3120c4289c66", 18200877),
	GAME_ENTRY("overtheedge", "jdags.exe", "05f7ff300b322bc431e7cda6a07b5976", 235453751),
	GAME_ENTRY("owlsquest", "King.exe", "a6906aec8617b81af44cf9420731fc34", 3506408),
	GAME_ENTRY("palettequest2", "PaletteQuest2.exe", "2b7ae26333ba15529a8bbbdb49605133", 771805),
	GAME_ENTRY("pandainspace", "pandasp.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 14340176),
	GAME_ENTRY("pandor", "Pandor.exe", "a6dc66da890952431371b62659e58a62", 18995824),
	GAME_ENTRY("paperplanes", "Paper Planes.exe", "c3169a1c681007b95f517f765a139b89", 83144027),
	GAME_ENTRY("paradiselost", "larywilc.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 9061068),
	GAME_ENTRY("parameciumcomplex", "paramaecium.exe", "0500aacb6c176d47ac0f8158f055db83", 2805720),
	GAME_ENTRY("paranormalinvestigation", "ronpi.exe", "f8e8f781a4a95c2bfea5f54b085df550", 3830361),  // updated version
	GAME_ENTRY("paranormalwarriorwithin", "BJWW.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3538617),
	GAME_ENTRY("party", "Party.exe", "f120690b506dd63cd7d1112ea6af2f77", 1888987),
	GAME_ENTRY("patchwork", "Patchwork.exe", "bbadca125279cb808b4ed0ff4b31448d", 110767860),
	GAME_ENTRY("paulaimwunderland", "PaulaWunderland.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 2249299),
	GAME_ENTRY("paulmooseinspaceworld", "Paul Moose In Space World.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 15971406),
	GAME_ENTRY("paulquest", "calle.exe", "06a03fe35791b0578068ab1873455463", 3055837),
	GAME_ENTRY("paulromano", "Paul Romano.exe", "ee9deee0da02406cf9b7ca076321a106", 844755077),
	GAME_ENTRY("ponderabilia", "Ponderabilia.exe", "615e73fc1874e92d60a1996c2330ea36", 21206289),
	GAME_ENTRY("pennistheultimateinpong", "Pennis.exe", "28f82e420b82d07651b68114f90223c8", 939611),
	GAME_ENTRY("perfidiouspetrolstation", "NancyATPPS.exe", "be858e83311d4f1b49e05b933b92f0a9", 28085287),
	GAME_ENTRY("perilsofpoom", "Poom.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 10455126),
	GAME_ENTRY("pesterquest", "PQ.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2381566),
	GAME_ENTRY("petalrose", "petalrose.exe", "949f7440e3692b7366c2029979dee9a0", 748315),
	GAME_ENTRY("petshopincident", "petshop.exe", "64fcaf7da0b257ea831f89c54be0ad72", 3660347),
	GAME_ENTRY("pharmacistjones", "Pharmacist Jones.exe", "00bb363ccb0acfe57893dd3ba6f1719c", 8285817),
	GAME_ENTRY("pickpocketrpg", "Pickpocket RPG.exe", "82da2565c456dcfb265ded6fe3189c0b", 44540638),
	GAME_ENTRY("pilotlight", "Pilot.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 9707781),
	GAME_ENTRY("pimpinonparakuss", "Squest2.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 3717277),
	GAME_ENTRY("piratefry2", "FryTworedo.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 8492745),
	GAME_ENTRY("piratefry3", "tryout.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 2318881),
	GAME_ENTRY("pirates", "Pirates!.exe", "0564de07d3fd5c16e6947a647061913c", 81574110),
	GAME_ENTRY("piratess", "Piratess.exe", "f120690b506dd63cd7d1112ea6af2f77", 2043871),
	GAME_ENTRY("piss", "PISS.exe", "e2ad4b60bafc5da468607e026d831230", 102387880),
	GAME_ENTRY("pixelhunt", "pixelhunt.exe", "057d1aa29f6fadd83209268efcfb35a3", 3321338),
	GAME_ENTRY("pixia", "Pixia.exe", "0710e2ec71042617f565c01824f0cf3c", 1286189),
	GAME_ENTRY("pixxxelhuntertheepic", "pixelhunter.exe", "0710e2ec71042617f565c01824f0cf3c", 1621107),
	GAME_ENTRY("pizzanostra", "PizzaNostra.exe", "f049336af42d365ab16e68d4be5cbe9a", 56205310),
	GAME_ENTRY("plan10frommypants", "plan10.exe", "06a03fe35791b0578068ab1873455463", 8514311),
	GAME_ENTRY("planetxmas", "PlanetX.exe", "64fcaf7da0b257ea831f89c54be0ad72", 4430665),
	GAME_ENTRY("platformerius", "platformerius.exe", "a3ad5fa6463c0116a2ac8986841860e0", 1512479),
	GAME_ENTRY("platformhorde", "Platform Horde.exe", "49157a0ea75b960eded4d0811a71d3e9", 14991450),
	GAME_ENTRY("pledgequest1", "svpromo.exe", "82da2565c456dcfb265ded6fe3189c0b", 3239155),
	GAME_ENTRY("pledgequest2", "pledgequest2.exe", "615e73fc1874e92d60a1996c2330ea36", 27872703),
	GAME_ENTRY("pleurghburgdarkages", "Pleurgh.exe", "9cf51833e787cc919837d9a8bd8fc14c", 11555983),
	GAME_ENTRY("plumberboy", "Plumberboy.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 4169240),
	GAME_ENTRY("pm-cute", "pm-cute.exe", "28f82e420b82d07651b68114f90223c8", 2728354),
	GAME_ENTRY("pmuvchvt", "PMUVCHVT.exe", "06a03fe35791b0578068ab1873455463", 5127419),
	GAME_ENTRY("pmxi", "PMXI.exe", "609aa4339aea63a0ebc1fd6a659e6d4f", 3164504),
	GAME_ENTRY("pocketfluffyay", "Pketfluf.exe", "0b7529a76f38283d6e850b8d56526fc1", 10858438),
	GAME_ENTRY("politicallyyours", "Politically Yours.exe", "031bce0ec1a563faffc19a62ea17e35f", 4640266),
	GAME_ENTRY("pong", "Pong.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 611249),
	GAME_ENTRY("postmansquest", "PQ.exe", "345685aaec400c69a1e6d5e18a63850c", 6896450),
	GAME_ENTRY("powernap", "powernap.exe", "615e73fc1874e92d60a1996c2330ea36", 13308487),
	GAME_ENTRY("powerunlimited", "PU Bordspel.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1842762),
	GAME_ENTRY("pqtadventure", "playpqt.exe", "0b7529a76f38283d6e850b8d56526fc1", 19914806),
	GAME_ENTRY("practicescript", "Practice.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 764358),
	GAME_ENTRY("predatorspreyforplants", "Predators Prey For Plants.exe", "d44551532361c1eeec9b167de35515d1", 2318985),
	GAME_ENTRY("preludetoadventure", "Prelude.exe", "7db052bc30700d1f30f5330f5814f519", 7072523),
	GAME_ENTRY("preludetoadventure", "Prelude.exe", "7db052bc30700d1f30f5330f5814f519", 10406930),
	GAME_ENTRY("preludetoadventure", "Prelude.exe", "7db052bc30700d1f30f5330f5814f519", 12923511),
	GAME_ENTRY("princessandallthekingdom", "Copy of PHK.exe", "465f972675db2da6040518221af5b0ba", 24658916),
	GAME_ENTRY("princessmarianix", "phantom.exe", "2a486107b3f04f789c122a1d0e1f3d5f", 2067548),
	GAME_ENTRY("princessmariansnowfight", "pmsnow.exe", "f120690b506dd63cd7d1112ea6af2f77", 1250562),
	GAME_ENTRY("princessmarianspigeonpinger", "PMPP.exe", "e68aaf0cea1e5701a7bb50a757bb5f4b", 2929950),
	GAME_ENTRY("princessmarianxmagichat", "pmx.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 3243258),
	GAME_ENTRY("principlesofevil", "P of E.exe", "f120690b506dd63cd7d1112ea6af2f77", 43410398),
	GAME_ENTRY("principlesofevil2", "PoE II.exe", "f120690b506dd63cd7d1112ea6af2f77", 87236507),
	GAME_ENTRY("prodigal", "Prodigal.exe", "682a8c57c7678c99c1564fd43680f03e", 7486947),
	GAME_ENTRY("profneely", "ProfN.exe", "26cfa7bd1be5485e1f0385101b31e43b", 31956037),
	GAME_ENTRY("profneely", "ProfN.exe", "26cfa7bd1be5485e1f0385101b31e43b", 3917542), // v1.1
	GAME_ENTRY("projectevilspy2", "Project Evilspy II.exe", "0b7529a76f38283d6e850b8d56526fc1", 1583899),
	GAME_ENTRY("proofoffiction", "PoF.exe", "9cf51833e787cc919837d9a8bd8fc14c", 2723885),
	GAME_ENTRY("prototypical", "Proto.exe", "06a03fe35791b0578068ab1873455463", 48507319),
	GAME_ENTRY("proxecto", "proxec.exe", "465f972675db2da6040518221af5b0ba", 2636209),
	GAME_ENTRY("psychopomp", "psychopomp.exe", "b142b43c146c25443a1d155d441a6a81", 23721476),
	GAME_ENTRY("pubmasterquest2", "shogin crystal.exe", "90baefd2f369cebe25f3aa9ad90332d2", 35191110),
	GAME_ENTRY("puddypenguin", "Penguin.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 2328158),
	GAME_ENTRY("purgatorio", "Purgatorio 0.1.exe", "18b284c22010850f79bc5c20054a70c4", 194293367),
	GAME_ENTRY("purityofthesurf", "Surf.exe", "71ca0d6c1c699595f28a2125948d4a84", 11315703),
	GAME_ENTRY("pussiehunt", "kittie.exe", "03b4d6ed1b2f07082ff25367b6631da0", 4422335),
	GAME_ENTRY("puzzlepumice", "MAGS_Jun_2012.exe", "82da2565c456dcfb265ded6fe3189c0b", 13358126),
	GAME_ENTRY("pxenophobe", "ProjXeno.exe", "465f972675db2da6040518221af5b0ba", 79053486),
	GAME_ENTRY("questfighter", "Quest Fighter.exe", "21fd0f65dfa48de2b39cb8ec23b30889", 2914128),
	GAME_ENTRY("questfighter2", "Quest Fighter 2.exe", "4d7d2addcde045dae6e0363a43f9acad", 5219511),
	GAME_ENTRY("questforcinema", "Questforcinema.exe", "465f972675db2da6040518221af5b0ba", 2670632),
	GAME_ENTRY("questforjesus", "QuestForJesus.exe", "495d45fb8adfd49690ae3b97921feec6", 3973088),
	GAME_ENTRY("questforpalette", "Palette Quest.exe", "0710e2ec71042617f565c01824f0cf3c", 754395),
	GAME_ENTRY("questforthebluecup", "Quest for the Cup.exe", "9cb3c8dc7a8ab9c44815955696be2677", 8760015),
	GAME_ENTRY("questforyeti", "Quest For Yeti.exe", "90413e9ae57e222f8913b09d2bc847bc", 2635580),
	GAME_ENTRY("questforyrolg", "Quest for Yrolg.exe", "c4f5b7b29be90ba0f8128298afb917de", 9388101),
	GAME_ENTRY("questforyrolg", "quest for yrolg.exe", "89df481678b2ddc40ecc9f83caa76b89", 9709051), // v1.8
	GAME_ENTRY_STEAM("questforyrolg", "quest for yrolg.ags", "51527ed37f001db741e68b767259c81e", 8214789),
	GAME_ENTRY("quimbyquestanewdope", "QQuest.exe", "615e806856b7730afadf1fea9a756b70", 8801878),
	GAME_ENTRY_PLATFORM("rabbiteyemotel", "asylumjam2015.exe", "2ca80bd50763378b72cd1e1cf25afac3", 38579543, "GameJam Build"),
	GAME_ENTRY("rabbiteyemotel", "asylumjam2015.exe", "2ca80bd50763378b72cd1e1cf25afac3", 40528966),  // v0.4.2
	GAME_ENTRY("race", "R.ACE.exe", "06a03fe35791b0578068ab1873455463", 3842314),
	GAME_ENTRY("racist", "arcade01.exe", "2bf7a3a5f0a22a140350e29bb1ac7cfb", 142097978),
	GAME_ENTRY("rackham", "Rackham.exe", "36f44e064eab15e502caeb60fd09f52d", 3672597),
	GAME_ENTRY("rainbowtube", "Tube Rainbow.exe", "03c8c45bd00daca1a9d75d1133df5640", 5669127),
	GAME_ENTRY("ralphtheraven", "RalphTheRaven.exe", "0500aacb6c176d47ac0f8158f055db83", 1655198),
	GAME_ENTRY("ramghost", "RAM_Ghost.exe", "f87f3e71d13b5fea0970ef95f1c87abe", 14830699),
	GAME_ENTRY("ramsesporter", "Ramses Porter and the Relay for Love.exe", "a524cbb1c51589903c4043b98917f1d9", 55490676),
	DETECTION_ENTRY("rango", "Rango.exe", "618d7dce9631229b4579340b964c6810", 21059129, Common::UNK_LANG, nullptr, nullptr, GAMEFLAG_FORCE_AA),
	GAME_ENTRY("ratchannel", "Rat Channel.exe", "c5d2c54c20cb606519b86d3890ee7fc0", 303946606),
	GAME_ENTRY("rayandtheguitar", "The Band.exe", "465f972675db2da6040518221af5b0ba", 1518249),
	GAME_ENTRY("raybexter", "Ray Bexter.exe", "3e8667bab45f2e5d7237db53ab376400", 5930752),
	GAME_ENTRY("raybexter", "Ray Bexter.exe", "d3bc2cf3a0f72f0fbe37d9edbd5ebec3", 5680319),
	GAME_ENTRY("razorsinthenight", "Razors.exe", "0500aacb6c176d47ac0f8158f055db83", 25442827),
	GAME_ENTRY("reagentorange", "Lab.exe", "83d96faa4efefcc9c03c01b9517f23bb", 13377038),
	GAME_ENTRY("realitycheck1", "Reality Check.exe", "82da2565c456dcfb265ded6fe3189c0b", 9184815),  //v1.0
	GAME_ENTRY("realitycheck1", "Reality Check.exe", "82da2565c456dcfb265ded6fe3189c0b", 9208605),  //v1.2
	GAME_ENTRY("realitycheck2", "Reality on the Norm Reality Check 2.exe", "82da2565c456dcfb265ded6fe3189c0b", 9499643),
	GAME_ENTRY("realitycheck3", "RoN Reality Check 3.exe", "82da2565c456dcfb265ded6fe3189c0b", 8386704),
	GAME_ENTRY("realityinthenorm", "Reality-in-the-Norm.ags", "546f5a7467d711f725eb48d0bbaec12e", 4204865),  // Linux
	GAME_ENTRY("realityinthenorm", "Reality-in-the-Norm.exe", "21d7482c8e968857e2653debeaa8a384", 6686033),  // Windows
	GAME_ENTRY("realityonthenorm", "RoN-DayOfComet.exe", "465f972675db2da6040518221af5b0ba", 10497989),
	GAME_ENTRY("recess", "Recess.exe", "c87aa6377abc18c1a1b2968ae6db08eb", 1941530),
	GAME_ENTRY("recess2", "Recess2.exe", "45ab4f29031b50c8d01d10a269f77ff5", 2805921),
	GAME_ENTRY("redbeardsavesron", "rbg.exe", "06a03fe35791b0578068ab1873455463", 15285217),
	GAME_ENTRY("reddwarf", "Red Dwarf.exe", "06a03fe35791b0578068ab1873455463", 2812268),
	GAME_ENTRY("redflagg", "Red Flagg.exe", "5901879fafae3812f71b3a2d73bee40e", 79414802),
	GAME_ENTRY("redhotoverdrive", "RHO.exe", "bdaf20d9779c01986d6d8b7e1d6118ee", 11718460),
	GAME_ENTRY("redpantsmeetsrobinsonclauseau", "DBL.exe", "c0aab3e02bbaf8468770480079436f61", 15658119),
	GAME_ENTRY("redpantstheprincessandthebeanstalk", "Redpants - The Princess and the Beanstalk.exe", "c0aab3e02bbaf8468770480079436f61", 28517345),
	GAME_ENTRY("reefriversquestforekoban", "Quest for Ekoban.exe", "338fa79960d40689063af31c671b8729", 179342350),
	GAME_ENTRY("rend", "rend.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 6156428),
	GAME_ENTRY("returnjourney", "return.exe", "0564de07d3fd5c16e6947a647061913c", 72875118),
	GAME_ENTRY_PLATFORM("repossessor", "repossesor.exe", "06a03fe35791b0578068ab1873455463", 3331695,"2007 release"),  // 2007 version
	GAME_ENTRY_PLATFORM("repossessor", "repossessor.exe", "f8e8f781a4a95c2bfea5f54b085df550", 4037461,"2014 release"),  // 2014 version
	GAME_ENTRY("returntocivilization", "ReturnTo.exe", "0710e2ec71042617f565c01824f0cf3c", 3280888),
	GAME_ENTRY("revelation", "Revelation.exe", "06a03fe35791b0578068ab1873455463", 14512328),
	GAME_ENTRY("rickyquest", "black.exe", "06a03fe35791b0578068ab1873455463", 3250100),
	GAME_ENTRY("righteouscity", "RC PI - 3.00.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 19786840),
	GAME_ENTRY("righteouscity", "RCII.exe", "06a03fe35791b0578068ab1873455463", 39085407),
	GAME_ENTRY("roadofdestiny", "ROD.exe", "618d7dce9631229b4579340b964c6810", 30127308),
	GAME_ENTRY("roadracer", "TR_Bryvis.exe", "cebb3ac5c3d2df939e7f0ec8f2975b64", 25080647),
	GAME_ENTRY("roastmothergoose", "RMG.exe", "00328f4f1e7729144483107b96b11df8", 46474982),
	GAME_ENTRY("robbingtheprincess", "Princess.exe", "ac461eb75959761fe159917607c246b4", 5793384),
	GAME_ENTRY("robertredford1", "GAME.exe", "02635a77ab660023f59519c91329f7f5", 6537985),
	GAME_ENTRY("robertredford2", "ROBERT2.exe", "02635a77ab660023f59519c91329f7f5", 13075066),
	GAME_ENTRY("robertredford3", "game.exe", "71ca0d6c1c699595f28a2125948d4a84", 10846423),
	GAME_ENTRY("robmassacreofchainsawness", "Chainsaw.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 1153384),
	GAME_ENTRY("roboquest", "RoboQuest 1.2.exe", "338fa79960d40689063af31c671b8729", 22776964),
	GAME_ENTRY("robotragedy", "Robotragedy.exe", "465f972675db2da6040518221af5b0ba", 130585260),
	GAME_ENTRY("robotragedy2", "Robotragedy 2.exe", "465f972675db2da6040518221af5b0ba", 256955387),
	GAME_ENTRY("roccioquest", "RoccioQuest.exe", "7727bf5360b00bfc1947455218137803", 5797284),
	GAME_ENTRY("rockabillykid", "Rockabilly Kid.exe", "ff3358d8f2726d544aadfde4f1ec8407", 2650305),
	GAME_ENTRY("rockatruestory", "RON-Rock.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 3917056),
	GAME_ENTRY("rockburgerstreehouses", "RBTH.exe", "88cf59aad15ca331ab0f854e16c84df3", 1876674),
	GAME_ENTRY("rockpaperscissors2", "Rock, Paper, Scissors 2.exe", "89a94326c8afd9e0234e269bd7330130", 2926218),
	GAME_ENTRY("rockrockrock", "rrr.exe", "7dd36aa863ed40ede1b09ae505e478cc", 9362761),
	GAME_ENTRY("rockyroams", "Rocky.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 16978200),
	GAME_ENTRY("rodequest2", "RQ2.exe", "12c03a3c782237821acd590fd91af4c5", 4192097),
	GAME_ENTRY("rogue", "Rogue.exe", "4309e1468cdde96ad97f6988e9d5bc65", 31745808),
	GAME_ENTRY("ronbeforethelegacy", "RONlegacy.exe", "0b7529a76f38283d6e850b8d56526fc1", 4792872),
	GAME_ENTRY("ronsixteen", "16c.exe", "06a03fe35791b0578068ab1873455463", 2467851),
	GAME_ENTRY("ronvilleviper", "RonvilleViper.exe", "217e8ee8014220e9a9a2c053bd59b65a", 21158342),
	GAME_ENTRY("roomoffear", "RoomofFear_Oct.exe", "495d45fb8adfd49690ae3b97921feec6", 17366083),
	GAME_ENTRY("rootofallevil", "RootOfAllEvil.exe", "c4f5b7b29be90ba0f8128298afb917de", 3699067), // v1.0
	GAME_ENTRY("rootofallevil", "RootOfAllEvil.exe", "c4f5b7b29be90ba0f8128298afb917de", 3957834), // v1.1
	GAME_ENTRY("rosauradocelestialrescuefromdespair", "RosauraMAGS.exe", "3c5bd1713959ff469cb46ebe5542cfcf", 13190949),
	GAME_ENTRY("rowengoestowork", "Rowen.exe", "a1cef60926235b85bd0e1866b19e0dc7", 3791058),
	GAME_ENTRY("rs15", "rs15.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 13638597),
	GAME_ENTRY("rudeawakening", "RudeAwakening.exe", "0710e2ec71042617f565c01824f0cf3c", 8038257),
	GAME_ENTRY("runestones", "Project Forsetti.exe", "c0d48dcc2003d4de0410cb8612d1c3e6", 37111243),
	GAME_ENTRY("ryansdayout", "Ryan's Day out.exe", "06a03fe35791b0578068ab1873455463", 2573584),
	GAME_ENTRY("saddsonissein", "Issein.exe", "3e8667bab45f2e5d7237db53ab376400", 4070795),
	GAME_ENTRY("salazarsevilplan", "Jonny Smallvalley.exe", "a524cbb1c51589903c4043b98917f1d9", 64646627),
	GAME_ENTRY("sammysquest", "Sammy's Quest.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 7924985),
	GAME_ENTRY("santaclausdown", "scdown.exe", "f120690b506dd63cd7d1112ea6af2f77", 14385095),
	GAME_ENTRY("santassidekick", "Xmas.exe", "0710e2ec71042617f565c01824f0cf3c", 1921077),
	GAME_ENTRY("satanquest", "Satan.exe", "70cd70d2fc7b2a8716fc58fc9deaf259", 4779276),
	GAME_ENTRY("satchsquest", "Satch's.exe", "465f972675db2da6040518221af5b0ba", 1928613),
	GAME_ENTRY("saturdayschool", "ss.exe", "b216ee957dd677023e02d900281a02d6", 1588546),
	GAME_ENTRY("saw", "Saw.exe", "34a66a5033b70f4050cbe5e33a45f747", 2452460),
	GAME_ENTRY("saw", "Saw.exe", "f120690b506dd63cd7d1112ea6af2f77", 60869310),
	GAME_ENTRY("saw2", "Saw2.exe", "615e806856b7730afadf1fea9a756b70", 45338514),
	GAME_ENTRY("scaredstiffa", "Scared Stiff.exe", "18b284c22010850f79bc5c20054a70c4", 57878023),
	GAME_ENTRY("scarymaze", "Scary Maze.exe", "01823d511cc00f4de6fd920eb543c6e7", 5380554),
	GAME_ENTRY("schwarzweissrot", "SchwarzWeissRot - Englisch.exe", "495d45fb8adfd49690ae3b97921feec6", 82849166),
	GAME_ENTRY("schwarzweissrot", "SchwarzWeissRot.exe", "495d45fb8adfd49690ae3b97921feec6", 82913128),
	GAME_ENTRY("scnider", "scnider.exe", "3128b9f90e2f954ba704414ae854d10b", 1189237),
	GAME_ENTRY("scytheisland", "Scythe.exe", "0500aacb6c176d47ac0f8158f055db83", 7119760),
	GAME_ENTRY("searchofmarina", "In search of Marina.exe", "9f8a9d74c09f188af9af3e263f8b59bc", 138505062),  // Windows
	GAME_ENTRY("searchofmarina", "In search of Marina.ags", "57d8e44cfe1b992e92d63f7f646bd6fa", 135468882),  // Linux
	GAME_ENTRY("seashells", "Shells.exe", "0500aacb6c176d47ac0f8158f055db83", 6355325),
	GAME_ENTRY("seasongreetings2002", "xmas2002.exe", "97d700529f5cc826f230c27acf81adfd", 4263336),
	GAME_ENTRY("secretquestremake", "secretquest.exe", "f120690b506dd63cd7d1112ea6af2f77", 2121159),
	GAME_ENTRY("secrets", "Secrets.exe", "06a03fe35791b0578068ab1873455463", 36176884),
	GAME_ENTRY("sepulchre", "sepulchre.exe", "38dce17f7f7b96badf3a88e11e7a9797", 28412866),
	GAME_ENTRY("sevendoors", "7DOORS.exe", "18b284c22010850f79bc5c20054a70c4", 113716886),
	GAME_ENTRY("shadesofgreye", "Shades of Greye.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 16125855),
	GAME_ENTRY("shadowsofron", "Shadows.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 13891684),
	GAME_ENTRY("shailadusithlenquete", "Shai-la Enquete.exe", "a524cbb1c51589903c4043b98917f1d9", 7489302),
	GAME_ENTRY("shailaofthesith", "Shaila_of_the_Sith.exe", "a524cbb1c51589903c4043b98917f1d9", 76170347),
	GAME_ENTRY("shawshank", "Shawshank.exe", "9cb3c8dc7a8ab9c44815955696be2677", 2968469),
	GAME_ENTRY("shem", "Shem.exe", "0710e2ec71042617f565c01824f0cf3c", 8866401),
	GAME_ENTRY("sheepquest", "SheepQuest.exe", "c62e6e17113f278357859e2b9d5e4dbf", 16505844),
	GAME_ENTRY("sherlock", "Sherlock.exe", "615e73fc1874e92d60a1996c2330ea36", 19108029),
	GAME_ENTRY("shiftersboxoutsidein", "Box.exe", "fc17e9b3ab53f6b4841e2a4af5c782ff", 24471804),
	GAME_ENTRY("shoot", "Shoot.exe", "1275885401b7d2ece491e704535707d9", 4327626),
	GAME_ENTRY("shootmyvalentine", "Valentine.exe", "06a03fe35791b0578068ab1873455463", 2859760),
	GAME_ENTRY("shortcut", "ShortCut.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 4415830),
	GAME_ENTRY("shrivel", "Shrivel.exe", "12c6a846b5ba9a5dde4a1b804b3e86e9", 58873190),
	GAME_ENTRY("shunday", "Shunday.exe", "82da2565c456dcfb265ded6fe3189c0b", 4937129),
	GAME_ENTRY("sierraquest1", "SierraQuest1.exe", "465f972675db2da6040518221af5b0ba", 1275381),
	GAME_ENTRY("silentknight1", "Silent Knight.exe", "465f972675db2da6040518221af5b0ba", 47414163),
	GAME_ENTRY("silentknight2", "SilentKnight2.exe", "465f972675db2da6040518221af5b0ba", 39941166),
	GAME_ENTRY("simonsjourney", "Simon.exe", "0710e2ec71042617f565c01824f0cf3c", 3496858),
	GAME_ENTRY("simshogwarts", "Sims Hogwarts.exe", "615e73fc1874e92d60a1996c2330ea36", 20016887),
	GAME_ENTRY("skippysavestheday", "First Game Test.exe", "06a03fe35791b0578068ab1873455463", 10473902),
	GAME_ENTRY("slaythedragon", "dragon.exe", "3c5bd1713959ff469cb46ebe5542cfcf", 2917672),
	GAME_ENTRY("slaythedragon2", "Dragon2.exe", "84dc3d6bee474e039aace3c1f37b6c7d", 5682711),
	GAME_ENTRY("slaythedragon3", "Dragon III.exe", "7ddb9e776648faed5a51170d087074e9", 36162059),
	GAME_ENTRY("sleepyisland", "Sleepy Island.exe", "465f972675db2da6040518221af5b0ba", 20270790),
	GAME_ENTRY("slimequestforpizza", "slime.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 1661109),
	GAME_ENTRY("slothforseasons", "A Sloth For Both Seasons.exe", "0241777c2537fc5d077c05cde10bfa9f", 43374778),
	GAME_ENTRY("slothforseasons", "A Sloth For Both Seasons.exe", "0241777c2537fc5d077c05cde10bfa9f", 404709403), // 1.09
	GAME_ENTRY("slothforseasons", "A Sloth For Both Seasons.exe", "1dedb2fa0b9278ab564fef7d4fb053dc", 405040236), // 1.10
	GAME_ENTRY("slugprincess", "SlugPrincess.exe", "28f82e420b82d07651b68114f90223c8", 12132209),
	GAME_ENTRY("sma2", "sma21.exe", "02094e217c23e1d40a84891ee95010cb", 7093110),
	GAME_ENTRY("sma3", "sma31.exe", "4d17844029d8910fbaae1bdc99e250f2", 4961734),
	GAME_ENTRY("sma4", "smavier.exe", "02094e217c23e1d40a84891ee95010cb", 2447360),
	GAME_ENTRY("sma6", "sma6.exe", "64fcaf7da0b257ea831f89c54be0ad72", 3735081),
	GAME_ENTRY("smileysquest", "Smiley.exe", "90413e9ae57e222f8913b09d2bc847bc", 4938049),
	GAME_ENTRY("smileysquest2", "mags.exe", "3128b9f90e2f954ba704414ae854d10b", 2108492),
	GAME_ENTRY("smoothhide", "SmoothHide.exe", "b142b43c146c25443a1d155d441a6a81", 10006680),
	GAME_ENTRY("snakeamagsgame", "Snake.exe", "f120690b506dd63cd7d1112ea6af2f77", 2110526),
	GAME_ENTRY("snakesofavalon", "snakes.exe", "464fbeef013ac949e2011551048928cd", 52601238),
	GAME_ENTRY("snakesonaplane", "SOAP.exe", "06a03fe35791b0578068ab1873455463", 1589975),
	GAME_ENTRY("snipermotherland", "sniper and spotter 2.exe", "7a3096ac0237cb6aa8e1718e28caf039", 134215997),
	GAME_ENTRY("sniperpatriotic", "Sniper and spotter being patriotic.exe", "89a94326c8afd9e0234e269bd7330130", 188070576),
	GAME_ENTRY("snowmaneatcarrot", "HourgameIBISPI_1.exe", "2ff048659aaefd20d342db6428a5f1a0", 3484230),
	GAME_ENTRY("sonicandfriendsinclubhouse", "Sonic and friends.exe", "71989c04f1b9812a0df87bc4f5915d4b", 50429335),
	GAME_ENTRY("sophiamcgrath", "SophiaMcGrath.exe", "06a03fe35791b0578068ab1873455463", 7477218),
	GAME_ENTRY("sosk", "Sosk.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 12338591),
	GAME_ENTRY("sovietunterzoegersdorf2", "suz2prog.exe", "47a774ff828be0ca227ee58e7dc61467", 43921618),
	GAME_ENTRY("sovietunterzoegersdorf", "suzoeg.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 79618213),
	GAME_ENTRY("spacefreakers", "Space Freakers v2.exe", "7a3096ac0237cb6aa8e1718e28caf039", 64527091),
	GAME_ENTRY("spacehunter", "Space Hunter.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 87639118),
	GAME_ENTRY("spacelynxes", "SpaceLynxes.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 6593042),
	GAME_ENTRY("spacepirates", "Space Pirates.exe", "95dcf736be87cf7d40bf64d5b078c4b7", 3006210),
	GAME_ENTRY("spacepoolalpha", "SpacePool.exe", "ef1d6fdc83c91a1a8de9eaf2630737b7", 3055777),
	GAME_ENTRY("spacerangers", "SpaceRangersEp46.exe", "4f6c7ec127e8b0ce077abb357903612f", 41103057),
	GAME_ENTRY("spacerangersep52", "SpaceRangers52Grisli.exe", "4f6c7ec127e8b0ce077abb357903612f", 208346458),
	GAME_ENTRY("spacewar", "Spacewar.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2270669),
	GAME_ENTRY("spacewarepisode2strikba", "Space.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 4084181),
	GAME_ENTRY("spellbound", "Spellbound.exe", "588e5b40901f9c85df35ac60b9417eac", 8809110),
	GAME_ENTRY("spilakassinn", "Splakassinn.exe", "06a03fe35791b0578068ab1873455463", 2658189),
	GAME_ENTRY("spooks", "Spooks.exe", "0710e2ec71042617f565c01824f0cf3c", 22888238),
	GAME_ENTRY("spoonsiiitheunauthorizededition", "spoonsIII.exe", "2ca80bd50763378b72cd1e1cf25afac3", 16298983),
	GAME_ENTRY("spottd_boyd", "Spot the Difference.exe", "0b7529a76f38283d6e850b8d56526fc1", 933452),
	GAME_ENTRY("spottd_captainid", "SpotTheDifference.exe", "0241777c2537fc5d077c05cde10bfa9f", 2853487),
	GAME_ENTRY("sproutsofevil", "Sprouts of evil.exe", "bdd1df0484e296faa348ffcb03e16273", 22329944),
	GAME_ENTRY("sq45", "SQ4,5.exe", "5cd8db602cedc8f04cd3ca290a4a2693", 6886082),
	GAME_ENTRY("sqdote", "SQ DOTE.exe", "615e73fc1874e92d60a1996c2330ea36", 28479377),
	GAME_ENTRY("sqdote2", "DOTE2.exe", "7ddb9e776648faed5a51170d087074e9", 6122737),
	GAME_ENTRY("sqinc", "SQinc.exe", "3ee9783a5613040e25193e21c235a7d3", 6013823),
	GAME_ENTRY("sqkubikgetready", "SQ Kubik.exe", "4fb72c890984548ed6782063f2230942", 2184808),
	GAME_ENTRY("sqm11", "SQMania1.exe", "465f972675db2da6040518221af5b0ba", 831674),
	GAME_ENTRY("sqm11remake", "SQM1.exe", "465f972675db2da6040518221af5b0ba", 1001506),
	GAME_ENTRY("sqm12", "SQM 1x2.exe", "465f972675db2da6040518221af5b0ba", 755146),
	GAME_ENTRY("sqm12remake", "SQM2 RMK.exe", "465f972675db2da6040518221af5b0ba", 3029288),
	GAME_ENTRY("sqm13", "SQM 1x3.exe", "465f972675db2da6040518221af5b0ba", 1435210),
	GAME_ENTRY("sqm14", "SQM 1x4.exe", "465f972675db2da6040518221af5b0ba", 1383567),
	GAME_ENTRY("sqm15", "SQ Mania Ep5.exe", "a524cbb1c51589903c4043b98917f1d9", 2896204),
	GAME_ENTRY("sqm16", "SQM 1x6.exe", "465f972675db2da6040518221af5b0ba", 1400100),
	GAME_ENTRY("sqpotim", "sq_game.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2937151),
	GAME_ENTRY("sqvn", "ENG.exe", "615e73fc1874e92d60a1996c2330ea36", 13629884),
	GAME_ENTRY("sqvsb", "vsb.exe", "9fc9b41b494ec4a1072e7485ee6113fc", 5632323),
	GAME_ENTRY("sqvsb", "vsb.exe", "9fc9b41b494ec4a1072e7485ee6113fc", 5631438),
	GAME_ENTRY("stablepeteandthejoust", "StablePete.exe", "b142b43c146c25443a1d155d441a6a81", 30046740),
	GAME_ENTRY("stablepeteandthejoust", "StablePete.exe", "b142b43c146c25443a1d155d441a6a81", 30048075),
	GAME_ENTRY("stairquest", "Stair Quest.exe", "e0aeab6a2c479fde167c4c43c3abb8ca", 4550699),
	GAME_ENTRY("stairquest", "stair-quest.exe", "75494269745a5282be12278166cf662c", 33778514), // itch.io Windows
	GAME_ENTRY("stairquest", "stair-quest.ags", "535320876f2ef9ef066dfabc925f4e51", 31300418), // itch.io Linux
	GAME_ENTRY("stanamespiepisode1", "NEW.exe", "f120690b506dd63cd7d1112ea6af2f77", 19194728),
	GAME_ENTRY("stansrevenge", "Gameisle.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 915036),
	GAME_ENTRY("stargateadv", "StarGA.exe", "0710e2ec71042617f565c01824f0cf3c", 45738298),
	GAME_ENTRY("stargateadv", "StarGA.exe", "0710e2ec71042617f565c01824f0cf3c", 45664346),
	GAME_ENTRY("stargateadv", "StarGA.exe", "0710e2ec71042617f565c01824f0cf3c", 45662205),
	GAME_ENTRY("stargatesgc", "Stargate SGC.exe", "bdaf20d9779c01986d6d8b7e1d6118ee", 2188193),
	GAME_ENTRY("stargatesolitaire", "SolitaireSG1.exe", "5529522460cb27d6a4f2619aee618590", 11658638),
	GAME_ENTRY("starshipcaramba", "karamba.exe", "465f972675db2da6040518221af5b0ba", 21540340),
	GAME_ENTRY("starshipposeidon", "Starship Poseidon.exe", "5a9abb3094d0b3f4bc09c0c77fbb8024", 4163873),
	GAME_ENTRY("starshipquasar", "quasar.exe", "8d1c6698abc66509df3dbe57a0a4144b", 11959826), // v1.1
	GAME_ENTRY_STEAM("starshipquasar", "starship quasar.ags", "0ea8150e15a4f4d0f3e82c231a4659f2", 10415956),
	GAME_ENTRY("startreknewton", "Anomaly.exe", "721e8a1dce90fc3ee31cade9a50d9e75", 8750111),
	GAME_ENTRY("stediddyip1employment", "stediddy1.exe", "5872fea5a958bc74c2d9ca7b2d196c42", 27136166),
	GAME_ENTRY("stickmeni", "stick.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 2399329),
	GAME_ENTRY("stickythestickfigurepart1thecrimsonhouse", "Crimson House Files.exe", "3b095a7872e04769d04ab45e9c1b66eb", 3610653),
	GAME_ENTRY("stranded", "Stranded.exe", "18b284c22010850f79bc5c20054a70c4", 39791629),
	GAME_ENTRY("strangeland", "Strangeland.exe", "c5978d50a9b7ee1c8a50a731847d8504", 3186614879),
	GAME_ENTRY("strangeland", "Strangeland.exe", "c5978d50a9b7ee1c8a50a731847d8504", -1), // for 32-bit limited filesystems
	GAME_ENTRY("strangeland", "ac2game.dat", "151b0391a650d3c81c2758deaa5852cd", 3183277137),
	GAME_ENTRY("stranger", "Stranger.exe", "0500aacb6c176d47ac0f8158f055db83", 5854099),
	GAME_ENTRY("strangerinstickworld", "game1.exe", "a524cbb1c51589903c4043b98917f1d9", 42525810),
	GAME_ENTRY("strangerthings", "StrangerThings.exe", "cc19db728abbcf657db6b76afb0e92d1", 43636017),
	GAME_ENTRY("strangerthings", "StrangerThings.ags", "88784c4bc760f7a7bfdd2c77e41297c5", 41367623), // Linux
	GAME_ENTRY_PLATFORM("stuckathome", "stuckathome.exe", "465f972675db2da6040518221af5b0ba", 2540157, "v1.0"),
	GAME_ENTRY_PLATFORM("stuckathome", "stuckathome.exe", "f120690b506dd63cd7d1112ea6af2f77", 2746090, "v2.0"),
	GAME_ENTRY("supaevil", "SupaEvil.exe", "0710e2ec71042617f565c01824f0cf3c", 7602318),
	GAME_ENTRY("supergirl", "Supergirl.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 12108982),
	GAME_ENTRY("superhammerquest", "Super Hama Queste.exe", "ed77faf99fc94efb68662e92bce2e985", 15954791),
	GAME_ENTRY("superpitstopracing", "Super Racing.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 3660473),
	GAME_ENTRY("superpitstopracing", "Super Racing.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 3660481),
	GAME_ENTRY("surreality", "Surreality.exe", "3128b9f90e2f954ba704414ae854d10b", 10773443),
	GAME_ENTRY("suspiciousmind", "MAGS March 2019.exe", "c7211b1db56a231ff1f8454704c086f1", 20550294),
	GAME_ENTRY("sweed", "SWeed.exe", "be65afc1ea59889c05e4e4cc143b3dbc", 2171942),
	GAME_ENTRY("sword", "Sword.exe", "0500aacb6c176d47ac0f8158f055db83", 1847692),
	GAME_ENTRY("sydneyfindsemployment", "sydney.exe", "06a03fe35791b0578068ab1873455463", 17351738),
	GAME_ENTRY("sydneytreadsthecatwalk", "sydney two.exe", "615e806856b7730afadf1fea9a756b70", 31480339),
	GAME_ENTRY("taleofalegacy", "A Tale of a Legacy.exe", "387ff720e746ae46e93f463fd58d77a4", 347029015),
	GAME_ENTRY("talesofchickenry", "Chickenry.exe", "aabdafae8b57dfc48fdf158a72326c23", 50338519),
	GAME_ENTRY("tao", "Tao through space and time AGS.exe", "7a3096ac0237cb6aa8e1718e28caf039", 35930047),
	GAME_ENTRY("tarthenia", "Tarthenia.exe", "a524cbb1c51589903c4043b98917f1d9", 1047988125),
	GAME_ENTRY("teafortwo", "detective208x.exe", "7d551cb6cc3c3424d40da9568a3c2340", 11076184),
	GAME_ENTRY("teamwork", "teamwork.exe", "96f83f7decb523d0c621646828cad249", 3741039),
	GAME_ENTRY("templeofspheres", "Spheres.exe", "e9475a2e453039ca51c8c319a8c8255a", 7117373),
	GAME_ENTRY("tenhumstombpart1", "tomb.exe", "0710e2ec71042617f565c01824f0cf3c", 1252175),
	GAME_ENTRY("terrorofthevampire", "TERRVAMP.exe", "efd2b2abf965c4b50bea79a419b82cf1", 5164804),
	GAME_ENTRY("test", "Living Nightmare.exe", "95dcf736be87cf7d40bf64d5b078c4b7", 3356797),
	GAME_ENTRY("test5", "who07.exe", "465f972675db2da6040518221af5b0ba", 1889598),
	GAME_ENTRY("textparsergame", "tparsergame.exe", "06a03fe35791b0578068ab1873455463", 2061002),
	GAME_ENTRY("tfg-bttf3", "tfg - bttf iii - timeline of mi.exe", "7ddb9e776648faed5a51170d087074e9", 157518001),
	GAME_ENTRY("tfg-bttf4", "tfg - bttf iv - the multitasking crystal.exe", "7ddb9e776648faed5a51170d087074e9", 176964994),
	GAME_ENTRY("tfg-bttf5", "tfg - bttf v - m -space-timelines -.exe", "7971a7c02d414dc8cb33b6ec36080b91", 213022300),
	GAME_ENTRY("tfg-bttfwat", "TFG-IBBTTFWAT.exe", "7971a7c02d414dc8cb33b6ec36080b91", 285643776),
	GAME_ENTRY("tfg-goonies", "TFG - THE GOONIES.exe", "7971a7c02d414dc8cb33b6ec36080b91", 62524979),
	GAME_ENTRY("tfg-mi", "tfg-g&mi.exe", "7971a7c02d414dc8cb33b6ec36080b91", 251715672),
	GAME_ENTRY("tfg-pixel", "THE PIXEL HAS YOU DISK 1.exe", "7971a7c02d414dc8cb33b6ec36080b91", 289291855),
	GAME_ENTRY("tfg-pixel", "THE PIXEL HAS YOU DISK 1.exe", "0691254142a4dbeaf47a6efd7a4cb6f0", 376910335), // 1.1
	GAME_ENTRY("tfg-somi", "TFG-TSOMI-R.exe", "7971a7c02d414dc8cb33b6ec36080b91", 473724788),
	GAME_ENTRY("tfg-ssgw", "TFG-SSGW.exe", "7971a7c02d414dc8cb33b6ec36080b91", 274251831),
	GAME_ENTRY("tfg-zak2", "TFG - ZAK2.exe", "7971a7c02d414dc8cb33b6ec36080b91", 155632013),
	GAME_ENTRY("tftoz1", "Cyborg Seppuku.exe", "78dd4ca028ee0156b6a093d6d780aa65", 16776249),
	GAME_ENTRY("tftoz1", "Cyborg Seppuku.ags", "68dc2bc08a1c5979304f16c145a7fbb5", 14291497),
	GAME_ENTRY("tftoz2", "The Goat Crone.exe", "78dd4ca028ee0156b6a093d6d780aa65", 39332941),
	GAME_ENTRY("tftoz2", "The Goat Crone.ags", "efd1535495c3e875c30b0c1391c73c80", 36848189),
	GAME_ENTRY("tftoz3", "Fleshworms.exe", "78dd4ca028ee0156b6a093d6d780aa65", 28663403),
	GAME_ENTRY("tftoz3", "Fleshworms.ags", "eb6655814be8d6d5d5c0448d5db51d53", 26178651),
	GAME_ENTRY("tftoz4", "The Construction.exe", "63f8a60cc094996bd070e68cb3c4722c", 21089665),
	GAME_ENTRY("tftoz4", "The Construction.ags", "44cf8ac1234e6bd5dfc0068c8a6d601b", 17982829),
	GAME_ENTRY("thatcrazyworld", "crworld.exe", "64fcaf7da0b257ea831f89c54be0ad72", 3219346),
	GAME_ENTRY("thatday", "ThatDay.exe", "b142b43c146c25443a1d155d441a6a81", 9534366),
	GAME_ENTRY("the30minutewar", "7DG.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1659319),
	GAME_ENTRY("the7thsense", "7thSense.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 17972183),
	GAME_ENTRY("theadventureofthehero", "The Adventure of the Hero.exe", "5d20aab40290fc72ec84393464913df2", 4408710),
	GAME_ENTRY("theadventuresofturquoisem", "The Adventures Of Turquoise Mcdonald.exe", "06a03fe35791b0578068ab1873455463", 2883450),
	GAME_ENTRY("theassassin", "the-assassin.exe", "e3962995a70923a8d5a8f1cf8f932eee", 29043438),
	GAME_ENTRY("theawakening", "The Awakening.exe", "0241777c2537fc5d077c05cde10bfa9f", 13613585),
	GAME_ENTRY("thebadneighbours", "Bad neighbour.exe", "06a03fe35791b0578068ab1873455463", 9672173),
	GAME_ENTRY("thebar", "one room game.exe", "465f972675db2da6040518221af5b0ba", 11660587),
	GAME_ENTRY("thebrokenbrain", "Brain.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 1092293),
	GAME_ENTRY("thebunker", "The Bunker.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 12391058),
	GAME_ENTRY("theburn", "The Bum 1.04.exe", "0212ad5fd38d64f63c5d3f2f2a0f65ee", 28673515),
	GAME_ENTRY("thecadaversynod", "The cadaver synod.exe", "36f44e064eab15e502caeb60fd09f52d", 37438749),
	GAME_ENTRY("thecan", "TheCan.exe", "82da2565c456dcfb265ded6fe3189c0b", 72388782),
	GAME_ENTRY("thecell", "Cell.exe", "0b7529a76f38283d6e850b8d56526fc1", 811527),
	GAME_ENTRY("thecell", "The Cell.exe", "b142b43c146c25443a1d155d441a6a81", 21422530),
	GAME_ENTRY("thechrysalis", "Mygame.exe", "22b9c6d170613eb01afa1697b1b75cdb", 28926604),
	GAME_ENTRY("thecrazedchicken", "chicken.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 3913199),
	GAME_ENTRY("thecube", "The Cube.exe", "97d700529f5cc826f230c27acf81adfd", 2029985),
	GAME_ENTRY("thecurseoflife", "TheCurse.exe", "90413e9ae57e222f8913b09d2bc847bc", 9651875),
	GAME_ENTRY("thedaynothinghappened", "MAGSMarch2011.exe", "615e73fc1874e92d60a1996c2330ea36", 9845417),
	GAME_ENTRY("thedayofdarkness", "DayODark.exe", "465f972675db2da6040518221af5b0ba", 1082758),
	GAME_ENTRY("thedeathoflukesimpson", "LukeDead.exe", "06a03fe35791b0578068ab1873455463", 3233789),
	GAME_ENTRY("thedevilsshroudpart1", "DevilTorino256.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 16661573),
	GAME_ENTRY("thedigitalspell", "Digital.exe", "4d17844029d8910fbaae1bdc99e250f2", 14657385),
	GAME_ENTRY("thedusseldorfconspiracy", "dusseldorf.exe", "465f972675db2da6040518221af5b0ba", 60887427),  //v1.4
	GAME_ENTRY("thedusseldorfconspiracy", "dusseldorf.exe", "465f972675db2da6040518221af5b0ba", 60878686),
	GAME_ENTRY("thedwarvendaggerofblitz", "teste2.exe", "06a03fe35791b0578068ab1873455463", 9874658),
	GAME_ENTRY("theelevator", "Elevator.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6563864),
	GAME_ENTRY("theenergizer", "TheEnergizer.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 54539625),
	GAME_ENTRY("theepicadventures", "Epic adventures.exe", "a524cbb1c51589903c4043b98917f1d9", 17723648),
	GAME_ENTRY("theeverbeginningtale", "RRS.exe", "36f8b37f85f446e9aaccb18d85660cde", 5006033),
	GAME_ENTRY("theexecutionofanneboleyn", "TheExecutionOfAnneBoleyn.exe", "6ee67d23067b0499eb8c6a1a9aabff8c", 8549540),
	GAME_ENTRY("thefarm", "the farm.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 88858865),
	GAME_ENTRY("theficklehandsoffate", "Game.exe", "2bf7a3a5f0a22a140350e29bb1ac7cfb", 4105398),
	GAME_ENTRY("thefind", "The Find.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3476394),
	GAME_ENTRY("thegourmet", "The Gourmet.exe", "c48d0beedcdc1b05e9e25dcd60de46a9", 49995478),
	GAME_ENTRY("thegreatcasserolecaper", "TGCC.exe", "6ee842f73649ced615c44d4eb303687c", 10902276),
	GAME_ENTRY("thegreatstrokeoff", "GSO.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 84337184),
	GAME_ENTRY("thegruglegends", "Grug.exe", "c6acb1705dd30f82ba026e92d6af831e", 85947629),
	GAME_ENTRY("thehamlet", "hamlet.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 4252451),
	GAME_ENTRY("thehauntedhouse", "HH.exe", "97d700529f5cc826f230c27acf81adfd", 29221222),
	GAME_ENTRY("theheist", "The Heist.exe", "261d108f9213356a351b35b54867f342", 13502430),
	GAME_ENTRY("thehobbitriseofthedragonking", "The Hobbit.exe", "338fa79960d40689063af31c671b8729", 113862075),
	GAME_ENTRY("thehousethatatemysoul", "THTFMD.exe", "f120690b506dd63cd7d1112ea6af2f77", 3930376),
	GAME_ENTRY("thehuntforgoldbeard", "The hunt for Goldbeard.exe", "a524cbb1c51589903c4043b98917f1d9", 4043188),
	GAME_ENTRY("thehuntforshaunbinda", "For Lisa Creed Made By Dan man.exe", "fd91d116e5adc4328cb22fab0b940e4d", 30753829),
	GAME_ENTRY("thehuntforshaunbindadeluxeedition", "For Lisa Creed Made By Dan man.exe", "5d6e936eaee9316e756bfe33ef8d3a19", 34290389),
	GAME_ENTRY("theinfinitystring", "String.exe", "90413e9ae57e222f8913b09d2bc847bc", 36963577),
	GAME_ENTRY("theiraqiparadox", "0203.exe", "b25674056fe8cc0b7bf0a4409c5c5bfc", 2976283),
	GAME_ENTRY("thejackyard", "The Jackyard.exe", "45d092881ef70b288382426a10251df3", 101417484),
	GAME_ENTRY("thejourneyhome", "Part1.exe", "9cf51833e787cc919837d9a8bd8fc14c", 8355767),
	GAME_ENTRY("thejourneyofiesir", "The Journey of Iesir.exe", "376a3f162c7940d990325c53edc20fed", 70444514),
	GAME_ENTRY("thelastharvest", "The Last Harvest.exe", "f120690b506dd63cd7d1112ea6af2f77", 6253816),
	GAME_ENTRY("thelastsupperawhodunnit", "THE LAST SUPPER, A WHODUNNIT.exe", "37500274a7882e8087042cc6ec851e0c", 13447848),
	GAME_ENTRY("thelongtrip", "longtrip.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 184362586),
	GAME_ENTRY("themajesticconspiracy", "majestic.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 17929647),
	GAME_ENTRY("themarionette", "marionette.exe", "ff3d6e4edfca8b4f4f1c6cbf8e2781a6", 88408446),
	GAME_ENTRY("themccarthychronicleschapter1", "McCarthy.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 29488543),
	GAME_ENTRY("themcreedcasebytk", "McReedCase.exe", "4bcbc24015114752b3c7971128704689", 2982436),
	GAME_ENTRY("themysteriesofstiegomoors", "mystery.exe", "0710e2ec71042617f565c01824f0cf3c", 12062769),
	GAME_ENTRY("themysteryofhauntedhollow", "magic1.exe", "3128b9f90e2f954ba704414ae854d10b", 3338806),
	GAME_ENTRY("thenetherworld", "netherworld.exe", "465f972675db2da6040518221af5b0ba", 2253033),
	GAME_ENTRY("thenextcurse", "TNC.exe", "88cf59aad15ca331ab0f854e16c84df3", 4125146),
	GAME_ENTRY("theoracle", "The Oracle.exe", "f120690b506dd63cd7d1112ea6af2f77", 7490474),
	GAME_ENTRY("thepaparazziprince", "Willy.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 3403804),
	GAME_ENTRY("thepark", "park.exe", "97d700529f5cc826f230c27acf81adfd", 709265),
	GAME_ENTRY("theperfectmurder", "Tamz.exe", "9cf51833e787cc919837d9a8bd8fc14c", 4527709),
	GAME_ENTRY("thephantominheritance", "Phantom.exe", "ec04c7917c003d9e07d4514ff25bf365", 27558669),
	GAME_ENTRY("thequestfortheholysalsa", "TheQuestForTheHolySalsa.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 38506266),
	GAME_ENTRY("thequesttozooloo", "Zooloo.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 14619530),
	GAME_ENTRY("therail", "Rail.exe", "973f6b65820ca1f4e19704a49be99d76", 23852280),
	GAME_ENTRY("theroadtomurder", "lbb.exe", "465f972675db2da6040518221af5b0ba", 1020984),
	GAME_ENTRY("therobolovers", "The Robolovers.exe", "618d7dce9631229b4579340b964c6810", 63850620),
	GAME_ENTRY("therotaryclub", "The Rotary Club.exe", "01823d511cc00f4de6fd920eb543c6e7", 9641709),
	GAME_ENTRY("thesearch", "s??rts.exe", "465f972675db2da6040518221af5b0ba", 5465638),
	GAME_ENTRY("thesecretofchunkysalsa", "TSOCS.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 3096950),
	GAME_ENTRY("thesecretofgoldenriver", "tsotgr.exe", "06a03fe35791b0578068ab1873455463", 8397455),
	GAME_ENTRY("thesecretofhuttongrammarschool", "1g1w.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 6584420),
	GAME_ENTRY("thesecretofhuttongrammarschool", "The Secret of Hutton Grammar School VGA.ags", "8d699b21ab64b28c6b2c245c01c822fc", 64971355),
	GAME_ENTRY("thesecretofhuttongrammarschool", "Hutton.exe", "da4472d08645ec27a0829667a33bd46f", 14270944),
	GAME_ENTRY("thesecretofhuttongrammarschool", "Hutton.exe", "597dae6c61fa074c87fd81a8303744a7", 13564399),
	GAME_ENTRY("thesecretofmountmonkey", "Mmonk.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 6386620),
	GAME_ENTRY("thesecretplan1runningtostandstill", "thesecretplan1.exe", "bb59de174d70797d774dec76a171352d", 447931405),
	GAME_ENTRY("theshaft", "TheShaft.exe", "7ddb9e776648faed5a51170d087074e9", 24992168),
	GAME_ENTRY("theshortestjourney", "The Shortest Journey.exe", "7c70226b560d6d9ffd9e165d6fbddd7e", 21503346),
	GAME_ENTRY("thesmallestpoints", "The Smallest Points.exe", "fd642138b7e6374ce0a0b9a1b0510500", 29534364),
	GAME_ENTRY("thesnaplock", "The Snaplock.exe", "7a3096ac0237cb6aa8e1718e28caf039", 31519102),
	GAME_ENTRY("thespoons", "Spoons.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 3652176),
	GAME_ENTRY("thestarryskyaboveme", "The Starry Sky Above Me.exe", "618d7dce9631229b4579340b964c6810", 14082659),
	GAME_ENTRY("thesundownmystery", "Sundown.exe", "a08ab253c4d2f255b9139f2aa5fe7006", 31839270),
	GAME_ENTRY("thethickening", "Retaliation Pt2.exe", "0500aacb6c176d47ac0f8158f055db83", 7084941),
	GAME_ENTRY("thetombofthemoon", "TotM.exe", "f120690b506dd63cd7d1112ea6af2f77", 1632811),
	GAME_ENTRY("thetrap", "Darcy.exe", "0500aacb6c176d47ac0f8158f055db83", 1164147),
	GAME_ENTRY("thetreasuredmedallion", "The Treasured Medallion.exe", "504df40bf50a0859e3dc15b000dab5f6", 1091122652),
	GAME_ENTRY("thetreasureoflochinch", "LochInch.exe", "6e861b1f476ff7cdf036082abb271329", 4091983),
	GAME_ENTRY("theuncertaintymachine", "TUMv11.exe", "b25674056fe8cc0b7bf0a4409c5c5bfc", 20670414),
	GAME_ENTRY("theuncertaintymachine", "TUMv11.exe", "b25674056fe8cc0b7bf0a4409c5c5bfc", 20672955),
	GAME_ENTRY("theupliftmofopartyplan", "MI5 Bob.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 4092850),
	GAME_ENTRY("thevacuum", "Spacefiles.exe", "d0ba73645e3cbf8ccd65121417f9895f", 14805166),
	GAME_ENTRY("thevisitor3", "Visitor3.exe", "615e73fc1874e92d60a1996c2330ea36", 126688970),
	GAME_ENTRY("thewitch", "Witch.exe", "f120690b506dd63cd7d1112ea6af2f77", 2693486),
	GAME_ENTRY("thisgame", "thisgame.exe", "74aad8dfd71ed2ae9574a60be7610c43", 6271585),
	GAME_ENTRY("threeguyswalkintoheaven", "Three Guys Walk Into Heaven.exe", "c45653d1c856f002ceb59a5b865ab187", 2896291),
	GAME_ENTRY("tilepuzzlegame", "Puzzle01.exe", "615e73fc1874e92d60a1996c2330ea36", 2819964),
	GAME_ENTRY("tiltor", "Tiltor.exe", "f120690b506dd63cd7d1112ea6af2f77", 17561878),
	GAME_ENTRY("timequest1", "gam.exe", "465f972675db2da6040518221af5b0ba", 5669007),
	GAME_ENTRY("timequest2", "TimeQ2.exe", "465f972675db2da6040518221af5b0ba", 5838823),
	GAME_ENTRY("timesinkofchronos", "Timesink.exe", "2bc8f994a7d1e05ed45f35abf2128231", 127528679),
	GAME_ENTRY("timestone", "Time Stone.exe", "a2b79cf0a58853225f7df221a6a9e528", 16256197),
	GAME_ENTRY("timothylande", "Timothy Lande.exe", "0500aacb6c176d47ac0f8158f055db83", 13874628),
	GAME_ENTRY("tomateundescanso", "tomate.exe", "3128b9f90e2f954ba704414ae854d10b", 8865274),
	GAME_ENTRY("tmntturtlesintime", "Turtles.exe", "465f972675db2da6040518221af5b0ba", 2309552),
	GAME_ENTRY("toffeetrouble", "ToffeeTrouble.exe", "acda5a3cf15b9e9e1d96bdc78f6eff60", 74459735),
	GAME_ENTRY("tomhanksaway", "Tom Hanks Away.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 1589035),
	GAME_ENTRY("totti1", "Tochan.exe", "2ca80bd50763378b72cd1e1cf25afac3", 9982703),
	GAME_ENTRY("totti2", "good evening tochan.exe", "2ca80bd50763378b72cd1e1cf25afac3", 3408230),
	GAME_ENTRY("toomanykittens", "Too Many Kittens.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 3926440),
	GAME_ENTRY("totalhangoverextreamzz", "hangover.exe", "72a1e963da14255d2b7523133f7147d9", 1837194),
	GAME_ENTRY("tq", "TQ.exe", "465f972675db2da6040518221af5b0ba", 2420457),
	GAME_ENTRY("trappedinabuilding", "T I A B.exe", "722c8bd17ace161f1bba2d9d92806eaf", 5370873),
	GAME_ENTRY("trevordaisoninouterspace", "TrevorDaison.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 22641402),
	GAME_ENTRY("trexandmusclesambigtroubleinspf", "Trex and Muscle Sam.exe", "91696f9333f36bdba272220c644c72e7", 120822652),
	GAME_ENTRY("trilbysnotes", "notes.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5736960),
	GAME_ENTRY("trilbysnotes", "notes se.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 5880445),
	GAME_ENTRY("trilbytheartoftheft", "artoftheft.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8940823),
	GAME_ENTRY("trilbytheartoftheft", "artoftheft.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 8940666), // v1.3.4
	GAME_ENTRY("trivialpassyouit", "Trivial Pass You It.exe", "01823d511cc00f4de6fd920eb543c6e7", 2737077),
	GAME_ENTRY("trumpsbed", "SITB.exe", "c1a6f1752b85d9127d6f9d11bcb124bb", 67920649),  // Windows
	GAME_ENTRY("trumpsbed", "SITB.ags", "0d79c6f044b0f44b07e8800c5224fbf8", 65180409),  // Linux
	GAME_ENTRY("tvbrder", "TvaBroder.exe", "7a669a96e488653db661d285bbc12783", 17875297),
	GAME_ENTRY("twelvethirteense", "1213 SE.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 644458),
	GAME_ENTRY("twelvethirteen", "1213.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2942386),
	GAME_ENTRY("twelvethirteen", "1213_ep1.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3283696), // From SE
	GAME_ENTRY("twelvethirteenepisode2", "1213_ep2.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3602361),
	GAME_ENTRY("twelvethirteenepisode2", "1213_ep2.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3656275), // From SE
	GAME_ENTRY("twelvethirteenepisode3", "1213_ep3.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3205606),
	GAME_ENTRY("twelvethirteenepisode3", "1213_ep3.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 3246117), // From SE
	GAME_ENTRY("twentiesflappersvsthemummy", "Twenties Flappers vs The Mummy.exe", "a524cbb1c51589903c4043b98917f1d9", 15042196),
	GAME_ENTRY("twoofakind", "toak.exe", "465f972675db2da6040518221af5b0ba", 24644765),
	GAME_ENTRY("ucom", "UCOM.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 1593175),
	GAME_ENTRY("uglyfiles", "ugly.exe", "0394af1c29e1060fcdbacf2a3dd9b231", 4169486),
	GAME_ENTRY("ulitsadimitrova", "ulitsa.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 291828379),
	GAME_ENTRY_STEAM("unavowed", "ac2game.dat", "b1ff7d96667707daf4266975cea2bf90", 1755457364), // Mac
	GAME_ENTRY_PLATFORM("unavowed", "Unavowed.exe", "b1ff7d96667707daf4266975cea2bf90", 1755451248, "Steam/GOG"), // TODO: split
	GAME_ENTRY("unbound", "Unbound.exe", "900b277d7e1601c65b42868cd7fae662", 10448702),
	GAME_ENTRY("underworld", "Underworld.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 5147661),
	GAME_ENTRY("unfinished", "mags.exe", "0710e2ec71042617f565c01824f0cf3c", 12092514),
	GAME_ENTRY("unfinishedtales", "shst.exe", "28f82e420b82d07651b68114f90223c8", 1013809),
	GAME_ENTRY("unganeedsmumba", "UNGA needs MUMBA.exe", "2ca6bb6d5b2710ac89fea7d69c2eaf77", 5470102),
	GAME_ENTRY("unintelligentdesign", "UD.exe", "5ca1bc01c5a45388bd5c84ef36077361", 6019596),
	GAME_ENTRY("unprofe", "Un Profe.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 3465541),
	GAME_ENTRY("unraveling", "unraveling.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 2927577),
	GAME_ENTRY("updatequest", "U-Quest.exe", "06a03fe35791b0578068ab1873455463", 1776804),
	GAME_ENTRY("urbanwitchstory", "Urban Witch Story.exe", "636950f50c877767bca7e2b1250632f7", 441430956),
	GAME_ENTRY("utopiaoftyrant", "Utopia_of_a_Tyrant.exe", "f8a42e09e40a7ab1cd2a21f74a5e0980", 80966652),
	GAME_ENTRY("vacationquestthing", "MGA.exe", "95b7dd55f6e15c8a2118856ed9fe8ff9", 943647),
	GAME_ENTRY("valhallaextinction", "MAGSjuly2016.exe", "95864ae16f51c512985007dca83c1370", 4464850),
	GAME_ENTRY("valis", "valis 0.70.exe", "0710e2ec71042617f565c01824f0cf3c", 4348394),
	GAME_ENTRY("vankairbreak", "Airbreak.exe", "28567bd2dc355a02a0ba58749e753f87", 23126775),
	GAME_ENTRY("vegetablepatchextreemturbo", "VPET.exe", "0b7529a76f38283d6e850b8d56526fc1", 2656540),
	GAME_ENTRY("veggietales3d", "Veggie Tales 3D.exe", "089fab88e6e1075a2f5b271f6f5b3c57", 5645075),
	GAME_ENTRY("venator", "notarpg.exe", "58fa77748873bdecee8b3ef1b564c45e", 88605764),
	GAME_ENTRY("veteranshootout", "Vet kill.exe", "0710e2ec71042617f565c01824f0cf3c", 3641458),
	GAME_ENTRY("vicwreckleshalloweencostume", "vic.exe", "01d0e6bd812abaa307bcb10fc2193416", 2913241),
	GAME_ENTRY("virtualpiano", "Synth.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 1419081),
	GAME_ENTRY("vohaulsrevenge2", "SQ XII.exe", "465f972675db2da6040518221af5b0ba", 17313307),
	GAME_ENTRY("voodoodave", "vdtm.exe", "06a03fe35791b0578068ab1873455463", 4451423),
	GAME_ENTRY("vpxt2", "VPET!2!.exe", "0b7529a76f38283d6e850b8d56526fc1", 12933096),
	GAME_ENTRY_PLATFORM("vrrontour", "Virtual Reality.exe", "430eaebb21d406061d67a9972ad33947", 9448048, "v05"),
	GAME_ENTRY_PLATFORM("vrrontour", "Virtual Reality.exe", "f8e8f781a4a95c2bfea5f54b085df550", 10327680, "v08"),
	GAME_ENTRY("waltersasteroid", "HDGame.exe", "465f972675db2da6040518221af5b0ba", 8390872),
	GAME_ENTRY("warstars", "MAGS.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 2356146),
	GAME_ENTRY("washedashore", "Achtung!.exe", "06a03fe35791b0578068ab1873455463", 7926840),
	GAME_ENTRY("washedashoredeluxe", "Washed.exe", "06a03fe35791b0578068ab1873455463", 2771873),
	GAME_ENTRY("wasted", "Wasted.exe", "f120690b506dd63cd7d1112ea6af2f77", 27870661),
	GAME_ENTRY("waterquest", "KOSTAS.exe", "f120690b506dd63cd7d1112ea6af2f77", 12403015),
	GAME_ENTRY("wcedit", "walkcyclist.exe", "1e81f0cba7e94fb658acd8e24ff1089f", 1861346),
	GAME_ENTRY("wearevectors", "WAV.exe", "a524cbb1c51589903c4043b98917f1d9", 5851536),
	GAME_ENTRY("wegotlost", "dream.exe", "0710e2ec71042617f565c01824f0cf3c", 8820049),
	GAME_ENTRY("welcometodarklake", "mystery.exe", "18b284c22010850f79bc5c20054a70c4", 5438912),
	GAME_ENTRY("wet", "Wet.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 1271457),
	GAME_ENTRY("what", "what!.exe", "08cb9ad3be9f966132d0c17f0dee471c", 48181831),
	GAME_ENTRY("whatisthatthing", "somtin.exe", "0500aacb6c176d47ac0f8158f055db83", 1289618),
	GAME_ENTRY("whatlinusbruckmansees", "LinusBruckman.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 320171493),
	GAME_ENTRY("wherebedragons", "Where Be Dragons.exe", "d8ccbb83c73ca8520b19412ce0d8de10", 2607599),
	GAME_ENTRY("wheredidsamgo", "WDSG.exe", "0710e2ec71042617f565c01824f0cf3c", 4921841),
	GAME_ENTRY("wheresmhatma", "WMHM.exe", "25f919423520b921a041ec854e3a0217", 51766424),
	GAME_ENTRY("whowantstoliveagain", "Bond.exe", "465f972675db2da6040518221af5b0ba", 2497443),
	GAME_ENTRY("whowantstoliveforever", "WWtLF.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 6917937),
	GAME_ENTRY("williamsnightmare", "Killer.exe", "0b7529a76f38283d6e850b8d56526fc1", 3991683),
	GAME_ENTRY("willowhouse", "Game.exe", "5bc696cf7178870b21db6ac87972befd", 132161306),
	GAME_ENTRY("winnersdontdodrugs", "windrugs.exe", "ff3358d8f2726d544aadfde4f1ec8407", 2573704),
	GAME_ENTRY("winterrose", "Winter Rose.exe", "0500aacb6c176d47ac0f8158f055db83", 37444693),
	GAME_ENTRY("witch", "witch.exe", "06a03fe35791b0578068ab1873455463", 10110407),
	GAME_ENTRY("witchnight", "wnight.exe", "9cf51833e787cc919837d9a8bd8fc14c", 2792150),
	GAME_ENTRY("witchron", "Witch!.exe", "b52d56422af9cb50fd5cf369af69388f", 1838433),
	GAME_ENTRY("witness", "Witness!.exe", "0710e2ec71042617f565c01824f0cf3c", 803884),
	GAME_ENTRY("wizardhood", "wiz.exe", "f3a13b2d6c2e0fe04c6f466062920e23", 3693530),
	GAME_ENTRY("woo", "Woo.exe", "06a03fe35791b0578068ab1873455463", 4771204),
	GAME_ENTRY("woolyrockbottom", "Wooly.exe", "261d108f9213356a351b35b54867f342", 3409152),
	GAME_ENTRY("worldofwarcraftquest", "IMBA.exe", "3a96a134156aeccee37daae9a7d5232d", 31743641),
	GAME_ENTRY("worm", "Worm.exe", "e88fd6a23a5e498d7b0d50e3bb914085", 40704028),
	GAME_ENTRY("wrathofthesolonoids", "verb.exe", "0500aacb6c176d47ac0f8158f055db83", 3582078),
	GAME_ENTRY("yoda", "Yoda.exe", "a01a9639ce30bdcd5bf82e528b51fa06", 2461339),
	GAME_ENTRY("yourlate", "Your late.exe", "02635a77ab660023f59519c91329f7f5", 2719997),
	GAME_ENTRY("zakrepixeled", "ZAK.exe", "06885f43ad98fa6a50772b664ad2a81b", 5090444), // v0.1.4
	GAME_ENTRY("zakrepixeled", "ZAK.exe", "305a819bce4004ef3c9b1a3a9f6ac1c8", 5741632), // v0.2.2.2
	GAME_ENTRY("zombiefish", "FZombie.exe", "3128b9f90e2f954ba704414ae854d10b", 4220305),
	GAME_ENTRY("zooreal", "zoo_real.exe", "3b7cceb3e4bdb031dc5d8f290936e94b", 24184795),
	GAME_ENTRY("zugzwang", "Zugzwang.exe", "6cddccb3744ec5c6af7c398fb7b3b11c", 17209702),

	//////////
	// RuCOMM
	//////////

	// RuCOMM #1. The Best Man
	DEMO_ENTRY_LANG("tbdiy", "tbdiy.exe", "27343924ddad3be0b97bdcaa71858b1b", 4020251, Common::RU_RUS),
	GAME_ENTRY_LANG("goodman", "goodman.exe", "465f972675db2da6040518221af5b0ba", 2699578,Common::RU_RUS),
	GAME_ENTRY_LANG("evildead4", "evil dead.exe", "465f972675db2da6040518221af5b0ba", 2141432,Common::RU_RUS),

	// RuCOMM #2. Laboratory / Hotel between worlds
	GAME_ENTRY_LANG("einsteinmachine", "em.exe", "bb59de174d70797d774dec76a171352d", 76169675, Common::RU_RUS),

	// RuCOMM #3. Santa Claus Summit on Canaries
	GAME_ENTRY_LANG("prisonersofice", "newyearq.exe", "b26aa198e5175000f037b84d8a4038f5", 84723231, Common::RU_RUS),
	DEMO_ENTRY_LANG("snowyadventures", "snowyadventures.exe", "27343924ddad3be0b97bdcaa71858b1b", 86439776, Common::RU_RUS),

	{ AD_TABLE_END_MARKER, nullptr }
};

/**
 * The fallback game descriptor used by the fallback detection code
 */
static AGSGameDescription g_fallbackDesc = {
	{
		"",
		"",
		AD_ENTRY1(0, 0),
		Common::UNK_LANG,
		Common::kPlatformWindows,
		ADGF_NO_FLAGS,
		GUIO1(GUIO_NOLANG)
	},
	nullptr
};

} // namespace AGS
