#
#
#!/usr/bin/ruby

#
# ץ
#
# ====================================================================
# ===  Copyright (C) 1998-2003 Yutaka Sagiya. All rights reserved. ===
# ====================================================================
# 
#    Project              : SagCAD
#    Description          : Script
#    Source               : sample.rb
# 
#    ----------------------------------
# 
#    License              : GNU General Public License (GPL)
#    Copyright            : (C) 1998-2003 by Yutaka Sagiya
#    email                : kappa@a6s.highway.ne.jp
#                         : yutaka@sagiya.com
#    Begin                : 2003/05/21
#    Last                 : 2003/05/25
# ====================================================================
require "./ruby/diagram.rb"


# --------------------------------------------------------------------
# ϥե
InputFile = "./ruby/sag_out.txt"
OutputFile = "./ruby/sag_inp.txt"

# ----------------------------------------------------------
# SagCAD Ϥե뤫ǡɤ߹
io = open(InputFile , "r")


i = 0
x = {0,0,0,0}
y = {0,0,0,0}

while line = io.gets		# 1 Ԥɤ߹
	line.chomp!				# üʸ
	
	
	# Ƭ TRACE ȸʸĤä顢CAD DATA
	# ɽѤƤ롣
	#     
	if /^START/ =~ line
#		print io.lineno," : Data Start\n"
		
		while line = io.gets		# 1 Ԥɤ߹
			line.chomp!				# üʸ
			
			# Ƭ TRACE END ȸʸĤä顢¦ while ȴ롣
			if /^END/ =~ line
#				print io.lineno," : Data End\n"
				break
			end

			if /^POINT/ =~ line
				data = line.split(",") # (,) ڤΥǡ data() 
				i = i + 1
				x[i] = data[4].to_f
				y[i] = data[5].to_f

#				print io.lineno,"POINT ",i," (",x[i]," , ",y[i],")\n"
			end
		end
	

	elsif /^NOW_LAYER/ =~ line
		inp_layer = line.split(",") # (,) ڤΥǡ data() 
		layer = inp_layer[1].to_i
#		print io.lineno,"NOW_LAYER = ",layer,"\n"

	elsif /^NOW_COLOR/ =~ line
		inp_color = line.split(",") # (,) ڤΥǡ data() 
		color = inp_color[1].to_i
#		print io.lineno,"NOW_COLOR = ",color,"\n"
	
	elsif /^NOW_STYLE/ =~ line
		inp_style = line.split(",") # (,) ڤΥǡ data() 
		style = inp_style[1].to_i
#		print io.lineno,"NOW_STYLE = ",style,"\n"
	
	end
end
io.close




diagram = Diagram.new

# ----------------------------------------------------------------
# ľγ
# la
#  : 
#      :          (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
#  : return : 1
#      :        @Angle
diagram.sx[1] = x[1]
diagram.sy[1] = y[1]
diagram.ex[1] = x[2]
diagram.ey[1] = y[2]
diagram.la
angle = diagram.Angle
#print "angle = ",angle,"\n"


# ----------------------------------------------------------------
# Ƚʬ sx[2] : ex[2] 
# ʬ
# ppp
#  : 
#      :        (@sx[1] , @sy[1])
#      :        (@ex[1] , @ey[1])
#      :          (@sx[2] , @ex[2])
#  : return : 1
#      :          (@sx[3] , @sy[3])
diagram.sx[1] = x[1]
diagram.sy[1] = y[1]
diagram.ex[1] = x[2]
diagram.ey[1] = y[2]
diagram.sx[2] = 1.0
diagram.ex[2] = 1.0
diagram.ppp
cx = diagram.sx[3]
cy = diagram.sy[3]
#print "center = (",cx," , ",cy,")\n"

dx = x[2] - cx
dy = y[2] - cy
#print "(dx , dy) = (",dx," , ",dy,")\n"



# ----------------------------------------------------------
# ľκǶʣ̤
# plp
#  : 
#      :  1    (@sx[1] , @sy[1]) - (@ex[1] , @ey[1])
#      :  1    (@sx[2] , @sy[2])
#  : 
#      : @Type    0 , 1
#      :  1    (@ex[2] , @ey[2])
#      :  2    (@ex[3] , @ey[3]) ȴطʤ
diagram.sx[1] = x[1]
diagram.sy[1] = y[1]
diagram.ex[1] = x[2]
diagram.ey[1] = y[2]
diagram.sx[2] = x[3]
diagram.sy[2] = y[3]
ret = diagram.plp
if (ret == 0)
	#error
	io = open(OutputFile , "w")
	io.print "ERROR,\"ellipse_make.rb : plp : error\"\n"
	io.print "EOF\n"
	io.close
	exit(0)
end
x[0] = diagram.ex[2]
y[0] = diagram.ey[2]


# ----------------------------------------------------------------
# ֤εΥ
# pp
#  : 
#      :  1 (sx[1] , sy[1])
#      :  2 (ex[1] , ey[1])
#  : 
#      : Length
diagram.sx[1] = x[0]
diagram.sy[1] = y[0]
diagram.ex[1] = x[3]
diagram.ey[1] = y[3]
diagram.pp
short_l = diagram.Length
#print "short length = ",short_l,"\n"

diagram.sx[1] = cx
diagram.sy[1] = cy
diagram.ex[1] = cx + dx
diagram.ey[1] = cy + dy
diagram.pp
long_l = diagram.Length
#print "long length = ",long_l,"\n"

k = short_l / long_l
#print "k (short / long) = ",k,"\n"
if (k > 1)
	#error
	io = open(OutputFile , "w")
	io.print "ERROR,\"ûĹΤϡ롣: error\"\n"
	io.print "EOF\n"
	io.close
	exit(0)
end


# ----------------------------------------------------------
# ե˽
io = open(OutputFile , "w")

io.print "START\n"

#ELLIPSE,layer,color,style,cx,cy,dx,dy,k,sa,ea
io.print "ELLIPSE,",layer,",",color,",",style,",",cx,",",cy,",",dx,",",dy,",",k,",0,360\n"

io.print "END\n"
io.print "EOF\n"

io.close
#print "꥿󥭡򲡤Ƥλޤ"
#gets
__END__
