/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : types.h
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/17
 *    Last                 : 2007/11/08
 * ====================================================================
 */
#ifndef __TYPES_H__
#define __TYPES_H__

//#include <>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */



/* -------------------------------------------------------
 * 1 : 前処理  (struct #define etc)
 * -------------------------------------------------------
 */

struct _LAYER {
	char name[31];	/* レイヤー名 */
	int draw;		/* 0:非表示    1:表示 */
	int style;		/* レイヤーの線種 */
	int color;		/* レイヤーの色 */
	int data;		/* 0:データなし    1:データあり */
};
typedef struct _LAYER LAYER;



struct _SAG_POINT {
	int frag;
	double x;
	double y;
};
typedef struct _SAG_POINT SAG_POINT;



/* -------------------------------------------------------------------
 * FONT
 */
struct _SAG_FONT_DATA
{
	int code;
	double sx;
	double sy;
	double ex;
	double ey;
	double cx;
	double cy;
	double r;
};
typedef struct _SAG_FONT_DATA SAG_FONT_DATA;


struct _SAG_FONT {
	char moji[5];
	double height;
	double width;
	int index;
	SAG_FONT_DATA *font_data;
};
typedef struct _SAG_FONT SAG_FONT;


struct _SAG_FONT_LIST {
	SAG_FONT *font;
	struct _SAG_FONT_LIST *next;
};
typedef struct _SAG_FONT_LIST SAG_FONT_LIST;


struct _SAG_FONT_LIST_INFO {
	SAG_FONT_LIST *head;
	SAG_FONT_LIST *tail;
};
typedef struct _SAG_FONT_LIST_INFO SAG_FONT_LIST_INFO;



/* -------------------------------------------------------------------
 * CAD
 */
struct _CAD {
	int layer;
	int code;		/* 0：点  1：直線  2：円弧  3：円 */
	int style;
	long color;
	double sx;
	double sy;
	double ex;
	double ey;
	double cx;
	double cy;
	double r ;
	int OnScreen; /* (1:表示  2:不表示)  0:正  1:始点終点逆 */
};
typedef struct _CAD CAD;


struct _CAD_LIST {
	CAD *cad;
	struct _CAD_LIST *next;
};
typedef struct _CAD_LIST CAD_LIST;


struct _CAD_LIST_INFO {
	CAD_LIST *head;
	CAD_LIST *tail;
};
typedef struct _CAD_LIST_INFO CAD_LIST_INFO;



/* -------------------------------------------------------------------
 * DIMENSION
 */
struct _ASSISTANCE {
	/* 
	 * defin  補助線の定義(部品)
	 * 
	 * 点					0	
	 * 線					1	
	 * 円弧					2	
	 * 円					4	
	 * 
	 * 終点に矢印(線)		10	LineEndArrow				+0:矢印のみ  +1:矢印と線
	 * 両端に矢印(線)		20	LineBothArrow				+0:矢印のみ  +1:矢印と線
	 * 両端に逆矢印(線)		30	LineBothConverseArrow		+0:矢印のみ  +1:矢印と線
	 * 
	 * 始点に矢印(円弧)		40	ArcStartArrow				+0:矢印のみ  +1:矢印と円弧
	 * 終点に矢印(円弧)		50	ArcEndArrow					+0:矢印のみ  +1:矢印と円弧
	 * 両端に矢印(円弧)		60	ArcBothArrow				+0:矢印のみ  +1:矢印と円弧
	 * 
	 * 補助線				70	AssistanceLine				Start:引出隙間   End:引出延長
	 * (矢印)補助線の延長	80	LineEndExtension
	 * 						(LineStartExtension)
	 * 						(LineBothExtension)
	 */
	int defin;
	double sx;
	double sy;
	double ex;
	double ey;
	double cx;
	double cy;
	double r;
};
typedef struct _ASSISTANCE ASSISTANCE;


struct _TEXT {
	int		Layer;			
	int		FontType;		

	double	SearchPointX;
	double	SearchPointY;
	int		StartPoint;		/* 文字の書き出し位置 */
	float	FontHeight;		
	float	FontSpace;		
	float	Angle;
	
	char	FontName[40];	
	char	Text[256];		
	int		index;
	
};
typedef struct _TEXT TEXT;


struct _DIMENSION {
	int		Layer;
	long	text_color;
	long	Assist_color;

	int		Type;
	int		DrawType;		/* 0:縮尺実寸	1:固定サイズ	2:実寸表示 */

	char	Text[256];		
	char	UpperText[20];	
	char	LowerText[20];	

	int		FontType;
	char	FontName[40];
	float	FontHeight;
	float	FontSpace;
	float	WordSpace;
	float	FontOverLineSpace;

	float	Angle;
	double	SearchPointX;
	double	SearchPointY;
	int		StartPoint;		/* 文字の書き出し位置 */

	/* -------------------------------------------
	 * 水平位置合わせ
	 * 0:Left  
	 * 1:Center  
	 * 2:Right 
	 */
	int FitPointX;
	/* -------------------------------------------
	 * 垂直位置合わせ
	 * 0:BaseLine  
	 * 1:BaseLine + FontOverLineSpace  
	 * 2:Center  
	 * 3:UpperLine 
	 * 4:UpperLine + FontOverLineSpace 
	 */
	int FitPointY;

	SAG_POINT	start;
	SAG_POINT	end;
	int diagram_of_char_index;
	ASSISTANCE *diagram_of_char;

	int index;
	ASSISTANCE *AssistLine;
};
typedef struct _DIMENSION DIMENSION;


struct _DIMENSION_CULC {
	double X[7];
	double Y[7];
};
typedef struct _DIMENSION_CULC DIMENSION_CULC;


/* 寸法リスト */
struct _DIMENSION_LIST {
	DIMENSION *dimension;
	struct _DIMENSION_LIST *next;
};
typedef struct _DIMENSION_LIST DIMENSION_LIST;


/* 寸法リスト情報 */
struct _DIMENSION_LIST_INFO {
	DIMENSION_LIST *head;
	DIMENSION_LIST *tail;
};
typedef struct _DIMENSION_LIST_INFO DIMENSION_LIST_INFO;



/* -------------------------------------------------------------------
 * ELLIPSE
 */
struct _ELLIPSE {
	int code;		/* 0:楕円    1:楕円弧 */
	int layer;
	long color;
	int style;

	double cx;		/* 中心Ｘ */
	double cy;		/* 中心Ｙ */
	double dx;		/* 長軸の位置Ｘ(中心からの相対位置) */
	double dy;		/* 長軸の位置Ｙ(中心からの相対位置) */
	double k;		/* 短軸の％ */
	double sa;		/* 開始角 */
	double ea;		/* 終了角 */
};
typedef struct _ELLIPSE ELLIPSE;


struct _ELLIPSE_LIST {
	ELLIPSE *ellipse;
	struct _ELLIPSE_LIST *next;
};
typedef struct _ELLIPSE_LIST ELLIPSE_LIST;


struct _ELLIPSE_LIST_INFO {
	ELLIPSE_LIST *head;
	ELLIPSE_LIST *tail;
};
typedef struct _ELLIPSE_LIST_INFO ELLIPSE_LIST_INFO;



/* -------------------------------------------------------------------
 * VERTEX
 */
struct _VERTEX {
	int frag;
	double x;
	double y;
};
typedef struct _VERTEX VERTEX;


struct _VERTEX_LIST {
	VERTEX *vertex;
	struct _VERTEX_LIST *next;
};
typedef struct _VERTEX_LIST VERTEX_LIST;


struct _VERTEX_LIST_INFO {
	VERTEX_LIST *head;
	VERTEX_LIST *tail;
};
typedef struct _VERTEX_LIST_INFO VERTEX_LIST_INFO;



/* -------------------------------------------------------------------
 * POLYLINE
 */
struct _POLYLINE {
	int layer;
	/* -------------------------------------------
	 *	8  : ポリライン
	 * 16  : スプライン補間
	 * 32  : ３次Ｂスプライン曲線
	 *(64) : ベジェ曲線
	 */
	int code;
	/* 線種 */
	int style;
	/* 色 */
	long color;
	/* 分割数 */
	int split;
	/* ピッチ */
	double pitch;
	/* -------------------------------------------
	 * 1 : 閉じている
	 * 
	 */
	int frag;

	/* 頂点の数 */
	int index;
	/* 頂点のデータ */
	VERTEX_LIST_INFO vertex_list_info;
};
typedef struct _POLYLINE POLYLINE;


struct _POLYLINE_LIST {
	POLYLINE *polyline;
	struct _POLYLINE_LIST *next;
};
typedef struct _POLYLINE_LIST POLYLINE_LIST;


struct _POLYLINE_LIST_INFO {
	POLYLINE_LIST *head;
	POLYLINE_LIST *tail;
};
typedef struct _POLYLINE_LIST_INFO POLYLINE_LIST_INFO;



/* -------------------------------------------------------------------
 * INSERT
 */
struct _INSERT {
	char name[256];
	int layer;
	long color;
	int style;

	double x;
	double y;
	double angle;
	double x_scale;
	double y_scale;

	int x_num;
	int y_num;
	double x_pitch;
	double y_pitch;
};
typedef struct _INSERT INSERT;


struct _INSERT_LIST {
	INSERT *insert;
	struct _INSERT_LIST *next;
};
typedef struct _INSERT_LIST INSERT_LIST;


struct _INSERT_LIST_INFO {
	INSERT_LIST *head;
	INSERT_LIST *tail;
};
typedef struct _INSERT_LIST_INFO INSERT_LIST_INFO;



/* -------------------------------------------------------------------
 * BLOCK
 */
struct _BLOCK {
	char name[256];
	int layer;

	CAD_LIST_INFO cad_list_info;
	DIMENSION_LIST_INFO dimension_list_info;
	POLYLINE_LIST_INFO polyline_list_info;
	INSERT_LIST_INFO insert_list_info;
	ELLIPSE_LIST_INFO ellipse_list_info;
};
typedef struct _BLOCK BLOCK;


struct _BLOCK_LIST {
	BLOCK *block;
	struct _BLOCK_LIST *next;
};
typedef struct _BLOCK_LIST BLOCK_LIST;


struct _BLOCK_LIST_INFO {
	BLOCK_LIST *head;
	BLOCK_LIST *tail;
};
typedef struct _BLOCK_LIST_INFO BLOCK_LIST_INFO;



/* -------------------------------------------------------------------
 * UNDO
 */
union _LPDIAGRAM {				// union 型の宣言図形
	int *Nuru_point;
	CAD *cad_point;				// 2, 4
	DIMENSION *dimension_point;	// 3
	POLYLINE *polyline_point;	// 8
	ELLIPSE *ellipse_point;
	INSERT *insert_point;
	BLOCK *block_point;			// 
};
typedef union _LPDIAGRAM LPDIAGRAM;


union _DIAGRAM {				// union 型の宣言
	int Nuru;
	CAD cad;					// 2, 4
	DIMENSION dimension;		// 3
	POLYLINE polyline;			// 8
	ELLIPSE ellipse;
	INSERT insert;
	BLOCK block;				// 
};
typedef union _DIAGRAM DIAGRAM;


struct _UNDO_LIST {
	/* ---------------------------------------
	 * [ type ]
	 * union なので、これでデータのタイプがわかるし、
	 * このアンドゥリストが、新規、削除、編集のどれかわかる。
	 * 11,12,13  :	CAD Data 
	 * 21,22,23  :	Dimension Data 
	 */
	int type;
	/* ---------------------------------------
	 * [ index ]
	 * まとめて処理したものは、まとめて処理するために
	 * index の値は、作業ごとに 1 インクリメントする。
	 */
	long index;
	LPDIAGRAM diagram_point;
	DIAGRAM diagram;
	struct _UNDO_LIST *next;
};
typedef struct _UNDO_LIST UNDO_LIST;


struct _UNDO_LIST_INFO {
	UNDO_LIST *head;
	UNDO_LIST *tail;
};
typedef struct _UNDO_LIST_INFO UNDO_LIST_INFO;



/* -------------------------------------------------------------------
 * SELECT
 */
struct _SELECT {
	int index;	  /* 0:無	 1:点情報	 2:図形情報    3:寸法情報	 4:図形情報 */
	double x;
	double y;
	LPDIAGRAM diagram_point;
};
typedef struct _SELECT SELECT;


struct _SELECT_LIST {
	SELECT *select;
	struct _SELECT_LIST *next;
};
typedef struct _SELECT_LIST SELECT_LIST;


struct _SELECT_LIST_INFO {
	SELECT_LIST *head;
	SELECT_LIST *tail;
};
typedef struct _SELECT_LIST_INFO SELECT_LIST_INFO;



/* -------------------------------------------------------------------
 * CAM
 */
struct _CAM {
	int code;
	int gcode;	/* ０：点　１：直線　２：円弧　３：円 */
	double sx;
	double sy;
	double ex;
	double ey;
	double cx;
	double cy;
	double r ;
	double sa;
	double ea;
	double ia;
};
typedef struct _CAM CAM;


struct _CAM_LIST {
	CAM *cam;
	struct _CAM_LIST *next;
};
typedef struct _CAM_LIST CAM_LIST;


struct _CAM_LIST_INFO {
	CAM_LIST *head;
	CAM_LIST *tail;
};
typedef struct _CAM_LIST_INFO CAM_LIST_INFO;



/* -------------------------------------------------------
 * 2 : 外部変数 (global)
 * -------------------------------------------------------
 */
#ifdef    _TYPES_
#define   GLOBAL
// 初期値設定
#define   GLOBAL_VAL(v)  = (v)
#else
#define   GLOBAL	extern
// 初期値設定の代入部分を無くす
#define   GLOBAL_VAL(v)  /* */
#endif




#undef  GLOBAL
#undef  GLOBAL_VAL
#undef  _TYPES_



/* -------------------------------------------------------
 * 3 : 外部関数 (Function)
 * -------------------------------------------------------
 */



#ifdef __cplusplus
}
#endif /* __cplusplus */
#endif /* __TYPES_H__ */
/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : types.h
 * ====================================================================
 */
