/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 * 
 *    Project              : SagCAD
 *    Description          : CAD/CAM
 *    Source               : ScalingDlg.c
 * 
 *    ----------------------------------
 * 
 *    License              : GNU General Public License (GPL)
 *    Copyright            : (C) 1998-2007 by Yutaka Sagiya
 *    email                : kappa@a6s.highway.ne.jp
 *                         : yutaka@sagiya.com
 *    Begin                : 2003/02/20
 *    Last                 : 2007/11/08
 * ====================================================================
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "intl.h"

//#include "global.h"
#define _SCALINGDLG_
#include "ScalingDlg.h"





/* -------------------------------------------------------------------
 * CANCEL
 */
void scaling_dlg_cancel_pushed(GtkWidget *widget, SCALING_DLG *scaling_dlg)
{
	scaling_dlg->value = -1;
	scaling_dlg->x_pos = 0;
	scaling_dlg->y_pos = 0;
	scaling_dlg->coefficient = 0;
}



/* -------------------------------------------------------------------
 * OK
 */
void scaling_dlg_ok_pushed(GtkWidget *widget, SCALING_DLG *scaling_dlg)
{
	char str[256];
	
	/* テキストエントリーから文字列を取得 */
	if (scaling_dlg->x_pos_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(scaling_dlg->x_pos_entry)));
		scaling_dlg->x_pos = atof(str);
	}
	
	if (scaling_dlg->y_pos_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(scaling_dlg->y_pos_entry)));
		scaling_dlg->y_pos = atof(str);
	}
	
	if (scaling_dlg->coefficient_entry) {
		strcpy(str, gtk_entry_get_text(GTK_ENTRY(scaling_dlg->coefficient_entry)));
		scaling_dlg->coefficient = atof(str);
	}
	scaling_dlg->value = 0;
}



static gint scaling_dlg_delete_event(GtkWidget *widget, GdkEventAny *event, gpointer data)
{
	return TRUE;
}

static gint scaling_dlg_focus_out(GtkWidget *widget, GdkEventFocus *event, gpointer data)
{
#ifdef G_OS_WIN32
	gtk_window_present(GTK_WINDOW(widget));
#endif
	return FALSE;
}

/* -------------------------------------------------------------------
 * キーが押されたイベント
 * key_press_event
 */
static gint scaling_dlg_key_press_event(GtkWidget *widget, GdkEventKey *event, SCALING_DLG *scaling_dlg)
{
	switch (event->keyval) {
	case GDK_Return:
	case GDK_KP_Enter:
		/* フォーカス x_pos_entry で Enter ならフォーカスを y_pos_entry に移す */
		if (GTK_WIDGET( scaling_dlg->x_pos_entry) 
				== GTK_WINDOW(scaling_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(scaling_dlg->dialog), scaling_dlg->y_pos_entry);
			//gtk_editable_select_region(GTK_EDITABLE(scaling_dlg->y_pos_entry), 0, 
			//		GTK_ENTRY(scaling_dlg->y_pos_entry)->text_length);
		}
		/* フォーカス y_pos_entry で Enter ならフォーカスを coefficient_entry に移す */
		else if (GTK_WIDGET(scaling_dlg->y_pos_entry) 
				== GTK_WINDOW(scaling_dlg->dialog)->focus_widget) 
		{
			gtk_window_set_focus(GTK_WINDOW(scaling_dlg->dialog), scaling_dlg->coefficient_entry);
			//gtk_editable_select_region(GTK_EDITABLE(scaling_dlg->coefficient_entry), 0, 
			//		GTK_ENTRY(scaling_dlg->coefficient_entry)->text_length);
		}
		/* フォーカス coefficient_entry で Enter なら終わり */
		else if (GTK_WIDGET(scaling_dlg->coefficient_entry) 
				== GTK_WINDOW(scaling_dlg->dialog)->focus_widget) 
		{
			scaling_dlg_ok_pushed(widget, scaling_dlg);
			gtk_main_quit();
		}
		return TRUE;
		break;
	default:
		break;
	}
	return FALSE; 
}



/* -------------------------------------------------------------------
 * コピー【移動/複写】設定
 * 
 */
gint ScalingDialog(SCALING_DLG *scaling_dlg)
{
	gint parent_x, parent_y;
	
	GtkWidget *main_vbox;
	GtkWidget *hbox;
	GtkWidget *label_vbox;
	GtkWidget *x_pos_label;
	GtkWidget *y_pos_label;
	GtkWidget *coefficient_label;
	GtkWidget *entry_vbox;
	GtkWidget *separator;
	GtkWidget *action_hbox;
	GtkWidget *cancel_buttun;
	GtkWidget *ok_buttun;
	
	/* ダイアログ生成 */
	scaling_dlg->dialog = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(scaling_dlg->dialog), _("Scaling Setting") );
	
	//gtk_window_set_position(GTK_WINDOW(scaling_dlg->dialog), GTK_WIN_POS_CENTER);
	//gtk_window_set_resizable(GTK_WINDOW(scaling_dlg->dialog), FALSE);
	gtk_window_get_position(GTK_WINDOW(scaling_dlg->parent), &parent_x, &parent_y);
	gtk_window_move(GTK_WINDOW(scaling_dlg->dialog), parent_x + 72, parent_y + 89);
	
	/* ダイアログを最前面に表示する */
	gtk_window_set_modal(GTK_WINDOW(scaling_dlg->dialog), TRUE);
	/* メインウィンドウを操作できないように設定 */
	gtk_window_set_transient_for(GTK_WINDOW(scaling_dlg->dialog), 
			GTK_WINDOW(scaling_dlg->parent));
	
	g_signal_connect(G_OBJECT(scaling_dlg->dialog), "delete_event",
			 G_CALLBACK(scaling_dlg_delete_event), NULL);
	g_signal_connect( G_OBJECT(scaling_dlg->dialog), "key_press_event",
				G_CALLBACK(scaling_dlg_key_press_event), scaling_dlg);
	g_signal_connect(G_OBJECT(scaling_dlg->dialog), "focus_out_event",
			 G_CALLBACK(scaling_dlg_focus_out), NULL);

	main_vbox = gtk_vbox_new(0, 5);
	gtk_container_add(GTK_CONTAINER(scaling_dlg->dialog), main_vbox);
	gtk_container_set_border_width(GTK_CONTAINER(scaling_dlg->dialog), 5);
	gtk_widget_show(main_vbox);

	hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( (GtkBox *)GTK_BOX(main_vbox), 
						hbox, TRUE, TRUE, 0);
	gtk_widget_show(hbox);

	/* セパレーター(separator) */
	separator = gtk_hseparator_new();
	gtk_box_pack_start( GTK_BOX(main_vbox), separator, TRUE, TRUE, 0);
	gtk_widget_show(separator);

	action_hbox = gtk_hbox_new(FALSE, 2);
	gtk_box_pack_start( GTK_BOX(main_vbox), action_hbox, TRUE, TRUE, 0);
	gtk_widget_show(action_hbox);

		label_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), label_vbox, TRUE, TRUE, 0);
		gtk_widget_show(label_vbox);

		entry_vbox = gtk_vbox_new(FALSE, 2);
		gtk_box_pack_start( (GtkBox *)GTK_BOX(hbox), entry_vbox, TRUE, TRUE, 0);
		gtk_widget_show(entry_vbox);

			x_pos_label = gtk_label_new( _("Starting Point X") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), x_pos_label, TRUE, TRUE, 0);
			gtk_widget_show(x_pos_label);

			y_pos_label = gtk_label_new( _("Starting Point Y") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), y_pos_label, TRUE, TRUE, 0);
			gtk_widget_show(y_pos_label);

			coefficient_label = gtk_label_new( _("Coefficient") );
			gtk_box_pack_start((GtkBox *)GTK_BOX(label_vbox), coefficient_label, TRUE, TRUE, 0);
			gtk_widget_show(coefficient_label);

			/* テキストエントリー生成 */
			scaling_dlg->x_pos_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), scaling_dlg->x_pos_entry, TRUE, TRUE, 1);
			gtk_entry_set_max_length(GTK_ENTRY(scaling_dlg->x_pos_entry), 256);
			gtk_entry_set_text(GTK_ENTRY(scaling_dlg->x_pos_entry), "0");
			gtk_editable_select_region(GTK_EDITABLE(scaling_dlg->x_pos_entry), 0, GTK_ENTRY(scaling_dlg->x_pos_entry)->text_length);
			//g_signal_connect (G_OBJECT(entry), "activate", G_CALLBACK(entry_callback), NULL);
			gtk_widget_show(scaling_dlg->x_pos_entry);

			scaling_dlg->y_pos_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), scaling_dlg->y_pos_entry, TRUE, TRUE, 1);
			gtk_entry_set_max_length(GTK_ENTRY(scaling_dlg->y_pos_entry), 256);
			gtk_entry_set_text(GTK_ENTRY(scaling_dlg->y_pos_entry), "0");
			//gtk_editable_select_region(GTK_EDITABLE(scaling_dlg->y_pos_entry), 0, GTK_ENTRY(scaling_dlg->y_pos_entry)->text_length);
			gtk_widget_show(scaling_dlg->y_pos_entry);

			scaling_dlg->coefficient_entry = gtk_entry_new();
			gtk_box_pack_start((GtkBox *)GTK_BOX(entry_vbox), scaling_dlg->coefficient_entry, TRUE, TRUE, 1);
			gtk_entry_set_max_length(GTK_ENTRY(scaling_dlg->coefficient_entry), 256);
			gtk_entry_set_text(GTK_ENTRY(scaling_dlg->coefficient_entry), "1");
			//gtk_editable_select_region(GTK_EDITABLE(scaling_dlg->coefficient_entry), 0, GTK_ENTRY(scaling_dlg->coefficient_entry)->text_length);
			gtk_widget_show(scaling_dlg->coefficient_entry);

		/* CANCELボタンの生成 */
		cancel_buttun = gtk_button_new_with_label("CANCEL");
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), cancel_buttun, TRUE, TRUE, 2);
		g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(scaling_dlg_cancel_pushed), scaling_dlg);
		g_signal_connect( G_OBJECT(cancel_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(cancel_buttun);

		/* OKボタンの生成 */
		ok_buttun = gtk_button_new_with_label("OK");
		gtk_box_pack_start((GtkBox *)GTK_BOX(action_hbox), ok_buttun, TRUE, TRUE, 2);
		g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(scaling_dlg_ok_pushed), scaling_dlg);
		g_signal_connect(G_OBJECT(ok_buttun), "clicked", G_CALLBACK(gtk_main_quit), NULL);
		gtk_widget_show(ok_buttun);

	/*  フォーカスを x_pos_entry に設定 */
	gtk_window_set_focus(GTK_WINDOW(scaling_dlg->dialog), scaling_dlg->x_pos_entry);

	/* ダイアログを可視状態へ */
	gtk_widget_show(scaling_dlg->dialog);
	/* メインイベントループ */
	gtk_main();
	gtk_widget_destroy(scaling_dlg->dialog);
	return scaling_dlg->value; 
}





/* ====================================================================
 * ===  Copyright (C) 1998-2007 Yutaka Sagiya. All rights reserved. ===
 * ====================================================================
 *    Project              : SagCAD
 *    Source               : ScalingDlg.c
 * ====================================================================
 */
