#!/bin/bash
# bbou@ac-toulouse.fr
# 14/07/2009  
# conf/config-pam_mkhomedir.sh

### I N C L U D E
. ./_include.sh

### P A R A M S
if [ "$1" == "-f" ];then
	MYDIR="$2"
	shift
	shift
else
	MYDIR="${PAMDIR}"
fi
MYSERVICES="$1"
MYMODES="$2"
#echo "dir=${MYDIR}"
#echo "services=${MYSERVICES}"
#echo "modes=${MYMODES}"

### M O D I F I E D   F I L E S ...
# those specified by ${MYDIR}/${MYSERVICES}

### ... W I T H   A C C E S S
INST_UID=root
INST_GID=root
INST_PAM_MOD=644

### F O R M A T S
case ${DISTRIBUTION} in
	Debian|Ubuntu)
		libpath=
		;;
	Redhat|Fedora)
		libpath="/lib/security/\$ISA/"
		;;
	Mandriva|Suse)
		libpath=
		;;
	*)
		echo "Unsupported distribution" >&2
		exit 1
		;;
esac

### S T A R T
echo "+install pam_mkhomedir"
case ${DISTRIBUTION} in
	Debian|Ubuntu)
		echo "copy libpam-mkhomedir profile for pam-auth-update"
		cp pam-configs/libpam-mkhomedir /usr/share/pam-configs
		chown ${INST_UID}.${INST_GID} /usr/share/pam-configs/libpam-mkhomedir
		chmod ${INST_PAM_MOD} /usr/share/pam-configs/libpam-mkhomedir
		;;
	*)
		echo "try common pam files update"

		# C U S T O M I Z E   P A M   H O O K
		j=1
		for i in ${MYSERVICES}; do

			# read mode
			mode=`echo ${MYMODES} | gawk '{split($0,a);print a[nth]}' "nth=${j}"`
			j=$((j+1))	
	
			# handle file
			echo "add pam_mkhomedir to ${MYDIR}/${i}"
			if [ ! -f ${MYDIR}/${i} ]; then
				echo "cannot customize ${MYDIR}/${i} (does not exist)"	
				continue
			fi
			grep -s "pam_mkhomedir.so" ${MYDIR}/${i} > /dev/null
			case $? in
			0)
				echo "pam_mkhomedir is already used in ${MYDIR}/${i}"
				;;
			*)
				# customize
				awk -f pam_parse.awk "add_pammkhomedir=1" "output_${mode}=1" "libpath=${libpath}" ${MYDIR}/${i} > ${TMPDIR}/${i}
				#cat ${TMPDIR}/${i}

				# install
				echo "install modified ${i} to ${MYDIR}"
				${INSTALL} -o ${INST_UID} -g ${INST_GID} -m ${INST_PAM_MOD} ${TMPDIR}/${i} ${MYDIR} > /dev/null

				# cleanup temporary
				rm -f ${TMPDIR}/${i}
				;;
			esac
		done
		;;
esac
