NAME
       listen - listen for connections on a socket

SYNOPSIS
       #include <network.h>

       int listen(int s, int backlog);

DESCRIPTION
       To  accept  connections,  a  socket  is first created with
       socket(2), a willingness to  accept  incoming  connections
       and  a  queue limit for incoming connections are specified
       with listen, and then the connections  are  accepted  with
       accept(2).   The  listen  call  applies only to sockets of
       type SOCK_STREAM or SOCK_SEQPACKET.

       The backlog parameter defines the maximum length the queue
       of  pending  connections  may  grow  to.   If a connection
       request arrives with the queue full the client may receive
       an  error  with  an  indication of ECONNREFUSED or, if the
       underlying protocol supports retransmission,  the  request
       may be ignored so that retries may succeed.

RETURN VALUE
       On success, zero is returned.  On error, -1  is  returned,
       and errno is set appropriately.

ERRORS
       EBADF   The argument s is not a valid descriptor.

       ENOTSOCK
               The argument s is not a socket.

       EOPNOTSUPP
               The socket is not of a type that supports the lis-
               ten operation.
