% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikipages.R
\name{wt_wiki_page}
\alias{wt_wiki_page}
\title{Get MediaWiki Page from API}
\usage{
wt_wiki_page(url, ...)
}
\arguments{
\item{url}{(character) MediaWiki page url.}

\item{...}{Arguments passed to \code{\link[=wt_wiki_url_build]{wt_wiki_url_build()}} if \code{url}
is a static page url.}
}
\value{
an \code{HttpResponse} response object from \pkg{crul}
}
\description{
Supports both static page urls and their equivalent API calls.
}
\details{
If the URL given is for a human readable html page,
we convert it to equivalent API call - if URL is already an API call,
we just use that.
}
\examples{
\dontrun{
wt_wiki_page("https://en.wikipedia.org/wiki/Malus_domestica")
}
}
\seealso{
Other MediaWiki functions: \code{\link{wt_wiki_page_parse}},
  \code{\link{wt_wiki_url_build}},
  \code{\link{wt_wiki_url_parse}}
}
