% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/densityfun.R
\name{densityfun}
\alias{densityfun}
\title{Kernel density estimation}
\usage{
densityfun(
  x,
  bw = "nrd0",
  adjust = 1,
  kernel = "gaussian",
  weights = NULL,
  window = kernel,
  width,
  n = 512,
  from,
  to,
  cut = 3,
  na.rm = FALSE,
  ...
)
}
\arguments{
\item{x}{numeric. The data from which the estimate is to be computed.}

\item{bw}{numeric. The smoothing bandwidth to be used. 
See the eponymous argument of \code{\link[stats]{density}}.}

\item{adjust}{numeric. The bandwidth used is actually \code{adjust*bw}. 
This makes it easy to specify values like 'half the default' bandwidth.}

\item{kernel, window}{character. A string giving the smoothing kernel to be used. 
Authorized kernels are listed in \code{\link[statip]{.kernelsList}()}. 
See also the eponymous argument of \code{\link[stats]{density}}.}

\item{weights}{numeric. A vector of non-negative observation weights, 
hence of same length as \code{x}. 
See the eponymous argument of \code{\link[stats]{density}}.}

\item{width}{this exists for compatibility with S; 
if given, and \code{bw} is not, 
will set \code{bw} to \code{width} 
if this is a character string, 
or to a kernel-dependent multiple of \code{width} if this is numeric.}

\item{n}{The number of equally spaced points at which the density 
is to be estimated. 
See the eponymous argument of \code{\link[stats]{density}}.}

\item{from, to}{The left and right-most points of the grid at which the 
density is to be estimated; 
the defaults are \code{cut * bw} outside of \code{range(x)}.}

\item{cut}{By default, the values of \code{from} and \code{to} 
are cut bandwidths beyond the extremes of the data. 
This allows the estimated density to drop to 
approximately zero at the extremes.}

\item{na.rm}{logical. If \code{TRUE}, missing values are removed 
from \code{x}. 
If \code{FALSE} any missing values cause an error.}

\item{...}{Additional arguments for (non-default) methods.}
}
\value{
A function that can be called to generate a density.
}
\description{
Return a function performing kernel density estimation. 
The difference between \code{\link[stats]{density}} and 
\code{densityfun} is similar to that between 
\code{\link[stats]{approx}} and \code{\link[stats]{approxfun}}.
}
\examples{
x <- rlnorm(1000, 1, 1)
f <- densityfun(x, from = 0)
curve(f(x), xlim = c(0, 20))

}
\seealso{
\code{\link[stats]{density}} and \code{\link[stats]{approxfun}} 
from package \pkg{stats}.
}
\author{
Adapted from the \code{\link[stats]{density}} function of package \pkg{stats}. 
The C code of \code{BinDist} is copied from package \pkg{stats} and authored 
by the R Core Team with contributions from Adrian Baddeley.
}
