% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/config_set.R
\name{config_set}
\alias{config_set}
\title{Set Solr configuration details}
\usage{
config_set(conn, name, set = NULL, unset = NULL, ...)
}
\arguments{
\item{conn}{A solrium connection object, see \link{SolrClient}}

\item{name}{(character) The name of the core. If not given, all cores.}

\item{set}{(list) List of key:value pairs of what to set. Default: NULL
(nothing passed)}

\item{unset}{(list) One or more character strings of keys to unset. Default: NULL
(nothing passed)}

\item{...}{curl options passed on to \link[crul:HttpClient]{crul::HttpClient}}
}
\value{
A list with response from server
}
\description{
Set Solr configuration details
}
\examples{
\dontrun{
# start Solr with Cloud mode via the schemaless eg: bin/solr -e cloud
# you can create a new core like: bin/solr create -c corename
# where <corename> is the name for your core - or creaate as below

# connect
(conn <- SolrClient$new())

# set a property
conn$config_set("gettingstarted", 
  set = list(query.filterCache.autowarmCount = 1000))

# unset a property
conn$config_set("gettingstarted", unset = "query.filterCache.size", 
  verbose = TRUE)

# both set a property and unset a property
conn$config_set("gettingstarted", unset = "enableLazyFieldLoading")

# many properties
conn$config_set("gettingstarted", set = list(
   query.filterCache.autowarmCount = 1000,
   query.commitWithin.softCommit = 'false'
 )
)
}
}
