% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor2string.R
\name{step_factor2string}
\alias{step_factor2string}
\title{Convert factors to strings}
\usage{
step_factor2string(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  columns = FALSE,
  skip = FALSE,
  id = rand_id("factor2string")
)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{One or more selector functions to choose variables
for this step. See \code{\link[=selections]{selections()}} for more details.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{columns}{A character string of the selected variable names. This field
is a placeholder and will be populated once \code{\link[=prep]{prep()}} is used.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake]{bake()}}? While all operations are baked
when \code{\link[=prep]{prep()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations.}

\item{id}{A character string that is unique to this step to identify it.}
}
\value{
An updated version of \code{recipe} with the new step added to the
sequence of any existing operations.
}
\description{
\code{step_factor2string()} creates a \emph{specification} of a recipe step that will
convert one or more factor vectors to strings.
}
\details{
\code{\link[=prep]{prep()}} has an option \code{strings_as_factors} that defaults to \code{TRUE}. If this
step is used with the default option, the strings produced by this step will
not be converted to factors.

Remember that categorical data that will be directly passed to a model should
be encoded as factors. This step is helpful for ancillary columns (such as
identifiers) that will not be computed on in the model.
}
\section{Tidying}{
When you \code{\link[=tidy.recipe]{tidy()}} this step, a tibble is returned with
columns \code{terms} and \code{id}:

\describe{
\item{terms}{character, the selectors or variables selected}
\item{id}{character, id of this step}
}
}

\section{Case weights}{


The underlying operation does not allow for case weights.
}

\examples{
\dontshow{if (rlang::is_installed("modeldata")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(Sacramento, package = "modeldata")

rec <- recipe(~ city + zip, data = Sacramento)

make_string <- rec \%>\%
  step_factor2string(city)

make_string <- prep(make_string,
  training = Sacramento,
  strings_as_factors = FALSE
)

make_string

# note that `city` is a string in recipe output
bake(make_string, new_data = NULL) \%>\% head()

# ...but remains a factor in the original data
Sacramento \%>\% head()
\dontshow{\}) # examplesIf}
}
\seealso{
Other dummy variable and encoding steps: 
\code{\link{step_bin2factor}()},
\code{\link{step_count}()},
\code{\link{step_date}()},
\code{\link{step_dummy_extract}()},
\code{\link{step_dummy_multi_choice}()},
\code{\link{step_dummy}()},
\code{\link{step_holiday}()},
\code{\link{step_indicate_na}()},
\code{\link{step_integer}()},
\code{\link{step_novel}()},
\code{\link{step_num2factor}()},
\code{\link{step_ordinalscore}()},
\code{\link{step_other}()},
\code{\link{step_regex}()},
\code{\link{step_relevel}()},
\code{\link{step_string2factor}()},
\code{\link{step_time}()},
\code{\link{step_unknown}()},
\code{\link{step_unorder}()}
}
\concept{dummy variable and encoding steps}
