% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ns_images.R
\name{ns_images}
\alias{ns_images}
\title{NatureServe image metadata}
\usage{
ns_images(uid = NULL, scientificName = NULL, commonName = NULL,
  includeSynonyms = NULL, resolution = NULL, ITISNames = NULL,
  key = NULL, ...)
}
\arguments{
\item{uid}{(character) a species UID, e.g., ELEMENT_GLOBAL.2.100925}

\item{scientificName}{(character) An asterisk (*) wildcarded species
scientific name, e.g., 'Aquila chry*'. Name matching is case-insensitive.}

\item{commonName}{(character) An asterisk (*) wildcarded species common
name, e.g., 'g*EAGLE'. Name matching is case-insensitive.}

\item{includeSynonyms}{(character)    An optional parameter, relevant to
scientific or common name queries, that indicates whether to include
synonymous names in the query, as follows:
\itemize{
 \item Y (or y) - search the Primary and all synonymous Scientific and
 Common Names
 \item Any other value, or omitted - search only the Primary Scientific
 and Common Name fields
}}

\item{resolution}{(character)    An optional parameter that restricts output
to images at a certain resolution. The value can be of one of the following.
\itemize{
 \item lowest - return only the lowest resolution version of images
 \item highest - return only the highest resolution version of images
 \item thumbnail - return only the version NatureServe deems the
 'thumbnail image'
 \item web - return only the version NatureServe deems the 'web image'
}
The omission of this parameter leads to the return of metadata for images at
all available resolutions.}

\item{ITISNames}{(character)    An optional parameter, relevant to scientific
or common name queries, that will indicate whether to restrict queries to
ITIS names, as follows.
\itemize{
 \item Y (or y) - query using ITIS names
 \item Any other value, or omitted - query using NatureServe names
}
NOTE: This parameter is a placeholder only and will not affect processing.
At present, searching by ITIS names is not possible.}

\item{key}{(character) API key. Required. See \strong{Authentication} below
for more.}

\item{...}{Curl options passed on to \code{\link[crul]{HttpClient}}}
}
\value{
a list with terms and images
}
\description{
NatureServe image metadata
}
\details{
Note that the NatureServer servers apparently want Windows
HTML encoding (Windows-1252), instead of UTF-8, so some accents
and such may not work
}
\section{Authentication}{

Get an API key from NatureServe at
\url{https://services.natureserve.org/developer/index.jsp}.
You can pass your token in as an argument or store it one of two places:

\itemize{
  \item your .Rprofile file with an entry like
  \code{options(NatureServeKey = "your-natureserve-key")}
  \item your .Renviron file with an entry like
  \code{NATURE_SERVE_KEY=your-natureserve-key}
}

See \code{\link{Startup}} for information on how to create/find your
.Rrofile and .Renviron files
}

\examples{
\dontrun{
# search by uid
ns_images(uid = 'ELEMENT_GLOBAL.2.100925')

# search by common name and resolutio thumbnail
(res <- ns_images(commonName = "*eagle", resolution = 'thumbnail'))

# search "Ruby*", all common names [in any language], and highest
# resolution only:
(res <- ns_images(commonName = "Ruby*", includeSynonyms = 'y',
  resolution = 'highest'))
}
}
\references{
\url{https://services.natureserve.org/index.jsp}
}
