% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_parameters_gam.R
\name{find_parameters.gamlss}
\alias{find_parameters.gamlss}
\alias{find_parameters.gam}
\title{Find names of model parameters from generalized additive models}
\usage{
\method{find_parameters}{gamlss}(x, flatten = FALSE, ...)

\method{find_parameters}{gam}(x, component = "all", flatten = FALSE, ...)
}
\arguments{
\item{x}{A fitted model.}

\item{flatten}{Logical, if \code{TRUE}, the values are returned as character
vector, not as list. Duplicated values are removed.}

\item{...}{Currently not used.}

\item{component}{Which type of parameters to return, such as parameters for
the conditional model, the zero-inflated part of the model, the dispersion
term, the instrumental variables or marginal effects be returned? Applies to
models with zero-inflated and/or dispersion formula, or to models with
instrumental variables (so called fixed-effects regressions), or models with
marginal effects (from \strong{mfx}). See details in section \emph{Model Components}
.May be abbreviated. Note that the \emph{conditional} component also refers to the
\emph{count} or \emph{mean} component - names may differ, depending on the modeling
package. There are three convenient shortcuts (not applicable to \emph{all} model
classes):
\itemize{
\item \code{component = "all"} returns all possible parameters.
\item If \code{component = "location"}, location parameters such as \code{conditional},
\code{zero_inflated}, \code{smooth_terms}, or \code{instruments} are returned (everything
that are fixed or random effects - depending on the \code{effects} argument -
but no auxiliary parameters).
\item For \code{component = "distributional"} (or \code{"auxiliary"}), components like
\code{sigma}, \code{dispersion}, \code{beta} or \code{precision} (and other auxiliary
parameters) are returned.
}}
}
\value{
A list of parameter names. The returned list may have following
elements:
\itemize{
\item \code{conditional}, the "fixed effects" part from the model.
\item \code{smooth_terms}, the smooth parameters.
}
}
\description{
Returns the names of model parameters, like they typically
appear in the \code{summary()} output.
}
\examples{
\dontshow{if (requireNamespace("mgcv", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
data(mtcars)
m <- mgcv::gam(mpg ~ s(hp) + gear, data = mtcars)
find_parameters(m)
\dontshow{\}) # examplesIf}
}
