% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colAvgsPerRowSet,xgCMatrix-method}
\alias{colAvgsPerRowSet,xgCMatrix-method}
\alias{colAvgsPerRowSet}
\alias{rowAvgsPerColSet,xgCMatrix-method}
\title{Calculates for each row (column) a summary statistic for equally sized subsets of columns (rows)}
\usage{
\S4method{colAvgsPerRowSet}{xgCMatrix}(
  X,
  W = NULL,
  cols = NULL,
  S,
  FUN = colMeans2,
  ...,
  na.rm = NA,
  tFUN = FALSE
)

\S4method{rowAvgsPerColSet}{xgCMatrix}(
  X,
  W = NULL,
  rows = NULL,
  S,
  FUN = rowMeans2,
  ...,
  na.rm = NA,
  tFUN = FALSE
)
}
\arguments{
\item{X}{An \code{NxM} matrix-like object.}

\item{W}{An optional numeric \code{NxM} matrix of weights.}

\item{cols}{A \code{\link{vector}} indicating the subset (and/or
columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{S}{An \link{integer} \code{KxJ} matrix that specifying the \code{J} subsets. Each
column hold \code{K} column (row) indices for the corresponding subset. The
range of values is [1, M] ([1,N]).}

\item{FUN}{A row-by-row (column-by-column) summary statistic function. It is
applied to to each column (row) subset of \code{X} that is specified by \code{S}.}

\item{...}{Additional arguments passed to \code{FUN}.}

\item{na.rm}{(logical) Argument passed to \code{FUN()} as \code{na.rm = na.rm}.
If \code{NA} (default), then \code{na.rm = TRUE} is used if \code{X} or \code{S} holds missing values,
otherwise \code{na.rm = FALSE}.}

\item{tFUN}{If \code{TRUE}, \code{X} is transposed before it is passed to \code{FUN}.}

\item{rows}{A \code{\link{vector}} indicating the subset (and/or
columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}
}
\value{
Returns a numeric \code{JxN} (\code{MxJ}) matrix.
}
\description{
Calculates for each row (column) a summary statistic for equally sized subsets of columns (rows)
}
\details{
**Note**: the handling of missing parameters differs from
  [matrixStats::colAvgsPerRowSet()]. The `matrixStats` version
  always removes `NA`'s if there are any in the data. This method
  however does whatever is passed in the `...` parameter.
}
\examples{
mat <- matrix(rnorm(20), nrow = 5, ncol = 4)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  S <- matrix(1:ncol(mat), ncol = 2)
  print(S)
  
  rowAvgsPerColSet(mat, S = S, FUN = rowMeans)
  rowAvgsPerColSet(mat, S = S, FUN = rowVars)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowAvgsPerColSet]{rowAvgsPerColSet}()}
and \code{matrixStats::\link[matrixStats:rowAvgsPerColSet]{colAvgsPerRowSet}()}
which are used when the input is a \code{matrix} or \code{numeric} vector.
}
}
