% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TCSScutoff.R
\name{tcss_cutoff}
\alias{tcss_cutoff}
\title{determine the topological cutoff for TCSS method}
\usage{
tcss_cutoff(
  OrgDb = NULL,
  keytype = "ENTREZID",
  ont,
  combine_method = "max",
  ppidata
)
}
\arguments{
\item{OrgDb}{OrgDb object}

\item{keytype}{keytype}

\item{ont}{ontology : "BP", "MF", "CC"}

\item{combine_method}{"max", "BMA", "avg", "rcmax", "rcmax.avg"}

\item{ppidata}{A data.frame contains positive set and negative set.
Positive set is PPI pairs that already verified.
ppidata has three columns, column 1 and 2 are character, column 3
must be logical value:TRUE/FALSE.}
}
\value{
numeric, topological cutoff for given parameters
}
\description{
determine the topological cutoff for TCSS method
}
\examples{
\dontrun{
    library(org.Hs.eg.db)
    library(STRINGdb)

    string_db <- STRINGdb$new(version = "11.0", species = 9606,
    score_threshold = 700)
    string_proteins <- string_db$get_proteins()

    #get relationship
    ppi <- string_db$get_interactions(string_proteins$protein_external_id)

    ppi$from <- vapply(ppi$from, function(e)
                       strsplit(e, "9606.")[[1]][2], character(1))
    ppi$to <- vapply(ppi$to, function(e)
                       strsplit(e, "9606.")[[1]][2], character(1))
    len <- nrow(ppi)

    #select length
    s_len <- 100
    pos_1 <- sample(len, s_len, replace = T)
    #negative set
    pos_2 <- sample(len, s_len, replace = T)
    pos_3 <- sample(len, s_len, replace = T)
    #union as ppidata
    ppidata <- data.frame(pro1 = c(ppi$from[pos_1], ppi$from[pos_2]),
     pro2 = c(ppi$to[pos_1], ppi$to[pos_3]),
     label = c(rep(TRUE, s_len), rep(FALSE, s_len)),
     stringsAsFactors = FALSE)

    cutoff <- tcss_cutoff(OrgDb = org.Hs.eg.db, keytype = "ENSEMBLPROT",
    ont = "BP", combine_method = "max", ppidata)
}
}
