#########################################################################/**
# @RdocDocumentation "1. Dictionary"
#
# \description{
#   This part describes non-obvious terms used in this package.
#
#  \describe{
#   \item{affxparser}{The name of this package.}
#   \item{API}{Application program interface, which describes the
#     functional interface of underlying methods.}
#   \item{block}{(aka group).}
#   \item{BPMAP}{A file format containing information
#      related to the design of the tiling arrays.}
#   \item{Calvin}{A special binary file format.}
#   \item{CDF}{A file format: chip definition file.}
#   \item{CEL}{A file format: cell intensity file.}
#   \item{cell}{(aka feature) A probe.}
#   \item{cell index}{An integer that identifies a probe uniquely.}
#   \item{chip}{An array.}
#   \item{chip type}{An identifier specifying a chip design
#     uniquely, e.g. \code{"Mapping50K_Xba240"}.}
#   \item{DAT}{A file format: contains pixel intensity
#      values collected from an Affymetrix GeneArray scanner.}
#   \item{feature}{A probe.}
#   \item{Fusion SDK}{Open-source software development kit (SDK) provided
#     by Affymetrix to access their data files.}
#   \item{group}{(aka block)
#     Defines a unique subset of the cells in a unit.
#     Expression arrays typically only have one group per unit, whereas
#     SNP arrays have either two or four groups per unit, one for each of
#     the two allele times possibly repeated for both strands.}
#   \item{MM}{Mismatch-match, e.g. MM probe.}
#   \item{PGF}{A file format: probe group file.}
#   \item{TPMAP}{A file format storing the relationship between (PM,MM)
#     pairs (or PM probes) and positions on a set of sequences.}
#   \item{QC}{Quality control, e.g. QC probes and QC probe sets.}
#   \item{unit}{A probeset.}
#   \item{XDA}{A file format, aka as the binary file format.}
#  }
# }
#*/#########################################################################
