/* 
 * Copyright 2013 ClinRisk Ltd.
 * 
 * This file is part of QRISK2-2013 (http://qrisk.org, http://svn.clinrisk.co.uk/opensource/qrisk2).
 * 
 * QRISK2-2013 is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * QRISK2-2013 is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with QRISK2-2013.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Additional terms
 * 
 * The following disclaimer must be displayed alongside any risk score generated by this code.
 *   The initial version of this file, to be found at http://svn.clinrisk.co.uk/opensource/qrisk2, faithfully implements QRISK2-2013.
 *   We have released this code under the GNU Lesser General Public License to enable others to implement the algorithm faithfully.
 *   However, the nature of the GNU Lesser General Public License is such that we cannot prevent, for example, someone accidentally 
 *   altering the coefficients, getting the inputs wrong, or just poor programming.
 *   We stress, therefore, that it is the responsibility of the end user to check that the source that they receive produces the same results as the original code posted at http://svn.clinrisk.co.uk/opensource/qrisk2.
 *   Inaccurate implementations of risk scores can lead to wrong patients being given the wrong treatment.
 * 
 * This file has been auto-generated.
 * XML source: Q77_qrisk2_2013_1.xml
 * STATA dta time stamp: 16 Nov 2012 22:10
 * This file was created on: Wed  8 May 2013 07:41:42 BST
 */

#include <math.h>
#include <string.h>
#include <clinrisk/Q77_qrisk2_2013_1.h>
#include <clinrisk/utils.h>

static double cvd_male_raw(
int age,int b_AF,int b_ra,int b_renal,int b_treatedhyp,int b_type1,int b_type2,double bmi,int ethrisk,int fh_cvd,double rati,double sbp,int smoke_cat,int surv,double town
)
{
	double survivor[16] = {
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0,
		0.978206992149353,
		0,
		0,
		0,
		0,
		0
	};

	/* The conditional arrays */

	double Iethrisk[10] = {
		0,
		0,
		0.2455190496467173600000000,
		0.5660101891908698700000000,
		0.5071774786941407600000000,
		0.1389394355409972500000000,
		-0.3741460040971635900000000,
		-0.4569877668572746000000000,
		-0.3980300277796868800000000,
		-0.2458314247118184900000000
	};
	double Ismoke[5] = {
		0,
		0.2733747359324866800000000,
		0.5613178495903169400000000,
		0.6862483380221766600000000,
		0.8089648612880009400000000
	};

	/* Applying the fractional polynomial transforms */
	/* (which includes scaling)                      */

	double dage = age;
	dage=dage/10;
	double age_1 = pow(dage,-1);
	double age_2 = pow(dage,2);
	double dbmi = bmi;
	dbmi=dbmi/10;
	double bmi_1 = pow(dbmi,-2);
	double bmi_2 = pow(dbmi,-2)*log(dbmi);

	/* Centring the continuous variables */

	age_1 = age_1 - 0.229260012507439;
	age_2 = age_2 - 19.025821685791016;
	bmi_1 = bmi_1 - 0.146091341972351;
	bmi_2 = bmi_2 - 0.140505045652390;
	rati = rati - 4.400725841522217;
	sbp = sbp - 131.575469970703120;
	town = town - 0.002737425966188;

	/* Start of Sum */
	double a=0;

	/* The conditional sums */

	a += Iethrisk[ethrisk];
	a += Ismoke[smoke_cat];

	/* Sum from continuous values */

	a += age_1 * -19.4666173334122840000000000;
	a += age_2 * 0.0201364267507625730000000;
	a += bmi_1 * 1.3830867611940247000000000;
	a += bmi_2 * -7.1627340311445842000000000;
	a += rati * 0.1533097330217813300000000;
	a += sbp * 0.0099543428482831708000000;
	a += town * 0.0320608645752168620000000;

	/* Sum from boolean values */

	a += b_AF * 0.8561770660317954400000000;
	a += b_ra * 0.3295853885133138700000000;
	a += b_renal * 0.7661782832063270800000000;
	a += b_treatedhyp * 0.6570994445804946300000000;
	a += b_type1 * 1.2235901893205057000000000;
	a += b_type2 * 0.8201160328780074900000000;
	a += fh_cvd * 0.6962022338056947900000000;

	/* Sum from interaction terms */

	a += age_1 * (smoke_cat==1) * 0.7675246688050250100000000;
	a += age_1 * (smoke_cat==2) * 0.7287918369962067500000000;
	a += age_1 * (smoke_cat==3) * 3.2938032311654148000000000;
	a += age_1 * (smoke_cat==4) * 3.6962686629926185000000000;
	a += age_1 * b_AF * 6.8279483425030065000000000;
	a += age_1 * b_renal * -1.2499862850572443000000000;
	a += age_1 * b_treatedhyp * 6.8793023059229004000000000;
	a += age_1 * b_type1 * 2.5566900730730104000000000;
	a += age_1 * b_type2 * 2.5043645216873411000000000;
	a += age_1 * bmi_1 * 46.1982485629838000000000000;
	a += age_1 * bmi_2 * -169.4442164713507000000000000;
	a += age_1 * fh_cvd * 2.5891954185540058000000000;
	a += age_1 * sbp * 0.0328765577798371750000000;
	a += age_1 * town * -0.0039873285944521386000000;
	a += age_2 * (smoke_cat==1) * -0.0028190973036285923000000;
	a += age_2 * (smoke_cat==2) * -0.0074290549312194289000000;
	a += age_2 * (smoke_cat==3) * 0.0006623943592407952700000;
	a += age_2 * (smoke_cat==4) * -0.0009539165087934006100000;
	a += age_2 * b_AF * 0.0051545540015502968000000;
	a += age_2 * b_renal * -0.0190484751944149380000000;
	a += age_2 * b_treatedhyp * 0.0042514995185120022000000;
	a += age_2 * b_type1 * -0.0029641180896136064000000;
	a += age_2 * b_type2 * -0.0049052623533052224000000;
	a += age_2 * bmi_1 * 0.1174445082068387000000000;
	a += age_2 * bmi_2 * -0.3493064079001478300000000;
	a += age_2 * fh_cvd * -0.0059689380584026352000000;
	a += age_2 * sbp * -0.0001231469495691592500000;
	a += age_2 * town * -0.0008493525147140088800000;

	/* Calculate the score itself */
	double score = 100.0 * (1 - pow(survivor[surv], exp(a)) );
	return score;
}

static int cvd_male_validation(
int age,int b_AF,int b_ra,int b_renal,int b_treatedhyp,int b_type1,int b_type2,double bmi,int ethrisk,int fh_cvd,double rati,double sbp,int smoke_cat,int surv,double town,char *errorBuf,int errorBufSize
)
{
	int ok=1;
	*errorBuf=0;
	if (!i_in_range(age,25,84)) {
		ok=0;
		strlcat(errorBuf,"error: age must be in range (25,84)\n",errorBufSize);
	}
	if (!is_boolean(b_AF)) {
		ok=0;
		strlcat(errorBuf,"error: b_AF must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_ra)) {
		ok=0;
		strlcat(errorBuf,"error: b_ra must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_renal)) {
		ok=0;
		strlcat(errorBuf,"error: b_renal must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_treatedhyp)) {
		ok=0;
		strlcat(errorBuf,"error: b_treatedhyp must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_type1)) {
		ok=0;
		strlcat(errorBuf,"error: b_type1 must be in range (0,1)\n",errorBufSize);
	}
	if (!is_boolean(b_type2)) {
		ok=0;
		strlcat(errorBuf,"error: b_type2 must be in range (0,1)\n",errorBufSize);
	}
	if (!d_in_range(bmi,20,40)) {
		ok=0;
		strlcat(errorBuf,"error: bmi must be in range (20,40)\n",errorBufSize);
	}
	if (!i_in_range(ethrisk,1,9)) {
		ok=0;
		strlcat(errorBuf,"error: ethrisk must be in range (1,9)\n",errorBufSize);
	}
	if (!is_boolean(fh_cvd)) {
		ok=0;
		strlcat(errorBuf,"error: fh_cvd must be in range (0,1)\n",errorBufSize);
	}
	if (!d_in_range(rati,1,12)) {
		ok=0;
		strlcat(errorBuf,"error: rati must be in range (1,12)\n",errorBufSize);
	}
	if (!d_in_range(sbp,70,210)) {
		ok=0;
		strlcat(errorBuf,"error: sbp must be in range (70,210)\n",errorBufSize);
	}
	if (!i_in_range(smoke_cat,0,4)) {
		ok=0;
		strlcat(errorBuf,"error: smoke_cat must be in range (0,4)\n",errorBufSize);
	}
	if (surv!=10) {
		ok=0;
		strlcat(errorBuf,"error: surv must be 10\n",errorBufSize);
	}
	if (!d_in_range(town,-7,11)) {
		ok=0;
		strlcat(errorBuf,"error: town must be in range (-7,11)\n",errorBufSize);
	}
	return ok;
}

double cvd_male(
int age,int b_AF,int b_ra,int b_renal,int b_treatedhyp,int b_type1,int b_type2,double bmi,int ethrisk,int fh_cvd,double rati,double sbp,int smoke_cat,int surv,double town,int *error,char *errorBuf,int errorBufSize
)
{
	*error = 0;	int ok = cvd_male_validation(age,b_AF,b_ra,b_renal,b_treatedhyp,b_type1,b_type2,bmi,ethrisk,fh_cvd,rati,sbp,smoke_cat,surv,town,errorBuf,errorBufSize);
	if(!ok) { 
		*error = 1;
		return 0.0;
	}
	return cvd_male_raw(age,b_AF,b_ra,b_renal,b_treatedhyp,b_type1,b_type2,bmi,ethrisk,fh_cvd,rati,sbp,smoke_cat,surv,town);
}
