# Configuration switches for SCP-firmware:
#
# CFG_SCMI_SCPFW Boolean switch, embeds SCP-firmware SCMI stack when enabled.
# CFG_SCMI_SCPFW_PRODUCT Name of the SCP-firmware product to build.
# CFG_SCP_FIRMWARE Directory path to SCP-firmware source tree
# CFG_SCPFW_LOG_LEVEL SCP-firmware log level
# CFG_SCPFW_MOD_x Boolean switch, embeds SCP-firmware module x when enabled
# CFG_SCPFW_NOTIFICATION Boolean switch, embeds SCMI notification when enabled.
# CFG_SCPFW_FAST_CHANNELS Boolean switch, embeds SCMI fast channel when enabled.
#
# Boolean y|n switches for module features
# CFG_SCPFW_CLOCK_TREE_MGMT
# CFG_SCPFW_SCMI_PERF_FAST_CHANNELS
# CFG_SCPFW_SCMI_SENSOR_EVENTS
# CFG_SCPFW_SCMI_SENSOR_V2
# CFG_SCPFW_SENSOR_TIMESTAMP
# CFG_SCPFW_SENSOR_MULTI_AXIS
# CFG_SCPFW_SENSOR_EXT_ATTRIBS
# CFG_SCPFW_SENSOR_SIGNED_VALUE

include core/lib/scmi-server/conf-optee-$(CFG_SCMI_SCPFW_PRODUCT).mk

# SCP-fmw log level: 0 trace/verbose, 1 info, 2 warning, 3 error, 4 critical
ifeq ($(CFG_TEE_CORE_LOG_LEVEL),0)
CFG_SCPFW_LOG_LEVEL ?= 3
else ifeq ($(CFG_TEE_CORE_LOG_LEVEL),1)
CFG_SCPFW_LOG_LEVEL ?= 3
else ifeq ($(CFG_TEE_CORE_LOG_LEVEL),2)
CFG_SCPFW_LOG_LEVEL ?= 1
else
CFG_SCPFW_LOG_LEVEL ?= 0
endif

CFG_SCPFW_MOD_DVFS ?= n
CFG_SCPFW_MOD_RESET_DOMAIN ?= n
CFG_SCPFW_MOD_CLOCK ?= n
CFG_SCPFW_MOD_MSG_SMT ?= n
CFG_SCPFW_MOD_MOCK_CLOCK ?= n
CFG_SCPFW_MOD_MOCK_PPU ?= n
CFG_SCPFW_MOD_MOCK_PSU ?= n
CFG_SCPFW_MOD_OPTEE_CLOCK ?= n
CFG_SCPFW_MOD_OPTEE_CONSOLE ?= y
CFG_SCPFW_MOD_OPTEE_MBX ?= n
CFG_SCPFW_MOD_OPTEE_RESET ?= n
CFG_SCPFW_MOD_OPTEE_SMT ?= n
CFG_SCPFW_MOD_POWER_DOMAIN ?= n
CFG_SCPFW_MOD_PSU ?= n
CFG_SCPFW_MOD_REG_SENSOR ?= n
CFG_SCPFW_MOD_SENSOR ?= n
CFG_SCPFW_MOD_SCMI ?= y
CFG_SCPFW_MOD_SCMI_APCORE ?= n
CFG_SCPFW_MOD_SCMI_CLOCK ?= n
CFG_SCPFW_MOD_SCMI_PERF ?= n
CFG_SCPFW_MOD_SCMI_POWER_DOMAIN ?= n
CFG_SCPFW_MOD_SCMI_RESET_DOMAIN ?= n
CFG_SCPFW_MOD_SCMI_SENSOR ?= n
CFG_SCPFW_MOD_SCMI_VOLTAGE_DOMAIN ?= n
CFG_SCPFW_MOD_SYSTEM_PLL ?= n
CFG_SCPFW_MOD_VOLTAGE_DOMAIN ?= n

CFG_SCPFW_NOTIFICATION ?= n
CFG_SCPFW_FAST_CHANNELS ?= n

CFG_SCPFW_CLOCK_TREE_MGMT ?= n
CFG_SCPFW_SCMI_PERF_FAST_CHANNELS ?= n
CFG_SCPFW_SCMI_SENSOR_EVENTS ?= n
CFG_SCPFW_SCMI_SENSOR_V2 ?= n
CFG_SCPFW_SENSOR_TIMESTAMP ?= n
CFG_SCPFW_SENSOR_MULTI_AXIS ?= n
CFG_SCPFW_SENSOR_EXT_ATTRIBS ?= n
CFG_SCPFW_SENSOR_SIGNED_VALUE ?= n

ifeq ($(CFG_SCPFW_MOD_OPTEE_SMT),y)
_CFG_SCMI_PTA_SMT_HEADER := y
endif
ifeq ($(CFG_SCPFW_MOD_MSG_SMT),y)
_CFG_SCMI_PTA_MSG_HEADER := y
endif
