###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_seamonkey_mult_vuln_nov09_lin.nasl 5567 2009-11-02 15:49:33Z nov $
#
# Mozilla Seamonkey Multiple Vulnerabilities Nov-09 (Linux)
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801137);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3372", "CVE-2009-3373", "CVE-2009-3376");
  script_bugtraq_id(36856, 36855, 36867);
  script_name("Mozilla Seamonkey Multiple Vulnerabilities Nov-09 (Linux)");
  desc = "
  Overview: This host is installed with Mozilla Seamonkey browser and is prone to
  multiple vulnerabilities.

  Vulnerability Insight:
  Muliple flaws exist,
  - When parsing regular expressions used in Proxy Auto-configuration. This can
    be exploited to cause a crash or potentially execute arbitrary code via
    specially crafted configured PAC files.
  - When processing GIF color maps whcich can be exploited to cause a heap based
    buffer overflow and potentially execute arbitrary code via a specially
    crafted GIF file.
  - An error when downloading files can be exploited to display different file
    names in the download dialog title bar and download dialog body. This can
    be exploited to obfuscate file names via a right-to-left override character
    and potentially trick a user into running an executable file.

  Impact:
  Successful exploitation will let attacker to disclose sensitive information,
  bypass certain security restrictions, manipulate certain data, or compromise
  a user's system.

  Impact Level: Application/System

  Affected Software/OS:
  Mozilla Seamonkey version prior to 2.0 on Linux.

  Fix: Upgrade to Seamonkey version 2.0,
  http://www.seamonkey-project.org/releases

  References:
  http://secunia.com/secunia_research/2009-35/
  http://www.mozilla.org/security/announce/2009/mfsa2009-55.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-56.html
  http://www.mozilla.org/security/announce/2009/mfsa2009-62.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 7.8
  Risk factor: High";

  script_description(desc);
  script_summary("Check for the version of Mozilla Seamonkey");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_seamonkey_detect_lin.nasl");
  script_require_keys("Seamonkey/Linux/Ver");
  exit(0);
}


include("version_func.inc");

smVer = get_kb_item("Seamonkey/Linux/Ver");
if(!smVer){
  exit(0);
}

# Check for Seamonkey version < 2.0
if(version_is_less(version:smVer, test_version:"2.0")){
  security_hole(0);
}
