###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_qip_detect.nasl 832 2009-03-17 10:40:24Z mar $
#
# QIP Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800540);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("QIP Version Detection");
  desc = "
  Overview : This script detects the QIP version and saves the result in KB.

  Risk factor : None";

  script_description(desc);
  script_summary("Set the KB for the Version of QIP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";

if(!registry_key_exists(key:key)){
    exit(0);
}

foreach item (registry_enum_keys(key:key))
{
  qipName = registry_get_sz(key:key + item, item:"DisplayName");
  if(qipName =~ "QIP ([0-9]+)")
  {
    qipPath = registry_get_sz(key:key + item, item:"UninstallString");
    if(qipPath == NULL){
      exit(0);
    }
    qipPath = ereg_replace(pattern:'\"(.*)\"', replace:"\1", string:qipPath);
    qipPath = qipPath - "unqip.exe" - "unins000.exe" + "qip.exe";

    share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:qipPath);
    file = ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:qipPath);
    qipVer = GetVer(file:file, share:share);

    if(qipVer)
    {
      set_kb_item(name:"QIP/Version", value:qipVer);
      security_note(data:"QIP version " + qipVer + 
                         " running at location " + qipPath +
                         " was detected on the host");
    }
    exit(0);
  }
}
