###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for x11-server MDVA-2008:126 (x11-server)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830442);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2008:126");
  script_name( "Mandriva Update for x11-server MDVA-2008:126 (x11-server)");
  desc = "

  Vulnerability Insight:

  A Xvnc server running in 16 bpp depth would crash when a client with
  16 bpp depth connected. Also, keyboard behaviour was incorrect when
  the X server was run with Xkb extension disabled.
  
  This update fixes both issues.

  Affected Software/OS:
  x11-server on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-09/msg00023.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of x11-server");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"x11-server", rpm:"x11-server~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-common", rpm:"x11-server-common~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-devel", rpm:"x11-server-devel~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xati", rpm:"x11-server-xati~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xchips", rpm:"x11-server-xchips~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xephyr", rpm:"x11-server-xephyr~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xepson", rpm:"x11-server-xepson~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xfake", rpm:"x11-server-xfake~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xfbdev", rpm:"x11-server-xfbdev~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xi810", rpm:"x11-server-xi810~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xmach64", rpm:"x11-server-xmach64~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xmga", rpm:"x11-server-xmga~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xnest", rpm:"x11-server-xnest~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xnvidia", rpm:"x11-server-xnvidia~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xorg", rpm:"x11-server-xorg~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xpm2", rpm:"x11-server-xpm2~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xr128", rpm:"x11-server-xr128~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xsdl", rpm:"x11-server-xsdl~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xsmi", rpm:"x11-server-xsmi~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvesa", rpm:"x11-server-xvesa~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvfb", rpm:"x11-server-xvfb~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvia", rpm:"x11-server-xvia~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"x11-server-xvnc", rpm:"x11-server-xvnc~1.4.0.90~14.4mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}