###############################################################################
# OpenVAS Vulnerability Test
#
# CentOS Update for mysql CESA-2007:1155 centos4 i386
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(880324);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "CESA", value: "2007:1155");
  script_cve_id("CVE-2007-5969", "CVE-2007-5925");
  script_name( "CentOS Update for mysql CESA-2007:1155 centos4 i386");
  desc = "

  Vulnerability Insight:
  MySQL is a multi-user, multi-threaded SQL database server. MySQL is a
  client/server implementation consisting of a server daemon (mysqld), and
  many different client programs and libraries.
  
  A flaw was found in a way MySQL handled symbolic links when database tables
  were created with explicit &quot;DATA&quot; and &quot;INDEX DIRECTORY&quot; options. An
  authenticated user could create a table that would overwrite tables in
  other databases, causing destruction of data or allowing the user to
  elevate privileges. (CVE-2007-5969)
  
  A flaw was found in a way MySQL's InnoDB engine handled spatial indexes. An
  authenticated user could create a table with spatial indexes, which are not
  supported by the InnoDB engine, that would cause the mysql daemon to crash
  when used. This issue only causes a temporary denial of service, as the
  mysql daemon will be automatically restarted after the crash.
  (CVE-2007-5925)
  
  All mysql users are advised to upgrade to these updated packages, which
  contain backported patches to resolve these issues.


  Affected Software/OS:
  mysql on CentOS 4

  Fix: Please Install the Updated Packages.

  References:
  http://lists.centos.org/pipermail/centos-announce/2007-December/014525.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of mysql");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("CentOS Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "CentOS4")
{

  if(isrpmvuln(pkg:"mysql", rpm:"mysql~4.1.20~3.RHEL4.1.el4_6.1", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-bench", rpm:"mysql-bench~4.1.20~3.RHEL4.1.el4_6.1", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-devel", rpm:"mysql-devel~4.1.20~3.RHEL4.1.el4_6.1", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  if(isrpmvuln(pkg:"mysql-server", rpm:"mysql-server~4.1.20~3.RHEL4.1.el4_6.1", rls:"CentOS4"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}
