#
#VID 5d425189-7a03-11d9-a9e7-0001020eed82
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52194);
 script_cve_id("CVE-2005-0227");
 script_bugtraq_id(12411);
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: postgresql, postgresql-server, ja-postgresql";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following packages are affected:
   postgresql
   postgresql-server
   ja-postgresql
   postgresql-devel

CVE-2005-0227
PostgreSQL (pgsql) 7.4.x, 7.2.x, and other versions allows local users
to load arbitrary shared libraries and execute code via the LOAD
extension.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://archives.postgresql.org/pgsql-announce/2005-02/msg00000.php
http://archives.postgresql.org/pgsql-bugs/2005-01/msg00269.php
http://www.vuxml.org/freebsd/5d425189-7a03-11d9-a9e7-0001020eed82.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: postgresql, postgresql-server, ja-postgresql";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"postgresql");
if(!isnull(bver) && revcomp(a:bver, b:"7.3.9")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>0 && revcomp(a:bver, b:"7.4.7")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8")>0 && revcomp(a:bver, b:"8.0.1")<0) {
    security_note(0, data:"Package postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"postgresql-server");
if(!isnull(bver) && revcomp(a:bver, b:"7.3.9")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>0 && revcomp(a:bver, b:"7.4.7")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8")>0 && revcomp(a:bver, b:"8.0.1")<0) {
    security_note(0, data:"Package postgresql-server version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"ja-postgresql");
if(!isnull(bver) && revcomp(a:bver, b:"7.3.9")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"7.4")>0 && revcomp(a:bver, b:"7.4.7")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
if(!isnull(bver) && revcomp(a:bver, b:"8")>0 && revcomp(a:bver, b:"8.0.1")<0) {
    security_note(0, data:"Package ja-postgresql version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}
bver = portver(pkg:"postgresql-devel");
if(!isnull(bver) && revcomp(a:bver, b:"8.0.1,1")<=0) {
    security_note(0, data:"Package postgresql-devel version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
