MACRO(GENERATE_VERSION_INFO)
    FIND_PROGRAM(SVNVERSION "svnversion")
    MARK_AS_ADVANCED(SVNVERSION)
    IF (SVNVERSION)
        EXECUTE_PROCESS(
            COMMAND ${SVNVERSION} "-n"
            WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}
            OUTPUT_VARIABLE REVISION_NUMBER)
    ELSE()
        SET(REVISION_NUMBER "unknown")
    ENDIF()
    SET(VERSION_STRING "${CPACK_PACKAGE_VERSION_MAJOR}.${CPACK_PACKAGE_VERSION_MINOR}.${CPACK_PACKAGE_VERSION_PATCH} (${REVISION_NUMBER})")
ENDMACRO()
