/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.    
 */
package org.apache.openjpa.persistence.jdbc.query.domain;

import java.sql.Timestamp;
import java.util.Date;

import javax.persistence.*;

/**
 * Simple persistent entity as a target of bi-directional one-to-one 
 * association.
 * 
 * @author Pinaki Poddar
 *
 */
@Entity
@Table(name="MAG_DOMAIN")
public class Magazine {
	@Id
	@GeneratedValue
	private long id;

	private String name;
	
	@OneToOne
	private Publisher publisher;

	private Date datePublished;

	private Timestamp tsPublished;
	
	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public long getId() {
		return id;
	}

	public Publisher getPublisher() {
		return publisher;
	}

	public void setPublisher(Publisher publisher) {
		this.publisher = publisher;
	}

	public Date getDatePublished() {
		return datePublished;
	}

	public void setDatePublished(Date datePublished) {
		this.datePublished = datePublished;
	}

	public Date getTsPublished() {
		return tsPublished;
	}

	public void setTsPublished(Timestamp tsPublished) {
		this.tsPublished = tsPublished;
	}
	
}
