
namespace Test {
  void check(bool test , output int errorcount)
  {
    if( !test )
    {
      ++errorcount;
    }
  }
  void checkIntEqual( int i1, int i2, output int errorcount)
  {
    if( i1 != i2)
    {
      print(i1, "!=", i2);
      ++errorcount;
    }
  }
  void checkNearEqualVec( float f1[3], float f2[3], output int errorcount)
  {
    for( int k = 0; k < 3; ++k)
    {
      float diff = f1[k] - f2[k];
      if( diff > 10e-3 || (-diff > 10e-3))
      {
        print(k, f1[k], f2[k], diff);
        ++errorcount;
      }
    }
  }
  void checkNearEqualMat( float f1[][], float f2[][], output int errorcount)
  {
    for( int i = 0; i < f1.size; ++i)
    {
      if( f1[i].size == f2[i].size )
      {
        for( int j = 0; j < f1[i].size; ++j )
        {
          float diff = f1[i][j] - f2[i][j];
          if( diff > 10e-3 || (-diff > 10e-3))
          {
            print(i, j, f1[i][j], f2[i][j], diff);
            ++errorcount;
          }
        }
      } else {
        print( i, " different size ", f1[i].size, f2[i].size );
        ++errorcount;
      }
    }
  }
  void checkNearEqual( float f1, float f2, output int errorcount)
  {
    float diff = f1 - f2;
    if( diff > 10e-3 || (-diff > 10e-3))
    {
      print(f1, f2, diff);
      ++errorcount;
    }
  }
}
