// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _MAT_Graph_HeaderFile
#define _MAT_Graph_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineHandle_HeaderFile
#include <Standard_DefineHandle.hxx>
#endif
#ifndef _Handle_MAT_Graph_HeaderFile
#include <Handle_MAT_Graph.hxx>
#endif

#ifndef _MAT_DataMapOfIntegerArc_HeaderFile
#include <MAT_DataMapOfIntegerArc.hxx>
#endif
#ifndef _MAT_DataMapOfIntegerBasicElt_HeaderFile
#include <MAT_DataMapOfIntegerBasicElt.hxx>
#endif
#ifndef _MAT_DataMapOfIntegerNode_HeaderFile
#include <MAT_DataMapOfIntegerNode.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _MMgt_TShared_HeaderFile
#include <MMgt_TShared.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_MAT_ListOfBisector_HeaderFile
#include <Handle_MAT_ListOfBisector.hxx>
#endif
#ifndef _Handle_MAT_Arc_HeaderFile
#include <Handle_MAT_Arc.hxx>
#endif
#ifndef _Handle_MAT_BasicElt_HeaderFile
#include <Handle_MAT_BasicElt.hxx>
#endif
#ifndef _Handle_MAT_Node_HeaderFile
#include <Handle_MAT_Node.hxx>
#endif
class MAT_ListOfBisector;
class MAT_Arc;
class MAT_BasicElt;
class MAT_Node;
class MAT_DataMapOfIntegerBasicElt;


//! The Class Graph permits the exploration of the <br>
//!          Bisector Locus. <br>
class MAT_Graph : public MMgt_TShared {

public:

  //! Empty constructor. <br>
  Standard_EXPORT   MAT_Graph();
  //! Construct <me> from the result of the method <br>
//!            <CreateMat> of the class <MAT> from <MAT>. <br>
//! <br>
//!            <SemiInfinite> : if some bisector are infinites. <br>
//!            <TheRoots>     : Set of the bisectors. <br>
//!            <NbBasicElts>  : Number of Basic Elements. <br>
//!            <NbArcs>       : Number of Arcs = Number of Bisectors. <br>
  Standard_EXPORT     void Perform(const Standard_Boolean SemiInfinite,const Handle(MAT_ListOfBisector)& TheRoots,const Standard_Integer NbBasicElts,const Standard_Integer NbArcs) ;
  //! Return the Arc of index <Index> in <theArcs>. <br>
  Standard_EXPORT     Handle_MAT_Arc Arc(const Standard_Integer Index) const;
  //! Return the BasicElt of index <Index> in <theBasicElts>. <br>
  Standard_EXPORT     Handle_MAT_BasicElt BasicElt(const Standard_Integer Index) const;
  //! Return the Node of index <Index> in <theNodes>. <br>
  Standard_EXPORT     Handle_MAT_Node Node(const Standard_Integer Index) const;
  //! Return the number of arcs of <me>. <br>
  Standard_EXPORT     Standard_Integer NumberOfArcs() const;
  //! Return the number of nodes of <me>. <br>
  Standard_EXPORT     Standard_Integer NumberOfNodes() const;
  //! Return the number of basic elements of <me>. <br>
  Standard_EXPORT     Standard_Integer NumberOfBasicElts() const;
  //! Return the number of infinites nodes of <me>. <br>
  Standard_EXPORT     Standard_Integer NumberOfInfiniteNodes() const;
  //! Merge two BasicElts.  The End of the BasicElt Elt1 <br>
//!          of  IndexElt1 becomes The End of the BasicElt Elt2 <br>
//!          of  IndexElt2.   Elt2 is replaced in  the  arcs  by <br>
//!          Elt1, Elt2 is eliminated. <br>
//! <br>
//!          <MergeArc1> is True  if the fusion  of the BasicElts  => <br>
//!          a fusion  of two Arcs which separated  the same  elements. <br>
//!          In this case <GeomIndexArc1> and  <GeomIndexArc2>  are the <br>
//!          Geometric  Index of this  arcs. <br>
//! <br>
//!          If the  BasicElt corresponds to a close line , <br>
//!          the StartArc and the EndArc of Elt1 can separate the same <br>
//!          elements . <br>
//!          In this case there is a fusion of this arcs, <MergeArc2> <br>
//!          is true and <GeomIndexArc3> and  <GeomIndexArc4>  are the <br>
//!          Geometric  Index of this  arcs. <br>
  Standard_EXPORT     void FusionOfBasicElts(const Standard_Integer IndexElt1,const Standard_Integer IndexElt2,Standard_Boolean& MergeArc1,Standard_Integer& GeomIndexArc1,Standard_Integer& GeomIndexArc2,Standard_Boolean& MergeArc2,Standard_Integer& GeomIndexArc3,Standard_Integer& GeomIndexArc4) ;
  
  Standard_EXPORT     void CompactArcs() ;
  
  Standard_EXPORT     void CompactNodes() ;
  
  Standard_EXPORT     void ChangeBasicElts(const MAT_DataMapOfIntegerBasicElt& NewMap) ;
  
  Standard_EXPORT     Handle_MAT_BasicElt ChangeBasicElt(const Standard_Integer Index) ;




  DEFINE_STANDARD_RTTI(MAT_Graph)

protected:




private: 

  //! Merge two Arcs.  the second node of <Arc2> becomes <br>
//!          the  first node  of <Arc1>.  Update  of the  first <br>
//!          node and the neighbours of <Arc1>. <br>
//!          <Arc2> is eliminated. <br>
  Standard_EXPORT     void FusionOfArcs(const Handle(MAT_Arc)& Arc1,const Handle(MAT_Arc)& Arc2) ;
  
  Standard_EXPORT     void UpDateNodes(Standard_Integer& Index) ;

MAT_DataMapOfIntegerArc theArcs;
MAT_DataMapOfIntegerBasicElt theBasicElts;
MAT_DataMapOfIntegerNode theNodes;
Standard_Integer numberOfArcs;
Standard_Integer numberOfNodes;
Standard_Integer numberOfBasicElts;
Standard_Integer numberOfInfiniteNodes;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
