// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _IGESData_GlobalSection_HeaderFile
#define _IGESData_GlobalSection_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Character_HeaderFile
#include <Standard_Character.hxx>
#endif
#ifndef _Handle_TCollection_HAsciiString_HeaderFile
#include <Handle_TCollection_HAsciiString.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Interface_ParamSet_HeaderFile
#include <Handle_Interface_ParamSet.hxx>
#endif
#ifndef _Handle_Interface_Check_HeaderFile
#include <Handle_Interface_Check.hxx>
#endif
class TCollection_HAsciiString;
class Interface_ParamSet;
class Interface_Check;
class gp_XYZ;


//! Description of a global section (corresponds to file header) <br>
//!           used as well in IGESModel, IGESReader and IGESWriter <br>
//!           Warning : From IGES-5.1, a parameter is added : LastChangeDate (concerns <br>
//!           transferred set of data, not the file itself) <br>
//!           Of course, it can be absent if read from earlier versions <br>
//!           (a default is then to be set to current date) <br>
//!           From 5.3, one more : ApplicationProtocol (optional) <br>
class IGESData_GlobalSection  {
public:

  DEFINE_STANDARD_ALLOC

  //! Creates an empty GlobalSection, ready to be filled, <br>
//!  Warning : No default value is provided <br>
  Standard_EXPORT   IGESData_GlobalSection();
  //! Fills GlobalSection from a ParamSet (i.e. taken from file) <br>
//!           undefined parameters do not change default values when defined <br>
//!           Fills Check about Corrections or Fails <br>
  Standard_EXPORT     void Init(const Handle(Interface_ParamSet)& params,Handle(Interface_Check)& ach) ;
  //! Copies data referenced by Handle (that is, Strings) <br>
//!           usefull to "isolate" a GlobalSection after copy by "=" <br>
//!           (from a Model to another Model for instance) <br>
  Standard_EXPORT     void CopyRefs() ;
  //! Returns all contained data in the form of a ParamSet <br>
//!           Remark : Strings are given under Hollerith form <br>
  Standard_EXPORT     Handle_Interface_ParamSet Params() const;
  //! Returns a string withpout its Hollerith marks (nnnH ahead). <br>
//!           Remark : all strings stored in GlobalSection are expurged <br>
//!           from Hollerith informations (without nnnH) <br>
//!           If <astr> is not Hollerith form, it is simply copied <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString TranslatedFromHollerith(const Handle(TCollection_HAsciiString)& astr) const;
  //! Returns the parameter delimiter character. <br>
  Standard_EXPORT     Standard_Character Separator() const;
  //!  Returns the record delimiter character. <br>
  Standard_EXPORT     Standard_Character EndMark() const;
  //! Returns the name of the sending system. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString SendName() const;
  //! Returns the name of the IGES file. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString FileName() const;
  //! Returns the Native System ID of the system that created the IGES file. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString SystemId() const;
  //! Returns the name of the pre-processor used to write the IGES file. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString InterfaceVersion() const;
  //! Returns the number of binary bits for integer representations. <br>
  Standard_EXPORT     Standard_Integer IntegerBits() const;
  //! Returns the maximum power of a decimal representation of a <br>
//!          single-precision floating point number in the sending system. <br>
  Standard_EXPORT     Standard_Integer MaxPower10Single() const;
  
  Standard_EXPORT     Standard_Integer MaxDigitsSingle() const;
  //! Returns the maximum power of a decimal representation of a <br>
//!           double-precision floating point number in the sending system. <br>
  Standard_EXPORT     Standard_Integer MaxPower10Double() const;
  
  Standard_EXPORT     Standard_Integer MaxDigitsDouble() const;
  //! Returns the name of the receiving system. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString ReceiveName() const;
  //! Returns the scale used in the IGES file. <br>
  Standard_EXPORT     Standard_Real Scale() const;
  //! Returns the unit flag that was used to write the IGES file. <br>
  Standard_EXPORT     Standard_Integer UnitFlag() const;
  //! Returns the name of the unit the IGES file was written in. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString UnitName() const;
  //! Returns the maximum number of line weight gradations. <br>
  Standard_EXPORT     Standard_Integer LineWeightGrad() const;
  //! Returns the of maximum line weight width in IGES file units. <br>
  Standard_EXPORT     Standard_Real MaxLineWeight() const;
  //! Returns the IGES file creation date. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString Date() const;
  //! Returns the resolution used in the IGES file. <br>
  Standard_EXPORT     Standard_Real Resolution() const;
  //! Returns the approximate maximum coordinate value found in the model. <br>
  Standard_EXPORT     Standard_Real MaxCoord() const;
  //! Returns True if the approximate maximum coordinate value found in <br>
//!          the model is greater than 0. <br>
  Standard_EXPORT     Standard_Boolean HasMaxCoord() const;
  //! Returns the name of the IGES file author. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString AuthorName() const;
  //! Returns the name of the company where the IGES file was written. <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString CompanyName() const;
  //! Returns the IGES version that the IGES file was written in. <br>
  Standard_EXPORT     Standard_Integer IGESVersion() const;
  
  Standard_EXPORT     Standard_Integer DraftingStandard() const;
  //! Returns the date and time when the model was created or last <br>
//!          modified (for IGES 5.1 and later). <br>
  Standard_EXPORT     Handle_TCollection_HAsciiString LastChangeDate() const;
  //! Returns True if the date and time when the model was created or <br>
//!           last modified are specified, i.e. not defaulted to NULL. <br>
  Standard_EXPORT     Standard_Boolean HasLastChangeDate() const;
  
  Standard_EXPORT     void SetLastChangeDate() ;
  
  Standard_EXPORT     Handle_TCollection_HAsciiString ApplicationProtocol() const;
  
  Standard_EXPORT     Standard_Boolean HasApplicationProtocol() const;
  //! Returns a string built from year, <br>
//!           month, day, hour, minute and second values. The form of the <br>
//!           resulting string is defined as follows: <br>
//!           -      -1: YYMMDD.HHNNSS, <br>
//!           -       0: YYYYMMDD.HHNNSS, <br>
//! 		 -       1: YYYY-MM-DD:HH-NN-SS, where: <br>
//! - YYYY or YY is 4 or 2 digit year, <br>
//! - HH is hour (00-23), <br>
//! - MM is month (01-12), <br>
//! - NN is minute (00-59) <br>
//! - DD is day (01-31), <br>
//! - SS is second (00-59). <br>
  Standard_EXPORT   static  Handle_TCollection_HAsciiString NewDateString(const Standard_Integer year,const Standard_Integer month,const Standard_Integer day,const Standard_Integer hour,const Standard_Integer minut,const Standard_Integer second,const Standard_Integer mode = -1) ;
  //! Converts the string given in the <br>
//!           form YYMMDD.HHNNSS or YYYYMMDD.HHNNSS to either <br>
//!           YYMMDD.HHNNSS, YYYYMMDD.HHNNSS or YYYY-MM-DD:HH-NN-SS. <br>
  Standard_EXPORT   static  Handle_TCollection_HAsciiString NewDateString(const Handle(TCollection_HAsciiString)& date,const Standard_Integer mode = 1) ;
  //! Returns the unit value (in <br>
//! meters) that the IGES file was written in. <br>
  Standard_EXPORT     Standard_Real UnitValue() const;
  
  Standard_EXPORT     void SetSeparator(const Standard_Character val) ;
  
  Standard_EXPORT     void SetEndMark(const Standard_Character val) ;
  
  Standard_EXPORT     void SetSendName(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetFileName(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetSystemId(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetInterfaceVersion(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetIntegerBits(const Standard_Integer val) ;
  
  Standard_EXPORT     void SetMaxPower10Single(const Standard_Integer val) ;
  
  Standard_EXPORT     void SetMaxDigitsSingle(const Standard_Integer val) ;
  
  Standard_EXPORT     void SetMaxPower10Double(const Standard_Integer val) ;
  
  Standard_EXPORT     void SetMaxDigitsDouble(const Standard_Integer val) ;
  
  Standard_EXPORT     void SetReceiveName(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetScale(const Standard_Real val) ;
  
  Standard_EXPORT     void SetUnitFlag(const Standard_Integer val) ;
  
  Standard_EXPORT     void SetUnitName(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetLineWeightGrad(const Standard_Integer val) ;
  
  Standard_EXPORT     void SetMaxLineWeight(const Standard_Real val) ;
  
  Standard_EXPORT     void SetDate(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetResolution(const Standard_Real val) ;
  
  Standard_EXPORT     void SetMaxCoord(const Standard_Real val = 0.0) ;
  
  Standard_EXPORT     void MaxMaxCoord(const Standard_Real val = 0.0) ;
  
  Standard_EXPORT     void MaxMaxCoords(const gp_XYZ& xyz) ;
  
  Standard_EXPORT     void SetAuthorName(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetCompanyName(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetIGESVersion(const Standard_Integer val) ;
  
  Standard_EXPORT     void SetDraftingStandard(const Standard_Integer val) ;
  
  Standard_EXPORT     void SetLastChangeDate(const Handle(TCollection_HAsciiString)& val) ;
  
  Standard_EXPORT     void SetApplicationProtocol(const Handle(TCollection_HAsciiString)& val) ;





protected:





private:



Standard_Character theSeparator;
Standard_Character theEndMark;
Handle_TCollection_HAsciiString theSendName;
Handle_TCollection_HAsciiString theFileName;
Handle_TCollection_HAsciiString theSystemId;
Handle_TCollection_HAsciiString theInterfaceVersion;
Standard_Integer theIntegerBits;
Standard_Integer theMaxPower10Single;
Standard_Integer theMaxDigitsSingle;
Standard_Integer theMaxPower10Double;
Standard_Integer theMaxDigitsDouble;
Handle_TCollection_HAsciiString theReceiveName;
Standard_Real theScale;
Standard_Integer theUnitFlag;
Handle_TCollection_HAsciiString theUnitName;
Standard_Integer theLineWeightGrad;
Standard_Real theMaxLineWeight;
Handle_TCollection_HAsciiString theDate;
Standard_Real theResolution;
Standard_Real theMaxCoord;
Standard_Boolean hasMaxCoord;
Handle_TCollection_HAsciiString theAuthorName;
Handle_TCollection_HAsciiString theCompanyName;
Standard_Integer theIGESVersion;
Standard_Integer theDraftingStandard;
Handle_TCollection_HAsciiString theLastChangeDate;
Handle_TCollection_HAsciiString theAppliProtocol;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
