#!/usr/bin/perl
#
# Copyright 2014 Chris Young <chris@unsatisfactorysoftware.co.uk>
#
# This file is part of NetSurf, http://www.netsurf-browser.org/
#
# NetSurf is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# NetSurf is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

print <<HEADER;
/* This file is generated by idna-derived-props-gen.pl
 * DO NOT EDIT BY HAND
 */
#ifndef _NETSURF_UTILS_IDNA_PROPS_H_
#define _NETSURF_UTILS_IDNA_PROPS_H_

typedef enum idna_property {
	IDNA_P_PVALID		= 1,
	IDNA_P_CONTEXTJ		= 2,
	IDNA_P_CONTEXTO		= 3,
	IDNA_P_DISALLOWED	= 4,
	IDNA_P_UNASSIGNED	= 5
} idna_property;

typedef enum idna_unicode_jt {
	IDNA_UNICODE_JT_U	= 0,
	IDNA_UNICODE_JT_C	= 1,
	IDNA_UNICODE_JT_D	= 2,
	IDNA_UNICODE_JT_R	= 3,
	IDNA_UNICODE_JT_T	= 4,
	IDNA_UNICODE_JT_L	= 5
} idna_unicode_jt;


typedef struct idna_table {
	int32_t start;
	int32_t end;
	union p {
		idna_property property;
		idna_unicode_jt jt;
	} p;
} idna_table;

idna_table idna_derived[] = {
HEADER

open(CSVFILE, "idna-tables-5.2.0-properties.csv");
$line = <CSVFILE>; # discard header line

while($line = <CSVFILE>) {
	@items = split(/\,/, $line);
	@codepoints = split(/-/, $items[0]);
	if($#codepoints == 0) { $codepoints[1] = $codepoints[0]; }
	print "\t{ 0x" . $codepoints[0] . ", 0x" . $codepoints[1] . ", .p.property = IDNA_P_" . $items[1] . " },\n";
}

close(CSVFILE);

print <<HEADER;
	{ 0, 0, .p.property = 0}
};

idna_table idna_joiningtype[] = {
HEADER


open(TXTFILE, "DerivedJoiningType.txt");

while($line = <TXTFILE>) {
	chop($line);
	if(substr($line, 0, 1) eq '#') {next;}
	if(length($line) == 0) {next;}
	@items = split(/;/, $line);
	@codepoints = split(/\./, $items[0]);
	if($#codepoints == 0) { $codepoints[2] = $codepoints[0]; }
	print "\t{ 0x" . $codepoints[0] . ", 0x" . $codepoints[2] . ", .p.jt = IDNA_UNICODE_JT_" . substr($items[1], 1, 1) . " },\n";
}

close(TXTFILE);

print <<HEADER;
	{ 0, 0, .p.jt = 0}
};
#endif
HEADER


