/* $Id: Seq_annot.hpp 646877 2022-03-16 11:46:33Z grichenk $
 * ===========================================================================
 *
 *                            PUBLIC DOMAIN NOTICE
 *               National Center for Biotechnology Information
 *
 *  This software/database is a "United States Government Work" under the
 *  terms of the United States Copyright Act.  It was written as part of
 *  the author's official duties as a United States Government employee and
 *  thus cannot be copyrighted.  This software/database is freely available
 *  to the public for use. The National Library of Medicine and the U.S.
 *  Government have not placed any restriction on its use or reproduction.
 *
 *  Although all reasonable efforts have been taken to ensure the accuracy
 *  and reliability of the software and data, the NLM and the U.S.
 *  Government do not and cannot warrant the performance or results that
 *  may be obtained by using this software or data. The NLM and the U.S.
 *  Government disclaim all warranties, express or implied, including
 *  warranties of performance, merchantability or fitness for any particular
 *  purpose.
 *
 *  Please cite the author in any work or product based on this material.
 *
 * ===========================================================================
 *
 * Author:  .......
 *
 * File Description:
 *   .......
 *
 * Remark:
 *   This code was originally generated by application DATATOOL
 *   using specifications from the data definition file
 *   'seq.asn'.
 */

#ifndef OBJECTS_SEQ_SEQ_ANNOT_HPP
#define OBJECTS_SEQ_SEQ_ANNOT_HPP


// generated includes
#include <objects/seq/Seq_annot_.hpp>

// generated classes

BEGIN_NCBI_SCOPE

class CTime;


BEGIN_objects_SCOPE // namespace ncbi::objects::

class CUser_object;
class CDate;


class NCBI_SEQ_EXPORT CSeq_annot : public CSeq_annot_Base
{
    typedef CSeq_annot_Base Tparent;
public:
    // constructor
    CSeq_annot(void);
    // destructor
    ~CSeq_annot(void);

    // Removes any existing CAnnotdesc(s) of type name and adds
    // new CAnnotdesc of type name
    NCBI_DEPRECATED void AddName(const string &name);
    void SetNameDesc(const string &name);

    // Adds a CAnnotdesc of type title.  This will replace any previous
    // title fields.
    void SetTitleDesc(const string &title);
    NCBI_DEPRECATED void AddTitle(const string &title);
    
    // SetTitle() is deprecated; use AddTitle() instead
    // @deprecated
    NCBI_DEPRECATED void SetTitle(const string &title);

    // Adds a CAnnotdesc of type comment
    void AddComment(const string &comment);

    // Add/Set the create-date field
    void SetCreateDate(const CTime& dt);
    void SetCreateDate(CDate& dt);

    // Add/Set the create-date field
    void SetUpdateDate(const CTime& dt);
    void SetUpdateDate(CDate& dt);

    // add a user-object descriptor
    void AddUserObject(CUser_object& obj);

    // check annot type
    bool IsFtable(void) const;
    bool IsAlign(void) const;
    bool IsGraph(void) const;
    bool IsIds(void) const;
    bool IsLocs(void) const;
    bool IsSeq_table(void) const;

    /// Extract optional zoom level suffix from named annotation string.
    /// returns true if zoom level explicitly defined in the full_name argument.
    /// The accession string without zoom level will be written
    /// by acc_ptr pointer if it's not null.
    /// Zoom level will be written by zoom_level_ptr pointer if it's not null.
    /// Absent zoom level will be represented by value 0.
    /// Wildcard zoom level will be represented by value -1.
    static bool ExtractZoomLevel(const string& full_name,
                          string* acc_ptr, int* zoom_level_ptr);

    /// Combine accession string and zoom level into a string with separator.
    /// If the argument string already contains zoom level verify it's the same
    /// as the zoom_level argument.
    /// Zoom level value of -1 can be used to add wildcard @@*.
    static string CombineWithZoomLevel(const string& acc, int zoom_level);
    static void AddZoomLevel(string& acc, int zoom_level);

private:
    // Prohibit copy constructor and assignment operator
    CSeq_annot(const CSeq_annot& value);
    CSeq_annot& operator=(const CSeq_annot& value);

};


class NCBI_SEQ_EXPORT CSeqAnnotException : public CException
{
public:
    enum EErrCode {
        eZoom,     //< Bad zoom level
        eOther     //< Other errors
    };

    virtual const char* GetErrCodeString(void) const override;

    NCBI_EXCEPTION_DEFAULT(CSeqAnnotException, CException);
};


/// Named annotations zoom level can be encoded in the accession string
/// with @@ suffix, for example: NA000000001.1@@1000
/// zoom level is the number of bases covered by single value in a annotation
/// density graph.

#define NCBI_ANNOT_TRACK_ZOOM_LEVEL_SUFFIX "@@"


/////////////////// CSeq_annot inline methods

// constructor
inline
CSeq_annot::CSeq_annot(void)
{
}


/////////////////// end of CSeq_annot inline methods


END_objects_SCOPE // namespace ncbi::objects::

END_NCBI_SCOPE

#endif // OBJECTS_SEQ_SEQ_ANNOT_HPP
/* Original file checksum: lines: 93, chars: 2396, CRC32: bdd8950d */
