## -*- coding: utf-8 -*-
#
# «proprietary_codecs» - MCC Proprietary Codecs enablement plugin
#
# Copyright (C) 2009, Mario Limonciello, for Mythbuntu
#
#
# Mythbuntu is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2 of the License, or at your option)
# any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this application; if not, write to the Free Software Foundation, Inc., 51
# Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
##################################################################################

from MythbuntuControlCentre.plugin import MCCPlugin
import subprocess
import re
import os
import logging
from mythbuntu_common.dictionaries import *

class ProprietaryCodecsPlugin(MCCPlugin):
    """Proprietary Codec Enablement"""

    def __init__(self):
        #Initialize parent class
        information = {}
        information["name"] = "Proprietary Codecs"
        information["icon"] = "gtk-dialog-warning"
        information["ui"] = "tab_proprietary_codecs"
        MCCPlugin.__init__(self,information)

    def captureState(self):
        """Determines the state of the items on managed by this plugin
           and stores it into the plugin's own internal structures"""
        #Dictionaries
        self.dictionary_state={}
        list=get_nonfree_dictionary(self)
        for item in list:
            self.dictionary_state[list[item]]=self.query_installed(item)

    def applyStateToGUI(self):
        """Takes the current state information and sets the GUI
           for this plugin"""
        #Load the detected dictionary
        for item in self.dictionary_state:
            item.set_active(self.dictionary_state[item])

        self.proprietary_codecs.set_sensitive(True)

    def compareState(self):
        """Determines what items have been modified on this plugin"""
        #Prepare for state capturing
        MCCPlugin.clearParentState(self)

        #Installable items
        list=get_nonfree_dictionary(self)
        for item in list:
            if list[item].get_active() != self.dictionary_state[list[item]]:
                if list[item].get_active():
                    self._markReconfigureRoot("DVD Support",self.enable_libdvdcss2.get_active())
                else:
                    self._markRemove(item)


    def search(self,path, filename):
        for root, dirs, files in os.walk(path):
            if filename in files:
                rootpath = root
        return rootpath

    def root_scripted_changes(self,reconfigure):
        """System-wide changes that need root access to be applied.
           This function is ran by the dbus backend"""
        os.environ['PATH']='/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin'
        for item in reconfigure:
            if item == "DVD Support":
                csspath = self.search("/usr/share/doc/", "install-css.sh")
                run = subprocess.Popen([csspath+'/install-css.sh'])
                run.communicate()
